# This file is automatically generated.
# DO NOT MODIFY THIS FILE MANUALLY.

from __future__ import annotations

from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field


class CronEntryLine(BaseModel):
    start: Optional[int] = Field(None, title="Start")
    end: Optional[int] = Field(None, title="End")


class DeleteBodySlurmJobJobid(BaseModel):
    pass


class DeletePathSlurmJobJobid(BaseModel):
    job_id: str = Field(..., title="Job Id")


class DeleteQuerySlurmJobJobid(BaseModel):
    signal: Optional[str] = Field(None, title="POSIX signal name")


class Error(BaseModel):
    error_number: Optional[int] = Field(None, title="Slurm internal error number")
    error: Optional[str] = Field(None, title="Error message")
    source: Optional[str] = Field(None, title="Where error occurred in the source")
    description: Optional[str] = Field(None, title="Explanation of cause of error")


class Float64NoVal(BaseModel):
    set: Optional[bool] = Field(
        None, title="True if number has been set. False if number is unset"
    )
    infinite: Optional[bool] = Field(
        None,
        title='True if number has been set to infinite. "set" and "number" will be ignored.',
    )
    number: Optional[float] = Field(
        None,
        title="If set is True the number will be set with value. Otherwise ignore number contents.",
    )


class GetBodySlurmJobJobid(BaseModel):
    pass


class GetBodySlurmJobs(BaseModel):
    pass


class GetPathSlurmJobJobid(BaseModel):
    job_id: str = Field(..., title="Job Id")


class GetPathSlurmJobs(BaseModel):
    pass


class GetQuerySlurmJobJobid(BaseModel):
    pass


class GetQuerySlurmJobs(BaseModel):
    update_time: Optional[int] = Field(None, title="Update Time")


class JobInfoPower(BaseModel):
    flags: Optional[List[Dict[str, Any]]] = Field(None, title="Flags")


class JobRes(BaseModel):
    nodes: Optional[str] = Field(None, title="Nodes")
    allocated_cores: Optional[int] = Field(None, title="Allocated Cores")
    allocated_cpus: Optional[int] = Field(None, title="Allocated Cpus")
    allocated_hosts: Optional[int] = Field(None, title="Allocated Hosts")
    allocated_nodes: Optional[List[Dict[str, Any]]] = Field(
        None, title="Allocated Nodes"
    )


class MetaPlugin(BaseModel):
    type: Optional[str] = Field(None, title="Type")
    name: Optional[str] = Field(None, title="Name")


class MetaSlurmVersion(BaseModel):
    major: Optional[int] = Field(None, title="Major")
    micro: Optional[int] = Field(None, title="Micro")
    minor: Optional[int] = Field(None, title="Minor")


class PostPathSlurmJobSubmit(BaseModel):
    pass


class PostQuerySlurmJobSubmit(BaseModel):
    pass


class Uint16NoVal(BaseModel):
    set: Optional[bool] = Field(
        None, title="True if number has been set. False if number is unset"
    )
    infinite: Optional[bool] = Field(
        None,
        title='True if number has been set to infinite. "set" and "number" will be ignored.',
    )
    number: Optional[int] = Field(
        None,
        title="If set is True the number will be set with value. Otherwise ignore number contents.",
    )


class Uint32NoVal(BaseModel):
    set: Optional[bool] = Field(
        None, title="True if number has been set. False if number is unset"
    )
    infinite: Optional[bool] = Field(
        None,
        title='True if number has been set to infinite. "set" and "number" will be ignored.',
    )
    number: Optional[int] = Field(
        None,
        title="If set is True the number will be set with value. Otherwise ignore number contents.",
    )


class Uint64NoVal(BaseModel):
    set: Optional[bool] = Field(
        None, title="True if number has been set. False if number is unset"
    )
    infinite: Optional[bool] = Field(
        None,
        title='True if number has been set to infinite. "set" and "number" will be ignored.',
    )
    number: Optional[int] = Field(
        None,
        title="If set is True the number will be set with value. Otherwise ignore number contents.",
    )


class Warning(BaseModel):
    warning: Optional[str] = Field(None, title="Earning message")
    source: Optional[str] = Field(None, title="Where error occurred in the source")
    description: Optional[str] = Field(None, title="Explanation of cause of error")


class CronEntry(BaseModel):
    flags: Optional[List[str]] = Field(None, title="Flags")
    minute: Optional[str] = Field(None, title="Minute")
    hour: Optional[str] = Field(None, title="Hour")
    day_of_month: Optional[str] = Field(None, title="Day Of Month")
    month: Optional[str] = Field(None, title="Month")
    day_of_week: Optional[str] = Field(None, title="Day Of Week")
    specification: Optional[str] = Field(None, title="Specification")
    command: Optional[str] = Field(None, title="Command")
    line: Optional[CronEntryLine] = Field(None, title="Cron entry line")


class JobDescMsg(BaseModel):
    account: Optional[str] = Field(None, title="Account")
    account_gather_frequency: Optional[str] = Field(
        None, title="Account Gather Frequency"
    )
    admin_comment: Optional[str] = Field(None, title="Admin Comment")
    allocation_node_list: Optional[str] = Field(None, title="Allocation Node List")
    allocation_node_port: Optional[int] = Field(None, title="Allocation Node Port")
    argv: Optional[List[str]] = Field(None, title="Argv")
    array: Optional[str] = Field(None, title="Array")
    batch_features: Optional[str] = Field(None, title="Batch Features")
    begin_time: Optional[int] = Field(None, title="Begin Time")
    flags: Optional[List[str]] = Field(None, title="Flags")
    burst_buffer: Optional[str] = Field(None, title="Burst Buffer")
    clusters: Optional[str] = Field(None, title="Clusters")
    cluster_constraint: Optional[str] = Field(None, title="Cluster Constraint")
    comment: Optional[str] = Field(None, title="Comment")
    contiguous: Optional[bool] = Field(None, title="Contiguous")
    container: Optional[str] = Field(None, title="Container")
    container_id: Optional[str] = Field(None, title="Container Id")
    core_specification: Optional[int] = Field(None, title="Core Specification")
    thread_specification: Optional[int] = Field(None, title="Thread Specification")
    cpu_binding: Optional[str] = Field(None, title="Cpu Binding")
    cpu_binding_flags: Optional[List[str]] = Field(None, title="Cpu Binding Flags")
    cpu_frequency: Optional[str] = Field(None, title="Cpu Frequency")
    cpus_per_tres: Optional[str] = Field(None, title="Cpus Per Tres")
    crontab: Optional[CronEntry] = Field(None, title="Cron entry")
    deadline: Optional[int] = Field(None, title="Deadline")
    delay_boot: Optional[int] = Field(None, title="Delay Boot")
    dependency: Optional[str] = Field(None, title="Dependency")
    end_time: Optional[int] = Field(None, title="End Time")
    environment: List[str] = Field(..., title="Environment")
    excluded_nodes: Optional[List[str]] = Field(None, title="Excluded Nodes")
    extra: Optional[str] = Field(None, title="Extra")
    constraints: Optional[str] = Field(None, title="Constraints")
    group_id: Optional[str] = Field(None, title="Group Id")
    hetjob_group: Optional[int] = Field(None, title="Hetjob Group")
    immediate: Optional[bool] = Field(None, title="Immediate")
    job_id: Optional[int] = Field(None, title="Job Id")
    kill_on_node_fail: Optional[bool] = Field(None, title="Kill On Node Fail")
    licenses: Optional[str] = Field(None, title="Licenses")
    mail_type: Optional[List[str]] = Field(None, title="Mail Type")
    mail_user: Optional[str] = Field(None, title="Mail User")
    mcs_label: Optional[str] = Field(None, title="Mcs Label")
    memory_binding: Optional[str] = Field(None, title="Memory Binding")
    memory_binding_type: Optional[List[str]] = Field(None, title="Memory Binding Type")
    memory_per_tres: Optional[str] = Field(None, title="Memory Per Tres")
    name: Optional[str] = Field(None, title="Name")
    network: Optional[str] = Field(None, title="Network")
    nice: Optional[int] = Field(None, title="Nice")
    tasks: Optional[int] = Field(None, title="Tasks")
    open_mode: Optional[List[str]] = Field(None, title="Open Mode")
    reserve_ports: Optional[int] = Field(None, title="Reserve Ports")
    overcommit: Optional[bool] = Field(None, title="Overcommit")
    partition: Optional[str] = Field(None, title="Partition")
    distribution_plane_size: Optional[int] = Field(
        None, title="Distribution Plane Size"
    )
    power_flags: Optional[List[Dict[str, Any]]] = Field(None, title="Power Flags")
    prefer: Optional[str] = Field(None, title="Prefer")
    hold: Optional[bool] = Field(None, title="Hold (true) or release (false) job")
    priority: Optional[Uint32NoVal] = Field(None, title="Request specific job priority")
    profile: Optional[List[str]] = Field(None, title="Profile")
    qos: Optional[str] = Field(None, title="Qos")
    reboot: Optional[bool] = Field(None, title="Reboot")
    required_nodes: Optional[List[str]] = Field(None, title="Required Nodes")
    requeue: Optional[bool] = Field(None, title="Requeue")
    reservation: Optional[str] = Field(None, title="Reservation")
    script: Optional[str] = Field(None, title="Script")
    shared: Optional[List[str]] = Field(None, title="Shared")
    exclusive: Optional[List[str]] = Field(None, title="Exclusive")
    oversubscribe: Optional[bool] = Field(None, title="Oversubscribe")
    site_factor: Optional[int] = Field(None, title="Site Factor")
    spank_environment: Optional[List[str]] = Field(None, title="Spank Environment")
    distribution: Optional[str] = Field(None, title="Distribution")
    time_limit: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    time_minimum: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    tres_bind: Optional[str] = Field(None, title="Tres Bind")
    tres_freq: Optional[str] = Field(None, title="Tres Freq")
    tres_per_job: Optional[str] = Field(None, title="Tres Per Job")
    tres_per_node: Optional[str] = Field(None, title="Tres Per Node")
    tres_per_socket: Optional[str] = Field(None, title="Tres Per Socket")
    tres_per_task: Optional[str] = Field(None, title="Tres Per Task")
    user_id: Optional[str] = Field(None, title="User Id")
    wait_all_nodes: Optional[bool] = Field(None, title="Wait All Nodes")
    kill_warning_flags: Optional[List[str]] = Field(None, title="Kill Warning Flags")
    kill_warning_signal: Optional[str] = Field(None, title="Kill Warning Signal")
    kill_warning_delay: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    current_working_directory: Optional[str] = Field(
        None, title="Current Working Directory"
    )
    cpus_per_task: Optional[int] = Field(None, title="Cpus Per Task")
    minimum_cpus: Optional[int] = Field(None, title="Minimum Cpus")
    maximum_cpus: Optional[int] = Field(None, title="Maximum Cpus")
    nodes: Optional[str] = Field(None, title="Nodes")
    minimum_nodes: Optional[int] = Field(None, title="Minimum Nodes")
    maximum_nodes: Optional[int] = Field(None, title="Maximum Nodes")
    minimum_boards_per_node: Optional[int] = Field(
        None, title="Minimum Boards Per Node"
    )
    minimum_sockets_per_board: Optional[int] = Field(
        None, title="Minimum Sockets Per Board"
    )
    sockets_per_node: Optional[int] = Field(None, title="Sockets Per Node")
    threads_per_core: Optional[int] = Field(None, title="Threads Per Core")
    tasks_per_node: Optional[int] = Field(None, title="Tasks Per Node")
    tasks_per_socket: Optional[int] = Field(None, title="Tasks Per Socket")
    tasks_per_core: Optional[int] = Field(None, title="Tasks Per Core")
    tasks_per_board: Optional[int] = Field(None, title="Tasks Per Board")
    ntasks_per_tres: Optional[int] = Field(None, title="Ntasks Per Tres")
    minimum_cpus_per_node: Optional[int] = Field(None, title="Minimum Cpus Per Node")
    memory_per_cpu: Optional[Uint64NoVal] = Field(
        None, title="Integer number with flags"
    )
    memory_per_node: Optional[Uint64NoVal] = Field(
        None, title="Integer number with flags"
    )
    temporary_disk_per_node: Optional[int] = Field(
        None, title="Temporary Disk Per Node"
    )
    selinux_context: Optional[str] = Field(None, title="Selinux Context")
    required_switches: Optional[Uint32NoVal] = Field(
        None, title="Integer number with flags"
    )
    standard_error: Optional[str] = Field(None, title="Standard Error")
    standard_input: Optional[str] = Field(None, title="Standard Input")
    standard_output: Optional[str] = Field(None, title="Standard Output")
    wait_for_switch: Optional[int] = Field(None, title="Wait For Switch")
    wckey: Optional[str] = Field(None, title="Wckey")
    x11: Optional[List[str]] = Field(None, title="X11")
    x11_magic_cookie: Optional[str] = Field(None, title="X11 Magic Cookie")
    x11_target_host: Optional[str] = Field(None, title="X11 Target Host")
    x11_target_port: Optional[int] = Field(None, title="X11 Target Port")


class JobInfo(BaseModel):
    account: Optional[str] = Field(None, title="Account")
    accrue_time: Optional[int] = Field(None, title="Accrue Time")
    admin_comment: Optional[str] = Field(None, title="Admin Comment")
    allocating_node: Optional[str] = Field(None, title="Allocating Node")
    array_job_id: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    array_task_id: Optional[Uint32NoVal] = Field(
        None, title="Integer number with flags"
    )
    array_max_tasks: Optional[Uint32NoVal] = Field(
        None, title="Integer number with flags"
    )
    array_task_string: Optional[str] = Field(None, title="Array Task String")
    association_id: Optional[int] = Field(None, title="Association Id")
    batch_features: Optional[str] = Field(None, title="Batch Features")
    batch_flag: Optional[bool] = Field(None, title="Batch Flag")
    batch_host: Optional[str] = Field(None, title="Batch Host")
    flags: Optional[List[str]] = Field(None, title="Flags")
    burst_buffer: Optional[str] = Field(None, title="Burst Buffer")
    burst_buffer_state: Optional[str] = Field(None, title="Burst Buffer State")
    cluster: Optional[str] = Field(None, title="Cluster")
    cluster_features: Optional[str] = Field(None, title="Cluster Features")
    command: Optional[str] = Field(None, title="Command")
    comment: Optional[str] = Field(None, title="Comment")
    container: Optional[str] = Field(None, title="Container")
    container_id: Optional[str] = Field(None, title="Container Id")
    contiguous: Optional[bool] = Field(None, title="Contiguous")
    core_spec: Optional[int] = Field(None, title="Core Spec")
    thread_spec: Optional[int] = Field(None, title="Thread Spec")
    cores_per_socket: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    billable_tres: Optional[Float64NoVal] = Field(
        None, title="64 bit floating point number with flags"
    )
    cpus_per_task: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    cpu_frequency_minimum: Optional[Uint32NoVal] = Field(
        None, title="Integer number with flags"
    )
    cpu_frequency_maximum: Optional[Uint32NoVal] = Field(
        None, title="Integer number with flags"
    )
    cpu_frequency_governor: Optional[Uint32NoVal] = Field(
        None, title="Integer number with flags"
    )
    cpus_per_tres: Optional[str] = Field(None, title="Cpus Per Tres")
    cron: Optional[str] = Field(None, title="Cron")
    deadline: Optional[int] = Field(None, title="Deadline")
    delay_boot: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    dependency: Optional[str] = Field(None, title="Dependency")
    derived_exit_code: Optional[Uint32NoVal] = Field(
        None, title="Integer number with flags"
    )
    eligible_time: Optional[int] = Field(None, title="Eligible Time")
    end_time: Optional[int] = Field(None, title="End Time")
    excluded_nodes: Optional[str] = Field(None, title="Excluded Nodes")
    exit_code: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    extra: Optional[str] = Field(None, title="Extra")
    failed_node: Optional[str] = Field(None, title="Failed Node")
    features: Optional[str] = Field(None, title="Features")
    federation_origin: Optional[str] = Field(None, title="Federation Origin")
    federation_siblings_active: Optional[str] = Field(
        None, title="Federation Siblings Active"
    )
    federation_siblings_viable: Optional[str] = Field(
        None, title="Federation Siblings Viable"
    )
    gres_detail: Optional[List[str]] = Field(None, title="Gres Detail")
    group_id: Optional[int] = Field(None, title="Group Id")
    group_name: Optional[str] = Field(None, title="Group Name")
    het_job_id: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    het_job_id_set: Optional[str] = Field(None, title="Het Job Id Set")
    het_job_offset: Optional[Uint32NoVal] = Field(
        None, title="Integer number with flags"
    )
    job_id: Optional[int] = Field(None, title="Job Id")
    job_resources: Optional[JobRes] = Field(None, title="Job res")
    job_size_str: Optional[List[str]] = Field(None, title="Job Size Str")
    job_state: Optional[str] = Field(None, title="Job State")
    last_sched_evaluation: Optional[int] = Field(None, title="Last Sched Evaluation")
    licenses: Optional[str] = Field(None, title="Licenses")
    mail_type: Optional[List[str]] = Field(None, title="Mail Type")
    mail_user: Optional[str] = Field(None, title="Mail User")
    max_cpus: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    max_nodes: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    mcs_label: Optional[str] = Field(None, title="Mcs Label")
    memory_per_tres: Optional[str] = Field(None, title="Memory Per Tres")
    name: Optional[str] = Field(None, title="Name")
    network: Optional[str] = Field(None, title="Network")
    nodes: Optional[str] = Field(None, title="Nodes")
    nice: Optional[int] = Field(None, title="Nice")
    tasks_per_core: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    tasks_per_tres: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    tasks_per_node: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    tasks_per_socket: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    tasks_per_board: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    cpus: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    node_count: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    tasks: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    partition: Optional[str] = Field(None, title="Partition")
    prefer: Optional[str] = Field(None, title="Prefer")
    memory_per_cpu: Optional[Uint64NoVal] = Field(
        None, title="Integer number with flags"
    )
    memory_per_node: Optional[Uint64NoVal] = Field(
        None, title="Integer number with flags"
    )
    minimum_cpus_per_node: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    minimum_tmp_disk_per_node: Optional[Uint32NoVal] = Field(
        None, title="Integer number with flags"
    )
    power: Optional[JobInfoPower] = Field(None, title="Job info power")
    preempt_time: Optional[int] = Field(None, title="Preempt Time")
    preemptable_time: Optional[int] = Field(None, title="Preemptable Time")
    pre_sus_time: Optional[int] = Field(None, title="Pre Sus Time")
    hold: Optional[bool] = Field(None, title="Hold (true) or release (false) job")
    priority: Optional[Uint32NoVal] = Field(None, title="Request specific job priority")
    profile: Optional[List[str]] = Field(None, title="Profile")
    qos: Optional[str] = Field(None, title="Qos")
    reboot: Optional[bool] = Field(None, title="Reboot")
    required_nodes: Optional[str] = Field(None, title="Required Nodes")
    minimum_switches: Optional[int] = Field(None, title="Minimum Switches")
    requeue: Optional[bool] = Field(None, title="Requeue")
    resize_time: Optional[int] = Field(None, title="Resize Time")
    restart_cnt: Optional[int] = Field(None, title="Restart Cnt")
    resv_name: Optional[str] = Field(None, title="Resv Name")
    scheduled_nodes: Optional[str] = Field(None, title="Scheduled Nodes")
    selinux_context: Optional[str] = Field(None, title="Selinux Context")
    shared: Optional[List[str]] = Field(None, title="Shared")
    exclusive: Optional[List[str]] = Field(None, title="Exclusive")
    oversubscribe: Optional[bool] = Field(None, title="Oversubscribe")
    show_flags: Optional[List[str]] = Field(None, title="Show Flags")
    sockets_per_board: Optional[int] = Field(None, title="Sockets Per Board")
    sockets_per_node: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    start_time: Optional[int] = Field(None, title="Start Time")
    state_description: Optional[str] = Field(None, title="State Description")
    state_reason: Optional[str] = Field(None, title="State Reason")
    standard_error: Optional[str] = Field(None, title="Standard Error")
    standard_input: Optional[str] = Field(None, title="Standard Input")
    standard_output: Optional[str] = Field(None, title="Standard Output")
    submit_time: Optional[int] = Field(None, title="Submit Time")
    suspend_time: Optional[int] = Field(None, title="Suspend Time")
    system_comment: Optional[str] = Field(None, title="System Comment")
    time_limit: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    time_minimum: Optional[Uint32NoVal] = Field(None, title="Integer number with flags")
    threads_per_core: Optional[Uint16NoVal] = Field(
        None, title="Integer number with flags"
    )
    tres_bind: Optional[str] = Field(None, title="Tres Bind")
    tres_freq: Optional[str] = Field(None, title="Tres Freq")
    tres_per_job: Optional[str] = Field(None, title="Tres Per Job")
    tres_per_node: Optional[str] = Field(None, title="Tres Per Node")
    tres_per_socket: Optional[str] = Field(None, title="Tres Per Socket")
    tres_per_task: Optional[str] = Field(None, title="Tres Per Task")
    tres_req_str: Optional[str] = Field(None, title="Tres Req Str")
    tres_alloc_str: Optional[str] = Field(None, title="Tres Alloc Str")
    user_id: Optional[int] = Field(None, title="User Id")
    user_name: Optional[str] = Field(None, title="User Name")
    maximum_switch_wait_time: Optional[int] = Field(
        None, title="Maximum Switch Wait Time"
    )
    wckey: Optional[str] = Field(None, title="Wckey")
    current_working_directory: Optional[str] = Field(
        None, title="Current Working Directory"
    )


class JobSubmission(BaseModel):
    script: Optional[str] = Field(
        None,
        title="Executable script (full contents) to run in batch step for all job components",
    )
    job: Optional[JobDescMsg] = Field(None, title="Job desc msg")
    jobs: Optional[List[JobDescMsg]] = Field(None, title="List of job desc msg")


class MetaSlurm(BaseModel):
    version: Optional[MetaSlurmVersion] = Field(None, title="Meta slurm version")
    release: Optional[str] = Field(None, title="version specifier")


class PostBodySlurmJobSubmit(BaseModel):
    content: Optional[JobSubmission] = Field(None, title="Job submission")


class Meta(BaseModel):
    plugin: Optional[MetaPlugin] = Field(None, title="Meta plugin")
    Slurm: Optional[MetaSlurm] = Field(None, title="Slurm information")


class Status(BaseModel):
    meta: Optional[Meta] = None
    errors: Optional[List[Error]] = Field(None, title="List of error")
    warnings: Optional[List[Warning]] = Field(None, title="List of warning")


class DeleteResponse200SlurmJobJobid(BaseModel):
    content: Status


class DeleteResponseDefaultSlurmJobJobid(BaseModel):
    content: Status


class GetResponseDefaultSlurmJobJobid(BaseModel):
    content: Status


class GetResponseDefaultSlurmJobs(BaseModel):
    content: Status


class JobSubmissionResponse(BaseModel):
    meta: Optional[Meta] = None
    errors: Optional[List[Error]] = Field(None, title="List of error")
    warnings: Optional[List[Warning]] = Field(None, title="List of warning")
    job_id: Optional[int] = Field(None, title="new job ID")
    step_id: Optional[str] = Field(None, title="new job step ID")
    job_submit_user_msg: Optional[str] = Field(
        None, title="Message to user from job_submit plugin"
    )


class JobsResponse(BaseModel):
    meta: Optional[Meta] = None
    errors: Optional[List[Error]] = Field(None, title="List of error")
    warnings: Optional[List[Warning]] = Field(None, title="List of warning")
    jobs: Optional[List[JobInfo]] = Field(None, title="List of job info")


class PostResponse200SlurmJobSubmit(BaseModel):
    content: JobSubmissionResponse = Field(..., title="Job submission response")


class PostResponseDefaultSlurmJobSubmit(BaseModel):
    content: Status


class GetResponse200SlurmJobJobid(BaseModel):
    content: JobsResponse = Field(..., title="Jobs response")


class GetResponse200SlurmJobs(BaseModel):
    content: JobsResponse = Field(..., title="Jobs response")


class AllModels(BaseModel):
    model0: PostPathSlurmJobSubmit = Field(
        ..., title="POST /slurm/v0.0.39/job/submit: path parameters"
    )
    model1: PostQuerySlurmJobSubmit = Field(
        ..., title="POST /slurm/v0.0.39/job/submit: query parameters"
    )
    model2: CronEntryLine = Field(..., title="Cron entry line")
    model3: CronEntry = Field(..., title="Cron entry")
    model4: Uint32NoVal = Field(..., title="Integer number with flags")
    model5: Uint16NoVal = Field(..., title="Integer number with flags")
    model6: Uint64NoVal = Field(..., title="Integer number with flags")
    model7: JobDescMsg = Field(..., title="Job desc msg")
    model8: JobSubmission = Field(..., title="Job submission")
    model9: PostBodySlurmJobSubmit = Field(..., title="submit new job")
    model10: MetaPlugin = Field(..., title="Meta plugin")
    model11: MetaSlurmVersion = Field(..., title="Meta slurm version")
    model12: MetaSlurm = Field(..., title="Slurm information")
    model13: Meta
    model14: Error
    model15: Warning
    model16: JobSubmissionResponse = Field(..., title="Job submission response")
    model17: PostResponse200SlurmJobSubmit = Field(..., title="job submitted")
    model18: Status
    model19: PostResponseDefaultSlurmJobSubmit = Field(..., title="job rejected")
    model20: GetPathSlurmJobJobid = Field(
        ..., title="GET /slurm/v0.0.39/job/{job_id}: path parameters"
    )
    model21: GetQuerySlurmJobJobid = Field(
        ..., title="GET /slurm/v0.0.39/job/{job_id}: query parameters"
    )
    model22: GetBodySlurmJobJobid = Field(
        ..., title="GET /slurm/v0.0.39/job/{job_id}: body"
    )
    model23: Float64NoVal = Field(..., title="64 bit floating point number with flags")
    model24: JobRes = Field(..., title="Job res")
    model25: JobInfoPower = Field(..., title="Job info power")
    model26: JobInfo = Field(..., title="Job info")
    model27: JobsResponse = Field(..., title="Jobs response")
    model28: GetResponse200SlurmJobJobid = Field(..., title="job(s) information")
    model29: GetResponseDefaultSlurmJobJobid = Field(
        ..., title="job matching JobId not found"
    )
    model30: DeletePathSlurmJobJobid = Field(
        ..., title="DELETE /slurm/v0.0.39/job/{job_id}: path parameters"
    )
    model31: DeleteQuerySlurmJobJobid = Field(
        ..., title="DELETE /slurm/v0.0.39/job/{job_id}: query parameters"
    )
    model32: DeleteBodySlurmJobJobid = Field(
        ..., title="DELETE /slurm/v0.0.39/job/{job_id}: body"
    )
    model33: DeleteResponse200SlurmJobJobid = Field(
        ..., title="job cancelled or sent signal"
    )
    model34: DeleteResponseDefaultSlurmJobJobid = Field(
        ..., title="Job cancel request failed"
    )
    model35: GetPathSlurmJobs = Field(
        ..., title="GET /slurm/v0.0.39/jobs: path parameters"
    )
    model36: GetQuerySlurmJobs = Field(
        ..., title="GET /slurm/v0.0.39/jobs: query parameters"
    )
    model37: GetBodySlurmJobs = Field(..., title="GET /slurm/v0.0.39/jobs: body")
    model38: GetResponse200SlurmJobs = Field(..., title="job(s) information")
    model39: GetResponseDefaultSlurmJobs = Field(..., title="job not found")
