# This file is automatically generated.
# DO NOT MODIFY THIS FILE MANUALLY.

from __future__ import annotations

from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field


class CronEntryLine(BaseModel):
    start: Optional[int] = Field(None, title="Start of this entry in file")
    end: Optional[int] = Field(None, title="End of this entry in file")


class DeleteBodySlurmJobJobid(BaseModel):
    pass


class DeletePathSlurmJobJobid(BaseModel):
    job_id: str = Field(..., title="Job Id")


class DeleteQuerySlurmJobJobid(BaseModel):
    signal: Optional[str] = Field(None, title="Signal")


class Float64NoVal(BaseModel):
    set: Optional[bool] = Field(
        None, title="True if number has been set. False if number is unset"
    )
    infinite: Optional[bool] = Field(
        None,
        title='True if number has been set to infinite. "set" and "number" will be ignored.',
    )
    number: Optional[float] = Field(
        None,
        title="If set is True the number will be set with value. Otherwise ignore number contents.",
    )


class GetBodySlurmJobJobid(BaseModel):
    pass


class GetBodySlurmJobs(BaseModel):
    pass


class GetPathSlurmJobJobid(BaseModel):
    job_id: str = Field(..., title="Job Id")


class GetPathSlurmJobs(BaseModel):
    pass


class GetQuerySlurmJobJobid(BaseModel):
    update_time: Optional[str] = Field(None, title="Update Time")


class GetQuerySlurmJobs(BaseModel):
    update_time: Optional[str] = Field(None, title="Update Time")


class JobInfoPower(BaseModel):
    flags: Optional[List[Dict[str, Any]]] = Field(None, title="Flags")


class JobRes(BaseModel):
    nodes: Optional[str] = Field(None, title="Node(s) allocated to the job")
    allocated_cores: Optional[int] = Field(None, title="Number of allocated cores")
    allocated_cpus: Optional[int] = Field(None, title="Number of allocated CPUs")
    allocated_hosts: Optional[int] = Field(None, title="Number of allocated hosts")
    allocated_nodes: Optional[List[Dict[str, Any]]] = Field(
        None, title="Allocated node resources"
    )


class JobSubmitResponseMsg(BaseModel):
    job_id: Optional[int] = Field(None, title="New job ID")
    step_id: Optional[str] = Field(None, title="New job step ID")
    error_code: Optional[int] = Field(None, title="Error code")
    error: Optional[str] = Field(None, title="Error message")
    job_submit_user_msg: Optional[str] = Field(
        None, title="Message to user from job_submit plugin"
    )


class OpenapiError(BaseModel):
    description: Optional[str] = Field(None, title="Long form error description")
    error_number: Optional[int] = Field(None, title="Slurm numeric error identifier")
    error: Optional[str] = Field(None, title="Short form error description")
    source: Optional[str] = Field(
        None, title="Source of error or where error was first detected"
    )


class OpenapiMetaClient(BaseModel):
    source: Optional[str] = Field(None, title="Client source description")
    user: Optional[str] = Field(None, title="Client user (if known)")
    group: Optional[str] = Field(None, title="Client group (if known)")


class OpenapiMetaPlugin(BaseModel):
    type: Optional[str] = Field(None, title="Slurm plugin type (if applicable)")
    name: Optional[str] = Field(None, title="Slurm plugin name (if applicable)")
    data_parser: Optional[str] = Field(None, title="Slurm data_parser plugin")
    accounting_storage: Optional[str] = Field(None, title="Slurm accounting plugin")


class OpenapiMetaSlurmVersion(BaseModel):
    major: Optional[str] = Field(None, title="Slurm release major version")
    micro: Optional[str] = Field(None, title="Slurm release micro version")
    minor: Optional[str] = Field(None, title="Slurm release minor version")


class OpenapiWarning(BaseModel):
    description: Optional[str] = Field(None, title="Long form warning description")
    source: Optional[str] = Field(
        None, title="Source of warning or where warning was first detected"
    )


class PostPathSlurmJobSubmit(BaseModel):
    pass


class PostQuerySlurmJobSubmit(BaseModel):
    pass


class Uint16NoVal(BaseModel):
    set: Optional[bool] = Field(
        None, title="True if number has been set. False if number is unset"
    )
    infinite: Optional[bool] = Field(
        None,
        title='True if number has been set to infinite. "set" and "number" will be ignored.',
    )
    number: Optional[int] = Field(
        None,
        title="If set is True the number will be set with value. Otherwise ignore number contents.",
    )


class Uint32NoVal(BaseModel):
    set: Optional[bool] = Field(
        None, title="True if number has been set. False if number is unset"
    )
    infinite: Optional[bool] = Field(
        None,
        title='True if number has been set to infinite. "set" and "number" will be ignored.',
    )
    number: Optional[int] = Field(
        None,
        title="If set is True the number will be set with value. Otherwise ignore number contents.",
    )


class Uint64NoVal(BaseModel):
    set: Optional[bool] = Field(
        None, title="True if number has been set. False if number is unset"
    )
    infinite: Optional[bool] = Field(
        None,
        title='True if number has been set to infinite. "set" and "number" will be ignored.',
    )
    number: Optional[int] = Field(
        None,
        title="If set is True the number will be set with value. Otherwise ignore number contents.",
    )


class CronEntry(BaseModel):
    flags: Optional[List[str]] = Field(None, title="Flags")
    minute: Optional[str] = Field(
        None, title="Ranged string specifying eligible minute values (e.g. 0-10,50)"
    )
    hour: Optional[str] = Field(
        None, title="Ranged string specifying eligible hour values (e.g. 0-5,23)"
    )
    day_of_month: Optional[str] = Field(
        None,
        title="Ranged string specifying eligible day of month values (e.g. 0-10,29)",
    )
    month: Optional[str] = Field(
        None, title="Ranged string specifying eligible month values (e.g. 0-5,12)"
    )
    day_of_week: Optional[str] = Field(
        None, title="Ranged string specifying eligible day of week values (e.g.0-3,7)"
    )
    specification: Optional[str] = Field(
        None,
        title="Time specification (* means valid for all allowed values) - minute hour day_of_month month day_of_week",
    )
    command: Optional[str] = Field(None, title="Command to run")
    line: Optional[CronEntryLine] = Field(None, title="Cron entry line")


class JobDescMsgRlimits(BaseModel):
    cpu: Optional[Uint64NoVal] = Field(None, title="Per-process CPU limit, in seconds.")
    fsize: Optional[Uint64NoVal] = Field(
        None, title="Largest file that can be created, in bytes."
    )
    data: Optional[Uint64NoVal] = Field(
        None, title="Maximum size of data segment, in bytes. "
    )
    stack: Optional[Uint64NoVal] = Field(
        None, title="Maximum size of stack segment, in bytes."
    )
    core: Optional[Uint64NoVal] = Field(
        None, title="Largest core file that can be created, in bytes."
    )
    rss: Optional[Uint64NoVal] = Field(
        None,
        title="Largest resident set size, in bytes. This affects swapping; processes that are exceeding their resident set size will be more likely to have physical memory taken from them.",
    )
    nproc: Optional[Uint64NoVal] = Field(None, title="Number of processes.")
    nofile: Optional[Uint64NoVal] = Field(None, title="Number of open files.")
    memlock: Optional[Uint64NoVal] = Field(None, title="Locked-in-memory address space")
    as_: Optional[Uint64NoVal] = Field(None, alias="as", title="Address space limit.")


class OpenapiMetaSlurm(BaseModel):
    version: Optional[OpenapiMetaSlurmVersion] = Field(
        None, title="Openapi meta slurm version"
    )
    release: Optional[str] = Field(None, title="Slurm release string")
    cluster: Optional[str] = Field(None, title="Slurm cluster name")


class ProcessExitCodeVerboseSignal(BaseModel):
    id: Optional[Uint16NoVal] = Field(None, title="Signal sent to process (numeric)")
    name: Optional[str] = Field(None, title="Signal sent to process")


class JobDescMsg(BaseModel):
    account: Optional[str] = Field(None, title="Account associated with the job")
    account_gather_frequency: Optional[str] = Field(
        None, title="Job accounting and profiling sampling intervals in seconds"
    )
    admin_comment: Optional[str] = Field(
        None, title="Arbitrary comment made by administrator"
    )
    allocation_node_list: Optional[str] = Field(
        None, title="Local node making the resource allocation"
    )
    allocation_node_port: Optional[int] = Field(
        None, title="Port to send allocation confirmation to"
    )
    argv: Optional[List[str]] = Field(None, title="Arguments to the script")
    array: Optional[str] = Field(None, title="Job array index value specification")
    batch_features: Optional[str] = Field(
        None, title="Features required for batch script's node"
    )
    begin_time: Optional[Uint64NoVal] = Field(
        None,
        title="Defer the allocation of the job until the specified time (UNIX timestamp)",
    )
    flags: Optional[List[str]] = Field(None, title="Job flags")
    burst_buffer: Optional[str] = Field(None, title="Burst buffer specifications")
    clusters: Optional[str] = Field(
        None, title="Clusters that a federated job can run on"
    )
    cluster_constraint: Optional[str] = Field(
        None,
        title="Required features that a federated cluster must have to have a sibling job submitted to it",
    )
    comment: Optional[str] = Field(None, title="Arbitrary comment made by user")
    contiguous: Optional[bool] = Field(
        None, title="True if job requires contiguous nodes"
    )
    container: Optional[str] = Field(
        None, title="Absolute path to OCI container bundle"
    )
    container_id: Optional[str] = Field(None, title="OCI container ID")
    cores_per_socket: Optional[int] = Field(None, title="Cores per socket required")
    core_specification: Optional[int] = Field(None, title="Specialized core count")
    thread_specification: Optional[int] = Field(None, title="Specialized thread count")
    cpu_binding: Optional[str] = Field(
        None, title="Method for binding tasks to allocated CPUs"
    )
    cpu_binding_flags: Optional[List[str]] = Field(None, title="Flags for CPU binding")
    cpu_frequency: Optional[str] = Field(
        None, title="Requested CPU frequency range <p1>[-p2][:p3]"
    )
    cpus_per_tres: Optional[str] = Field(
        None,
        title="Semicolon delimited list of TRES=# values values indicating how many CPUs should be allocated for each specified TRES (currently only used for gres/gpu)",
    )
    crontab: Optional[CronEntry] = Field(None, title="crontab entry")
    deadline: Optional[int] = Field(
        None, title="Latest time that the job may start (UNIX timestamp)"
    )
    delay_boot: Optional[int] = Field(
        None,
        title="Number of seconds after job eligible start that nodes will be rebooted to satisfy feature specification",
    )
    dependency: Optional[str] = Field(
        None,
        title="Other jobs that must meet certain criteria before this job can start",
    )
    end_time: Optional[int] = Field(None, title="Expected end time (UNIX timestamp)")
    environment: Optional[List[str]] = Field(
        None, title="Environment variables to be set for the job"
    )
    rlimits: Optional[JobDescMsgRlimits] = Field(None, title="Job desc msg rlimits")
    excluded_nodes: Optional[List[str]] = Field(
        None, title="Comma separated list of nodes that may not be used"
    )
    extra: Optional[str] = Field(
        None,
        title="Arbitrary string used for node filtering if extra constraints are enabled",
    )
    constraints: Optional[str] = Field(
        None, title="Comma separated list of features that are required"
    )
    group_id: Optional[str] = Field(
        None, title="Group ID of the user that owns the job"
    )
    hetjob_group: Optional[int] = Field(
        None,
        title="Unique sequence number applied to this component of the heterogeneous job",
    )
    immediate: Optional[bool] = Field(
        None,
        title="If true, exit if resources are not available within the time period specified",
    )
    job_id: Optional[int] = Field(None, title="Job ID")
    kill_on_node_fail: Optional[bool] = Field(
        None, title="If true, kill job on node failure"
    )
    licenses: Optional[str] = Field(None, title="License(s) required by the job")
    mail_type: Optional[List[str]] = Field(None, title="Mail event type(s)")
    mail_user: Optional[str] = Field(None, title="User to receive email notifications")
    mcs_label: Optional[str] = Field(
        None, title="Multi-Category Security label on the job"
    )
    memory_binding: Optional[str] = Field(None, title="Binding map for map/mask_cpu")
    memory_binding_type: Optional[List[str]] = Field(
        None, title="Method for binding tasks to memory"
    )
    memory_per_tres: Optional[str] = Field(
        None,
        title="Semicolon delimited list of TRES=# values indicating how much memory in megabytes should be allocated for each specified TRES (currently only used for gres/gpu)",
    )
    name: Optional[str] = Field(None, title="Job name")
    network: Optional[str] = Field(None, title="Network specs for job step")
    nice: Optional[int] = Field(None, title="Requested job priority change")
    tasks: Optional[int] = Field(None, title="Number of tasks")
    open_mode: Optional[List[str]] = Field(
        None, title="Open mode used for stdout and stderr files"
    )
    reserve_ports: Optional[int] = Field(
        None, title="Port to send various notification msg to"
    )
    overcommit: Optional[bool] = Field(None, title="Overcommit resources")
    partition: Optional[str] = Field(None, title="Partition assigned to the job")
    distribution_plane_size: Optional[int] = Field(
        None, title="Plane size specification when distribution specifies plane"
    )
    power_flags: Optional[List[Dict[str, Any]]] = Field(None, title="Power Flags")
    prefer: Optional[str] = Field(
        None,
        title="Comma separated list of features that are preferred but not required",
    )
    hold: Optional[bool] = Field(None, title="Job held")
    priority: Optional[Uint32NoVal] = Field(None, title="Request specific job priority")
    profile: Optional[List[str]] = Field(
        None, title="Profile used by the acct_gather_profile plugin"
    )
    qos: Optional[str] = Field(None, title="Quality of Service assigned to the job")
    reboot: Optional[bool] = Field(None, title="Node reboot requested before start")
    required_nodes: Optional[List[str]] = Field(
        None, title="Comma separated list of required nodes"
    )
    requeue: Optional[bool] = Field(
        None, title="Determines whether the job may be requeued"
    )
    reservation: Optional[str] = Field(None, title="Name of reservation to use")
    script: Optional[str] = Field(
        None,
        title="Job batch script; only the first component in a HetJob is populated or honored",
    )
    shared: Optional[List[str]] = Field(
        None, title="How the job can share resources with other jobs, if at all"
    )
    exclusive: Optional[List[str]] = Field(None, title="Exclusive")
    oversubscribe: Optional[bool] = Field(None, title="Oversubscribe")
    site_factor: Optional[int] = Field(None, title="Site-specific priority factor")
    spank_environment: Optional[List[str]] = Field(
        None,
        title="Environment variables for job prolog/epilog scripts as set by SPANK plugins",
    )
    distribution: Optional[str] = Field(None, title="Layout")
    time_limit: Optional[Uint32NoVal] = Field(None, title="Maximum run time in minutes")
    time_minimum: Optional[Uint32NoVal] = Field(
        None, title="Minimum run time in minutes"
    )
    tres_bind: Optional[str] = Field(None, title="Task to TRES binding directives")
    tres_freq: Optional[str] = Field(None, title="TRES frequency directives")
    tres_per_job: Optional[str] = Field(
        None,
        title="Comma separated list of TRES=# values to be allocated for every job",
    )
    tres_per_node: Optional[str] = Field(
        None,
        title="Comma separated list of TRES=# values to be allocated for every node",
    )
    tres_per_socket: Optional[str] = Field(
        None,
        title="Comma separated list of TRES=# values to be allocated for every socket",
    )
    tres_per_task: Optional[str] = Field(
        None,
        title="Comma separated list of TRES=# values to be allocated for every task",
    )
    user_id: Optional[str] = Field(None, title="User ID that owns the job")
    wait_all_nodes: Optional[bool] = Field(
        None, title="If true, wait to start until after all nodes have booted"
    )
    kill_warning_flags: Optional[List[str]] = Field(
        None, title="Flags related to job signals"
    )
    kill_warning_signal: Optional[str] = Field(
        None, title='Signal to send when approaching end time (e.g. "10" or "USR1")'
    )
    kill_warning_delay: Optional[Uint16NoVal] = Field(
        None, title="Number of seconds before end time to send the warning signal"
    )
    current_working_directory: Optional[str] = Field(
        None, title="Working directory to use for the job"
    )
    cpus_per_task: Optional[int] = Field(
        None, title="Number of CPUs required by each task"
    )
    minimum_cpus: Optional[int] = Field(None, title="Minimum number of CPUs required")
    maximum_cpus: Optional[int] = Field(None, title="Maximum number of CPUs required")
    nodes: Optional[str] = Field(
        None, title="Node count range specification (e.g. 1-15:4)"
    )
    minimum_nodes: Optional[int] = Field(None, title="Minimum node count")
    maximum_nodes: Optional[int] = Field(None, title="Maximum node count")
    minimum_boards_per_node: Optional[int] = Field(
        None, title="Boards per node required"
    )
    minimum_sockets_per_board: Optional[int] = Field(
        None, title="Sockets per board required"
    )
    sockets_per_node: Optional[int] = Field(None, title="Sockets per node required")
    threads_per_core: Optional[int] = Field(None, title="Threads per core required")
    tasks_per_node: Optional[int] = Field(
        None, title="Number of tasks to invoke on each node"
    )
    tasks_per_socket: Optional[int] = Field(
        None, title="Number of tasks to invoke on each socket"
    )
    tasks_per_core: Optional[int] = Field(
        None, title="Number of tasks to invoke on each core"
    )
    tasks_per_board: Optional[int] = Field(
        None, title="Number of tasks to invoke on each board"
    )
    ntasks_per_tres: Optional[int] = Field(
        None, title="Number of tasks that can access each GPU"
    )
    minimum_cpus_per_node: Optional[int] = Field(
        None, title="Minimum number of CPUs per node"
    )
    memory_per_cpu: Optional[Uint64NoVal] = Field(
        None, title="Minimum memory in megabytes per allocated CPU"
    )
    memory_per_node: Optional[Uint64NoVal] = Field(
        None, title="Minimum memory in megabytes per allocated node"
    )
    temporary_disk_per_node: Optional[int] = Field(
        None, title="Minimum tmp disk space required per node"
    )
    selinux_context: Optional[str] = Field(None, title="SELinux context")
    required_switches: Optional[Uint32NoVal] = Field(
        None, title="Maximum number of switches"
    )
    standard_error: Optional[str] = Field(None, title="Path to stderr file")
    standard_input: Optional[str] = Field(None, title="Path to stdin file")
    standard_output: Optional[str] = Field(None, title="Path to stdout file")
    wait_for_switch: Optional[int] = Field(
        None, title="Maximum time to wait for switches in seconds"
    )
    wckey: Optional[str] = Field(None, title="Workload characterization key")
    x11: Optional[List[str]] = Field(None, title="X11 forwarding options")
    x11_magic_cookie: Optional[str] = Field(
        None, title="Magic cookie for X11 forwarding"
    )
    x11_target_host: Optional[str] = Field(
        None, title="Hostname or UNIX socket if x11_target_port=0"
    )
    x11_target_port: Optional[int] = Field(None, title="TCP port")


class JobSubmitReq(BaseModel):
    script: Optional[str] = Field(
        None,
        title="Batch job script; must be specified in first component of jobs or in job if this field is not populated",
    )
    jobs: Optional[List[JobDescMsg]] = Field(None, title="HetJob description")
    job: Optional[JobDescMsg] = Field(None, title="Job description")


class OpenapiMeta(BaseModel):
    plugin: Optional[OpenapiMetaPlugin] = Field(None, title="Openapi meta plugin")
    client: Optional[OpenapiMetaClient] = Field(None, title="Openapi meta client")
    command: Optional[List[str]] = Field(None, title="CLI command (if applicable)")
    slurm: Optional[OpenapiMetaSlurm] = Field(None, title="Openapi meta slurm")


class OpenapiResp(BaseModel):
    meta: Optional[OpenapiMeta] = Field(None, title="Slurm meta values")
    errors: Optional[List[OpenapiError]] = Field(None, title="Query errors")
    warnings: Optional[List[OpenapiWarning]] = Field(None, title="Query warnings")


class PostBodySlurmJobSubmit(BaseModel):
    content: Optional[JobSubmitReq] = Field(None, title="Job submit req")


class ProcessExitCodeVerbose(BaseModel):
    status: Optional[List[str]] = Field(None, title="Status given by return code")
    return_code: Optional[Uint32NoVal] = Field(
        None, title="Process return code (numeric)"
    )
    signal: Optional[ProcessExitCodeVerboseSignal] = Field(
        None, title="Process exit code verbose signal"
    )


class DeleteResponse200SlurmJobJobid(BaseModel):
    content: OpenapiResp = Field(..., title="Openapi resp")


class DeleteResponseDefaultSlurmJobJobid(BaseModel):
    content: OpenapiResp = Field(..., title="Openapi resp")


class JobInfo(BaseModel):
    account: Optional[str] = Field(None, title="Account associated with the job")
    accrue_time: Optional[Uint64NoVal] = Field(
        None, title="When the job started accruing age priority (UNIX timestamp)"
    )
    admin_comment: Optional[str] = Field(
        None, title="Arbitrary comment made by administrator"
    )
    allocating_node: Optional[str] = Field(
        None, title="Local node making the resource allocation"
    )
    array_job_id: Optional[Uint32NoVal] = Field(
        None, title="Job ID of job array, or 0 if N/A"
    )
    array_task_id: Optional[Uint32NoVal] = Field(
        None, title="Task ID of this task in job array"
    )
    array_max_tasks: Optional[Uint32NoVal] = Field(
        None, title="Maximum number of simultaneously running tasks, 0 if no limit"
    )
    array_task_string: Optional[str] = Field(
        None, title="String expression of task IDs in this record"
    )
    association_id: Optional[int] = Field(
        None, title="Unique identifier for the association"
    )
    batch_features: Optional[str] = Field(
        None, title="Features required for batch script's node"
    )
    batch_flag: Optional[bool] = Field(None, title="True if batch job")
    batch_host: Optional[str] = Field(None, title="Name of host running batch script")
    flags: Optional[List[str]] = Field(None, title="Job flags")
    burst_buffer: Optional[str] = Field(None, title="Burst buffer specifications")
    burst_buffer_state: Optional[str] = Field(None, title="Burst buffer state details")
    cluster: Optional[str] = Field(None, title="Cluster name")
    cluster_features: Optional[str] = Field(
        None, title="List of required cluster features"
    )
    command: Optional[str] = Field(None, title="Executed command")
    comment: Optional[str] = Field(None, title="Arbitrary comment")
    container: Optional[str] = Field(
        None, title="Absolute path to OCI container bundle"
    )
    container_id: Optional[str] = Field(None, title="OCI container ID")
    contiguous: Optional[bool] = Field(
        None, title="True if job requires contiguous nodes"
    )
    core_spec: Optional[int] = Field(None, title="Specialized core count")
    thread_spec: Optional[int] = Field(None, title="Specialized thread count")
    cores_per_socket: Optional[Uint16NoVal] = Field(
        None, title="Cores per socket required"
    )
    billable_tres: Optional[Float64NoVal] = Field(None, title="Billable TRES")
    cpus_per_task: Optional[Uint16NoVal] = Field(
        None, title="Number of CPUs required by each task"
    )
    cpu_frequency_minimum: Optional[Uint32NoVal] = Field(
        None, title="Minimum CPU frequency"
    )
    cpu_frequency_maximum: Optional[Uint32NoVal] = Field(
        None, title="Maximum CPU frequency"
    )
    cpu_frequency_governor: Optional[Uint32NoVal] = Field(
        None, title="CPU frequency governor"
    )
    cpus_per_tres: Optional[str] = Field(
        None,
        title="Semicolon delimited list of TRES=# values indicating how many CPUs should be allocated for each specified TRES (currently only used for gres/gpu)",
    )
    cron: Optional[str] = Field(None, title="Time specification for scrontab job")
    deadline: Optional[Uint64NoVal] = Field(
        None, title="Latest time that the job may start (UNIX timestamp)"
    )
    delay_boot: Optional[Uint32NoVal] = Field(
        None,
        title="Number of seconds after job eligible start that nodes will be rebooted to satisfy feature specification",
    )
    dependency: Optional[str] = Field(
        None,
        title="Other jobs that must meet certain criteria before this job can start",
    )
    derived_exit_code: Optional[ProcessExitCodeVerbose] = Field(
        None, title="return code returned by process"
    )
    eligible_time: Optional[Uint64NoVal] = Field(
        None, title="Time when the job became eligible to run (UNIX timestamp)"
    )
    end_time: Optional[Uint64NoVal] = Field(
        None, title="End time, real or expected (UNIX timestamp)"
    )
    excluded_nodes: Optional[str] = Field(
        None, title="Comma separated list of nodes that may not be used"
    )
    exit_code: Optional[ProcessExitCodeVerbose] = Field(
        None, title="return code returned by process"
    )
    extra: Optional[str] = Field(
        None,
        title="Arbitrary string used for node filtering if extra constraints are enabled",
    )
    failed_node: Optional[str] = Field(
        None, title="Name of node that caused job failure"
    )
    features: Optional[str] = Field(
        None, title="Comma separated list of features that are required"
    )
    federation_origin: Optional[str] = Field(
        None, title="Origin cluster's name (when using federation)"
    )
    federation_siblings_active: Optional[str] = Field(
        None, title="Active sibling job names"
    )
    federation_siblings_viable: Optional[str] = Field(
        None, title="Viable sibling job names"
    )
    gres_detail: Optional[List[str]] = Field(
        None, title="List of GRES index and counts allocated per node"
    )
    group_id: Optional[int] = Field(
        None, title="Group ID of the user that owns the job"
    )
    group_name: Optional[str] = Field(
        None, title="Group name of the user that owns the job"
    )
    het_job_id: Optional[Uint32NoVal] = Field(
        None, title="Heterogeneous job ID, if applicable"
    )
    het_job_id_set: Optional[str] = Field(
        None, title="Job ID range for all heterogeneous job components"
    )
    het_job_offset: Optional[Uint32NoVal] = Field(
        None,
        title="Unique sequence number applied to this component of the heterogeneous job",
    )
    job_id: Optional[int] = Field(None, title="Job ID")
    job_resources: Optional[JobRes] = Field(None, title="Resources used by the job")
    job_size_str: Optional[List[str]] = Field(
        None, title="Number of nodes (in a range) required for this job"
    )
    job_state: Optional[List[str]] = Field(None, title="Current state")
    last_sched_evaluation: Optional[Uint64NoVal] = Field(
        None, title="Last time job was evaluated for scheduling (UNIX timestamp)"
    )
    licenses: Optional[str] = Field(None, title="License(s) required by the job")
    mail_type: Optional[List[str]] = Field(None, title="Mail event type(s)")
    mail_user: Optional[str] = Field(None, title="User to receive email notifications")
    max_cpus: Optional[Uint32NoVal] = Field(
        None, title="Maximum number of CPUs usable by the job"
    )
    max_nodes: Optional[Uint32NoVal] = Field(
        None, title="Maximum number of nodes usable by the job"
    )
    mcs_label: Optional[str] = Field(
        None, title="Multi-Category Security label on the job"
    )
    memory_per_tres: Optional[str] = Field(
        None,
        title="Semicolon delimited list of TRES=# values indicating how much memory in megabytes should be allocated for each specified TRES (currently only used for gres/gpu)",
    )
    name: Optional[str] = Field(None, title="Job name")
    network: Optional[str] = Field(None, title="Network specs for the job")
    nodes: Optional[str] = Field(None, title="Node(s) allocated to the job")
    nice: Optional[int] = Field(None, title="Requested job priority change")
    tasks_per_core: Optional[Uint16NoVal] = Field(
        None, title="Number of tasks invoked on each core"
    )
    tasks_per_tres: Optional[Uint16NoVal] = Field(
        None, title="Number of tasks that can assess each GPU"
    )
    tasks_per_node: Optional[Uint16NoVal] = Field(
        None, title="Number of tasks invoked on each node"
    )
    tasks_per_socket: Optional[Uint16NoVal] = Field(
        None, title="Number of tasks invoked on each socket"
    )
    tasks_per_board: Optional[Uint16NoVal] = Field(
        None, title="Number of tasks invoked on each board"
    )
    cpus: Optional[Uint32NoVal] = Field(None, title="Minimum number of CPUs required")
    node_count: Optional[Uint32NoVal] = Field(
        None, title="Minimum number of nodes required"
    )
    tasks: Optional[Uint32NoVal] = Field(None, title="Number of tasks")
    partition: Optional[str] = Field(None, title="Partition assigned to the job")
    prefer: Optional[str] = Field(
        None, title="Feature(s) the job requested but that are not required"
    )
    memory_per_cpu: Optional[Uint64NoVal] = Field(
        None, title="Minimum memory in megabytes per allocated CPU"
    )
    memory_per_node: Optional[Uint64NoVal] = Field(
        None, title="Minimum memory in megabytes per allocated node"
    )
    minimum_cpus_per_node: Optional[Uint16NoVal] = Field(
        None, title="Minimum number of CPUs per node"
    )
    minimum_tmp_disk_per_node: Optional[Uint32NoVal] = Field(
        None, title="Minimum tmp disk space required per node"
    )
    power: Optional[JobInfoPower] = Field(None, title="Job info power")
    preempt_time: Optional[Uint64NoVal] = Field(
        None, title="Time job received preemption signal (UNIX timestamp)"
    )
    preemptable_time: Optional[Uint64NoVal] = Field(
        None, title="Time job becomes eligible for preemption (UNIX timestamp)"
    )
    pre_sus_time: Optional[Uint64NoVal] = Field(
        None, title="Total run time prior to last suspend in seconds"
    )
    hold: Optional[bool] = Field(None, title="Job held")
    priority: Optional[Uint32NoVal] = Field(None, title="Request specific job priority")
    profile: Optional[List[str]] = Field(
        None, title="Profile used by the acct_gather_profile plugin"
    )
    qos: Optional[str] = Field(None, title="Quality of Service assigned to the job")
    reboot: Optional[bool] = Field(None, title="Node reboot requested before start")
    required_nodes: Optional[str] = Field(
        None, title="Comma separated list of required nodes"
    )
    minimum_switches: Optional[int] = Field(
        None, title="Maximum number of switches (the 'minimum' in the key is incorrect)"
    )
    requeue: Optional[bool] = Field(
        None, title="Determines whether the job may be requeued"
    )
    resize_time: Optional[Uint64NoVal] = Field(
        None, title="Time of last size change (UNIX timestamp)"
    )
    restart_cnt: Optional[int] = Field(None, title="Number of job restarts")
    resv_name: Optional[str] = Field(None, title="Name of reservation to use")
    scheduled_nodes: Optional[str] = Field(
        None, title="List of nodes scheduled to be used for the job"
    )
    selinux_context: Optional[str] = Field(None, title="SELinux context")
    shared: Optional[List[str]] = Field(
        None, title="How the job can share resources with other jobs, if at all"
    )
    exclusive: Optional[List[str]] = Field(None, title="Exclusive")
    oversubscribe: Optional[bool] = Field(None, title="Oversubscribe")
    show_flags: Optional[List[str]] = Field(
        None, title="Job details shown in this response"
    )
    sockets_per_board: Optional[int] = Field(
        None, title="Number of sockets per board required"
    )
    sockets_per_node: Optional[Uint16NoVal] = Field(
        None, title="Number of sockets per node required"
    )
    start_time: Optional[Uint64NoVal] = Field(
        None, title="Time execution began, or is expected to begin (UNIX timestamp)"
    )
    state_description: Optional[str] = Field(
        None, title="Optional details for state_reason"
    )
    state_reason: Optional[str] = Field(
        None, title="Reason for current Pending or Failed state"
    )
    standard_error: Optional[str] = Field(None, title="Path to stderr file")
    standard_input: Optional[str] = Field(None, title="Path to stdin file")
    standard_output: Optional[str] = Field(None, title="Path to stdout file")
    submit_time: Optional[Uint64NoVal] = Field(
        None, title="Time when the job was submitted (UNIX timestamp)"
    )
    suspend_time: Optional[Uint64NoVal] = Field(
        None, title="Time the job was last suspended or resumed (UNIX timestamp)"
    )
    system_comment: Optional[str] = Field(
        None, title="Arbitrary comment from slurmctld"
    )
    time_limit: Optional[Uint32NoVal] = Field(None, title="Maximum run time in minutes")
    time_minimum: Optional[Uint32NoVal] = Field(
        None, title="Minimum run time in minutes"
    )
    threads_per_core: Optional[Uint16NoVal] = Field(
        None, title="Number of threads per core required"
    )
    tres_bind: Optional[str] = Field(None, title="Task to TRES binding directives")
    tres_freq: Optional[str] = Field(None, title="TRES frequency directives")
    tres_per_job: Optional[str] = Field(
        None, title="Comma separated list of TRES=# values to be allocated per job"
    )
    tres_per_node: Optional[str] = Field(
        None, title="Comma separated list of TRES=# values to be allocated per node"
    )
    tres_per_socket: Optional[str] = Field(
        None, title="Comma separated list of TRES=# values to be allocated per socket"
    )
    tres_per_task: Optional[str] = Field(
        None, title="Comma separated list of TRES=# values to be allocated per task"
    )
    tres_req_str: Optional[str] = Field(None, title="TRES requested by the job")
    tres_alloc_str: Optional[str] = Field(None, title="TRES used by the job")
    user_id: Optional[int] = Field(None, title="User ID that owns the job")
    user_name: Optional[str] = Field(None, title="User name that owns the job")
    maximum_switch_wait_time: Optional[int] = Field(
        None, title="Maximum time to wait for switches in seconds"
    )
    wckey: Optional[str] = Field(None, title="Workload characterization key")
    current_working_directory: Optional[str] = Field(
        None, title="Working directory to use for the job"
    )


class OpenapiJobInfoResp(BaseModel):
    jobs: Optional[List[JobInfo]] = Field(None, title="List of jobs")
    last_backfill: Optional[Uint64NoVal] = Field(
        None, title="Time of last backfill scheduler run (UNIX timestamp)"
    )
    last_update: Optional[Uint64NoVal] = Field(
        None, title="Time of last job change (UNIX timestamp)"
    )
    meta: Optional[OpenapiMeta] = Field(None, title="Slurm meta values")
    errors: Optional[List[OpenapiError]] = Field(None, title="Query errors")
    warnings: Optional[List[OpenapiWarning]] = Field(None, title="Query warnings")


class OpenapiJobSubmitResponse(BaseModel):
    result: Optional[JobSubmitResponseMsg] = Field(None, title="Job submission")
    job_id: Optional[int] = Field(None, title="Submitted Job ID")
    step_id: Optional[str] = Field(None, title="Submitted Step ID")
    job_submit_user_msg: Optional[str] = Field(None, title="job submision user message")
    meta: Optional[OpenapiMeta] = Field(None, title="Slurm meta values")
    errors: Optional[List[OpenapiError]] = Field(None, title="Query errors")
    warnings: Optional[List[OpenapiWarning]] = Field(None, title="Query warnings")


class PostResponse200SlurmJobSubmit(BaseModel):
    content: OpenapiJobSubmitResponse = Field(..., title="Openapi job submit response")


class PostResponseDefaultSlurmJobSubmit(BaseModel):
    content: OpenapiJobSubmitResponse = Field(..., title="Openapi job submit response")


class GetResponse200SlurmJobJobid(BaseModel):
    content: OpenapiJobInfoResp = Field(..., title="Openapi job info resp")


class GetResponse200SlurmJobs(BaseModel):
    content: OpenapiJobInfoResp = Field(..., title="Openapi job info resp")


class GetResponseDefaultSlurmJobJobid(BaseModel):
    content: OpenapiJobInfoResp = Field(..., title="Openapi job info resp")


class GetResponseDefaultSlurmJobs(BaseModel):
    content: OpenapiJobInfoResp = Field(..., title="Openapi job info resp")


class AllModels(BaseModel):
    model0: PostPathSlurmJobSubmit = Field(
        ..., title="POST /slurm/v0.0.40/job/submit: path parameters"
    )
    model1: PostQuerySlurmJobSubmit = Field(
        ..., title="POST /slurm/v0.0.40/job/submit: query parameters"
    )
    model2: Uint64NoVal = Field(..., title="Integer number with flags")
    model3: CronEntryLine = Field(..., title="Cron entry line")
    model4: CronEntry = Field(..., title="crontab entry")
    model5: JobDescMsgRlimits = Field(..., title="Job desc msg rlimits")
    model6: Uint32NoVal = Field(..., title="Integer number with flags")
    model7: Uint16NoVal = Field(..., title="Integer number with flags")
    model8: JobDescMsg = Field(..., title="Job desc msg")
    model9: JobSubmitReq = Field(..., title="Job submit req")
    model10: PostBodySlurmJobSubmit = Field(..., title="Job description")
    model11: JobSubmitResponseMsg = Field(..., title="Job submission")
    model12: OpenapiMetaPlugin = Field(..., title="Openapi meta plugin")
    model13: OpenapiMetaClient = Field(..., title="Openapi meta client")
    model14: OpenapiMetaSlurmVersion = Field(..., title="Openapi meta slurm version")
    model15: OpenapiMetaSlurm = Field(..., title="Openapi meta slurm")
    model16: OpenapiMeta = Field(..., title="Slurm meta values")
    model17: OpenapiError = Field(..., title="Openapi error")
    model18: OpenapiWarning = Field(..., title="Openapi warning")
    model19: OpenapiJobSubmitResponse = Field(..., title="Openapi job submit response")
    model20: PostResponse200SlurmJobSubmit = Field(..., title="job submission response")
    model21: PostResponseDefaultSlurmJobSubmit = Field(
        ..., title="job submission response"
    )
    model22: GetPathSlurmJobJobid = Field(
        ..., title="GET /slurm/v0.0.40/job/{job_id}: path parameters"
    )
    model23: GetQuerySlurmJobJobid = Field(
        ..., title="GET /slurm/v0.0.40/job/{job_id}: query parameters"
    )
    model24: GetBodySlurmJobJobid = Field(
        ..., title="GET /slurm/v0.0.40/job/{job_id}: body"
    )
    model25: Float64NoVal = Field(..., title="64 bit floating point number with flags")
    model26: ProcessExitCodeVerboseSignal = Field(
        ..., title="Process exit code verbose signal"
    )
    model27: ProcessExitCodeVerbose = Field(
        ..., title="return code returned by process"
    )
    model28: JobRes = Field(..., title="Resources used by the job")
    model29: JobInfoPower = Field(..., title="Job info power")
    model30: JobInfo = Field(..., title="Job info")
    model31: OpenapiJobInfoResp = Field(..., title="Openapi job info resp")
    model32: GetResponse200SlurmJobJobid = Field(..., title="job(s) information")
    model33: GetResponseDefaultSlurmJobJobid = Field(..., title="job(s) information")
    model34: DeletePathSlurmJobJobid = Field(
        ..., title="DELETE /slurm/v0.0.40/job/{job_id}: path parameters"
    )
    model35: DeleteQuerySlurmJobJobid = Field(
        ..., title="DELETE /slurm/v0.0.40/job/{job_id}: query parameters"
    )
    model36: DeleteBodySlurmJobJobid = Field(
        ..., title="DELETE /slurm/v0.0.40/job/{job_id}: body"
    )
    model37: OpenapiResp = Field(..., title="Openapi resp")
    model38: DeleteResponse200SlurmJobJobid = Field(..., title="job signal result")
    model39: DeleteResponseDefaultSlurmJobJobid = Field(..., title="job signal result")
    model40: GetPathSlurmJobs = Field(
        ..., title="GET /slurm/v0.0.40/jobs: path parameters"
    )
    model41: GetQuerySlurmJobs = Field(
        ..., title="GET /slurm/v0.0.40/jobs: query parameters"
    )
    model42: GetBodySlurmJobs = Field(..., title="GET /slurm/v0.0.40/jobs: body")
    model43: GetResponse200SlurmJobs = Field(..., title="job(s) information")
    model44: GetResponseDefaultSlurmJobs = Field(..., title="job(s) information")
