# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PermissionsArgs', 'Permissions']

@pulumi.input_type
class PermissionsArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input['PermissionsPermissionsArgs'],
                 user: pulumi.Input[_builtins.str],
                 vhost: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Permissions resource.
        :param pulumi.Input['PermissionsPermissionsArgs'] permissions: The settings of the permissions. The structure is
               described below.
        :param pulumi.Input[_builtins.str] user: The user to apply the permissions to.
        :param pulumi.Input[_builtins.str] vhost: The vhost to create the resource in.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "user", user)
        if vhost is not None:
            pulumi.set(__self__, "vhost", vhost)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Input['PermissionsPermissionsArgs']:
        """
        The settings of the permissions. The structure is
        described below.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input['PermissionsPermissionsArgs']):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input[_builtins.str]:
        """
        The user to apply the permissions to.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def vhost(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vhost to create the resource in.
        """
        return pulumi.get(self, "vhost")

    @vhost.setter
    def vhost(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost", value)


@pulumi.input_type
class _PermissionsState:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input['PermissionsPermissionsArgs']] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Permissions resources.
        :param pulumi.Input['PermissionsPermissionsArgs'] permissions: The settings of the permissions. The structure is
               described below.
        :param pulumi.Input[_builtins.str] user: The user to apply the permissions to.
        :param pulumi.Input[_builtins.str] vhost: The vhost to create the resource in.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vhost is not None:
            pulumi.set(__self__, "vhost", vhost)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input['PermissionsPermissionsArgs']]:
        """
        The settings of the permissions. The structure is
        described below.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input['PermissionsPermissionsArgs']]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user to apply the permissions to.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def vhost(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vhost to create the resource in.
        """
        return pulumi.get(self, "vhost")

    @vhost.setter
    def vhost(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vhost", value)


@pulumi.type_token("rabbitmq:index/permissions:Permissions")
class Permissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Union['PermissionsPermissionsArgs', 'PermissionsPermissionsArgsDict']]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The ``Permissions`` resource creates and manages a user's set of
        permissions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rabbitmq as rabbitmq

        test = rabbitmq.VHost("test", name="test")
        test_user = rabbitmq.User("test",
            name="mctest",
            password="foobar",
            tags=["administrator"])
        test_permissions = rabbitmq.Permissions("test",
            user=test_user.name,
            vhost=test.name,
            permissions={
                "configure": ".*",
                "write": ".*",
                "read": ".*",
            })
        ```

        ## Import

        Permissions can be imported using the `id` which is composed of  `user@vhost`.

        E.g.

        ```sh
        $ pulumi import rabbitmq:index/permissions:Permissions test user@vhost
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PermissionsPermissionsArgs', 'PermissionsPermissionsArgsDict']] permissions: The settings of the permissions. The structure is
               described below.
        :param pulumi.Input[_builtins.str] user: The user to apply the permissions to.
        :param pulumi.Input[_builtins.str] vhost: The vhost to create the resource in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``Permissions`` resource creates and manages a user's set of
        permissions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_rabbitmq as rabbitmq

        test = rabbitmq.VHost("test", name="test")
        test_user = rabbitmq.User("test",
            name="mctest",
            password="foobar",
            tags=["administrator"])
        test_permissions = rabbitmq.Permissions("test",
            user=test_user.name,
            vhost=test.name,
            permissions={
                "configure": ".*",
                "write": ".*",
                "read": ".*",
            })
        ```

        ## Import

        Permissions can be imported using the `id` which is composed of  `user@vhost`.

        E.g.

        ```sh
        $ pulumi import rabbitmq:index/permissions:Permissions test user@vhost
        ```

        :param str resource_name: The name of the resource.
        :param PermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Union['PermissionsPermissionsArgs', 'PermissionsPermissionsArgsDict']]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 vhost: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionsArgs.__new__(PermissionsArgs)

            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["vhost"] = vhost
        super(Permissions, __self__).__init__(
            'rabbitmq:index/permissions:Permissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            permissions: Optional[pulumi.Input[Union['PermissionsPermissionsArgs', 'PermissionsPermissionsArgsDict']]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None,
            vhost: Optional[pulumi.Input[_builtins.str]] = None) -> 'Permissions':
        """
        Get an existing Permissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PermissionsPermissionsArgs', 'PermissionsPermissionsArgsDict']] permissions: The settings of the permissions. The structure is
               described below.
        :param pulumi.Input[_builtins.str] user: The user to apply the permissions to.
        :param pulumi.Input[_builtins.str] vhost: The vhost to create the resource in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionsState.__new__(_PermissionsState)

        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["user"] = user
        __props__.__dict__["vhost"] = vhost
        return Permissions(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output['outputs.PermissionsPermissions']:
        """
        The settings of the permissions. The structure is
        described below.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The user to apply the permissions to.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def vhost(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The vhost to create the resource in.
        """
        return pulumi.get(self, "vhost")

