import os
import json
import pickle
from typing import Optional
from .basicutils import mkdir
from json import JSONEncoder

class MyEncoder(JSONEncoder):
    def default(self, o):
        return o.__dict__

def objequals(o1:object, o2:object) -> bool:
    return json.dumps(o1, cls=MyEncoder) == json.dumps(o2, cls=MyEncoder)

def objtojson(o:object) -> str:
    return json.dumps(o, cls=MyEncoder)

def loadjsonfile(path) -> Optional[list|dict]:
    if not os.path.exists(path):
        return None
    with open(path, "r") as f:
        return json.load(f)

def loadarrayjsonfile(path) -> list:
    r = loadjsonfile(path)
    if r is None:
        return []
    if isinstance(r, list):
        return r
    raise Exception("result is not list")

def loaddictjsonfile(path) -> dict:
    r = loadjsonfile(path)
    if r is None:
        return {}
    if isinstance(r, dict):
        return r
    raise Exception("result is not dict")

def writejsonfile(path, obj, automkdir=True):
    if automkdir:
        dir = os.path.dirname(path)
        if dir and not os.path.exists(dir):
            mkdir(dir)
    with open(path, "w+") as f:
        return json.dump(obj, f)

def loadpicklefile(path):
    if not os.path.exists(path):
        return None
    with open(path, "rb") as f:
        return pickle.load(f)
    
def writepicklefile(path, obj):
    with open(path, "wb+") as f:
        return pickle.dump(obj, f)
