# Stellar Evolutionary Stage Heuristic Assessment Tool (SESHAT)

This is a beta version of the SESHAT tool, currently being modified for publication.  
The final version will be released pending any suggestions from the referee.

Important caveat: In the current distribution, Spitzer data that is missing MIPS is not classified to the accuracy given by the test set. This will be rectified before publication.

If you use this package, please cite Crompvoets et al. 2025 (nearly submitted). Please also cite the original data producers:  
YSOs: [Richardson et al. (2024)](https://ui.adsabs.harvard.edu/abs/2024ApJ...961..188R/abstract)  
Brown dwarfs: ATMO -- [Phillips et al. (2020)](https://ui.adsabs.harvard.edu/abs/2020A%26A...637A..38P/abstract)  
White dwarfs: [Blouin et al. (2018)](https://ui.adsabs.harvard.edu/abs/2018ApJ...863..184B/abstract)  
Field stars: PARSEC -- [Bressen et al. (2012)](https://ui.adsabs.harvard.edu/abs/2012MNRAS.427..127B/abstract)  
Galaxies: CIGALE -- [Burgarella et al. 2005](https://ui.adsabs.harvard.edu/abs/2005MNRAS.360.1413B/abstract), [Noll et al. 2009](https://ui.adsabs.harvard.edu/abs/2009A%26A...507.1793N/abstract) [Boquin et al. (2020)](https://ui.adsabs.harvard.edu/abs/2019A%26A...622A.103B/abstract)  


## Catalog set-up
Please have your catalog set-up with the columns as:  
Spitzer: ['IRAC1', 'IRAC2', 'IRAC3', 'IRAC4', 'MIPS1', 'MIPS2', 'MIPS3']  
2MASS: ['J', 'H', 'Ks']  
JWST: in the frame of 'f090w', or 'f322w2'.  

Please include errors as 'e_' + filter name; e.g. 'e_f090w'.  

All columns must be in Vega mags.  

If you have labels already known, these should be under the column: 'Class'  
The labels should match the following:  
Young Stellar Objects: "YSO"  
Field stars: "FS"  
Galaxies: "Gal"  
White dwarfs: "WD"  
Brown dwarfs: "BD"   

## Other important information
The function classify accepts pandas DataFrames or Astropy Tables.  

When testing filters, you must input limiting and saturating magnitudes of each filter, as well as what an appropriate distribution of errors for the data might be. These errors are used to add noise to the training/testing data.

SESHAT only takes medium, wide, and very-wide filters as input for JWST, no narrow filters.

## Example of obtaining classifications

~~~
from seshat_classifier import seshat
import pandas as pd

# Read in catalog
my_catalog = pd.read_csv("my_catalog.csv")

# Specify classes to be identified
classes = ['YSO', 'FS', 'Gal']

# Get classifications
my_catalog_classified = seshat.classify(real = my_catalog, classes = classes, return_test=False, threads = 8)

# Get classifications and test set performance
my_catalog_classified, test_results = seshat.classify(real = my_catalog, classes = classes, return_test=True, threads = 8)
~~~

## Example of testing filters

~~~
from seshat_classifier import seshat
import numpy as np
import matplotlib.pyplot as plt

# Specify filters to test
filters = ['f090w', 'f200w', 'f356w', 'f480m', 'f770w', 'f1500w']
# Specify classes to search for
classes = ['YSO', 'FS', 'Gal']

# Specify the limiting and saturating magnitudes of your proposed observations
limiting_mags = {'f090w':22, 'f200w':23, 'f356w':24, 'f480m':25, 'f770w':22, 'f1500w':24}
saturating_mags = {'f090w':14, 'f200w':13, 'f356w':12, 'f480m':11, 'f770w':15, 'f1500w':14}

# Specify the expected distribution of errors
sig = 0.02
mean = 0.1
errs = [np.random.normal(mean, sig, size=100) for f in filters] # Choose a suitably large size to capture shape of distribution

# Get the performance
test_results = seshat.test_filters(filters = filters, classes=classes, limiting_mags = limiting_mags, saturating_mags = saturating_mags, errs=errs, threads = 8)

# Plot performance
ax = seshat.cm_custom(test_results.Class,test_results.Predicted_Class,cmap='Greys',display_labels=classes)
plt.show()
~~~