import { CostExplorerClient } from '@aws-sdk/client-cost-explorer';
import { GetDateRange } from './get-date-range';
export interface TotalBilling {
    readonly unit: string;
    readonly amount: number;
}
export declare class GetTotalBilling {
    private client;
    constructor(client: CostExplorerClient);
    execute: (dateRange: GetDateRange) => Promise<TotalBilling | undefined>;
}
export interface ServiceBilling {
    readonly service: string;
    readonly unit: string;
    readonly amount: number;
}
export declare class GetServiceBilling {
    private client;
    constructor(client: CostExplorerClient);
    execute: (dateRange: GetDateRange, nextPageToken?: string | undefined) => Promise<ServiceBilling[] | undefined>;
}
export interface AccountBilling {
    readonly account: string;
    readonly amount: number;
    readonly unit: string;
}
export declare class GetAccountBillings {
    private client;
    constructor(client: CostExplorerClient);
    execute: (dateRange: GetDateRange, nextPageToken?: string | undefined) => Promise<AccountBilling[] | undefined>;
}
