"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetAccountBillings = exports.GetServiceBilling = exports.GetTotalBilling = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const client_cost_explorer_1 = require("@aws-sdk/client-cost-explorer");
class GetTotalBilling {
    constructor(client) {
        this.client = client;
        this.execute = async (dateRange) => {
            const input = {
                TimePeriod: {
                    Start: dateRange.start,
                    End: dateRange.end,
                },
                Granularity: 'MONTHLY',
                Metrics: [
                    'AMORTIZED_COST',
                ],
            };
            console.log(`TotalBilling:Command:Input:${JSON.stringify(input)}`);
            return this.client.send(new client_cost_explorer_1.GetCostAndUsageCommand(input))
                .then((data) => {
                if (data && data.ResultsByTime && data.ResultsByTime.length === 1) {
                    const cost = Object(data.ResultsByTime[0]).Total.AmortizedCost;
                    const result = {
                        unit: cost.Unit,
                        amount: cost.Amount,
                    };
                    console.log(`TotalBilling:Command:Output(Shaped):${JSON.stringify(result)}`);
                    return result;
                }
                return undefined;
            })
                .catch((error) => {
                console.log('Error caught...');
                console.log(`Error:${JSON.stringify(error)}`);
                return undefined;
            });
        };
    }
    ;
}
exports.GetTotalBilling = GetTotalBilling;
class GetServiceBilling {
    constructor(client) {
        this.client = client;
        this.execute = async (dateRange, nextPageToken) => {
            const input = {
                NextPageToken: nextPageToken,
                TimePeriod: {
                    Start: dateRange.start,
                    End: dateRange.end,
                },
                Granularity: 'MONTHLY',
                Metrics: [
                    'AMORTIZED_COST',
                ],
                GroupBy: [
                    {
                        Type: 'DIMENSION',
                        Key: 'SERVICE',
                    },
                ],
            };
            console.log(`ServiceBillings:Command:Input:${JSON.stringify(input)}`);
            return this.client.send(new client_cost_explorer_1.GetCostAndUsageCommand(input))
                .then(async (data) => {
                const billings = [];
                if (data.ResultsByTime && data.ResultsByTime.length === 1) {
                    for (const item of Object(data.ResultsByTime[0]).Groups) {
                        billings.push({
                            service: item.Keys[0],
                            unit: item.Metrics.AmortizedCost.Unit,
                            amount: item.Metrics.AmortizedCost.Amount,
                        });
                    }
                    console.log(`ServiceBillings:Command:Output(Shaped):${JSON.stringify(billings)}`);
                    if (data.NextPageToken) {
                        const nextBillings = await this.execute(dateRange, data.NextPageToken);
                        if (nextBillings) {
                            return billings.concat(nextBillings);
                        }
                    }
                    return billings;
                }
                return undefined;
            })
                .catch(async (error) => {
                console.log('Error caught...');
                console.log(`Error:${JSON.stringify(error)}`);
                return undefined;
            });
        };
    }
    ;
}
exports.GetServiceBilling = GetServiceBilling;
class GetAccountBillings {
    constructor(client) {
        this.client = client;
        this.execute = async (dateRange, nextPageToken) => {
            const input = {
                NextPageToken: nextPageToken,
                TimePeriod: {
                    Start: dateRange.start,
                    End: dateRange.end,
                },
                Granularity: 'MONTHLY',
                Metrics: [
                    'AMORTIZED_COST',
                ],
                GroupBy: [
                    {
                        Type: 'DIMENSION',
                        Key: 'LINKED_ACCOUNT',
                    },
                ],
            };
            console.log(`AccountBillings:Command:Input:${JSON.stringify(input)}`);
            return this.client.send(new client_cost_explorer_1.GetCostAndUsageCommand(input))
                .then(async (data) => {
                const billings = [];
                if (data.ResultsByTime && data.ResultsByTime.length === 1) {
                    const groups = Object(data.ResultsByTime[0]).Groups;
                    const dimensionValueAttributes = data.DimensionValueAttributes;
                    for (const item of groups) {
                        for (const attr of dimensionValueAttributes) {
                            if (item.Keys[0] === attr.Value) {
                                billings.push({
                                    account: `${attr.Value} (${attr.Attributes.description})`,
                                    unit: item.Metrics.AmortizedCost.Unit,
                                    amount: item.Metrics.AmortizedCost.Amount,
                                });
                            }
                        }
                    }
                    console.log(`AccountBillings:Command:Output(Shaped):${JSON.stringify(billings)}`);
                    if (data.NextPageToken) {
                        const nextBillings = await this.execute(dateRange, data.NextPageToken);
                        if (nextBillings) {
                            return billings.concat(nextBillings);
                        }
                    }
                    return billings;
                }
                return undefined;
            })
                .catch(async (error) => {
                console.log('Error caught...');
                console.log(`Error:${JSON.stringify(error)}`);
                return undefined;
            });
        };
    }
    ;
}
exports.GetAccountBillings = GetAccountBillings;
//# sourceMappingURL=data:application/json;base64,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