// Generated documentation contains content from HL7 FHIR specifications
// which may include HTML-like tags and bracket notations that are not actual HTML or links
#![allow(rustdoc::broken_intra_doc_links)]
#![allow(rustdoc::invalid_html_tags)]

use helios_fhir_macro::{FhirPath, FhirSerde};
use serde::{Deserialize, Serialize};

use crate::{DecimalElement, Element};

/// The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account
///
/// The party(s) that are responsible for covering the payment of this account,
/// and what order should they be applied to the account.
///
/// ## Implementation Notes
/// Typically. this may be some form of insurance, internal charges, or self-pay.
///
/// Local or jurisdictional business rules may determine which coverage covers
/// which types of billable items charged to the account, and in which order.
/// Where the order is important, a local/jurisdictional extension may be defined
/// to specify the order for the type of charge.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AccountCoverage {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// The party(s), such as insurances, that may contribute to the payment of this account
    ///
    /// The party(s) that contribute to payment (or part of) of the charges applied
    /// to this account (including self-pay).
    ///
    /// A coverage may only be responsible for specific types of charges, and the
    /// sequence of the coverages in the account could be important when processing
    /// billing.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub coverage: Reference,
    /// The priority of the coverage in the context of this account
    ///
    /// The priority of the coverage in the context of this account.
    ///
    /// ## Implementation Notes
    /// It is common in some jurisdictions for there to be multiple coverages
    /// allocated to an account, and a sequence is required to order the settling of
    /// the account (often with insurance claiming).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// coordination of benefit priority
    pub priority: Option<PositiveInt>,
}

/// FHIR Account type
///
/// A financial tool for tracking value accrued for a particular purpose. In the
/// healthcare field, used to track charges for a patient, cost centers, etc.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [Account](http://hl7.org/fhir/StructureDefinition/Account)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Account {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Account number
    ///
    /// Unique identifier used to reference the account. Might or might not be
    /// intended for human use (e.g. credit card number).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// active | inactive | entered-in-error | on-hold | unknown
    ///
    /// Indicates whether the account is presently used/usable or not.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because the status contains the codes
    /// inactive and entered-in-error that mark the Account as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicates whether the account is available to be used.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/account-status|4.0.1
    pub status: Code,
    /// E.g. patient, expense, depreciation
    ///
    /// Categorizes the account for reporting and searching purposes.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The usage type of this account, permits categorization of accounts.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/account-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<CodeableConcept>,
    /// Human-readable label
    ///
    /// Name used for the account when displaying it to humans in reports, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Title
    pub name: Option<String>,
    /// The entity that caused the expenses
    ///
    /// Identifies the entity which incurs the expenses. While the immediate
    /// recipients of services or goods might be entities related to the subject, the
    /// expenses were ultimately incurred by the subject of the Account.
    ///
    /// ## Implementation Notes
    /// Accounts can be applied to non-patients for tracking other non-patient
    /// related activities, such as group services (patients not tracked, and costs
    /// charged to another body), or might not be allocated.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// target
    pub subject: Option<Vec<Reference>>,
    /// Transaction window
    ///
    /// The date range of services associated with this account.
    ///
    /// ## Implementation Notes
    /// It is possible for transactions to be posted outside the service period, as
    /// long as the service was provided within the defined service period.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "servicePeriod")]
    pub service_period: Option<Period>,
    /// The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account
    ///
    /// The party(s) that are responsible for covering the payment of this account,
    /// and what order should they be applied to the account.
    ///
    /// ## Implementation Notes
    /// Typically. this may be some form of insurance, internal charges, or self-pay.
    ///
    /// Local or jurisdictional business rules may determine which coverage covers
    /// which types of billable items charged to the account, and in which order.
    /// Where the order is important, a local/jurisdictional extension may be defined
    /// to specify the order for the type of charge.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub coverage: Option<Vec<AccountCoverage>>,
    /// Entity managing the Account
    ///
    /// Indicates the service area, hospital, department, etc. with responsibility
    /// for managing the Account.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub owner: Option<Reference>,
    /// Explanation of purpose/use
    ///
    /// Provides additional information about what the account tracks and how it is
    /// used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// The parties ultimately responsible for balancing the Account
    ///
    /// The parties responsible for balancing the account if other payment options
    /// fall short.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub guarantor: Option<Vec<AccountGuarantor>>,
    /// Reference to a parent Account
    ///
    /// Reference to a parent Account.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "partOf")]
    pub part_of: Option<Reference>,
}

/// The parties ultimately responsible for balancing the Account
///
/// The parties responsible for balancing the account if other payment options
/// fall short.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AccountGuarantor {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Responsible entity
    ///
    /// The entity who is responsible.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub party: Reference,
    /// Credit or other hold applied
    ///
    /// A guarantor may be placed on credit hold or otherwise have their role
    /// temporarily suspended.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "onHold")]
    pub on_hold: Option<Boolean>,
    /// Guarantee account during
    ///
    /// The timeframe during which the guarantor accepts responsibility for the
    /// account.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub period: Option<Period>,
}

/// Who should participate in the action
///
/// Indicates who should participate in performing the action described.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ActivityDefinitionParticipant {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// patient | practitioner | related-person | device
    ///
    /// The type of participant in the action.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The type of participant in the activity.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/action-participant-type|4.0.1
    #[fhir_serde(rename = "type")]
    pub r#type: Code,
    /// E.g. Nurse, Surgeon, Parent, etc.
    ///
    /// The role the participant should play in performing the described action.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Defines roles played by participants for the action.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/action-participant-role
    pub role: Option<CodeableConcept>,
}

/// Choice of types for the subject\[x\] field in ActivityDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "subject")]
pub enum ActivityDefinitionSubject {
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "subjectCodeableConcept")]
    CodeableConcept(CodeableConcept),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "subjectReference")]
    Reference(Reference),
}

/// Choice of types for the timing\[x\] field in ActivityDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "timing")]
pub enum ActivityDefinitionTiming {
    /// Variant accepting the Timing type.
    #[fhir_serde(rename = "timingTiming")]
    Timing(Timing),
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "timingDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Age type.
    #[fhir_serde(rename = "timingAge")]
    Age(Age),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "timingPeriod")]
    Period(Period),
    /// Variant accepting the Range type.
    #[fhir_serde(rename = "timingRange")]
    Range(Range),
    /// Variant accepting the Duration type.
    #[fhir_serde(rename = "timingDuration")]
    Duration(Duration),
}

/// Choice of types for the product\[x\] field in ActivityDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "product")]
pub enum ActivityDefinitionProduct {
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "productReference")]
    Reference(Reference),
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "productCodeableConcept")]
    CodeableConcept(CodeableConcept),
}

/// FHIR ActivityDefinition type
///
/// This resource allows for the definition of some activity to be performed,
/// independent of a particular patient, practitioner, or other performance
/// context.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [ActivityDefinition](http://hl7.org/fhir/StructureDefinition/ActivityDefinition)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "subject,timing,product")]
pub struct ActivityDefinition {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Canonical identifier for this activity definition, represented as a URI (globally unique)
    ///
    /// An absolute URI that is used to identify this activity definition when it is
    /// referenced in a specification, model, design or an instance; also called its
    /// canonical identifier. This SHOULD be globally unique and SHOULD be a literal
    /// address at which at which an authoritative instance of this activity
    /// definition is (or will be) published. This URL can be the target of a
    /// canonical reference. It SHALL remain the same when the activity definition is
    /// stored on different servers.
    ///
    /// ## Requirements
    /// Allows the activity definition to be referenced by a single globally unique
    /// identifier.
    ///
    /// ## Implementation Notes
    /// Can be a urn:uuid: or a urn:oid: but real http: addresses are preferred.
    /// Multiple instances may share the same URL if they have a distinct version.
    ///
    /// The determination of when to create a new version of a resource (same url,
    /// new version) vs. defining a new artifact is up to the author. Considerations
    /// for making this decision are found in [Technical and Business
    /// Versions](resource.html#versions).
    ///
    /// In some cases, the resource can no longer be found at the stated url, but the
    /// url itself cannot change. Implementations can use the
    /// [meta.source](resource.html#meta) element to indicate where the current
    /// master source of the resource can be found.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Option<Uri>,
    /// Additional identifier for the activity definition
    ///
    /// A formal identifier that is used to identify this activity definition when it
    /// is represented in other formats, or referenced in a specification, model,
    /// design or an instance.
    ///
    /// ## Requirements
    /// Allows externally provided and/or usable business identifiers to be easily
    /// associated with the module.
    ///
    /// ## Implementation Notes
    /// Typically, this is used for identifiers that can go in an HL7 V3 II (instance
    /// identifier) data type, and can then identify this activity definition outside
    /// of FHIR, where it is not possible to use the logical URI.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Business version of the activity definition
    ///
    /// The identifier that is used to identify this version of the activity
    /// definition when it is referenced in a specification, model, design or
    /// instance. This is an arbitrary value managed by the activity definition
    /// author and is not expected to be globally unique. For example, it might be a
    /// timestamp (e.g. yyyymmdd) if a managed version is not available. There is
    /// also no expectation that versions can be placed in a lexicographical
    /// sequence. To provide a version consistent with the Decision Support Service
    /// specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more
    /// information on versioning knowledge assets, refer to the Decision Support
    /// Service specification. Note that a version is required for non-experimental
    /// active assets.
    ///
    /// ## Implementation Notes
    /// There may be different activity definition instances that have the same
    /// identifier but different versions. The version can be appended to the url in
    /// a reference to allow a reference to a particular business version of the
    /// activity definition with the format [url]|[version].
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub version: Option<String>,
    /// Name for this activity definition (computer friendly)
    ///
    /// A natural language name identifying the activity definition. This name should
    /// be usable as an identifier for the module by machine processing applications
    /// such as code generation.
    ///
    /// ## Requirements
    /// Support human navigation and code generation.
    ///
    /// ## Implementation Notes
    /// The name is not expected to be globally unique. The name should be a simple
    /// alphanumeric type name to ensure that it is machine-processing friendly.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: inv-0
    pub name: Option<String>,
    /// Name for this activity definition (human friendly)
    ///
    /// A short, descriptive, user-friendly title for the activity definition.
    ///
    /// ## Implementation Notes
    /// This name does not need to be machine-processing friendly and may contain
    /// punctuation, white-space, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// Subordinate title of the activity definition
    ///
    /// An explanatory or alternate title for the activity definition giving
    /// additional information about its content.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub subtitle: Option<String>,
    /// draft | active | retired | unknown
    ///
    /// The status of this activity definition. Enables tracking the life-cycle of
    /// the content.
    ///
    /// ## Implementation Notes
    /// Allows filtering of activity definitions that are appropriate for use versus
    /// not.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This is labeled as "Is Modifier" because applications should not use a retired {{title}} without due consideration
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|4.0.1
    pub status: Code,
    /// For testing purposes, not real usage
    ///
    /// A Boolean value to indicate that this activity definition is authored for
    /// testing purposes (or education/evaluation/marketing) and is not intended to
    /// be used for genuine usage.
    ///
    /// ## Requirements
    /// Enables experimental content to be developed following the same lifecycle
    /// that would be used for a production-level activity definition.
    ///
    /// ## Implementation Notes
    /// Allows filtering of activity definitions that are appropriate for use versus
    /// not.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub experimental: Option<Boolean>,
    /// Type of individual the activity definition is intended for
    ///
    /// A code or group definition that describes the intended subject of the
    /// activity being defined.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - When missing: Patient
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: The possible types of subjects for an activity (E.g. Patient, Practitioner, Organization, Location, etc.).
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/subject-type
    #[fhir_serde(flatten)]
    pub subject: Option<ActivityDefinitionSubject>,
    /// Date last changed
    ///
    /// The date (and optionally time) when the activity definition was published.
    /// The date must change when the business version changes and it must change if
    /// the status code changes. In addition, it should change when the substantive
    /// content of the activity definition changes.
    ///
    /// ## Implementation Notes
    /// Note that this is not the same as the resource last-modified-date, since the
    /// resource may be a secondary representation of the activity definition.
    /// Additional specific dates may be added as extensions or be found by
    /// consulting Provenances associated with past versions of the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Revision Date
    pub date: Option<DateTime>,
    /// Name of the publisher (organization or individual)
    ///
    /// The name of the organization or individual that published the activity
    /// definition.
    ///
    /// ## Requirements
    /// Helps establish the "authority/credibility" of the activity definition. May
    /// also allow for contact.
    ///
    /// ## Implementation Notes
    /// Usually an organization but may be an individual. The publisher (or steward)
    /// of the activity definition is the organization or individual primarily
    /// responsible for the maintenance and upkeep of the activity definition. This
    /// is not necessarily the same individual or organization that developed and
    /// initially authored the content. The publisher is the primary point of contact
    /// for questions or issues with the activity definition. This item SHOULD be
    /// populated unless the information is available from context.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub publisher: Option<String>,
    /// Contact details for the publisher
    ///
    /// Contact details to assist a user in finding and communicating with the
    /// publisher.
    ///
    /// ## Implementation Notes
    /// May be a web site, an email address, a telephone number, etc.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contact: Option<Vec<ContactDetail>>,
    /// Natural language description of the activity definition
    ///
    /// A free text natural language description of the activity definition from a
    /// consumer's perspective.
    ///
    /// ## Implementation Notes
    /// This description can be used to capture details such as why the activity
    /// definition was built, comments about misuse, instructions for clinical use
    /// and interpretation, literature references, examples from the paper world,
    /// etc. It is not a rendering of the activity definition as conveyed in the
    /// 'text' field of the resource itself. This item SHOULD be populated unless the
    /// information is available from context (e.g. the language of the activity
    /// definition is presumed to be the predominant language in the place the
    /// activity definition was created).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<Markdown>,
    /// The context that the content is intended to support
    ///
    /// The content was developed with a focus and intent of supporting the contexts
    /// that are listed. These contexts may be general categories (gender, age, ...)
    /// or may be references to specific programs (insurance plans, studies, ...) and
    /// may be used to assist with indexing and searching for appropriate activity
    /// definition instances.
    ///
    /// ## Requirements
    /// Assist in searching for appropriate content.
    ///
    /// ## Implementation Notes
    /// When multiple useContexts are specified, there is no expectation that all or
    /// any of the contexts apply.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "useContext")]
    pub use_context: Option<Vec<UsageContext>>,
    /// Intended jurisdiction for activity definition (if applicable)
    ///
    /// A legal or geographic region in which the activity definition is intended to
    /// be used.
    ///
    /// ## Implementation Notes
    /// It may be possible for the activity definition to be used in jurisdictions
    /// other than those for which it was originally designed or intended.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Countries and regions within which this artifact is targeted for use.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/jurisdiction
    pub jurisdiction: Option<Vec<CodeableConcept>>,
    /// Why this activity definition is defined
    ///
    /// Explanation of why this activity definition is needed and why it has been
    /// designed as it has.
    ///
    /// ## Implementation Notes
    /// This element does not describe the usage of the activity definition. Instead,
    /// it provides traceability of ''why'' the resource is either needed or ''why''
    /// it is defined as it is. This may be used to point to source materials or
    /// specifications that drove the structure of this activity definition.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub purpose: Option<Markdown>,
    /// Describes the clinical usage of the activity definition
    ///
    /// A detailed description of how the activity definition is used from a clinical
    /// perspective.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub usage: Option<String>,
    /// Use and/or publishing restrictions
    ///
    /// A copyright statement relating to the activity definition and/or its
    /// contents. Copyright statements are generally legal restrictions on the use
    /// and publishing of the activity definition.
    ///
    /// ## Requirements
    /// Consumers must be able to determine any legal restrictions on the use of the
    /// activity definition and/or its content.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// License, Restrictions
    pub copyright: Option<Markdown>,
    /// When the activity definition was approved by publisher
    ///
    /// The date on which the resource content was approved by the publisher.
    /// Approval happens once when the content is officially approved for usage.
    ///
    /// ## Implementation Notes
    /// The 'date' element may be more recent than the approval date because of minor
    /// changes or editorial corrections.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "approvalDate")]
    pub approval_date: Option<Date>,
    /// When the activity definition was last reviewed
    ///
    /// The date on which the resource content was last reviewed. Review happens
    /// periodically after approval but does not change the original approval date.
    ///
    /// ## Requirements
    /// Gives a sense of how "current" the content is. Resources that have not been
    /// reviewed in a long time may have a risk of being less appropriate/relevant.
    ///
    /// ## Implementation Notes
    /// If specified, this date follows the original approval date.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastReviewDate")]
    pub last_review_date: Option<Date>,
    /// When the activity definition is expected to be used
    ///
    /// The period during which the activity definition content was or is planned to
    /// be in active use.
    ///
    /// ## Requirements
    /// Allows establishing a transition before a resource comes into effect and also
    /// allows for a sunsetting process when new versions of the activity definition
    /// are or are expected to be used instead.
    ///
    /// ## Implementation Notes
    /// The effective period for a activity definition determines when the content is
    /// applicable for usage and is independent of publication and review dates. For
    /// example, a measure intended to be used for the year 2016 might be published
    /// in 2015.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "effectivePeriod")]
    pub effective_period: Option<Period>,
    /// E.g. Education, Treatment, Assessment, etc.
    ///
    /// Descriptive topics related to the content of the activity. Topics provide a
    /// high-level categorization of the activity that can be useful for filtering
    /// and searching.
    ///
    /// ## Requirements
    /// Repositories must be able to determine how to categorize the activity
    /// definition so that it can be found by topical searches.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: High-level categorization of the definition, used for searching, sorting, and filtering.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/definition-topic
    pub topic: Option<Vec<CodeableConcept>>,
    /// Who authored the content
    ///
    /// An individiual or organization primarily involved in the creation and
    /// maintenance of the content.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub author: Option<Vec<ContactDetail>>,
    /// Who edited the content
    ///
    /// An individual or organization primarily responsible for internal coherence of
    /// the content.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub editor: Option<Vec<ContactDetail>>,
    /// Who reviewed the content
    ///
    /// An individual or organization primarily responsible for review of some aspect
    /// of the content.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub reviewer: Option<Vec<ContactDetail>>,
    /// Who endorsed the content
    ///
    /// An individual or organization responsible for officially endorsing the
    /// content for use in some setting.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub endorser: Option<Vec<ContactDetail>>,
    /// Additional documentation, citations, etc.
    ///
    /// Related artifacts such as additional documentation, justification, or
    /// bibliographic references.
    ///
    /// ## Requirements
    /// Activity definitions must be able to provide enough information for consumers
    /// of the content (and/or interventions or results produced by the content) to
    /// be able to determine and understand the justification for and evidence in
    /// support of the content.
    ///
    /// ## Implementation Notes
    /// Each related artifact is either an attachment, or a reference to another
    /// resource, but not both.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "relatedArtifact")]
    pub related_artifact: Option<Vec<RelatedArtifact>>,
    /// Logic used by the activity definition
    ///
    /// A reference to a Library resource containing any formal logic used by the
    /// activity definition.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub library: Option<Vec<Canonical>>,
    /// Kind of resource
    ///
    /// A description of the kind of resource the activity definition is
    /// representing. For example, a MedicationRequest, a ServiceRequest, or a
    /// CommunicationRequest. Typically, but not always, this is a Request resource.
    ///
    /// ## Implementation Notes
    /// May determine what types of extensions are permitted.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The kind of activity the definition is describing.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/request-resource-types|4.0.1
    pub kind: Option<Code>,
    /// What profile the resource needs to conform to
    ///
    /// A profile to which the target of the activity definition is expected to
    /// conform.
    ///
    /// ## Requirements
    /// Allows profiles to be used to describe the types of activities that can be
    /// performed within a workflow, protocol, or order set.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub profile: Option<Canonical>,
    /// Detail type of activity
    ///
    /// Detailed description of the type of activity; e.g. What lab test, what
    /// procedure, what kind of encounter.
    ///
    /// ## Requirements
    /// Allows matching performed to planned as well as validation against protocols.
    ///
    /// ## Implementation Notes
    /// Tends to be less relevant for activities involving particular products.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Detailed type of the activity; e.g. CBC.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/procedure-code
    pub code: Option<CodeableConcept>,
    /// proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option
    ///
    /// Indicates the level of authority/intentionality associated with the activity
    /// and where the request should fit into the workflow chain.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Codes indicating the degree of authority/intentionality associated with a request.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/request-intent|4.0.1
    pub intent: Option<Code>,
    /// routine | urgent | asap | stat
    ///
    /// Indicates how quickly the activity should be addressed with respect to other
    /// requests.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Identifies the level of importance to be assigned to actioning the request.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/request-priority|4.0.1
    pub priority: Option<Code>,
    /// True if the activity should not be performed
    ///
    /// Set this to true if the definition is to indicate that a particular activity
    /// should NOT be performed. If true, this element should be interpreted to
    /// reinforce a negative coding. For example NPO as a code with a doNotPerform of
    /// true would still indicate to NOT perform the action.
    ///
    /// ## Implementation Notes
    /// This element is not intended to be used to communicate a decision support
    /// response to cancel an order in progress. That should be done with the
    /// "remove" type of a PlanDefinition or RequestGroup.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - If true this element negates the specified action. For Example,  instead of a request for a procedure, it is a request for the procedure to not occur.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "doNotPerform")]
    pub do_not_perform: Option<Boolean>,
    /// When activity is to occur
    ///
    /// The period, timing or frequency upon which the described activity is to
    /// occur.
    ///
    /// ## Requirements
    /// Allows prompting for activities and detection of missed planned activities.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub timing: Option<ActivityDefinitionTiming>,
    /// Where it should happen
    ///
    /// Identifies the facility where the activity will occur; e.g. home, hospital,
    /// specific clinic, etc.
    ///
    /// ## Requirements
    /// Helps in planning of activity.
    ///
    /// ## Implementation Notes
    /// May reference a specific clinical location or may just identify a type of
    /// location.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// facility
    pub location: Option<Reference>,
    /// Who should participate in the action
    ///
    /// Indicates who should participate in performing the action described.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub participant: Option<Vec<ActivityDefinitionParticipant>>,
    /// What's administered/supplied
    ///
    /// Identifies the food, drug or other product being consumed or supplied in the
    /// activity.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Code describing the type of substance or medication.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/medication-codes
    #[fhir_serde(flatten)]
    pub product: Option<ActivityDefinitionProduct>,
    /// How much is administered/consumed/supplied
    ///
    /// Identifies the quantity expected to be consumed at once (per dose, per meal,
    /// etc.).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// dose
    pub quantity: Option<Quantity>,
    /// Detailed dosage instructions
    ///
    /// Provides detailed dosage instructions in the same way that they are described
    /// for MedicationRequest resources.
    ///
    /// ## Implementation Notes
    /// If a dosage instruction is used, the definition should not specify timing or
    /// quantity.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub dosage: Option<Vec<Dosage>>,
    /// What part of body to perform on
    ///
    /// Indicates the sites on the subject's body where the procedure should be
    /// performed (I.e. the target sites).
    ///
    /// ## Requirements
    /// Knowing where the procedure is made is important for tracking if multiple
    /// sites are possible.
    ///
    /// ## Implementation Notes
    /// Only used if not implicit in the code found in ServiceRequest.type.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A code that identifies the anatomical location.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/body-site
    #[fhir_serde(rename = "bodySite")]
    pub body_site: Option<Vec<CodeableConcept>>,
    /// What specimens are required to perform this action
    ///
    /// Defines specimen requirements for the action to be performed, such as
    /// required specimens for a lab test.
    ///
    /// ## Requirements
    /// Needed to represent lab order definitions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "specimenRequirement")]
    pub specimen_requirement: Option<Vec<Reference>>,
    /// What observations are required to perform this action
    ///
    /// Defines observation requirements for the action to be performed, such as body
    /// weight or surface area.
    ///
    /// ## Requirements
    /// Needed to represent observation definitions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "observationRequirement")]
    pub observation_requirement: Option<Vec<Reference>>,
    /// What observations must be produced by this action
    ///
    /// Defines the observations that are expected to be produced by the action.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "observationResultRequirement")]
    pub observation_result_requirement: Option<Vec<Reference>>,
    /// Transform to apply the template
    ///
    /// A reference to a StructureMap resource that defines a transform that can be
    /// executed to produce the intent resource using the ActivityDefinition instance
    /// as the input.
    ///
    /// ## Implementation Notes
    /// Note that if both a transform and dynamic values are specified, the dynamic
    /// values will be applied to the result of the transform.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub transform: Option<Canonical>,
    /// Dynamic aspects of the definition
    ///
    /// Dynamic values that will be evaluated to produce values for elements of the
    /// resulting resource. For example, if the dosage of a medication must be
    /// computed based on the patient's weight, a dynamic value would be used to
    /// specify an expression that calculated the weight, and the path on the request
    /// resource that would contain the result.
    ///
    /// ## Implementation Notes
    /// Dynamic values are applied in the order in which they are defined in the
    /// ActivityDefinition. Note that if both a transform and dynamic values are
    /// specified, the dynamic values will be applied to the result of the transform.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "dynamicValue")]
    pub dynamic_value: Option<Vec<ActivityDefinitionDynamicValue>>,
}

/// Dynamic aspects of the definition
///
/// Dynamic values that will be evaluated to produce values for elements of the
/// resulting resource. For example, if the dosage of a medication must be
/// computed based on the patient's weight, a dynamic value would be used to
/// specify an expression that calculated the weight, and the path on the request
/// resource that would contain the result.
///
/// ## Implementation Notes
/// Dynamic values are applied in the order in which they are defined in the
/// ActivityDefinition. Note that if both a transform and dynamic values are
/// specified, the dynamic values will be applied to the result of the transform.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ActivityDefinitionDynamicValue {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// The path to the element to be set dynamically
    ///
    /// The path to the element to be customized. This is the path on the resource
    /// that will hold the result of the calculation defined by the expression. The
    /// specified path SHALL be a FHIRPath resolveable on the specified target type
    /// of the ActivityDefinition, and SHALL consist only of identifiers, constant
    /// indexers, and a restricted subset of functions. The path is allowed to
    /// contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to
    /// traverse multiple-cardinality sub-elements (see the [Simple FHIRPath
    /// Profile](fhirpath.html#simple) for full details).
    ///
    /// ## Implementation Notes
    /// The path attribute contains a [Simple FHIRPath Subset](fhirpath.html#simple)
    /// that allows path traversal, but not calculation.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub path: String,
    /// An expression that provides the dynamic value for the customization
    ///
    /// An expression specifying the value of the customized element.
    ///
    /// ## Implementation Notes
    /// The expression may be inlined, or may be a reference to a named expression
    /// within a logic library referenced by the library element.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub expression: Expression,
}

/// Information on the possible cause of the event
///
/// Information on the possible cause of the event.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AdverseEventSuspectEntityCausality {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Assessment of if the entity caused the event
    ///
    /// Assessment of if the entity caused the event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes for the assessment of whether the entity caused the event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-causality-assess
    pub assessment: Option<CodeableConcept>,
    /// AdverseEvent.suspectEntity.causalityProductRelatedness
    ///
    /// AdverseEvent.suspectEntity.causalityProductRelatedness.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "productRelatedness")]
    pub product_relatedness: Option<String>,
    /// AdverseEvent.suspectEntity.causalityAuthor
    ///
    /// AdverseEvent.suspectEntity.causalityAuthor.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub author: Option<Reference>,
    /// ProbabilityScale | Bayesian | Checklist
    ///
    /// ProbabilityScale | Bayesian | Checklist.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: TODO.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-causality-method
    pub method: Option<CodeableConcept>,
}

/// FHIR AdverseEvent type
///
/// Actual or potential/avoided event causing unintended physical injury
/// resulting from or contributed to by medical care, a research study or other
/// healthcare setting factors that requires additional monitoring, treatment, or
/// hospitalization, or that results in death.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [AdverseEvent](http://hl7.org/fhir/StructureDefinition/AdverseEvent)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AdverseEvent {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Business identifier for the event
    ///
    /// Business identifiers assigned to this adverse event by the performer or other
    /// systems which remain constant as the resource is updated and propagates from
    /// server to server.
    ///
    /// ## Requirements
    /// Allows identification of the adverse event as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Implementation Notes
    /// This is a business identifier, not a resource identifier (see
    /// [discussion](resource.html#identifiers)). It is best practice for the
    /// identifier to only appear on a single resource instance, however business
    /// practices may occasionally dictate that multiple resource instances with the
    /// same identifier can exist - possibly even with different resource types. For
    /// example, multiple Patient and a Person resource instance might share the same
    /// social insurance number.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Identifier>,
    /// actual | potential
    ///
    /// Whether the event actually happened, or just had the potential to. Note that
    /// this is independent of whether anyone was affected or harmed or how severely.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because it has a potential code that indicates the adverse event did not actually happen.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Overall nature of the adverse event, e.g. real or potential.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-actuality|4.0.1
    pub actuality: Code,
    /// product-problem | product-quality | product-use-error | wrong-dose | incorrect-prescribing-information | wrong-technique | wrong-route-of-administration | wrong-rate | wrong-duration | wrong-time | expired-drug | medical-device-use-error | problem-different-manufacturer | unsafe-physical-environment
    ///
    /// The overall type of event, intended for search and filtering purposes.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Overall categorization of the event, e.g. product-related or situational.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-category
    pub category: Option<Vec<CodeableConcept>>,
    /// Type of the event itself in relation to the subject
    ///
    /// This element defines the specific type of event that occurred or that was
    /// prevented from occurring.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Detailed type of event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-type
    pub event: Option<CodeableConcept>,
    /// Subject impacted by event
    ///
    /// This subject or group impacted by the event.
    ///
    /// ## Requirements
    /// Allows for exposure of biohazard (such as legionella) to a group of
    /// individuals in a hospital.
    ///
    /// ## Implementation Notes
    /// If AdverseEvent.resultingCondition differs among members of the group, then
    /// use Patient as the subject.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// patient
    pub subject: Reference,
    /// Encounter created as part of
    ///
    /// The Encounter during which AdverseEvent was created or to which the creation
    /// of this record is tightly associated.
    ///
    /// ## Implementation Notes
    /// This will typically be the encounter the event occurred within, but some
    /// activities may be initiated prior to or after the official completion of an
    /// encounter but still be tied to the context of the encounter. For example, if
    /// a medication administration was considered an adverse event because it
    /// resulted in a rash, then the encounter when the medication administration was
    /// given is the context. If the patient reports the AdverseEvent during a second
    /// encounter, that second encounter is not the context.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Reference>,
    /// When the event occurred
    ///
    /// The date (and perhaps time) when the adverse event occurred.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub date: Option<DateTime>,
    /// When the event was detected
    ///
    /// Estimated or actual date the AdverseEvent began, in the opinion of the
    /// reporter.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub detected: Option<DateTime>,
    /// When the event was recorded
    ///
    /// The date on which the existence of the AdverseEvent was first recorded.
    ///
    /// ## Implementation Notes
    /// The recordedDate represents the date when this particular AdverseEvent record
    /// was created in the system, not the date of the most recent update. The date
    /// of the last record modification can be retrieved from the resource metadata.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "recordedDate")]
    pub recorded_date: Option<DateTime>,
    /// Effect on the subject due to this event
    ///
    /// Includes information about the reaction that occurred as a result of exposure
    /// to a substance (for example, a drug or a chemical).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "resultingCondition")]
    pub resulting_condition: Option<Vec<Reference>>,
    /// Location where adverse event occurred
    ///
    /// The information about where the adverse event occurred.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub location: Option<Reference>,
    /// Seriousness of the event
    ///
    /// Assessment whether this event was of real importance.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Overall seriousness of this event for the patient.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-seriousness
    pub seriousness: Option<CodeableConcept>,
    /// mild | moderate | severe
    ///
    /// Describes the severity of the adverse event, in relation to the subject.
    /// Contrast to AdverseEvent.seriousness - a severe rash might not be serious,
    /// but a mild heart problem is.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The severity of the adverse event itself, in direct relation to the subject.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-severity|4.0.1
    pub severity: Option<CodeableConcept>,
    /// resolved | recovering | ongoing | resolvedWithSequelae | fatal | unknown
    ///
    /// Describes the type of outcome from the adverse event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: TODO (and should this be required?).
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-outcome|4.0.1
    pub outcome: Option<CodeableConcept>,
    /// Who recorded the adverse event
    ///
    /// Information on who recorded the adverse event. May be the patient or a
    /// practitioner.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub recorder: Option<Reference>,
    /// Who  was involved in the adverse event or the potential adverse event
    ///
    /// Parties that may or should contribute or have contributed information to the
    /// adverse event, which can consist of one or more activities. Such information
    /// includes information leading to the decision to perform the activity and how
    /// to perform the activity (e.g. consultant), information that the activity
    /// itself seeks to reveal (e.g. informant of clinical history), or information
    /// about what activity was performed (e.g. informant witness).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contributor: Option<Vec<Reference>>,
    /// The suspected agent causing the adverse event
    ///
    /// Describes the entity that is suspected to have caused the adverse event.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "suspectEntity")]
    pub suspect_entity: Option<Vec<AdverseEventSuspectEntity>>,
    /// AdverseEvent.subjectMedicalHistory
    ///
    /// AdverseEvent.subjectMedicalHistory.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "subjectMedicalHistory")]
    pub subject_medical_history: Option<Vec<Reference>>,
    /// AdverseEvent.referenceDocument
    ///
    /// AdverseEvent.referenceDocument.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "referenceDocument")]
    pub reference_document: Option<Vec<Reference>>,
    /// AdverseEvent.study
    ///
    /// AdverseEvent.study.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub study: Option<Vec<Reference>>,
}

/// The suspected agent causing the adverse event
///
/// Describes the entity that is suspected to have caused the adverse event.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AdverseEventSuspectEntity {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Refers to the specific entity that caused the adverse event
    ///
    /// Identifies the actual instance of what caused the adverse event. May be a
    /// substance, medication, medication administration, medication statement or a
    /// device.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Substance or Medication or Device
    pub instance: Reference,
    /// Information on the possible cause of the event
    ///
    /// Information on the possible cause of the event.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub causality: Option<Vec<AdverseEventSuspectEntityCausality>>,
}

/// Choice of types for the onset\[x\] field in AllergyIntolerance
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "onset")]
pub enum AllergyIntoleranceOnset {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "onsetDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Age type.
    #[fhir_serde(rename = "onsetAge")]
    Age(Age),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "onsetPeriod")]
    Period(Period),
    /// Variant accepting the Range type.
    #[fhir_serde(rename = "onsetRange")]
    Range(Range),
    /// Variant accepting the String type.
    #[fhir_serde(rename = "onsetString")]
    String(String),
}

/// FHIR AllergyIntolerance type
///
/// Risk of harmful or undesirable, physiological response which is unique to an
/// individual and associated with exposure to a substance.
///
/// ## Purpose
/// To record a clinical assessment of a propensity, or potential risk to an individual, of an adverse reaction upon future exposure to the specified substance, or class of substance.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [AllergyIntolerance](http://hl7.org/fhir/StructureDefinition/AllergyIntolerance)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "onset")]
pub struct AllergyIntolerance {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External ids for this item
    ///
    /// Business identifiers assigned to this AllergyIntolerance by the performer or
    /// other systems which remain constant as the resource is updated and propagates
    /// from server to server.
    ///
    /// ## Requirements
    /// Allows identification of the AllergyIntolerance as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Implementation Notes
    /// This is a business identifier, not a resource identifier (see
    /// [discussion](resource.html#identifiers)). It is best practice for the
    /// identifier to only appear on a single resource instance, however business
    /// practices may occasionally dictate that multiple resource instances with the
    /// same identifier can exist - possibly even with different resource types. For
    /// example, multiple Patient and a Person resource instance might share the same
    /// social insurance number.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// active | inactive | resolved
    ///
    /// The clinical status of the allergy or intolerance.
    ///
    /// ## Implementation Notes
    /// Refer to [discussion](extensibility.html#Special-Case) if clincalStatus is
    /// missing data.
    /// The data type is CodeableConcept because clinicalStatus has some clinical
    /// judgment involved, such that there might need to be more specificity than the
    /// required FHIR value set allows. For example, a SNOMED coding might allow for
    /// additional specificity.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the status contains the codes inactive and resolved that mark the AllergyIntolerance as no longer active.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The clinical status of the allergy or intolerance.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergyintolerance-clinical|4.0.1
    ///
    /// ## Conditions
    /// Used when: ait-1, ait-2
    #[fhir_serde(rename = "clinicalStatus")]
    pub clinical_status: Option<CodeableConcept>,
    /// unconfirmed | confirmed | refuted | entered-in-error
    ///
    /// Assertion about certainty associated with the propensity, or potential risk,
    /// of a reaction to the identified substance (including pharmaceutical product).
    ///
    /// ## Implementation Notes
    /// The data type is CodeableConcept because verificationStatus has some clinical
    /// judgment involved, such that there might need to be more specificity than the
    /// required FHIR value set allows. For example, a SNOMED coding might allow for
    /// additional specificity.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the status contains the codes refuted and entered-in-error that mark the AllergyIntolerance as not currently valid.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Assertion about certainty associated with a propensity, or potential risk, of a reaction to the identified substance.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergyintolerance-verification|4.0.1
    ///
    /// ## Conditions
    /// Used when: ait-1, ait-2
    #[fhir_serde(rename = "verificationStatus")]
    pub verification_status: Option<CodeableConcept>,
    /// allergy | intolerance - Underlying mechanism (if known)
    ///
    /// Identification of the underlying physiological mechanism for the reaction
    /// risk.
    ///
    /// ## Implementation Notes
    /// Allergic (typically immune-mediated) reactions have been traditionally
    /// regarded as an indicator for potential escalation to significant future risk.
    /// Contemporary knowledge suggests that some reactions previously thought to be
    /// immune-mediated are, in fact, non-immune, but in some cases can still pose a
    /// life threatening risk. It is acknowledged that many clinicians might not be
    /// in a position to distinguish the mechanism of a particular reaction. Often
    /// the term "allergy" is used rather generically and may overlap with the use of
    /// "intolerance" - in practice the boundaries between these two concepts might
    /// not be well-defined or understood. This data element is included
    /// nevertheless, because many legacy systems have captured this attribute.
    /// Immunologic testing may provide supporting evidence for the basis of the
    /// reaction and the causative substance, but no tests are 100% sensitive or
    /// specific for sensitivity to a particular substance. If, as is commonly the
    /// case, it is unclear whether the reaction is due to an allergy or an
    /// intolerance, then the type element should be omitted from the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Identification of the underlying physiological mechanism for a Reaction Risk.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergy-intolerance-type|4.0.1
    ///
    /// ## Aliases
    /// Category, Class
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Code>,
    /// food | medication | environment | biologic
    ///
    /// Category of the identified substance.
    ///
    /// ## Implementation Notes
    /// This data element has been included because it is currently being captured in
    /// some clinical systems. This data can be derived from the substance where
    /// coding systems are used, and is effectively redundant in that situation. When
    /// searching on category, consider the implications of AllergyIntolerance
    /// resources without a category. For example, when searching on category =
    /// medication, medication allergies that don't have a category valued will not
    /// be returned. Refer to [search](search.html) for more information on how to
    /// search category with a :missing modifier to get allergies that don't have a
    /// category. Additionally, category should be used with caution because category
    /// can be subjective based on the sender.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Category of an identified substance associated with allergies or intolerances.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergy-intolerance-category|4.0.1
    ///
    /// ## Aliases
    /// Category, Type, Reaction Type, Class
    pub category: Option<Vec<Code>>,
    /// low | high | unable-to-assess
    ///
    /// Estimate of the potential clinical harm, or seriousness, of the reaction to
    /// the identified substance.
    ///
    /// ## Implementation Notes
    /// The default criticality value for any propensity to an adverse reaction
    /// should be 'Low Risk', indicating at the very least a relative
    /// contraindication to deliberate or voluntary exposure to the substance. 'High
    /// Risk' is flagged if the clinician has identified a propensity for a more
    /// serious or potentially life-threatening reaction, such as anaphylaxis, and
    /// implies an absolute contraindication to deliberate or voluntary exposure to
    /// the substance. If this element is missing, the criticality is unknown (though
    /// it may be known elsewhere). Systems that capture a severity at the condition
    /// level are actually representing the concept of criticality whereas the
    /// severity documented at the reaction level is representing the true reaction
    /// severity. Existing systems that are capturing both condition criticality and
    /// reaction severity may use the term "severity" to represent both. Criticality
    /// is the worst it could be in the future (i.e. situation-agnostic) whereas
    /// severity is situation-dependent.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Estimate of the potential clinical harm, or seriousness, of a reaction to an identified substance.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergy-intolerance-criticality|4.0.1
    ///
    /// ## Aliases
    /// Severity, Seriousness, Contra-indication, Risk
    pub criticality: Option<Code>,
    /// Code that identifies the allergy or intolerance
    ///
    /// Code for an allergy or intolerance statement (either a positive or a
    /// negated/excluded statement). This may be a code for a substance or
    /// pharmaceutical product that is considered to be responsible for the adverse
    /// reaction risk (e.g., "Latex"), an allergy or intolerance condition (e.g.,
    /// "Latex allergy"), or a negated/excluded code for a specific substance or
    /// class (e.g., "No latex allergy") or a general or categorical negated
    /// statement (e.g., "No known allergy", "No known drug allergies"). Note: the
    /// substance for a specific reaction may be different from the substance
    /// identified as the cause of the risk, but it must be consistent with it. For
    /// instance, it may be a more specific substance (e.g. a brand medication) or a
    /// composite product that includes the identified substance. It must be
    /// clinically safe to only process the 'code' and ignore the
    /// 'reaction.substance'. If a receiving system is unable to confirm that
    /// AllergyIntolerance.reaction.substance falls within the semantic scope of
    /// AllergyIntolerance.code, then the receiving system should ignore
    /// AllergyIntolerance.reaction.substance.
    ///
    /// ## Implementation Notes
    /// It is strongly recommended that this element be populated using a
    /// terminology, where possible. For example, some terminologies used include
    /// RxNorm, SNOMED CT, DM+D, NDFRT, ICD-9, IDC-10, UNII, and ATC. Plain text
    /// should only be used if there is no appropriate terminology available.
    /// Additional details can be specified in the text.
    ///
    /// When a substance or product code is specified for the 'code' element, the
    /// "default" semantic context is that this is a positive statement of an allergy
    /// or intolerance (depending on the value of the 'type' element, if present)
    /// condition to the specified substance/product. In the corresponding SNOMED CT
    /// allergy model, the specified substance/product is the target (destination) of
    /// the "Causative agent" relationship.
    ///
    /// The 'substanceExposureRisk' extension is available as a structured and more
    /// flexible alternative to the 'code' element for making positive or negative
    /// allergy or intolerance statements. This extension provides the capability to
    /// make "no known allergy" (or "no risk of adverse reaction") statements
    /// regarding any coded substance/product (including cases when a pre-coordinated
    /// "no allergy to x" concept for that substance/product does not exist). If the
    /// 'substanceExposureRisk' extension is present, the AllergyIntolerance.code
    /// element SHALL be omitted.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Type of the substance/product, allergy or intolerance condition, or negation/exclusion codes for reporting no known allergies.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergyintolerance-code
    ///
    /// ## Aliases
    /// Code
    pub code: Option<CodeableConcept>,
    /// Who the sensitivity is for
    ///
    /// The patient who has the allergy or intolerance.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Patient
    pub patient: Reference,
    /// Encounter when the allergy or intolerance was asserted
    ///
    /// The encounter when the allergy or intolerance was asserted.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Reference>,
    /// When allergy or intolerance was identified
    ///
    /// Estimated or actual date, date-time, or age when allergy or intolerance was
    /// identified.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub onset: Option<AllergyIntoleranceOnset>,
    /// Date first version of the resource instance was recorded
    ///
    /// The recordedDate represents when this particular AllergyIntolerance record
    /// was created in the system, which is often a system-generated date.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "recordedDate")]
    pub recorded_date: Option<DateTime>,
    /// Who recorded the sensitivity
    ///
    /// Individual who recorded the record and takes responsibility for its content.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Author
    pub recorder: Option<Reference>,
    /// Source of the information about the allergy
    ///
    /// The source of the information about the allergy that is recorded.
    ///
    /// ## Implementation Notes
    /// The recorder takes responsibility for the content, but can reference the
    /// source from where they got it.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Source, Informant
    pub asserter: Option<Reference>,
    /// Date(/time) of last known occurrence of a reaction
    ///
    /// Represents the date and/or time of the last known occurrence of a reaction
    /// event.
    ///
    /// ## Implementation Notes
    /// This date may be replicated by one of the Onset of Reaction dates. Where a
    /// textual representation of the date of last occurrence is required e.g. 'In
    /// Childhood, '10 years ago' the Comment element should be used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastOccurrence")]
    pub last_occurrence: Option<DateTime>,
    /// Additional text not captured in other fields
    ///
    /// Additional narrative about the propensity for the Adverse Reaction, not
    /// captured in other fields.
    ///
    /// ## Implementation Notes
    /// For example: including reason for flagging a seriousness of 'High Risk'; and
    /// instructions related to future exposure or administration of the substance,
    /// such as administration within an Intensive Care Unit or under corticosteroid
    /// cover. The notes should be related to an allergy or intolerance as a
    /// condition in general and not related to any particular episode of it. For
    /// episode notes and descriptions, use AllergyIntolerance.event.description and
    /// AllergyIntolerance.event.notes.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
    /// Adverse Reaction Events linked to exposure to substance
    ///
    /// Details about each adverse reaction event linked to exposure to the
    /// identified substance.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub reaction: Option<Vec<AllergyIntoleranceReaction>>,
}

/// Adverse Reaction Events linked to exposure to substance
///
/// Details about each adverse reaction event linked to exposure to the
/// identified substance.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AllergyIntoleranceReaction {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Specific substance or pharmaceutical product considered to be responsible for event
    ///
    /// Identification of the specific substance (or pharmaceutical product)
    /// considered to be responsible for the Adverse Reaction event. Note: the
    /// substance for a specific reaction may be different from the substance
    /// identified as the cause of the risk, but it must be consistent with it. For
    /// instance, it may be a more specific substance (e.g. a brand medication) or a
    /// composite product that includes the identified substance. It must be
    /// clinically safe to only process the 'code' and ignore the
    /// 'reaction.substance'. If a receiving system is unable to confirm that
    /// AllergyIntolerance.reaction.substance falls within the semantic scope of
    /// AllergyIntolerance.code, then the receiving system should ignore
    /// AllergyIntolerance.reaction.substance.
    ///
    /// ## Implementation Notes
    /// Coding of the specific substance (or pharmaceutical product) with a
    /// terminology capable of triggering decision support should be used wherever
    /// possible. The 'code' element allows for the use of a specific substance or
    /// pharmaceutical product, or a group or class of substances. In the case of an
    /// allergy or intolerance to a class of substances, (for example,
    /// "penicillins"), the 'reaction.substance' element could be used to code the
    /// specific substance that was identified as having caused the reaction (for
    /// example, "amoxycillin"). Duplication of the value in the 'code' and
    /// 'reaction.substance' elements is acceptable when a specific substance has
    /// been recorded in 'code'.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes defining the type of the substance (including pharmaceutical products).
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/substance-code
    pub substance: Option<CodeableConcept>,
    /// Clinical symptoms/signs associated with the Event
    ///
    /// Clinical symptoms and/or signs that are observed or associated with the
    /// adverse reaction event.
    ///
    /// ## Implementation Notes
    /// Manifestation can be expressed as a single word, phrase or brief description.
    /// For example: nausea, rash or no reaction. It is preferable that manifestation
    /// should be coded with a terminology, where possible. The values entered here
    /// may be used to display on an application screen as part of a list of adverse
    /// reactions, as recommended in the UK NHS CUI guidelines. Terminologies
    /// commonly used include, but are not limited to, SNOMED CT or ICD10.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Clinical symptoms and/or signs that are observed or associated with an Adverse Reaction Event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/clinical-findings
    ///
    /// ## Aliases
    /// Symptoms, Signs
    pub manifestation: Option<Vec<CodeableConcept>>,
    /// Description of the event as a whole
    ///
    /// Text description about the reaction as a whole, including details of the
    /// manifestation if required.
    ///
    /// ## Implementation Notes
    /// Use the description to provide any details of a particular event of the
    /// occurred reaction such as circumstances, reaction specifics, what happened
    /// before/after. Information, related to the event, but not describing a
    /// particular care should be captured in the comment field. For example: at the
    /// age of four, the patient was given penicillin for strep throat and
    /// subsequently developed severe hives.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Narrative, Text
    pub description: Option<String>,
    /// Date(/time) when manifestations showed
    ///
    /// Record of the date and/or time of the onset of the Reaction.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub onset: Option<DateTime>,
    /// mild | moderate | severe (of event as a whole)
    ///
    /// Clinical assessment of the severity of the reaction event as a whole,
    /// potentially considering multiple different manifestations.
    ///
    /// ## Implementation Notes
    /// It is acknowledged that this assessment is very subjective. There may be some
    /// specific practice domains where objective scales have been applied. Objective
    /// scales can be included in this model as extensions.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Clinical assessment of the severity of a reaction event as a whole, potentially considering multiple different manifestations.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/reaction-event-severity|4.0.1
    pub severity: Option<Code>,
    /// How the subject was exposed to the substance
    ///
    /// Identification of the route by which the subject was exposed to the
    /// substance.
    ///
    /// ## Implementation Notes
    /// Coding of the route of exposure with a terminology should be used wherever
    /// possible.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A coded concept describing the route or physiological path of administration of a therapeutic agent into or onto the body of a subject.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/route-codes
    #[fhir_serde(rename = "exposureRoute")]
    pub exposure_route: Option<CodeableConcept>,
    /// Text about event not captured in other fields
    ///
    /// Additional text about the adverse reaction event not captured in other
    /// fields.
    ///
    /// ## Implementation Notes
    /// Use this field to record information indirectly related to a particular event
    /// and not captured in the description. For example: Clinical records are no
    /// longer available, recorded based on information provided to the patient by
    /// her mother and her mother is deceased.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
}

/// FHIR Appointment type
///
/// A booking of a healthcare event among patient(s), practitioner(s), related
/// person(s) and/or device(s) for a specific date/time. This may result in one
/// or more Encounter(s).
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [Appointment](http://hl7.org/fhir/StructureDefinition/Appointment)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Appointment {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External Ids for this item
    ///
    /// This records identifiers associated with this appointment concern that are
    /// defined by business processes and/or used to refer to it when a direct URL
    /// reference to the resource itself is not appropriate (e.g. in CDA documents,
    /// or in written / printed documentation).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// proposed | pending | booked | arrived | fulfilled | cancelled | noshow | entered-in-error | checked-in | waitlist
    ///
    /// The overall status of the Appointment. Each of the participants has their own
    /// participation status which indicates their involvement in the process,
    /// however this status indicates the shared status.
    ///
    /// ## Implementation Notes
    /// If the Appointment's status is "cancelled" then all participants are expected
    /// to have their calendars released for the appointment period, and as such any
    /// Slots that were marked as BUSY can be re-set to FREE.
    ///
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that mark the Appointment as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The free/busy status of an appointment.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/appointmentstatus|4.0.1
    pub status: Code,
    /// The coded reason for the appointment being cancelled
    ///
    /// The coded reason for the appointment being cancelled. This is often used in
    /// reporting/billing/futher processing to determine if further actions are
    /// required, or specific fees apply.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/appointment-cancellation-reason
    #[fhir_serde(rename = "cancelationReason")]
    pub cancelation_reason: Option<CodeableConcept>,
    /// A broad categorization of the service that is to be performed during this appointment
    ///
    /// A broad categorization of the service that is to be performed during this
    /// appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-category
    #[fhir_serde(rename = "serviceCategory")]
    pub service_category: Option<Vec<CodeableConcept>>,
    /// The specific service that is to be performed during this appointment
    ///
    /// The specific service that is to be performed during this appointment.
    ///
    /// ## Implementation Notes
    /// For a provider to provider appointment the code "FOLLOWUP" may be
    /// appropriate, as this is expected to be discussing some patient that was seen
    /// in the past.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-type
    #[fhir_serde(rename = "serviceType")]
    pub service_type: Option<Vec<CodeableConcept>>,
    /// The specialty of a practitioner that would be required to perform the service requested in this appointment
    ///
    /// The specialty of a practitioner that would be required to perform the service
    /// requested in this appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/c80-practice-codes
    pub specialty: Option<Vec<CodeableConcept>>,
    /// The style of appointment or patient that has been booked in the slot (not service type)
    ///
    /// The style of appointment or patient that has been booked in the slot (not
    /// service type).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/v2-0276
    #[fhir_serde(rename = "appointmentType")]
    pub appointment_type: Option<CodeableConcept>,
    /// Coded reason this appointment is scheduled
    ///
    /// The coded reason that this appointment is being scheduled. This is more
    /// clinical than administrative.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: The Reason for the appointment to take place.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/encounter-reason
    #[fhir_serde(rename = "reasonCode")]
    pub reason_code: Option<Vec<CodeableConcept>>,
    /// Reason the appointment is to take place (resource)
    ///
    /// Reason the appointment has been scheduled to take place, as specified using
    /// information from another resource. When the patient arrives and the encounter
    /// begins it may be used as the admission diagnosis. The indication will
    /// typically be a Condition (with other resources referenced in the
    /// evidence.detail), or a Procedure.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "reasonReference")]
    pub reason_reference: Option<Vec<Reference>>,
    /// Used to make informed decisions if needing to re-prioritize
    ///
    /// The priority of the appointment. Can be used to make informed decisions if
    /// needing to re-prioritize appointments. (The iCal Standard specifies 0 as
    /// undefined, 1 as highest, 9 as lowest priority).
    ///
    /// ## Implementation Notes
    /// Seeking implementer feedback on this property and how interoperable it is.
    ///
    /// Using an extension to record a CodeableConcept for named values may be tested
    /// at a future connectathon.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub priority: Option<UnsignedInt>,
    /// Shown on a subject line in a meeting request, or appointment list
    ///
    /// The brief description of the appointment as would be shown on a subject line
    /// in a meeting request, or appointment list. Detailed or expanded information
    /// should be put in the comment field.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Additional information to support the appointment
    ///
    /// Additional information to support the appointment provided when making the
    /// appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportingInformation")]
    pub supporting_information: Option<Vec<Reference>>,
    /// When appointment is to take place
    ///
    /// Date/Time that the appointment is to take place.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub start: Option<Instant>,
    /// When appointment is to conclude
    ///
    /// Date/Time that the appointment is to conclude.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub end: Option<Instant>,
    /// Can be less than start/end (e.g. estimate)
    ///
    /// Number of minutes that the appointment is to take. This can be less than the
    /// duration between the start and end times. For example, where the actual time
    /// of appointment is only an estimate or if a 30 minute appointment is being
    /// requested, but any time would work. Also, if there is, for example, a planned
    /// 15 minute break in the middle of a long appointment, the duration may be 15
    /// minutes less than the difference between the start and end.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "minutesDuration")]
    pub minutes_duration: Option<PositiveInt>,
    /// The slots that this appointment is filling
    ///
    /// The slots from the participants' schedules that will be filled by the
    /// appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub slot: Option<Vec<Reference>>,
    /// The date that this appointment was initially created
    ///
    /// The date that this appointment was initially created. This could be different
    /// to the meta.lastModified value on the initial entry, as this could have been
    /// before the resource was created on the FHIR server, and should remain
    /// unchanged over the lifespan of the appointment.
    ///
    /// ## Implementation Notes
    /// This property is required for many use cases where the age of an appointment
    /// is considered in processing workflows for scheduling and billing of
    /// appointments.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub created: Option<DateTime>,
    /// Additional comments
    ///
    /// Additional comments about the appointment.
    ///
    /// ## Implementation Notes
    /// Additional text to aid in facilitating the appointment. For instance, a
    /// comment might be, "patient should proceed immediately to infusion room upon
    /// arrival"
    ///
    /// Where this is a planned appointment and the start/end dates are not set then
    /// this field can be used to provide additional guidance on the details of the
    /// appointment request, including any restrictions on when to book it.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub comment: Option<String>,
    /// Detailed information and instructions for the patient
    ///
    /// While Appointment.comment contains information for internal use,
    /// Appointment.patientInstructions is used to capture patient facing information
    /// about the Appointment (e.g. please bring your referral or fast from 8pm night
    /// before).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "patientInstruction")]
    pub patient_instruction: Option<String>,
    /// The service request this appointment is allocated to assess
    ///
    /// The service request this appointment is allocated to assess (e.g. incoming
    /// referral or procedure request).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// incomingReferral
    #[fhir_serde(rename = "basedOn")]
    pub based_on: Option<Vec<Reference>>,
    /// Participants involved in appointment
    ///
    /// List of participants involved in the appointment.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **app-1**: Either the type or actor on the participant SHALL be specified (error)
    ///   Expression: `type.exists() or actor.exists()`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub participant: Option<Vec<AppointmentParticipant>>,
    /// Potential date/time interval(s) requested to allocate the appointment within
    ///
    /// A set of date ranges (potentially including times) that the appointment is
    /// preferred to be scheduled within.
    ///
    /// The duration (usually in minutes) could also be provided to indicate the
    /// length of the appointment to fill and populate the start/end times for the
    /// actual allocated time. However, in other situations the duration may be
    /// calculated by the scheduling system.
    ///
    /// ## Implementation Notes
    /// This does not introduce a capacity for recurring appointments.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "requestedPeriod")]
    pub requested_period: Option<Vec<Period>>,
}

/// Participants involved in appointment
///
/// List of participants involved in the appointment.
///
/// ## Cardinality: Required, Multiple (1..*)
///
/// ## Constraints
/// - **app-1**: Either the type or actor on the participant SHALL be specified (error)
///   Expression: `type.exists() or actor.exists()`
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AppointmentParticipant {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Role of participant in the appointment
    ///
    /// Role of participant in the appointment.
    ///
    /// ## Implementation Notes
    /// The role of the participant can be used to declare what the actor will be
    /// doing in the scope of this appointment.
    ///
    /// If the actor is not specified, then it is expected that the actor will be
    /// filled in at a later stage of planning.
    ///
    /// This value SHALL be the same when creating an AppointmentResponse so that
    /// they can be matched, and subsequently update the Appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Role of participant in encounter.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/encounter-participant-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Vec<CodeableConcept>>,
    /// Person, Location/HealthcareService or Device
    ///
    /// A Person, Location/HealthcareService or Device that is participating in the
    /// appointment.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub actor: Option<Reference>,
    /// required | optional | information-only
    ///
    /// Whether this participant is required to be present at the meeting. This
    /// covers a use-case where two doctors need to meet to discuss the results for a
    /// specific patient, and the patient is not required to be present.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Is the Participant required to attend the appointment.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/participantrequired|4.0.1
    pub required: Option<Code>,
    /// accepted | declined | tentative | needs-action
    ///
    /// Participation status of the actor.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The Participation status of an appointment.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/participationstatus|4.0.1
    pub status: Code,
    /// Participation period of the actor
    ///
    /// Participation period of the actor.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub period: Option<Period>,
}

/// FHIR AppointmentResponse type
///
/// A reply to an appointment request for a patient and/or practitioner(s), such
/// as a confirmation or rejection.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [AppointmentResponse](http://hl7.org/fhir/StructureDefinition/AppointmentResponse)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AppointmentResponse {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External Ids for this item
    ///
    /// This records identifiers associated with this appointment response concern
    /// that are defined by business processes and/ or used to refer to it when a
    /// direct URL reference to the resource itself is not appropriate.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Appointment this response relates to
    ///
    /// Appointment that this response is replying to.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub appointment: Reference,
    /// Time from appointment, or requested new start time
    ///
    /// Date/Time that the appointment is to take place, or requested new start time.
    ///
    /// ## Implementation Notes
    /// This may be either the same as the appointment request to confirm the details
    /// of the appointment, or alternately a new time to request a re-negotiation of
    /// the start time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub start: Option<Instant>,
    /// Time from appointment, or requested new end time
    ///
    /// This may be either the same as the appointment request to confirm the details
    /// of the appointment, or alternately a new time to request a re-negotiation of
    /// the end time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub end: Option<Instant>,
    /// Role of participant in the appointment
    ///
    /// Role of participant in the appointment.
    ///
    /// ## Implementation Notes
    /// The role of the participant can be used to declare what the actor will be
    /// doing in the scope of the referenced appointment.
    ///
    /// If the actor is not specified, then it is expected that the actor will be
    /// filled in at a later stage of planning.
    ///
    /// This value SHALL be the same as specified on the referenced Appointment so
    /// that they can be matched, and subsequently updated.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Role of participant in encounter.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/encounter-participant-type
    #[fhir_serde(rename = "participantType")]
    pub participant_type: Option<Vec<CodeableConcept>>,
    /// Person, Location, HealthcareService, or Device
    ///
    /// A Person, Location, HealthcareService, or Device that is participating in the
    /// appointment.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub actor: Option<Reference>,
    /// accepted | declined | tentative | needs-action
    ///
    /// Participation status of the participant. When the status is declined or
    /// tentative if the start/end times are different to the appointment, then these
    /// times should be interpreted as a requested time change. When the status is
    /// accepted, the times can either be the time of the appointment (as a
    /// confirmation of the time) or can be empty.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that marks the participant as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - Not known why this is labelled a modifier
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The Participation status of an appointment.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/participationstatus|4.0.1
    #[fhir_serde(rename = "participantStatus")]
    pub participant_status: Code,
    /// Additional comments
    ///
    /// Additional comments about the appointment.
    ///
    /// ## Implementation Notes
    /// This comment is particularly important when the responder is declining,
    /// tentatively accepting or requesting another time to indicate the reasons why.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub comment: Option<String>,
}

/// Choice of types for the value\[x\] field in AuditEventEntityDetail
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "value")]
pub enum AuditEventEntityDetailValue {
    /// Variant accepting the String type.
    #[fhir_serde(rename = "valueString")]
    String(String),
    /// Variant accepting the Base64Binary type.
    #[fhir_serde(rename = "valueBase64Binary")]
    Base64Binary(Base64Binary),
}

/// Additional Information about the entity
///
/// Tagged value pairs for conveying additional information about the entity.
///
/// ## Requirements
/// Implementation-defined data about specific details of the object accessed or
/// used.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "value")]
pub struct AuditEventEntityDetail {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Name of the property
    ///
    /// The type of extra detail provided in the value.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "type")]
    pub r#type: String,
    /// Property value
    ///
    /// The  value of the extra detail.
    ///
    /// ## Requirements
    /// Should not duplicate the entity value unless absolutely necessary.
    ///
    /// ## Implementation Notes
    /// The value can be string when known to be a string, else base64 encoding
    /// should be used to protect binary or undefined content. The meaning and
    /// secondary-encoding of the content of base64 encoded blob is specific to the
    /// AuditEvent.type, AuditEvent.subtype, AuditEvent.entity.type, and
    /// AuditEvent.entity.role. The base64 is a general-use and safe container for
    /// event specific data blobs regardless of the encoding used by the transaction
    /// being recorded. An AuditEvent consuming application must understand the event
    /// it is consuming and the formats used by the event. For example if auditing an
    /// Oracle network database access, the Oracle formats must be understood as they
    /// will be simply encoded in the base64binary blob.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub value: Option<AuditEventEntityDetailValue>,
}

/// Logical network location for application activity
///
/// Logical network location for application activity, if the activity has a
/// network location.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AuditEventAgentNetwork {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Identifier for the network access point of the user device
    ///
    /// An identifier for the network access point of the user device for the audit
    /// event.
    ///
    /// ## Requirements
    /// This datum identifies the user's network access point, which may be distinct
    /// from the server that performed the action. It is an optional value that may
    /// be used to group events recorded on separate servers for analysis of a
    /// specific network access point's data access across all servers.
    ///
    /// ## Implementation Notes
    /// This could be a device id, IP address or some other identifier associated
    /// with a device.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub address: Option<String>,
    /// The type of network access point
    ///
    /// An identifier for the type of network access point that originated the audit
    /// event.
    ///
    /// ## Requirements
    /// This datum identifies the type of network access point identifier of the user
    /// device for the audit event. It is an optional value that may be used to group
    /// events recorded on separate servers for analysis of access according to a
    /// network access point's type.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The type of network access point of this agent in the audit event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/network-type|4.0.1
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Code>,
}

/// Actor involved in the event
///
/// An actor taking an active role in the event or activity that is logged.
///
/// ## Requirements
/// An agent can be a person, an organization, software, device, or other actors
/// that may be ascribed responsibility.
///
/// ## Implementation Notes
/// Several agents may be associated (i.e. have some responsibility for an
/// activity) with an event or activity.
///
/// For example, an activity may be initiated by one user for other users or
/// involve more than one user. However, only one user may be the
/// initiator/requestor for the activity.
///
/// ## Cardinality: Required, Multiple (1..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Aliases
/// ActiveParticipant
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AuditEventAgent {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// How agent participated
    ///
    /// Specification of the participation type the user plays when performing the
    /// event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: The Participation type of the agent to the event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/participation-role-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<CodeableConcept>,
    /// Agent role in the event
    ///
    /// The security role that the user was acting under, that come from local codes
    /// defined by the access control security system (e.g. RBAC, ABAC) used in the
    /// local context.
    ///
    /// ## Requirements
    /// This value ties an audited event to a user's role(s). It is an optional value
    /// that might be used to group events for analysis by user functional role
    /// categories.
    ///
    /// ## Implementation Notes
    /// Should be roles relevant to the event. Should not be an exhaustive list of
    /// roles.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: What security role enabled the agent to participate in the event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/security-role-type
    pub role: Option<Vec<CodeableConcept>>,
    /// Identifier of who
    ///
    /// Reference to who this agent is that was involved in the event.
    ///
    /// ## Requirements
    /// This field ties an audit event to a specific resource or identifier.
    ///
    /// ## Implementation Notes
    /// Where a User ID is available it will go into who.identifier.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// userId
    pub who: Option<Reference>,
    /// Alternative User identity
    ///
    /// Alternative agent Identifier. For a human, this should be a user identifier
    /// text string from authentication system. This identifier would be one known to
    /// a common authentication system (e.g. single sign-on), if available.
    ///
    /// ## Requirements
    /// In some situations, a human user may authenticate with one identity but, to
    /// access a specific application system, may use a synonymous identify. For
    /// example, some "single sign on" implementations will do this. The alternative
    /// identifier would then be the original identify used for authentication, and
    /// the User ID is the one known to and used by the application.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "altId")]
    pub alt_id: Option<String>,
    /// Human friendly name for the agent
    ///
    /// Human-meaningful name for the agent.
    ///
    /// ## Requirements
    /// The User ID and Authorization User ID may be internal or otherwise obscure
    /// values. This field assists the auditor in identifying the actual user.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub name: Option<String>,
    /// Whether user is initiator
    ///
    /// Indicator that the user is or is not the requestor, or initiator, for the
    /// event being audited.
    ///
    /// ## Requirements
    /// This value is used to distinguish between requestor-users and
    /// recipient-users. For example, one person may initiate a report-output to be
    /// sent to another user.
    ///
    /// ## Implementation Notes
    /// There can only be one initiator. If the initiator is not clear, then do not
    /// choose any one agent as the initiator.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub requestor: Boolean,
    /// Where
    ///
    /// Where the event occurred.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub location: Option<Reference>,
    /// Policy that authorized event
    ///
    /// The policy or plan that authorized the activity being recorded. Typically, a
    /// single activity may have multiple applicable policies, such as patient
    /// consent, guarantor funding, etc. The policy would also indicate the security
    /// token used.
    ///
    /// ## Requirements
    /// This value is used retrospectively to determine the authorization policies.
    ///
    /// ## Implementation Notes
    /// For example: Where an OAuth token authorizes, the unique identifier from the
    /// OAuth token is placed into the policy element Where a policy engine (e.g.
    /// XACML) holds policy logic, the unique policy identifier is placed into the
    /// policy element.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub policy: Option<Vec<Uri>>,
    /// Type of media
    ///
    /// Type of media involved. Used when the event is about exporting/importing onto
    /// media.
    ///
    /// ## Requirements
    /// Usually, this is used instead of specifying a network address. This field is
    /// not used for Media Id (i.e. the serial number of a CD).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Used when the event is about exporting/importing onto media.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/dicm-405-mediatype
    pub media: Option<Coding>,
    /// Logical network location for application activity
    ///
    /// Logical network location for application activity, if the activity has a
    /// network location.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub network: Option<AuditEventAgentNetwork>,
    /// Reason given for this user
    ///
    /// The reason (purpose of use), specific to this agent, that was used during the
    /// event being recorded.
    ///
    /// ## Implementation Notes
    /// Use AuditEvent.agent.purposeOfUse when you know that is specific to the
    /// agent, otherwise use AuditEvent.purposeOfEvent. For example, during a
    /// machine-to-machine transfer it might not be obvious to the audit system who
    /// caused the event, but it does know why.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: The reason the activity took place.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/v3-PurposeOfUse
    #[fhir_serde(rename = "purposeOfUse")]
    pub purpose_of_use: Option<Vec<CodeableConcept>>,
}

/// FHIR AuditEvent type
///
/// A record of an event made for purposes of maintaining a security log. Typical
/// uses include detection of intrusion attempts and monitoring for inappropriate
/// usage.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [AuditEvent](http://hl7.org/fhir/StructureDefinition/AuditEvent)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AuditEvent {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Type/identifier of event
    ///
    /// Identifier for a family of the event. For example, a menu item, program,
    /// rule, policy, function code, application name or URL. It identifies the
    /// performed function.
    ///
    /// ## Requirements
    /// This identifies the performed function. For "Execute" Event Action Code audit
    /// records, this identifies the application function performed.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Type of event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-type
    #[fhir_serde(rename = "type")]
    pub r#type: Coding,
    /// More specific type/id for the event
    ///
    /// Identifier for the category of event.
    ///
    /// ## Requirements
    /// This field enables queries of messages by implementation-defined event
    /// categories.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Sub-type of event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-sub-type
    pub subtype: Option<Vec<Coding>>,
    /// Type of action performed during the event
    ///
    /// Indicator for type of action performed during the event that generated the
    /// audit.
    ///
    /// ## Requirements
    /// This broadly indicates what kind of action was done on the AuditEvent.entity
    /// by the AuditEvent.agent.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicator for type of action performed during the event that generated the event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-action|4.0.1
    pub action: Option<Code>,
    /// When the activity occurred
    ///
    /// The period during which the activity occurred.
    ///
    /// ## Implementation Notes
    /// The period can be a little arbitrary; where possible, the time should
    /// correspond to human assessment of the activity time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub period: Option<Period>,
    /// Time when the event was recorded
    ///
    /// The time when the event was recorded.
    ///
    /// ## Requirements
    /// This ties an event to a specific date and time. Security audits typically
    /// require a consistent time base (e.g. UTC), to eliminate time-zone issues
    /// arising from geographical distribution.
    ///
    /// ## Implementation Notes
    /// In a distributed system, some sort of common time base (e.g. an NTP [RFC1305]
    /// server) is a good implementation tactic.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub recorded: Instant,
    /// Whether the event succeeded or failed
    ///
    /// Indicates whether the event succeeded or failed.
    ///
    /// ## Implementation Notes
    /// In some cases a "success" may be partial, for example, an incomplete or
    /// interrupted transfer of a radiological study. For the purpose of establishing
    /// accountability, these distinctions are not relevant.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicates whether the event succeeded or failed.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-outcome|4.0.1
    pub outcome: Option<Code>,
    /// Description of the event outcome
    ///
    /// A free text description of the outcome of the event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "outcomeDesc")]
    pub outcome_desc: Option<String>,
    /// The purposeOfUse of the event
    ///
    /// The purposeOfUse (reason) that was used during the event being recorded.
    ///
    /// ## Implementation Notes
    /// Use AuditEvent.agent.purposeOfUse when you know that it is specific to the
    /// agent, otherwise use AuditEvent.purposeOfEvent. For example, during a
    /// machine-to-machine transfer it might not be obvious to the audit system who
    /// caused the event, but it does know why.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: The reason the activity took place.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/v3-PurposeOfUse
    #[fhir_serde(rename = "purposeOfEvent")]
    pub purpose_of_event: Option<Vec<CodeableConcept>>,
    /// Actor involved in the event
    ///
    /// An actor taking an active role in the event or activity that is logged.
    ///
    /// ## Requirements
    /// An agent can be a person, an organization, software, device, or other actors
    /// that may be ascribed responsibility.
    ///
    /// ## Implementation Notes
    /// Several agents may be associated (i.e. have some responsibility for an
    /// activity) with an event or activity.
    ///
    /// For example, an activity may be initiated by one user for other users or
    /// involve more than one user. However, only one user may be the
    /// initiator/requestor for the activity.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// ActiveParticipant
    pub agent: Option<Vec<AuditEventAgent>>,
    /// Audit Event Reporter
    ///
    /// The system that is reporting the event.
    ///
    /// ## Requirements
    /// The event is reported by one source.
    ///
    /// ## Implementation Notes
    /// Since multi-tier, distributed, or composite applications make source
    /// identification ambiguous, this collection of fields may repeat for each
    /// application or process actively involved in the event. For example, multiple
    /// value-sets can identify participating web servers, application processes, and
    /// database server threads in an n-tier distributed application. Passive event
    /// participants (e.g. low-level network transports) need not be identified.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub source: AuditEventSource,
    /// Data or objects used
    ///
    /// Specific instances of data or objects that have been accessed.
    ///
    /// ## Requirements
    /// The event may have other entities involved.
    ///
    /// ## Implementation Notes
    /// Required unless the values for event identification, agent identification,
    /// and audit source identification are sufficient to document the entire
    /// auditable event. Because events may have more than one entity, this group can
    /// be a repeating set of values.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **sev-1**: Either a name or a query (NOT both) (error)
    ///   Expression: `name.empty() or query.empty()`
    ///
    /// ## Aliases
    /// ParticipantObject
    pub entity: Option<Vec<AuditEventEntity>>,
}

/// Data or objects used
///
/// Specific instances of data or objects that have been accessed.
///
/// ## Requirements
/// The event may have other entities involved.
///
/// ## Implementation Notes
/// Required unless the values for event identification, agent identification,
/// and audit source identification are sufficient to document the entire
/// auditable event. Because events may have more than one entity, this group can
/// be a repeating set of values.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
/// - **sev-1**: Either a name or a query (NOT both) (error)
///   Expression: `name.empty() or query.empty()`
///
/// ## Aliases
/// ParticipantObject
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AuditEventEntity {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Specific instance of resource
    ///
    /// Identifies a specific instance of the entity. The reference should be version
    /// specific.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub what: Option<Reference>,
    /// Type of entity involved
    ///
    /// The type of the object that was involved in this audit event.
    ///
    /// ## Requirements
    /// To describe the object being acted upon. In addition to queries on the
    /// subject of the action in an auditable event, it is also important to be able
    /// to query on the object type for the action.
    ///
    /// ## Implementation Notes
    /// This value is distinct from the user's role or any user relationship to the
    /// entity.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Code for the entity type involved in the audit event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-entity-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Coding>,
    /// What role the entity played
    ///
    /// Code representing the role the entity played in the event being audited.
    ///
    /// ## Requirements
    /// For some detailed audit analysis it may be necessary to indicate a more
    /// granular type of entity, based on the application role it serves.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Code representing the role the entity played in the audit event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/object-role
    pub role: Option<Coding>,
    /// Life-cycle stage for the entity
    ///
    /// Identifier for the data life-cycle stage for the entity.
    ///
    /// ## Requirements
    /// Institutional policies for privacy and security may optionally fall under
    /// different accountability rules based on data life cycle. This provides a
    /// differentiating value for those cases.
    ///
    /// ## Implementation Notes
    /// This can be used to provide an audit trail for data, over time, as it passes
    /// through the system.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Identifier for the data life-cycle stage for the entity.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/object-lifecycle-events
    pub lifecycle: Option<Coding>,
    /// Security labels on the entity
    ///
    /// Security labels for the identified entity.
    ///
    /// ## Requirements
    /// This field identifies the security labels for a specific instance of an
    /// object, such as a patient, to detect/track privacy and security issues.
    ///
    /// ## Implementation Notes
    /// Copied from entity meta security tags.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Security Labels from the Healthcare Privacy and Security Classification System.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/security-labels
    #[fhir_serde(rename = "securityLabel")]
    pub security_label: Option<Vec<Coding>>,
    /// Descriptor for entity
    ///
    /// A name of the entity in the audit event.
    ///
    /// ## Requirements
    /// Use only where entity can't be identified with an identifier.
    ///
    /// ## Implementation Notes
    /// This field may be used in a query/report to identify audit events for a
    /// specific person. For example, where multiple synonymous entity identifiers
    /// (patient number, medical record number, encounter number, etc.) have been
    /// used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: sev-1
    pub name: Option<String>,
    /// Descriptive text
    ///
    /// Text that describes the entity in more detail.
    ///
    /// ## Requirements
    /// Use only where entity can't be identified with an identifier.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Query parameters
    ///
    /// The query parameters for a query-type entities.
    ///
    /// ## Requirements
    /// For query events, it may be necessary to capture the actual query input to
    /// the query process in order to identify the specific event. Because of
    /// differences among query implementations and data encoding for them, this is a
    /// base 64 encoded data blob. It may be subsequently decoded or interpreted by
    /// downstream audit analysis processing.
    ///
    /// ## Implementation Notes
    /// The meaning and secondary-encoding of the content of base64 encoded blob is
    /// specific to the AuditEvent.type, AuditEvent.subtype, AuditEvent.entity.type,
    /// and AuditEvent.entity.role. The base64 is a general-use and safe container
    /// for event specific data blobs regardless of the encoding used by the
    /// transaction being recorded. An AuditEvent consuming application must
    /// understand the event it is consuming and the formats used by the event. For
    /// example, if auditing an Oracle network database access, the Oracle formats
    /// must be understood as they will be simply encoded in the base64binary blob.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: sev-1
    pub query: Option<Base64Binary>,
    /// Additional Information about the entity
    ///
    /// Tagged value pairs for conveying additional information about the entity.
    ///
    /// ## Requirements
    /// Implementation-defined data about specific details of the object accessed or
    /// used.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub detail: Option<Vec<AuditEventEntityDetail>>,
}

/// Audit Event Reporter
///
/// The system that is reporting the event.
///
/// ## Requirements
/// The event is reported by one source.
///
/// ## Implementation Notes
/// Since multi-tier, distributed, or composite applications make source
/// identification ambiguous, this collection of fields may repeat for each
/// application or process actively involved in the event. For example, multiple
/// value-sets can identify participating web servers, application processes, and
/// database server threads in an n-tier distributed application. Passive event
/// participants (e.g. low-level network transports) need not be identified.
///
/// ## Cardinality: Required (1..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AuditEventSource {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Logical source location within the enterprise
    ///
    /// Logical source location within the healthcare enterprise network. For
    /// example, a hospital or other provider location within a multi-entity provider
    /// group.
    ///
    /// ## Requirements
    /// This value differentiates among the sites in a multi-site enterprise health
    /// information system.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub site: Option<String>,
    /// The identity of source detecting the event
    ///
    /// Identifier of the source where the event was detected.
    ///
    /// ## Requirements
    /// This field ties the event to a specific source system. It may be used to
    /// group events for analysis according to where the event was detected.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// SourceId
    pub observer: Reference,
    /// The type of source where event originated
    ///
    /// Code specifying the type of source where event originated.
    ///
    /// ## Requirements
    /// This field indicates which type of source is identified by the Audit Source
    /// ID. It is an optional value that may be used to group events for analysis
    /// according to the type of source where the event occurred.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Code specifying the type of system that detected and recorded the event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-source-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Vec<Coding>>,
}

/// FHIR Basic type
///
/// Basic is used for handling concepts not yet defined in FHIR, narrative-only
/// resources that don't map to an existing resource, and custom resources not
/// appropriate for inclusion in the FHIR specification.
///
/// ## Purpose
/// Need some way to safely (without breaking interoperability) allow implementers to exchange content not supported by the initial set of declared resources.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [Basic](http://hl7.org/fhir/StructureDefinition/Basic)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Basic {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Business identifier
    ///
    /// Identifier assigned to the resource for business purposes, outside the
    /// context of FHIR.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Kind of Resource
    ///
    /// Identifies the 'type' of resource - equivalent to the resource name for other
    /// resources.
    ///
    /// ## Requirements
    /// Must be able to distinguish different types of Basic resources.
    ///
    /// ## Implementation Notes
    /// Because resource references will only be able to indicate 'Basic', the type
    /// of reference will need to be specified in a Profile identified as part of the
    /// resource. Refer to the resource notes section for information on appropriate
    /// terminologies for this code.
    ///
    /// This element is labeled as a modifier because it defines the meaning of the
    /// resource and cannot be ignored.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element determines what kind of resource is being represented which drives the meaning of all of the other elements.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes for identifying types of resources not yet defined by FHIR.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/basic-resource-type
    pub code: CodeableConcept,
    /// Identifies the focus of this resource
    ///
    /// Identifies the patient, practitioner, device or any other resource that is
    /// the "focus" of this resource.
    ///
    /// ## Requirements
    /// Needed for partitioning the resource by Patient.
    ///
    /// ## Implementation Notes
    /// Optional as not all potential resources will have subjects. Resources
    /// associated with multiple subjects can handle this via extension.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub subject: Option<Reference>,
    /// When created
    ///
    /// Identifies when the resource was first created.
    ///
    /// ## Requirements
    /// Allows ordering resource instances by time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub created: Option<Date>,
    /// Who created
    ///
    /// Indicates who was responsible for creating the resource instance.
    ///
    /// ## Requirements
    /// Needed for partitioning the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub author: Option<Reference>,
}

/// FHIR Binary type
///
/// A resource that represents the data of a single raw artifact as digital
/// content accessible in its native format. A Binary resource can contain any
/// content, whether text, image, pdf, zip archive, etc.
///
/// ## Purpose
/// There are situations where it is useful or required to handle pure binary content using the same framework as other resources.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/Resource
///
/// ## Status: active
/// FHIR Version: 4.0.1
///
/// See: [Binary](http://hl7.org/fhir/StructureDefinition/Binary)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Binary {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// MimeType of the binary content
    ///
    /// MimeType of the binary content represented as a standard MimeType (BCP 13).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The mime type of an attachment. Any valid mime type is allowed.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/mimetypes|4.0.1
    #[fhir_serde(rename = "contentType")]
    pub content_type: Code,
    /// Identifies another resource to use as proxy when enforcing access control
    ///
    /// This element identifies another resource that can be used as a proxy of the
    /// security sensitivity to use when deciding and enforcing access control rules
    /// for the Binary resource. Given that the Binary resource contains very few
    /// elements that can be used to determine the sensitivity of the data and
    /// relationships to individuals, the referenced resource stands in as a proxy
    /// equivalent for this purpose. This referenced resource may be related to the
    /// Binary (e.g. Media, DocumentReference), or may be some non-related Resource
    /// purely as a security proxy. E.g. to identify that the binary resource relates
    /// to a patient, and access should only be granted to applications that have
    /// access to the patient.
    ///
    /// ## Implementation Notes
    /// Very often, a server will also know of a resource that references the binary,
    /// and can automatically apply the appropriate access rules based on that
    /// reference. However, there are some circumstances where this is not
    /// appropriate, e.g. the binary is uploaded directly to the server without any
    /// linking resource, the binary is referred to from multiple different
    /// resources, and/or the binary is content such as an application logo that has
    /// less protection than any of the resources that reference it.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "securityContext")]
    pub security_context: Option<Reference>,
    /// The actual content
    ///
    /// The actual content, base64 encoded.
    ///
    /// ## Implementation Notes
    /// If the content type is itself base64 encoding, then this will be base64
    /// encoded twice - what is created by un-base64ing the content must be the
    /// specified content type.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub data: Option<Base64Binary>,
}

/// FHIR BiologicallyDerivedProduct type
///
/// A material substance originating from a biological entity intended to be
/// transplanted or infused
/// into another (possibly the same) biological entity.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [BiologicallyDerivedProduct](http://hl7.org/fhir/StructureDefinition/BiologicallyDerivedProduct)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BiologicallyDerivedProduct {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External ids for this item
    ///
    /// This records identifiers associated with this biologically derived product
    /// instance that are defined by business processes and/or used to refer to it
    /// when a direct URL reference to the resource itself is not appropriate (e.g.
    /// in CDA documents, or in written / printed documentation).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// organ | tissue | fluid | cells | biologicalAgent
    ///
    /// Broad category of this product.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Biologically Derived Product Category.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/product-category|4.0.1
    #[fhir_serde(rename = "productCategory")]
    pub product_category: Option<Code>,
    /// What this biologically derived product is
    ///
    /// A code that identifies the kind of this biologically derived product (SNOMED
    /// Ctcode).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Biologically Derived Product Code.
    #[fhir_serde(rename = "productCode")]
    pub product_code: Option<CodeableConcept>,
    /// available | unavailable
    ///
    /// Whether the product is currently available.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Biologically Derived Product Status.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/product-status|4.0.1
    pub status: Option<Code>,
    /// Procedure request
    ///
    /// Procedure request to obtain this biologically derived product.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub request: Option<Vec<Reference>>,
    /// The amount of this biologically derived product
    ///
    /// Number of discrete units within this product.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Integer>,
    /// BiologicallyDerivedProduct parent
    ///
    /// Parent product (if any).
    ///
    /// ## Implementation Notes
    /// For products that have multiple collections. For example Peripheral Blood
    /// Stem Cells may be collected over several days from a single donor and the
    /// donation split into in multiple containers which must be linked to the parent
    /// donation.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub parent: Option<Vec<Reference>>,
    /// How this product was collected
    ///
    /// How this product was collected.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub collection: Option<BiologicallyDerivedProductCollection>,
    /// Any processing of the product during collection
    ///
    /// Any processing of the product during collection that does not change the
    /// fundamental nature of the product. For example adding anti-coagulants during
    /// the collection of Peripheral Blood Stem Cells.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub processing: Option<Vec<BiologicallyDerivedProductProcessing>>,
    /// Any manipulation of product post-collection
    ///
    /// Any manipulation of product post-collection that is intended to alter the
    /// product. For example a buffy-coat enrichment or CD8 reduction of Peripheral
    /// Blood Stem Cells to make it more suitable for infusion.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub manipulation: Option<BiologicallyDerivedProductManipulation>,
    /// Product storage
    ///
    /// Product storage.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub storage: Option<Vec<BiologicallyDerivedProductStorage>>,
}

/// Choice of types for the time\[x\] field in BiologicallyDerivedProductManipulation
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "time")]
pub enum BiologicallyDerivedProductManipulationTime {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "timeDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "timePeriod")]
    Period(Period),
}

/// Any manipulation of product post-collection
///
/// Any manipulation of product post-collection that is intended to alter the
/// product. For example a buffy-coat enrichment or CD8 reduction of Peripheral
/// Blood Stem Cells to make it more suitable for infusion.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "time")]
pub struct BiologicallyDerivedProductManipulation {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Description of manipulation
    ///
    /// Description of manipulation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Time of manipulation
    ///
    /// Time of manipulation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub time: Option<BiologicallyDerivedProductManipulationTime>,
}

/// Choice of types for the time\[x\] field in BiologicallyDerivedProductProcessing
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "time")]
pub enum BiologicallyDerivedProductProcessingTime {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "timeDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "timePeriod")]
    Period(Period),
}

/// Any processing of the product during collection
///
/// Any processing of the product during collection that does not change the
/// fundamental nature of the product. For example adding anti-coagulants during
/// the collection of Peripheral Blood Stem Cells.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "time")]
pub struct BiologicallyDerivedProductProcessing {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Description of of processing
    ///
    /// Description of of processing.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Procesing code
    ///
    /// Procesing code.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Biologically Derived Product Procedure.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/procedure-code
    pub procedure: Option<CodeableConcept>,
    /// Substance added during processing
    ///
    /// Substance added during processing.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub additive: Option<Reference>,
    /// Time of processing
    ///
    /// Time of processing.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub time: Option<BiologicallyDerivedProductProcessingTime>,
}

/// Choice of types for the collected\[x\] field in BiologicallyDerivedProductCollection
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "collected")]
pub enum BiologicallyDerivedProductCollectionCollected {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "collectedDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "collectedPeriod")]
    Period(Period),
}

/// How this product was collected
///
/// How this product was collected.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "collected")]
pub struct BiologicallyDerivedProductCollection {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Individual performing collection
    ///
    /// Healthcare professional who is performing the collection.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub collector: Option<Reference>,
    /// Who is product from
    ///
    /// The patient or entity, such as a hospital or vendor in the case of a
    /// processed/manipulated/manufactured product, providing the product.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub source: Option<Reference>,
    /// Time of product collection
    ///
    /// Time of product collection.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub collected: Option<BiologicallyDerivedProductCollectionCollected>,
}

/// Product storage
///
/// Product storage.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BiologicallyDerivedProductStorage {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Description of storage
    ///
    /// Description of storage.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Storage temperature
    ///
    /// Storage temperature.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub temperature: Option<Decimal>,
    /// farenheit | celsius | kelvin
    ///
    /// Temperature scale used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: BiologicallyDerived Product Storage Scale.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/product-storage-scale|4.0.1
    pub scale: Option<Code>,
    /// Storage timeperiod
    ///
    /// Storage timeperiod.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub duration: Option<Period>,
}

/// FHIR BodyStructure type
///
/// Record details about an anatomical structure. This resource may be used when
/// a coded concept does not provide the necessary detail needed for the use
/// case.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [BodyStructure](http://hl7.org/fhir/StructureDefinition/BodyStructure)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BodyStructure {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Bodystructure identifier
    ///
    /// Identifier for this instance of the anatomical structure.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Whether this record is in active use
    ///
    /// Whether this body site is in active use.
    ///
    /// ## Requirements
    /// Need to be able to mark a body site entry as not to be used because it was
    /// created in error.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because it may be used to mark that the
    /// resource was created in error.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that can indicate that a record should not be treated as valid
    /// - Included in summary
    /// - When missing: This resource is generally assumed to be active if no value is provided for the active element
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub active: Option<Boolean>,
    /// Kind of Structure
    ///
    /// The kind of structure being represented by the body structure at
    /// `BodyStructure.location`. This can define both normal and abnormal
    /// morphologies.
    ///
    /// ## Implementation Notes
    /// The minimum cardinality of 0 supports the use case of specifying a location
    /// without defining a morphology.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing anatomic morphology.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/bodystructure-code
    pub morphology: Option<CodeableConcept>,
    /// Body site
    ///
    /// The anatomical location or region of the specimen, lesion, or body structure.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing anatomical locations. May include laterality.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/body-site
    pub location: Option<CodeableConcept>,
    /// Body site modifier
    ///
    /// Qualifier to refine the anatomical location. These include qualifiers for
    /// laterality, relative location, directionality, number, and plane.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Concepts modifying the anatomic location.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/bodystructure-relative-location
    #[fhir_serde(rename = "locationQualifier")]
    pub location_qualifier: Option<Vec<CodeableConcept>>,
    /// Text description
    ///
    /// A summary, characterization or explanation of the body structure.
    ///
    /// ## Implementation Notes
    /// This description could include any visual markings used to orientate the
    /// viewer e.g. external reference points, special sutures, ink markings.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Attached images
    ///
    /// Image or images used to identify a location.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub image: Option<Vec<Attachment>>,
    /// Who this is about
    ///
    /// The person to which the body site belongs.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub patient: Reference,
}

/// Search related information
///
/// Information about the search process that lead to the creation of this entry.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: bdl-2
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleEntrySearch {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// match | include | outcome - why this is in the result set
    ///
    /// Why this entry is in the result set - whether it's included as a match or
    /// because of an _include requirement, or to convey information or warning
    /// information about the search process.
    ///
    /// ## Implementation Notes
    /// There is only one mode. In some corner cases, a resource may be included
    /// because it is both a match and an include. In these circumstances, 'match'
    /// takes precedence.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Why an entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/search-entry-mode|4.0.1
    pub mode: Option<Code>,
    /// Search ranking (between 0 and 1)
    ///
    /// When searching, the server's search ranking score for the entry.
    ///
    /// ## Implementation Notes
    /// Servers are not required to return a ranking score. 1 is most relevant, and 0
    /// is least relevant. Often, search results are sorted by score, but the client
    /// may specify a different sort order.
    ///
    /// See [Patient Match](patient-operation-match.html) for the EMPI search which
    /// relates to this element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub score: Option<Decimal>,
}

/// FHIR Bundle type
///
/// A container for a collection of resources.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/Resource
///
/// ## Status: active
/// FHIR Version: 4.0.1
///
/// See: [Bundle](http://hl7.org/fhir/StructureDefinition/Bundle)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Bundle {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Persistent identifier for the bundle
    ///
    /// A persistent identifier for the bundle that won't change as a bundle is
    /// copied from server to server.
    ///
    /// ## Implementation Notes
    /// Persistent identity generally only matters for batches of type Document,
    /// Message, and Collection. It would not normally be populated for search and
    /// history results and servers ignore Bundle.identifier when processing batches
    /// and transactions. For Documents the .identifier SHALL be populated such that
    /// the .identifier is globally unique.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Identifier>,
    /// document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection
    ///
    /// Indicates the purpose of this bundle - how it is intended to be used.
    ///
    /// ## Implementation Notes
    /// It's possible to use a bundle for other purposes (e.g. a document can be
    /// accepted as a transaction). This is primarily defined so that there can be
    /// specific rules for some of the bundle types.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicates the purpose of a bundle - how it is intended to be used.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/bundle-type|4.0.1
    #[fhir_serde(rename = "type")]
    pub r#type: Code,
    /// When the bundle was assembled
    ///
    /// The date/time that the bundle was assembled - i.e. when the resources were
    /// placed in the bundle.
    ///
    /// ## Implementation Notes
    /// For many bundles, the timestamp is equal to .meta.lastUpdated, because they
    /// are not stored (e.g. search results). When a bundle is placed in a persistent
    /// store, .meta.lastUpdated will be usually be changed by the server. When the
    /// bundle is a message, a middleware agent altering the message (even if not
    /// stored) SHOULD update .meta.lastUpdated. .timestamp is used to track the
    /// original time of the Bundle, and SHOULD be populated.
    ///
    /// Usage:
    ///
    /// * document : the date the document was created. Note: the composition may
    ///   predate the document, or be associated with multiple documents. The date of
    ///   the composition - the authoring time - may be earlier than the document
    ///   assembly time
    /// * message : the date that the content of the message was assembled. This date
    ///   is not changed by middleware engines unless they add additional data that
    ///   changes the meaning of the time of the message
    /// * history : the date that the history was assembled. This time would be used
    ///   as the _since time to ask for subsequent updates
    /// * searchset : the time that the search set was assembled. Note that different
    ///   pages MAY have different timestamps but need not. Having different
    ///   timestamps does not imply that subsequent pages will represent or include
    ///   changes made since the initial query
    /// * transaction | transaction-response | batch | batch-response | collection :
    ///   no particular assigned meaning
    ///
    /// The timestamp value should be greater than the lastUpdated and other
    /// timestamps in the resources in the bundle, and it should be equal or earlier
    /// than the .meta.lastUpdated on the Bundle itself.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub timestamp: Option<Instant>,
    /// If search, the total number of matches
    ///
    /// If a set of search matches, this is the total number of entries of type
    /// 'match' across all pages in the search. It does not include search.mode =
    /// 'include' or 'outcome' entries and it does not provide a count of the number
    /// of entries in the Bundle.
    ///
    /// ## Implementation Notes
    /// Only used if the bundle is a search result set. The total does not include
    /// resources such as OperationOutcome and included resources, only the total
    /// number of matching resources.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-1
    pub total: Option<UnsignedInt>,
    /// Links related to this Bundle
    ///
    /// A series of links that provide context to this bundle.
    ///
    /// ## Implementation Notes
    /// Both Bundle.link and Bundle.entry.link are defined to support providing
    /// additional context when Bundles are used (e.g.
    /// [HATEOAS](http://en.wikipedia.org/wiki/HATEOAS)).
    ///
    /// Bundle.entry.link corresponds to links found in the HTTP header if the
    /// resource in the entry was [read](http.html#read) directly.
    ///
    /// This specification defines some specific uses of Bundle.link for
    /// [searching](search.html#conformance) and [paging](http.html#paging), but no
    /// specific uses for Bundle.entry.link, and no defined function in a transaction
    /// - the meaning is implementation specific.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub link: Option<Vec<BundleLink>>,
    /// Entry in the bundle - will have a resource or information
    ///
    /// An entry in a bundle resource - will either contain a resource or information
    /// about a resource (transactions and history only).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    /// - Order meaning: For bundles of type 'document' and 'message', the first resource is special (must be Composition or MessageHeader respectively). For all bundles, the meaning of the order of entries depends on the bundle type
    ///
    /// ## Constraints
    /// - **bdl-5**: must be a resource unless there's a request or response (error)
    ///   Expression: `resource.exists() or request.exists() or response.exists()`
    /// - **bdl-8**: fullUrl cannot be a version specific reference (error)
    ///   Expression: `fullUrl.contains('/_history/').not()`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub entry: Option<Vec<BundleEntry>>,
    /// Digital Signature
    ///
    /// Digital Signature - base64 encoded. XML-DSig or a JWT.
    ///
    /// ## Requirements
    /// A Signature holds an electronic representation of a signature and its
    /// supporting context in a FHIR accessible form. The signature may either be a
    /// cryptographic type (XML DigSig or a JWS), which is able to provide
    /// non-repudiation proof, or it may be a graphical image that represents a
    /// signature or a signature process. This element allows capturing signatures on
    /// documents, messages, transactions or even search responses, to support
    /// content-authentication, non-repudiation or other business cases. This is
    /// primarily relevant where the bundle may travel through multiple hops or via
    /// other mechanisms where HTTPS non-repudiation is insufficient.
    ///
    /// ## Implementation Notes
    /// The signature could be created by the "author" of the bundle or by the
    /// originating device. Requirements around inclusion of a signature,
    /// verification of signatures and treatment of signed/non-signed bundles is
    /// implementation-environment specific.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub signature: Option<Signature>,
}

/// Links related to this Bundle
///
/// A series of links that provide context to this bundle.
///
/// ## Implementation Notes
/// Both Bundle.link and Bundle.entry.link are defined to support providing
/// additional context when Bundles are used (e.g.
/// [HATEOAS](http://en.wikipedia.org/wiki/HATEOAS)).
///
/// Bundle.entry.link corresponds to links found in the HTTP header if the
/// resource in the entry was [read](http.html#read) directly.
///
/// This specification defines some specific uses of Bundle.link for
/// [searching](search.html#conformance) and [paging](http.html#paging), but no
/// specific uses for Bundle.entry.link, and no defined function in a transaction
/// - the meaning is implementation specific.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleLink {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// See http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1
    ///
    /// A name which details the functional use for this link - see
    /// [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub relation: String,
    /// Reference details for the link
    ///
    /// The reference details for the link.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Uri,
}

/// Entry in the bundle - will have a resource or information
///
/// An entry in a bundle resource - will either contain a resource or information
/// about a resource (transactions and history only).
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
/// - Order meaning: For bundles of type 'document' and 'message', the first resource is special (must be Composition or MessageHeader respectively). For all bundles, the meaning of the order of entries depends on the bundle type
///
/// ## Constraints
/// - **bdl-5**: must be a resource unless there's a request or response (error)
///   Expression: `resource.exists() or request.exists() or response.exists()`
/// - **bdl-8**: fullUrl cannot be a version specific reference (error)
///   Expression: `fullUrl.contains('/_history/').not()`
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleEntry {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Links related to this entry
    ///
    /// A series of links that provide context to this entry.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub link: Option<Vec<BundleLink>>,
    /// URI for resource (Absolute URL server address or URI for UUID/OID)
    ///
    /// The Absolute URL for the resource. The fullUrl SHALL NOT disagree with the id
    /// in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be
    /// version-independent URL consistent with the Resource.id. The fullUrl is a
    /// version independent reference to the resource. The fullUrl element SHALL have
    /// a value except that:
    /// * fullUrl can be empty on a POST (although it does not need to when
    ///   specifying a temporary id for reference in the bundle)
    /// * Results from operations might involve resources that are not identified.
    ///
    /// ## Implementation Notes
    /// fullUrl might not be [unique in the context of a
    /// resource](bundle.html#bundle-unique). Note that since [FHIR resources do not
    /// need to be served through the FHIR API](references.html), the fullURL might
    /// be a URN or an absolute URL that does not end with the logical id of the
    /// resource (Resource.id). However, but if the fullUrl does look like a RESTful
    /// server URL (e.g. meets the [regex](references.html#regex), then the 'id'
    /// portion of the fullUrl SHALL end with the Resource.id.
    ///
    /// Note that the fullUrl is not the same as the canonical URL - it's an absolute
    /// url for an endpoint serving the resource (these will happen to have the same
    /// value on the canonical server for the resource with the canonical URL).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "fullUrl")]
    pub full_url: Option<Uri>,
    /// A resource in the bundle
    ///
    /// The Resource for the entry. The purpose/meaning of the resource is determined
    /// by the Bundle.type.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub resource: Option<Resource>,
    /// Search related information
    ///
    /// Information about the search process that lead to the creation of this entry.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-2
    pub search: Option<BundleEntrySearch>,
    /// Additional execution information (transaction/batch/history)
    ///
    /// Additional information about how this entry should be processed as part of a
    /// transaction or batch. For history, it shows how the entry was processed to
    /// create the version contained in the entry.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-3
    pub request: Option<BundleEntryRequest>,
    /// Results of execution (transaction/batch/history)
    ///
    /// Indicates the results of processing the corresponding 'request' entry in the
    /// batch or transaction being responded to or what the results of an operation
    /// where when returning history.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-4
    pub response: Option<BundleEntryResponse>,
}

/// Additional execution information (transaction/batch/history)
///
/// Additional information about how this entry should be processed as part of a
/// transaction or batch. For history, it shows how the entry was processed to
/// create the version contained in the entry.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: bdl-3
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleEntryRequest {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// GET | HEAD | POST | PUT | DELETE | PATCH
    ///
    /// In a transaction or batch, this is the HTTP action to be executed for this
    /// entry. In a history bundle, this indicates the HTTP action that occurred.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: HTTP verbs (in the HTTP command line). See [HTTP rfc](https://tools.ietf.org/html/rfc7231) for details.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/http-verb|4.0.1
    pub method: Code,
    /// URL for HTTP equivalent of this entry
    ///
    /// The URL for this entry, relative to the root (the address to which the
    /// request is posted).
    ///
    /// ## Implementation Notes
    /// E.g. for a Patient Create, the method would be "POST" and the URL would be
    /// "Patient". For a Patient Update, the method would be PUT and the URL would be
    /// "Patient/[id]".
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Uri,
    /// For managing cache currency
    ///
    /// If the ETag values match, return a 304 Not Modified status. See the API
    /// documentation for ["Conditional Read"](http.html#cread).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "ifNoneMatch")]
    pub if_none_match: Option<String>,
    /// For managing cache currency
    ///
    /// Only perform the operation if the last updated date matches. See the API
    /// documentation for ["Conditional Read"](http.html#cread).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "ifModifiedSince")]
    pub if_modified_since: Option<Instant>,
    /// For managing update contention
    ///
    /// Only perform the operation if the Etag value matches. For more information,
    /// see the API section ["Managing Resource Contention"](http.html#concurrency).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "ifMatch")]
    pub if_match: Option<String>,
    /// For conditional creates
    ///
    /// Instruct the server not to perform the create if a specified resource already
    /// exists. For further information, see the API documentation for ["Conditional
    /// Create"](http.html#ccreate). This is just the query portion of the URL - what
    /// follows the "?" (not including the "?").
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "ifNoneExist")]
    pub if_none_exist: Option<String>,
}

/// Results of execution (transaction/batch/history)
///
/// Indicates the results of processing the corresponding 'request' entry in the
/// batch or transaction being responded to or what the results of an operation
/// where when returning history.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: bdl-4
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleEntryResponse {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Status response code (text optional)
    ///
    /// The status code returned by processing this entry. The status SHALL start
    /// with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP
    /// description associated with the status code.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub status: String,
    /// The location (if the operation returns a location)
    ///
    /// The location header created by processing this operation, populated if the
    /// operation returns a location.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub location: Option<Uri>,
    /// The Etag for the resource (if relevant)
    ///
    /// The Etag for the resource, if the operation for the entry produced a
    /// versioned resource (see [Resource Metadata and
    /// Versioning](http.html#versioning) and [Managing Resource
    /// Contention](http.html#concurrency)).
    ///
    /// ## Implementation Notes
    /// Etags match the Resource.meta.versionId. The ETag has to match the version id
    /// in the header if a resource is included.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub etag: Option<String>,
    /// Server's date time modified
    ///
    /// The date/time that the resource was modified on the server.
    ///
    /// ## Implementation Notes
    /// This has to match the same time in the meta header (meta.lastUpdated) if a
    /// resource is included.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastModified")]
    pub last_modified: Option<Instant>,
    /// OperationOutcome with hints and warnings (for batch/transaction)
    ///
    /// An OperationOutcome containing hints and warnings produced as part of
    /// processing this entry in a batch or transaction.
    ///
    /// ## Implementation Notes
    /// For a POST/PUT operation, this is the equivalent outcome that would be
    /// returned for prefer = operationoutcome - except that the resource is always
    /// returned whether or not the outcome is returned.
    ///
    /// This outcome is not used for error responses in batch/transaction, only for
    /// hints and warnings. In a batch operation, the error will be in
    /// Bundle.entry.response, and for transaction, there will be a single
    /// OperationOutcome instead of a bundle in the case of an error.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub outcome: Option<Resource>,
}

/// Resource served on the REST interface
///
/// A specification of the restful capabilities of the solution for a specific
/// resource type.
///
/// ## Implementation Notes
/// Max of one repetition per resource type.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **cpb-12**: Search parameter names must be unique in the context of a resource. (error)
///   Expression: `searchParam.select(name).isDistinct()`
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestResource {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// A resource type that is supported
    ///
    /// A type of resource exposed via the restful interface.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: One of the resource types defined as part of this version of FHIR.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/resource-types|4.0.1
    #[fhir_serde(rename = "type")]
    pub r#type: Code,
    /// Base System profile for all uses of resource
    ///
    /// A specification of the profile that describes the solution's overall support
    /// for the resource, including any constraints on cardinality, bindings, lengths
    /// or other limitations. See further discussion in [Using
    /// Profiles](profiling.html#profile-uses).
    ///
    /// ## Implementation Notes
    /// The profile applies to all resources of this type - i.e. it is the superset
    /// of what is supported by the system.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub profile: Option<Canonical>,
    /// Profiles for use cases supported
    ///
    /// A list of profiles that represent different use cases supported by the
    /// system. For a server, "supported by the system" means the system
    /// hosts/produces a set of resources that are conformant to a particular
    /// profile, and allows clients that use its services to search using this
    /// profile and to find appropriate data. For a client, it means the system will
    /// search by this profile and process data according to the guidance implicit in
    /// the profile. See further discussion in [Using
    /// Profiles](profiling.html#profile-uses).
    ///
    /// ## Implementation Notes
    /// Supported profiles are different than the profile that applies to a
    /// particular resource in .rest.resource.profile. The resource profile is a
    /// general statement of what features of the resource are supported overall by
    /// the system - the sum total of the facilities it supports. A supported profile
    /// is a deeper statement about the functionality of the data and services
    /// provided by the server (or used by the client). A typical case is a
    /// laboratory system that produces a set of different reports - this is the list
    /// of types of data that it publishes. A key aspect of declaring profiles here
    /// is the question of how the client converts knowledge that the server
    /// publishes this data into working with the data; the client can inspect
    /// individual resources to determine whether they conform to a particular
    /// profile, but how does it find the ones that do? It does so by searching using
    /// the _profile parameter, so any resources listed here must be valid values for
    /// the _profile resource (using the identifier in the target profile).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportedProfile")]
    pub supported_profile: Option<Vec<Canonical>>,
    /// Additional information about the use of the resource type
    ///
    /// Additional information about the resource type used by the system.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
    /// What operations are supported?
    ///
    /// Identifies a restful operation supported by the solution.
    ///
    /// ## Implementation Notes
    /// In general, a Resource will only appear in a CapabilityStatement if the
    /// server actually has some capabilities - e.g. there is at least one
    /// interaction supported. However interactions can be omitted to support
    /// summarization (_summary = true).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub interaction: Option<Vec<CapabilityStatementRestResourceInteraction>>,
    /// no-version | versioned | versioned-update
    ///
    /// This field is set to no-version to specify that the system does not support
    /// (server) or use (client) versioning for this resource type. If this has some
    /// other value, the server must at least correctly track and populate the
    /// versionId meta-property on resources. If the value is 'versioned-update',
    /// then the server supports all the versioning features, including using e-tags
    /// for version integrity in the API.
    ///
    /// ## Implementation Notes
    /// If a server supports versionIds correctly, it SHOULD support vread too, but
    /// is not required to do so.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: How the system supports versioning for a resource.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/versioning-policy|4.0.1
    pub versioning: Option<Code>,
    /// Whether vRead can return past versions
    ///
    /// A flag for whether the server is able to return past versions as part of the
    /// vRead operation.
    ///
    /// ## Implementation Notes
    /// It is useful to support the vRead operation for current operations, even if
    /// past versions aren't available.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "readHistory")]
    pub read_history: Option<Boolean>,
    /// If update can commit to a new identity
    ///
    /// A flag to indicate that the server allows or needs to allow the client to
    /// create new identities on the server (that is, the client PUTs to a location
    /// where there is no existing resource). Allowing this operation means that the
    /// server allows the client to create new identities on the server.
    ///
    /// ## Implementation Notes
    /// Allowing the clients to create new identities on the server means that the
    /// system administrator needs to have confidence that the clients do not create
    /// clashing identities between them. Obviously, if there is only one client,
    /// this won't happen. While creating identities on the client means that the
    /// clients need to be managed, it's much more convenient for many scenarios if
    /// such management can be put in place.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "updateCreate")]
    pub update_create: Option<Boolean>,
    /// If allows/uses conditional create
    ///
    /// A flag that indicates that the server supports conditional create.
    ///
    /// ## Implementation Notes
    /// Conditional Create is mainly appropriate for interface engine scripts
    /// converting from other formats, such as v2.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "conditionalCreate")]
    pub conditional_create: Option<Boolean>,
    /// not-supported | modified-since | not-match | full-support
    ///
    /// A code that indicates how the server supports conditional read.
    ///
    /// ## Implementation Notes
    /// Conditional Read is mainly appropriate for interface engine scripts
    /// converting from other formats, such as v2.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: A code that indicates how the server supports conditional read.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/conditional-read-status|4.0.1
    #[fhir_serde(rename = "conditionalRead")]
    pub conditional_read: Option<Code>,
    /// If allows/uses conditional update
    ///
    /// A flag that indicates that the server supports conditional update.
    ///
    /// ## Implementation Notes
    /// Conditional Update is mainly appropriate for interface engine scripts
    /// converting from other formats, such as v2.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "conditionalUpdate")]
    pub conditional_update: Option<Boolean>,
    /// not-supported | single | multiple - how conditional delete is supported
    ///
    /// A code that indicates how the server supports conditional delete.
    ///
    /// ## Implementation Notes
    /// Conditional Delete is mainly appropriate for interface engine scripts
    /// converting from other formats, such as v2.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: A code that indicates how the server supports conditional delete.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/conditional-delete-status|4.0.1
    #[fhir_serde(rename = "conditionalDelete")]
    pub conditional_delete: Option<Code>,
    /// literal | logical | resolves | enforced | local
    ///
    /// A set of flags that defines how references are supported.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: A set of flags that defines how references are supported.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/reference-handling-policy|4.0.1
    #[fhir_serde(rename = "referencePolicy")]
    pub reference_policy: Option<Vec<Code>>,
    /// _include values supported by the server
    ///
    /// A list of _include values supported by the server.
    ///
    /// ## Implementation Notes
    /// If this list is empty, the server does not support includes.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "searchInclude")]
    pub search_include: Option<Vec<String>>,
    /// _revinclude values supported by the server
    ///
    /// A list of _revinclude (reverse include) values supported by the server.
    ///
    /// ## Implementation Notes
    /// If this list is empty, the server does not support reverse includes.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "searchRevInclude")]
    pub search_rev_include: Option<Vec<String>>,
    /// Search parameters supported by implementation
    ///
    /// Search parameters for implementations to support and/or make use of - either
    /// references to ones defined in the specification, or additional ones defined
    /// for/by the implementation.
    ///
    /// ## Implementation Notes
    /// The search parameters should include the control search parameters such as
    /// _sort, _count, etc. that also apply to this resource (though many will be
    /// listed at
    /// [CapabilityStatement.rest.searchParam](capabilitystatement-definitions.html#CapabilityStatement.rest.searchParam)).
    /// The behavior of some search parameters may be further described by other code
    /// or extension elements, or narrative within the capability statement or linked
    /// [SearchParameter](searchparameter.html#) definitions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "searchParam")]
    pub search_param: Option<Vec<CapabilityStatementRestResourceSearchParam>>,
    /// Definition of a resource operation
    ///
    /// Definition of an operation or a named query together with its parameters and
    /// their meaning and type. Consult the definition of the operation for details
    /// about how to invoke the operation, and the parameters.
    ///
    /// ## Implementation Notes
    /// Operations linked from CapabilityStatement.rest.resource.operation must have
    /// OperationDefinition.type = true or OperationDefinition.instance = true.
    ///
    /// If an operation that is listed in multiple
    /// CapabilityStatement.rest.resource.operation (e.g. for different resource
    /// types), then clients should understand that the operation is only supported
    /// on the specified resource types, and that may be a subset of those listed in
    /// OperationDefinition.resource.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub operation: Option<Vec<CapabilityStatementRestResourceOperation>>,
}

/// What operations are supported?
///
/// Identifies a restful operation supported by the solution.
///
/// ## Implementation Notes
/// In general, a Resource will only appear in a CapabilityStatement if the
/// server actually has some capabilities - e.g. there is at least one
/// interaction supported. However interactions can be omitted to support
/// summarization (_summary = true).
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestResourceInteraction {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// read | vread | update | patch | delete | history-instance | history-type | create | search-type
    ///
    /// Coded identifier of the operation, supported by the system resource.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Operations supported by REST at the type or instance level.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/type-restful-interaction|4.0.1
    pub code: Code,
    /// Anything special about operation behavior
    ///
    /// Guidance specific to the implementation of this operation, such as 'delete is
    /// a logical delete' or 'updates are only allowed with version id' or 'creates
    /// permitted from pre-authorized certificates only'.
    ///
    /// ## Requirements
    /// REST allows a degree of variability in the implementation of RESTful
    /// solutions that is useful for exchange partners to be aware of.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
}

/// Search parameters supported by implementation
///
/// Search parameters for implementations to support and/or make use of - either
/// references to ones defined in the specification, or additional ones defined
/// for/by the implementation.
///
/// ## Implementation Notes
/// The search parameters should include the control search parameters such as
/// _sort, _count, etc. that also apply to this resource (though many will be
/// listed at
/// [CapabilityStatement.rest.searchParam](capabilitystatement-definitions.html#CapabilityStatement.rest.searchParam)).
/// The behavior of some search parameters may be further described by other code
/// or extension elements, or narrative within the capability statement or linked
/// [SearchParameter](searchparameter.html#) definitions.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestResourceSearchParam {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Name of search parameter
    ///
    /// The name of the search parameter used in the interface.
    ///
    /// ## Implementation Notes
    /// Parameter names cannot overlap with standard parameter names, and standard
    /// parameters cannot be redefined.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub name: String,
    /// Source of definition for parameter
    ///
    /// An absolute URI that is a formal reference to where this parameter was first
    /// defined, so that a client can be confident of the meaning of the search
    /// parameter (a reference to
    /// [SearchParameter.url](searchparameter-definitions.html#SearchParameter.url)).
    /// This element SHALL be populated if the search parameter refers to a
    /// SearchParameter defined by the FHIR core specification or externally defined
    /// IGs.
    ///
    /// ## Implementation Notes
    /// This SHOULD be present, and matches refers to a SearchParameter by its
    /// canonical URL. If systems wish to document their support for modifiers,
    /// comparators, target resource types, and chained parameters, they should do
    /// using a search parameter resource. This element SHALL be populated if the
    /// search parameter refers to a SearchParameter defined by the FHIR core
    /// specification or externally defined IGs.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub definition: Option<Canonical>,
    /// number | date | string | token | reference | composite | quantity | uri | special
    ///
    /// The type of value a search parameter refers to, and how the content is
    /// interpreted.
    ///
    /// ## Implementation Notes
    /// While this can be looked up from the definition, it is included here as a
    /// convenience for systems that autogenerate a query interface based on the
    /// server capability statement. It SHALL be the same as the type in the search
    /// parameter definition.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Data types allowed to be used for search parameters.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/search-param-type|4.0.1
    #[fhir_serde(rename = "type")]
    pub r#type: Code,
    /// Server-specific usage
    ///
    /// This allows documentation of any distinct behaviors about how the search
    /// parameter is used. For example, text matching algorithms.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
}

/// Software that is covered by this capability statement
///
/// Software that is covered by this capability statement. It is used when the
/// capability statement describes the capabilities of a particular software
/// version, independent of an installation.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-2
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementSoftware {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// A name the software is known by
    ///
    /// Name the software is known by.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub name: String,
    /// Version covered by this statement
    ///
    /// The version identifier for the software covered by this statement.
    ///
    /// ## Implementation Notes
    /// If possible, a version should be specified, as statements are likely to be
    /// different for different versions of software.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub version: Option<String>,
    /// Date this version was released
    ///
    /// Date this version of the software was released.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "releaseDate")]
    pub release_date: Option<DateTime>,
}

/// If messaging is supported
///
/// A description of the messaging capabilities of the solution.
///
/// ## Implementation Notes
/// Multiple repetitions allow the documentation of multiple endpoints per
/// solution.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-1
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementMessaging {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Where messages should be sent
    ///
    /// An endpoint (network accessible address) to which messages and/or replies are
    /// to be sent.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// 3
    pub endpoint: Option<Vec<CapabilityStatementMessagingEndpoint>>,
    /// Reliable Message Cache Length (min)
    ///
    /// Length if the receiver's reliable messaging cache in minutes (if a receiver)
    /// or how long the cache length on the receiver should be (if a sender).
    ///
    /// ## Implementation Notes
    /// If this value is missing then the application does not implement (receiver)
    /// or depend on (sender) reliable messaging.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "reliableCache")]
    pub reliable_cache: Option<UnsignedInt>,
    /// Messaging interface behavior details
    ///
    /// Documentation about the system's messaging capabilities for this endpoint not
    /// otherwise documented by the capability statement. For example, the process
    /// for becoming an authorized messaging exchange partner.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
    /// Messages supported by this system
    ///
    /// References to message definitions for messages this system can send or
    /// receive.
    ///
    /// ## Implementation Notes
    /// This is a proposed alternative to the messaging.event structure.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportedMessage")]
    pub supported_message: Option<Vec<CapabilityStatementMessagingSupportedMessage>>,
}

/// If this describes a specific instance
///
/// Identifies a specific implementation instance that is described by the
/// capability statement - i.e. a particular installation, rather than the
/// capabilities of a software program.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-2, cpb-15
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementImplementation {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Describes this specific instance
    ///
    /// Information about the specific installation that this capability statement
    /// relates to.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: String,
    /// Base URL for the installation
    ///
    /// An absolute base URL for the implementation. This forms the base for REST
    /// interfaces as well as the mailbox and document interfaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Option<Url>,
    /// Organization that manages the data
    ///
    /// The organization responsible for the management of the instance and oversight
    /// of the data on the server at the specified URL.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub custodian: Option<Reference>,
}

/// Definition of a resource operation
///
/// Definition of an operation or a named query together with its parameters and
/// their meaning and type. Consult the definition of the operation for details
/// about how to invoke the operation, and the parameters.
///
/// ## Implementation Notes
/// Operations linked from CapabilityStatement.rest.resource.operation must have
/// OperationDefinition.type = true or OperationDefinition.instance = true.
///
/// If an operation that is listed in multiple
/// CapabilityStatement.rest.resource.operation (e.g. for different resource
/// types), then clients should understand that the operation is only supported
/// on the specified resource types, and that may be a subset of those listed in
/// OperationDefinition.resource.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestResourceOperation {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Name by which the operation/query is invoked
    ///
    /// The name of the operation or query. For an operation, this is the name
    /// prefixed with $ and used in the URL. For a query, this is the name used in
    /// the _query parameter when the query is called.
    ///
    /// ## Implementation Notes
    /// The name here SHOULD be the same as the name in the definition, unless there
    /// is a name clash and the name cannot be used. The name does not include the
    /// "$" portion that is always included in the URL.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub name: String,
    /// The defined operation/query
    ///
    /// Where the formal definition can be found. If a server references the base
    /// definition of an Operation (i.e. from the specification itself such as
    /// ```http://hl7.org/fhir/OperationDefinition/ValueSet-expand```), that means it
    /// supports the full capabilities of the operation - e.g. both GET and POST
    /// invocation. If it only supports a subset, it must define its own custom
    /// [OperationDefinition](operationdefinition.html#) with a 'base' of the
    /// original OperationDefinition. The custom definition would describe the
    /// specific subset of functionality supported.
    ///
    /// ## Implementation Notes
    /// This can be used to build an HTML form to invoke the operation, for instance.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub definition: Canonical,
    /// Specific details about operation behavior
    ///
    /// Documentation that describes anything special about the operation behavior,
    /// possibly detailing different behavior for system, type and instance-level
    /// invocation of the operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
}

/// Where messages should be sent
///
/// An endpoint (network accessible address) to which messages and/or replies are
/// to be sent.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Aliases
/// 3
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementMessagingEndpoint {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// http | ftp | mllp +
    ///
    /// A list of the messaging transport protocol(s) identifiers, supported by this
    /// endpoint.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: The protocol used for message transport.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/message-transport
    pub protocol: Coding,
    /// Network address or identifier of the end-point
    ///
    /// The network address of the endpoint. For solutions that do not use network
    /// addresses for routing, it can be just an identifier.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub address: Url,
}

/// Document definition
///
/// A document definition.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-1
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementDocument {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// producer | consumer
    ///
    /// Mode of this document declaration - whether an application is a producer or
    /// consumer.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Whether the application produces or consumes documents.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/document-mode|4.0.1
    pub mode: Code,
    /// Description of document support
    ///
    /// A description of how the application supports or uses the specified document
    /// profile. For example, when documents are created, what action is taken with
    /// consumed documents, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
    /// Constraint on the resources used in the document
    ///
    /// A profile on the document Bundle that constrains which resources are present,
    /// and their contents.
    ///
    /// ## Implementation Notes
    /// The profile is actually on the Bundle.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub profile: Canonical,
}

/// If the endpoint is a RESTful one
///
/// A definition of the restful capabilities of the solution, if any.
///
/// ## Implementation Notes
/// Multiple repetitions allow definition of both client and/or server behaviors
/// or possibly behaviors under different configuration settings (for software or
/// requirements statements).
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **cpb-9**: A given resource can only be described once per RESTful mode. (error)
///   Expression: `resource.select(type).isDistinct()`
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-1
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRest {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// client | server
    ///
    /// Identifies whether this portion of the statement is describing the ability to
    /// initiate or receive restful operations.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The mode of a RESTful capability statement.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/restful-capability-mode|4.0.1
    pub mode: Code,
    /// General description of implementation
    ///
    /// Information about the system's restful capabilities that apply across all
    /// applications, such as security.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
    /// Information about security of implementation
    ///
    /// Information about security implementation from an interface perspective -
    /// what a client needs to know.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub security: Option<CapabilityStatementRestSecurity>,
    /// Resource served on the REST interface
    ///
    /// A specification of the restful capabilities of the solution for a specific
    /// resource type.
    ///
    /// ## Implementation Notes
    /// Max of one repetition per resource type.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **cpb-12**: Search parameter names must be unique in the context of a resource. (error)
    ///   Expression: `searchParam.select(name).isDistinct()`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub resource: Option<Vec<CapabilityStatementRestResource>>,
    /// What operations are supported?
    ///
    /// A specification of restful operations supported by the system.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub interaction: Option<Vec<CapabilityStatementRestInteraction>>,
    /// Search parameters for searching all resources
    ///
    /// Search parameters that are supported for searching all resources for
    /// implementations to support and/or make use of - either references to ones
    /// defined in the specification, or additional ones defined for/by the
    /// implementation.
    ///
    /// ## Implementation Notes
    /// Typically, the only search parameters supported for all searches are those
    /// that apply to all resources - tags, profiles, text search etc. These search
    /// parameters should include the control search parameters such as _sort,
    /// _count, etc. that also apply to this resource (though many will be listed at
    /// [CapabilityStatement.rest.searchParam](capabilitystatement-definitions.html#CapabilityStatement.rest.searchParam)).
    /// The behavior of some search parameters may be further described by other code
    /// or extension elements, or narrative within the capability statement or linked
    /// [SearchParameter](searchparameter.html#) definitions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "searchParam")]
    pub search_param: Option<Vec<CapabilityStatementRestResourceSearchParam>>,
    /// Definition of a system level operation
    ///
    /// Definition of an operation or a named query together with its parameters and
    /// their meaning and type.
    ///
    /// ## Implementation Notes
    /// CapabilityStatement.rest.operation is for operations invoked at the system
    /// level, or for operations that are supported across multiple resource types.
    /// Operations linked from CapabilityStatement.rest.operation must have
    /// OperationDefinition.system = true, or more than one Operation.resource.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub operation: Option<Vec<CapabilityStatementRestResourceOperation>>,
    /// Compartments served/used by system
    ///
    /// An absolute URI which is a reference to the definition of a compartment that
    /// the system supports. The reference is to a CompartmentDefinition resource by
    /// its canonical URL .
    ///
    /// ## Implementation Notes
    /// At present, the only defined compartments are at
    /// [CompartmentDefinition](compartmentdefinition.html).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub compartment: Option<Vec<Canonical>>,
}

/// Information about security of implementation
///
/// Information about security implementation from an interface perspective -
/// what a client needs to know.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestSecurity {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Adds CORS Headers (http://enable-cors.org/)
    ///
    /// Server adds CORS headers when responding to requests - this enables
    /// Javascript applications to use the server.
    ///
    /// ## Implementation Notes
    /// The easiest CORS headers to add are Access-Control-Allow-Origin: * &
    /// Access-Control-Request-Method: GET, POST, PUT, DELETE. All servers SHOULD
    /// support CORS.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub cors: Option<Boolean>,
    /// OAuth | SMART-on-FHIR | NTLM | Basic | Kerberos | Certificates
    ///
    /// Types of security services that are supported/required by the system.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Types of security services used with FHIR.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/restful-security-service
    pub service: Option<Vec<CodeableConcept>>,
    /// General description of how security works
    ///
    /// General description of how security works.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<Markdown>,
}

/// What operations are supported?
///
/// A specification of restful operations supported by the system.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestInteraction {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// transaction | batch | search-system | history-system
    ///
    /// A coded identifier of the operation, supported by the system.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Operations supported by REST at the system level.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/system-restful-interaction|4.0.1
    pub code: Code,
    /// Anything special about operation behavior
    ///
    /// Guidance specific to the implementation of this operation, such as
    /// limitations on the kind of transactions allowed, or information about system
    /// wide search is implemented.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
}

/// Messages supported by this system
///
/// References to message definitions for messages this system can send or
/// receive.
///
/// ## Implementation Notes
/// This is a proposed alternative to the messaging.event structure.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementMessagingSupportedMessage {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// sender | receiver
    ///
    /// The mode of this event declaration - whether application is sender or
    /// receiver.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The mode of a message capability statement.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/event-capability-mode|4.0.1
    pub mode: Code,
    /// Message supported by this system
    ///
    /// Points to a message definition that identifies the messaging event, message
    /// structure, allowed responses, etc.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub definition: Canonical,
}

/// FHIR CapabilityStatement type
///
/// A Capability Statement documents a set of capabilities (behaviors) of a FHIR
/// Server for a particular version of FHIR that may be used as a statement of
/// actual server functionality or a statement of required or desired server
/// implementation.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: active
/// FHIR Version: 4.0.1
///
/// See: [CapabilityStatement](http://hl7.org/fhir/StructureDefinition/CapabilityStatement)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatement {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Canonical identifier for this capability statement, represented as a URI (globally unique)
    ///
    /// An absolute URI that is used to identify this capability statement when it is
    /// referenced in a specification, model, design or an instance; also called its
    /// canonical identifier. This SHOULD be globally unique and SHOULD be a literal
    /// address at which at which an authoritative instance of this capability
    /// statement is (or will be) published. This URL can be the target of a
    /// canonical reference. It SHALL remain the same when the capability statement
    /// is stored on different servers.
    ///
    /// ## Requirements
    /// Allows the capability statement to be referenced by a single globally unique
    /// identifier.
    ///
    /// ## Implementation Notes
    /// Can be a urn:uuid: or a urn:oid: but real http: addresses are preferred.
    /// Multiple instances may share the same URL if they have a distinct version.
    ///
    /// The determination of when to create a new version of a resource (same url,
    /// new version) vs. defining a new artifact is up to the author. Considerations
    /// for making this decision are found in [Technical and Business
    /// Versions](resource.html#versions).
    ///
    /// In some cases, the resource can no longer be found at the stated url, but the
    /// url itself cannot change. Implementations can use the
    /// [meta.source](resource.html#meta) element to indicate where the current
    /// master source of the resource can be found.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Option<Uri>,
    /// Business version of the capability statement
    ///
    /// The identifier that is used to identify this version of the capability
    /// statement when it is referenced in a specification, model, design or
    /// instance. This is an arbitrary value managed by the capability statement
    /// author and is not expected to be globally unique. For example, it might be a
    /// timestamp (e.g. yyyymmdd) if a managed version is not available. There is
    /// also no expectation that versions can be placed in a lexicographical
    /// sequence.
    ///
    /// ## Implementation Notes
    /// There may be different capability statement instances that have the same
    /// identifier but different versions. The version can be appended to the url in
    /// a reference to allow a reference to a particular business version of the
    /// capability statement with the format [url]|[version].
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub version: Option<String>,
    /// Name for this capability statement (computer friendly)
    ///
    /// A natural language name identifying the capability statement. This name
    /// should be usable as an identifier for the module by machine processing
    /// applications such as code generation.
    ///
    /// ## Requirements
    /// Support human navigation and code generation.
    ///
    /// ## Implementation Notes
    /// The name is not expected to be globally unique. The name should be a simple
    /// alphanumeric type name to ensure that it is machine-processing friendly.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: inv-0
    pub name: Option<String>,
    /// Name for this capability statement (human friendly)
    ///
    /// A short, descriptive, user-friendly title for the capability statement.
    ///
    /// ## Implementation Notes
    /// This name does not need to be machine-processing friendly and may contain
    /// punctuation, white-space, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// draft | active | retired | unknown
    ///
    /// The status of this capability statement. Enables tracking the life-cycle of
    /// the content.
    ///
    /// ## Implementation Notes
    /// Allows filtering of capability statements that are appropriate for use versus
    /// not.This is not intended for use with actual capability statements, but where
    /// capability statements are used to describe possible or desired systems.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This is labeled as "Is Modifier" because applications should not use a retired {{title}} without due consideration
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|4.0.1
    pub status: Code,
    /// For testing purposes, not real usage
    ///
    /// A Boolean value to indicate that this capability statement is authored for
    /// testing purposes (or education/evaluation/marketing) and is not intended to
    /// be used for genuine usage.
    ///
    /// ## Requirements
    /// Enables experimental content to be developed following the same lifecycle
    /// that would be used for a production-level capability statement.
    ///
    /// ## Implementation Notes
    /// Allows filtering of capability statements that are appropriate for use versus
    /// not.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub experimental: Option<Boolean>,
    /// Date last changed
    ///
    /// The date (and optionally time) when the capability statement was published.
    /// The date must change when the business version changes and it must change if
    /// the status code changes. In addition, it should change when the substantive
    /// content of the capability statement changes.
    ///
    /// ## Implementation Notes
    /// Note that this is not the same as the resource last-modified-date, since the
    /// resource may be a secondary representation of the capability statement.
    /// Additional specific dates may be added as extensions or be found by
    /// consulting Provenances associated with past versions of the resource.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Revision Date
    pub date: DateTime,
    /// Name of the publisher (organization or individual)
    ///
    /// The name of the organization or individual that published the capability
    /// statement.
    ///
    /// ## Requirements
    /// Helps establish the "authority/credibility" of the capability statement. May
    /// also allow for contact.
    ///
    /// ## Implementation Notes
    /// Usually an organization but may be an individual. The publisher (or steward)
    /// of the capability statement is the organization or individual primarily
    /// responsible for the maintenance and upkeep of the capability statement. This
    /// is not necessarily the same individual or organization that developed and
    /// initially authored the content. The publisher is the primary point of contact
    /// for questions or issues with the capability statement. This item SHOULD be
    /// populated unless the information is available from context.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub publisher: Option<String>,
    /// Contact details for the publisher
    ///
    /// Contact details to assist a user in finding and communicating with the
    /// publisher.
    ///
    /// ## Implementation Notes
    /// May be a web site, an email address, a telephone number, etc.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contact: Option<Vec<ContactDetail>>,
    /// Natural language description of the capability statement
    ///
    /// A free text natural language description of the capability statement from a
    /// consumer's perspective. Typically, this is used when the capability statement
    /// describes a desired rather than an actual solution, for example as a formal
    /// expression of requirements as part of an RFP.
    ///
    /// ## Implementation Notes
    /// This description can be used to capture details such as why the capability
    /// statement was built, comments about misuse, instructions for clinical use and
    /// interpretation, literature references, examples from the paper world, etc. It
    /// is not a rendering of the capability statement as conveyed in the 'text'
    /// field of the resource itself. This item SHOULD be populated unless the
    /// information is available from context (e.g. the language of the capability
    /// statement is presumed to be the predominant language in the place the
    /// capability statement was created).This does not need to be populated if the
    /// description is adequately implied by the software or implementation details.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-2
    pub description: Option<Markdown>,
    /// The context that the content is intended to support
    ///
    /// The content was developed with a focus and intent of supporting the contexts
    /// that are listed. These contexts may be general categories (gender, age, ...)
    /// or may be references to specific programs (insurance plans, studies, ...) and
    /// may be used to assist with indexing and searching for appropriate capability
    /// statement instances.
    ///
    /// ## Requirements
    /// Assist in searching for appropriate content.
    ///
    /// ## Implementation Notes
    /// When multiple useContexts are specified, there is no expectation that all or
    /// any of the contexts apply.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "useContext")]
    pub use_context: Option<Vec<UsageContext>>,
    /// Intended jurisdiction for capability statement (if applicable)
    ///
    /// A legal or geographic region in which the capability statement is intended to
    /// be used.
    ///
    /// ## Implementation Notes
    /// It may be possible for the capability statement to be used in jurisdictions
    /// other than those for which it was originally designed or intended.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Countries and regions within which this artifact is targeted for use.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/jurisdiction
    pub jurisdiction: Option<Vec<CodeableConcept>>,
    /// Why this capability statement is defined
    ///
    /// Explanation of why this capability statement is needed and why it has been
    /// designed as it has.
    ///
    /// ## Implementation Notes
    /// This element does not describe the usage of the capability statement.
    /// Instead, it provides traceability of ''why'' the resource is either needed or
    /// ''why'' it is defined as it is. This may be used to point to source materials
    /// or specifications that drove the structure of this capability statement.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub purpose: Option<Markdown>,
    /// Use and/or publishing restrictions
    ///
    /// A copyright statement relating to the capability statement and/or its
    /// contents. Copyright statements are generally legal restrictions on the use
    /// and publishing of the capability statement.
    ///
    /// ## Requirements
    /// Consumers must be able to determine any legal restrictions on the use of the
    /// capability statement and/or its content.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// License, Restrictions
    pub copyright: Option<Markdown>,
    /// instance | capability | requirements
    ///
    /// The way that this statement is intended to be used, to describe an actual
    /// running instance of software, a particular product (kind, not instance of
    /// software) or a class of implementation (e.g. a desired purchase).
    ///
    /// ## Requirements
    /// Allow searching the 3 modes.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: How a capability statement is intended to be used.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/capability-statement-kind|4.0.1
    ///
    /// ## Conditions
    /// Used when: cpb-15
    pub kind: Code,
    /// Canonical URL of another capability statement this implements
    ///
    /// Reference to a canonical URL of another CapabilityStatement that this
    /// software implements. This capability statement is a published API description
    /// that corresponds to a business service. The server may actually implement a
    /// subset of the capability statement it claims to implement, so the capability
    /// statement must specify the full capability details.
    ///
    /// ## Implementation Notes
    /// HL7 defines the following Services: [Terminology
    /// Service](terminology-service.html).
    ///
    /// Many [Implementation Guides](http://fhir.org/guides/registry) define
    /// additional services.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub instantiates: Option<Vec<Canonical>>,
    /// Canonical URL of another capability statement this adds to
    ///
    /// Reference to a canonical URL of another CapabilityStatement that this
    /// software adds to. The capability statement automatically includes everything
    /// in the other statement, and it is not duplicated, though the server may
    /// repeat the same resources, interactions and operations to add additional
    /// details to them.
    ///
    /// ## Implementation Notes
    /// the contents of any directly or indirectly imported CapabilityStatements
    /// SHALL NOT overlap, i.e. they cannot refer to the same rest/resource,
    /// operations/name, searchparam/name, interaction/code, messaging/endpoint,
    /// document/mode pair.
    ///
    /// A capability statement that imports another CapabilityStatement automatically
    /// instantiates it too (though this is often not a very useful statement for the
    /// kinds of CapabilityStatements that are suitable for importing).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub imports: Option<Vec<Canonical>>,
    /// Software that is covered by this capability statement
    ///
    /// Software that is covered by this capability statement. It is used when the
    /// capability statement describes the capabilities of a particular software
    /// version, independent of an installation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-2
    pub software: Option<CapabilityStatementSoftware>,
    /// If this describes a specific instance
    ///
    /// Identifies a specific implementation instance that is described by the
    /// capability statement - i.e. a particular installation, rather than the
    /// capabilities of a software program.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-2, cpb-15
    pub implementation: Option<CapabilityStatementImplementation>,
    /// FHIR Version the system supports
    ///
    /// The version of the FHIR specification that this CapabilityStatement describes
    /// (which SHALL be the same as the FHIR version of the CapabilityStatement
    /// itself). There is no default value.
    ///
    /// ## Implementation Notes
    /// Servers may implement multiple versions (see [Managing Multiple
    /// Versions](versioning.html), and the
    /// [$versions](capabilitystatement-operation-versions.html) operation). If they
    /// do, and the CapabilityStatement is requested from the server, then this
    /// fhirVersion will be either the version requested, or the server's default
    /// version.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: All published FHIR Versions.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/FHIR-version|4.0.1
    #[fhir_serde(rename = "fhirVersion")]
    pub fhir_version: Code,
    /// formats supported (xml | json | ttl | mime type)
    ///
    /// A list of the formats supported by this implementation using their content
    /// types.
    ///
    /// ## Implementation Notes
    /// "xml", "json" and "ttl" are allowed, which describe the simple encodings
    /// described in the specification (and imply appropriate bundle support).
    /// Otherwise, mime types are legal here.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The mime type of an attachment. Any valid mime type is allowed.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/mimetypes|4.0.1
    pub format: Option<Vec<Code>>,
    /// Patch formats supported
    ///
    /// A list of the patch formats supported by this implementation using their
    /// content types.
    ///
    /// ## Implementation Notes
    /// At present, the patch mime types application/json-patch+json and
    /// application/xml-patch+xml are legal. Generally, if a server supports PATCH,
    /// it would be expected to support the patch formats and match the formats it
    /// supports, but this is not always possible or necessary.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The mime type of an attachment. Any valid mime type is allowed.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/mimetypes|4.0.1
    #[fhir_serde(rename = "patchFormat")]
    pub patch_format: Option<Vec<Code>>,
    /// Implementation guides supported
    ///
    /// A list of implementation guides that the server does (or should) support in
    /// their entirety.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implementationGuide")]
    pub implementation_guide: Option<Vec<Canonical>>,
    /// If the endpoint is a RESTful one
    ///
    /// A definition of the restful capabilities of the solution, if any.
    ///
    /// ## Implementation Notes
    /// Multiple repetitions allow definition of both client and/or server behaviors
    /// or possibly behaviors under different configuration settings (for software or
    /// requirements statements).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **cpb-9**: A given resource can only be described once per RESTful mode. (error)
    ///   Expression: `resource.select(type).isDistinct()`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-1
    pub rest: Option<Vec<CapabilityStatementRest>>,
    /// If messaging is supported
    ///
    /// A description of the messaging capabilities of the solution.
    ///
    /// ## Implementation Notes
    /// Multiple repetitions allow the documentation of multiple endpoints per
    /// solution.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-1
    pub messaging: Option<Vec<CapabilityStatementMessaging>>,
    /// Document definition
    ///
    /// A document definition.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-1
    pub document: Option<Vec<CapabilityStatementDocument>>,
}

/// Choice of types for the scheduled\[x\] field in CarePlanActivityDetail
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "scheduled")]
pub enum CarePlanActivityDetailScheduled {
    /// Variant accepting the Timing type.
    #[fhir_serde(rename = "scheduledTiming")]
    Timing(Timing),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "scheduledPeriod")]
    Period(Period),
    /// Variant accepting the String type.
    #[fhir_serde(rename = "scheduledString")]
    String(String),
}

/// Choice of types for the product\[x\] field in CarePlanActivityDetail
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "product")]
pub enum CarePlanActivityDetailProduct {
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "productCodeableConcept")]
    CodeableConcept(CodeableConcept),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "productReference")]
    Reference(Reference),
}

/// In-line definition of activity
///
/// A simple summary of a planned activity suitable for a general care plan
/// system (e.g. form driven) that doesn't know about specific resources such as
/// procedure etc.
///
/// ## Requirements
/// Details in a simple form for generic care plan systems.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpl-3
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "scheduled,product")]
pub struct CarePlanActivityDetail {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Appointment | CommunicationRequest | DeviceRequest | MedicationRequest | NutritionOrder | Task | ServiceRequest | VisionPrescription
    ///
    /// A description of the kind of resource the in-line definition of a care plan
    /// activity is representing. The CarePlan.activity.detail is an in-line
    /// definition when a resource is not referenced using
    /// CarePlan.activity.reference. For example, a MedicationRequest, a
    /// ServiceRequest, or a CommunicationRequest.
    ///
    /// ## Requirements
    /// May determine what types of extensions are permitted.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Resource types defined as part of FHIR that can be represented as in-line definitions of a care plan activity.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-plan-activity-kind|4.0.1
    pub kind: Option<Code>,
    /// Instantiates FHIR protocol or definition
    ///
    /// The URL pointing to a FHIR-defined protocol, guideline, questionnaire or
    /// other definition that is adhered to in whole or in part by this CarePlan
    /// activity.
    ///
    /// ## Requirements
    /// Allows Questionnaires that the patient (or practitioner) should fill in to
    /// fulfill the care plan activity.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "instantiatesCanonical")]
    pub instantiates_canonical: Option<Vec<Canonical>>,
    /// Instantiates external protocol or definition
    ///
    /// The URL pointing to an externally maintained protocol, guideline,
    /// questionnaire or other definition that is adhered to in whole or in part by
    /// this CarePlan activity.
    ///
    /// ## Requirements
    /// Allows Questionnaires that the patient (or practitioner) should fill in to
    /// fulfill the care plan activity.
    ///
    /// ## Implementation Notes
    /// This might be an HTML page, PDF, etc. or could just be a non-resolvable URI
    /// identifier.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "instantiatesUri")]
    pub instantiates_uri: Option<Vec<Uri>>,
    /// Detail type of activity
    ///
    /// Detailed description of the type of planned activity; e.g. what lab test,
    /// what procedure, what kind of encounter.
    ///
    /// ## Requirements
    /// Allows matching performed to planned as well as validation against protocols.
    ///
    /// ## Implementation Notes
    /// Tends to be less relevant for activities involving particular products. Codes
    /// should not convey negation - use "prohibited" instead.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/procedure-code
    pub code: Option<CodeableConcept>,
    /// Why activity should be done or why activity was prohibited
    ///
    /// Provides the rationale that drove the inclusion of this particular activity
    /// as part of the plan or the reason why the activity was prohibited.
    ///
    /// ## Implementation Notes
    /// This could be a diagnosis code. If a full condition record exists or
    /// additional detail is needed, use reasonCondition instead.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Identifies why a care plan activity is needed.  Can include any health condition codes as well as such concepts as "general wellness", prophylaxis, surgical preparation, etc.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/clinical-findings
    #[fhir_serde(rename = "reasonCode")]
    pub reason_code: Option<Vec<CodeableConcept>>,
    /// Why activity is needed
    ///
    /// Indicates another resource, such as the health condition(s), whose existence
    /// justifies this request and drove the inclusion of this particular activity as
    /// part of the plan.
    ///
    /// ## Implementation Notes
    /// Conditions can be identified at the activity level that are not identified as
    /// reasons for the overall plan.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "reasonReference")]
    pub reason_reference: Option<Vec<Reference>>,
    /// Goals this activity relates to
    ///
    /// Internal reference that identifies the goals that this activity is intended
    /// to contribute towards meeting.
    ///
    /// ## Requirements
    /// So that participants know the link explicitly.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub goal: Option<Vec<Reference>>,
    /// not-started | scheduled | in-progress | on-hold | completed | cancelled | stopped | unknown | entered-in-error
    ///
    /// Identifies what progress is being made for the specific activity.
    ///
    /// ## Requirements
    /// Indicates progress against the plan, whether the activity is still relevant
    /// for the plan.
    ///
    /// ## Implementation Notes
    /// Some aspects of status can be inferred based on the resources linked in
    /// actionTaken. Note that "status" is only as current as the plan was most
    /// recently updated.
    /// The unknown code is not to be used to convey other statuses. The unknown code
    /// should be used when one of the statuses applies, but the authoring system
    /// doesn't know the current state of the activity.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the activity should not be treated as valid
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Codes that reflect the current state of a care plan activity within its overall life cycle.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-plan-activity-status|4.0.1
    pub status: Code,
    /// Reason for current status
    ///
    /// Provides reason why the activity isn't yet started, is on hold, was
    /// cancelled, etc.
    ///
    /// ## Implementation Notes
    /// Will generally not be present if status is "complete". Be sure to prompt to
    /// update this (or at least remove the existing value) if the status is changed.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "statusReason")]
    pub status_reason: Option<CodeableConcept>,
    /// If true, activity is prohibiting action
    ///
    /// If true, indicates that the described activity is one that must NOT be
    /// engaged in when following the plan. If false, or missing, indicates that the
    /// described activity is one that should be engaged in when following the plan.
    ///
    /// ## Requirements
    /// Captures intention to not do something that may have been previously typical.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because it marks an activity as an
    /// activity that is not to be performed.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - If true this element negates the specified action. For example, instead of a request for a procedure, it is a request for the procedure to not occur.
    /// - When missing: If missing indicates that the described activity is one that should be engaged in when following the plan.
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "doNotPerform")]
    pub do_not_perform: Option<Boolean>,
    /// When activity is to occur
    ///
    /// The period, timing or frequency upon which the described activity is to
    /// occur.
    ///
    /// ## Requirements
    /// Allows prompting for activities and detection of missed planned activities.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub scheduled: Option<CarePlanActivityDetailScheduled>,
    /// Where it should happen
    ///
    /// Identifies the facility where the activity will occur; e.g. home, hospital,
    /// specific clinic, etc.
    ///
    /// ## Requirements
    /// Helps in planning of activity.
    ///
    /// ## Implementation Notes
    /// May reference a specific clinical location or may identify a type of
    /// location.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub location: Option<Reference>,
    /// Who will be responsible?
    ///
    /// Identifies who's expected to be involved in the activity.
    ///
    /// ## Requirements
    /// Helps in planning of activity.
    ///
    /// ## Implementation Notes
    /// A performer MAY also be a participant in the care plan.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub performer: Option<Vec<Reference>>,
    /// What is to be administered/supplied
    ///
    /// Identifies the food, drug or other product to be consumed or supplied in the
    /// activity.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A product supplied or administered as part of a care plan activity.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/medication-codes
    #[fhir_serde(flatten)]
    pub product: Option<CarePlanActivityDetailProduct>,
    /// How to consume/day?
    ///
    /// Identifies the quantity expected to be consumed in a given day.
    ///
    /// ## Requirements
    /// Allows rough dose checking.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// daily dose
    #[fhir_serde(rename = "dailyAmount")]
    pub daily_amount: Option<Quantity>,
    /// How much to administer/supply/consume
    ///
    /// Identifies the quantity expected to be supplied, administered or consumed by
    /// the subject.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// Extra info describing activity to perform
    ///
    /// This provides a textual description of constraints on the intended activity
    /// occurrence, including relation to other activities. It may also include
    /// objectives, pre-conditions and end-conditions. Finally, it may convey
    /// specifics about the activity such as body site, method, route, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
}

/// FHIR CarePlan type
///
/// Describes the intention of how one or more practitioners intend to deliver
/// care for a particular patient, group or community for a period of time,
/// possibly limited to care for a specific condition or set of conditions.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [CarePlan](http://hl7.org/fhir/StructureDefinition/CarePlan)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CarePlan {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External Ids for this plan
    ///
    /// Business identifiers assigned to this care plan by the performer or other
    /// systems which remain constant as the resource is updated and propagates from
    /// server to server.
    ///
    /// ## Requirements
    /// Allows identification of the care plan as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Implementation Notes
    /// This is a business identifier, not a resource identifier (see
    /// [discussion](resource.html#identifiers)). It is best practice for the
    /// identifier to only appear on a single resource instance, however business
    /// practices may occasionally dictate that multiple resource instances with the
    /// same identifier can exist - possibly even with different resource types. For
    /// example, multiple Patient and a Person resource instance might share the same
    /// social insurance number.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Instantiates FHIR protocol or definition
    ///
    /// The URL pointing to a FHIR-defined protocol, guideline, questionnaire or
    /// other definition that is adhered to in whole or in part by this CarePlan.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "instantiatesCanonical")]
    pub instantiates_canonical: Option<Vec<Canonical>>,
    /// Instantiates external protocol or definition
    ///
    /// The URL pointing to an externally maintained protocol, guideline,
    /// questionnaire or other definition that is adhered to in whole or in part by
    /// this CarePlan.
    ///
    /// ## Implementation Notes
    /// This might be an HTML page, PDF, etc. or could just be a non-resolvable URI
    /// identifier.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "instantiatesUri")]
    pub instantiates_uri: Option<Vec<Uri>>,
    /// Fulfills CarePlan
    ///
    /// A care plan that is fulfilled in whole or in part by this care plan.
    ///
    /// ## Requirements
    /// Allows tracing of the care plan and tracking whether
    /// proposals/recommendations were acted upon.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// fulfills
    #[fhir_serde(rename = "basedOn")]
    pub based_on: Option<Vec<Reference>>,
    /// CarePlan replaced by this CarePlan
    ///
    /// Completed or terminated care plan whose function is taken by this new care
    /// plan.
    ///
    /// ## Requirements
    /// Allows tracing the continuation of a therapy or administrative process
    /// instantiated through multiple care plans.
    ///
    /// ## Implementation Notes
    /// The replacement could be because the initial care plan was immediately
    /// rejected (due to an issue) or because the previous care plan was completed,
    /// but the need for the action described by the care plan remains ongoing.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// supersedes
    pub replaces: Option<Vec<Reference>>,
    /// Part of referenced CarePlan
    ///
    /// A larger care plan of which this particular care plan is a component or step.
    ///
    /// ## Implementation Notes
    /// Each care plan is an independent request, such that having a care plan be
    /// part of another care plan can cause issues with cascading statuses. As such,
    /// this element is still being discussed.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "partOf")]
    pub part_of: Option<Vec<Reference>>,
    /// draft | active | on-hold | revoked | completed | entered-in-error | unknown
    ///
    /// Indicates whether the plan is currently being acted upon, represents future
    /// intentions or is now a historical record.
    ///
    /// ## Requirements
    /// Allows clinicians to determine whether the plan is actionable or not.
    ///
    /// ## Implementation Notes
    /// The unknown code is not to be used to convey other statuses. The unknown code
    /// should be used when one of the statuses applies, but the authoring system
    /// doesn't know the current state of the care plan.
    ///
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that marks the plan as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/request-status|4.0.1
    pub status: Code,
    /// proposal | plan | order | option
    ///
    /// Indicates the level of authority/intentionality associated with the care plan
    /// and where the care plan fits into the workflow chain.
    ///
    /// ## Requirements
    /// Proposals/recommendations, plans and orders all use the same structure and
    /// can exist in the same fulfillment chain.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because the intent alters when and how
    /// the resource is actually applicable.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element changes the interpretation of all descriptive attributes. For example "the time the request is recommended to occur" vs. "the time the request is authorized to occur" or "who is recommended to perform the request" vs. "who is authorized to perform the request"
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Codes indicating the degree of authority/intentionality associated with a care plan.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-plan-intent|4.0.1
    pub intent: Code,
    /// Type of plan
    ///
    /// Identifies what "kind" of plan this is to support differentiation between
    /// multiple co-existing plans; e.g. "Home health", "psychiatric", "asthma",
    /// "disease management", "wellness plan", etc.
    ///
    /// ## Requirements
    /// Used for filtering what plan(s) are retrieved and displayed to different
    /// types of users.
    ///
    /// ## Implementation Notes
    /// There may be multiple axes of categorization and one plan may serve multiple
    /// purposes. In some cases, this may be redundant with references to
    /// CarePlan.concern.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Identifies what "kind" of plan this is to support differentiation between multiple co-existing plans; e.g. "Home health", "psychiatric", "asthma", "disease management", etc.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-plan-category
    pub category: Option<Vec<CodeableConcept>>,
    /// Human-friendly name for the care plan
    ///
    /// Human-friendly name for the care plan.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// Summary of nature of plan
    ///
    /// A description of the scope and nature of the plan.
    ///
    /// ## Requirements
    /// Provides more detail than conveyed by category.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Who the care plan is for
    ///
    /// Identifies the patient or group whose intended care is described by the plan.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// patient
    pub subject: Reference,
    /// Encounter created as part of
    ///
    /// The Encounter during which this CarePlan was created or to which the creation
    /// of this record is tightly associated.
    ///
    /// ## Implementation Notes
    /// This will typically be the encounter the event occurred within, but some
    /// activities may be initiated prior to or after the official completion of an
    /// encounter but still be tied to the context of the encounter. CarePlan
    /// activities conducted as a result of the care plan may well occur as part of
    /// other encounters.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Reference>,
    /// Time period plan covers
    ///
    /// Indicates when the plan did (or is intended to) come into effect and end.
    ///
    /// ## Requirements
    /// Allows tracking what plan(s) are in effect at a particular time.
    ///
    /// ## Implementation Notes
    /// Any activities scheduled as part of the plan should be constrained to the
    /// specified period regardless of whether the activities are planned within a
    /// single encounter/episode or across multiple encounters/episodes (e.g. the
    /// longitudinal management of a chronic condition).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// timing
    pub period: Option<Period>,
    /// Date record was first recorded
    ///
    /// Represents when this particular CarePlan record was created in the system,
    /// which is often a system-generated date.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// authoredOn
    pub created: Option<DateTime>,
    /// Who is the designated responsible party
    ///
    /// When populated, the author is responsible for the care plan. The care plan is
    /// attributed to the author.
    ///
    /// ## Implementation Notes
    /// The author may also be a contributor. For example, an organization can be an
    /// author, but not listed as a contributor.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub author: Option<Reference>,
    /// Who provided the content of the care plan
    ///
    /// Identifies the individual(s) or organization who provided the contents of the
    /// care plan.
    ///
    /// ## Implementation Notes
    /// Collaborative care plans may have multiple contributors.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contributor: Option<Vec<Reference>>,
    /// Who's involved in plan?
    ///
    /// Identifies all people and organizations who are expected to be involved in
    /// the care envisioned by this plan.
    ///
    /// ## Requirements
    /// Allows representation of care teams, helps scope care plan. In some cases may
    /// be a determiner of access permissions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "careTeam")]
    pub care_team: Option<Vec<Reference>>,
    /// Health issues this plan addresses
    ///
    /// Identifies the conditions/problems/concerns/diagnoses/etc. whose management
    /// and/or mitigation are handled by this plan.
    ///
    /// ## Requirements
    /// Links plan to the conditions it manages. The element can identify risks
    /// addressed by the plan as well as active conditions. (The Condition resource
    /// can include things like "at risk for hypertension" or "fall risk".) Also
    /// scopes plans - multiple plans may exist addressing different concerns.
    ///
    /// ## Implementation Notes
    /// When the diagnosis is related to an allergy or intolerance, the Condition and
    /// AllergyIntolerance resources can both be used. However, to be actionable for
    /// decision support, using Condition alone is not sufficient as the allergy or
    /// intolerance condition needs to be represented as an AllergyIntolerance.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub addresses: Option<Vec<Reference>>,
    /// Information considered as part of plan
    ///
    /// Identifies portions of the patient's record that specifically influenced the
    /// formation of the plan. These might include comorbidities, recent procedures,
    /// limitations, recent assessments, etc.
    ///
    /// ## Requirements
    /// Identifies barriers and other considerations associated with the care plan.
    ///
    /// ## Implementation Notes
    /// Use "concern" to identify specific conditions addressed by the care plan.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportingInfo")]
    pub supporting_info: Option<Vec<Reference>>,
    /// Desired outcome of plan
    ///
    /// Describes the intended objective(s) of carrying out the care plan.
    ///
    /// ## Requirements
    /// Provides context for plan. Allows plan effectiveness to be evaluated by
    /// clinicians.
    ///
    /// ## Implementation Notes
    /// Goal can be achieving a particular change or merely maintaining a current
    /// state or even slowing a decline.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub goal: Option<Vec<Reference>>,
    /// Action to occur as part of plan
    ///
    /// Identifies a planned action to occur as part of the plan. For example, a
    /// medication to be used, lab tests to perform, self-monitoring, education, etc.
    ///
    /// ## Requirements
    /// Allows systems to prompt for performance of planned activities, and validate
    /// plans against best practice.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **cpl-3**: Provide a reference or detail, not both (error)
    ///   Expression: `detail.empty() or reference.empty()`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub activity: Option<Vec<CarePlanActivity>>,
    /// Comments about the plan
    ///
    /// General notes about the care plan not covered elsewhere.
    ///
    /// ## Requirements
    /// Used to capture information that applies to the plan as a whole that doesn't
    /// fit into discrete elements.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
}

/// Action to occur as part of plan
///
/// Identifies a planned action to occur as part of the plan. For example, a
/// medication to be used, lab tests to perform, self-monitoring, education, etc.
///
/// ## Requirements
/// Allows systems to prompt for performance of planned activities, and validate
/// plans against best practice.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **cpl-3**: Provide a reference or detail, not both (error)
///   Expression: `detail.empty() or reference.empty()`
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CarePlanActivity {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Results of the activity
    ///
    /// Identifies the outcome at the point when the status of the activity is
    /// assessed. For example, the outcome of an education activity could be patient
    /// understands (or not).
    ///
    /// ## Implementation Notes
    /// Note that this should not duplicate the activity status (e.g. completed or in
    /// progress).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Identifies the results of the activity.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-plan-activity-outcome
    #[fhir_serde(rename = "outcomeCodeableConcept")]
    pub outcome_codeable_concept: Option<Vec<CodeableConcept>>,
    /// Appointment, Encounter, Procedure, etc.
    ///
    /// Details of the outcome or action resulting from the activity. The reference
    /// to an "event" resource, such as Procedure or Encounter or Observation, is the
    /// result/outcome of the activity itself. The activity can be conveyed using
    /// CarePlan.activity.detail OR using the CarePlan.activity.reference (a
    /// reference to a “request” resource).
    ///
    /// ## Requirements
    /// Links plan to resulting actions.
    ///
    /// ## Implementation Notes
    /// The activity outcome is independent of the outcome of the related goal(s).
    /// For example, if the goal is to achieve a target body weight of 150 lbs and an
    /// activity is defined to diet, then the activity outcome could be calories
    /// consumed whereas the goal outcome is an observation for the actual body
    /// weight measured.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "outcomeReference")]
    pub outcome_reference: Option<Vec<Reference>>,
    /// Comments about the activity status/progress
    ///
    /// Notes about the adherence/status/progress of the activity.
    ///
    /// ## Requirements
    /// Can be used to capture information about adherence, progress, concerns, etc.
    ///
    /// ## Implementation Notes
    /// This element should NOT be used to describe the activity to be performed -
    /// that occurs either within the resource pointed to by
    /// activity.detail.reference or in activity.detail.description.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub progress: Option<Vec<Annotation>>,
    /// Activity details defined in specific resource
    ///
    /// The details of the proposed activity represented in a specific resource.
    ///
    /// ## Requirements
    /// Details in a form consistent with other applications and contexts of use.
    ///
    /// ## Implementation Notes
    /// Standard extension exists
    /// ([resource-pertainsToGoal](extension-resource-pertainstogoal.html)) that
    /// allows goals to be referenced from any of the referenced resources in
    /// CarePlan.activity.reference.
    /// The goal should be visible when the resource referenced by
    /// CarePlan.activity.reference is viewed independently from the CarePlan.
    /// Requests that are pointed to by a CarePlan using this element should *not*
    /// point to this CarePlan using the "basedOn" element. i.e. Requests that are
    /// part of a CarePlan are not "based on" the CarePlan.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpl-3
    pub reference: Option<Reference>,
    /// In-line definition of activity
    ///
    /// A simple summary of a planned activity suitable for a general care plan
    /// system (e.g. form driven) that doesn't know about specific resources such as
    /// procedure etc.
    ///
    /// ## Requirements
    /// Details in a simple form for generic care plan systems.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpl-3
    pub detail: Option<CarePlanActivityDetail>,
}

/// FHIR CareTeam type
///
/// The Care Team includes all the people and organizations who plan to
/// participate in the coordination and delivery of care for a patient.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [CareTeam](http://hl7.org/fhir/StructureDefinition/CareTeam)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CareTeam {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External Ids for this team
    ///
    /// Business identifiers assigned to this care team by the performer or other
    /// systems which remain constant as the resource is updated and propagates from
    /// server to server.
    ///
    /// ## Requirements
    /// Allows identification of the care team as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Implementation Notes
    /// This is a business identifier, not a resource identifier (see
    /// [discussion](resource.html#identifiers)). It is best practice for the
    /// identifier to only appear on a single resource instance, however business
    /// practices may occasionally dictate that multiple resource instances with the
    /// same identifier can exist - possibly even with different resource types. For
    /// example, multiple Patient and a Person resource instance might share the same
    /// social insurance number.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// proposed | active | suspended | inactive | entered-in-error
    ///
    /// Indicates the current state of the care team.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that marks the care team as not currently valid.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicates the status of the care team.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-team-status|4.0.1
    pub status: Option<Code>,
    /// Type of team
    ///
    /// Identifies what kind of team. This is to support differentiation between
    /// multiple co-existing teams, such as care plan team, episode of care team,
    /// longitudinal care team.
    ///
    /// ## Requirements
    /// Used for filtering what teams(s) are retrieved and displayed to different
    /// types of users.
    ///
    /// ## Implementation Notes
    /// There may be multiple axis of categorization and one team may serve multiple
    /// purposes.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Indicates the type of care team.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-team-category
    pub category: Option<Vec<CodeableConcept>>,
    /// Name of the team, such as crisis assessment team
    ///
    /// A label for human use intended to distinguish like teams. E.g. the "red" vs.
    /// "green" trauma teams.
    ///
    /// ## Implementation Notes
    /// The meaning/purpose of the team is conveyed in CareTeam.category. This
    /// element may also convey semantics of the team (e.g. "Red trauma team"), but
    /// its primary purpose is to distinguish between identical teams in a
    /// human-friendly way. ("Team 18735" isn't as friendly.).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub name: Option<String>,
    /// Who care team is for
    ///
    /// Identifies the patient or group whose intended care is handled by the team.
    ///
    /// ## Requirements
    /// Allows the team to care for a group (e.g. marriage) therapy.
    /// Allows for an organization to designate a team such as the PICC line team.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// patient
    pub subject: Option<Reference>,
    /// Encounter created as part of
    ///
    /// The Encounter during which this CareTeam was created or to which the creation
    /// of this record is tightly associated.
    ///
    /// ## Implementation Notes
    /// This will typically be the encounter the event occurred within, but some
    /// activities may be initiated prior to or after the official completion of an
    /// encounter but still be tied to the context of the encounter.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Reference>,
    /// Time period team covers
    ///
    /// Indicates when the team did (or is intended to) come into effect and end.
    ///
    /// ## Requirements
    /// Allows tracking what team(s) are in effect at a particular time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub period: Option<Period>,
    /// Members of the team
    ///
    /// Identifies all people and organizations who are expected to be involved in
    /// the care team.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ctm-1**: CareTeam.participant.onBehalfOf can only be populated when CareTeam.participant.member is a Practitioner (error)
    ///   Expression: `onBehalfOf.exists() implies (member.resolve().iif(empty(), true, ofType(Practitioner).exists()))`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: ctm-1
    pub participant: Option<Vec<CareTeamParticipant>>,
    /// Why the care team exists
    ///
    /// Describes why the care team exists.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Indicates the reason for the care team.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/clinical-findings
    #[fhir_serde(rename = "reasonCode")]
    pub reason_code: Option<Vec<CodeableConcept>>,
    /// Why the care team exists
    ///
    /// Condition(s) that this care team addresses.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "reasonReference")]
    pub reason_reference: Option<Vec<Reference>>,
    /// Organization responsible for the care team
    ///
    /// The organization responsible for the care team.
    ///
    /// ## Requirements
    /// Allows for multiple organizations to collaboratively manage
    /// cross-organizational, longitudinal care plan.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "managingOrganization")]
    pub managing_organization: Option<Vec<Reference>>,
    /// A contact detail for the care team (that applies to all members)
    ///
    /// A central contact detail for the care team (that applies to all members).
    ///
    /// ## Implementation Notes
    /// The ContactPoint.use code of home is not appropriate to use. These contacts
    /// are not the contact details of individual care team members.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub telecom: Option<Vec<ContactPoint>>,
    /// Comments made about the CareTeam
    ///
    /// Comments made about the CareTeam.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
}

/// Members of the team
///
/// Identifies all people and organizations who are expected to be involved in
/// the care team.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ctm-1**: CareTeam.participant.onBehalfOf can only be populated when CareTeam.participant.member is a Practitioner (error)
///   Expression: `onBehalfOf.exists() implies (member.resolve().iif(empty(), true, ofType(Practitioner).exists()))`
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: ctm-1
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CareTeamParticipant {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Type of involvement
    ///
    /// Indicates specific responsibility of an individual within the care team, such
    /// as "Primary care physician", "Trained social worker counselor", "Caregiver",
    /// etc.
    ///
    /// ## Implementation Notes
    /// Roles may sometimes be inferred by type of Practitioner. These are
    /// relationships that hold only within the context of the care team. General
    /// relationships should be handled as properties of the Patient resource
    /// directly.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Indicates specific responsibility of an individual within the care team, such as "Primary physician", "Team coordinator", "Caregiver", etc.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/participant-role
    pub role: Option<Vec<CodeableConcept>>,
    /// Who is involved
    ///
    /// The specific person or organization who is participating/expected to
    /// participate in the care team.
    ///
    /// ## Implementation Notes
    /// Patient only needs to be listed if they have a role other than "subject of
    /// care".
    ///
    /// Member is optional because some participants may be known only by their role,
    /// particularly in draft plans.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub member: Option<Reference>,
    /// Organization of the practitioner
    ///
    /// The organization of the practitioner.
    ///
    /// ## Requirements
    /// Practitioners can be associated with multiple organizations. This element
    /// indicates which organization they were acting on behalf of.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "onBehalfOf")]
    pub on_behalf_of: Option<Reference>,
    /// Time period of participant
    ///
    /// Indicates when the specific member or organization did (or is intended to)
    /// come into effect and end.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub period: Option<Period>,
}

/// FHIR CatalogEntry type
///
/// Catalog entries are wrappers that contextualize items included in a catalog.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [CatalogEntry](http://hl7.org/fhir/StructureDefinition/CatalogEntry)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CatalogEntry {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Unique identifier of the catalog item
    ///
    /// Used in supporting different identifiers for the same product, e.g.
    /// manufacturer code and retailer code.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// The type of item - medication, device, service, protocol or other
    ///
    /// The type of item - medication, device, service, protocol or other.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "type")]
    pub r#type: Option<CodeableConcept>,
    /// Whether the entry represents an orderable item
    ///
    /// Whether the entry represents an orderable item.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub orderable: Boolean,
    /// The item that is being defined
    ///
    /// The item in a catalog or definition.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "referencedItem")]
    pub referenced_item: Reference,
    /// Any additional identifier(s) for the catalog item, in the same granularity or concept
    ///
    /// Used in supporting related concepts, e.g. NDC to RxNorm.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "additionalIdentifier")]
    pub additional_identifier: Option<Vec<Identifier>>,
    /// Classification (category or class) of the item entry
    ///
    /// Classes of devices, or ATC for medication.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub classification: Option<Vec<CodeableConcept>>,
    /// draft | active | retired | unknown
    ///
    /// Used to support catalog exchange even for unsupported products, e.g. getting
    /// list of medications even if not prescribable.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|4.0.1
    pub status: Option<Code>,
    /// The time period in which this catalog entry is expected to be active
    ///
    /// The time period in which this catalog entry is expected to be active.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "validityPeriod")]
    pub validity_period: Option<Period>,
    /// The date until which this catalog entry is expected to be active
    ///
    /// The date until which this catalog entry is expected to be active.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "validTo")]
    pub valid_to: Option<DateTime>,
    /// When was this catalog last updated
    ///
    /// Typically date of issue is different from the beginning of the validity. This
    /// can be used to see when an item was last updated.
    ///
    /// ## Implementation Notes
    /// Perhaps not needed - if we use fhir resource metadata.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastUpdated")]
    pub last_updated: Option<DateTime>,
    /// Additional characteristics of the catalog entry
    ///
    /// Used for examplefor Out of Formulary, or any specifics.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "additionalCharacteristic")]
    pub additional_characteristic: Option<Vec<CodeableConcept>>,
    /// Additional classification of the catalog entry
    ///
    /// User for example for ATC classification, or.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "additionalClassification")]
    pub additional_classification: Option<Vec<CodeableConcept>>,
    /// An item that this catalog entry is related to
    ///
    /// Used for example, to point to a substance, or to a device used to administer
    /// a medication.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "relatedEntry")]
    pub related_entry: Option<Vec<CatalogEntryRelatedEntry>>,
}

/// An item that this catalog entry is related to
///
/// Used for example, to point to a substance, or to a device used to administer
/// a medication.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CatalogEntryRelatedEntry {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// triggers | is-replaced-by
    ///
    /// The type of relation to the related item: child, parent, packageContent,
    /// containerPackage, usedIn, uses, requires, etc.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The type of relations between entries.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/relation-type|4.0.1
    pub relationtype: Code,
    /// The reference to the related item
    ///
    /// The reference to the related item.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub item: Reference,
}

/// Who performed charged service
///
/// Indicates who or what performed or participated in the charged service.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ChargeItemPerformer {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// What type of performance was done
    ///
    /// Describes the type of performance or participation(e.g. primary surgeon,
    /// anesthesiologiest, etc.).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing the types of functional roles performers can take on when performing events.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/performer-role
    pub function: Option<CodeableConcept>,
    /// Individual who was performing
    ///
    /// The device, practitioner, etc. who performed or participated in the service.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub actor: Reference,
}

/// Choice of types for the occurrence\[x\] field in ChargeItem
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "occurrence")]
pub enum ChargeItemOccurrence {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "occurrenceDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "occurrencePeriod")]
    Period(Period),
    /// Variant accepting the Timing type.
    #[fhir_serde(rename = "occurrenceTiming")]
    Timing(Timing),
}

/// Choice of types for the product\[x\] field in ChargeItem
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "product")]
pub enum ChargeItemProduct {
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "productReference")]
    Reference(Reference),
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "productCodeableConcept")]
    CodeableConcept(CodeableConcept),
}

/// FHIR ChargeItem type
///
/// The resource ChargeItem describes the provision of healthcare provider
/// products for a certain patient, therefore referring not only to the product,
/// but containing in addition details of the provision, like date, time, amounts
/// and participating organizations and persons. Main Usage of the ChargeItem is
/// to enable the billing process and internal cost allocation.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [ChargeItem](http://hl7.org/fhir/StructureDefinition/ChargeItem)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "occurrence,product")]
pub struct ChargeItem {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Business Identifier for item
    ///
    /// Identifiers assigned to this event performer or other systems.
    ///
    /// ## Requirements
    /// Allows identification of the charge Item as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Defining information about the code of this charge item
    ///
    /// References the (external) source of pricing information, rules of application
    /// for the code this ChargeItem uses.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "definitionUri")]
    pub definition_uri: Option<Vec<Uri>>,
    /// Resource defining the code of this ChargeItem
    ///
    /// References the source of pricing information, rules of application for the
    /// code this ChargeItem uses.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "definitionCanonical")]
    pub definition_canonical: Option<Vec<Canonical>>,
    /// planned | billable | not-billable | aborted | billed | entered-in-error | unknown
    ///
    /// The current state of the ChargeItem.
    ///
    /// ## Implementation Notes
    /// Unknown does not represent "other" - one of the defined statuses must apply.
    /// Unknown is used when the authoring system is not sure what the current status
    /// is.
    ///
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that marks the charge item as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Codes identifying the lifecycle stage of a ChargeItem.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/chargeitem-status|4.0.1
    pub status: Code,
    /// Part of referenced ChargeItem
    ///
    /// ChargeItems can be grouped to larger ChargeItems covering the whole set.
    ///
    /// ## Requirements
    /// E.g. Drug administration as part of a procedure, procedure as part of
    /// observation, etc.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// container
    #[fhir_serde(rename = "partOf")]
    pub part_of: Option<Vec<Reference>>,
    /// A code that identifies the charge, like a billing code
    ///
    /// A code that identifies the charge, like a billing code.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Example set of codes that can be used for billing purposes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/chargeitem-billingcodes
    ///
    /// ## Aliases
    /// type
    pub code: CodeableConcept,
    /// Individual service was done for/to
    ///
    /// The individual or set of individuals the action is being or was performed on.
    ///
    /// ## Requirements
    /// Links the event to the Patient context.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// patient
    pub subject: Reference,
    /// Encounter / Episode associated with event
    ///
    /// The encounter or episode of care that establishes the context for this event.
    ///
    /// ## Requirements
    /// Links the request to the Encounter context.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// encounter
    pub context: Option<Reference>,
    /// When the charged service was applied
    ///
    /// Date/time(s) or duration when the charged service was applied.
    ///
    /// ## Implementation Notes
    /// The list of types may be constrained as appropriate for the type of charge
    /// item.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// timing
    #[fhir_serde(flatten)]
    pub occurrence: Option<ChargeItemOccurrence>,
    /// Who performed charged service
    ///
    /// Indicates who or what performed or participated in the charged service.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub performer: Option<Vec<ChargeItemPerformer>>,
    /// Organization providing the charged service
    ///
    /// The organization requesting the service.
    ///
    /// ## Implementation Notes
    /// Practitioners and Devices can be associated with multiple organizations. It
    /// has to be made clear, on behalf of which Organization the services have been
    /// rendered.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "performingOrganization")]
    pub performing_organization: Option<Reference>,
    /// Organization requesting the charged service
    ///
    /// The organization performing the service.
    ///
    /// ## Implementation Notes
    /// The rendered Service might not be associated with a Request. This property
    /// indicates which Organization requested the services to be rendered. (In many
    /// cases, this may just be the Department associated with the
    /// Encounter.location).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "requestingOrganization")]
    pub requesting_organization: Option<Reference>,
    /// Organization that has ownership of the (potential, future) revenue
    ///
    /// The financial cost center permits the tracking of charge attribution.
    ///
    /// ## Implementation Notes
    /// The costCenter could either be given as a reference to an Organization(Role)
    /// resource or as the identifier of the cost center determined by
    /// Reference.identifier.value and Reference.identifier.system, depending on use
    /// case requirements.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "costCenter")]
    pub cost_center: Option<Reference>,
    /// Quantity of which the charge item has been serviced
    ///
    /// Quantity of which the charge item has been serviced.
    ///
    /// ## Implementation Notes
    /// In many cases this may just be a value, if the underlying units are implicit
    /// in the definition of the charge item code.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// Anatomical location, if relevant
    ///
    /// The anatomical location where the related service has been applied.
    ///
    /// ## Implementation Notes
    /// Only used if not implicit in code found in Condition.code. If the use case
    /// requires attributes from the BodySite resource (e.g. to identify and track
    /// separately) then use the standard extension
    /// [bodySite](extension-bodysite.html). May be a summary code, or a reference to
    /// a very precise definition of the location, or both.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing anatomical locations. May include laterality.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/body-site
    pub bodysite: Option<Vec<CodeableConcept>>,
    /// Factor overriding the associated rules
    ///
    /// Factor overriding the factor determined by the rules associated with the
    /// code.
    ///
    /// ## Implementation Notes
    /// There is no reason to carry the factor in the instance of a ChargeItem unless
    /// special circumstances require a manual override. The factors are usually
    /// defined by a set of rules in a back catalogue of the billing codes (see
    /// ChargeItem.definition). Derived profiles may require a
    /// ChargeItem.overrideReason to be provided if either factor or price are
    /// manually overridden.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "factorOverride")]
    pub factor_override: Option<Decimal>,
    /// Price overriding the associated rules
    ///
    /// Total price of the charge overriding the list price associated with the code.
    ///
    /// ## Implementation Notes
    /// There is no reason to carry the price in the instance of a ChargeItem unless
    /// circumstances require a manual override. The list prices or are usually
    /// defined in a back catalogue of the billing codes (see ChargeItem.definition).
    /// Derived profiles may require a ChargeItem.overrideReason to be provided if
    /// either factor or price are manually overridden.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "priceOverride")]
    pub price_override: Option<Money>,
    /// Reason for overriding the list price/factor
    ///
    /// If the list price or the rule-based factor associated with the code is
    /// overridden, this attribute can capture a text to indicate the reason for this
    /// action.
    ///
    /// ## Implementation Notes
    /// Derived Profiles may choose to add invariants requiring this field to be
    /// populated if either priceOverride or factorOverride have been filled.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "overrideReason")]
    pub override_reason: Option<String>,
    /// Individual who was entering
    ///
    /// The device, practitioner, etc. who entered the charge item.
    ///
    /// ## Implementation Notes
    /// The enterer is also the person considered responsible for factor/price
    /// overrides if applicable.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub enterer: Option<Reference>,
    /// Date the charge item was entered
    ///
    /// Date the charge item was entered.
    ///
    /// ## Implementation Notes
    /// The actual date when the service associated with the charge has been rendered
    /// is captured in occurrence[x].
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "enteredDate")]
    pub entered_date: Option<DateTime>,
    /// Why was the charged  service rendered?
    ///
    /// Describes why the event occurred in coded or textual form.
    ///
    /// ## Implementation Notes
    /// If the application of the charge item requires a reason to be given, it can
    /// be captured here. Textual reasons can be captured using reasonCode.text.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Example binding for reason.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/icd-10
    pub reason: Option<Vec<CodeableConcept>>,
    /// Which rendered service is being charged?
    ///
    /// Indicated the rendered service that caused this charge.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub service: Option<Vec<Reference>>,
    /// Product charged
    ///
    /// Identifies the device, food, drug or other product being charged either by
    /// type code or reference to an instance.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Example binding for product type.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/device-kind
    #[fhir_serde(flatten)]
    pub product: Option<ChargeItemProduct>,
    /// Account to place this charge
    ///
    /// Account into which this ChargeItems belongs.
    ///
    /// ## Implementation Notes
    /// Systems posting the ChargeItems might not always be able to determine, which
    /// accounts the Items need to be places into. It is up to the postprocessing
    /// Financial System to apply internal rules to decide based on the
    /// Encounter/EpisodeOfCare/Patient/Coverage context and the type of ChargeItem,
    /// which Account is appropriate.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub account: Option<Vec<Reference>>,
    /// Comments made about the ChargeItem
    ///
    /// Comments made about the event by the performer, subject or other
    /// participants.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
    /// Further information supporting this charge
    ///
    /// Further information supporting this charge.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportingInformation")]
    pub supporting_information: Option<Vec<Reference>>,
}

/// Whether or not the billing code is applicable
///
/// Expressions that describe applicability criteria for the billing code.
///
/// ## Implementation Notes
/// The applicability conditions can be used to ascertain whether a billing item
/// is allowed in a specific context. E.g. some billing codes may only be
/// applicable in out-patient settings, only to male/female patients or only to
/// children.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ChargeItemDefinitionApplicability {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Natural language description of the condition
    ///
    /// A brief, natural language description of the condition that effectively
    /// communicates the intended semantics.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Language of the expression
    ///
    /// The media type of the language for the expression, e.g. "text/cql" for
    /// Clinical Query Language expressions or "text/fhirpath" for FHIRPath
    /// expressions.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub language: Option<String>,
    /// Boolean-valued expression
    ///
    /// An expression that returns true or false, indicating whether the condition is
    /// satisfied. When using FHIRPath expressions, the %context environment variable
    /// must be replaced at runtime with the ChargeItem resource to which this
    /// definition is applied.
    ///
    /// ## Implementation Notes
    /// Please note that FHIRPath Expressions can only be evaluated in the scope of
    /// the current ChargeItem resource to which this definition is being applied.
    /// FHIRPath expressions can traverse into other resources linked from the
    /// ChargeItem resource, however, testing rules such as that a billing code may
    /// be billed only once per encounter need a wider scope. In such scenarios, CQL
    /// may be the appropriate choice.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub expression: Option<String>,
}

/// FHIR ChargeItemDefinition type
///
/// The ChargeItemDefinition resource provides the properties that apply to the
/// (billing) codes necessary to calculate costs and prices. The properties may
/// differ largely depending on type and realm, therefore this resource gives
/// only a rough structure and requires profiling for each type of billing code
/// system.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [ChargeItemDefinition](http://hl7.org/fhir/StructureDefinition/ChargeItemDefinition)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ChargeItemDefinition {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Canonical identifier for this charge item definition, represented as a URI (globally unique)
    ///
    /// An absolute URI that is used to identify this charge item definition when it
    /// is referenced in a specification, model, design or an instance; also called
    /// its canonical identifier. This SHOULD be globally unique and SHOULD be a
    /// literal address at which at which an authoritative instance of this charge
    /// item definition is (or will be) published. This URL can be the target of a
    /// canonical reference. It SHALL remain the same when the charge item definition
    /// is stored on different servers.
    ///
    /// ## Requirements
    /// Allows the charge item definition to be referenced by a single globally
    /// unique identifier.
    ///
    /// ## Implementation Notes
    /// Can be a urn:uuid: or a urn:oid: but real http: addresses are preferred.
    /// Multiple instances may share the same URL if they have a distinct version.
    ///
    /// The determination of when to create a new version of a resource (same url,
    /// new version) vs. defining a new artifact is up to the author. Considerations
    /// for making this decision are found in [Technical and Business
    /// Versions](resource.html#versions).
    ///
    /// In some cases, the resource can no longer be found at the stated url, but the
    /// url itself cannot change. Implementations can use the
    /// [meta.source](resource.html#meta) element to indicate where the current
    /// master source of the resource can be found.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Uri,
    /// Additional identifier for the charge item definition
    ///
    /// A formal identifier that is used to identify this charge item definition when
    /// it is represented in other formats, or referenced in a specification, model,
    /// design or an instance.
    ///
    /// ## Requirements
    /// Allows externally provided and/or usable business identifiers to be easily
    /// associated with the module.
    ///
    /// ## Implementation Notes
    /// Typically, this is used for identifiers that can go in an HL7 V3 II (instance
    /// identifier) data type, and can then identify this charge item definition
    /// outside of FHIR, where it is not possible to use the logical URI.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Business version of the charge item definition
    ///
    /// The identifier that is used to identify this version of the charge item
    /// definition when it is referenced in a specification, model, design or
    /// instance. This is an arbitrary value managed by the charge item definition
    /// author and is not expected to be globally unique. For example, it might be a
    /// timestamp (e.g. yyyymmdd) if a managed version is not available. There is
    /// also no expectation that versions can be placed in a lexicographical
    /// sequence. To provide a version consistent with the Decision Support Service
    /// specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more
    /// information on versioning knowledge assets, refer to the Decision Support
    /// Service specification. Note that a version is required for non-experimental
    /// active assets.
    ///
    /// ## Implementation Notes
    /// There may be different charge item definition instances that have the same
    /// identifier but different versions. The version can be appended to the url in
    /// a reference to allow a reference to a particular business version of the
    /// charge item definition with the format [url]|[version].
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub version: Option<String>,
    /// Name for this charge item definition (human friendly)
    ///
    /// A short, descriptive, user-friendly title for the charge item definition.
    ///
    /// ## Implementation Notes
    /// This name does not need to be machine-processing friendly and may contain
    /// punctuation, white-space, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// Underlying externally-defined charge item definition
    ///
    /// The URL pointing to an externally-defined charge item definition that is
    /// adhered to in whole or in part by this definition.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "derivedFromUri")]
    pub derived_from_uri: Option<Vec<Uri>>,
    /// A larger definition of which this particular definition is a component or step
    ///
    /// A larger definition of which this particular definition is a component or
    /// step.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// container
    #[fhir_serde(rename = "partOf")]
    pub part_of: Option<Vec<Canonical>>,
    /// Completed or terminated request(s) whose function is taken by this new request
    ///
    /// As new versions of a protocol or guideline are defined, allows identification
    /// of what versions are replaced by a new instance.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// supersedes, prior, renewed order
    pub replaces: Option<Vec<Canonical>>,
    /// draft | active | retired | unknown
    ///
    /// The current state of the ChargeItemDefinition.
    ///
    /// ## Implementation Notes
    /// Allows filtering of charge item definitions that are appropriate for use
    /// versus not.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This is labeled as "Is Modifier" because applications should not use a retired {{title}} without due consideration
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|4.0.1
    pub status: Code,
    /// For testing purposes, not real usage
    ///
    /// A Boolean value to indicate that this charge item definition is authored for
    /// testing purposes (or education/evaluation/marketing) and is not intended to
    /// be used for genuine usage.
    ///
    /// ## Requirements
    /// Enables experimental content to be developed following the same lifecycle
    /// that would be used for a production-level charge item definition.
    ///
    /// ## Implementation Notes
    /// Allows filtering of charge item definitions that are appropriate for use
    /// versus not.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub experimental: Option<Boolean>,
    /// Date last changed
    ///
    /// The date (and optionally time) when the charge item definition was published.
    /// The date must change when the business version changes and it must change if
    /// the status code changes. In addition, it should change when the substantive
    /// content of the charge item definition changes.
    ///
    /// ## Implementation Notes
    /// Note that this is not the same as the resource last-modified-date, since the
    /// resource may be a secondary representation of the charge item definition.
    /// Additional specific dates may be added as extensions or be found by
    /// consulting Provenances associated with past versions of the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Revision Date
    pub date: Option<DateTime>,
    /// Name of the publisher (organization or individual)
    ///
    /// The name of the organization or individual that published the charge item
    /// definition.
    ///
    /// ## Requirements
    /// Helps establish the "authority/credibility" of the charge item definition.
    /// May also allow for contact.
    ///
    /// ## Implementation Notes
    /// Usually an organization but may be an individual. The publisher (or steward)
    /// of the charge item definition is the organization or individual primarily
    /// responsible for the maintenance and upkeep of the charge item definition.
    /// This is not necessarily the same individual or organization that developed
    /// and initially authored the content. The publisher is the primary point of
    /// contact for questions or issues with the charge item definition. This item
    /// SHOULD be populated unless the information is available from context.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub publisher: Option<String>,
    /// Contact details for the publisher
    ///
    /// Contact details to assist a user in finding and communicating with the
    /// publisher.
    ///
    /// ## Implementation Notes
    /// May be a web site, an email address, a telephone number, etc.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contact: Option<Vec<ContactDetail>>,
    /// Natural language description of the charge item definition
    ///
    /// A free text natural language description of the charge item definition from a
    /// consumer's perspective.
    ///
    /// ## Implementation Notes
    /// This description can be used to capture details such as why the charge item
    /// definition was built, comments about misuse, instructions for clinical use
    /// and interpretation, literature references, examples from the paper world,
    /// etc. It is not a rendering of the charge item definition as conveyed in the
    /// 'text' field of the resource itself. This item SHOULD be populated unless the
    /// information is available from context (e.g. the language of the charge item
    /// definition is presumed to be the predominant language in the place the charge
    /// item definition was created).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<Markdown>,
    /// The context that the content is intended to support
    ///
    /// The content was developed with a focus and intent of supporting the contexts
    /// that are listed. These contexts may be general categories (gender, age, ...)
    /// or may be references to specific programs (insurance plans, studies, ...) and
    /// may be used to assist with indexing and searching for appropriate charge item
    /// definition instances.
    ///
    /// ## Requirements
    /// Assist in searching for appropriate content.
    ///
    /// ## Implementation Notes
    /// When multiple useContexts are specified, there is no expectation that all or
    /// any of the contexts apply.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "useContext")]
    pub use_context: Option<Vec<UsageContext>>,
    /// Intended jurisdiction for charge item definition (if applicable)
    ///
    /// A legal or geographic region in which the charge item definition is intended
    /// to be used.
    ///
    /// ## Implementation Notes
    /// It may be possible for the charge item definition to be used in jurisdictions
    /// other than those for which it was originally designed or intended.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Countries and regions within which this artifact is targeted for use.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/jurisdiction
    pub jurisdiction: Option<Vec<CodeableConcept>>,
    /// Use and/or publishing restrictions
    ///
    /// A copyright statement relating to the charge item definition and/or its
    /// contents. Copyright statements are generally legal restrictions on the use
    /// and publishing of the charge item definition.
    ///
    /// ## Requirements
    /// Consumers must be able to determine any legal restrictions on the use of the
    /// charge item definition and/or its content.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// License, Restrictions
    pub copyright: Option<Markdown>,
    /// When the charge item definition was approved by publisher
    ///
    /// The date on which the resource content was approved by the publisher.
    /// Approval happens once when the content is officially approved for usage.
    ///
    /// ## Implementation Notes
    /// The 'date' element may be more recent than the approval date because of minor
    /// changes or editorial corrections.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "approvalDate")]
    pub approval_date: Option<Date>,
    /// When the charge item definition was last reviewed
    ///
    /// The date on which the resource content was last reviewed. Review happens
    /// periodically after approval but does not change the original approval date.
    ///
    /// ## Requirements
    /// Gives a sense of how "current" the content is. Resources that have not been
    /// reviewed in a long time may have a risk of being less appropriate/relevant.
    ///
    /// ## Implementation Notes
    /// If specified, this date follows the original approval date.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastReviewDate")]
    pub last_review_date: Option<Date>,
    /// When the charge item definition is expected to be used
    ///
    /// The period during which the charge item definition content was or is planned
    /// to be in active use.
    ///
    /// ## Requirements
    /// Allows establishing a transition before a resource comes into effect and also
    /// allows for a sunsetting process when new versions of the charge item
    /// definition are or are expected to be used instead.
    ///
    /// ## Implementation Notes
    /// The effective period for a charge item definition determines when the content
    /// is applicable for usage and is independent of publication and review dates.
    /// For example, a measure intended to be used for the year 2016 might be
    /// published in 2015.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "effectivePeriod")]
    pub effective_period: Option<Period>,
    /// Billing codes or product types this definition applies to
    ///
    /// The defined billing details in this resource pertain to the given billing
    /// code.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Billing Code defined by this ChargeItemDefinition.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/chargeitem-billingcodes
    pub code: Option<CodeableConcept>,
    /// Instances this definition applies to
    ///
    /// The defined billing details in this resource pertain to the given product
    /// instance(s).
    ///
    /// ## Implementation Notes
    /// In case of highly customized, individually produced or fitted
    /// devices/substances, the pricing information may be different for each
    /// instance of the product. This reference links pricing details to specific
    /// product instances.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub instance: Option<Vec<Reference>>,
    /// Whether or not the billing code is applicable
    ///
    /// Expressions that describe applicability criteria for the billing code.
    ///
    /// ## Implementation Notes
    /// The applicability conditions can be used to ascertain whether a billing item
    /// is allowed in a specific context. E.g. some billing codes may only be
    /// applicable in out-patient settings, only to male/female patients or only to
    /// children.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub applicability: Option<Vec<ChargeItemDefinitionApplicability>>,
    /// Group of properties which are applicable under the same conditions
    ///
    /// Group of properties which are applicable under the same conditions. If no
    /// applicability rules are established for the group, then all properties always
    /// apply.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "propertyGroup")]
    pub property_group: Option<Vec<ChargeItemDefinitionPropertyGroup>>,
}

/// Components of total line item price
///
/// The price for a ChargeItem may be calculated as a base price with
/// surcharges/deductions that apply in certain conditions. A
/// ChargeItemDefinition resource that defines the prices, factors and conditions
/// that apply to a billing code is currently under development. The
/// priceComponent element can be used to offer transparency to the recipient of
/// the Invoice of how the prices have been calculated.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ChargeItemDefinitionPropertyGroupPriceComponent {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// base | surcharge | deduction | discount | tax | informational
    ///
    /// This code identifies the type of the component.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Codes indicating the kind of the price component.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/invoice-priceComponentType|4.0.1
    #[fhir_serde(rename = "type")]
    pub r#type: Code,
    /// Code identifying the specific component
    ///
    /// A code that identifies the component. Codes may be used to differentiate
    /// between kinds of taxes, surcharges, discounts etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub code: Option<CodeableConcept>,
    /// Factor used for calculating this component
    ///
    /// The factor that has been applied on the base price for calculating this
    /// component.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub factor: Option<Decimal>,
    /// Monetary amount associated with this component
    ///
    /// The amount calculated for this component.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub amount: Option<Money>,
}

/// Group of properties which are applicable under the same conditions
///
/// Group of properties which are applicable under the same conditions. If no
/// applicability rules are established for the group, then all properties always
/// apply.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ChargeItemDefinitionPropertyGroup {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Conditions under which the priceComponent is applicable
    ///
    /// Expressions that describe applicability criteria for the priceComponent.
    ///
    /// ## Implementation Notes
    /// The applicability conditions can be used to ascertain whether a billing item
    /// is allowed in a specific context. E.g. some billing codes may only be
    /// applicable in out-patient settings, only to male/female patients or only to
    /// children.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub applicability: Option<Vec<ChargeItemDefinitionApplicability>>,
    /// Components of total line item price
    ///
    /// The price for a ChargeItem may be calculated as a base price with
    /// surcharges/deductions that apply in certain conditions. A
    /// ChargeItemDefinition resource that defines the prices, factors and conditions
    /// that apply to a billing code is currently under development. The
    /// priceComponent element can be used to offer transparency to the recipient of
    /// the Invoice of how the prices have been calculated.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "priceComponent")]
    pub price_component: Option<Vec<ChargeItemDefinitionPropertyGroupPriceComponent>>,
}

/// Product or service provided
///
/// A claim detail line. Either a simple (a product or service) or a 'group' of
/// sub-details which are simple items.
///
/// ## Requirements
/// The items to be processed for adjudication.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimItemDetail {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Item instance identifier
    ///
    /// A number to uniquely identify item entries.
    ///
    /// ## Requirements
    /// Necessary to provide a mechanism to link to items from within the claim and
    /// within the adjudication details of the ClaimResponse.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: PositiveInt,
    /// Revenue or cost center code
    ///
    /// The type of revenue or cost center providing the product and/or service.
    ///
    /// ## Requirements
    /// Needed in the processing of institutional claims.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes for the revenue or cost centers supplying the service and/or products.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-revenue-center
    pub revenue: Option<CodeableConcept>,
    /// Benefit classification
    ///
    /// Code to identify the general type of benefits under which products and
    /// services are provided.
    ///
    /// ## Requirements
    /// Needed in the processing of institutional claims as this allows the insurer
    /// to determine whether a facial X-Ray is for dental, orthopedic, or facial
    /// surgery purposes.
    ///
    /// ## Implementation Notes
    /// Examples include Medical Care, Periodontics, Renal Dialysis, Vision Coverage.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Benefit categories such as: oral-basic, major, glasses.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-benefitcategory
    pub category: Option<CodeableConcept>,
    /// Billing, service, product, or drug code
    ///
    /// When the value is a group code then this item collects a set of related claim
    /// details, otherwise this contains the product, service, drug or other billing
    /// code for the item.
    ///
    /// ## Requirements
    /// Necessary to state what was provided or done.
    ///
    /// ## Implementation Notes
    /// If this is an actual service or product line, i.e. not a Group, then use code
    /// to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,
    /// USCLS, ICD10, NCPDP, DIN, RxNorm, ACHI, CCI). If a grouping item then use a
    /// group code to indicate the type of thing being grouped e.g. 'glasses' or
    /// 'compound'.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Allowable service and product codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-uscls
    ///
    /// ## Aliases
    /// Drug Code, Bill Code, Service Code
    #[fhir_serde(rename = "productOrService")]
    pub product_or_service: CodeableConcept,
    /// Service/Product billing modifiers
    ///
    /// Item typification or modifiers codes to convey additional context for the
    /// product or service.
    ///
    /// ## Requirements
    /// To support inclusion of the item for adjudication or to charge an elevated
    /// fee.
    ///
    /// ## Implementation Notes
    /// For example in Oral whether the treatment is cosmetic or associated with TMJ,
    /// or for Medical whether the treatment was outside the clinic or out of office
    /// hours.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-modifiers
    pub modifier: Option<Vec<CodeableConcept>>,
    /// Program the product or service is provided under
    ///
    /// Identifies the program under which this may be recovered.
    ///
    /// ## Requirements
    /// Commonly used in in the identification of publicly provided program focused
    /// on population segments or disease classifications.
    ///
    /// ## Implementation Notes
    /// For example: Neonatal program, child dental program or drug users recovery
    /// program.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Program specific reason codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-program-code
    #[fhir_serde(rename = "programCode")]
    pub program_code: Option<Vec<CodeableConcept>>,
    /// Count of products or services
    ///
    /// The number of repetitions of a service or product.
    ///
    /// ## Requirements
    /// Required when the product or service code does not convey the quantity
    /// provided.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// Fee, charge or cost per item
    ///
    /// If the item is not a group then this is the fee for the product or service,
    /// otherwise this is the total of the fees for the details of the group.
    ///
    /// ## Requirements
    /// The amount charged to the patient by the provider for a single unit.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "unitPrice")]
    pub unit_price: Option<Money>,
    /// Price scaling factor
    ///
    /// A real number that represents a multiplier used in determining the overall
    /// value of services delivered and/or goods received. The concept of a Factor
    /// allows for a discount or surcharge multiplier to be applied to a monetary
    /// amount.
    ///
    /// ## Requirements
    /// When discounts are provided to a patient (example: Senior's discount) then
    /// this must be documented for adjudication.
    ///
    /// ## Implementation Notes
    /// To show a 10% senior's discount, the value entered is: 0.90 (1.00 - 0.10).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub factor: Option<Decimal>,
    /// Total item cost
    ///
    /// The quantity times the unit price for an additional service or product or
    /// charge.
    ///
    /// ## Requirements
    /// Provides the total amount claimed for the group (if a grouper) or the line
    /// item.
    ///
    /// ## Implementation Notes
    /// For example, the formula: quantity * unitPrice * factor = net. Quantity and
    /// factor are assumed to be 1 if not supplied.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub net: Option<Money>,
    /// Unique device identifier
    ///
    /// Unique Device Identifiers associated with this line item.
    ///
    /// ## Requirements
    /// The UDI code allows the insurer to obtain device level information on the
    /// product supplied.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub udi: Option<Vec<Reference>>,
    /// Product or service provided
    ///
    /// A claim detail line. Either a simple (a product or service) or a 'group' of
    /// sub-details which are simple items.
    ///
    /// ## Requirements
    /// The items to be processed for adjudication.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "subDetail")]
    pub sub_detail: Option<Vec<ClaimItemDetailSubDetail>>,
}

/// Product or service provided
///
/// A claim detail line. Either a simple (a product or service) or a 'group' of
/// sub-details which are simple items.
///
/// ## Requirements
/// The items to be processed for adjudication.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimItemDetailSubDetail {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Item instance identifier
    ///
    /// A number to uniquely identify item entries.
    ///
    /// ## Requirements
    /// Necessary to provide a mechanism to link to items from within the claim and
    /// within the adjudication details of the ClaimResponse.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: PositiveInt,
    /// Revenue or cost center code
    ///
    /// The type of revenue or cost center providing the product and/or service.
    ///
    /// ## Requirements
    /// Needed in the processing of institutional claims.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes for the revenue or cost centers supplying the service and/or products.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-revenue-center
    pub revenue: Option<CodeableConcept>,
    /// Benefit classification
    ///
    /// Code to identify the general type of benefits under which products and
    /// services are provided.
    ///
    /// ## Requirements
    /// Needed in the processing of institutional claims as this allows the insurer
    /// to determine whether a facial X-Ray is for dental, orthopedic, or facial
    /// surgery purposes.
    ///
    /// ## Implementation Notes
    /// Examples include Medical Care, Periodontics, Renal Dialysis, Vision Coverage.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Benefit categories such as: oral-basic, major, glasses.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-benefitcategory
    pub category: Option<CodeableConcept>,
    /// Billing, service, product, or drug code
    ///
    /// When the value is a group code then this item collects a set of related claim
    /// details, otherwise this contains the product, service, drug or other billing
    /// code for the item.
    ///
    /// ## Requirements
    /// Necessary to state what was provided or done.
    ///
    /// ## Implementation Notes
    /// If this is an actual service or product line, i.e. not a Group, then use code
    /// to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,
    /// USCLS, ICD10, NCPDP, DIN, RxNorm, ACHI, CCI). If a grouping item then use a
    /// group code to indicate the type of thing being grouped e.g. 'glasses' or
    /// 'compound'.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Allowable service and product codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-uscls
    #[fhir_serde(rename = "productOrService")]
    pub product_or_service: CodeableConcept,
    /// Service/Product billing modifiers
    ///
    /// Item typification or modifiers codes to convey additional context for the
    /// product or service.
    ///
    /// ## Requirements
    /// To support inclusion of the item for adjudication or to charge an elevated
    /// fee.
    ///
    /// ## Implementation Notes
    /// For example in Oral whether the treatment is cosmetic or associated with TMJ,
    /// or for Medical whether the treatment was outside the clinic or out of office
    /// hours.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-modifiers
    pub modifier: Option<Vec<CodeableConcept>>,
    /// Program the product or service is provided under
    ///
    /// Identifies the program under which this may be recovered.
    ///
    /// ## Requirements
    /// Commonly used in in the identification of publicly provided program focused
    /// on population segments or disease classifications.
    ///
    /// ## Implementation Notes
    /// For example: Neonatal program, child dental program or drug users recovery
    /// program.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Program specific reason codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-program-code
    #[fhir_serde(rename = "programCode")]
    pub program_code: Option<Vec<CodeableConcept>>,
    /// Count of products or services
    ///
    /// The number of repetitions of a service or product.
    ///
    /// ## Requirements
    /// Required when the product or service code does not convey the quantity
    /// provided.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// Fee, charge or cost per item
    ///
    /// If the item is not a group then this is the fee for the product or service,
    /// otherwise this is the total of the fees for the details of the group.
    ///
    /// ## Requirements
    /// The amount charged to the patient by the provider for a single unit.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "unitPrice")]
    pub unit_price: Option<Money>,
    /// Price scaling factor
    ///
    /// A real number that represents a multiplier used in determining the overall
    /// value of services delivered and/or goods received. The concept of a Factor
    /// allows for a discount or surcharge multiplier to be applied to a monetary
    /// amount.
    ///
    /// ## Requirements
    /// When discounts are provided to a patient (example: Senior's discount) then
    /// this must be documented for adjudication.
    ///
    /// ## Implementation Notes
    /// To show a 10% senior's discount, the value entered is: 0.90 (1.00 - 0.10).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub factor: Option<Decimal>,
    /// Total item cost
    ///
    /// The quantity times the unit price for an additional service or product or
    /// charge.
    ///
    /// ## Requirements
    /// Provides the total amount claimed for the group (if a grouper) or the line
    /// item.
    ///
    /// ## Implementation Notes
    /// For example, the formula: quantity * unitPrice * factor = net. Quantity and
    /// factor are assumed to be 1 if not supplied.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub net: Option<Money>,
    /// Unique device identifier
    ///
    /// Unique Device Identifiers associated with this line item.
    ///
    /// ## Requirements
    /// The UDI code allows the insurer to obtain device level information on the
    /// product supplied.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub udi: Option<Vec<Reference>>,
}

/// Members of the care team
///
/// The members of the team who provided the products and services.
///
/// ## Requirements
/// Common to identify the responsible and supporting practitioners.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimCareTeam {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Order of care team
    ///
    /// A number to uniquely identify care team entries.
    ///
    /// ## Requirements
    /// Necessary to maintain the order of the care team and provide a mechanism to
    /// link individuals to claim details.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: PositiveInt,
    /// Practitioner or organization
    ///
    /// Member of the team who provided the product or service.
    ///
    /// ## Requirements
    /// Often a regulatory requirement to specify the responsible provider.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub provider: Reference,
    /// Indicator of the lead practitioner
    ///
    /// The party who is billing and/or responsible for the claimed products or
    /// services.
    ///
    /// ## Requirements
    /// When multiple parties are present it is required to distinguish the lead or
    /// responsible individual.
    ///
    /// ## Implementation Notes
    /// Responsible might not be required when there is only a single provider
    /// listed.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub responsible: Option<Boolean>,
    /// Function within the team
    ///
    /// The lead, assisting or supervising practitioner and their discipline if a
    /// multidisciplinary team.
    ///
    /// ## Requirements
    /// When multiple parties are present it is required to distinguish the roles
    /// performed by each member.
    ///
    /// ## Implementation Notes
    /// Role might not be required when there is only a single provider listed.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The role codes for the care team members.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-careteamrole
    pub role: Option<CodeableConcept>,
    /// Practitioner credential or specialization
    ///
    /// The qualification of the practitioner which is applicable for this service.
    ///
    /// ## Requirements
    /// Need to specify which qualification a provider is delivering the product or
    /// service under.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Provider professional qualifications.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/provider-qualification
    pub qualification: Option<CodeableConcept>,
}

/// Choice of types for the location\[x\] field in ClaimAccident
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "location")]
pub enum ClaimAccidentLocation {
    /// Variant accepting the Address type.
    #[fhir_serde(rename = "locationAddress")]
    Address(Address),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "locationReference")]
    Reference(Reference),
}

/// Details of the event
///
/// Details of an accident which resulted in injuries which required the products
/// and services listed in the claim.
///
/// ## Requirements
/// When healthcare products and services are accident related, benefits may be
/// payable under accident provisions of policies, such as automotive, etc before
/// they are payable under normal health insurance.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "location")]
pub struct ClaimAccident {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// When the incident occurred
    ///
    /// Date of an accident event related to the products and services contained in
    /// the claim.
    ///
    /// ## Requirements
    /// Required for audit purposes and adjudication.
    ///
    /// ## Implementation Notes
    /// The date of the accident has to precede the dates of the products and
    /// services but within a reasonable timeframe.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub date: Date,
    /// The nature of the accident
    ///
    /// The type or context of the accident event for the purposes of selection of
    /// potential insurance coverages and determination of coordination between
    /// insurers.
    ///
    /// ## Requirements
    /// Coverage may be dependant on the type of accident.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Type of accident: work place, auto, etc.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/v3-ActIncidentCode
    #[fhir_serde(rename = "type")]
    pub r#type: Option<CodeableConcept>,
    /// Where the event occurred
    ///
    /// The physical location of the accident event.
    ///
    /// ## Requirements
    /// Required for audit purposes and determination of applicable insurance
    /// liability.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub location: Option<ClaimAccidentLocation>,
}

/// FHIR Claim type
///
/// A provider issued list of professional services and products which have been
/// provided, or are to be provided, to a patient which is sent to an insurer for
/// reimbursement.
///
/// ## Purpose
/// The Claim resource is used by providers to exchange services and products rendered to patients or planned to be rendered with insurers for reimbuserment. It is also used by insurers to exchange claims information with statutory reporting and data analytics firms.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [Claim](http://hl7.org/fhir/StructureDefinition/Claim)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Claim {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Business Identifier for claim
    ///
    /// A unique identifier assigned to this claim.
    ///
    /// ## Requirements
    /// Allows claims to be distinguished and referenced.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Claim Number
    pub identifier: Option<Vec<Identifier>>,
    /// active | cancelled | draft | entered-in-error
    ///
    /// The status of the resource instance.
    ///
    /// ## Requirements
    /// Need to track the status of the resource as 'draft' resources may undergo
    /// further edits while 'active' resources are immutable and may only have their
    /// status changed to 'cancelled'.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because the status contains codes that
    /// mark the resource as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: A code specifying the state of the resource instance.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/fm-status|4.0.1
    pub status: Code,
    /// Category or discipline
    ///
    /// The category of claim, e.g. oral, pharmacy, vision, institutional,
    /// professional.
    ///
    /// ## Requirements
    /// Claim type determine the general sets of business rules applied for
    /// information requirements and adjudication.
    ///
    /// ## Implementation Notes
    /// The majority of jurisdictions use: oral, pharmacy, vision, professional and
    /// institutional, or variants on those terms, as the general styles of claims.
    /// The valueset is extensible to accommodate other jurisdictional requirements.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: The type or discipline-style of the claim.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-type
    #[fhir_serde(rename = "type")]
    pub r#type: CodeableConcept,
    /// More granular claim type
    ///
    /// A finer grained suite of claim type codes which may convey additional
    /// information such as Inpatient vs Outpatient and/or a specialty service.
    ///
    /// ## Requirements
    /// Some jurisdictions need a finer grained claim type for routing and
    /// adjudication.
    ///
    /// ## Implementation Notes
    /// This may contain the local bill type codes, for example the US UB-04 bill
    /// type code or the CMS bill type.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A more granular claim typecode.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-subtype
    #[fhir_serde(rename = "subType")]
    pub sub_type: Option<CodeableConcept>,
    /// claim | preauthorization | predetermination
    ///
    /// A code to indicate whether the nature of the request is: to request
    /// adjudication of products and services previously rendered; or requesting
    /// authorization and adjudication for provision in the future; or requesting the
    /// non-binding adjudication of the listed products and services which could be
    /// provided in the future.
    ///
    /// ## Requirements
    /// This element is required to understand the nature of the request for
    /// adjudication.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The purpose of the Claim: predetermination, preauthorization, claim.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-use|4.0.1
    #[fhir_serde(rename = "use")]
    pub r#use: Code,
    /// The recipient of the products and services
    ///
    /// The party to whom the professional services and/or products have been
    /// supplied or are being considered and for whom actual or forecast
    /// reimbursement is sought.
    ///
    /// ## Requirements
    /// The patient must be supplied to the insurer so that confirmation of coverage
    /// and service history may be considered as part of the authorization and/or
    /// adjudiction.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub patient: Reference,
    /// Relevant time frame for the claim
    ///
    /// The period for which charges are being submitted.
    ///
    /// ## Requirements
    /// A number jurisdictions required the submission of the billing period when
    /// submitting claims for example for hospital stays or long-term care.
    ///
    /// ## Implementation Notes
    /// Typically this would be today or in the past for a claim, and today or in the
    /// future for preauthorizations and predeterminations. Typically line item dates
    /// of service should fall within the billing period if one is specified.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "billablePeriod")]
    pub billable_period: Option<Period>,
    /// Resource creation date
    ///
    /// The date this resource was created.
    ///
    /// ## Requirements
    /// Need to record a timestamp for use by both the recipient and the issuer.
    ///
    /// ## Implementation Notes
    /// This field is independent of the date of creation of the resource as it may
    /// reflect the creation date of a source document prior to digitization.
    /// Typically for claims all services must be completed as of this date.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub created: DateTime,
    /// Author of the claim
    ///
    /// Individual who created the claim, predetermination or preauthorization.
    ///
    /// ## Requirements
    /// Some jurisdictions require the contact information for personnel completing
    /// claims.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub enterer: Option<Reference>,
    /// Target
    ///
    /// The Insurer who is target of the request.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub insurer: Option<Reference>,
    /// Party responsible for the claim
    ///
    /// The provider which is responsible for the claim, predetermination or
    /// preauthorization.
    ///
    /// ## Implementation Notes
    /// Typically this field would be 1..1 where this party is responsible for the
    /// claim but not necessarily professionally responsible for the provision of the
    /// individual products and services listed below.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub provider: Reference,
    /// Desired processing ugency
    ///
    /// The provider-required urgency of processing the request. Typical values
    /// include: stat, routine deferred.
    ///
    /// ## Requirements
    /// The provider may need to indicate their processing requirements so that the
    /// processor can indicate if they are unable to comply.
    ///
    /// ## Implementation Notes
    /// If a claim processor is unable to complete the processing as per the priority
    /// then they should generate and error and not process the request.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The timeliness with which processing is required: stat, normal, deferred.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/process-priority
    pub priority: CodeableConcept,
    /// For whom to reserve funds
    ///
    /// A code to indicate whether and for whom funds are to be reserved for future
    /// claims.
    ///
    /// ## Requirements
    /// In the case of a Pre-Determination/Pre-Authorization the provider may request
    /// that funds in the amount of the expected Benefit be reserved ('Patient' or
    /// 'Provider') to pay for the Benefits determined on the subsequent claim(s).
    /// 'None' explicitly indicates no funds reserving is requested.
    ///
    /// ## Implementation Notes
    /// This field is only used for preauthorizations.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: For whom funds are to be reserved: (Patient, Provider, None).
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/fundsreserve
    ///
    /// ## Aliases
    /// Fund pre-allocation
    #[fhir_serde(rename = "fundsReserve")]
    pub funds_reserve: Option<CodeableConcept>,
    /// Prior or corollary claims
    ///
    /// Other claims which are related to this claim such as prior submissions or
    /// claims for related services or for the same event.
    ///
    /// ## Requirements
    /// For workplace or other accidents it is common to relate separate claims
    /// arising from the same event.
    ///
    /// ## Implementation Notes
    /// For example,  for the original treatment and follow-up exams.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub related: Option<Vec<ClaimRelated>>,
    /// Prescription authorizing services and products
    ///
    /// Prescription to support the dispensing of pharmacy, device or vision
    /// products.
    ///
    /// ## Requirements
    /// Required to authorize the dispensing of controlled substances and devices.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub prescription: Option<Reference>,
    /// Original prescription if superseded by fulfiller
    ///
    /// Original prescription which has been superseded by this prescription to
    /// support the dispensing of pharmacy services, medications or products.
    ///
    /// ## Requirements
    /// Often required when a fulfiller varies what is fulfilled from that authorized
    /// on the original prescription.
    ///
    /// ## Implementation Notes
    /// For example, a physician may prescribe a medication which the pharmacy
    /// determines is contraindicated, or for which the patient has an intolerance,
    /// and therefore issues a new prescription for an alternate medication which has
    /// the same therapeutic intent. The prescription from the pharmacy becomes the
    /// 'prescription' and that from the physician becomes the 'original
    /// prescription'.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "originalPrescription")]
    pub original_prescription: Option<Reference>,
    /// Recipient of benefits payable
    ///
    /// The party to be reimbursed for cost of the products and services according to
    /// the terms of the policy.
    ///
    /// ## Requirements
    /// The provider needs to specify who they wish to be reimbursed and the claims
    /// processor needs express who they will reimburse.
    ///
    /// ## Implementation Notes
    /// Often providers agree to receive the benefits payable to reduce the near-term
    /// costs to the patient. The insurer may decline to pay the provider and choose
    /// to pay the subscriber instead.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub payee: Option<ClaimPayee>,
    /// Treatment referral
    ///
    /// A reference to a referral resource.
    ///
    /// ## Requirements
    /// Some insurers require proof of referral to pay for services or to pay
    /// specialist rates for services.
    ///
    /// ## Implementation Notes
    /// The referral resource which lists the date, practitioner, reason and other
    /// supporting information.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub referral: Option<Reference>,
    /// Servicing facility
    ///
    /// Facility where the services were provided.
    ///
    /// ## Requirements
    /// Insurance adjudication can be dependant on where services were delivered.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub facility: Option<Reference>,
    /// Members of the care team
    ///
    /// The members of the team who provided the products and services.
    ///
    /// ## Requirements
    /// Common to identify the responsible and supporting practitioners.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "careTeam")]
    pub care_team: Option<Vec<ClaimCareTeam>>,
    /// Supporting information
    ///
    /// Additional information codes regarding exceptions, special considerations,
    /// the condition, situation, prior or concurrent issues.
    ///
    /// ## Requirements
    /// Typically these information codes are required to support the services
    /// rendered or the adjudication of the services rendered.
    ///
    /// ## Implementation Notes
    /// Often there are multiple jurisdiction specific valuesets which are required.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Attachments
    /// Exception Codes
    /// Occurrence Codes
    /// Value codes
    #[fhir_serde(rename = "supportingInfo")]
    pub supporting_info: Option<Vec<ClaimSupportingInfo>>,
    /// Pertinent diagnosis information
    ///
    /// Information about diagnoses relevant to the claim items.
    ///
    /// ## Requirements
    /// Required for the adjudication by provided context for the services and
    /// product listed.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub diagnosis: Option<Vec<ClaimDiagnosis>>,
    /// Clinical procedures performed
    ///
    /// Procedures performed on the patient relevant to the billing items with the
    /// claim.
    ///
    /// ## Requirements
    /// The specific clinical invention are sometimes required to be provided to
    /// justify billing a greater than customary amount for a service.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub procedure: Option<Vec<ClaimProcedure>>,
    /// Patient insurance information
    ///
    /// Financial instruments for reimbursement for the health care products and
    /// services specified on the claim.
    ///
    /// ## Requirements
    /// At least one insurer is required for a claim to be a claim.
    ///
    /// ## Implementation Notes
    /// All insurance coverages for the patient which may be applicable for
    /// reimbursement, of the products and services listed in the claim, are
    /// typically provided in the claim to allow insurers to confirm the ordering of
    /// the insurance coverages relative to local 'coordination of benefit' rules.
    /// One coverage (and only one) with 'focal=true' is to be used in the
    /// adjudication of this claim. Coverages appearing before the focal Coverage in
    /// the list, and where 'Coverage.subrogation=false', should provide a reference
    /// to the ClaimResponse containing the adjudication results of the prior claim.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub insurance: Option<Vec<ClaimInsurance>>,
    /// Details of the event
    ///
    /// Details of an accident which resulted in injuries which required the products
    /// and services listed in the claim.
    ///
    /// ## Requirements
    /// When healthcare products and services are accident related, benefits may be
    /// payable under accident provisions of policies, such as automotive, etc before
    /// they are payable under normal health insurance.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub accident: Option<ClaimAccident>,
    /// Product or service provided
    ///
    /// A claim line. Either a simple product or service or a 'group' of details
    /// which can each be a simple items or groups of sub-details.
    ///
    /// ## Requirements
    /// The items to be processed for adjudication.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub item: Option<Vec<ClaimItem>>,
    /// Total claim cost
    ///
    /// The total value of the all the items in the claim.
    ///
    /// ## Requirements
    /// Used for  control total purposes.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub total: Option<Money>,
}

/// Prior or corollary claims
///
/// Other claims which are related to this claim such as prior submissions or
/// claims for related services or for the same event.
///
/// ## Requirements
/// For workplace or other accidents it is common to relate separate claims
/// arising from the same event.
///
/// ## Implementation Notes
/// For example,  for the original treatment and follow-up exams.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimRelated {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Reference to the related claim
    ///
    /// Reference to a related claim.
    ///
    /// ## Requirements
    /// For workplace or other accidents it is common to relate separate claims
    /// arising from the same event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub claim: Option<Reference>,
    /// How the reference claim is related
    ///
    /// A code to convey how the claims are related.
    ///
    /// ## Requirements
    /// Some insurers need a declaration of the type of relationship.
    ///
    /// ## Implementation Notes
    /// For example, prior claim or umbrella.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Relationship of this claim to a related Claim.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/related-claim-relationship
    pub relationship: Option<CodeableConcept>,
    /// File or case reference
    ///
    /// An alternate organizational reference to the case or file to which this
    /// particular claim pertains.
    ///
    /// ## Requirements
    /// In cases where an event-triggered claim is being submitted to an insurer
    /// which requires a reference number to be specified on all exchanges.
    ///
    /// ## Implementation Notes
    /// For example, Property/Casualty insurer claim # or Workers Compensation case #
    /// .
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub reference: Option<Identifier>,
}

/// Choice of types for the timing\[x\] field in ClaimSupportingInfo
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "timing")]
pub enum ClaimSupportingInfoTiming {
    /// Variant accepting the Date type.
    #[fhir_serde(rename = "timingDate")]
    Date(Date),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "timingPeriod")]
    Period(Period),
}

/// Choice of types for the value\[x\] field in ClaimSupportingInfo
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "value")]
pub enum ClaimSupportingInfoValue {
    /// Variant accepting the Boolean type.
    #[fhir_serde(rename = "valueBoolean")]
    Boolean(Boolean),
    /// Variant accepting the String type.
    #[fhir_serde(rename = "valueString")]
    String(String),
    /// Variant accepting the Quantity type.
    #[fhir_serde(rename = "valueQuantity")]
    Quantity(Quantity),
    /// Variant accepting the Attachment type.
    #[fhir_serde(rename = "valueAttachment")]
    Attachment(Attachment),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "valueReference")]
    Reference(Reference),
}

/// Supporting information
///
/// Additional information codes regarding exceptions, special considerations,
/// the condition, situation, prior or concurrent issues.
///
/// ## Requirements
/// Typically these information codes are required to support the services
/// rendered or the adjudication of the services rendered.
///
/// ## Implementation Notes
/// Often there are multiple jurisdiction specific valuesets which are required.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Aliases
/// Attachments
/// Exception Codes
/// Occurrence Codes
/// Value codes
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "timing,value")]
pub struct ClaimSupportingInfo {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Information instance identifier
    ///
    /// A number to uniquely identify supporting information entries.
    ///
    /// ## Requirements
    /// Necessary to maintain the order of the supporting information items and
    /// provide a mechanism to link to claim details.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: PositiveInt,
    /// Classification of the supplied information
    ///
    /// The general class of the information supplied: information; exception;
    /// accident, employment; onset, etc.
    ///
    /// ## Requirements
    /// Required to group or associate information items with common characteristics.
    /// For example: admission information or prior treatments.
    ///
    /// ## Implementation Notes
    /// This may contain a category for the local bill type codes.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The valuset used for additional information category codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-informationcategory
    pub category: CodeableConcept,
    /// Type of information
    ///
    /// System and code pertaining to the specific information regarding special
    /// conditions relating to the setting, treatment or patient for which care is
    /// sought.
    ///
    /// ## Requirements
    /// Required to identify the kind of additional information.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The valuset used for additional information codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-exception
    pub code: Option<CodeableConcept>,
    /// When it occurred
    ///
    /// The date when or period to which this information refers.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub timing: Option<ClaimSupportingInfoTiming>,
    /// Data to be provided
    ///
    /// Additional data or information such as resources, documents, images etc.
    /// including references to the data or the actual inclusion of the data.
    ///
    /// ## Requirements
    /// To convey the data content to be provided when the information is more than a
    /// simple code or period.
    ///
    /// ## Implementation Notes
    /// Could be used to provide references to other resources, document. For example
    /// could contain a PDF in an Attachment of the Police Report for an Accident.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub value: Option<ClaimSupportingInfoValue>,
    /// Explanation for the information
    ///
    /// Provides the reason in the situation where a reason code is required in
    /// addition to the content.
    ///
    /// ## Requirements
    /// Needed when the supporting information has both a date and amount/value and
    /// requires explanation.
    ///
    /// ## Implementation Notes
    /// For example: the reason for the additional stay, or why a tooth is  missing.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Reason codes for the missing teeth.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/missing-tooth-reason
    pub reason: Option<CodeableConcept>,
}

/// Choice of types for the procedure\[x\] field in ClaimProcedure
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "procedure")]
pub enum ClaimProcedureProcedure {
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "procedureCodeableConcept")]
    CodeableConcept(CodeableConcept),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "procedureReference")]
    Reference(Reference),
}

/// Clinical procedures performed
///
/// Procedures performed on the patient relevant to the billing items with the
/// claim.
///
/// ## Requirements
/// The specific clinical invention are sometimes required to be provided to
/// justify billing a greater than customary amount for a service.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "procedure")]
pub struct ClaimProcedure {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Procedure instance identifier
    ///
    /// A number to uniquely identify procedure entries.
    ///
    /// ## Requirements
    /// Necessary to provide a mechanism to link to claim details.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: PositiveInt,
    /// Category of Procedure
    ///
    /// When the condition was observed or the relative ranking.
    ///
    /// ## Requirements
    /// Often required to capture a particular diagnosis, for example: primary or
    /// discharge.
    ///
    /// ## Implementation Notes
    /// For example: primary, secondary.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Example procedure type codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-procedure-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Vec<CodeableConcept>>,
    /// When the procedure was performed
    ///
    /// Date and optionally time the procedure was performed.
    ///
    /// ## Requirements
    /// Required for auditing purposes.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub date: Option<DateTime>,
    /// Specific clinical procedure
    ///
    /// The code or reference to a Procedure resource which identifies the clinical
    /// intervention performed.
    ///
    /// ## Requirements
    /// This identifies the actual clinical procedure.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Example ICD10 Procedure codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/icd-10-procedures
    #[fhir_serde(flatten)]
    pub procedure: Option<ClaimProcedureProcedure>,
    /// Unique device identifier
    ///
    /// Unique Device Identifiers associated with this line item.
    ///
    /// ## Requirements
    /// The UDI code allows the insurer to obtain device level information on the
    /// product supplied.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub udi: Option<Vec<Reference>>,
}

/// Choice of types for the serviced\[x\] field in ClaimItem
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "serviced")]
pub enum ClaimItemServiced {
    /// Variant accepting the Date type.
    #[fhir_serde(rename = "servicedDate")]
    Date(Date),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "servicedPeriod")]
    Period(Period),
}

/// Choice of types for the location\[x\] field in ClaimItem
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "location")]
pub enum ClaimItemLocation {
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "locationCodeableConcept")]
    CodeableConcept(CodeableConcept),
    /// Variant accepting the Address type.
    #[fhir_serde(rename = "locationAddress")]
    Address(Address),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "locationReference")]
    Reference(Reference),
}

/// Product or service provided
///
/// A claim line. Either a simple product or service or a 'group' of details
/// which can each be a simple items or groups of sub-details.
///
/// ## Requirements
/// The items to be processed for adjudication.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "serviced,location")]
pub struct ClaimItem {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Item instance identifier
    ///
    /// A number to uniquely identify item entries.
    ///
    /// ## Requirements
    /// Necessary to provide a mechanism to link to items from within the claim and
    /// within the adjudication details of the ClaimResponse.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: PositiveInt,
    /// Applicable careTeam members
    ///
    /// CareTeam members related to this service or product.
    ///
    /// ## Requirements
    /// Need to identify the individuals and their roles in the provision of the
    /// product or service.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "careTeamSequence")]
    pub care_team_sequence: Option<Vec<PositiveInt>>,
    /// Applicable diagnoses
    ///
    /// Diagnosis applicable for this service or product.
    ///
    /// ## Requirements
    /// Need to related the product or service to the associated diagnoses.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "diagnosisSequence")]
    pub diagnosis_sequence: Option<Vec<PositiveInt>>,
    /// Applicable procedures
    ///
    /// Procedures applicable for this service or product.
    ///
    /// ## Requirements
    /// Need to provide any listed specific procedures to support the product or
    /// service being claimed.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "procedureSequence")]
    pub procedure_sequence: Option<Vec<PositiveInt>>,
    /// Applicable exception and supporting information
    ///
    /// Exceptions, special conditions and supporting information applicable for this
    /// service or product.
    ///
    /// ## Requirements
    /// Need to reference the supporting information items that relate directly to
    /// this product or service.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "informationSequence")]
    pub information_sequence: Option<Vec<PositiveInt>>,
    /// Revenue or cost center code
    ///
    /// The type of revenue or cost center providing the product and/or service.
    ///
    /// ## Requirements
    /// Needed in the processing of institutional claims.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes for the revenue or cost centers supplying the service and/or products.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-revenue-center
    pub revenue: Option<CodeableConcept>,
    /// Benefit classification
    ///
    /// Code to identify the general type of benefits under which products and
    /// services are provided.
    ///
    /// ## Requirements
    /// Needed in the processing of institutional claims as this allows the insurer
    /// to determine whether a facial X-Ray is for dental, orthopedic, or facial
    /// surgery purposes.
    ///
    /// ## Implementation Notes
    /// Examples include Medical Care, Periodontics, Renal Dialysis, Vision Coverage.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Benefit categories such as: oral-basic, major, glasses.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-benefitcategory
    pub category: Option<CodeableConcept>,
    /// Billing, service, product, or drug code
    ///
    /// When the value is a group code then this item collects a set of related claim
    /// details, otherwise this contains the product, service, drug or other billing
    /// code for the item.
    ///
    /// ## Requirements
    /// Necessary to state what was provided or done.
    ///
    /// ## Implementation Notes
    /// If this is an actual service or product line, i.e. not a Group, then use code
    /// to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,
    /// USCLS, ICD10, NCPDP, DIN, RxNorm, ACHI, CCI). If a grouping item then use a
    /// group code to indicate the type of thing being grouped e.g. 'glasses' or
    /// 'compound'.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Allowable service and product codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-uscls
    ///
    /// ## Aliases
    /// Drug Code, Bill Code, Service Code
    #[fhir_serde(rename = "productOrService")]
    pub product_or_service: CodeableConcept,
    /// Product or service billing modifiers
    ///
    /// Item typification or modifiers codes to convey additional context for the
    /// product or service.
    ///
    /// ## Requirements
    /// To support inclusion of the item for adjudication or to charge an elevated
    /// fee.
    ///
    /// ## Implementation Notes
    /// For example in Oral whether the treatment is cosmetic or associated with TMJ,
    /// or for Medical whether the treatment was outside the clinic or outside of
    /// office hours.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-modifiers
    pub modifier: Option<Vec<CodeableConcept>>,
    /// Program the product or service is provided under
    ///
    /// Identifies the program under which this may be recovered.
    ///
    /// ## Requirements
    /// Commonly used in in the identification of publicly provided program focused
    /// on population segments or disease classifications.
    ///
    /// ## Implementation Notes
    /// For example: Neonatal program, child dental program or drug users recovery
    /// program.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Program specific reason codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-program-code
    #[fhir_serde(rename = "programCode")]
    pub program_code: Option<Vec<CodeableConcept>>,
    /// Date or dates of service or product delivery
    ///
    /// The date or dates when the service or product was supplied, performed or
    /// completed.
    ///
    /// ## Requirements
    /// Needed to determine whether the service or product was provided during the
    /// term of the insurance coverage.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub serviced: Option<ClaimItemServiced>,
    /// Place of service or where product was supplied
    ///
    /// Where the product or service was provided.
    ///
    /// ## Requirements
    /// The location can alter whether the item was acceptable for insurance purposes
    /// or impact the determination of the benefit amount.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Place of service: pharmacy, school, prison, etc.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-place
    #[fhir_serde(flatten)]
    pub location: Option<ClaimItemLocation>,
    /// Count of products or services
    ///
    /// The number of repetitions of a service or product.
    ///
    /// ## Requirements
    /// Required when the product or service code does not convey the quantity
    /// provided.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// Fee, charge or cost per item
    ///
    /// If the item is not a group then this is the fee for the product or service,
    /// otherwise this is the total of the fees for the details of the group.
    ///
    /// ## Requirements
    /// The amount charged to the patient by the provider for a single unit.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "unitPrice")]
    pub unit_price: Option<Money>,
    /// Price scaling factor
    ///
    /// A real number that represents a multiplier used in determining the overall
    /// value of services delivered and/or goods received. The concept of a Factor
    /// allows for a discount or surcharge multiplier to be applied to a monetary
    /// amount.
    ///
    /// ## Requirements
    /// When discounts are provided to a patient (example: Senior's discount) then
    /// this must be documented for adjudication.
    ///
    /// ## Implementation Notes
    /// To show a 10% senior's discount, the value entered is: 0.90 (1.00 - 0.10).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub factor: Option<Decimal>,
    /// Total item cost
    ///
    /// The quantity times the unit price for an additional service or product or
    /// charge.
    ///
    /// ## Requirements
    /// Provides the total amount claimed for the group (if a grouper) or the line
    /// item.
    ///
    /// ## Implementation Notes
    /// For example, the formula: quantity * unitPrice * factor = net. Quantity and
    /// factor are assumed to be 1 if not supplied.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub net: Option<Money>,
    /// Unique device identifier
    ///
    /// Unique Device Identifiers associated with this line item.
    ///
    /// ## Requirements
    /// The UDI code allows the insurer to obtain device level information on the
    /// product supplied.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub udi: Option<Vec<Reference>>,
    /// Anatomical location
    ///
    /// Physical service site on the patient (limb, tooth, etc.).
    ///
    /// ## Requirements
    /// Allows insurer to validate specific procedures.
    ///
    /// ## Implementation Notes
    /// For example: Providing a tooth code, allows an insurer to identify a provider
    /// performing a filling on a tooth that was previously removed.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The code for the teeth, quadrant, sextant and arch.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/tooth
    #[fhir_serde(rename = "bodySite")]
    pub body_site: Option<CodeableConcept>,
    /// Anatomical sub-location
    ///
    /// A region or surface of the bodySite, e.g. limb region or tooth surface(s).
    ///
    /// ## Requirements
    /// Allows insurer to validate specific procedures.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The code for the tooth surface and surface combinations.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/surface
    #[fhir_serde(rename = "subSite")]
    pub sub_site: Option<Vec<CodeableConcept>>,
    /// Encounters related to this billed item
    ///
    /// The Encounters during which this Claim was created or to which the creation
    /// of this record is tightly associated.
    ///
    /// ## Requirements
    /// Used in some jurisdictions to link clinical events to claim items.
    ///
    /// ## Implementation Notes
    /// This will typically be the encounter the event occurred within, but some
    /// activities may be initiated prior to or after the official completion of an
    /// encounter but still be tied to the context of the encounter.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Vec<Reference>>,
    /// Product or service provided
    ///
    /// A claim detail line. Either a simple (a product or service) or a 'group' of
    /// sub-details which are simple items.
    ///
    /// ## Requirements
    /// The items to be processed for adjudication.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub detail: Option<Vec<ClaimItemDetail>>,
}

/// Patient insurance information
///
/// Financial instruments for reimbursement for the health care products and
/// services specified on the claim.
///
/// ## Requirements
/// At least one insurer is required for a claim to be a claim.
///
/// ## Implementation Notes
/// All insurance coverages for the patient which may be applicable for
/// reimbursement, of the products and services listed in the claim, are
/// typically provided in the claim to allow insurers to confirm the ordering of
/// the insurance coverages relative to local 'coordination of benefit' rules.
/// One coverage (and only one) with 'focal=true' is to be used in the
/// adjudication of this claim. Coverages appearing before the focal Coverage in
/// the list, and where 'Coverage.subrogation=false', should provide a reference
/// to the ClaimResponse containing the adjudication results of the prior claim.
///
/// ## Cardinality: Required, Multiple (1..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimInsurance {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Insurance instance identifier
    ///
    /// A number to uniquely identify insurance entries and provide a sequence of
    /// coverages to convey coordination of benefit order.
    ///
    /// ## Requirements
    /// To maintain order of the coverages.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: PositiveInt,
    /// Coverage to be used for adjudication
    ///
    /// A flag to indicate that this Coverage is to be used for adjudication of this
    /// claim when set to true.
    ///
    /// ## Requirements
    /// To identify which coverage in the list is being used to adjudicate this
    /// claim.
    ///
    /// ## Implementation Notes
    /// A patient may (will) have multiple insurance policies which provide
    /// reimbursement for healthcare services and products. For example a person may
    /// also be covered by their spouse's policy and both appear in the list (and may
    /// be from the same insurer). This flag will be set to true for only one of the
    /// listed policies and that policy will be used for adjudicating this claim.
    /// Other claims would be created to request adjudication against the other
    /// listed policies.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub focal: Boolean,
    /// Pre-assigned Claim number
    ///
    /// The business identifier to be used when the claim is sent for adjudication
    /// against this insurance policy.
    ///
    /// ## Requirements
    /// This will be the claim number should it be necessary to create this claim in
    /// the future. This is provided so that payors may forward claims to other
    /// payors in the Coordination of Benefit for adjudication rather than the
    /// provider being required to initiate each adjudication.
    ///
    /// ## Implementation Notes
    /// Only required in jurisdictions where insurers, rather than the provider, are
    /// required to send claims to insurers that appear after them in the list. This
    /// element is not required when 'subrogation=true'.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Identifier>,
    /// Insurance information
    ///
    /// Reference to the insurance card level information contained in the Coverage
    /// resource. The coverage issuing insurer will use these details to locate the
    /// patient's actual coverage within the insurer's information system.
    ///
    /// ## Requirements
    /// Required to allow the adjudicator to locate the correct policy and history
    /// within their information system.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub coverage: Reference,
    /// Additional provider contract number
    ///
    /// A business agreement number established between the provider and the insurer
    /// for special business processing purposes.
    ///
    /// ## Requirements
    /// Providers may have multiple business arrangements with a given insurer and
    /// must supply the specific contract number for adjudication.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "businessArrangement")]
    pub business_arrangement: Option<String>,
    /// Prior authorization reference number
    ///
    /// Reference numbers previously provided by the insurer to the provider to be
    /// quoted on subsequent claims containing services or products related to the
    /// prior authorization.
    ///
    /// ## Requirements
    /// Providers must quote previously issued authorization reference numbers in
    /// order to obtain adjudication as previously advised on the Preauthorization.
    ///
    /// ## Implementation Notes
    /// This value is an alphanumeric string that may be provided over the phone, via
    /// text, via paper, or within a ClaimResponse resource and is not a FHIR
    /// Identifier.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "preAuthRef")]
    pub pre_auth_ref: Option<Vec<String>>,
    /// Adjudication results
    ///
    /// The result of the adjudication of the line items for the Coverage specified
    /// in this insurance.
    ///
    /// ## Requirements
    /// An insurer need the adjudication results from prior insurers to determine the
    /// outstanding balance remaining by item for the items in the curent claim.
    ///
    /// ## Implementation Notes
    /// Must not be specified when 'focal=true' for this insurance.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "claimResponse")]
    pub claim_response: Option<Reference>,
}

/// Choice of types for the diagnosis\[x\] field in ClaimDiagnosis
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "diagnosis")]
pub enum ClaimDiagnosisDiagnosis {
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "diagnosisCodeableConcept")]
    CodeableConcept(CodeableConcept),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "diagnosisReference")]
    Reference(Reference),
}

/// Pertinent diagnosis information
///
/// Information about diagnoses relevant to the claim items.
///
/// ## Requirements
/// Required for the adjudication by provided context for the services and
/// product listed.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "diagnosis")]
pub struct ClaimDiagnosis {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Diagnosis instance identifier
    ///
    /// A number to uniquely identify diagnosis entries.
    ///
    /// ## Requirements
    /// Necessary to maintain the order of the diagnosis items and provide a
    /// mechanism to link to claim details.
    ///
    /// ## Implementation Notes
    /// Diagnosis are presented in list order to their expected importance: primary,
    /// secondary, etc.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: PositiveInt,
    /// Nature of illness or problem
    ///
    /// The nature of illness or problem in a coded form or as a reference to an
    /// external defined Condition.
    ///
    /// ## Requirements
    /// Provides health context for the evaluation of the products and/or services.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Example ICD10 Diagnostic codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/icd-10
    #[fhir_serde(flatten)]
    pub diagnosis: Option<ClaimDiagnosisDiagnosis>,
    /// Timing or nature of the diagnosis
    ///
    /// When the condition was observed or the relative ranking.
    ///
    /// ## Requirements
    /// Often required to capture a particular diagnosis, for example: primary or
    /// discharge.
    ///
    /// ## Implementation Notes
    /// For example: admitting, primary, secondary, discharge.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The type of the diagnosis: admitting, principal, discharge.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-diagnosistype
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Vec<CodeableConcept>>,
    /// Present on admission
    ///
    /// Indication of whether the diagnosis was present on admission to a facility.
    ///
    /// ## Requirements
    /// Many systems need to understand for adjudication if the diagnosis was present
    /// a time of admission.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Present on admission.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-diagnosis-on-admission
    #[fhir_serde(rename = "onAdmission")]
    pub on_admission: Option<CodeableConcept>,
    /// Package billing code
    ///
    /// A package billing code or bundle code used to group products and services to
    /// a particular health condition (such as heart attack) which is based on a
    /// predetermined grouping code system.
    ///
    /// ## Requirements
    /// Required to relate the current diagnosis to a package billing code that is
    /// then referenced on the individual claim items which are specific to the
    /// health condition covered by the package code.
    ///
    /// ## Implementation Notes
    /// For example DRG (Diagnosis Related Group) or a bundled billing code. A
    /// patient may have a diagnosis of a Myocardial Infarction and a DRG for
    /// HeartAttack would be assigned. The Claim item (and possible subsequent
    /// claims) would refer to the DRG for those line items that were for services
    /// related to the heart attack event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The DRG codes associated with the diagnosis.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/ex-diagnosisrelatedgroup
    #[fhir_serde(rename = "packageCode")]
    pub package_code: Option<CodeableConcept>,
}

/// Recipient of benefits payable
///
/// The party to be reimbursed for cost of the products and services according to
/// the terms of the policy.
///
/// ## Requirements
/// The provider needs to specify who they wish to be reimbursed and the claims
/// processor needs express who they will reimburse.
///
/// ## Implementation Notes
/// Often providers agree to receive the benefits payable to reduce the near-term
/// costs to the patient. The insurer may decline to pay the provider and choose
/// to pay the subscriber instead.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimPayee {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Category of recipient
    ///
    /// Type of Party to be reimbursed: subscriber, provider, other.
    ///
    /// ## Requirements
    /// Need to know who should receive payment with the most common situations being
    /// the Provider (assignment of benefits) or the Subscriber.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A code for the party to be reimbursed.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/payeetype
    #[fhir_serde(rename = "type")]
    pub r#type: CodeableConcept,
    /// Recipient reference
    ///
    /// Reference to the individual or organization to whom any payment will be made.
    ///
    /// ## Requirements
    /// Need to provide demographics if the payee is not 'subscriber' nor 'provider'.
    ///
    /// ## Implementation Notes
    /// Not required if the payee is 'subscriber' or 'provider'.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub party: Option<Reference>,
}

/// Insurer added line details
///
/// The second-tier service adjudications for payor added services.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponseAddItemDetail {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Billing, service, product, or drug code
    ///
    /// When the value is a group code then this item collects a set of related claim
    /// details, otherwise this contains the product, service, drug or other billing
    /// code for the item.
    ///
    /// ## Requirements
    /// Necessary to state what was provided or done.
    ///
    /// ## Implementation Notes
    /// If this is an actual service or product line, i.e. not a Group, then use code
    /// to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,
    /// USCLS, ICD10, NCPDP, DIN, RxNorm, ACHI, CCI). If a grouping item then use a
    /// group code to indicate the type of thing being grouped e.g. 'glasses' or
    /// 'compound'.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Allowable service and product codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-uscls
    #[fhir_serde(rename = "productOrService")]
    pub product_or_service: CodeableConcept,
    /// Service/Product billing modifiers
    ///
    /// Item typification or modifiers codes to convey additional context for the
    /// product or service.
    ///
    /// ## Requirements
    /// To support inclusion of the item for adjudication or to charge an elevated
    /// fee.
    ///
    /// ## Implementation Notes
    /// For example in Oral whether the treatment is cosmetic or associated with TMJ,
    /// or for Medical whether the treatment was outside the clinic or outside of
    /// office hours.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-modifiers
    pub modifier: Option<Vec<CodeableConcept>>,
    /// Count of products or services
    ///
    /// The number of repetitions of a service or product.
    ///
    /// ## Requirements
    /// Required when the product or service code does not convey the quantity
    /// provided.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// Fee, charge or cost per item
    ///
    /// If the item is not a group then this is the fee for the product or service,
    /// otherwise this is the total of the fees for the details of the group.
    ///
    /// ## Requirements
    /// The amount charged to the patient by the provider for a single unit.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "unitPrice")]
    pub unit_price: Option<Money>,
    /// Price scaling factor
    ///
    /// A real number that represents a multiplier used in determining the overall
    /// value of services delivered and/or goods received. The concept of a Factor
    /// allows for a discount or surcharge multiplier to be applied to a monetary
    /// amount.
    ///
    /// ## Requirements
    /// When discounts are provided to a patient (example: Senior's discount) then
    /// this must be documented for adjudication.
    ///
    /// ## Implementation Notes
    /// To show a 10% senior's discount, the value entered is: 0.90 (1.00 - 0.10).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub factor: Option<Decimal>,
    /// Total item cost
    ///
    /// The quantity times the unit price for an additional service or product or
    /// charge.
    ///
    /// ## Requirements
    /// Provides the total amount claimed for the group (if a grouper) or the line
    /// item.
    ///
    /// ## Implementation Notes
    /// For example, the formula: quantity * unitPrice * factor = net. Quantity and
    /// factor are assumed to be 1 if not supplied.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub net: Option<Money>,
    /// Applicable note numbers
    ///
    /// The numbers associated with notes below which apply to the adjudication of
    /// this item.
    ///
    /// ## Requirements
    /// Provides a condensed manner for associating human readable descriptive
    /// explanations for adjudications on the line item.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "noteNumber")]
    pub note_number: Option<Vec<PositiveInt>>,
    /// Added items detail adjudication
    ///
    /// The adjudication results.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub adjudication: Option<Vec<ClaimResponseItemAdjudication>>,
    /// Insurer added line items
    ///
    /// The third-tier service adjudications for payor added services.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "subDetail")]
    pub sub_detail: Option<Vec<ClaimResponseAddItemDetailSubDetail>>,
}

/// Processing errors
///
/// Errors encountered during the processing of the adjudication.
///
/// ## Requirements
/// Need to communicate processing issues to the requestor.
///
/// ## Implementation Notes
/// If the request contains errors then an error element should be provided and
/// no adjudication related sections (item, addItem, or payment) should be
/// present.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponseError {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Item sequence number
    ///
    /// The sequence number of the line item submitted which contains the error. This
    /// value is omitted when the error occurs outside of the item structure.
    ///
    /// ## Requirements
    /// Provides references to the claim items.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "itemSequence")]
    pub item_sequence: Option<PositiveInt>,
    /// Detail sequence number
    ///
    /// The sequence number of the detail within the line item submitted which
    /// contains the error. This value is omitted when the error occurs outside of
    /// the item structure.
    ///
    /// ## Requirements
    /// Provides references to the claim details within the claim item.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "detailSequence")]
    pub detail_sequence: Option<PositiveInt>,
    /// Subdetail sequence number
    ///
    /// The sequence number of the sub-detail within the detail within the line item
    /// submitted which contains the error. This value is omitted when the error
    /// occurs outside of the item structure.
    ///
    /// ## Requirements
    /// Provides references to the claim sub-details within the claim detail.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "subDetailSequence")]
    pub sub_detail_sequence: Option<PositiveInt>,
    /// Error code detailing processing issues
    ///
    /// An error code, from a specified code system, which details why the claim
    /// could not be adjudicated.
    ///
    /// ## Requirements
    /// Required to convey processing errors.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The adjudication error codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adjudication-error
    pub code: CodeableConcept,
}

/// Adjudication for claim details
///
/// A claim detail. Either a simple (a product or service) or a 'group' of
/// sub-details which are simple items.
///
/// ## Requirements
/// The adjudication for details provided on the claim.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponseItemDetail {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Claim detail instance identifier
    ///
    /// A number to uniquely reference the claim detail entry.
    ///
    /// ## Requirements
    /// Necessary to provide a mechanism to link the adjudication result to the
    /// submitted claim detail.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "detailSequence")]
    pub detail_sequence: PositiveInt,
    /// Applicable note numbers
    ///
    /// The numbers associated with notes below which apply to the adjudication of
    /// this item.
    ///
    /// ## Requirements
    /// Provides a condensed manner for associating human readable descriptive
    /// explanations for adjudications on the line item.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "noteNumber")]
    pub note_number: Option<Vec<PositiveInt>>,
    /// Detail level adjudication details
    ///
    /// The adjudication results.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub adjudication: Option<Vec<ClaimResponseItemAdjudication>>,
    /// Adjudication for claim sub-details
    ///
    /// A sub-detail adjudication of a simple product or service.
    ///
    /// ## Requirements
    /// The adjudication for sub-details provided on the claim.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "subDetail")]
    pub sub_detail: Option<Vec<ClaimResponseItemDetailSubDetail>>,
}

/// Adjudication for claim line items
///
/// A claim line. Either a simple (a product or service) or a 'group' of details
/// which can also be a simple items or groups of sub-details.
///
/// ## Requirements
/// The adjudication for items provided on the claim.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponseItem {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Claim item instance identifier
    ///
    /// A number to uniquely reference the claim item entries.
    ///
    /// ## Requirements
    /// Necessary to provide a mechanism to link the adjudication result to the
    /// submitted claim item.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "itemSequence")]
    pub item_sequence: PositiveInt,
    /// Applicable note numbers
    ///
    /// The numbers associated with notes below which apply to the adjudication of
    /// this item.
    ///
    /// ## Requirements
    /// Provides a condensed manner for associating human readable descriptive
    /// explanations for adjudications on the line item.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "noteNumber")]
    pub note_number: Option<Vec<PositiveInt>>,
    /// Adjudication details
    ///
    /// If this item is a group then the values here are a summary of the
    /// adjudication of the detail items. If this item is a simple product or service
    /// then this is the result of the adjudication of this item.
    ///
    /// ## Requirements
    /// The adjudication results conveys the insurer's assessment of the item
    /// provided in the claim under the terms of the patient's insurance coverage.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub adjudication: Option<Vec<ClaimResponseItemAdjudication>>,
    /// Adjudication for claim details
    ///
    /// A claim detail. Either a simple (a product or service) or a 'group' of
    /// sub-details which are simple items.
    ///
    /// ## Requirements
    /// The adjudication for details provided on the claim.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub detail: Option<Vec<ClaimResponseItemDetail>>,
}

/// Adjudication details
///
/// If this item is a group then the values here are a summary of the
/// adjudication of the detail items. If this item is a simple product or service
/// then this is the result of the adjudication of this item.
///
/// ## Requirements
/// The adjudication results conveys the insurer's assessment of the item
/// provided in the claim under the terms of the patient's insurance coverage.
///
/// ## Cardinality: Required, Multiple (1..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponseItemAdjudication {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Type of adjudication information
    ///
    /// A code to indicate the information type of this adjudication record.
    /// Information types may include the value submitted, maximum values or
    /// percentages allowed or payable under the plan, amounts that: the patient is
    /// responsible for in aggregate or pertaining to this item; amounts paid by
    /// other coverages; and, the benefit payable for this item.
    ///
    /// ## Requirements
    /// Needed to enable understanding of the context of the other information in the
    /// adjudication.
    ///
    /// ## Implementation Notes
    /// For example codes indicating: Co-Pay, deductible, eligible, benefit, tax,
    /// etc.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The adjudication codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adjudication
    pub category: CodeableConcept,
    /// Explanation of adjudication outcome
    ///
    /// A code supporting the understanding of the adjudication result and explaining
    /// variance from expected amount.
    ///
    /// ## Requirements
    /// To support understanding of variance from adjudication expectations.
    ///
    /// ## Implementation Notes
    /// For example may indicate that the funds for this benefit type have been
    /// exhausted.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The adjudication reason codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adjudication-reason
    pub reason: Option<CodeableConcept>,
    /// Monetary amount
    ///
    /// Monetary amount associated with the category.
    ///
    /// ## Requirements
    /// Most adjuciation categories convey a monetary amount.
    ///
    /// ## Implementation Notes
    /// For example: amount submitted, eligible amount, co-payment, and benefit
    /// payable.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub amount: Option<Money>,
    /// Non-monetary value
    ///
    /// A non-monetary value associated with the category. Mutually exclusive to the
    /// amount element above.
    ///
    /// ## Requirements
    /// Some adjudication categories convey a percentage or a fixed value.
    ///
    /// ## Implementation Notes
    /// For example: eligible percentage or co-payment percentage.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub value: Option<Decimal>,
}

/// Adjudication for claim sub-details
///
/// A sub-detail adjudication of a simple product or service.
///
/// ## Requirements
/// The adjudication for sub-details provided on the claim.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponseItemDetailSubDetail {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Claim sub-detail instance identifier
    ///
    /// A number to uniquely reference the claim sub-detail entry.
    ///
    /// ## Requirements
    /// Necessary to provide a mechanism to link the adjudication result to the
    /// submitted claim sub-detail.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "subDetailSequence")]
    pub sub_detail_sequence: PositiveInt,
    /// Applicable note numbers
    ///
    /// The numbers associated with notes below which apply to the adjudication of
    /// this item.
    ///
    /// ## Requirements
    /// Provides a condensed manner for associating human readable descriptive
    /// explanations for adjudications on the line item.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "noteNumber")]
    pub note_number: Option<Vec<PositiveInt>>,
    /// Subdetail level adjudication details
    ///
    /// The adjudication results.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub adjudication: Option<Vec<ClaimResponseItemAdjudication>>,
}

/// Note concerning adjudication
///
/// A note that describes or explains adjudication results in a human readable
/// form.
///
/// ## Requirements
/// Provides the insurer specific textual explanations associated with the
/// processing.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponseProcessNote {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Note instance identifier
    ///
    /// A number to uniquely identify a note entry.
    ///
    /// ## Requirements
    /// Necessary to provide a mechanism to link from adjudications.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub number: Option<PositiveInt>,
    /// display | print | printoper
    ///
    /// The business purpose of the note text.
    ///
    /// ## Requirements
    /// To convey the expectation for when the text is used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The presentation types of notes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/note-type|4.0.1
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Code>,
    /// Note explanatory text
    ///
    /// The explanation or description associated with the processing.
    ///
    /// ## Requirements
    /// Required to provide human readable explanation.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub text: String,
    /// Language of the text
    ///
    /// A code to define the language used in the text of the note.
    ///
    /// ## Requirements
    /// Note text may vary from the resource defined language.
    ///
    /// ## Implementation Notes
    /// Only required if the language is different from the resource language.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<CodeableConcept>,
}

/// Insurer added line items
///
/// The third-tier service adjudications for payor added services.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponseAddItemDetailSubDetail {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Billing, service, product, or drug code
    ///
    /// When the value is a group code then this item collects a set of related claim
    /// details, otherwise this contains the product, service, drug or other billing
    /// code for the item.
    ///
    /// ## Requirements
    /// Necessary to state what was provided or done.
    ///
    /// ## Implementation Notes
    /// If this is an actual service or product line, i.e. not a Group, then use code
    /// to indicate the Professional Service or Product supplied (e.g. CTP, HCPCS,
    /// USCLS, ICD10, NCPDP, DIN, RxNorm, ACHI, CCI). If a grouping item then use a
    /// group code to indicate the type of thing being grouped e.g. 'glasses' or
    /// 'compound'.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Allowable service and product codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-uscls
    #[fhir_serde(rename = "productOrService")]
    pub product_or_service: CodeableConcept,
    /// Service/Product billing modifiers
    ///
    /// Item typification or modifiers codes to convey additional context for the
    /// product or service.
    ///
    /// ## Requirements
    /// To support inclusion of the item for adjudication or to charge an elevated
    /// fee.
    ///
    /// ## Implementation Notes
    /// For example in Oral whether the treatment is cosmetic or associated with TMJ,
    /// or for Medical whether the treatment was outside the clinic or outside of
    /// office hours.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/claim-modifiers
    pub modifier: Option<Vec<CodeableConcept>>,
    /// Count of products or services
    ///
    /// The number of repetitions of a service or product.
    ///
    /// ## Requirements
    /// Required when the product or service code does not convey the quantity
    /// provided.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// Fee, charge or cost per item
    ///
    /// If the item is not a group then this is the fee for the product or service,
    /// otherwise this is the total of the fees for the details of the group.
    ///
    /// ## Requirements
    /// The amount charged to the patient by the provider for a single unit.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "unitPrice")]
    pub unit_price: Option<Money>,
    /// Price scaling factor
    ///
    /// A real number that represents a multiplier used in determining the overall
    /// value of services delivered and/or goods received. The concept of a Factor
    /// allows for a discount or surcharge multiplier to be applied to a monetary
    /// amount.
    ///
    /// ## Requirements
    /// When discounts are provided to a patient (example: Senior's discount) then
    /// this must be documented for adjudication.
    ///
    /// ## Implementation Notes
    /// To show a 10% senior's discount, the value entered is: 0.90 (1.00 - 0.10).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub factor: Option<Decimal>,
    /// Total item cost
    ///
    /// The quantity times the unit price for an additional service or product or
    /// charge.
    ///
    /// ## Requirements
    /// Provides the total amount claimed for the group (if a grouper) or the line
    /// item.
    ///
    /// ## Implementation Notes
    /// For example, the formula: quantity * unitPrice * factor = net. Quantity and
    /// factor are assumed to be 1 if not supplied.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub net: Option<Money>,
    /// Applicable note numbers
    ///
    /// The numbers associated with notes below which apply to the adjudication of
    /// this item.
    ///
    /// ## Requirements
    /// Provides a condensed manner for associating human readable descriptive
    /// explanations for adjudications on the line item.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "noteNumber")]
    pub note_number: Option<Vec<PositiveInt>>,
    /// Added items detail adjudication
    ///
    /// The adjudication results.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub adjudication: Option<Vec<ClaimResponseItemAdjudication>>,
}

/// Adjudication totals
///
/// Categorized monetary totals for the adjudication.
///
/// ## Requirements
/// To provide the requestor with financial totals by category for the
/// adjudication.
///
/// ## Implementation Notes
/// Totals for amounts submitted, co-pays, benefits payable etc.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponseTotal {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and manageable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Type of adjudication information
    ///
    /// A code to indicate the information type of this adjudication record.
    /// Information types may include: the value submitted, maximum values or
    /// percentages allowed or payable under the plan, amounts that the patient is
    /// responsible for in aggregate or pertaining to this item, amounts paid by
    /// other coverages, and the benefit payable for this item.
    ///
    /// ## Requirements
    /// Needed to convey the type of total provided.
    ///
    /// ## Implementation Notes
    /// For example codes indicating: Co-Pay, deductible, eligible, benefit, tax,
    /// etc.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The adjudication codes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adjudication
    pub category: CodeableConcept,
    /// Financial total for the category
    ///
    /// Monetary total amount associated with the category.
    ///
    /// ## Requirements
    /// Needed to convey the total monetary amount.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub amount: Money,
}

/// FHIR ClaimResponse type
///
/// This resource provides the adjudication details from the processing of a
/// Claim resource.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 4.0.1
///
/// See: [ClaimResponse](http://hl7.org/fhir/StructureDefinition/ClaimResponse)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ClaimResponse {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// The only time that a resource does not have an id is when it is being
    /// submitted to the server using a create operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of it's narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: A human language.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/languages
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, and nor can
    /// they have their own independent transaction scope.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags In their meta elements, but SHALL NOT have security labels.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and
    /// manageable, there is a strict set of governance applied to the definition and
    /// use of extensions. Though any implementer can define an extension, there is a
    /// set of requirements that SHALL be met as part of the definition of the
    /// extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and manageable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    /// - **ext-1**: Must have either extensions or value[x], not both (error)
    ///   Expression: `extension.exists() != value.exists()`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Business Identifier for a claim response
    ///
    /// A unique identifier assigned to this claim response.
    ///
    /// ## Requirements
    /// Allows claim responses to be distinguished and referenced.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// active | cancelled | draft | entered-in-error
    ///
    /// The status of the resource instance.
    ///
    /// ## Requirements
    /// Need to track the status of the resource as 'draft' resources may undergo
    /// further edi