// Generated documentation contains content from HL7 FHIR specifications
// which may include HTML-like tags and bracket notations that are not actual HTML or links
#![allow(rustdoc::broken_intra_doc_links)]
#![allow(rustdoc::invalid_html_tags)]

use helios_fhir_macro::{FhirPath, FhirSerde};
use serde::{Deserialize, Serialize};

use crate::{DecimalElement, Element};

/// FHIR Account type
///
/// A financial tool for tracking value accrued for a particular purpose. In the
/// healthcare field, used to track charges for a patient, cost centers, etc.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [Account](http://hl7.org/fhir/StructureDefinition/Account)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Account {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Account number
    ///
    /// Unique identifier used to reference the account. Might or might not be
    /// intended for human use (e.g. credit card number).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// active | inactive | entered-in-error | on-hold | unknown
    ///
    /// Indicates whether the account is presently used/usable or not.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because the status contains the codes
    /// inactive and entered-in-error that mark the Account as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicates whether the account is available to be used.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/account-status|6.0.0-ballot3
    pub status: Code,
    /// Tracks the lifecycle of the account through the billing process
    ///
    /// The BillingStatus tracks the lifecycle of the account through the billing
    /// process. It indicates how transactions are treated when they are allocated to
    /// the account.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Indicates whether the account is available to be used for billing purposes.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/account-billing-status
    #[fhir_serde(rename = "billingStatus")]
    pub billing_status: Option<CodeableConcept>,
    /// E.g. patient, expense, depreciation
    ///
    /// Categorizes the account for reporting and searching purposes.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The usage type of this account, permits categorization of accounts.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/account-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<CodeableConcept>,
    /// Human-readable label
    ///
    /// Name used for the account when displaying it to humans in reports, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Title
    pub name: Option<String>,
    /// The entity that caused the expenses
    ///
    /// Identifies the entity which incurs the expenses. While the immediate
    /// recipients of services or goods might be entities related to the subject, the
    /// expenses were ultimately incurred by the subject of the Account.
    ///
    /// ## Implementation Notes
    /// Accounts can be applied to non-patients for tracking other non-patient
    /// related activities, such as group services (patients not tracked, and costs
    /// charged to another body), or might not be allocated.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// target
    pub subject: Option<Vec<Reference>>,
    /// Transaction window
    ///
    /// The date range of services associated with this account.
    ///
    /// ## Implementation Notes
    /// It is possible for transactions to be posted outside the service period, as
    /// long as the service was provided within the defined service period.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "servicePeriod")]
    pub service_period: Option<Period>,
    /// Episodic account covering these encounters/episodes of care
    ///
    /// An account that collects the charges for a specific set of services offered
    /// over a limited time period. For example, a hospital account might contain all
    /// charges related to a given admission, including any inpatient appointments,
    /// and possibly re-admissions, of the billing for those re-admissions should be
    /// grouped with the initial admission for the purpose of claim submission.
    ///
    /// ## Implementation Notes
    /// Episode Accounts often exist for the duration of a relatively short billing
    /// cycle (for example, a month, or possibly a quarter). One a given billing
    /// cycle ends, the associated Episodic Account would close, and a new account
    /// would open for the next billing cycle. A patient that is admitted for 6
    /// months, where the billing cycle is monthly, would have 6 episodic accounts
    /// each covering one month.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub covers: Option<Vec<Reference>>,
    /// The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account
    ///
    /// The party(s) that are responsible for covering the payment of this account,
    /// and what order should they be applied to the account.
    ///
    /// ## Implementation Notes
    /// Typically. this may be some form of insurance, internal charges, or self-pay.
    ///
    /// Local or jurisdictional business rules may determine which coverage covers
    /// which types of billable items charged to the account, and in which order.
    /// Where the order is important, a local/jurisdictional extension may be defined
    /// to specify the order for the type of charge.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub coverage: Option<Vec<AccountCoverage>>,
    /// Entity managing the Account
    ///
    /// Indicates the service area, hospital, department, etc. with responsibility
    /// for managing the Account.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub owner: Option<Reference>,
    /// Explanation of purpose/use
    ///
    /// Provides additional information about what the account tracks and how it is
    /// used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<Markdown>,
    /// The parties ultimately responsible for balancing the Account
    ///
    /// The parties responsible for balancing the account if other payment options
    /// fall short.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub guarantor: Option<Vec<AccountGuarantor>>,
    /// The list of diagnoses relevant to this account
    ///
    /// When using an account for billing a specific Encounter the set of diagnoses
    /// that are relevant for billing are stored here on the account where they are
    /// able to be sequenced appropriately prior to processing to produce claim(s).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **act-1**: The dateOfDiagnosis is not valid when using a reference to a diagnosis (error)
    ///   Expression: `condition.reference.empty().not() implies dateOfDiagnosis.empty()`
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub diagnosis: Option<Vec<AccountDiagnosis>>,
    /// The list of procedures relevant to this account
    ///
    /// When using an account for billing a specific Encounter the set of procedures
    /// that are relevant for billing are stored here on the account where they are
    /// able to be sequenced appropriately prior to processing to produce claim(s).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **act-2**: The dateOfService is not valid when using a reference to a procedure (error)
    ///   Expression: `code.reference.empty().not() implies dateOfService.empty()`
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub procedure: Option<Vec<AccountProcedure>>,
    /// Reference to an associated parent Account
    ///
    /// Reference to an associated parent Account which has this account as a
    /// sub-account.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub parent: Option<Reference>,
    /// The base or default currency
    ///
    /// The default currency for the account.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/currencies|6.0.0-ballot3
    pub currency: Option<CodeableConcept>,
    /// Calculated account balance(s)
    ///
    /// The calculated account balances - these are calculated and processed by the
    /// finance system.
    ///
    /// The balances with a `term` that is not current are usually generated/updated
    /// by an invoicing or similar process.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub balance: Option<Vec<AccountBalance>>,
    /// Time the balance amount was calculated
    ///
    /// Time the balance amount was calculated.
    ///
    /// ## Implementation Notes
    /// The total(s) are not typically updated using the restful API but more often
    /// by back-end processes included in a typical finance system.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "calculatedAt")]
    pub calculated_at: Option<Instant>,
}

/// Calculated account balance(s)
///
/// The calculated account balances - these are calculated and processed by the
/// finance system.
///
/// The balances with a `term` that is not current are usually generated/updated
/// by an invoicing or similar process.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AccountBalance {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Who is expected to pay this part of the balance
    ///
    /// Who is expected to pay this part of the balance.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Indicates the balance was outstanding at the given age.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/account-aggregate
    pub aggregate: Option<CodeableConcept>,
    /// current | 30 | 60 | 90 | 120
    ///
    /// The term of the account balances - The balance value is the amount that was
    /// outstanding for this age.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Indicates the balance was outstanding at the given age.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/account-balance-term
    pub term: Option<CodeableConcept>,
    /// Estimated balance
    ///
    /// The amount is only an estimated value - this is likely common for `current`
    /// term balances, but not with known terms (that were generated by a backend
    /// process).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub estimate: Option<Boolean>,
    /// Calculated amount
    ///
    /// The actual balance value calculated for the age defined in the term property.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub amount: Money,
}

/// The parties ultimately responsible for balancing the Account
///
/// The parties responsible for balancing the account if other payment options
/// fall short.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AccountGuarantor {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Responsible entity
    ///
    /// The entity who is responsible.
    ///
    /// ## Implementation Notes
    /// A party and/or an account is expected to be present on the guarantor.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub party: Option<Reference>,
    /// Credit or other hold applied
    ///
    /// A guarantor may be placed on credit hold or otherwise have their role
    /// temporarily suspended.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "onHold")]
    pub on_hold: Option<Boolean>,
    /// Guarantee account during
    ///
    /// The timeframe during which the guarantor accepts responsibility for the
    /// account.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub period: Option<Period>,
    /// A specific Account for the guarantor
    ///
    /// Reference to a specific Account belonging to the guarantor to use.
    ///
    /// ## Implementation Notes
    /// A party and/or an account is expected to be present on the guarantor.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub account: Option<Reference>,
}

/// The list of diagnoses relevant to this account
///
/// When using an account for billing a specific Encounter the set of diagnoses
/// that are relevant for billing are stored here on the account where they are
/// able to be sequenced appropriately prior to processing to produce claim(s).
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **act-1**: The dateOfDiagnosis is not valid when using a reference to a diagnosis (error)
///   Expression: `condition.reference.empty().not() implies dateOfDiagnosis.empty()`
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AccountDiagnosis {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Ranking of the diagnosis (for each type)
    ///
    /// Ranking of the diagnosis (for each type).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: Option<PositiveInt>,
    /// The diagnosis relevant to the account
    ///
    /// The diagnosis relevant to the account.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/condition-code
    ///
    /// ## Aliases
    /// indication
    ///
    /// ## Conditions
    /// Used when: act-1
    pub condition: CodeableReference,
    /// Date of the diagnosis (when coded diagnosis)
    ///
    /// Ranking of the diagnosis (for each type).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: act-1
    #[fhir_serde(rename = "dateOfDiagnosis")]
    pub date_of_diagnosis: Option<DateTime>,
    /// Type that this diagnosis has relevant to the account (e.g. admission, billing, discharge …)
    ///
    /// Type that this diagnosis has relevant to the account (e.g. admission,
    /// billing, discharge …).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: The type of diagnosis this condition represents.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/encounter-diagnosis-use
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Vec<CodeableConcept>>,
    /// Diagnosis present on Admission
    ///
    /// Was the Diagnosis present on Admission in the related Encounter.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "onAdmission")]
    pub on_admission: Option<Boolean>,
    /// Package Code specific for billing
    ///
    /// The package code can be used to group diagnoses that may be priced or
    /// delivered as a single product. Such as DRGs.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Local or Regional package codes, e.g. DRGs
    #[fhir_serde(rename = "packageCode")]
    pub package_code: Option<Vec<CodeableConcept>>,
}

/// The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account
///
/// The party(s) that are responsible for covering the payment of this account,
/// and what order should they be applied to the account.
///
/// ## Implementation Notes
/// Typically. this may be some form of insurance, internal charges, or self-pay.
///
/// Local or jurisdictional business rules may determine which coverage covers
/// which types of billable items charged to the account, and in which order.
/// Where the order is important, a local/jurisdictional extension may be defined
/// to specify the order for the type of charge.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AccountCoverage {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// The party(s), such as insurances, that may contribute to the payment of this account
    ///
    /// The party(s) that contribute to payment (or part of) of the charges applied
    /// to this account (including self-pay).
    ///
    /// A coverage may only be responsible for specific types of charges, and the
    /// sequence of the coverages in the account could be important when processing
    /// billing.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub coverage: Reference,
    /// The priority of the coverage in the context of this account
    ///
    /// The priority of the coverage in the context of this account.
    ///
    /// ## Implementation Notes
    /// It is common in some jurisdictions for there to be multiple coverages
    /// allocated to an account, and a sequence is required to order the settling of
    /// the account (often with insurance claiming).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// coordination of benefit priority
    pub priority: Option<PositiveInt>,
}

/// The list of procedures relevant to this account
///
/// When using an account for billing a specific Encounter the set of procedures
/// that are relevant for billing are stored here on the account where they are
/// able to be sequenced appropriately prior to processing to produce claim(s).
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **act-2**: The dateOfService is not valid when using a reference to a procedure (error)
///   Expression: `code.reference.empty().not() implies dateOfService.empty()`
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AccountProcedure {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Ranking of the procedure (for each type)
    ///
    /// Ranking of the procedure (for each type).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sequence: Option<PositiveInt>,
    /// The procedure relevant to the account
    ///
    /// The procedure relevant to the account.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/procedure-code
    ///
    /// ## Aliases
    /// indication
    ///
    /// ## Conditions
    /// Used when: act-2
    pub code: CodeableReference,
    /// Date of the procedure (when coded procedure)
    ///
    /// Date of the procedure when using a coded procedure. If using a reference to a
    /// procedure, then the date on the procedure should be used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: act-2
    #[fhir_serde(rename = "dateOfService")]
    pub date_of_service: Option<DateTime>,
    /// How this procedure value should be used in charging the account
    ///
    /// How this procedure value should be used in charging the account.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Usage for the specific procedure - e.g. billing
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Vec<CodeableConcept>>,
    /// Package Code specific for billing
    ///
    /// The package code can be used to group procedures that may be priced or
    /// delivered as a single product. Such as DRGs.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Local or Regional package codes, e.g. DRGs
    #[fhir_serde(rename = "packageCode")]
    pub package_code: Option<Vec<CodeableConcept>>,
    /// Any devices that were associated with the procedure
    ///
    /// Any devices that were associated with the procedure relevant to the account.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub device: Option<Vec<Reference>>,
}

/// Who should participate in the action
///
/// Indicates who should participate in performing the action described.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ActivityDefinitionParticipant {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// careteam | device | group | healthcareservice | location | organization | patient | practitioner | practitionerrole | relatedperson
    ///
    /// The type of participant in the action.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The type of participant in the activity.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/action-participant-type|6.0.0-ballot3
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Code>,
    /// Who or what can participate
    ///
    /// The type of participant in the action.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "typeCanonical")]
    pub type_canonical: Option<Canonical>,
    /// Who or what can participate
    ///
    /// The type of participant in the action.
    ///
    /// ## Implementation Notes
    /// When this element is a reference, it SHOULD be a reference to a definitional
    /// resource (for example, a location type, rather than a specific location).
    /// Note that specimen as a participant in cell-line research is acceptable, but
    /// specimen in clinical research would typically be represented as the focus
    /// rather the subject.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "typeReference")]
    pub type_reference: Option<Reference>,
    /// E.g. Nurse, Surgeon, Parent, etc
    ///
    /// The role the participant should play in performing the described action.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Defines roles played by participants for the action.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/action-participant-role
    pub role: Option<CodeableConcept>,
    /// E.g. Author, Reviewer, Witness, etc
    ///
    /// Indicates how the actor will be involved in the action - author, reviewer,
    /// witness, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/action-participant-function
    pub function: Option<CodeableConcept>,
}

/// Dynamic aspects of the definition
///
/// Dynamic values that will be evaluated to produce values for elements of the
/// resulting resource. For example, if the dosage of a medication must be
/// computed based on the patient's weight, a dynamic value would be used to
/// specify an expression that calculated the weight, and the path on the request
/// resource that would contain the result.
///
/// ## Implementation Notes
/// Dynamic values are applied in the order in which they are defined in the
/// ActivityDefinition. Note that if both a transform and dynamic values are
/// specified, the dynamic values will be applied to the result of the transform.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ActivityDefinitionDynamicValue {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// The path to the element to be set dynamically
    ///
    /// The path to the element to be customized. This is the path on the resource
    /// that will hold the result of the calculation defined by the expression. The
    /// specified path SHALL be a FHIRPath resolvable on the specified target type of
    /// the ActivityDefinition, and SHALL consist only of identifiers, constant
    /// indexers, and a restricted subset of functions. The path is allowed to
    /// contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to
    /// traverse multiple-cardinality sub-elements (see the [Simple FHIRPath
    /// Profile](fhirpath.html#simple) for full details).
    ///
    /// ## Implementation Notes
    /// The path attribute contains a [Simple FHIRPath Subset](fhirpath.html#simple)
    /// that allows path traversal, but not calculation.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub path: String,
    /// An expression that provides the dynamic value for the customization
    ///
    /// An expression specifying the value of the customized element.
    ///
    /// ## Implementation Notes
    /// The expression may be inlined, or may be a reference to a named expression
    /// within a logic library referenced by the library element.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub expression: Expression,
}

/// Choice of types for the versionAlgorithm\[x\] field in ActivityDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "versionAlgorithm")]
pub enum ActivityDefinitionVersionAlgorithm {
    /// Variant accepting the String type.
    #[fhir_serde(rename = "versionAlgorithmString")]
    String(String),
    /// Variant accepting the Coding type.
    #[fhir_serde(rename = "versionAlgorithmCoding")]
    Coding(Coding),
}

/// Choice of types for the subject\[x\] field in ActivityDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "subject")]
pub enum ActivityDefinitionSubject {
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "subjectCodeableConcept")]
    CodeableConcept(CodeableConcept),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "subjectReference")]
    Reference(Reference),
    /// Variant accepting the Canonical type.
    #[fhir_serde(rename = "subjectCanonical")]
    Canonical(Canonical),
}

/// Choice of types for the timing\[x\] field in ActivityDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "timing")]
pub enum ActivityDefinitionTiming {
    /// Variant accepting the Timing type.
    #[fhir_serde(rename = "timingTiming")]
    Timing(Timing),
    /// Variant accepting the Age type.
    #[fhir_serde(rename = "timingAge")]
    Age(Age),
    /// Variant accepting the Range type.
    #[fhir_serde(rename = "timingRange")]
    Range(Range),
    /// Variant accepting the Duration type.
    #[fhir_serde(rename = "timingDuration")]
    Duration(Duration),
}

/// Choice of types for the asNeeded\[x\] field in ActivityDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "asNeeded")]
pub enum ActivityDefinitionAsNeeded {
    /// Variant accepting the Boolean type.
    #[fhir_serde(rename = "asNeededBoolean")]
    Boolean(Boolean),
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "asNeededCodeableConcept")]
    CodeableConcept(CodeableConcept),
}

/// Choice of types for the product\[x\] field in ActivityDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "product")]
pub enum ActivityDefinitionProduct {
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "productReference")]
    Reference(Reference),
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "productCodeableConcept")]
    CodeableConcept(CodeableConcept),
}

/// FHIR ActivityDefinition type
///
/// This resource allows for the definition of some activity to be performed,
/// independent of a particular patient, practitioner, or other performance
/// context.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [ActivityDefinition](http://hl7.org/fhir/StructureDefinition/ActivityDefinition)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "versionAlgorithm,subject,timing,asNeeded,product")]
pub struct ActivityDefinition {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Canonical identifier for this activity definition, represented as a URI (globally unique)
    ///
    /// An absolute URI that is used to identify this activity definition when it is
    /// referenced in a specification, model, design or an instance; also called its
    /// canonical identifier. This SHOULD be globally unique and SHOULD be a literal
    /// address at which an authoritative instance of this activity definition is (or
    /// will be) published. This URL can be the target of a canonical reference. It
    /// SHALL remain the same when the activity definition is stored on different
    /// servers.
    ///
    /// ## Requirements
    /// Allows the activity definition to be referenced by a single globally unique
    /// identifier.
    ///
    /// ## Implementation Notes
    /// Can be a urn:uuid: or a urn:oid: but real http: addresses are preferred.
    /// Multiple instances may share the same URL if they have a distinct version.
    ///
    /// The determination of when to create a new version of a resource (same url,
    /// new version) vs. defining a new artifact is up to the author. Considerations
    /// for making this decision are found in [Technical and Business
    /// Versions](resource.html#versions).
    ///
    /// In some cases, the resource can no longer be found at the stated url, but the
    /// url itself cannot change. Implementations can use the
    /// [meta.source](resource.html#meta) element to indicate where the current
    /// master source of the resource can be found.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **cnl-1**: URL should not contain | or # - these characters make processing canonical references problematic (warning)
    ///   Expression: `exists() implies matches('^[^|# ]+$')`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Option<Uri>,
    /// Additional identifier for the activity definition
    ///
    /// A formal identifier that is used to identify this activity definition when it
    /// is represented in other formats, or referenced in a specification, model,
    /// design or an instance.
    ///
    /// ## Requirements
    /// Allows externally provided and/or usable business identifiers to be easily
    /// associated with the module.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Business version of the activity definition
    ///
    /// The identifier that is used to identify this version of the activity
    /// definition when it is referenced in a specification, model, design or
    /// instance. This is an arbitrary value managed by the activity definition
    /// author and is not expected to be globally unique. For example, it might be a
    /// timestamp (e.g. yyyymmdd) if a managed version is not available. There is
    /// also no expectation that versions can be placed in a lexicographical
    /// sequence. To provide a version consistent with the Decision Support Service
    /// specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more
    /// information on versioning knowledge assets, refer to the Decision Support
    /// Service specification. Note that a version is required for non-experimental
    /// active assets.
    ///
    /// ## Implementation Notes
    /// There may be different activity definition instances that have the same
    /// identifier but different versions. The version can be appended to the url in
    /// a reference to allow a reference to a particular business version of the
    /// activity definition with the format [url]|[version]. The version SHOULD NOT
    /// contain a '#' - see [Business Version](resource.html#bv-format).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub version: Option<String>,
    /// How to compare versions
    ///
    /// Indicates the mechanism used to compare versions to determine which is more
    /// current.
    ///
    /// ## Implementation Notes
    /// If set as a string, this is a FHIRPath expression that has two additional
    /// context variables passed in - %version1 and %version2 and will return a
    /// negative number if version1 is newer, a positive number if version2 and a 0
    /// if the version ordering can't be successfully be determined.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/version-algorithm
    #[fhir_serde(flatten)]
    pub version_algorithm: Option<ActivityDefinitionVersionAlgorithm>,
    /// Name for this activity definition (computer friendly)
    ///
    /// A natural language name identifying the activity definition. This name should
    /// be usable as an identifier for the module by machine processing applications
    /// such as code generation.
    ///
    /// ## Requirements
    /// Support human navigation and code generation.
    ///
    /// ## Implementation Notes
    /// The name is not expected to be globally unique. The name should be a simple
    /// alphanumeric type name to ensure that it is machine-processing friendly.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cnl-0
    pub name: Option<String>,
    /// Name for this activity definition (human friendly)
    ///
    /// A short, descriptive, user-friendly title for the activity definition.
    ///
    /// ## Implementation Notes
    /// This name does not need to be machine-processing friendly and may contain
    /// punctuation, white-space, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// Subordinate title of the activity definition
    ///
    /// An explanatory or alternate title for the activity definition giving
    /// additional information about its content.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub subtitle: Option<String>,
    /// draft | active | retired | unknown
    ///
    /// The status of this activity definition. Enables tracking the life-cycle of
    /// the content.
    ///
    /// ## Implementation Notes
    /// Allows filtering of activity definitions that are appropriate for use versus
    /// not.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This is labeled as "Is Modifier" because applications should not use a retired {{title}} without due consideration
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|6.0.0-ballot3
    pub status: Code,
    /// For testing only - never for real usage
    ///
    /// A Boolean value to indicate that this activity definition is authored for
    /// testing purposes (or education/evaluation/marketing) and no version of this
    /// resource will ever be intended for genuine usage.
    ///
    /// ## Requirements
    /// Enables experimental content to be developed following the same lifecycle
    /// that would be used for a production-level activity definition.
    ///
    /// ## Implementation Notes
    /// Allows filtering of activity definitions that are appropriate for use versus
    /// not.. Experimental resources might include example instances in
    /// implementation guides, instances created solely for testing purposes, etc. If
    /// experimental is 'true' for any version of a resource, it should be true for
    /// all versions of the resource. (If experimental changes, then it is being
    /// misused or a resource that was never intended for real-world use has
    /// unexpectedly changed its purpose.).
    ///
    /// Experimental resources are not expected to be stable and may well have
    /// breaking changes without a corresponding change to the 'version' element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    /// - When missing: If absent, this resource is treated as though it is not experimental.
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub experimental: Option<Boolean>,
    /// Type of individual the activity definition is intended for
    ///
    /// A code, group definition, or canonical reference that describes or identifies
    /// the intended subject of the activity being defined. Canonical references are
    /// allowed to support the definition of protocols for drug and substance quality
    /// specifications, and is allowed to reference a MedicinalProductDefinition,
    /// SubstanceDefinition, AdministrableProductDefinition,
    /// ManufacturedItemDefinition, or PackagedProductDefinition resource.
    ///
    /// ## Implementation Notes
    /// Note that the choice of canonical for the subject element was introduced in
    /// R4B to support pharmaceutical quality use cases. To ensure as much
    /// backwards-compatibility as possible, it is recommended to only use the new
    /// canonical type with these use cases.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - When missing: Patient
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: The possible types of subjects for an activity (E.g. Patient, Practitioner, Organization, Location, etc.).
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/participant-resource-types
    #[fhir_serde(flatten)]
    pub subject: Option<ActivityDefinitionSubject>,
    /// Date last changed
    ///
    /// The date (and optionally time) when the activity definition was last
    /// significantly changed. The date must change when the business version changes
    /// and it must change if the status code changes. In addition, it should change
    /// when the substantive content of the activity definition changes.
    ///
    /// ## Implementation Notes
    /// The date is often not tracked until the resource is published, but may be
    /// present on draft content. Note that this is not the same as the resource
    /// last-modified-date, since the resource may be a secondary representation of
    /// the activity definition. Additional specific dates may be added as extensions
    /// or be found by consulting Provenances associated with past versions of the
    /// resource.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Revision Date
    pub date: Option<DateTime>,
    /// Name of the publisher/steward (organization or individual)
    ///
    /// The name of the organization or individual responsible for the release and
    /// ongoing maintenance of the activity definition.
    ///
    /// ## Requirements
    /// Helps establish the "authority/credibility" of the activity definition. May
    /// also allow for contact.
    ///
    /// ## Implementation Notes
    /// Usually an organization but may be an individual. The publisher (or steward)
    /// of the activity definition is the organization or individual primarily
    /// responsible for the maintenance and upkeep of the activity definition. This
    /// is not necessarily the same individual or organization that developed and
    /// initially authored the content. The publisher is the primary point of contact
    /// for questions or issues with the activity definition. This item SHOULD be
    /// populated unless the information is available from context.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub publisher: Option<String>,
    /// Contact details for the publisher
    ///
    /// Contact details to assist a user in finding and communicating with the
    /// publisher.
    ///
    /// ## Implementation Notes
    /// May be a web site, an email address, a telephone number, etc.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contact: Option<Vec<ContactDetail>>,
    /// Natural language description of the activity definition
    ///
    /// A free text natural language description of the activity definition from a
    /// consumer's perspective.
    ///
    /// ## Implementation Notes
    /// This description can be used to capture details such as comments about
    /// misuse, instructions for clinical use and interpretation, literature
    /// references, examples from the paper world, etc. It is not a rendering of the
    /// activity definition as conveyed in the 'text' field of the resource itself.
    /// This item SHOULD be populated unless the information is available from
    /// context (e.g. the language of the activity definition is presumed to be the
    /// predominant language in the place the activity definition was created).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<Markdown>,
    /// The context that the content is intended to support
    ///
    /// The content was developed with a focus and intent of supporting the contexts
    /// that are listed. These contexts may be general categories (gender, age, ...)
    /// or may be references to specific programs (insurance plans, studies, ...) and
    /// may be used to assist with indexing and searching for appropriate activity
    /// definition instances.
    ///
    /// ## Requirements
    /// Assist in searching for appropriate content.
    ///
    /// ## Implementation Notes
    /// When multiple useContexts are specified, there is no expectation that all or
    /// any of the contexts apply.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "useContext")]
    pub use_context: Option<Vec<UsageContext>>,
    /// Jurisdiction of the authority that maintains the activity definition (if applicable)
    ///
    /// A legal or geographic region in which the authority that maintains the
    /// resource is operating. In general, the jurisdiction is also found in the
    /// useContext. The useContext may reference additional jurisdictions because the
    /// defining jurisdiction does not necessarily limit the jurisdictions of use.
    ///
    /// ## Implementation Notes
    /// It may be possible for the activity definition to be used in jurisdictions
    /// other than those for which it was originally designed or intended.
    ///
    /// DEPRECATION NOTE: For consistency, implementations are encouraged to migrate
    /// to using the new 'jurisdiction' code in the useContext element. (I.e.
    /// useContext.code indicating
    /// http://terminology.hl7.org/CodeSystem/usage-context-type#jurisdiction and
    /// useContext.valueCodeableConcept indicating the jurisdiction.)
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Countries and regions within which this artifact is targeted for use.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/jurisdiction
    pub jurisdiction: Option<Vec<CodeableConcept>>,
    /// Why this activity definition is defined
    ///
    /// Explanation of why this activity definition is needed and why it has been
    /// designed as it has.
    ///
    /// ## Implementation Notes
    /// This element does not describe the usage of the activity definition. Instead,
    /// it provides traceability of ''why'' the resource is either needed or ''why''
    /// it is defined as it is. This may be used to point to source materials or
    /// specifications that drove the structure of this activity definition.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub purpose: Option<Markdown>,
    /// Describes the clinical usage of the activity definition
    ///
    /// A detailed description of how the activity definition is used from a clinical
    /// perspective.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub usage: Option<Markdown>,
    /// Use and/or publishing restrictions
    ///
    /// A copyright statement relating to the activity definition and/or its
    /// contents. Copyright statements are generally legal restrictions on the use
    /// and publishing of the activity definition.
    ///
    /// ## Requirements
    /// Consumers must be able to determine any legal restrictions on the use of the
    /// activity definition and/or its content.
    ///
    /// ## Implementation Notes
    /// The short copyright declaration (e.g. (c) '2015+ xyz organization' should be
    /// sent in the copyrightLabel element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// License, Restrictions
    pub copyright: Option<Markdown>,
    /// Copyright holder and year(s)
    ///
    /// A short string (<50 characters), suitable for inclusion in a page footer that
    /// identifies the copyright holder, effective period, and optionally whether
    /// rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').
    ///
    /// ## Requirements
    /// Defines the content expected to be rendered in all representations of the
    /// artifact.
    ///
    /// ## Implementation Notes
    /// The (c) symbol should NOT be included in this string. It will be added by
    /// software when rendering the notation. Full details about licensing,
    /// restrictions, warrantees, etc. goes in the more general 'copyright' element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "copyrightLabel")]
    pub copyright_label: Option<String>,
    /// When the activity definition was approved by publisher
    ///
    /// The date on which the resource content was approved by the publisher.
    /// Approval happens once when the content is officially approved for usage.
    ///
    /// ## Implementation Notes
    /// The 'date' element may be more recent than the approval date because of minor
    /// changes or editorial corrections.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "approvalDate")]
    pub approval_date: Option<Date>,
    /// When the activity definition was last reviewed by the publisher
    ///
    /// The date on which the resource content was last reviewed. Review happens
    /// periodically after approval but does not change the original approval date.
    ///
    /// ## Requirements
    /// Gives a sense of how "current" the content is. Resources that have not been
    /// reviewed in a long time may have a risk of being less appropriate/relevant.
    ///
    /// ## Implementation Notes
    /// If specified, this date follows the original approval date.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastReviewDate")]
    pub last_review_date: Option<Date>,
    /// When the activity definition is expected to be used
    ///
    /// The period during which the activity definition content was or is planned to
    /// be in active use.
    ///
    /// ## Requirements
    /// Allows establishing a transition before a resource comes into effect and also
    /// allows for a sunsetting process when new versions of the activity definition
    /// are or are expected to be used instead.
    ///
    /// ## Implementation Notes
    /// The effective period for an activity definition determines when the content
    /// is applicable for usage and is independent of publication and review dates.
    /// For example, a activity intended to be used for the year 2016 might be
    /// published in 2015.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "effectivePeriod")]
    pub effective_period: Option<Period>,
    /// E.g. Education, Treatment, Assessment, etc
    ///
    /// Descriptive topics related to the content of the activity. Topics provide a
    /// high-level categorization of the activity that can be useful for filtering
    /// and searching.
    ///
    /// ## Requirements
    /// Repositories must be able to determine how to categorize the activity
    /// definition so that it can be found by topical searches.
    ///
    /// ## Implementation Notes
    /// DEPRECATION NOTE: For consistency, implementations are encouraged to migrate
    /// to using the new 'topic' code in the useContext element. (I.e.
    /// useContext.code indicating
    /// http://terminology.hl7.org/CodeSystem/usage-context-type#topic and
    /// useContext.valueCodeableConcept indicating the topic)
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: High-level categorization of the definition, used for searching, sorting, and filtering.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/definition-topic
    pub topic: Option<Vec<CodeableConcept>>,
    /// Who authored the content
    ///
    /// An individiual or organization primarily involved in the creation and
    /// maintenance of the content.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub author: Option<Vec<ContactDetail>>,
    /// Who edited the content
    ///
    /// An individual or organization primarily responsible for internal coherence of
    /// the content.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub editor: Option<Vec<ContactDetail>>,
    /// Who reviewed the content
    ///
    /// An individual or organization asserted by the publisher to be primarily
    /// responsible for review of some aspect of the content.
    ///
    /// ## Implementation Notes
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub reviewer: Option<Vec<ContactDetail>>,
    /// Who endorsed the content
    ///
    /// An individual or organization asserted by the publisher to be responsible for
    /// officially endorsing the content for use in some setting.
    ///
    /// ## Implementation Notes
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub endorser: Option<Vec<ContactDetail>>,
    /// Additional documentation, citations, etc
    ///
    /// Related artifacts such as additional documentation, justification, or
    /// bibliographic references.
    ///
    /// ## Requirements
    /// Activity definitions must be able to provide enough information for consumers
    /// of the content (and/or interventions or results produced by the content) to
    /// be able to determine and understand the justification for and evidence in
    /// support of the content.
    ///
    /// ## Implementation Notes
    /// Each related artifact is either an attachment, or a reference to another
    /// resource, but not both.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "relatedArtifact")]
    pub related_artifact: Option<Vec<RelatedArtifact>>,
    /// Logic used by the activity definition
    ///
    /// A reference to a Library resource containing any formal logic used by the
    /// activity definition.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub library: Option<Vec<Canonical>>,
    /// Kind of resource
    ///
    /// A description of the kind of resource the activity definition is
    /// representing. For example, a MedicationRequest, a ServiceRequest, or a
    /// CommunicationRequest.
    ///
    /// ## Implementation Notes
    /// The kind element may only specify Request resource types to facilitate
    /// considering user input as part of processing the result of any automated
    /// clinical reasoning processes. To support creation of event resources, such as
    /// Observations, RiskAssessments, and DetectedIssues, use a Task resource with
    /// the focus of the task set to the event resource to be created. Note that the
    /// kind of resource to be created may determine what types of extensions are
    /// permitted.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The kind of activity the definition is describing.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/request-resource-types|6.0.0-ballot3
    pub kind: Option<Code>,
    /// What profile the resource needs to conform to
    ///
    /// A profile to which the target of the activity definition is expected to
    /// conform.
    ///
    /// ## Requirements
    /// Allows profiles to be used to describe the types of activities that can be
    /// performed within a workflow, protocol, or order set.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub profile: Option<Canonical>,
    /// Detail type of activity
    ///
    /// Detailed description of the type of activity; e.g. What lab test, what
    /// procedure, what kind of encounter.
    ///
    /// ## Requirements
    /// Allows matching performed to planned as well as validation against protocols.
    ///
    /// ## Implementation Notes
    /// Tends to be less relevant for activities involving particular products.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Detailed type of the activity; e.g. CBC.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/procedure-code
    pub code: Option<CodeableConcept>,
    /// proposal | solicit-offer | offer-response | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option
    ///
    /// Indicates the level of authority/intentionality associated with the activity
    /// and where the request should fit into the workflow chain.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Codes indicating the degree of authority/intentionality associated with a request.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/request-intent|6.0.0-ballot3
    pub intent: Option<Code>,
    /// routine | urgent | asap | stat
    ///
    /// Indicates how quickly the activity should be addressed with respect to other
    /// requests.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Identifies the level of importance to be assigned to actioning the request.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/request-priority|6.0.0-ballot3
    pub priority: Option<Code>,
    /// True if the activity should not be performed
    ///
    /// Set this to true if the definition is to indicate that a particular activity
    /// should NOT be performed. If true, this element should be interpreted to
    /// reinforce a negative coding. For example NPO as a code with a doNotPerform of
    /// true would still indicate to NOT perform the action.
    ///
    /// ## Implementation Notes
    /// This element is not intended to be used to communicate a decision support
    /// response to cancel an order in progress. That should be done with the
    /// "remove" type of a PlanDefinition or RequestOrchestration.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - If true this element negates the specified action. For Example,  instead of a request for a procedure, it is a request for the procedure to not occur.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "doNotPerform")]
    pub do_not_perform: Option<Boolean>,
    /// When activity is to occur
    ///
    /// The timing or frequency upon which the described activity is to occur.
    ///
    /// ## Requirements
    /// Allows prompting for activities and detection of missed planned activities.
    ///
    /// ## Implementation Notes
    /// The intent of the timing element is to provide timing when the action should
    /// be performed. As a definitional resource, this timing is interpreted as part
    /// of an apply operation so that the timing of the result actions in a CarePlan
    /// or RequestOrchestration, for example, would be specified by evaluating the
    /// timing definition in the context of the apply and setting the resulting
    /// timing on the appropriate elements of the target resource. If the timing is
    /// an Age, the activity is expected to be performed when the subject is the
    /// given Age. When the timing is a Duration, the activity is expected to be
    /// performed within the specified duration from the apply. When the timing is a
    /// Range, it may be a range of Ages or Durations, providing a range for the
    /// expected timing of the resulting activity. When the timing is a Timing, it is
    /// establishing a schedule for the timing of the resulting activity.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub timing: Option<ActivityDefinitionTiming>,
    /// Preconditions for service
    ///
    /// If a CodeableConcept is present, it indicates the pre-condition for
    /// performing the service. For example "pain", "on flare-up", etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A coded concept identifying the pre-condition that should hold prior to performing a procedure.  For example "pain", "on flare-up", etc.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/medication-as-needed-reason
    #[fhir_serde(flatten)]
    pub as_needed: Option<ActivityDefinitionAsNeeded>,
    /// Where it should happen
    ///
    /// Identifies the facility where the activity will occur; e.g. home, hospital,
    /// specific clinic, etc.
    ///
    /// ## Requirements
    /// Helps in planning of activity.
    ///
    /// ## Implementation Notes
    /// May reference a specific clinical location or may just identify a type of
    /// location.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// facility
    pub location: Option<CodeableReference>,
    /// Who should participate in the action
    ///
    /// Indicates who should participate in performing the action described.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub participant: Option<Vec<ActivityDefinitionParticipant>>,
    /// What's administered/supplied
    ///
    /// Identifies the food, drug or other product being consumed or supplied in the
    /// activity.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Code describing the type of substance or medication.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/medication-codes
    #[fhir_serde(flatten)]
    pub product: Option<ActivityDefinitionProduct>,
    /// How much is administered/consumed/supplied
    ///
    /// Identifies the quantity expected to be consumed at once (per dose, per meal,
    /// etc.).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// dose
    pub quantity: Option<Quantity>,
    /// Detailed dosage instructions
    ///
    /// Provides detailed dosage instructions in the same way that they are described
    /// for MedicationRequest resources.
    ///
    /// ## Implementation Notes
    /// If a dosage instruction is used, the definition should not specify timing or
    /// quantity.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub dosage: Option<Vec<Dosage>>,
    /// What part of body to perform on
    ///
    /// Indicates the sites on the subject's body where the procedure should be
    /// performed (I.e. the target sites).
    ///
    /// ## Requirements
    /// Knowing where the procedure is made is important for tracking if multiple
    /// sites are possible.
    ///
    /// ## Implementation Notes
    /// Only used if not implicit in the code found in ServiceRequest.type.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A code that identifies the anatomical location.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/body-site
    #[fhir_serde(rename = "bodySite")]
    pub body_site: Option<Vec<CodeableConcept>>,
    /// What specimens are required to perform this action
    ///
    /// Defines specimen requirements for the action to be performed, such as
    /// required specimens for a lab test.
    ///
    /// ## Requirements
    /// Needed to represent lab order definitions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "specimenRequirement")]
    pub specimen_requirement: Option<Vec<Canonical>>,
    /// What observations are required to perform this action
    ///
    /// Defines observation requirements for the action to be performed, such as body
    /// weight or surface area.
    ///
    /// ## Requirements
    /// Needed to represent observation definitions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "observationRequirement")]
    pub observation_requirement: Option<Vec<Canonical>>,
    /// What observations must be produced by this action
    ///
    /// Defines the observations that are expected to be produced by the action.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "observationResultRequirement")]
    pub observation_result_requirement: Option<Vec<Canonical>>,
    /// Transform to apply the template
    ///
    /// A reference to a StructureMap resource that defines a transform that can be
    /// executed to produce the intent resource using the ActivityDefinition instance
    /// as the input.
    ///
    /// ## Implementation Notes
    /// Note that if both a transform and dynamic values are specified, the dynamic
    /// values will be applied to the result of the transform.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub transform: Option<Canonical>,
    /// Dynamic aspects of the definition
    ///
    /// Dynamic values that will be evaluated to produce values for elements of the
    /// resulting resource. For example, if the dosage of a medication must be
    /// computed based on the patient's weight, a dynamic value would be used to
    /// specify an expression that calculated the weight, and the path on the request
    /// resource that would contain the result.
    ///
    /// ## Implementation Notes
    /// Dynamic values are applied in the order in which they are defined in the
    /// ActivityDefinition. Note that if both a transform and dynamic values are
    /// specified, the dynamic values will be applied to the result of the transform.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "dynamicValue")]
    pub dynamic_value: Option<Vec<ActivityDefinitionDynamicValue>>,
}

/// Choice of types for the versionAlgorithm\[x\] field in ActorDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "versionAlgorithm")]
pub enum ActorDefinitionVersionAlgorithm {
    /// Variant accepting the String type.
    #[fhir_serde(rename = "versionAlgorithmString")]
    String(String),
    /// Variant accepting the Coding type.
    #[fhir_serde(rename = "versionAlgorithmCoding")]
    Coding(Coding),
}

/// FHIR ActorDefinition type
///
/// The ActorDefinition resource is used to describe an actor - a human or an
/// application that plays a role in data exchange, and that may have obligations
/// associated with the role the actor plays.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [ActorDefinition](http://hl7.org/fhir/StructureDefinition/ActorDefinition)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "versionAlgorithm")]
pub struct ActorDefinition {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Canonical identifier for this actor definition, represented as a URI (globally unique)
    ///
    /// An absolute URI that is used to identify this actor definition when it is
    /// referenced in a specification, model, design or an instance; also called its
    /// canonical identifier. This SHOULD be globally unique and SHOULD be a literal
    /// address at which an authoritative instance of this actor definition is (or
    /// will be) published. This URL can be the target of a canonical reference. It
    /// SHALL remain the same when the actor definition is stored on different
    /// servers.
    ///
    /// ## Requirements
    /// Allows the actor definition to be referenced by a single globally unique
    /// identifier.
    ///
    /// ## Implementation Notes
    /// Can be a urn:uuid: or a urn:oid: but real http: addresses are preferred.
    /// Multiple instances may share the same URL if they have a distinct version.
    ///
    /// The determination of when to create a new version of a resource (same url,
    /// new version) vs. defining a new artifact is up to the author. Considerations
    /// for making this decision are found in [Technical and Business
    /// Versions](resource.html#versions).
    ///
    /// In some cases, the resource can no longer be found at the stated url, but the
    /// url itself cannot change. Implementations can use the
    /// [meta.source](resource.html#meta) element to indicate where the current
    /// master source of the resource can be found.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **cnl-1**: URL should not contain | or # - these characters make processing canonical references problematic (warning)
    ///   Expression: `exists() implies matches('^[^|# ]+$')`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Option<Uri>,
    /// Additional identifier for the actor definition (business identifier)
    ///
    /// A formal identifier that is used to identify this actor definition when it is
    /// represented in other formats, or referenced in a specification, model, design
    /// or an instance.
    ///
    /// ## Requirements
    /// Allows externally provided and/or usable business identifiers to be easily
    /// associated with the module.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Business version of the actor definition
    ///
    /// The identifier that is used to identify this version of the actor definition
    /// when it is referenced in a specification, model, design or instance. This is
    /// an arbitrary value managed by the actor definition author and is not expected
    /// to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd)
    /// if a managed version is not available. There is also no expectation that
    /// versions can be placed in a lexicographical sequence.
    ///
    /// ## Implementation Notes
    /// There may be different actor definition instances that have the same
    /// identifier but different versions. The version can be appended to the url in
    /// a reference to allow a reference to a particular business version of the
    /// actor definition with the format [url]|[version]. The version SHOULD NOT
    /// contain a '#' - see [Business Version](resource.html#bv-format).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub version: Option<String>,
    /// How to compare versions
    ///
    /// Indicates the mechanism used to compare versions to determine which is more
    /// current.
    ///
    /// ## Implementation Notes
    /// If set as a string, this is a FHIRPath expression that has two additional
    /// context variables passed in - %version1 and %version2 and will return a
    /// negative number if version1 is newer, a positive number if version2 and a 0
    /// if the version ordering can't be successfully be determined.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/version-algorithm
    #[fhir_serde(flatten)]
    pub version_algorithm: Option<ActorDefinitionVersionAlgorithm>,
    /// Name for this actor definition (computer friendly)
    ///
    /// A natural language name identifying the actor definition. This name should be
    /// usable as an identifier for the module by machine processing applications
    /// such as code generation.
    ///
    /// ## Requirements
    /// Support human navigation and code generation.
    ///
    /// ## Implementation Notes
    /// The name is not expected to be globally unique. The name should be a simple
    /// alphanumeric type name to ensure that it is machine-processing friendly.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cnl-0
    pub name: Option<String>,
    /// Name for this actor definition (human friendly)
    ///
    /// A short, descriptive, user-friendly title for the actor definition.
    ///
    /// ## Implementation Notes
    /// This name does not need to be machine-processing friendly and may contain
    /// punctuation, white-space, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// draft | active | retired | unknown
    ///
    /// The status of this actor definition. Enables tracking the life-cycle of the
    /// content.
    ///
    /// ## Implementation Notes
    /// Allows filtering of actor definitions that are appropriate for use versus
    /// not.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This is labeled as "Is Modifier" because designs and applications should not use a retired ActorDefinition without due consideration
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|6.0.0-ballot3
    pub status: Code,
    /// For testing only - never for real usage
    ///
    /// A Boolean value to indicate that this actor definition is authored for
    /// testing purposes (or education/evaluation/marketing) and no version of this
    /// resource will ever be intended for genuine usage.
    ///
    /// ## Requirements
    /// Enables experimental content to be developed following the same lifecycle
    /// that would be used for a production-level actor definition.
    ///
    /// ## Implementation Notes
    /// Allows filtering of actor definitions that are appropriate for use versus
    /// not.. Experimental resources might include example instances in
    /// implementation guides, instances created solely for testing purposes, etc. If
    /// experimental is 'true' for any version of a resource, it should be true for
    /// all versions of the resource. (If experimental changes, then it is being
    /// misused or a resource that was never intended for real-world use has
    /// unexpectedly changed its purpose.).
    ///
    /// Experimental resources are not expected to be stable and may well have
    /// breaking changes without a corresponding change to the 'version' element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    /// - When missing: If absent, this resource is treated as though it is not experimental.
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub experimental: Option<Boolean>,
    /// Date last changed
    ///
    /// The date (and optionally time) when the actor definition was last
    /// significantly changed. The date must change when the business version changes
    /// and it must change if the status code changes. In addition, it should change
    /// when the substantive content of the actor definition changes.
    ///
    /// ## Implementation Notes
    /// The date is often not tracked until the resource is published, but may be
    /// present on draft content. Note that this is not the same as the resource
    /// last-modified-date, since the resource may be a secondary representation of
    /// the actor definition. Additional specific dates may be added as extensions or
    /// be found by consulting Provenances associated with past versions of the
    /// resource.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Revision Date
    pub date: Option<DateTime>,
    /// Name of the publisher/steward (organization or individual)
    ///
    /// The name of the organization or individual responsible for the release and
    /// ongoing maintenance of the actor definition.
    ///
    /// ## Requirements
    /// Helps establish the "authority/credibility" of the actor definition. May also
    /// allow for contact.
    ///
    /// ## Implementation Notes
    /// Usually an organization but may be an individual. The publisher (or steward)
    /// of the actor definition is the organization or individual primarily
    /// responsible for the maintenance and upkeep of the actor definition. This is
    /// not necessarily the same individual or organization that developed and
    /// initially authored the content. The publisher is the primary point of contact
    /// for questions or issues with the actor definition. This item SHOULD be
    /// populated unless the information is available from context.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub publisher: Option<String>,
    /// Contact details for the publisher
    ///
    /// Contact details to assist a user in finding and communicating with the
    /// publisher.
    ///
    /// ## Implementation Notes
    /// May be a web site, an email address, a telephone number, etc.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contact: Option<Vec<ContactDetail>>,
    /// Natural language description of the actor
    ///
    /// A free text natural language description of the actor.
    ///
    /// ## Implementation Notes
    /// This description can be used for a general description of the actor, and
    /// which covers why it was defined.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Scope, Purpose
    pub description: Option<Markdown>,
    /// The context that the content is intended to support
    ///
    /// The content was developed with a focus and intent of supporting the contexts
    /// that are listed. These contexts may be general categories (gender, age, ...)
    /// or may be references to specific programs (insurance plans, studies, ...) and
    /// may be used to assist with indexing and searching for appropriate actor
    /// definition instances.
    ///
    /// ## Requirements
    /// Assist in searching for appropriate content.
    ///
    /// ## Implementation Notes
    /// When multiple useContexts are specified, there is no expectation that all or
    /// any of the contexts apply.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "useContext")]
    pub use_context: Option<Vec<UsageContext>>,
    /// Jurisdiction of the authority that maintains the actor definition (if applicable)
    ///
    /// A legal or geographic region in which the authority that maintains the
    /// resource is operating. In general, the jurisdiction is also found in the
    /// useContext. The useContext may reference additional jurisdictions because the
    /// defining jurisdiction does not necessarily limit the jurisdictions of use.
    ///
    /// ## Implementation Notes
    /// It may be possible for the actor definition to be used in jurisdictions other
    /// than those for which it was originally designed or intended.
    ///
    /// DEPRECATION NOTE: For consistency, implementations are encouraged to migrate
    /// to using the new 'jurisdiction' code in the useContext element. (I.e.
    /// useContext.code indicating
    /// http://terminology.hl7.org/CodeSystem/usage-context-type#jurisdiction and
    /// useContext.valueCodeableConcept indicating the jurisdiction.)
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Countries and regions within which this artifact is targeted for use.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/jurisdiction
    pub jurisdiction: Option<Vec<CodeableConcept>>,
    /// Why this actor definition is defined
    ///
    /// Explanation of why this actor definition is needed and why it has been
    /// designed as it has.
    ///
    /// ## Implementation Notes
    /// This element does not describe the usage of the actor definition. Instead, it
    /// provides traceability of ''why'' the resource is either needed or ''why'' it
    /// is defined as it is. This may be used to point to source materials or
    /// specifications that drove the structure of this actor definition.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub purpose: Option<Markdown>,
    /// Use and/or publishing restrictions
    ///
    /// A copyright statement relating to the actor definition and/or its contents.
    /// Copyright statements are generally legal restrictions on the use and
    /// publishing of the actor definition.
    ///
    /// ## Requirements
    /// Consumers must be able to determine any legal restrictions on the use of the
    /// actor definition.
    ///
    /// ## Implementation Notes
    /// ...
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// License, Restrictions
    pub copyright: Option<Markdown>,
    /// Copyright holder and year(s)
    ///
    /// A short string (<50 characters), suitable for inclusion in a page footer that
    /// identifies the copyright holder, effective period, and optionally whether
    /// rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').
    ///
    /// ## Requirements
    /// Defines the content expected to be rendered in all representations of the
    /// artifact.
    ///
    /// ## Implementation Notes
    /// The (c) symbol should NOT be included in this string. It will be added by
    /// software when rendering the notation. Full details about licensing,
    /// restrictions, warrantees, etc. goes in the more general 'copyright' element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "copyrightLabel")]
    pub copyright_label: Option<String>,
    /// system | non-system | individual | patient | practitioner | related-person | device | collective | care-team | group | healthcare-service | organization
    ///
    /// Whether the actor represents a human or an appliction.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The type of actor - system or human.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/actordefinition-actor-type|6.0.0-ballot3
    #[fhir_serde(rename = "type")]
    pub r#type: Code,
    /// Explanation and details about the actor
    ///
    /// Details describing the nature of the actor as well as boundaries that
    /// distinguish this type of actor from other actors.
    ///
    /// ## Implementation Notes
    /// The description describes what the actor is, and this element describes what
    /// the actor does (or is expected to do).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
    /// Reference to more information about the actor
    ///
    /// A reference to additional documentation about the actor, but description and
    /// documentation.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub reference: Option<Vec<Url>>,
    /// Parent actor definition
    ///
    /// An ActorDefinition that is a super-type of this actor. This actor inherits
    /// all of the obligations that apply to the referenced actor definition and can
    /// be used wherever the referenced ActorDefinition can.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "baseDefinition")]
    pub base_definition: Option<Vec<Canonical>>,
}

/// A species for which this route applies
///
/// A species for which this route applies.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AdministrableProductDefinitionRouteOfAdministrationTargetSpecies {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Coded expression for the species
    ///
    /// Coded expression for the species.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A tissue type of an animal.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/target-species
    pub code: CodeableConcept,
    /// A species specific time during which consumption of animal product is not appropriate
    ///
    /// A species specific time during which consumption of animal product is not
    /// appropriate.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "withdrawalPeriod")]
    pub withdrawal_period: Option<
        Vec<AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriod>,
    >,
}

/// A species specific time during which consumption of animal product is not appropriate
///
/// A species specific time during which consumption of animal product is not
/// appropriate.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriod {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// The type of tissue for which the withdrawal period applies, e.g. meat, milk
    ///
    /// Coded expression for the type of tissue for which the withdrawal period
    /// applies, e.g. meat, milk.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A tissue type of an animal.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/animal-tissue-type
    pub tissue: CodeableConcept,
    /// A value for the time
    ///
    /// A value for the time.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub value: Quantity,
    /// Extra information about the withdrawal period
    ///
    /// Extra information about the withdrawal period.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportingInformation")]
    pub supporting_information: Option<String>,
}

/// Choice of types for the value\[x\] field in AdministrableProductDefinitionProperty
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "value")]
pub enum AdministrableProductDefinitionPropertyValue {
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "valueCodeableConcept")]
    CodeableConcept(CodeableConcept),
    /// Variant accepting the Quantity type.
    #[fhir_serde(rename = "valueQuantity")]
    Quantity(Quantity),
    /// Variant accepting the Date type.
    #[fhir_serde(rename = "valueDate")]
    Date(Date),
    /// Variant accepting the Boolean type.
    #[fhir_serde(rename = "valueBoolean")]
    Boolean(Boolean),
    /// Variant accepting the Markdown type.
    #[fhir_serde(rename = "valueMarkdown")]
    Markdown(Markdown),
    /// Variant accepting the Attachment type.
    #[fhir_serde(rename = "valueAttachment")]
    Attachment(Attachment),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "valueReference")]
    Reference(Reference),
}

/// Characteristics e.g. a product's onset of action
///
/// Characteristics e.g. a product's onset of action.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "value")]
pub struct AdministrableProductDefinitionProperty {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// A code expressing the type of characteristic
    ///
    /// A code expressing the type of characteristic.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: This value set includes all observable entity codes from SNOMED CT - provided as an exemplar value set.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/product-characteristic-codes
    #[fhir_serde(rename = "type")]
    pub r#type: CodeableConcept,
    /// A value for the characteristic
    ///
    /// A value for the characteristic.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub value: Option<AdministrableProductDefinitionPropertyValue>,
    /// The status of characteristic e.g. assigned or pending
    ///
    /// The status of characteristic e.g. assigned or pending.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|6.0.0-ballot3
    pub status: Option<CodeableConcept>,
}

/// The path by which the product is taken into or makes contact with the body
///
/// The path by which the product is taken into or makes contact with the body.
/// In some regions this is referred to as the licensed or approved route.
/// RouteOfAdministration cannot be used when the 'formOf' product already uses
/// MedicinalProductDefinition.route (and vice versa).
///
/// ## Cardinality: Required, Multiple (1..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AdministrableProductDefinitionRouteOfAdministration {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Coded expression for the route
    ///
    /// Coded expression for the route.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A code specifying the route or physiological path of administration of a therapeutic agent into or onto a patient's body.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/route-codes
    pub code: CodeableConcept,
    /// The first dose (dose quantity) administered can be specified for the product
    ///
    /// The first dose (dose quantity) administered can be specified for the product,
    /// using a numerical value and its unit of measurement.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "firstDose")]
    pub first_dose: Option<Quantity>,
    /// The maximum single dose that can be administered
    ///
    /// The maximum single dose that can be administered, specified using a numerical
    /// value and its unit of measurement.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "maxSingleDose")]
    pub max_single_dose: Option<Quantity>,
    /// The maximum dose quantity to be administered in any one 24-h period
    ///
    /// The maximum dose per day (maximum dose quantity to be administered in any one
    /// 24-h period) that can be administered.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "maxDosePerDay")]
    pub max_dose_per_day: Option<Quantity>,
    /// The maximum dose per treatment period that can be administered
    ///
    /// The maximum dose per treatment period that can be administered.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "maxDosePerTreatmentPeriod")]
    pub max_dose_per_treatment_period: Option<Ratio>,
    /// The maximum treatment period during which the product can be administered
    ///
    /// The maximum treatment period during which the product can be administered.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "maxTreatmentPeriod")]
    pub max_treatment_period: Option<Duration>,
    /// A species for which this route applies
    ///
    /// A species for which this route applies.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "targetSpecies")]
    pub target_species:
        Option<Vec<AdministrableProductDefinitionRouteOfAdministrationTargetSpecies>>,
}

/// FHIR AdministrableProductDefinition type
///
/// A medicinal product in the final form which is suitable for administering to
/// a patient (after any mixing of multiple components, dissolution etc. has been
/// performed).
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [AdministrableProductDefinition](http://hl7.org/fhir/StructureDefinition/AdministrableProductDefinition)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AdministrableProductDefinition {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// An identifier for the administrable product
    ///
    /// An identifier for the administrable product.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// draft | active | retired | unknown
    ///
    /// The status of this administrable product. Enables tracking the life-cycle of
    /// the content.
    ///
    /// ## Implementation Notes
    /// Allows filtering of administrable products that are appropriate for use
    /// versus not.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This is labeled as "Is Modifier" because applications should not use a retired {{title}} without due consideration
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|6.0.0-ballot3
    pub status: Code,
    /// References a product from which one or more of the constituent parts of that product can be prepared and used as described by this administrable product
    ///
    /// References a product from which one or more of the constituent parts of that
    /// product can be prepared and used as described by this administrable product.
    /// If this administrable product describes the administration of a crushed
    /// tablet, the 'formOf' would be the product representing a distribution
    /// containing tablets and possibly also a cream. This is distinct from the
    /// 'producedFrom' which refers to the specific components of the product that
    /// are used in this preparation, rather than the product as a whole.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: apd-1
    #[fhir_serde(rename = "formOf")]
    pub form_of: Option<Vec<Reference>>,
    /// The dose form of the final product after necessary reconstitution or processing
    ///
    /// The dose form of the final product after necessary reconstitution or
    /// processing. Contrasts to the manufactured dose form (see
    /// ManufacturedItemDefinition). If the manufactured form was 'powder for
    /// solution for injection', the administrable dose form could be 'solution for
    /// injection' (once mixed with another item having manufactured form 'solvent
    /// for solution for injection').
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Dose form for a medication, in the form suitable for administering to the patient, after mixing, where necessary.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/administrable-dose-form
    #[fhir_serde(rename = "administrableDoseForm")]
    pub administrable_dose_form: Option<CodeableConcept>,
    /// The presentation type in which this item is given to a patient. e.g. for a spray - 'puff'
    ///
    /// The presentation type in which this item is given to a patient. e.g. for a
    /// spray - 'puff' (as in 'contains 100 mcg per puff'), or for a liquid - 'vial'
    /// (as in 'contains 5 ml per vial').
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The presentation type in which an administrable medicinal product is given to a patient.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/unit-of-presentation
    #[fhir_serde(rename = "unitOfPresentation")]
    pub unit_of_presentation: Option<CodeableConcept>,
    /// Indicates the specific manufactured items that are part of the 'formOf' product that are used in the preparation of this specific administrable form
    ///
    /// Indicates the specific manufactured items that are part of the 'formOf'
    /// product that are used in the preparation of this specific administrable form.
    /// In some cases, an administrable form might use all of the items from the
    /// overall product (or there might only be one item), while in other cases, an
    /// administrable form might use only a subset of the items available in the
    /// overall product. For example, an administrable form might involve combining a
    /// liquid and a powder available as part of an overall product, but not involve
    /// applying the also supplied cream.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "producedFrom")]
    pub produced_from: Option<Vec<Reference>>,
    /// The ingredients of this administrable medicinal product. This is only needed if the ingredients are not specified either using ManufacturedItemDefinition, or using incoming references from the Ingredient resource
    ///
    /// The ingredients of this administrable medicinal product. This is only needed
    /// if the ingredients are not specified either using ManufacturedItemDefinition
    /// (via AdministrableProductDefinition.producedFrom) to state which component
    /// items are used to make this, or using by incoming references from the
    /// Ingredient resource, to state in detail which substances exist within this.
    /// This element allows a basic coded ingredient to be used.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: This value set includes all substance codes from SNOMED CT - provided as an exemplar value set.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/substance-codes
    pub ingredient: Option<Vec<CodeableConcept>>,
    /// A device that is integral to the medicinal product, in effect being considered as an "ingredient" of the medicinal product
    ///
    /// A device that is integral to the medicinal product, in effect being
    /// considered as an "ingredient" of the medicinal product. This is not intended
    /// for devices that are just co-packaged.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub device: Option<Reference>,
    /// A general description of the product, when in its final form, suitable for administration e.g. effervescent blue liquid, to be swallowed
    ///
    /// A general description of the product, when in its final form, suitable for
    /// administration e.g. effervescent blue liquid, to be swallowed. Intended to be
    /// used when the other structured properties of this resource are insufficient
    /// or cannot be supported. It is not intended to duplicate information already
    /// carried elsewhere.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<Markdown>,
    /// Characteristics e.g. a product's onset of action
    ///
    /// Characteristics e.g. a product's onset of action.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub property: Option<Vec<AdministrableProductDefinitionProperty>>,
    /// The path by which the product is taken into or makes contact with the body
    ///
    /// The path by which the product is taken into or makes contact with the body.
    /// In some regions this is referred to as the licensed or approved route.
    /// RouteOfAdministration cannot be used when the 'formOf' product already uses
    /// MedicinalProductDefinition.route (and vice versa).
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "routeOfAdministration")]
    pub route_of_administration: Option<Vec<AdministrableProductDefinitionRouteOfAdministration>>,
}

/// Information on the possible cause of the event
///
/// Information on the possible cause of the event.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AdverseEventSuspectEntityCausality {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Method of evaluating the relatedness of the suspected entity to the event
    ///
    /// The method of evaluating the relatedness of the suspected entity to the
    /// event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: TODO.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-causality-method
    #[fhir_serde(rename = "assessmentMethod")]
    pub assessment_method: Option<CodeableConcept>,
    /// Result of the assessment regarding the relatedness of the suspected entity to the event
    ///
    /// The result of the assessment regarding the relatedness of the suspected
    /// entity to the event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes for the assessment of whether the entity caused the event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-causality-assess
    #[fhir_serde(rename = "entityRelatedness")]
    pub entity_relatedness: Option<CodeableConcept>,
    /// Author of the information on the possible cause of the event
    ///
    /// The author of the information on the possible cause of the event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub author: Option<Reference>,
}

/// Choice of types for the occurrence\[x\] field in AdverseEventSuspectEntity
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "occurrence")]
pub enum AdverseEventSuspectEntityOccurrence {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "occurrenceDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "occurrencePeriod")]
    Period(Period),
}

/// The suspected agent causing the adverse event
///
/// Describes the entity that is suspected to have caused the adverse event.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "occurrence")]
pub struct AdverseEventSuspectEntity {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Refers to the specific entity that caused the adverse event
    ///
    /// Identifies the actual instance of what caused the adverse event. May be a
    /// substance, medication, medication administration, medication statement or a
    /// device.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub instance: CodeableReference,
    /// Information on the possible cause of the event
    ///
    /// Information on the possible cause of the event.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub causality: Option<AdverseEventSuspectEntityCausality>,
    /// When the suspect entity occurred
    ///
    /// The date (and perhaps time) when the suspect entity occurred.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub occurrence: Option<AdverseEventSuspectEntityOccurrence>,
}

/// Choice of types for the effect\[x\] field in AdverseEvent
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "effect")]
pub enum AdverseEventEffect {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "effectDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "effectPeriod")]
    Period(Period),
}

/// FHIR AdverseEvent type
///
/// An event (i.e. any change to current patient status) that may be related to
/// unintended effects on a patient or research participant. The unintended
/// effects may require additional monitoring, treatment, hospitalization, or may
/// result in death. The AdverseEvent resource also extends to potential or
/// avoided events that could have had such effects. There are two major domains
/// where the AdverseEvent resource is expected to be used. One is in clinical
/// care reported adverse events and the other is in reporting adverse events in
/// clinical research trial management. Adverse events can be reported by
/// healthcare providers, patients, caregivers or by medical products
/// manufacturers. Given the differences between these two concepts, we recommend
/// consulting the domain specific implementation guides when implementing the
/// AdverseEvent Resource. The implementation guides include specific extensions,
/// value sets and constraints.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [AdverseEvent](http://hl7.org/fhir/StructureDefinition/AdverseEvent)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "effect")]
pub struct AdverseEvent {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Business identifier for the event
    ///
    /// Business identifiers assigned to this adverse event by the performer or other
    /// systems which remain constant as the resource is updated and propagates from
    /// server to server.
    ///
    /// ## Requirements
    /// Allows identification of the adverse event as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Implementation Notes
    /// This is a business identifier, not a resource identifier (see
    /// [discussion](resource.html#identifiers)). It is best practice for the
    /// identifier to only appear on a single resource instance, however business
    /// practices may occasionally dictate that multiple resource instances with the
    /// same identifier can exist - possibly even with different resource types. For
    /// example, multiple Patient and a Person resource instance might share the same
    /// social insurance number.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// in-progress | completed | entered-in-error | unknown
    ///
    /// The current state of the adverse event or potential adverse event.
    ///
    /// ## Implementation Notes
    /// This is not the reporting of the event to any regulatory or quality
    /// organization. This is not the outcome of the patient's condition. The adverse
    /// event status may be determined by the timing of the clinical trial
    /// assessments and is not necessarily the same as the condition status.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Codes identifying the lifecycle stage of an event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-status|6.0.0-ballot3
    pub status: Code,
    /// actual | potential
    ///
    /// Whether the event actually happened or was a near miss. Note that this is
    /// independent of whether anyone was affected or harmed or how severely.
    ///
    /// ## Implementation Notes
    /// AllergyIntolerance should be used for the initial capture or recording of the
    /// individual's propensity to an adverse reaction to a substance. If an
    /// AllergyIntolerance does not exist, then an adverse reaction should be
    /// recorded as an AllergyIntolerance. If an AllergyIntolerance does exist and
    /// the substance was given, then an adverse reaction should be recorded as an
    /// AdverseEvent due to the aberrant workflow.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because it has a potential code that indicates the adverse event did not actually happen.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Overall nature of the adverse event, e.g. real or potential.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-actuality|6.0.0-ballot3
    pub actuality: Code,
    /// wrong-patient | procedure-mishap | medication-mishap | device | unsafe-physical-environment | hospital-aquired-infection | wrong-body-site
    ///
    /// The overall type of event, intended for search and filtering purposes.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Overall categorization of the event, e.g. product-related or situational.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-category
    pub category: Option<Vec<CodeableConcept>>,
    /// Event or incident that occurred or was averted
    ///
    /// Specific event that occurred or that was averted, such as patient fall, wrong
    /// organ removed, or wrong blood transfused.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Detailed type of event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-type
    pub code: Option<CodeableConcept>,
    /// Subject impacted by event
    ///
    /// This subject or group impacted by the event.
    ///
    /// ## Requirements
    /// Allows for exposure of biohazard (such as legionella) to a group of
    /// individuals in a hospital.
    ///
    /// ## Implementation Notes
    /// If AdverseEvent.resultingEffect differs among members of the group, then use
    /// Patient as the subject.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// patient
    pub subject: Reference,
    /// The Encounter associated with the start of the AdverseEvent
    ///
    /// The Encounter associated with the start of the AdverseEvent.
    ///
    /// ## Implementation Notes
    /// This will typically be the encounter the event occurred within, but some
    /// activities may be initiated prior to or after the official completion of an
    /// encounter but still be tied to the context of the encounter. For example, if
    /// a medication administration was considered an adverse event because it
    /// resulted in a rash, then the encounter when the medication administration was
    /// given is the associated encounter. If the patient reports the AdverseEvent
    /// during a second encounter, that second encounter is not the associated
    /// encounter.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Reference>,
    /// When the effect of the AdverseEvent occurred
    ///
    /// The date (and perhaps time) when the effect of the AdverseEvent occurred.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub effect: Option<AdverseEventEffect>,
    /// When the event was detected
    ///
    /// Estimated or actual date the AdverseEvent began, in the opinion of the
    /// reporter.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub detected: Option<DateTime>,
    /// When the event was recorded
    ///
    /// The date on which the existence of the AdverseEvent was first recorded.
    ///
    /// ## Implementation Notes
    /// The recordedDate represents the date when this particular AdverseEvent record
    /// was created in the system, not the date of the most recent update. The date
    /// of the last record modification can be retrieved from the resource metadata.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "recordedDate")]
    pub recorded_date: Option<DateTime>,
    /// Effect on the subject due to this event
    ///
    /// Information about the condition that occurred as a result of the adverse
    /// event, such as hives due to the exposure to a substance (for example, a drug
    /// or a chemical) or a broken leg as a result of the fall.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Indicates the effect on subject due to this adverse event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/clinical-findings
    #[fhir_serde(rename = "resultingEffect")]
    pub resulting_effect: Option<Vec<CodeableReference>>,
    /// Location where adverse event occurred
    ///
    /// The information about where the adverse event occurred.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub location: Option<Reference>,
    /// Seriousness or gravity of the event
    ///
    /// Assessment whether this event, or averted event, was of clinical importance.
    ///
    /// ## Implementation Notes
    /// Using an example, a rash can have an AdverseEvent.resultingEffect.severity =
    /// severe, yet an AdverseEvent.seriousness = non-serious. Alternatively, a
    /// medication given with the wrong dose (chemotherapy given with too low of a
    /// dose) can have an AdverseEvent.resultingEffect.severity = mild, yet an
    /// adverseEvent.seriousness = serious. Another example would be a beta blocker
    /// clinical trial where patients with asthma should be excluded, yet a patient
    /// with asthma was included and had an asthmatic episode where
    /// AdverseEvent.resultingEffect.severity = mild, yet an adverseEvent.seriousness
    /// = serious.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Overall seriousness of this event for the patient.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-seriousness
    pub seriousness: Option<CodeableConcept>,
    /// Type of outcome from the adverse event
    ///
    /// Describes the type of outcome from the adverse event, such as resolved,
    /// recovering, ongoing, resolved-with-sequelae, or fatal.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing the type of outcome from the adverse event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-outcome
    pub outcome: Option<Vec<CodeableConcept>>,
    /// Who recorded the adverse event
    ///
    /// Information on who recorded the adverse event. May be the patient or a
    /// practitioner.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub recorder: Option<Reference>,
    /// Who was involved in the adverse event or the potential adverse event and what they did
    ///
    /// Indicates who or what participated in the adverse event and how they were
    /// involved.
    ///
    /// ## Implementation Notes
    /// The participant should not be used when there is another element to capture
    /// the participation, such as subject or recorder.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub participant: Option<Vec<AdverseEventParticipant>>,
    /// Research study that the subject is enrolled in
    ///
    /// The research study that the subject is enrolled in.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub study: Option<Vec<Reference>>,
    /// Considered likely or probable or anticipated in the research study
    ///
    /// Considered likely or probable or anticipated in the research study. Whether
    /// the reported event matches any of the outcomes for the patient that are
    /// considered by the study as known or likely.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "expectedInResearchStudy")]
    pub expected_in_research_study: Option<Boolean>,
    /// The suspected agent causing the adverse event
    ///
    /// Describes the entity that is suspected to have caused the adverse event.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "suspectEntity")]
    pub suspect_entity: Option<Vec<AdverseEventSuspectEntity>>,
    /// Contributing factors suspected to have increased the probability or severity of the adverse event
    ///
    /// The contributing factors suspected to have increased the probability or
    /// severity of the adverse event.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing the contributing factors suspected to have increased the probability or severity of the adverse event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-contributing-factor
    #[fhir_serde(rename = "contributingFactor")]
    pub contributing_factor: Option<Vec<CodeableReference>>,
    /// Preventive actions that contributed to avoiding the adverse event
    ///
    /// Preventive actions that contributed to avoiding the adverse event.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing the preventive actions that contributed to avoiding the adverse event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-preventive-action
    #[fhir_serde(rename = "preventiveAction")]
    pub preventive_action: Option<Vec<CodeableReference>>,
    /// Ameliorating actions taken after the adverse event occurred in order to reduce the extent of harm
    ///
    /// The ameliorating action taken after the adverse event occurred in order to
    /// reduce the extent of harm.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing the ameliorating actions taken after the adverse event occured in order to reduce the extent of harm.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-mitigating-action
    #[fhir_serde(rename = "mitigatingAction")]
    pub mitigating_action: Option<Vec<CodeableReference>>,
    /// Subject medical history or document relevant to this adverse event
    ///
    /// Relevant past history for the subject. In a clinical care context, an example
    /// being a patient had an adverse event following a penicillin administration
    /// and the patient had a previously documented penicillin allergy. In a clinical
    /// trials context, an example is a bunion or rash that was present prior to the
    /// study. Additionally, the supporting item can be a document that is relevant
    /// to this instance of the adverse event that is not part of the subject's
    /// medical history. For example, a clinical note, staff list, or material safety
    /// data sheet (MSDS). Supporting information is not a contributing factor,
    /// preventive action, or mitigating action.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing the supporting information relevant to the event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-supporting-info
    #[fhir_serde(rename = "supportingInfo")]
    pub supporting_info: Option<Vec<CodeableReference>>,
    /// Comment on adverse event
    ///
    /// Comments made about the adverse event by the performer, subject or other
    /// participants.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
}

/// Who was involved in the adverse event or the potential adverse event and what they did
///
/// Indicates who or what participated in the adverse event and how they were
/// involved.
///
/// ## Implementation Notes
/// The participant should not be used when there is another element to capture
/// the participation, such as subject or recorder.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AdverseEventParticipant {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Type of involvement
    ///
    /// Distinguishes the type of involvement of the actor in the adverse event, such
    /// as contributor or informant.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing the type of involvement of the actor in the adverse event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/adverse-event-participant-function
    pub function: Option<CodeableConcept>,
    /// Who was involved in the adverse event or the potential adverse event
    ///
    /// Indicates who or what participated in the event.
    ///
    /// ## Implementation Notes
    /// For example, the physician prescribing a drug, a nurse administering the
    /// drug, a device that administered the drug, a witness to the event, or an
    /// informant of clinical history. The subject can be a participant if the
    /// subject was involved in the adverse event in another capacity beyond just
    /// being the subject, such as when the subject is a contributor or informant.
    /// Using Group is only allowed when the group represents a family or a household
    /// and does not represent groups of Practitioners.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub actor: Reference,
}

/// Choice of types for the onset\[x\] field in AllergyIntolerance
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "onset")]
pub enum AllergyIntoleranceOnset {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "onsetDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Age type.
    #[fhir_serde(rename = "onsetAge")]
    Age(Age),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "onsetPeriod")]
    Period(Period),
    /// Variant accepting the Range type.
    #[fhir_serde(rename = "onsetRange")]
    Range(Range),
    /// Variant accepting the String type.
    #[fhir_serde(rename = "onsetString")]
    String(String),
}

/// FHIR AllergyIntolerance type
///
/// Risk of harmful or undesirable, physiological response which is unique to an
/// individual and associated with exposure to a substance.
///
/// ## Purpose
/// To record a clinical assessment of a propensity, or potential risk to an individual, of an adverse reaction upon future exposure to the specified substance, or class of substance.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [AllergyIntolerance](http://hl7.org/fhir/StructureDefinition/AllergyIntolerance)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "onset")]
pub struct AllergyIntolerance {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External ids for this item
    ///
    /// Business identifiers assigned to this AllergyIntolerance by the performer or
    /// other systems which remain constant as the resource is updated and propagates
    /// from server to server.
    ///
    /// ## Requirements
    /// Allows identification of the AllergyIntolerance as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Implementation Notes
    /// This is a business identifier, not a resource identifier (see
    /// [discussion](resource.html#identifiers)). It is best practice for the
    /// identifier to only appear on a single resource instance, however business
    /// practices may occasionally dictate that multiple resource instances with the
    /// same identifier can exist - possibly even with different resource types. For
    /// example, multiple Patient and a Person resource instance might share the same
    /// social insurance number.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// active | inactive | resolved
    ///
    /// The clinical status of the allergy or intolerance.
    ///
    /// ## Implementation Notes
    /// AllergyIntolerance.clinicalStatus should be present if verificationStatus is
    /// not entered-in-error and the AllergyIntolerance.code isn't negated (No Known
    /// Allergy, No Drug Allergy, No Food Allergy, No Latex Allergy).
    /// Refer to [discussion](extensibility.html#Special-Case) if clinicalStatus is
    /// missing data.
    /// The data type is CodeableConcept because clinicalStatus has some clinical
    /// judgment involved, such that there might need to be more specificity than the
    /// required FHIR value set allows. For example, a SNOMED coding might allow for
    /// additional specificity.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the status contains the codes inactive and resolved that mark the AllergyIntolerance as no longer active.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The clinical status of the allergy or intolerance.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergyintolerance-clinical|6.0.0-ballot3
    #[fhir_serde(rename = "clinicalStatus")]
    pub clinical_status: Option<CodeableConcept>,
    /// unconfirmed | presumed | confirmed | refuted | entered-in-error
    ///
    /// Assertion about certainty associated with the propensity, or potential risk,
    /// of a reaction to the identified substance (including pharmaceutical product).
    /// The verification status pertains to the allergy or intolerance, itself, not
    /// to any specific AllergyIntolerance attribute.
    ///
    /// ## Implementation Notes
    /// The data type is CodeableConcept because verificationStatus has some clinical
    /// judgment involved, such that there might need to be more specificity than the
    /// required FHIR value set allows. For example, a SNOMED coding might allow for
    /// additional specificity.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the status contains the codes refuted and entered-in-error that mark the AllergyIntolerance as not currently valid.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Assertion about certainty associated with a propensity, or potential risk, of a reaction to the identified substance.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergyintolerance-verification|6.0.0-ballot3
    #[fhir_serde(rename = "verificationStatus")]
    pub verification_status: Option<CodeableConcept>,
    /// allergy | intolerance - Underlying mechanism (if known)
    ///
    /// Identification of the underlying physiological mechanism for the reaction
    /// risk.
    ///
    /// ## Implementation Notes
    /// Allergic (typically immune-mediated) reactions have been traditionally
    /// regarded as an indicator for potential escalation to significant future risk.
    /// Contemporary knowledge suggests that some reactions previously thought to be
    /// immune-mediated are, in fact, non-immune, but in some cases can still pose a
    /// life threatening risk. It is acknowledged that many clinicians might not be
    /// in a position to distinguish the mechanism of a particular reaction. Often
    /// the term "allergy" is used rather generically and may overlap with the use of
    /// "intolerance" - in practice the boundaries between these two concepts might
    /// not be well-defined or understood. This data element is included
    /// nevertheless, because many legacy systems have captured this attribute.
    /// Immunologic testing may provide supporting evidence for the basis of the
    /// reaction and the causative substance, but no tests are 100% sensitive or
    /// specific for sensitivity to a particular substance. If, as is commonly the
    /// case, it is unclear whether the reaction is due to an allergy or an
    /// intolerance, then the type element should be omitted from the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: Identification of the underlying physiological mechanism for a Reaction Risk.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergy-intolerance-type
    ///
    /// ## Aliases
    /// Category, Class
    #[fhir_serde(rename = "type")]
    pub r#type: Option<CodeableConcept>,
    /// food | medication | environment | biologic
    ///
    /// Category of the identified substance.
    ///
    /// ## Implementation Notes
    /// This data element has been included because it is currently being captured in
    /// some clinical systems. This data can be derived from the substance where
    /// coding systems are used, and is effectively redundant in that situation. When
    /// searching on category, consider the implications of AllergyIntolerance
    /// resources without a category. For example, when searching on category =
    /// medication, medication allergies that don't have a category valued will not
    /// be returned. Refer to [search](search.html) for more information on how to
    /// search category with a :missing modifier to get allergies that don't have a
    /// category. Additionally, category should be used with caution because category
    /// can be subjective based on the sender.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Category of an identified substance associated with allergies or intolerances.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergy-intolerance-category|6.0.0-ballot3
    ///
    /// ## Aliases
    /// Category, Type, Reaction Type, Class
    pub category: Option<Vec<Code>>,
    /// low | high | unable-to-assess
    ///
    /// Estimate of the potential clinical harm, or seriousness, of the reaction to
    /// the identified substance.
    ///
    /// ## Implementation Notes
    /// The default criticality value for any propensity to an adverse reaction
    /// should be 'Low Risk', indicating at the very least a relative
    /// contraindication to deliberate or voluntary exposure to the substance. 'High
    /// Risk' is flagged if the clinician has identified a propensity for a more
    /// serious or potentially life-threatening reaction, such as anaphylaxis, and
    /// implies an absolute contraindication to deliberate or voluntary exposure to
    /// the substance. If this element is missing, the criticality is unknown (though
    /// it may be known elsewhere). Systems that capture a severity at the condition
    /// level are actually representing the concept of criticality whereas the
    /// severity documented at the reaction level is representing the true reaction
    /// severity. Existing systems that are capturing both condition criticality and
    /// reaction severity may use the term "severity" to represent both. Criticality
    /// is the worst it could be in the future (i.e. situation-agnostic) whereas
    /// severity is situation-dependent.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Estimate of the potential clinical harm, or seriousness, of a reaction to an identified substance.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergy-intolerance-criticality|6.0.0-ballot3
    ///
    /// ## Aliases
    /// Severity, Seriousness, Contra-indication, Risk
    pub criticality: Option<Code>,
    /// Code that identifies the allergy or intolerance
    ///
    /// Code for an allergy or intolerance statement (either a positive or a
    /// negated/excluded statement). This may be a code for a substance or
    /// pharmaceutical product that is considered to be responsible for the adverse
    /// reaction risk (e.g., "Latex"), an allergy or intolerance condition (e.g.,
    /// "Latex allergy"), or a negated/excluded code for a specific substance or
    /// class (e.g., "No latex allergy") or a general or categorical negated
    /// statement (e.g., "No known allergy", "No known drug allergies"). Note: the
    /// substance for a specific reaction may be different from the substance
    /// identified as the cause of the risk, but it must be consistent with it. For
    /// instance, it may be a more specific substance (e.g. a brand medication) or a
    /// composite product that includes the identified substance. It must be
    /// clinically safe to only process the 'code' and ignore the
    /// 'reaction.substance'. If a receiving system is unable to confirm that
    /// AllergyIntolerance.reaction.substance falls within the semantic scope of
    /// AllergyIntolerance.code, then the receiving system should ignore
    /// AllergyIntolerance.reaction.substance.
    ///
    /// ## Implementation Notes
    /// It is strongly recommended that this element be populated using a
    /// terminology, where possible. For example, some terminologies used include
    /// RxNorm, SNOMED CT, DM+D, NDFRT, ICD-9, IDC-10, UNII, and ATC. Plain text
    /// should only be used if there is no appropriate terminology available.
    /// Additional details can be specified in the text.
    ///
    /// When a substance or product code is specified for the 'code' element, the
    /// "default" semantic context is that this is a positive statement of an allergy
    /// or intolerance (depending on the value of the 'type' element, if present)
    /// condition to the specified substance/product. In the corresponding SNOMED CT
    /// allergy model, the specified substance/product is the target (destination) of
    /// the "Causative agent" relationship.
    ///
    /// The 'substanceExposureRisk' extension is available as a structured and more
    /// flexible alternative to the 'code' element for making positive or negative
    /// allergy or intolerance statements. This extension provides the capability to
    /// make "no known allergy" (or "no risk of adverse reaction") statements
    /// regarding any coded substance/product (including cases when a pre-coordinated
    /// "no allergy to x" concept for that substance/product does not exist). If the
    /// 'substanceExposureRisk' extension is present, the AllergyIntolerance.code
    /// element SHALL be omitted.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Type of the substance/product, allergy or intolerance condition, or negation/exclusion codes for reporting no known allergies.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/allergyintolerance-code
    ///
    /// ## Aliases
    /// Code
    pub code: Option<CodeableConcept>,
    /// Who the allergy or intolerance is for
    ///
    /// The patient who has the allergy or intolerance.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Patient
    pub patient: Reference,
    /// Encounter when the allergy or intolerance was asserted
    ///
    /// The encounter when the allergy or intolerance was asserted.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Reference>,
    /// When allergy or intolerance was identified
    ///
    /// Estimated or actual date, date-time, or age when allergy or intolerance was
    /// identified.
    ///
    /// ## Implementation Notes
    /// Age is generally used when the patient reports an age at which the
    /// AllergyIntolerance was noted. Period is generally used to convey an imprecise
    /// onset that occurred within the time period. Range is generally used to convey
    /// an imprecise age range (e.g. 4 to 6 years old).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub onset: Option<AllergyIntoleranceOnset>,
    /// Date allergy or intolerance was first recorded
    ///
    /// The recordedDate represents when this particular AllergyIntolerance record
    /// was created in the system, which is often a system-generated date.
    ///
    /// ## Implementation Notes
    /// When onset date is unknown, recordedDate can be used to establish if the
    /// allergy or intolerance was present on or before a given date. If the
    /// recordedDate is known and provided by a sending system, it is preferred that
    /// the receiving system preserve that recordedDate value. If the recordedDate is
    /// not provided by the sending system, the receipt timestamp is sometimes used
    /// as the recordedDate.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "recordedDate")]
    pub recorded_date: Option<DateTime>,
    /// Who recorded the sensitivity
    ///
    /// Individual who recorded the record and takes responsibility for its content.
    ///
    /// ## Implementation Notes
    /// Because the recorder takes responsibility for accurately recording
    /// information in the record, the recorder is the most recent author. The
    /// recorder might or might not be the asserter. By contrast, the recordedDate is
    /// when the allergy or intolerance was first recorded.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Author
    pub recorder: Option<Reference>,
    /// Source of the information about the allergy
    ///
    /// The source of the information about the allergy that is recorded.
    ///
    /// ## Implementation Notes
    /// The recorder takes responsibility for the content, but can reference the
    /// source from where they got it.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Source, Informant
    pub asserter: Option<Reference>,
    /// Date(/time) of last known occurrence of a reaction
    ///
    /// Represents the date and/or time of the last known occurrence of a reaction
    /// event.
    ///
    /// ## Implementation Notes
    /// This date may be replicated by one of the Onset of Reaction dates. Where a
    /// textual representation of the date of last occurrence is required e.g. 'In
    /// Childhood, '10 years ago' the AllergyIntolerance.note element should be used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastReactionOccurrence")]
    pub last_reaction_occurrence: Option<DateTime>,
    /// Additional text not captured in other fields
    ///
    /// Additional narrative about the propensity for the Adverse Reaction, not
    /// captured in other fields.
    ///
    /// ## Implementation Notes
    /// For example: including reason for flagging a seriousness of 'High Risk'; and
    /// instructions related to future exposure or administration of the substance,
    /// such as administration within an Intensive Care Unit or under corticosteroid
    /// cover. The notes should be related to an allergy or intolerance as a
    /// condition in general and not related to any particular episode of it. For
    /// episode notes and descriptions, use AllergyIntolerance.event.description and
    /// AllergyIntolerance.event.notes.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
    /// Adverse Reaction Events linked to exposure to substance
    ///
    /// Details about each adverse reaction event linked to exposure to the
    /// identified substance.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub reaction: Option<Vec<AllergyIntoleranceReaction>>,
}

/// Adverse Reaction Events linked to exposure to substance
///
/// Details about each adverse reaction event linked to exposure to the
/// identified substance.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AllergyIntoleranceReaction {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Specific substance or pharmaceutical product considered to be responsible for event
    ///
    /// Identification of the specific substance (or pharmaceutical product)
    /// considered to be responsible for the Adverse Reaction event. Note: the
    /// substance for a specific reaction may be different from the substance
    /// identified as the cause of the risk, but it must be consistent with it. For
    /// instance, it may be a more specific substance (e.g. a brand medication) or a
    /// composite product that includes the identified substance. It must be
    /// clinically safe to only process the 'code' and ignore the
    /// 'reaction.substance'. If a receiving system is unable to confirm that
    /// AllergyIntolerance.reaction.substance falls within the semantic scope of
    /// AllergyIntolerance.code, then the receiving system should ignore
    /// AllergyIntolerance.reaction.substance.
    ///
    /// ## Implementation Notes
    /// Coding of the specific substance (or pharmaceutical product) with a
    /// terminology capable of triggering decision support should be used wherever
    /// possible. The 'code' element allows for the use of a specific substance or
    /// pharmaceutical product, or a group or class of substances. In the case of an
    /// allergy or intolerance to a class of substances, (for example,
    /// "penicillins"), the 'reaction.substance' element could be used to code the
    /// specific substance that was identified as having caused the reaction (for
    /// example, "amoxycillin"). Duplication of the value in the 'code' and
    /// 'reaction.substance' elements is acceptable when a specific substance has
    /// been recorded in 'code'.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes defining the type of the substance (including pharmaceutical products).
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/substance-code
    pub substance: Option<CodeableConcept>,
    /// Clinical symptoms/signs associated with the Event
    ///
    /// Clinical symptoms and/or signs that are observed or associated with the
    /// adverse reaction event.
    ///
    /// ## Implementation Notes
    /// Manifestation can be expressed as a single word, phrase or brief description.
    /// For example: nausea, rash or no reaction. It is preferable that manifestation
    /// should be coded with a terminology, where possible. The values entered here
    /// may be used to display on an application screen as part of a list of adverse
    /// reactions, as recommended in the UK NHS CUI guidelines. Terminologies
    /// commonly used include, but are not limited to, SNOMED CT or ICD10.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Clinical symptoms and/or signs that are observed or associated with an Adverse Reaction Event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/clinical-findings
    ///
    /// ## Aliases
    /// Symptoms, Signs
    pub manifestation: Option<Vec<CodeableReference>>,
    /// Description of the event as a whole
    ///
    /// Text description about the reaction as a whole, including details of the
    /// manifestation if required.
    ///
    /// ## Implementation Notes
    /// Use the description to provide any details of a particular event of the
    /// occurred reaction such as circumstances, reaction specifics, what happened
    /// before/after. Information, related to the event, but not describing a
    /// particular care should be captured in the note field. For example: at the age
    /// of four, the patient was given penicillin for strep throat and subsequently
    /// developed severe hives.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Narrative, Text
    pub description: Option<String>,
    /// Date(/time) when manifestations showed
    ///
    /// Record of the date and/or time of the onset of the Reaction.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub onset: Option<DateTime>,
    /// mild | moderate | severe (of event as a whole)
    ///
    /// Clinical assessment of the severity of the reaction event as a whole,
    /// potentially considering multiple different manifestations.
    ///
    /// ## Implementation Notes
    /// It is acknowledged that this assessment is very subjective. There may be some
    /// specific practice domains where objective scales have been applied. Objective
    /// scales can be included in this model as extensions.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Clinical assessment of the severity of a reaction event as a whole, potentially considering multiple different manifestations.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/reaction-event-severity|6.0.0-ballot3
    pub severity: Option<Code>,
    /// How the subject was exposed to the substance
    ///
    /// Identification of the route by which the subject was exposed to the
    /// substance.
    ///
    /// ## Implementation Notes
    /// Coding of the route of exposure with a terminology should be used wherever
    /// possible.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A coded concept describing the route or physiological path of exposure to a substance.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/route-codes
    #[fhir_serde(rename = "exposureRoute")]
    pub exposure_route: Option<CodeableConcept>,
    /// Text about event not captured in other fields
    ///
    /// Additional text about the adverse reaction event not captured in other
    /// fields.
    ///
    /// ## Implementation Notes
    /// Use this field to record information indirectly related to a particular event
    /// and not captured in the description. For example: Clinical records are no
    /// longer available, recorded based on information provided to the patient by
    /// her mother and her mother is deceased.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
}

/// Details of the recurrence pattern/template used to generate occurrences
///
/// The details of the recurrence pattern or template that is used to generate
/// recurring appointments.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: app-6
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AppointmentRecurrenceTemplate {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// The timezone of the occurrences
    ///
    /// The timezone of the recurring appointment occurrences.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IANA Timezones (BCP 175)
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/timezones|6.0.0-ballot3
    pub timezone: Option<CodeableConcept>,
    /// The frequency of the recurrence
    ///
    /// How often the appointment series should recur.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: IANA Timezones (BCP 175)
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/appointment-recurrrence-type
    #[fhir_serde(rename = "recurrenceType")]
    pub recurrence_type: CodeableConcept,
    /// The date when the recurrence should end
    ///
    /// Recurring appointments will not occur after this date.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastOccurrenceDate")]
    pub last_occurrence_date: Option<Date>,
    /// The number of planned occurrences
    ///
    /// How many appointments are planned in the recurrence.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "occurrenceCount")]
    pub occurrence_count: Option<PositiveInt>,
    /// Specific dates for a recurring set of appointments (no template)
    ///
    /// The list of specific dates that will have appointments generated.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "occurrenceDate")]
    pub occurrence_date: Option<Vec<Date>>,
    /// Information about weekly recurring appointments
    ///
    /// Information about weekly recurring appointments.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "weeklyTemplate")]
    pub weekly_template: Option<AppointmentRecurrenceTemplateWeeklyTemplate>,
    /// Information about monthly recurring appointments
    ///
    /// Information about monthly recurring appointments.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "monthlyTemplate")]
    pub monthly_template: Option<AppointmentRecurrenceTemplateMonthlyTemplate>,
    /// Information about yearly recurring appointments
    ///
    /// Information about yearly recurring appointments.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "yearlyTemplate")]
    pub yearly_template: Option<AppointmentRecurrenceTemplateYearlyTemplate>,
    /// Any dates that should be excluded from the series
    ///
    /// Any dates, such as holidays, that should be excluded from the recurrence.
    ///
    /// ## Implementation Notes
    /// excludingDate is an alternative to excludingRecurrenceId. You may say either
    /// that 12/25/XXXX should be excluded using excludingDate, or you may indicate
    /// the recurrenceId of the appointment that would fall on the excluded date in
    /// the excludingRecurrenceId property.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "excludingDate")]
    pub excluding_date: Option<Vec<Date>>,
    /// Any recurrence IDs that should be excluded from the recurrence
    ///
    /// Any dates, such as holidays, that should be excluded from the recurrence.
    ///
    /// ## Implementation Notes
    /// excludingRecurrenceId is an alternative to excludingDate. You may say either
    /// that 12/25/XXXX should be excluded using excludingDate, or you may indicate
    /// the recurrenceId of the appointment that would fall on the excluded date in
    /// the excludingRecurrenceId property.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "excludingRecurrenceId")]
    pub excluding_recurrence_id: Option<Vec<PositiveInt>>,
}

/// Information about yearly recurring appointments
///
/// Information about yearly recurring appointments.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AppointmentRecurrenceTemplateYearlyTemplate {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Recurs every nth year
    ///
    /// Appointment recurs every nth year.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "yearInterval")]
    pub year_interval: PositiveInt,
}

/// Information about weekly recurring appointments
///
/// Information about weekly recurring appointments.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AppointmentRecurrenceTemplateWeeklyTemplate {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Recurs on Mondays
    ///
    /// Indicates that recurring appointments should occur on Mondays.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub monday: Option<Boolean>,
    /// Recurs on Tuesday
    ///
    /// Indicates that recurring appointments should occur on Tuesdays.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub tuesday: Option<Boolean>,
    /// Recurs on Wednesday
    ///
    /// Indicates that recurring appointments should occur on Wednesdays.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub wednesday: Option<Boolean>,
    /// Recurs on Thursday
    ///
    /// Indicates that recurring appointments should occur on Thursdays.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub thursday: Option<Boolean>,
    /// Recurs on Friday
    ///
    /// Indicates that recurring appointments should occur on Fridays.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub friday: Option<Boolean>,
    /// Recurs on Saturday
    ///
    /// Indicates that recurring appointments should occur on Saturdays.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub saturday: Option<Boolean>,
    /// Recurs on Sunday
    ///
    /// Indicates that recurring appointments should occur on Sundays.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub sunday: Option<Boolean>,
    /// Recurs every nth week
    ///
    /// The interval defines if the recurrence is every nth week. The default is
    /// every week, so it is expected that this value will be 2 or more.
    ///
    /// e.g. For recurring every second week this interval would be 2, or every third
    /// week the interval would be 3.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "weekInterval")]
    pub week_interval: Option<PositiveInt>,
}

/// Participants involved in appointment
///
/// List of participants involved in the appointment.
///
/// ## Cardinality: Required, Multiple (1..*)
///
/// ## Constraints
/// - **app-1**: Either the type or actor on the participant SHALL be specified (error)
///   Expression: `type.exists() or actor.exists()`
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AppointmentParticipant {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Role of participant in the appointment
    ///
    /// Role of participant in the appointment.
    ///
    /// ## Implementation Notes
    /// The role of the participant can be used to declare what the actor will be
    /// doing in the scope of this appointment.
    ///
    /// If the actor is not specified, then it is expected that the actor will be
    /// filled in at a later stage of planning.
    ///
    /// This value SHALL be the same when creating an AppointmentResponse so that
    /// they can be matched, and subsequently update the Appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Role of participant in encounter.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/encounter-participant-type
    ///
    /// ## Conditions
    /// Used when: app-1
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Vec<CodeableConcept>>,
    /// Participation period of the actor
    ///
    /// Participation period of the actor.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub period: Option<Period>,
    /// The individual, device, location, or service participating in the appointment
    ///
    /// The individual, device, location, or service participating in the
    /// appointment.
    ///
    /// ## Implementation Notes
    /// Where a CareTeam is provided, this does not imply that the entire team is
    /// included, just a single member from the group with the appropriate role.
    /// Where multiple members are required, please include the CareTeam the required
    /// number of times.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: app-1
    pub actor: Option<Reference>,
    /// The participant is required to attend (optional when false)
    ///
    /// Whether this participant is required to be present at the meeting. If false,
    /// the participant is optional.
    ///
    /// ## Implementation Notes
    /// For the use-case where two doctors need to meet to discuss the results for a
    /// specific patient, and the patient is not required to be present include the
    /// patient in the subject field, but do not include them as a participant - this
    /// was formerly done prior to R5 with required='information-only'.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub required: Option<Boolean>,
    /// accepted | declined | tentative | needs-action
    ///
    /// Participation status of the actor.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The Participation status of an appointment.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/participationstatus|6.0.0-ballot3
    pub status: Code,
}

/// Information about monthly recurring appointments
///
/// Information about monthly recurring appointments.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AppointmentRecurrenceTemplateMonthlyTemplate {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Recurs on a specific day of the month
    ///
    /// Indicates that appointments in the series of recurring appointments should
    /// occur on a specific day of the month.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "dayOfMonth")]
    pub day_of_month: Option<PositiveInt>,
    /// Indicates which week of the month the appointment should occur
    ///
    /// Indicates which week within a month the appointments in the series of
    /// recurring appointments should occur on.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The set of weeks in a month.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/week-of-month|6.0.0-ballot3
    #[fhir_serde(rename = "nthWeekOfMonth")]
    pub nth_week_of_month: Option<Coding>,
    /// Indicates which day of the week the appointment should occur
    ///
    /// Indicates which day of the week the recurring appointments should occur each
    /// nth week.
    ///
    /// ## Implementation Notes
    /// This property is intended to be used with
    /// Appointment.recurrenceTemplate.monthly.nthWeek.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The days of the week.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/days-of-week|6.0.0-ballot3
    #[fhir_serde(rename = "dayOfWeek")]
    pub day_of_week: Option<Coding>,
    /// Recurs every nth month
    ///
    /// Indicates that recurring appointments should occur every nth month.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "monthInterval")]
    pub month_interval: PositiveInt,
}

/// FHIR Appointment type
///
/// A booking of a healthcare event among patient(s), practitioner(s), related
/// person(s) and/or device(s) for a specific date/time. This may result in one
/// or more Encounter(s).
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [Appointment](http://hl7.org/fhir/StructureDefinition/Appointment)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Appointment {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External Ids for this item
    ///
    /// This records identifiers associated with this appointment concern that are
    /// defined by business processes and/or used to refer to it when a direct URL
    /// reference to the resource itself is not appropriate (e.g. in CDA documents,
    /// or in written / printed documentation).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// proposed | pending | booked | arrived | fulfilled | cancelled | noshow | entered-in-error | checked-in | waitlist
    ///
    /// The overall status of the Appointment. Each of the participants has their own
    /// participation status which indicates their involvement in the process,
    /// however this status indicates the shared status.
    ///
    /// ## Implementation Notes
    /// If the Appointment's status is "cancelled" then all participants are expected
    /// to have their calendars released for the appointment period, and as such any
    /// Slots that were marked as BUSY can be re-set to FREE.
    ///
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that mark the Appointment as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The free/busy status of an appointment.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/appointmentstatus|6.0.0-ballot3
    ///
    /// ## Conditions
    /// Used when: app-4, app-3, app-7
    pub status: Code,
    /// The coded reason for the appointment being cancelled
    ///
    /// The coded reason for the appointment being cancelled. This is often used in
    /// reporting/billing/further processing to determine if further actions are
    /// required, or specific fees apply.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/appointment-cancellation-reason
    ///
    /// ## Conditions
    /// Used when: app-4
    #[fhir_serde(rename = "cancellationReason")]
    pub cancellation_reason: Option<CodeableConcept>,
    /// Classification when becoming an encounter
    ///
    /// Concepts representing classification of patient encounter such as ambulatory
    /// (outpatient), inpatient, emergency, home health or others due to local
    /// variations.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: Classification of the encounter.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/EncounterClass
    pub class: Option<Vec<CodeableConcept>>,
    /// A broad categorization of the service that is to be performed during this appointment
    ///
    /// A broad categorization of the service that is to be performed during this
    /// appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-category
    #[fhir_serde(rename = "serviceCategory")]
    pub service_category: Option<Vec<CodeableConcept>>,
    /// The specific service that is to be performed during this appointment
    ///
    /// The specific service that is to be performed during this appointment.
    ///
    /// ## Implementation Notes
    /// For a provider to provider appointment the code "FOLLOWUP" may be
    /// appropriate, as this is expected to be discussing some patient that was seen
    /// in the past.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/service-type
    #[fhir_serde(rename = "serviceType")]
    pub service_type: Option<Vec<CodeableReference>>,
    /// The specialty of a practitioner that would be required to perform the service requested in this appointment
    ///
    /// The specialty of a practitioner that would be required to perform the service
    /// requested in this appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/c80-practice-codes
    pub specialty: Option<Vec<CodeableConcept>>,
    /// The style of appointment or patient that has been booked in the slot (not service type)
    ///
    /// The style of appointment or patient that has been booked in the slot (not
    /// service type).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/v2-0276
    #[fhir_serde(rename = "appointmentType")]
    pub appointment_type: Option<CodeableConcept>,
    /// Reason this appointment is scheduled
    ///
    /// The reason that this appointment is being scheduled. This is more clinical
    /// than administrative. This can be coded, or as specified using information
    /// from another resource. When the patient arrives and the encounter begins it
    /// may be used as the admission diagnosis. The indication will typically be a
    /// Condition (with other resources referenced in the evidence.detail), or a
    /// Procedure.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: The Reason for the appointment to take place.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/encounter-reason
    pub reason: Option<Vec<CodeableReference>>,
    /// Used to make informed decisions if needing to re-prioritize
    ///
    /// The priority of the appointment. Can be used to make informed decisions if
    /// needing to re-prioritize appointments. (The iCal Standard specifies 0 as
    /// undefined, 1 as highest, 9 as lowest priority).
    ///
    /// ## Implementation Notes
    /// Seeking implementer feedback on this property and how interoperable it is.
    ///
    /// Using an extension to record a CodeableConcept for named values may be tested
    /// at a future connectathon.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Indicates the urgency of the appointment.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/v3-ActPriority
    pub priority: Option<CodeableConcept>,
    /// Shown on a subject line in a meeting request, or appointment list
    ///
    /// The brief description of the appointment as would be shown on a subject line
    /// in a meeting request, or appointment list. Detailed or expanded information
    /// should be put in the note field.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Appointment replaced by this Appointment
    ///
    /// Appointment replaced by this Appointment in cases where there is a
    /// cancellation, the details of the cancellation can be found in the
    /// cancellationReason property (on the referenced resource).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub replaces: Option<Vec<Reference>>,
    /// Connection details of a virtual service (e.g. conference call)
    ///
    /// Connection details of a virtual service (e.g. conference call).
    ///
    /// ## Implementation Notes
    /// There are two types of virtual meetings that often exist:
    ///
    /// * a persistent, virtual meeting room that can only be used for a single
    ///   purpose at a time,
    /// * and a dynamic virtual meeting room that is generated on demand for a
    ///   specific purpose.
    ///
    /// Implementers may consider using Location.virtualService for persistent
    /// meeting rooms.
    ///
    /// If each participant would have a different meeting link, an extension using
    /// the VirtualServiceContactDetail can be applied to the Appointment.participant
    /// BackboneElement.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "virtualService")]
    pub virtual_service: Option<Vec<VirtualServiceDetail>>,
    /// Additional information to support the appointment
    ///
    /// Additional information to support the appointment provided when making the
    /// appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportingInformation")]
    pub supporting_information: Option<Vec<Reference>>,
    /// The previous appointment in a series
    ///
    /// The previous appointment in a series of related appointments.
    ///
    /// ## Implementation Notes
    /// This property is intended for use when representing a series of related
    /// appointments. For example, in a nuclear medicine procedure, where there is an
    /// appointment for the injection of the isotopes, and then a subsequent
    /// appointment for the scan, the scan appointment would refer to the injection
    /// appointment via Appointment.previousAppointment. For representing recurring
    /// appointments, see the guidance on recurring vs. series appointments.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "previousAppointment")]
    pub previous_appointment: Option<Reference>,
    /// The originating appointment in a recurring set of appointments
    ///
    /// The originating appointment in a recurring set of related appointments.
    ///
    /// ## Implementation Notes
    /// This property is intended for use when representing a recurring set of
    /// related appointments.
    ///
    /// For example, a patient undergoing physical therapy may have a recurring
    /// appointment every Tuesday and Thursday. Each occurrence of the set will refer
    /// to the originating appointment, which contains the recurring template
    /// information. For representing appointment series, see the guidance on
    /// recurring vs. series appointments.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: app-6
    #[fhir_serde(rename = "originatingAppointment")]
    pub originating_appointment: Option<Reference>,
    /// When appointment is to take place
    ///
    /// Date/Time that the appointment is to take place.
    ///
    /// ## Implementation Notes
    /// If actual start/end times are not known then the requested period start/end
    /// can be used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: app-5, app-3, app-2
    pub start: Option<Instant>,
    /// When appointment is to conclude
    ///
    /// Date/Time that the appointment is to conclude.
    ///
    /// ## Implementation Notes
    /// If actual start/end times are not known then the requested period start/end
    /// can be used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: app-5, app-3, app-2
    pub end: Option<Instant>,
    /// Can be less than start/end (e.g. estimate)
    ///
    /// Number of minutes that the appointment is to take. This can be less than the
    /// duration between the start and end times. For example, where the actual time
    /// of appointment is only an estimate or if a 30 minute appointment is being
    /// requested, but any time would work. Also, if there is, for example, a planned
    /// 15 minute break in the middle of a long appointment, the duration may be 15
    /// minutes less than the difference between the start and end.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "minutesDuration")]
    pub minutes_duration: Option<PositiveInt>,
    /// Potential date/time interval(s) requested to allocate the appointment within
    ///
    /// A set of date ranges (potentially including times) that the appointment is
    /// preferred to be scheduled within.
    ///
    /// The duration (usually in minutes) could also be provided to indicate the
    /// length of the appointment to fill and populate the start/end times for the
    /// actual allocated time. However, in other situations the duration may be
    /// calculated by the scheduling system.
    ///
    /// ## Implementation Notes
    /// This does not introduce a capacity for recurring appointments.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "requestedPeriod")]
    pub requested_period: Option<Vec<Period>>,
    /// The slots that this appointment is filling
    ///
    /// The slots from the participants' schedules that will be filled by the
    /// appointment.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub slot: Option<Vec<Reference>>,
    /// The set of accounts that may be used for billing for this Appointment
    ///
    /// The set of accounts that is expected to be used for billing the activities
    /// that result from this Appointment.
    ///
    /// ## Implementation Notes
    /// The specified account(s) could be those identified during pre-registration
    /// workflows in preparation for an upcoming Encounter.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub account: Option<Vec<Reference>>,
    /// The date that this appointment was initially created
    ///
    /// The date that this appointment was initially created. This could be different
    /// to the meta.lastModified value on the initial entry, as this could have been
    /// before the resource was created on the FHIR server, and should remain
    /// unchanged over the lifespan of the appointment.
    ///
    /// ## Implementation Notes
    /// This property is required for many use cases where the age of an appointment
    /// is considered in processing workflows for scheduling and billing of
    /// appointments.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub created: Option<DateTime>,
    /// When the appointment was cancelled
    ///
    /// The date/time describing when the appointment was cancelled.
    ///
    /// ## Implementation Notes
    /// If the appointment was cancelled multiple times, this would reflect the most
    /// recent cancellation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: app-7
    #[fhir_serde(rename = "cancellationDate")]
    pub cancellation_date: Option<DateTime>,
    /// Additional comments
    ///
    /// Additional notes/comments about the appointment.
    ///
    /// ## Implementation Notes
    /// Additional text to aid in facilitating the appointment. For instance, a note
    /// might be, "patient should proceed immediately to infusion room upon arrival"
    ///
    /// Where this is a planned appointment and the start/end dates are not set then
    /// this field can be used to provide additional guidance on the details of the
    /// appointment request, including any restrictions on when to book it.
    ///
    /// Typically only the concept.text will be used, however occasionally a
    /// reference to some generic documentation (or specific) and also supports coded
    /// instructions if/when they are required.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
    /// Detailed information and instructions for the patient
    ///
    /// While Appointment.note contains information for internal use,
    /// Appointment.patientInstructions is used to capture patient facing information
    /// about the Appointment (e.g. please bring your referral or fast from 8pm night
    /// before).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "patientInstruction")]
    pub patient_instruction: Option<Vec<CodeableReference>>,
    /// The request this appointment is allocated to assess
    ///
    /// The request this appointment is allocated to assess (e.g. incoming referral
    /// or procedure request).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// incomingReferral
    #[fhir_serde(rename = "basedOn")]
    pub based_on: Option<Vec<Reference>>,
    /// The patient or group associated with the appointment
    ///
    /// The patient or group associated with the appointment, if they are to be
    /// present (usually) then they should also be included in the participant
    /// backbone element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub subject: Option<Reference>,
    /// Participants involved in appointment
    ///
    /// List of participants involved in the appointment.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **app-1**: Either the type or actor on the participant SHALL be specified (error)
    ///   Expression: `type.exists() or actor.exists()`
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub participant: Option<Vec<AppointmentParticipant>>,
    /// The sequence number in the recurrence
    ///
    /// The sequence number that identifies a specific appointment in a recurring
    /// pattern.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "recurrenceId")]
    pub recurrence_id: Option<PositiveInt>,
    /// Indicates that this appointment varies from a recurrence pattern
    ///
    /// This appointment varies from the recurring pattern.
    ///
    /// ## Implementation Notes
    /// For example, if a patient has physical therapy appointments every Tuesday and
    /// Thursday, but due to a national holiday, a single occurrence was rescheduled
    /// to a different day, while the rest of the recurring series remained on
    /// Tuesday / Thursday.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "occurrenceChanged")]
    pub occurrence_changed: Option<Boolean>,
    /// Details of the recurrence pattern/template used to generate occurrences
    ///
    /// The details of the recurrence pattern or template that is used to generate
    /// recurring appointments.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: app-6
    #[fhir_serde(rename = "recurrenceTemplate")]
    pub recurrence_template: Option<Vec<AppointmentRecurrenceTemplate>>,
}

/// FHIR AppointmentResponse type
///
/// A reply to an appointment request for a patient and/or practitioner(s), such
/// as a confirmation or rejection.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [AppointmentResponse](http://hl7.org/fhir/StructureDefinition/AppointmentResponse)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AppointmentResponse {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External Ids for this item
    ///
    /// This records identifiers associated with this appointment response concern
    /// that are defined by business processes and/ or used to refer to it when a
    /// direct URL reference to the resource itself is not appropriate.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Appointment this response relates to
    ///
    /// Appointment that this response is replying to.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub appointment: Reference,
    /// Indicator for a counter proposal
    ///
    /// Indicates that the response is proposing a different time that was initially
    /// requested. The new proposed time will be indicated in the start and end
    /// properties.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "proposedNewTime")]
    pub proposed_new_time: Option<Boolean>,
    /// Time from appointment, or requested new start time
    ///
    /// Date/Time that the appointment is to take place, or requested new start time.
    ///
    /// ## Implementation Notes
    /// This may be either the same as the appointment request to confirm the details
    /// of the appointment, or alternately a new time to request a re-negotiation of
    /// the start time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub start: Option<Instant>,
    /// Time from appointment, or requested new end time
    ///
    /// This may be either the same as the appointment request to confirm the details
    /// of the appointment, or alternately a new time to request a re-negotiation of
    /// the end time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub end: Option<Instant>,
    /// Role of participant in the appointment
    ///
    /// Role of participant in the appointment.
    ///
    /// ## Implementation Notes
    /// The role of the participant can be used to declare what the actor will be
    /// doing in the scope of the referenced appointment.
    ///
    /// If the actor is not specified, then it is expected that the actor will be
    /// filled in at a later stage of planning.
    ///
    /// This value SHALL be the same as specified on the referenced Appointment so
    /// that they can be matched, and subsequently updated.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Role of participant in encounter.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/encounter-participant-type
    ///
    /// ## Conditions
    /// Used when: apr-1
    #[fhir_serde(rename = "participantType")]
    pub participant_type: Option<Vec<CodeableConcept>>,
    /// Person(s), Location, HealthcareService, or Device
    ///
    /// A Person, Location, HealthcareService, or Device that is participating in the
    /// appointment.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: apr-1
    pub actor: Option<Reference>,
    /// accepted | declined | tentative | needs-action | entered-in-error
    ///
    /// Participation status of the participant. When the status is declined or
    /// tentative if the start/end times are different to the appointment, then these
    /// times should be interpreted as a requested time change. When the status is
    /// accepted, the times can either be the time of the appointment (as a
    /// confirmation of the time) or can be empty.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that marks the participant as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The Participation status of an appointment.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/appointmentresponse-status|6.0.0-ballot3
    #[fhir_serde(rename = "participantStatus")]
    pub participant_status: Code,
    /// Additional comments
    ///
    /// Additional comments about the appointment.
    ///
    /// ## Implementation Notes
    /// This comment is particularly important when the responder is declining,
    /// tentatively accepting or requesting another time to indicate the reasons why.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub comment: Option<Markdown>,
    /// This response is for all occurrences in a recurring request
    ///
    /// Indicates that this AppointmentResponse applies to all occurrences in a
    /// recurring request.
    ///
    /// ## Implementation Notes
    /// When a recurring appointment is requested, the participant may choose to
    /// respond to each individual occurrence, in which case
    /// AppointmentResponse.recurring should be false. If the participant chooses to
    /// respond the same way for all occurrences, they may instead use a single
    /// AppointmentResponse with recurring set to true. These may be combined as the
    /// participant chooses. For example, they may accept all occurrences (recurring
    /// = true), but then send a decline for a specific occurrence (recurring=false).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub recurring: Option<Boolean>,
    /// Original date within a recurring request
    ///
    /// The original date within a recurring request. This could be used in place of
    /// the recurrenceId to be more direct (or where the template is provided through
    /// the simple list of dates in `Appointment.occurrenceDate`).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "occurrenceDate")]
    pub occurrence_date: Option<Date>,
    /// The recurrence ID of the specific recurring request
    ///
    /// The recurrence ID (sequence number) of the specific appointment when
    /// responding to a recurring request.
    ///
    /// ## Implementation Notes
    /// If the recurrence template was defined using the list of occurrenceDates then
    /// this property might not be used.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "recurrenceId")]
    pub recurrence_id: Option<PositiveInt>,
}

/// Comment, classifier, or rating content
///
/// A component comment, classifier, or rating of the artifact.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ArtifactAssessmentContent {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Brief summary of the content
    ///
    /// A brief summary of the content of this component.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub summary: Option<Markdown>,
    /// What type of content
    ///
    /// Indicates what type of content this component represents.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/certainty-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<CodeableConcept>,
    /// Rating, classifier, or assessment
    ///
    /// Represents a rating, classifier, or assessment of the artifact.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/certainty-rating
    pub classifier: Option<Vec<CodeableConcept>>,
    /// Quantitative rating
    ///
    /// A quantitative rating of the artifact.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// Who authored the content
    ///
    /// Indicates who or what authored the content.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub author: Option<Vec<Reference>>,
    /// What the comment is directed to
    ///
    /// A URI that points to what the comment is about, such as a line of text in the
    /// CQL, or a specific element in a resource.
    ///
    /// ## Implementation Notes
    /// The target element is used to point the comment to aspect of the artifact,
    /// such as a text range within a CQL library (e.g. #content?0:0-120:80).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub path: Option<Vec<Uri>>,
    /// Relationship to other Resources
    ///
    /// Relationship that this content component has with other FHIR or non-FHIR
    /// resources that already exist.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "relatesTo")]
    pub relates_to: Option<Vec<ArtifactAssessmentRelatesTo>>,
    /// Acceptable to publicly share the content
    ///
    /// Acceptable to publicly share the comment, classifier or rating.
    ///
    /// ## Implementation Notes
    /// Absence of a value should be interpreted as inheriting any freeToShare value
    /// present in a containing structure, else inheriting data from the
    /// ArtifactAssessment.copyright element, else value unknown.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "freeToShare")]
    pub free_to_share: Option<Boolean>,
    /// Comment, classifier, or rating content
    ///
    /// A component comment, classifier, or rating of the artifact.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub component: Option<Vec<ArtifactAssessmentContent>>,
}

/// Choice of types for the artifact\[x\] field in ArtifactAssessment
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "artifact")]
pub enum ArtifactAssessmentArtifact {
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "artifactReference")]
    Reference(Reference),
    /// Variant accepting the Canonical type.
    #[fhir_serde(rename = "artifactCanonical")]
    Canonical(Canonical),
    /// Variant accepting the Uri type.
    #[fhir_serde(rename = "artifactUri")]
    Uri(Uri),
}

/// FHIR ArtifactAssessment type
///
/// This Resource provides one or more comments, classifiers or ratings about a
/// Resource and supports attribution and rights management metadata for the
/// added content.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [ArtifactAssessment](http://hl7.org/fhir/StructureDefinition/ArtifactAssessment)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "artifact")]
pub struct ArtifactAssessment {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Additional identifier for the artifact assessment
    ///
    /// A formal identifier that is used to identify this artifact assessment when it
    /// is represented in other formats, or referenced in a specification, model,
    /// design or an instance.
    ///
    /// ## Requirements
    /// Allows externally provided and/or usable business identifiers to be easily
    /// associated with the artifact assessment.
    ///
    /// ## Implementation Notes
    /// This may be used for identifiers that can go in an HL7 V3 II (instance
    /// identifier) data type, and can then identify this artifact assessment outside
    /// of FHIR, where it is not possible to use the logical URI.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// A label for use in displaying and selecting the artifact assessment
    ///
    /// A label for use in displaying and selecting the artifact assessment.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// How to cite the comment or rating
    ///
    /// Display of the bibliographic citation of the comment, classifier, or rating.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "citeAs")]
    pub cite_as: Option<Markdown>,
    /// The artifact assessed, commented upon or rated
    ///
    /// A reference to a resource, canonical resource, or non-FHIR resource which the
    /// comment or assessment is about.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub artifact: Option<ArtifactAssessmentArtifact>,
    /// Relationship to other Resources
    ///
    /// Relationship that this ArtifactAssessment has with other FHIR or non-FHIR
    /// resources that already exist.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "relatesTo")]
    pub relates_to: Option<Vec<ArtifactAssessmentRelatesTo>>,
    /// Date last changed
    ///
    /// The date (and optionally time) when the artifact assessment was published.
    /// The date must change when the disposition changes and it must change if the
    /// workflow status code changes. In addition, it should change when the
    /// substantive content of the artifact assessment changes.
    ///
    /// ## Implementation Notes
    /// The date is often not tracked until the resource is published, but may be
    /// present on draft content. Note that this is not the same as the resource
    /// last-modified-date, since the resource may be a secondary representation of
    /// the artifact assessment. Additional specific dates may be added as extensions
    /// or be found by consulting Provenances associated with past versions of the
    /// resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Revision Date
    pub date: Option<DateTime>,
    /// Use and/or publishing restrictions
    ///
    /// A copyright statement relating to the artifact assessment and/or its
    /// contents. Copyright statements are generally legal restrictions on the use
    /// and publishing of the artifact assessment.
    ///
    /// ## Requirements
    /// Consumers must be able to determine any legal restrictions on the use of the
    /// artifact assessment and/or its content.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// License, Restrictions
    pub copyright: Option<Markdown>,
    /// When the artifact assessment was approved by publisher
    ///
    /// The date on which the resource content was approved by the publisher.
    /// Approval happens once when the content is officially approved for usage.
    ///
    /// ## Implementation Notes
    /// The 'date' element may be more recent than the approval date because of minor
    /// changes or editorial corrections.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "approvalDate")]
    pub approval_date: Option<Date>,
    /// When the artifact assessment was last reviewed by the publisher
    ///
    /// The date on which the resource content was last reviewed. Review happens
    /// periodically after approval but does not change the original approval date.
    ///
    /// ## Requirements
    /// Gives a sense of how "current" the content is. Resources that have not been
    /// reviewed in a long time may have a risk of being less appropriate/relevant.
    ///
    /// ## Implementation Notes
    /// If specified, this date follows the original approval date.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastReviewDate")]
    pub last_review_date: Option<Date>,
    /// Comment, classifier, or rating content
    ///
    /// A component comment, classifier, or rating of the artifact.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub content: Option<Vec<ArtifactAssessmentContent>>,
    /// submitted | triaged | waiting-for-input | resolved-no-change | resolved-change-required | deferred | duplicate | applied | published | entered-in-error
    ///
    /// Indicates the workflow status of the comment or change request.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/artifactassessment-workflow-status|6.0.0-ballot3
    #[fhir_serde(rename = "workflowStatus")]
    pub workflow_status: Option<Code>,
    /// unresolved | not-persuasive | persuasive | persuasive-with-modification | not-persuasive-with-modification
    ///
    /// Indicates the disposition of the responsible party to the comment or change
    /// request.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/artifactassessment-disposition|6.0.0-ballot3
    pub disposition: Option<Code>,
}

/// Choice of types for the target\[x\] field in ArtifactAssessmentRelatesTo
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "target")]
pub enum ArtifactAssessmentRelatesToTarget {
    /// Variant accepting the Uri type.
    #[fhir_serde(rename = "targetUri")]
    Uri(Uri),
    /// Variant accepting the Attachment type.
    #[fhir_serde(rename = "targetAttachment")]
    Attachment(Attachment),
    /// Variant accepting the Canonical type.
    #[fhir_serde(rename = "targetCanonical")]
    Canonical(Canonical),
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "targetReference")]
    Reference(Reference),
    /// Variant accepting the Markdown type.
    #[fhir_serde(rename = "targetMarkdown")]
    Markdown(Markdown),
}

/// Relationship to other Resources
///
/// Relationship that this ArtifactAssessment has with other FHIR or non-FHIR
/// resources that already exist.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "target")]
pub struct ArtifactAssessmentRelatesTo {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// documentation | justification | citation | predecessor | successor | derived-from | depends-on | composed-of | part-of | amends | amended-with | appends | appended-with | cites | cited-by | comments-on | comment-in | contains | contained-in | corrects | correction-in | replaces | replaced-with | retracts | retracted-by | signs | similar-to | supports | supported-with | transforms | transformed-into | transformed-with | documents | specification-of | created-with | cite-as | reprint | reprint-of | summarizes
    ///
    /// The type of relationship to the related artifact.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: The type of relationship to the related artifact.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/artifact-relationship-type
    #[fhir_serde(rename = "type")]
    pub r#type: CodeableConcept,
    /// The artifact that is related to this ArtifactAssessment
    ///
    /// The artifact that is related to this ArtifactAssessment Resource.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub target: Option<ArtifactAssessmentRelatesToTarget>,
}

/// Choice of types for the occurred\[x\] field in AuditEvent
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "occurred")]
pub enum AuditEventOccurred {
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "occurredPeriod")]
    Period(Period),
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "occurredDateTime")]
    DateTime(DateTime),
}

/// FHIR AuditEvent type
///
/// A record of an event relevant for purposes such as operations, privacy,
/// security, maintenance, and performance analysis.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [AuditEvent](http://hl7.org/fhir/StructureDefinition/AuditEvent)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "occurred")]
pub struct AuditEvent {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// High level categorization of audit event
    ///
    /// Partitions the audit event into one or more categories that can be used to
    /// filter searching, to govern access control and/or to guide system behavior.
    ///
    /// ## Implementation Notes
    /// Categorization might be done automatically (inferred by code) or manually by
    /// user assertion. The absence of a category may limit the ability to determine
    /// when the element should be handled, so strong consideration should be given
    /// to how systems will be able to determine category values for legacy data and
    /// how data that cannot be categorized will be handled. As well, some categories
    /// might not be mutually exclusive, so systems should prepare for multiple
    /// declared categories - even within a single category 'axis'.
    /// In general, there should not be a 'strong' binding ('required' or
    /// 'extensible') on the category element overall. Instead, the element can be
    /// sliced and bindings can be asserted that apply to particular repetitions.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Type of event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-type
    ///
    /// ## Aliases
    /// category, EventTypeCode
    #[fhir_serde(rename = "type")]
    pub r#type: CodeableConcept,
    /// Specific type of event
    ///
    /// Describes what happened. The most specific codes for the event.
    ///
    /// ## Requirements
    /// This field enables queries of messages by implementation-defined event
    /// categories.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Specific type of event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-sub-type
    ///
    /// ## Aliases
    /// code, EventID
    pub subtype: Option<Vec<CodeableConcept>>,
    /// Type of action performed during the event
    ///
    /// Indicator for type of action performed during the event that generated the
    /// audit.
    ///
    /// ## Requirements
    /// This broadly indicates what kind of action was done on the AuditEvent.entity
    /// by the AuditEvent.agent.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: DICOM Audit Event Action
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-action|6.0.0-ballot3
    pub action: Option<Code>,
    /// emergency | alert | critical | error | warning | notice | informational | debug
    ///
    /// Indicates and enables segmentation of various severity including debugging
    /// from critical.
    ///
    /// ## Implementation Notes
    /// ATNA will map this to the SYSLOG PRI element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: This is in the SysLog header, PRI. http://tools.ietf.org/html/rfc5424#appendix-A.3
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-severity|6.0.0-ballot3
    pub severity: Option<Code>,
    /// When the activity occurred
    ///
    /// The time or period during which the activity occurred.
    ///
    /// ## Implementation Notes
    /// The time or period can be a little arbitrary; where possible, the time should
    /// correspond to human assessment of the activity time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub occurred: Option<AuditEventOccurred>,
    /// Time when the event was recorded
    ///
    /// The time when the event was recorded.
    ///
    /// ## Requirements
    /// This ties an event to a specific date and time. Security audits typically
    /// require a consistent time base (e.g. UTC), to eliminate time-zone issues
    /// arising from geographical distribution.
    ///
    /// ## Implementation Notes
    /// In a distributed system, some sort of common time base (e.g. an NTP [RFC1305]
    /// server) is a good implementation tactic.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub recorded: Instant,
    /// Whether the event succeeded or failed
    ///
    /// Indicates whether the event succeeded or failed. A free text descripiton can
    /// be given in outcome.text.
    ///
    /// ## Requirements
    /// when a code is given there must be one code from the given codeSystem, and
    /// may be other equivilant codes from other codeSystems (for example http
    /// response codes such as 2xx, 4xx, or 5xx).
    ///
    /// ## Implementation Notes
    /// In some cases a "success" may be partial, for example, an incomplete or
    /// interrupted transfer of a radiological study. For the purpose of establishing
    /// accountability, these distinctions are not relevant.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub outcome: Option<AuditEventOutcome>,
    /// Authorization related to the event
    ///
    /// The authorization (e.g., PurposeOfUse) that was used during the event being
    /// recorded.
    ///
    /// ## Requirements
    /// Record of any relevant security context, not restricted to purposeOfUse
    /// valueSet. May include security compartments, refrain, obligation, or other
    /// security tags.
    ///
    /// ## Implementation Notes
    /// Use AuditEvent.agent.authorization when you know that it is specific to the
    /// agent, otherwise use AuditEvent.authorization. For example, during a
    /// machine-to-machine transfer it might not be obvious to the audit system who
    /// caused the event, but it does know why.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The authorized purposeOfUse for the activity.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/v3-PurposeOfUse
    ///
    /// ## Aliases
    /// PurposeOfEvent
    pub authorization: Option<Vec<CodeableConcept>>,
    /// Workflow authorization within which this event occurred
    ///
    /// Allows tracing of authorization for the events and tracking whether
    /// proposals/recommendations were acted upon.
    ///
    /// ## Requirements
    /// Allows tracing of authorization for the audit event and tracking whether
    /// proposals/recommendations were acted upon.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "basedOn")]
    pub based_on: Option<Vec<Reference>>,
    /// The patient is the subject of the data used/created/updated/deleted during the activity
    ///
    /// The patient element is available to enable deterministic tracking of
    /// activities that involve the patient as the subject of the data used in an
    /// activity.
    ///
    /// ## Requirements
    /// When the .patient is populated it shall be accurate to the subject of the
    /// used data. The .patient shall not be populated when the used data
    /// used/created/updated/deleted (.entity) by the activity does not involve a
    /// subject. Note that when the patient is an agent, they will be recorded as an
    /// agent. When the Patient resource is Created, Updated, or Deleted it will be
    /// recorded as an entity. May also affect access control.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub patient: Option<Reference>,
    /// Encounter within which this event occurred or which the event is tightly associated
    ///
    /// This will typically be the encounter the event occurred, but some events may
    /// be initiated prior to or after the official completion of an encounter but
    /// still be tied to the context of the encounter (e.g. pre-admission lab tests).
    ///
    /// ## Requirements
    /// Links the audit event to the Encounter context. May also affect access
    /// control.
    ///
    /// ## Implementation Notes
    /// This will typically be the encounter the audit event was created during, but
    /// some audit events may be initiated prior to or after the official completion
    /// of an encounter but still be tied to the context of the encounter (e.g.
    /// pre-admission lab tests).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Reference>,
    /// Actor involved in the event
    ///
    /// An actor taking an active role in the event or activity that is logged.
    ///
    /// ## Requirements
    /// An agent can be a person, an organization, software, device, or other actors
    /// that may be ascribed responsibility.
    ///
    /// ## Implementation Notes
    /// Several agents may be associated (i.e. have some responsibility for an
    /// activity) with an event or activity.
    ///
    /// For example, an activity may be initiated by one user for other users or
    /// involve more than one user. However, only one user may be the
    /// initiator/requestor for the activity.
    ///
    /// When a network are used in an event being recorded, there should be distinct
    /// agent elements for the known actors using the network. The agent with a
    /// network detail would be the responsible agent for use of that network.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// ActiveParticipant
    pub agent: Option<Vec<AuditEventAgent>>,
    /// Audit Event Reporter
    ///
    /// The actor that is reporting the event.
    ///
    /// ## Requirements
    /// The event is reported by one source.
    ///
    /// ## Implementation Notes
    /// Events are reported by the actor that detected them. This may be one of the
    /// participating actors, but may also be different. The actor may be a human
    /// such as a medical-records clerk disclosing data manually, that clerk would be
    /// the source for the record of disclosure.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub source: AuditEventSource,
    /// Data or objects used
    ///
    /// Specific instances of data or objects that have been accessed.
    ///
    /// ## Requirements
    /// The event may have other entities involved.
    ///
    /// ## Implementation Notes
    /// Required unless the values for event identification, agent identification,
    /// and audit source identification are sufficient to document the entire
    /// auditable event. Because events may have more than one entity, this group can
    /// be a repeating set of values.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// ParticipantObject
    pub entity: Option<Vec<AuditEventEntity>>,
}

/// Whether the event succeeded or failed
///
/// Indicates whether the event succeeded or failed. A free text descripiton can
/// be given in outcome.text.
///
/// ## Requirements
/// when a code is given there must be one code from the given codeSystem, and
/// may be other equivilant codes from other codeSystems (for example http
/// response codes such as 2xx, 4xx, or 5xx).
///
/// ## Implementation Notes
/// In some cases a "success" may be partial, for example, an incomplete or
/// interrupted transfer of a radiological study. For the purpose of establishing
/// accountability, these distinctions are not relevant.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AuditEventOutcome {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Whether the event succeeded or failed
    ///
    /// Indicates whether the event succeeded or failed.
    ///
    /// ## Requirements
    /// when a code is given there must be one code from the given codeSystem.
    ///
    /// ## Implementation Notes
    /// In some cases a "success" may be partial, for example, an incomplete or
    /// interrupted transfer of a radiological study. For the purpose of establishing
    /// accountability, these distinctions are not relevant.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: DICOM Audit Event Outcome
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-outcome
    pub code: Coding,
    /// Additional outcome detail
    ///
    /// Additional details about the error. This may be a text description of the
    /// error or a system code that identifies the error.
    ///
    /// ## Implementation Notes
    /// A human readable description of the error issue SHOULD be placed in
    /// details.text.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: A code that provides details as the exact issue.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-event-outcome-detail
    pub detail: Option<Vec<CodeableConcept>>,
}

/// Choice of types for the network\[x\] field in AuditEventAgent
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "network")]
pub enum AuditEventAgentNetwork {
    /// Variant accepting the Reference type.
    #[fhir_serde(rename = "networkReference")]
    Reference(Reference),
    /// Variant accepting the Uri type.
    #[fhir_serde(rename = "networkUri")]
    Uri(Uri),
    /// Variant accepting the String type.
    #[fhir_serde(rename = "networkString")]
    String(String),
}

/// Actor involved in the event
///
/// An actor taking an active role in the event or activity that is logged.
///
/// ## Requirements
/// An agent can be a person, an organization, software, device, or other actors
/// that may be ascribed responsibility.
///
/// ## Implementation Notes
/// Several agents may be associated (i.e. have some responsibility for an
/// activity) with an event or activity.
///
/// For example, an activity may be initiated by one user for other users or
/// involve more than one user. However, only one user may be the
/// initiator/requestor for the activity.
///
/// When a network are used in an event being recorded, there should be distinct
/// agent elements for the known actors using the network. The agent with a
/// network detail would be the responsible agent for use of that network.
///
/// ## Cardinality: Required, Multiple (1..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Aliases
/// ActiveParticipant
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "network")]
pub struct AuditEventAgent {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// How agent participated
    ///
    /// The Functional Role of the user when performing the event.
    ///
    /// ## Requirements
    /// Functional roles reflect functional aspects of relationships between
    /// entities. Functional roles are bound to the realization/performance of acts,
    /// where actions might be concatenated to an activity or even to a process. This
    /// element will hold the functional role that the agent played in the activity
    /// that is the focus of this Provenance. Where an agent played multiple
    /// functional roles, they will be listed as multiple .agent elements
    /// representing each functional participation. See ISO 21298:2018 - Health
    /// Informatics - Functional and structural roles, and ISO 22600-2:2014 - Health
    /// Informatics - Privilege Management and Access Control - Part 2: formal
    /// models.
    ///
    /// ## Implementation Notes
    /// For example: assembler, author, prescriber, signer, investigator, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: The Participation type of the agent to the event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/participation-role-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<CodeableConcept>,
    /// Agent role in the event
    ///
    /// The structural roles of the agent indicating the agent's competency. The
    /// security role enabling the agent with respect to the activity.
    ///
    /// ## Requirements
    /// Structural roles reflect the structural aspects of relationships between
    /// entities. Structural roles describe prerequisites, feasibilities, or
    /// competences for acts. Functional roles reflect functional aspects of
    /// relationships between entities. Functional roles are bound to the
    /// realization/performance of acts, where actions might be concatenated to an
    /// activity or even to a process. See ISO 21298:2018 - Health Informatics -
    /// Functional and structural roles, and ISO 22600-2:2014 - Health Informatics -
    /// Privilege Management and Access Control - Part 2: formal models..
    ///
    /// ## Implementation Notes
    /// For example: Chief-of-Radiology, Nurse, Physician, Medical-Student, etc.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: What security role enabled the agent to participate in the event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/security-role-type
    pub role: Option<Vec<CodeableConcept>>,
    /// Identifier of who
    ///
    /// Reference to who this agent is that was involved in the event.
    ///
    /// ## Requirements
    /// This field ties an audit event to a specific resource or identifier.
    ///
    /// ## Implementation Notes
    /// Where a User ID is available it will go into who.identifier. Where a name of
    /// the user (human readable) it will go into who.display.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// userId
    pub who: Reference,
    /// Whether user is initiator
    ///
    /// Indicator that the user is or is not the requestor, or initiator, for the
    /// event being audited.
    ///
    /// ## Requirements
    /// This value is used to distinguish between requestor-users and
    /// recipient-users. For example, one person may initiate a report-output to be
    /// sent to another user.
    ///
    /// ## Implementation Notes
    /// There can only be one initiator. If the initiator is not clear, then do not
    /// choose any one agent as the initiator.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    /// - When missing: false
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub requestor: Option<Boolean>,
    /// The agent location when the event occurred
    ///
    /// Where the agent location is known, the agent location when the event
    /// occurred.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub location: Option<Reference>,
    /// Policy that authorized the agent participation in the event
    ///
    /// Where the policy(ies) are known that authorized the agent participation in
    /// the event. Typically, a single activity may have multiple applicable
    /// policies, such as patient consent, guarantor funding, etc. The policy would
    /// also indicate the security token used.
    ///
    /// ## Requirements
    /// This value is used retrospectively to determine the authorization policies.
    ///
    /// ## Implementation Notes
    /// For example: Where an OAuth token authorizes, the unique identifier from the
    /// OAuth token is placed into the policy element Where a policy engine (e.g.
    /// XACML) holds policy logic, the unique policy identifier is placed into the
    /// policy element.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub policy: Option<Vec<Uri>>,
    /// This agent network location for the activity
    ///
    /// When the event utilizes a network there should be an agent describing the
    /// local system, and an agent describing remote system, with the network
    /// interface details.
    ///
    /// ## Requirements
    /// When a network protocol is used the endpoint is associated with the agent
    /// most directly using the endpoint. This is usually the software agent that has
    /// implemented the application level protocol. Preference is to define network
    /// in terms of a Reference(Endpoint), or URI; use string only when address or
    /// hostname is all that is known. When encoding using string it is best to
    /// encode using the formal canonical host name, but if you can't, then you can
    /// encode numeric in Literal address form using square brackets '[]' as a v4
    /// string (in dotted notation), or v6 string (in colon notation).
    ///
    /// ## Implementation Notes
    /// When remote network endpoint is known, another agent representing the remote
    /// agent would indicate the remote network endpoint used. Convention is to
    /// indicate data flowing from Source to Destination. The convention for Search,
    /// given data flows both ways (query parameters vs results), is to have the
    /// Source as the initiator of the Search Transaction, and the Destination the
    /// responder to the Search transaction.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub network: Option<AuditEventAgentNetwork>,
    /// Allowable authorization for this agent
    ///
    /// The authorization (e.g., PurposeOfUse) that was used during the event being
    /// recorded.
    ///
    /// ## Requirements
    /// Record of any relevant security context, not restricted to purposeOfUse
    /// valueSet. May include security compartments, refrain, obligation, or other
    /// security tags.
    ///
    /// ## Implementation Notes
    /// Use AuditEvent.agent.authorization when you know that is specific to the
    /// agent, otherwise use AuditEvent.authorization. For example, during a
    /// machine-to-machine transfer it might not be obvious to the audit system who
    /// caused the event, but it does know why.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: The reason the activity took place.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/v3-PurposeOfUse
    ///
    /// ## Aliases
    /// PurposeOfUse
    pub authorization: Option<Vec<CodeableConcept>>,
}

/// Audit Event Reporter
///
/// The actor that is reporting the event.
///
/// ## Requirements
/// The event is reported by one source.
///
/// ## Implementation Notes
/// Events are reported by the actor that detected them. This may be one of the
/// participating actors, but may also be different. The actor may be a human
/// such as a medical-records clerk disclosing data manually, that clerk would be
/// the source for the record of disclosure.
///
/// ## Cardinality: Required (1..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AuditEventSource {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Logical source location within the enterprise
    ///
    /// Logical source location within the healthcare enterprise network. For
    /// example, a hospital or other provider location within a multi-entity provider
    /// group.
    ///
    /// ## Requirements
    /// This value differentiates among the sites in a multi-site enterprise health
    /// information system.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub site: Option<Reference>,
    /// The identity of source detecting the event
    ///
    /// Identifier of the source where the event was detected.
    ///
    /// ## Requirements
    /// This field ties the event to a specific source system. It may be used to
    /// group events for analysis according to where the event was detected.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// SourceId
    pub observer: Reference,
    /// The type of source where event originated
    ///
    /// Code specifying the type of source where event originated.
    ///
    /// ## Requirements
    /// This field indicates which type of source is identified by the Audit Source
    /// ID. It is an optional value that may be used to group events for analysis
    /// according to the type of source where the event occurred.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: Code specifying the type of system that detected and recorded the event. Use of these codes is not required but is encouraged to maintain translation with DICOM AuditMessage schema.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/security-source-type
    #[fhir_serde(rename = "type")]
    pub r#type: Option<Vec<CodeableConcept>>,
}

/// Data or objects used
///
/// Specific instances of data or objects that have been accessed.
///
/// ## Requirements
/// The event may have other entities involved.
///
/// ## Implementation Notes
/// Required unless the values for event identification, agent identification,
/// and audit source identification are sufficient to document the entire
/// auditable event. Because events may have more than one entity, this group can
/// be a repeating set of values.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Aliases
/// ParticipantObject
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct AuditEventEntity {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Specific instance of resource
    ///
    /// Identifies a specific instance of the entity. The reference should be version
    /// specific. This is allowed to be a Parameters resource.
    ///
    /// ## Implementation Notes
    /// Use .what.display when all you have is a string (e.g. ParticipantObjectName).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub what: Option<Reference>,
    /// What role the entity played
    ///
    /// Code representing the role the entity played in the event being audited.
    ///
    /// ## Requirements
    /// For some detailed audit analysis it may be necessary to indicate a more
    /// granular type of entity, based on the application role it serves.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: DICOM Audit Event Entity Role
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/object-role
    pub role: Option<CodeableConcept>,
    /// Security labels on the entity
    ///
    /// Security labels for the identified entity.
    ///
    /// ## Requirements
    /// This field identifies the security labels for a specific instance of an
    /// object, such as a patient, to detect/track privacy and security issues.
    ///
    /// ## Implementation Notes
    /// Copied from entity meta security tags.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Example Security Labels from the Healthcare Privacy and Security Classification System.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/security-label-examples
    #[fhir_serde(rename = "securityLabel")]
    pub security_label: Option<Vec<CodeableConcept>>,
    /// Descriptive text
    ///
    /// Text that describes the entity in more detail.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Query parameters
    ///
    /// The query parameters for a query-type entities.
    ///
    /// ## Requirements
    /// For query events, it may be necessary to capture the actual query input to
    /// the query process in order to identify the specific event. Because of
    /// differences among query implementations and data encoding for them, this is a
    /// base 64 encoded data blob. It may be subsequently decoded or interpreted by
    /// downstream audit analysis processing.
    ///
    /// ## Implementation Notes
    /// The meaning and secondary-encoding of the content of base64 encoded blob is
    /// specific to the AuditEvent.type, AuditEvent.subtype, and
    /// AuditEvent.entity.role. The base64 is a general-use and safe container for
    /// event specific data blobs regardless of the encoding used by the transaction
    /// being recorded. An AuditEvent consuming application must understand the event
    /// it is consuming and the formats used by the event. For example, if auditing
    /// an Oracle network database access, the Oracle formats must be understood as
    /// they will be simply encoded in the base64binary blob.
    ///
    /// The DICOM AuditMessage schema does not support both .name and .query being
    /// populated.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub query: Option<Base64Binary>,
    /// Additional Information about the entity
    ///
    /// Tagged value pairs for conveying additional information about the entity.
    ///
    /// ## Requirements
    /// Implementation-defined data about specific details of the object accessed or
    /// used.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub detail: Option<Vec<AuditEventEntityDetail>>,
    /// Entity is attributed to this agent
    ///
    /// The entity is attributed to an agent to express the agent's responsibility
    /// for that entity in the activity. This is most used to indicate when
    /// persistence media (the entity) are used by an agent. For example when
    /// importing data from a device, the device would be described in an entity, and
    /// the user importing data from that media would be indicated as the
    /// entity.agent.
    ///
    /// ## Implementation Notes
    /// A usecase where one AuditEvent.entity.agent is used where the Entity that was
    /// used in the creation/updating of a target resource, is not in the context of
    /// the same custodianship as the target resource, and thus the meaning of
    /// AuditEvent.entity.agent is to say that the entity referenced is managed
    /// elsewhere and that this Agent provided access to it. This would be similar to
    /// where the Entity being referenced is managed outside FHIR, such as through
    /// HL7 V2, v3, or XDS. This might be where the Entity being referenced is
    /// managed in another FHIR resource server. Thus it explains the provenance of
    /// that Entity's use in the context of this AuditEvent activity.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub agent: Option<Vec<AuditEventAgent>>,
}

/// Choice of types for the value\[x\] field in AuditEventEntityDetail
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "value")]
pub enum AuditEventEntityDetailValue {
    /// Variant accepting the Quantity type.
    #[fhir_serde(rename = "valueQuantity")]
    Quantity(Quantity),
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "valueCodeableConcept")]
    CodeableConcept(CodeableConcept),
    /// Variant accepting the String type.
    #[fhir_serde(rename = "valueString")]
    String(String),
    /// Variant accepting the Boolean type.
    #[fhir_serde(rename = "valueBoolean")]
    Boolean(Boolean),
    /// Variant accepting the Integer type.
    #[fhir_serde(rename = "valueInteger")]
    Integer(Integer),
    /// Variant accepting the Range type.
    #[fhir_serde(rename = "valueRange")]
    Range(Range),
    /// Variant accepting the Ratio type.
    #[fhir_serde(rename = "valueRatio")]
    Ratio(Ratio),
    /// Variant accepting the Time type.
    #[fhir_serde(rename = "valueTime")]
    Time(Time),
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "valueDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "valuePeriod")]
    Period(Period),
    /// Variant accepting the Base64Binary type.
    #[fhir_serde(rename = "valueBase64Binary")]
    Base64Binary(Base64Binary),
}

/// Additional Information about the entity
///
/// Tagged value pairs for conveying additional information about the entity.
///
/// ## Requirements
/// Implementation-defined data about specific details of the object accessed or
/// used.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "value")]
pub struct AuditEventEntityDetail {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// The name of the extra detail property
    ///
    /// The name of extra detail provided in the value. This element is the tag for
    /// the value. Where a simple string is used for the tag name, use the
    /// CodeableConcept.display element.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Additional detail about an entity used in an event.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/audit-entity-detail-type
    #[fhir_serde(rename = "type")]
    pub r#type: CodeableConcept,
    /// Property value
    ///
    /// The  value of the extra detail.
    ///
    /// ## Requirements
    /// Should not duplicate the entity value unless absolutely necessary.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub value: Option<AuditEventEntityDetailValue>,
}

/// FHIR Basic type
///
/// Basic is used for handling concepts not yet defined in FHIR, narrative-only
/// resources that don't map to an existing resource, and custom resources not
/// appropriate for inclusion in the FHIR specification.
///
/// ## Purpose
/// Need some way to safely (without breaking interoperability) allow implementers to exchange content not supported by the initial set of declared resources.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [Basic](http://hl7.org/fhir/StructureDefinition/Basic)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Basic {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Business identifier
    ///
    /// Identifier assigned to the resource for business purposes, outside the
    /// context of FHIR.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Kind of Resource
    ///
    /// Identifies the 'type' of resource - equivalent to the resource name for other
    /// resources.
    ///
    /// ## Requirements
    /// Must be able to distinguish different types of Basic resources.
    ///
    /// ## Implementation Notes
    /// Because resource references will only be able to indicate 'Basic', the type
    /// of reference will need to be specified in a Profile identified as part of the
    /// resource. Refer to the resource notes section for information on appropriate
    /// terminologies for this code.
    ///
    /// This element is labeled as a modifier because it defines the meaning of the
    /// resource and cannot be ignored.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element determines what kind of resource is being represented which drives the meaning of all of the other elements.
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Codes for all resources across R5 and all published previous versions since R2
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/version-independent-resource-types
    pub code: CodeableConcept,
    /// Identifies the focus of this resource
    ///
    /// Identifies the patient, practitioner, device or any other resource that is
    /// the "focus" of this resource.
    ///
    /// ## Requirements
    /// Needed for partitioning the resource by Patient.
    ///
    /// ## Implementation Notes
    /// Optional as not all potential resources will have subjects. Resources
    /// associated with multiple subjects can handle this via extension.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub subject: Option<Reference>,
    /// When created
    ///
    /// Identifies when the resource was first created.
    ///
    /// ## Requirements
    /// Allows ordering resource instances by time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub created: Option<DateTime>,
    /// Who created
    ///
    /// Indicates who was responsible for creating the resource instance.
    ///
    /// ## Requirements
    /// Needed for partitioning the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub author: Option<Reference>,
}

/// FHIR Binary type
///
/// A resource that represents the data of a single raw artifact as digital
/// content accessible in its native format. A Binary resource can contain any
/// content, whether text, image, pdf, zip archive, etc.
///
/// ## Purpose
/// There are situations where it is useful or required to handle pure binary content using the same framework as other resources.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/Resource
///
/// ## Status: active
/// FHIR Version: 6.0.0-ballot3
///
/// See: [Binary](http://hl7.org/fhir/StructureDefinition/Binary)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Binary {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// MimeType of the binary content
    ///
    /// MimeType of the binary content represented as a standard MimeType (BCP 13).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The mime type of an attachment. Any valid mime type is allowed.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/mimetypes|6.0.0-ballot3
    #[fhir_serde(rename = "contentType")]
    pub content_type: Code,
    /// Identifies another resource to use as proxy when enforcing access control
    ///
    /// This element identifies another resource that can be used as a proxy of the
    /// security sensitivity to use when deciding and enforcing access control rules
    /// for the Binary resource. Given that the Binary resource contains very few
    /// elements that can be used to determine the sensitivity of the data and
    /// relationships to individuals, the referenced resource stands in as a proxy
    /// equivalent for this purpose. This referenced resource may be related to the
    /// Binary (e.g. DocumentReference), or may be some non-related Resource purely
    /// as a security proxy. E.g. to identify that the binary resource relates to a
    /// patient, and access should only be granted to applications that have access
    /// to the patient.
    ///
    /// ## Implementation Notes
    /// Very often, a server will also know of a resource that references the binary,
    /// and can automatically apply the appropriate access rules based on that
    /// reference. However, there are some circumstances where this is not
    /// appropriate, e.g. the binary is uploaded directly to the server without any
    /// linking resource, the binary is referred to from multiple different
    /// resources, and/or the binary is content such as an application logo that has
    /// less protection than any of the resources that reference it.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "securityContext")]
    pub security_context: Option<Reference>,
    /// The actual content
    ///
    /// The actual content, base64 encoded.
    ///
    /// ## Implementation Notes
    /// If the content type is itself base64 encoding, then this will be base64
    /// encoded twice - what is created by un-base64ing the content must be the
    /// specified content type.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub data: Option<Base64Binary>,
}

/// Choice of types for the collected\[x\] field in BiologicallyDerivedProductCollection
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "collected")]
pub enum BiologicallyDerivedProductCollectionCollected {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "collectedDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "collectedPeriod")]
    Period(Period),
}

/// How this product was collected
///
/// How this product was collected.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "collected")]
pub struct BiologicallyDerivedProductCollection {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Individual performing the collection
    ///
    /// Healthcare professional who is performing the collection.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub collector: Option<Reference>,
    /// The patient who underwent the medical procedure to collect the product
    ///
    /// The patient providing the product.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "sourcePatient")]
    pub source_patient: Option<Reference>,
    /// The organization that facilitated the collection
    ///
    /// The entity, such as a hospital or vendor in the case of a
    /// processed/manipulated/manufactured product, providing the product.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "sourceOrganization")]
    pub source_organization: Option<Reference>,
    /// Time of product collection
    ///
    /// Time of product collection.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub collected: Option<BiologicallyDerivedProductCollectionCollected>,
    /// The procedure involved in the collection
    ///
    /// The procedure performed to collect the biologically derived product.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub procedure: Option<Reference>,
}

/// Choice of types for the value\[x\] field in BiologicallyDerivedProductProperty
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "value")]
pub enum BiologicallyDerivedProductPropertyValue {
    /// Variant accepting the Boolean type.
    #[fhir_serde(rename = "valueBoolean")]
    Boolean(Boolean),
    /// Variant accepting the Integer type.
    #[fhir_serde(rename = "valueInteger")]
    Integer(Integer),
    /// Variant accepting the CodeableConcept type.
    #[fhir_serde(rename = "valueCodeableConcept")]
    CodeableConcept(CodeableConcept),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "valuePeriod")]
    Period(Period),
    /// Variant accepting the Quantity type.
    #[fhir_serde(rename = "valueQuantity")]
    Quantity(Quantity),
    /// Variant accepting the Range type.
    #[fhir_serde(rename = "valueRange")]
    Range(Range),
    /// Variant accepting the Ratio type.
    #[fhir_serde(rename = "valueRatio")]
    Ratio(Ratio),
    /// Variant accepting the String type.
    #[fhir_serde(rename = "valueString")]
    String(String),
    /// Variant accepting the Attachment type.
    #[fhir_serde(rename = "valueAttachment")]
    Attachment(Attachment),
}

/// A property that is specific to this BiologicallyDerviedProduct instance
///
/// A property that is specific to this BiologicallyDerviedProduct instance.
///
/// ## Implementation Notes
/// Property can be used to provide information on a wide range of additional
/// information specific to a particular biologicallyDerivedProduct.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "value")]
pub struct BiologicallyDerivedProductProperty {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Code that specifies the property
    ///
    /// Code that specifies the property. It should reference an established coding
    /// system.
    ///
    /// ## Implementation Notes
    /// The element is identified by name and system URI in the type. Some types may
    /// have multiple occurrences.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Biologically Derived Product Property Type Codes
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/biologicallyderived-product-property-type-codes
    #[fhir_serde(rename = "type")]
    pub r#type: CodeableConcept,
    /// Property values
    ///
    /// Property values.
    ///
    /// ## Implementation Notes
    /// The value should be provided as a boolean, integer, CodeableConcept, period,
    /// quantity, range, ratio, or attachment. The description can be a string only
    /// when these others are not available. The type of value will depend on the
    /// property type and is specified in ST-027.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub value: Option<BiologicallyDerivedProductPropertyValue>,
}

/// FHIR BiologicallyDerivedProduct type
///
/// A biological material originating from a biological entity intended to be
/// transplanted or infused into another (possibly the same) biological entity.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [BiologicallyDerivedProduct](http://hl7.org/fhir/StructureDefinition/BiologicallyDerivedProduct)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BiologicallyDerivedProduct {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// A category or classification of the product
    ///
    /// A category or classification of the product. Products may be assigned
    /// multiple categories, for example a human heart valve can be categorized as an
    /// 'MPHO' and 'tissue'.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Biologically Derived Product Category.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/product-category
    #[fhir_serde(rename = "productCategory")]
    pub product_category: Option<Vec<CodeableConcept>>,
    /// A code that identifies the kind of this biologically derived product
    ///
    /// A codified value that systematically supports characterization and
    /// classification of medical products of human origin inclusive of processing
    /// conditions such as additives, volumes and handling conditions.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Biologically-derived Product Codes
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/biologicallyderived-productcodes
    #[fhir_serde(rename = "productCode")]
    pub product_code: Option<CodeableConcept>,
    /// The parent biologically-derived product
    ///
    /// Parent product (if any) for this biologically-derived product.
    ///
    /// ## Implementation Notes
    /// For products that have multiple collections. For example Peripheral Blood
    /// Stem Cells may be collected over several days from a single donor and the
    /// donation split into in multiple containers which must be linked to the parent
    /// donation.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub parent: Option<Vec<Reference>>,
    /// Request to obtain and/or infuse this product
    ///
    /// Request to obtain and/or infuse this biologically derived product.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub request: Option<Vec<Reference>>,
    /// Instance identifier
    ///
    /// Unique instance identifiers assigned to a biologically derived product. Note:
    /// This is a business identifier, not a resource identifier.
    ///
    /// ## Implementation Notes
    /// This identifier should uniquely identify the product instance in the business
    /// domain. Ideally it should be a globally unique identifier under the control
    /// of an ISO/IEC 15459 Issuing Agency.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// An identifier that supports traceability to the event during which material in this product from one or more biological entities was obtained or pooled
    ///
    /// An identifier that supports traceability to the event during which material
    /// in this product from one or more biological entities was obtained or pooled.
    ///
    /// ## Implementation Notes
    /// Necessary to support mandatory requirements for traceability from
    /// donor/source to recipient and vice versa, while also satisfying donor
    /// anonymity requirements. The element is defined consistently across
    /// BiologicallyDerivedProduct, NutritionProduct, and Device. The identifier
    /// references an event that links to a single biological entity such as a blood
    /// donor, or to multiple biological entities (e.g. when the product is an embryo
    /// or a pooled platelet product). A single biologicalSourceEvent identifier may
    /// appear on multiple products of many types derived from a single donation
    /// event or source extraction. As an example, a single donation event may
    /// provide 2 kidneys and a liver for organ transplantation, 2 corneas for eye
    /// surgery, heart valves and arterial tissue for cardiovascular surgery,
    /// multiple skin grafts, tendons, multiple shaped bone grafts and a large number
    /// of bone putty/paste products; and each of them may be assigned to the same
    /// biological source event identifier.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "biologicalSourceEvent")]
    pub biological_source_event: Option<Identifier>,
    /// Processing facilities responsible for the labeling and distribution of this biologically derived product
    ///
    /// Processing facilities responsible for the labeling and distribution of this
    /// biologically derived product.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "processingFacility")]
    pub processing_facility: Option<Vec<Reference>>,
    /// A unique identifier for an aliquot of a product
    ///
    /// A unique identifier for an aliquot of a product. Used to distinguish
    /// individual aliquots of a product carrying the same biologicalSource and
    /// productCode identifiers.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub division: Option<String>,
    /// available | unavailable | processed | applied | discarded
    ///
    /// The current status of the product.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Biologically Derived Product Status.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/biologicallyderived-product-status
    #[fhir_serde(rename = "productStatus")]
    pub product_status: Option<Coding>,
    /// Date, and where relevant time, of expiration
    ///
    /// Date, and where relevant time, of expiration.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "expirationDate")]
    pub expiration_date: Option<DateTime>,
    /// How this product was collected
    ///
    /// How this product was collected.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub collection: Option<BiologicallyDerivedProductCollection>,
    /// Product storage temperature requirements
    ///
    /// The temperature requirements for storage of the biologically-derived product.
    ///
    /// ## Implementation Notes
    /// May be extracted from information held in the Product Description Code.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "storageTempRequirements")]
    pub storage_temp_requirements: Option<Range>,
    /// A property that is specific to this BiologicallyDerviedProduct instance
    ///
    /// A property that is specific to this BiologicallyDerviedProduct instance.
    ///
    /// ## Implementation Notes
    /// Property can be used to provide information on a wide range of additional
    /// information specific to a particular biologicallyDerivedProduct.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub property: Option<Vec<BiologicallyDerivedProductProperty>>,
}

/// FHIR BiologicallyDerivedProductDispense type
///
/// A record of dispensation of a biologically derived product.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [BiologicallyDerivedProductDispense](http://hl7.org/fhir/StructureDefinition/BiologicallyDerivedProductDispense)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BiologicallyDerivedProductDispense {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Business identifier for this dispense
    ///
    /// Unique instance identifiers assigned to a biologically derived product
    /// dispense. Note: This is a business identifier, not a resource identifier.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// The order or request that this dispense is fulfilling
    ///
    /// The order or request that the dispense is fulfilling. This is a reference to
    /// a ServiceRequest resource.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "basedOn")]
    pub based_on: Option<Vec<Reference>>,
    /// Part of referenced event
    ///
    /// A larger event of which this particular event is a component.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "partOf")]
    pub part_of: Option<Vec<Reference>>,
    /// preparation | in-progress | allocated | issued | unfulfilled | returned | entered-in-error | unknown
    ///
    /// A code specifying the state of the dispense event.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Describes the lifecycle of the dispense.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/biologicallyderivedproductdispense-status|6.0.0-ballot3
    pub status: Code,
    /// Relationship between the donor and intended recipient
    ///
    /// Indicates the relationship between the donor of the biologically derived
    /// product and the intended recipient.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Describes the relationship between the recipient and origin of the dispensed product.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/biologicallyderivedproductdispense-origin-relationship
    #[fhir_serde(rename = "originRelationshipType")]
    pub origin_relationship_type: Option<CodeableConcept>,
    /// The BiologicallyDerivedProduct that is dispensed
    ///
    /// A link to a resource identifying the biologically derived product that is
    /// being dispensed.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub product: Reference,
    /// The intended recipient(s) of the dispensed product
    ///
    /// A link to a resource representing the individual(s) that the product is
    /// dispensed for.
    ///
    /// ## Implementation Notes
    /// Group is only allowed in the circumstance where the group represents a family
    /// or a household, and should not represent groups of Practitioners where other
    /// more specific resources can be used instead.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub subject: Reference,
    /// Indicates the type of matching associated with the dispense
    ///
    /// Indicates the type of matching associated with the dispense.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Describes the type of matching between the recipient and origin of the dispensed product.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/biologicallyderivedproductdispense-match-status
    #[fhir_serde(rename = "matchStatus")]
    pub match_status: Option<CodeableConcept>,
    /// Indicates who or what performed an action
    ///
    /// Indicates who or what performed an action.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub performer: Option<Vec<BiologicallyDerivedProductDispensePerformer>>,
    /// Where the dispense occurred
    ///
    /// The physical location where the dispense was performed.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub location: Option<Reference>,
    /// Amount dispensed
    ///
    /// The amount of product in the dispense. Quantity will depend on the product
    /// being dispensed. Examples are: volume; cell count; concentration.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// When product was selected/matched
    ///
    /// When the product was selected/ matched.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "preparedDate")]
    pub prepared_date: Option<DateTime>,
    /// When the product was dispatched
    ///
    /// When the product was dispatched for clinical use.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "whenHandedOver")]
    pub when_handed_over: Option<DateTime>,
    /// Where the product was dispatched to
    ///
    /// Link to a resource identifying the physical location that the product was
    /// dispatched to.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub destination: Option<Reference>,
    /// Additional notes
    ///
    /// Additional notes.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
    /// Specific instructions for use
    ///
    /// Specific instructions for use.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "usageInstruction")]
    pub usage_instruction: Option<String>,
}

/// Indicates who or what performed an action
///
/// Indicates who or what performed an action.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BiologicallyDerivedProductDispensePerformer {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Identifies the function of the performer during the dispense
    ///
    /// Identifies the function of the performer during the dispense.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Describes the the role or function of the performer in the dispense.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/biologicallyderivedproductdispense-performer-function
    pub function: Option<CodeableConcept>,
    /// Who performed the action
    ///
    /// Identifies the person responsible for the action.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub actor: Reference,
}

/// Landmark relative location
///
/// Body location in relation to a specific body landmark (e.g., a body structure
/// such a navel, scar, or implanted device).
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BodyStructureIncludedStructureBodyLandmarkOrientation {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Explanation of landmark
    ///
    /// Body landmark description used as a reference to locate something else.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Select SNOMED code system values. Values used in a podiatry setting to decsribe landmarks on the body.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/body-site
    #[fhir_serde(rename = "landmarkDescription")]
    pub landmark_description: Option<Vec<CodeableConcept>>,
    /// Clockface orientation
    ///
    /// An description of the direction away from a landmark something is located
    /// based on a radial clock dial.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Select SNOMED CT codes. A set of codes that describe a things orientation based on a hourly positions of a clock face.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/bodystructure-bodylandmarkorientation-clockface-position
    #[fhir_serde(rename = "clockFacePosition")]
    pub clock_face_position: Option<Vec<CodeableConcept>>,
    /// Landmark relative location
    ///
    /// The distance in centimeters a certain observation is made from a body
    /// landmark.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "distanceFromLandmark")]
    pub distance_from_landmark:
        Option<Vec<BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmark>>,
    /// Relative landmark surface orientation
    ///
    /// The surface area a body location is in relation to a landmark.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: preferred
    /// - **Description**: Select SNOMED code system values. The surface area a body location is in relation to a landmark.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/bodystructure-relative-location
    #[fhir_serde(rename = "surfaceOrientation")]
    pub surface_orientation: Option<Vec<CodeableConcept>>,
}

/// Landmark relative location
///
/// The distance in centimeters a certain observation is made from a body
/// landmark.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmark {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Measurement device
    ///
    /// An instrument, tool, analyzer, etc. used in the measurement.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes to identify medical devices.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/device-type
    pub device: Option<Vec<CodeableReference>>,
    /// Measured distance from body landmark
    ///
    /// The measured distance (e.g., in cm) from a body landmark.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub value: Option<Vec<Quantity>>,
}

/// Included anatomic location(s)
///
/// The anatomical location(s) or region(s) of the specimen, lesion, or body
/// structure.
///
/// ## Cardinality: Required, Multiple (1..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BodyStructureIncludedStructure {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Code that represents the included structure
    ///
    /// Code that represents the included structure.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: SNOMED CT Body site concepts
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/body-site
    pub structure: CodeableConcept,
    /// Code that represents the included structure laterality
    ///
    /// Code that represents the included structure laterality.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Concepts modifying the anatomic location.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/bodystructure-laterality
    pub laterality: Option<CodeableConcept>,
    /// Landmark relative location
    ///
    /// Body location in relation to a specific body landmark (e.g., a body structure
    /// such a navel, scar, or implanted device).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "bodyLandmarkOrientation")]
    pub body_landmark_orientation:
        Option<Vec<BodyStructureIncludedStructureBodyLandmarkOrientation>>,
    /// Cartesian reference for structure
    ///
    /// XY or XYZ-coordinate orientation for structure.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "spatialReference")]
    pub spatial_reference: Option<Vec<Reference>>,
    /// Code that represents the included structure qualifier
    ///
    /// Code that represents the included structure qualifier.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Concepts modifying the anatomic location.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/bodystructure-relative-location
    pub qualifier: Option<Vec<CodeableConcept>>,
    /// Kind of Structure
    ///
    /// The kind of structure being represented by the body structure at
    /// `BodyStructure.location`. This can define both normal and abnormal
    /// morphologies.
    ///
    /// ## Implementation Notes
    /// The minimum cardinality of 0 supports the use case of specifying a location
    /// without defining a morphology.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing anatomic morphology.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/bodystructure-code
    pub morphology: Option<CodeableConcept>,
}

/// FHIR BodyStructure type
///
/// Record details about an anatomical structure. This resource may be used when
/// a coded concept does not provide the necessary detail needed for the use
/// case.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [BodyStructure](http://hl7.org/fhir/StructureDefinition/BodyStructure)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BodyStructure {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Bodystructure identifier
    ///
    /// Identifier for this instance of the anatomical structure.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Whether this record is in active use
    ///
    /// Whether this body site is in active use.
    ///
    /// ## Requirements
    /// Need to be able to mark a body site entry as not to be used because it was
    /// created in error.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because it may be used to mark that the
    /// resource was created in error.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that can indicate that a record should not be treated as valid
    /// - Included in summary
    /// - When missing: This resource is generally assumed to be active if no value is provided for the active element
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub active: Option<Boolean>,
    /// Included anatomic location(s)
    ///
    /// The anatomical location(s) or region(s) of the specimen, lesion, or body
    /// structure.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "includedStructure")]
    pub included_structure: Option<Vec<BodyStructureIncludedStructure>>,
    /// Excluded anatomic locations(s)
    ///
    /// The anatomical location(s) or region(s) not occupied or represented by the
    /// specimen, lesion, or body structure.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "excludedStructure")]
    pub excluded_structure: Option<Vec<BodyStructureIncludedStructure>>,
    /// Text description
    ///
    /// A summary, characterization or explanation of the body structure.
    ///
    /// ## Implementation Notes
    /// This description could include any visual markings used to orientate the
    /// viewer e.g. external reference points, special sutures, ink markings.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<Markdown>,
    /// Attached images
    ///
    /// Image or images used to identify a location.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub image: Option<Vec<Attachment>>,
    /// Who this is about
    ///
    /// The person to which the body site belongs.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub patient: Reference,
}

/// Additional execution information (transaction/batch/history)
///
/// Additional information about how this entry should be processed as part of a
/// transaction or batch. For history, it shows how the entry was processed to
/// create the version contained in the entry.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: bdl-3a, bdl-3b, bdl-5
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleEntryRequest {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// GET | HEAD | POST | PUT | DELETE | PATCH
    ///
    /// In a transaction or batch, this is the HTTP action to be executed for this
    /// entry. In a history bundle, this indicates the HTTP action that occurred.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: HTTP verbs (in the HTTP command line). See [HTTP rfc](https://tools.ietf.org/html/rfc7231) for details.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/http-verb|6.0.0-ballot3
    ///
    /// ## Conditions
    /// Used when: bdl-3b, bdl-3c, bdl-14, bdl-15
    pub method: Code,
    /// URL for HTTP equivalent of this entry
    ///
    /// The URL for this entry, relative to the root (the address to which the
    /// request is posted).
    ///
    /// ## Implementation Notes
    /// E.g. for a Patient Create, the method would be "POST" and the URL would be
    /// "Patient". For a Patient Update, the method would be PUT and the URL would be
    /// "Patient/[id]".
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Uri,
    /// For managing cache validation
    ///
    /// If the ETag values match, return a 304 Not Modified status. See the API
    /// documentation for ["Conditional Read"](http.html#cread).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "ifNoneMatch")]
    pub if_none_match: Option<String>,
    /// For managing cache currency
    ///
    /// Only perform the operation if the last updated date matches. See the API
    /// documentation for ["Conditional Read"](http.html#cread).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "ifModifiedSince")]
    pub if_modified_since: Option<Instant>,
    /// For managing update contention
    ///
    /// Only perform the operation if the Etag value matches. For more information,
    /// see the API section ["Managing Resource Contention"](http.html#concurrency).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "ifMatch")]
    pub if_match: Option<String>,
    /// For conditional creates
    ///
    /// Instruct the server not to perform the create if a specified resource already
    /// exists. For further information, see the API documentation for ["Conditional
    /// Create"](http.html#ccreate). This is just the query portion of the URL - what
    /// follows the "?" (not including the "?").
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "ifNoneExist")]
    pub if_none_exist: Option<String>,
}

/// Results of execution (transaction/batch/history)
///
/// Indicates the results of processing the corresponding 'request' entry in the
/// batch or transaction being responded to or what the results of an operation
/// where when returning history.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: bdl-3a, bdl-3b, bdl-3d, bdl-5
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleEntryResponse {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Status response code (text optional)
    ///
    /// The status code returned by processing this entry. The status SHALL start
    /// with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP
    /// description associated with the status code.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub status: String,
    /// The location (if the operation returns a location)
    ///
    /// The location header created by processing this operation, populated if the
    /// operation returns a location.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub location: Option<Uri>,
    /// The Etag for the resource (if relevant)
    ///
    /// The Etag for the resource, if the operation for the entry produced a
    /// versioned resource (see [Resource Metadata and
    /// Versioning](http.html#versioning) and [Managing Resource
    /// Contention](http.html#concurrency)).
    ///
    /// ## Implementation Notes
    /// Etags match the Resource.meta.versionId. The ETag has to match the version id
    /// in the header if a resource is included.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub etag: Option<String>,
    /// Server's date time modified
    ///
    /// The date/time that the resource was modified on the server.
    ///
    /// ## Implementation Notes
    /// This has to match the same time in the meta header (meta.lastUpdated) if a
    /// resource is included.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastModified")]
    pub last_modified: Option<Instant>,
    /// OperationOutcome with hints and warnings (for batch/transaction)
    ///
    /// An OperationOutcome containing hints and warnings produced as part of
    /// processing this entry in a batch or transaction.
    ///
    /// ## Implementation Notes
    /// For a POST/PUT operation, this is the equivalent outcome that would be
    /// returned for prefer = operationoutcome - except that the resource is always
    /// returned whether or not the outcome is returned.
    ///
    /// This outcome is not used for error responses in batch/transaction, only for
    /// hints and warnings. In a batch operation, the error will be in
    /// Bundle.entry.response, and for transaction, there will be a single
    /// OperationOutcome instead of a bundle in the case of an error.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub outcome: Option<Box<Resource>>,
}

/// Links related to this Bundle
///
/// A series of links that provide context to this bundle.
///
/// ## Implementation Notes
/// Both Bundle.link and Bundle.entry.link are defined to support providing
/// additional context when Bundles are used (e.g.
/// [HATEOAS](http://en.wikipedia.org/wiki/HATEOAS)).
///
/// Bundle.entry.link corresponds to links found in the HTTP header if the
/// resource in the entry was [read](http.html#read) directly.
///
/// This specification defines some specific uses of Bundle.link for
/// [searching](search.html#conformance) and [paging](http.html#paging), but no
/// specific uses for Bundle.entry.link, and no defined function in a transaction
/// - the meaning is implementation specific. The behavior of navigation link
/// types (next/prev/first/last) are well defined for searchset and history
/// Bundles but are not currently defined for other types. Implementers who
/// choose to use such link relationships for other bundle types will need to
/// negotiate behavior with their interoperability partners.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: bdl-18
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleLink {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// See http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1
    ///
    /// A name which details the functional use for this link - see
    /// [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/iana-link-relations|6.0.0-ballot3
    ///
    /// ## Conditions
    /// Used when: bdl-18
    pub relation: Code,
    /// Reference details for the link
    ///
    /// The reference details for the link.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-18
    pub url: Uri,
}

/// Entry in the bundle - will have a resource or information
///
/// An entry in a bundle resource - will either contain a resource or information
/// about a resource (transactions and history only).
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
/// - Order meaning: For bundles of type 'document' and 'message', the first resource is special (must be Composition or MessageHeader respectively). For all bundles, the meaning of the order of entries depends on the bundle type
///
/// ## Constraints
/// - **bdl-5**: must be a resource unless there's a request or response (error)
///   Expression: `resource.exists() or request.exists() or response.exists()`
/// - **bdl-8**: fullUrl cannot be a version specific reference (error)
///   Expression: `fullUrl.exists() implies fullUrl.contains('/_history/').not()`
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: bdl-11, bdl-12, bdl-13, bdl-14, bdl-15, bdl-2
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleEntry {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Links related to this entry
    ///
    /// A series of links that provide context to this entry.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub link: Option<Vec<BundleLink>>,
    /// URI for resource (e.g. the absolute URL server address, URI for UUID/OID, etc.)
    ///
    /// The Absolute URL for the resource. Except for transactions and batches, each
    /// entry in a Bundle must have a fullUrl. The fullUrl SHALL NOT disagree with
    /// the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall
    /// be version-independent URL consistent with the Resource.id. The fullUrl is a
    /// version independent reference to the resource. Even when not required,
    /// fullUrl MAY be set to a urn:uuid to allow referencing entries in a
    /// transaction. The fullUrl can be an arbitrary URI and is not limited to
    /// urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value
    /// unless:
    /// * the Bundle is a batch or transaction request or response AND
    /// * the entry is
    ///     * invoking a create
    /// * invoking or responding to an operation where the body is not a single
    ///   identified resource
    ///   * invoking or returning the results of a search or history operation.
    ///
    /// ## Implementation Notes
    /// fullUrl might not be [unique in the context of a
    /// resource](bundle.html#bundle-unique). Note that since [FHIR resources do not
    /// need to be served through the FHIR API](references.html), the fullURL might
    /// be a URN or an absolute URL that does not end with the logical id of the
    /// resource (Resource.id). However, if the fullUrl does look like a RESTful
    /// server URL (e.g. meets the [regex](references.html#regex), then the portion
    /// of the URL that, by FHIR syntax, corresponds to the resource type and id
    /// within the fullUrl SHALL match the resource type and id of the resource.
    ///
    /// Note that the fullUrl is not the same as the canonical URL - it's an absolute
    /// url for an endpoint serving the resource (these will happen to have the same
    /// value on the canonical server for the resource with the canonical URL).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-7, bdl-15, bdl-8
    #[fhir_serde(rename = "fullUrl")]
    pub full_url: Option<Uri>,
    /// A resource in the bundle
    ///
    /// The Resource for the entry. The purpose/meaning of the resource is determined
    /// by the Bundle.type. This is allowed to be a Parameters resource if and only
    /// if it is referenced by something else within the Bundle that provides
    /// context/meaning.
    ///
    /// ## Implementation Notes
    /// This may be a resource defined in the FHIR specification, or an [additional
    /// resource](resource.html#additional)
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Conditions
    /// Used when: bdl-3a, bdl-3b, bdl-3c, bdl-7, bdl-11, bdl-12, bdl-13, bdl-5
    pub resource: Option<Box<Resource>>,
    /// Search related information
    ///
    /// Information about the search process that lead to the creation of this entry.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-2
    pub search: Option<BundleEntrySearch>,
    /// Additional execution information (transaction/batch/history)
    ///
    /// Additional information about how this entry should be processed as part of a
    /// transaction or batch. For history, it shows how the entry was processed to
    /// create the version contained in the entry.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-3a, bdl-3b, bdl-5
    pub request: Option<BundleEntryRequest>,
    /// Results of execution (transaction/batch/history)
    ///
    /// Indicates the results of processing the corresponding 'request' entry in the
    /// batch or transaction being responded to or what the results of an operation
    /// where when returning history.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-3a, bdl-3b, bdl-3d, bdl-5
    pub response: Option<BundleEntryResponse>,
}

/// FHIR Bundle type
///
/// A container for a collection of resources.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/Resource
///
/// ## Status: active
/// FHIR Version: 6.0.0-ballot3
///
/// See: [Bundle](http://hl7.org/fhir/StructureDefinition/Bundle)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct Bundle {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Persistent identifier for the bundle
    ///
    /// A persistent identifier for the bundle that won't change as a bundle is
    /// copied from server to server.
    ///
    /// ## Implementation Notes
    /// Persistent identity generally only matters for batches of type Document,
    /// Message, and Collection. It would not normally be populated for search and
    /// history results and servers ignore Bundle.identifier when processing batches
    /// and transactions. For Documents the .identifier SHALL be populated such that
    /// the .identifier is globally unique.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-9
    pub identifier: Option<Identifier>,
    /// document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection | subscription-notification
    ///
    /// Indicates the purpose of this bundle - how it is intended to be used.
    ///
    /// ## Implementation Notes
    /// It's possible to use a bundle for other purposes (e.g. a document can be
    /// accepted as a transaction). This is primarily defined so that there can be
    /// specific rules for some of the bundle types.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicates the purpose of a bundle - how it is intended to be used.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/bundle-type|6.0.0-ballot3
    ///
    /// ## Conditions
    /// Used when: bdl-1, bdl-2, bdl-3a, bdl-3b, bdl-3c, bdl-3d, bdl-7, bdl-9, bdl-10, bdl-11, bdl-12, bdl-13, bdl-14, bdl-15, bdl-17, bdl-18
    #[fhir_serde(rename = "type")]
    pub r#type: Code,
    /// When the bundle was assembled
    ///
    /// The date/time that the bundle was assembled - i.e. when the resources were
    /// placed in the bundle.
    ///
    /// ## Implementation Notes
    /// For many bundles, the timestamp is equal to .meta.lastUpdated, because they
    /// are not stored (e.g. search results). When a bundle is placed in a persistent
    /// store, .meta.lastUpdated will be usually be changed by the server. When the
    /// bundle is a message, a middleware agent altering the message (even if not
    /// stored) SHOULD update .meta.lastUpdated. .timestamp is used to track the
    /// original time of the Bundle, and SHOULD be populated.
    ///
    /// Usage:
    ///
    /// * document : the date the document was created. Note: the composition may
    ///   predate the document, or be associated with multiple documents. The date of
    ///   the composition - the authoring time - may be earlier than the document
    ///   assembly time
    /// * message : the date that the content of the message was assembled. This date
    ///   is not changed by middleware engines unless they add additional data that
    ///   changes the meaning of the time of the message
    /// * history : the date that the history was assembled. This time would be used
    ///   as the _since time to ask for subsequent updates
    /// * searchset : the time that the search set was assembled. Note that different
    ///   pages MAY have different timestamps but need not. Having different
    ///   timestamps does not imply that subsequent pages will represent or include
    ///   changes made since the initial query
    /// * transaction | transaction-response | batch | batch-response | collection :
    ///   no particular assigned meaning
    ///
    /// The timestamp value should be greater than the lastUpdated and other
    /// timestamps in the resources in the bundle, and it should be equal or earlier
    /// than the .meta.lastUpdated on the Bundle itself.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-10
    pub timestamp: Option<Instant>,
    /// Total matches across all pages
    ///
    /// If a set of search matches or a history, this is the (potentially estimated)
    /// total number of entries of type 'match' across all pages in the search. It
    /// does not include search.mode = 'include' or 'outcome' entries and it does not
    /// provide a count of the number of entries in the Bundle.
    ///
    /// ## Implementation Notes
    /// Only used if the bundle is a search or history result set. The total does not
    /// include resources such as OperationOutcome and included resources, only the
    /// total number of matching resources.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-1
    pub total: Option<UnsignedInt>,
    /// Links related to this Bundle
    ///
    /// A series of links that provide context to this bundle.
    ///
    /// ## Implementation Notes
    /// Both Bundle.link and Bundle.entry.link are defined to support providing
    /// additional context when Bundles are used (e.g.
    /// [HATEOAS](http://en.wikipedia.org/wiki/HATEOAS)).
    ///
    /// Bundle.entry.link corresponds to links found in the HTTP header if the
    /// resource in the entry was [read](http.html#read) directly.
    ///
    /// This specification defines some specific uses of Bundle.link for
    /// [searching](search.html#conformance) and [paging](http.html#paging), but no
    /// specific uses for Bundle.entry.link, and no defined function in a transaction
    /// - the meaning is implementation specific. The behavior of navigation link
    /// types (next/prev/first/last) are well defined for searchset and history
    /// Bundles but are not currently defined for other types. Implementers who
    /// choose to use such link relationships for other bundle types will need to
    /// negotiate behavior with their interoperability partners.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-18
    pub link: Option<Vec<BundleLink>>,
    /// Entry in the bundle - will have a resource or information
    ///
    /// An entry in a bundle resource - will either contain a resource or information
    /// about a resource (transactions and history only).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    /// - Order meaning: For bundles of type 'document' and 'message', the first resource is special (must be Composition or MessageHeader respectively). For all bundles, the meaning of the order of entries depends on the bundle type
    ///
    /// ## Constraints
    /// - **bdl-5**: must be a resource unless there's a request or response (error)
    ///   Expression: `resource.exists() or request.exists() or response.exists()`
    /// - **bdl-8**: fullUrl cannot be a version specific reference (error)
    ///   Expression: `fullUrl.exists() implies fullUrl.contains('/_history/').not()`
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: bdl-11, bdl-12, bdl-13, bdl-14, bdl-15, bdl-2
    pub entry: Option<Vec<BundleEntry>>,
    /// Digital Signature (deprecated: use Provenance Signatures)
    ///
    /// Digital Signature: XML-DSig or JWS. This element is deprecated, and
    /// [Provenance based Signatures](signatures.html#Bundle) should be used instead.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub signature: Option<Signature>,
    /// OperationOutcome with issues about the Bundle
    ///
    /// An OperationOutcome that captures issues and warnings that relate to the
    /// construction of the Bundle and the content within it.
    ///
    /// ## Implementation Notes
    /// Usage notes: These issues and warnings must apply to the Bundle as a whole,
    /// not to individual entries. Messages relating to the processing of individual
    /// entries (e.g. in a batch or transaction) SHALL be reported in the
    /// entry.response.outcome for that entry. If there are errors that arise in the
    /// creation of the Bundle, then that should be handled by an OperationOutcome
    /// being returned instead of the Bundle.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Conditions
    /// Used when: bdl-16, bdl-17
    pub issues: Option<Box<Resource>>,
}

/// Search related information
///
/// Information about the search process that lead to the creation of this entry.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: bdl-2
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct BundleEntrySearch {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// match | include - why this is in the result set
    ///
    /// Why this entry is in the result set - whether it's included as a match or
    /// because of an _include requirement, or to convey information or warning
    /// information about the search process.
    ///
    /// ## Implementation Notes
    /// There is only one mode. In some corner cases, a resource may be included
    /// because it is both a match and an include. In these circumstances, 'match'
    /// takes precedence.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Why an entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/search-entry-mode|6.0.0-ballot3
    pub mode: Option<Code>,
    /// Search ranking (between 0 and 1)
    ///
    /// When searching, the server's search ranking score for the entry.
    ///
    /// ## Implementation Notes
    /// Servers are not required to return a ranking score. 1 is most relevant, and 0
    /// is least relevant. Often, search results are sorted by score, but the client
    /// may specify a different sort order.
    ///
    /// See [Patient Match](patient-operation-match.html) for the EMPI search which
    /// relates to this element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub score: Option<Decimal>,
}

/// Where messages should be sent
///
/// An endpoint (network accessible address) to which messages and/or replies are
/// to be sent.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Aliases
/// 3
///
/// ## Conditions
/// Used when: cpb-3
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementMessagingEndpoint {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// http | ftp | mllp +
    ///
    /// A list of the messaging transport protocol(s) identifiers, supported by this
    /// endpoint.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: The protocol used for message transport.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/message-transport
    pub protocol: Coding,
    /// Network address or identifier of the end-point
    ///
    /// The network address of the endpoint. For solutions that do not use network
    /// addresses for routing, it can be just an identifier.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub address: Url,
}

/// What operations are supported?
///
/// A specification of restful operations supported by the system.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestInteraction {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// transaction | batch | search-system | history-system
    ///
    /// A coded identifier of the operation, supported by the system.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Operations supported by REST at the system level.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/system-restful-interaction|6.0.0-ballot3
    pub code: Code,
    /// Anything special about operation behavior
    ///
    /// Guidance specific to the implementation of this operation, such as
    /// limitations on the kind of transactions allowed, or information about system
    /// wide search is implemented.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
}

/// Information about security of implementation
///
/// Information about security implementation from an interface perspective -
/// what a client needs to know.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestSecurity {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Adds CORS Headers (http://enable-cors.org/)
    ///
    /// Server adds CORS headers when responding to requests - this enables
    /// Javascript applications to use the server.
    ///
    /// ## Implementation Notes
    /// The easiest CORS headers to add are Access-Control-Allow-Origin: * &
    /// Access-Control-Request-Method: GET, POST, PUT, DELETE. All servers SHOULD
    /// support CORS.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub cors: Option<Boolean>,
    /// OAuth | SMART-on-FHIR | NTLM | Basic | Kerberos | Certificates
    ///
    /// Types of security services that are supported/required by the system.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Types of security services used with FHIR.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/restful-security-service
    pub service: Option<Vec<CodeableConcept>>,
    /// General description of how security works
    ///
    /// General description of how security works.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<Markdown>,
}

/// If the endpoint is a RESTful one
///
/// A definition of the restful capabilities of the solution, if any.
///
/// ## Implementation Notes
/// Multiple repetitions allow definition of both client and/or server behaviors
/// or possibly behaviors under different configuration settings (for software or
/// requirements statements).
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **cpb-9**: A given resource can only be described once per RESTful mode. (error)
///   Expression: `resource.select(type).isDistinct()`
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-4, cpb-1
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRest {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// client | server
    ///
    /// Identifies whether this portion of the statement is describing the ability to
    /// initiate or receive restful operations.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The mode of a RESTful capability statement.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/restful-capability-mode|6.0.0-ballot3
    ///
    /// ## Conditions
    /// Used when: cpb-4
    pub mode: Code,
    /// General description of implementation
    ///
    /// Information about the system's restful capabilities that apply across all
    /// applications, such as security.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
    /// Information about security of implementation
    ///
    /// Information about security implementation from an interface perspective -
    /// what a client needs to know.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub security: Option<CapabilityStatementRestSecurity>,
    /// Resource served on the REST interface
    ///
    /// A specification of the restful capabilities of the solution for a specific
    /// resource type.
    ///
    /// ## Implementation Notes
    /// Max of one repetition per resource type.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **cpb-12**: Search parameter names must be unique in the context of a resource. (error)
    ///   Expression: `searchParam.select(name).isDistinct()`
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-9
    pub resource: Option<Vec<CapabilityStatementRestResource>>,
    /// What operations are supported?
    ///
    /// A specification of restful operations supported by the system.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub interaction: Option<Vec<CapabilityStatementRestInteraction>>,
    /// Search parameters for searching all resources
    ///
    /// Search parameters that are supported for searching all resources for
    /// implementations to support and/or make use of - either references to ones
    /// defined in the specification, or additional ones defined for/by the
    /// implementation. This is only for searches executed against the system-level
    /// endpoint.
    ///
    /// ## Implementation Notes
    /// Typically, the only search parameters supported for all searches are those
    /// that apply to all resources - tags, profiles, text search etc. These search
    /// parameters should include the control search parameters such as _sort,
    /// _count, etc. that also apply to this resource (though many will be listed at
    /// [CapabilityStatement.rest.searchParam](capabilitystatement-definitions.html#CapabilityStatement.rest.searchParam)).
    /// The behavior of some search parameters may be further described by other code
    /// or extension elements, or narrative within the capability statement or linked
    /// [SearchParameter](searchparameter.html#) definitions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "searchParam")]
    pub search_param: Option<Vec<CapabilityStatementRestResourceSearchParam>>,
    /// Definition of a system level operation
    ///
    /// Definition of an operation or a named query together with its parameters and
    /// their meaning and type.
    ///
    /// ## Implementation Notes
    /// CapabilityStatement.rest.operation is for operations invoked at the system
    /// level, or for operations that are supported across multiple resource types.
    /// Operations linked from CapabilityStatement.rest.operation must have
    /// OperationDefinition.system = true, or more than one Operation.resource.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub operation: Option<Vec<CapabilityStatementRestResourceOperation>>,
    /// Compartments served/used by system
    ///
    /// An absolute URI which is a reference to the definition of a compartment that
    /// the system supports. The reference is to a CompartmentDefinition resource by
    /// its canonical URL .
    ///
    /// ## Implementation Notes
    /// At present, the only defined compartments are at
    /// [CompartmentDefinition](compartmentdefinition.html).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub compartment: Option<Vec<Canonical>>,
}

/// If messaging is supported
///
/// A description of the messaging capabilities of the solution.
///
/// ## Implementation Notes
/// Multiple repetitions allow the documentation of multiple endpoints per
/// solution.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-1
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementMessaging {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Where messages should be sent
    ///
    /// An endpoint (network accessible address) to which messages and/or replies are
    /// to be sent.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// 3
    ///
    /// ## Conditions
    /// Used when: cpb-3
    pub endpoint: Option<Vec<CapabilityStatementMessagingEndpoint>>,
    /// Reliable Message Cache Length (min)
    ///
    /// Length if the receiver's reliable messaging cache in minutes (if a receiver)
    /// or how long the cache length on the receiver should be (if a sender).
    ///
    /// ## Implementation Notes
    /// If this value is missing then the application does not implement (receiver)
    /// or depend on (sender) reliable messaging.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "reliableCache")]
    pub reliable_cache: Option<UnsignedInt>,
    /// Messaging interface behavior details
    ///
    /// Documentation about the system's messaging capabilities for this endpoint not
    /// otherwise documented by the capability statement. For example, the process
    /// for becoming an authorized messaging exchange partner.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
    /// Messages supported by this system
    ///
    /// References to message definitions for messages this system can send or
    /// receive.
    ///
    /// ## Implementation Notes
    /// This is a proposed alternative to the messaging.event structure.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportedMessage")]
    pub supported_message: Option<Vec<CapabilityStatementMessagingSupportedMessage>>,
}

/// If this describes a specific instance
///
/// Identifies a specific implementation instance that is described by the
/// capability statement - i.e. a particular installation, rather than the
/// capabilities of a software program.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-16, cpb-15, cpb-14, cpb-2
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementImplementation {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Describes this specific instance
    ///
    /// Information about the specific installation that this capability statement
    /// relates to.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Markdown,
    /// Base URL for the installation
    ///
    /// An absolute base URL for the implementation. This forms the base for REST
    /// interfaces as well as the mailbox and document interfaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Option<Url>,
    /// Organization that manages the data
    ///
    /// The organization responsible for the management of the instance and oversight
    /// of the data on the server at the specified URL.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub custodian: Option<Reference>,
}

/// What operations are supported?
///
/// Identifies a restful operation supported by the solution.
///
/// ## Implementation Notes
/// In general, a Resource will only appear in a CapabilityStatement if the
/// server actually has some capabilities - e.g. there is at least one
/// interaction supported. However interactions can be omitted to support
/// summarization (_summary = true).
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestResourceInteraction {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// read | vread | update | update-conditional | patch | patch-conditional | delete | delete-conditional-single | delete-conditional-multiple | delete-history | delete-history-version | history-instance | history-type | create | create-conditional | search-type
    ///
    /// Coded identifier of the operation, supported by the system resource.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Operations supported by REST at the type or instance level.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/type-restful-interaction|6.0.0-ballot3
    pub code: Code,
    /// Anything special about operation behavior
    ///
    /// Guidance specific to the implementation of this operation, such as 'delete is
    /// a logical delete' or 'updates are only allowed with version id' or 'creates
    /// permitted from pre-authorized certificates only'.
    ///
    /// ## Requirements
    /// REST allows a degree of variability in the implementation of RESTful
    /// solutions that is useful for exchange partners to be aware of.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
}

/// Software that is covered by this capability statement
///
/// Software that is covered by this capability statement. It is used when the
/// capability statement describes the capabilities of a particular software
/// version, independent of an installation.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-16, cpb-15, cpb-2
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementSoftware {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// A name the software is known by
    ///
    /// Name the software is known by.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub name: String,
    /// Version covered by this statement
    ///
    /// The version identifier for the software covered by this statement.
    ///
    /// ## Implementation Notes
    /// If possible, a version should be specified, as statements are likely to be
    /// different for different versions of software.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub version: Option<String>,
    /// Date this version was released
    ///
    /// Date this version of the software was released.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "releaseDate")]
    pub release_date: Option<DateTime>,
}

/// Search parameters supported by implementation
///
/// Search parameters for implementations to support and/or make use of - either
/// references to ones defined in the specification, or additional ones defined
/// for/by the implementation.
///
/// ## Implementation Notes
/// The search parameters should include the control search parameters such as
/// _sort, _count, etc. that also apply to this resource (though many will be
/// listed at
/// [CapabilityStatement.rest.searchParam](capabilitystatement-definitions.html#CapabilityStatement.rest.searchParam)).
/// The behavior of some search parameters may be further described by other code
/// or extension elements, or narrative within the capability statement or linked
/// [SearchParameter](searchparameter.html#) definitions.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-12
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestResourceSearchParam {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Name for parameter in search url
    ///
    /// The label used for the search parameter in this particular system's API -
    /// i.e. the 'name' portion of the name-value pair that will appear as part of
    /// the search URL. This SHOULD be the same as the SearchParameter.code of the
    /// defining SearchParameter. However, it can sometimes differ if necessary to
    /// disambiguate when a server supports multiple SearchParameters that happen to
    /// share the same code.
    ///
    /// ## Implementation Notes
    /// Parameter names cannot overlap with standard parameter names, and standard
    /// parameters cannot be redefined. There is no correspondence whatsoever between
    /// CapabilityStatement's searchParam.name and SearchParameter.name - the latter
    /// is used as a class name when generating code for the search parameter.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-12
    pub name: String,
    /// Source of definition for parameter
    ///
    /// An absolute URI that is a formal reference to where this parameter was first
    /// defined, so that a client can be confident of the meaning of the search
    /// parameter (a reference to
    /// [SearchParameter.url](searchparameter-definitions.html#SearchParameter.url)).
    /// This element SHALL be populated if the search parameter refers to a
    /// SearchParameter defined by the FHIR core specification or externally defined
    /// IGs.
    ///
    /// ## Implementation Notes
    /// This SHOULD be present, and matches refers to a SearchParameter by its
    /// canonical URL. If systems wish to document their support for modifiers,
    /// comparators, target resource types, and chained parameters, they should do
    /// using a search parameter resource. This element SHALL be populated if the
    /// search parameter refers to a SearchParameter defined by the FHIR core
    /// specification or externally defined IGs.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub definition: Option<Canonical>,
    /// number | date | string | token | reference | composite | quantity | uri | special | resource
    ///
    /// The type of value a search parameter refers to, and how the content is
    /// interpreted.
    ///
    /// ## Implementation Notes
    /// While this can be looked up from the definition, it is included here as a
    /// convenience for systems that autogenerate a query interface based on the
    /// server capability statement. It SHALL be the same as the type in the search
    /// parameter definition.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Data types allowed to be used for search parameters.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/search-param-type|6.0.0-ballot3
    #[fhir_serde(rename = "type")]
    pub r#type: Code,
    /// Server-specific usage
    ///
    /// This allows documentation of any distinct behaviors about how the search
    /// parameter is used. For example, text matching algorithms.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
}

/// Definition of a resource operation
///
/// Definition of an operation or a named query together with its parameters and
/// their meaning and type. Consult the definition of the operation for details
/// about how to invoke the operation, and the parameters.
///
/// ## Implementation Notes
/// Operations linked from CapabilityStatement.rest.resource.operation must have
/// OperationDefinition.type = true or OperationDefinition.instance = true.
///
/// If an operation that is listed in multiple
/// CapabilityStatement.rest.resource.operation (e.g. for different resource
/// types), then clients should understand that the operation is only supported
/// on the specified resource types, and that may be a subset of those listed in
/// OperationDefinition.resource.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestResourceOperation {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Name by which the operation/query is invoked
    ///
    /// The name of the operation or query. For an operation, this name is prefixed
    /// with $ and used in the URL. For a query, this is the name used in the _query
    /// parameter when the query is called. This SHOULD be the same as the
    /// OperationDefinition.code of the defining OperationDefinition. However, it can
    /// sometimes differ if necessary to disambiguate when a server supports multiple
    /// OperationDefinition that happen to share the same code.
    ///
    /// ## Implementation Notes
    /// The name here SHOULD be the same as the OperationDefinition.code in the
    /// referenced OperationDefinition, unless there is a name clash and the
    /// OperationDefinition.code cannot be used. The name does not include the "$"
    /// portion that is always included in the URL. There is no correspondence
    /// whatsoever between CapabilityStatement's operation.name and
    /// OperationDefinition.name - the latter is used as a class name when generating
    /// code for the operation. HL7 will never define operations that have
    /// conflicting names.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub name: String,
    /// The defined operation/query
    ///
    /// Where the formal definition can be found. If a server references the base
    /// definition of an Operation (i.e. from the specification itself such as
    /// ```http://hl7.org/fhir/OperationDefinition/ValueSet-expand```), that means it
    /// supports the full capabilities of the operation - e.g. both GET and POST
    /// invocation. If it only supports a subset, it must define its own custom
    /// [OperationDefinition](operationdefinition.html#) with a 'base' of the
    /// original OperationDefinition. The custom definition would describe the
    /// specific subset of functionality supported.
    ///
    /// ## Implementation Notes
    /// This can be used to build an HTML form to invoke the operation, for instance.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub definition: Canonical,
    /// Specific details about operation behavior
    ///
    /// Documentation that describes anything special about the operation behavior,
    /// possibly detailing different behavior for system, type and instance-level
    /// invocation of the operation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
}

/// Document definition
///
/// A document definition.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-7, cpb-1
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementDocument {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// producer | consumer
    ///
    /// Mode of this document declaration - whether an application is a producer or
    /// consumer.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Whether the application produces or consumes documents.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/document-mode|6.0.0-ballot3
    ///
    /// ## Conditions
    /// Used when: cpb-7
    pub mode: Code,
    /// Description of document support
    ///
    /// A description of how the application supports or uses the specified document
    /// profile. For example, when documents are created, what action is taken with
    /// consumed documents, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
    /// Constraint on the resources used in the document
    ///
    /// A profile on the document Bundle that constrains which resources are present,
    /// and their contents.
    ///
    /// ## Implementation Notes
    /// The profile is actually on the Bundle.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-7
    pub profile: Canonical,
}

/// Resource served on the REST interface
///
/// A specification of the restful capabilities of the solution for a specific
/// resource type.
///
/// ## Implementation Notes
/// Max of one repetition per resource type.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **cpb-12**: Search parameter names must be unique in the context of a resource. (error)
///   Expression: `searchParam.select(name).isDistinct()`
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
///
/// ## Conditions
/// Used when: cpb-9
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementRestResource {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// A resource type that is supported
    ///
    /// A type of resource exposed via the restful interface, either a resource
    /// defined in this specification, or an [additional
    /// resource](resource.html#additional).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: One of the resource types defined as part of this version of FHIR. Note that this includes additional resources, and is not a fixed list
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/extended-resource-types|6.0.0-ballot3
    ///
    /// ## Conditions
    /// Used when: cpb-9
    #[fhir_serde(rename = "type")]
    pub r#type: Code,
    /// The definition for an additional resource
    ///
    /// The definition of the resource, if the resource is an additional resource. If
    /// it is not an additional resource, then this element must not be present.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub definition: Option<Canonical>,
    /// System-wide profile
    ///
    /// A system-wide profile that is applied across *all* instances of the resource
    /// supported by the system. For example, if declared on Observation, this
    /// profile is the "superset" of capabilities for laboratory *and* vitals *and*
    /// other domains. See further discussion in [Using
    /// Profiles](profiling.html#profile-uses).
    ///
    /// ## Implementation Notes
    /// All other profiles for this type that are listed in
    /// `.rest.resource.supportedProfile` must conform to this profile.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub profile: Option<Canonical>,
    /// Use-case specific profiles
    ///
    /// A list of profiles representing different use cases the system
    /// hosts/produces. A supported profile is a statement about the functionality of
    /// the data and services provided by the server (or the client) for supported
    /// use cases. For example, a system can define and declare multiple Observation
    /// profiles for laboratory observations, vital sign observations, etc. By
    /// declaring supported profiles, systems provide a way to determine whether
    /// individual resources are conformant. See further discussion in [Using
    /// Profiles](profiling.html#profile-uses).
    ///
    /// ## Implementation Notes
    /// Supported profiles must conform to the resource profile in the
    /// `.rest.resource.profile` element if it is present. The resource profile is a
    /// system-wide profile applied across *all* instances of the resource supported
    /// by the system. A supported profile is a statement about the functionality of
    /// the data and services provided by the server (or used by the client) for a
    /// particular set of use cases and will not necessarily apply to all data
    /// consumed or exposed by the server.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportedProfile")]
    pub supported_profile: Option<Vec<Canonical>>,
    /// Additional information about the use of the resource type
    ///
    /// Additional information about the resource type used by the system.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub documentation: Option<Markdown>,
    /// What operations are supported?
    ///
    /// Identifies a restful operation supported by the solution.
    ///
    /// ## Implementation Notes
    /// In general, a Resource will only appear in a CapabilityStatement if the
    /// server actually has some capabilities - e.g. there is at least one
    /// interaction supported. However interactions can be omitted to support
    /// summarization (_summary = true).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub interaction: Option<Vec<CapabilityStatementRestResourceInteraction>>,
    /// no-version | versioned | versioned-update
    ///
    /// This field is set to no-version to specify that the system does not support
    /// (server) or use (client) versioning for this resource type. If this has some
    /// other value, the server must at least correctly track and populate the
    /// versionId meta-property on resources. If the value is 'versioned-update',
    /// then the server supports all the versioning features, including using e-tags
    /// for version integrity in the API.
    ///
    /// ## Implementation Notes
    /// If a server supports versionIds correctly, it SHOULD support vread too, but
    /// is not required to do so.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: How the system supports versioning for a resource.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/versioning-policy|6.0.0-ballot3
    pub versioning: Option<Code>,
    /// Whether vRead can return past versions
    ///
    /// A flag for whether the server is able to return past versions as part of the
    /// vRead operation.
    ///
    /// ## Implementation Notes
    /// It is useful to support the vRead operation for current operations, even if
    /// past versions aren't available.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "readHistory")]
    pub read_history: Option<Boolean>,
    /// If update can commit to a new identity
    ///
    /// A flag to indicate that the server allows or needs to allow the client to
    /// create new identities on the server (that is, the client PUTs to a location
    /// where there is no existing resource). Allowing this operation means that the
    /// server allows the client to create new identities on the server.
    ///
    /// ## Implementation Notes
    /// Allowing the clients to create new identities on the server means that the
    /// system administrator needs to have confidence that the clients do not create
    /// clashing identities between them. Obviously, if there is only one client,
    /// this won't happen. While creating identities on the client means that the
    /// clients need to be managed, it's much more convenient for many scenarios if
    /// such management can be put in place.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "updateCreate")]
    pub update_create: Option<Boolean>,
    /// If allows/uses conditional create
    ///
    /// A flag that indicates that the server supports conditional create.
    ///
    /// ## Implementation Notes
    /// Conditional Create is mainly appropriate for interface engine scripts
    /// converting from other formats, such as v2.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "conditionalCreate")]
    pub conditional_create: Option<Boolean>,
    /// not-supported | modified-since | not-match | full-support
    ///
    /// A code that indicates how the server supports conditional read.
    ///
    /// ## Implementation Notes
    /// Conditional Read is mainly appropriate for interface engine scripts
    /// converting from other formats, such as v2.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: A code that indicates how the server supports conditional read.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/conditional-read-status|6.0.0-ballot3
    #[fhir_serde(rename = "conditionalRead")]
    pub conditional_read: Option<Code>,
    /// If allows/uses conditional update
    ///
    /// A flag that indicates that the server supports conditional update.
    ///
    /// ## Implementation Notes
    /// Conditional Update is mainly appropriate for interface engine scripts
    /// converting from other formats, such as v2.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "conditionalUpdate")]
    pub conditional_update: Option<Boolean>,
    /// If allows/uses conditional patch
    ///
    /// A flag that indicates that the server supports conditional patch.
    ///
    /// ## Implementation Notes
    /// Conditional Patch is mainly appropriate for interface engine scripts
    /// converting from other formats, such as v2.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "conditionalPatch")]
    pub conditional_patch: Option<Boolean>,
    /// not-supported | single | multiple - how conditional delete is supported
    ///
    /// A code that indicates how the server supports conditional delete.
    ///
    /// ## Implementation Notes
    /// Conditional Delete is mainly appropriate for interface engine scripts
    /// converting from other formats, such as v2.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: A code that indicates how the server supports conditional delete.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/conditional-delete-status|6.0.0-ballot3
    #[fhir_serde(rename = "conditionalDelete")]
    pub conditional_delete: Option<Code>,
    /// literal | logical | resolves | enforced | local
    ///
    /// A set of flags that defines how references are supported.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: A set of flags that defines how references are supported.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/reference-handling-policy|6.0.0-ballot3
    #[fhir_serde(rename = "referencePolicy")]
    pub reference_policy: Option<Vec<Code>>,
    /// _include values supported by the server
    ///
    /// A list of _include values supported by the server.
    ///
    /// ## Implementation Notes
    /// Documenting [`_include`](http://hl7.org/fhir/R5/search.html#revinclude)
    /// support helps set conformance expectations for the desired system. Still, it
    /// is a level of detail that might not be exposed by production servers or
    /// clients when using CapabilityStatement to describe an actual implementation.
    /// If this list is empty, the server does not support includes. Support for
    /// *iterative* (a.k.a., recursive) `_include` is communicated by listing the
    /// iterative includes values supported by the server in the `searchInclude`
    /// element of the "root" resource type. For example, to support the following
    /// search:
    ///
    /// `GET
    /// [base]/CarePlan?_include=CarePlan:activity-reference:DeviceRequest&_include:iterate=DeviceRequest:device`
    ///
    /// These values would be listed as part of capabilities for "CarePlan":
    ///
    /// "searchInclude" :
    /// ["CarePlan:activity-reference:DeviceRequest","DeviceRequest:device"],
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "searchInclude")]
    pub search_include: Option<Vec<String>>,
    /// _revinclude values supported by the server
    ///
    /// A list of _revinclude (reverse include) values supported by the server.
    ///
    /// ## Implementation Notes
    /// See `CapabilityStatement.rest.resource.searchInclude` comments.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "searchRevInclude")]
    pub search_rev_include: Option<Vec<String>>,
    /// Search parameters supported by implementation
    ///
    /// Search parameters for implementations to support and/or make use of - either
    /// references to ones defined in the specification, or additional ones defined
    /// for/by the implementation.
    ///
    /// ## Implementation Notes
    /// The search parameters should include the control search parameters such as
    /// _sort, _count, etc. that also apply to this resource (though many will be
    /// listed at
    /// [CapabilityStatement.rest.searchParam](capabilitystatement-definitions.html#CapabilityStatement.rest.searchParam)).
    /// The behavior of some search parameters may be further described by other code
    /// or extension elements, or narrative within the capability statement or linked
    /// [SearchParameter](searchparameter.html#) definitions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-12
    #[fhir_serde(rename = "searchParam")]
    pub search_param: Option<Vec<CapabilityStatementRestResourceSearchParam>>,
    /// Definition of a resource operation
    ///
    /// Definition of an operation or a named query together with its parameters and
    /// their meaning and type. Consult the definition of the operation for details
    /// about how to invoke the operation, and the parameters.
    ///
    /// ## Implementation Notes
    /// Operations linked from CapabilityStatement.rest.resource.operation must have
    /// OperationDefinition.type = true or OperationDefinition.instance = true.
    ///
    /// If an operation that is listed in multiple
    /// CapabilityStatement.rest.resource.operation (e.g. for different resource
    /// types), then clients should understand that the operation is only supported
    /// on the specified resource types, and that may be a subset of those listed in
    /// OperationDefinition.resource.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub operation: Option<Vec<CapabilityStatementRestResourceOperation>>,
}

/// Messages supported by this system
///
/// References to message definitions for messages this system can send or
/// receive.
///
/// ## Implementation Notes
/// This is a proposed alternative to the messaging.event structure.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Special Semantics
/// - Included in summary
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CapabilityStatementMessagingSupportedMessage {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// sender | receiver
    ///
    /// The mode of this event declaration - whether application is sender or
    /// receiver.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The mode of a message capability statement.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/event-capability-mode|6.0.0-ballot3
    pub mode: Code,
    /// Message supported by this system
    ///
    /// Points to a message definition that identifies the messaging event, message
    /// structure, allowed responses, etc.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub definition: Canonical,
}

/// Choice of types for the versionAlgorithm\[x\] field in CapabilityStatement
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "versionAlgorithm")]
pub enum CapabilityStatementVersionAlgorithm {
    /// Variant accepting the String type.
    #[fhir_serde(rename = "versionAlgorithmString")]
    String(String),
    /// Variant accepting the Coding type.
    #[fhir_serde(rename = "versionAlgorithmCoding")]
    Coding(Coding),
}

/// FHIR CapabilityStatement type
///
/// A Capability Statement documents a set of capabilities (behaviors) of a FHIR
/// Server or Client for a particular version of FHIR that may be used as a
/// statement of actual server functionality or a statement of required or
/// desired server implementation.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: active
/// FHIR Version: 6.0.0-ballot3
///
/// See: [CapabilityStatement](http://hl7.org/fhir/StructureDefinition/CapabilityStatement)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "versionAlgorithm")]
pub struct CapabilityStatement {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Canonical identifier for this capability statement, represented as a URI (globally unique)
    ///
    /// An absolute URI that is used to identify this capability statement when it is
    /// referenced in a specification, model, design or an instance; also called its
    /// canonical identifier. This SHOULD be globally unique and SHOULD be a literal
    /// address at which an authoritative instance of this capability statement is
    /// (or will be) published. This URL can be the target of a canonical reference.
    /// It SHALL remain the same when the capability statement is stored on different
    /// servers.
    ///
    /// ## Requirements
    /// Allows the capability statement to be referenced by a single globally unique
    /// identifier.
    ///
    /// ## Implementation Notes
    /// Can be a urn:uuid: or a urn:oid: but real http: addresses are preferred.
    /// Multiple instances may share the same URL if they have a distinct version.
    ///
    /// The determination of when to create a new version of a resource (same url,
    /// new version) vs. defining a new artifact is up to the author. Considerations
    /// for making this decision are found in [Technical and Business
    /// Versions](resource.html#versions).
    ///
    /// In some cases, the resource can no longer be found at the stated url, but the
    /// url itself cannot change. Implementations can use the
    /// [meta.source](resource.html#meta) element to indicate where the current
    /// master source of the resource can be found.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **cnl-1**: URL should not contain | or # - these characters make processing canonical references problematic (warning)
    ///   Expression: `exists() implies matches('^[^|# ]+$')`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Option<Uri>,
    /// Additional identifier for the CapabilityStatement (business identifier)
    ///
    /// A formal identifier that is used to identify this CapabilityStatement when it
    /// is represented in other formats, or referenced in a specification, model,
    /// design or an instance.
    ///
    /// ## Requirements
    /// Allows externally provided and/or usable business identifiers to be easily
    /// associated with the module.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Business version of the capability statement
    ///
    /// The identifier that is used to identify this version of the capability
    /// statement when it is referenced in a specification, model, design or
    /// instance. This is an arbitrary value managed by the capability statement
    /// author and is not expected to be globally unique. For example, it might be a
    /// timestamp (e.g. yyyymmdd) if a managed version is not available. There is
    /// also no expectation that versions can be placed in a lexicographical
    /// sequence.
    ///
    /// ## Implementation Notes
    /// There may be different capability statement instances that have the same
    /// identifier but different versions. The version can be appended to the url in
    /// a reference to allow a reference to a particular business version of the
    /// capability statement with the format [url]|[version]. The version SHOULD NOT
    /// contain a '#' - see [Business Version](resource.html#bv-format).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub version: Option<String>,
    /// How to compare versions
    ///
    /// Indicates the mechanism used to compare versions to determine which is more
    /// current.
    ///
    /// ## Implementation Notes
    /// If set as a string, this is a FHIRPath expression that has two additional
    /// context variables passed in - %version1 and %version2 and will return a
    /// negative number if version1 is newer, a positive number if version2 and a 0
    /// if the version ordering can't be successfully be determined.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/version-algorithm
    #[fhir_serde(flatten)]
    pub version_algorithm: Option<CapabilityStatementVersionAlgorithm>,
    /// Name for this capability statement (computer friendly)
    ///
    /// A natural language name identifying the capability statement. This name
    /// should be usable as an identifier for the module by machine processing
    /// applications such as code generation.
    ///
    /// ## Requirements
    /// Support human navigation and code generation.
    ///
    /// ## Implementation Notes
    /// The name is not expected to be globally unique. The name should be a simple
    /// alphanumeric type name to ensure that it is machine-processing friendly.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cnl-0
    pub name: Option<String>,
    /// Name for this capability statement (human friendly)
    ///
    /// A short, descriptive, user-friendly title for the capability statement.
    ///
    /// ## Implementation Notes
    /// This name does not need to be machine-processing friendly and may contain
    /// punctuation, white-space, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// draft | active | retired | unknown
    ///
    /// The status of this capability statement. Enables tracking the life-cycle of
    /// the content.
    ///
    /// ## Implementation Notes
    /// Allows filtering of capability statements that are appropriate for use versus
    /// not.This is not intended for use with actual capability statements, but where
    /// capability statements are used to describe possible or desired systems.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This is labeled as "Is Modifier" because applications should not use a retired {{title}} without due consideration
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|6.0.0-ballot3
    pub status: Code,
    /// For testing only - never for real usage
    ///
    /// A Boolean value to indicate that this capability statement is authored for
    /// testing purposes (or education/evaluation/marketing) and no version of this
    /// resource will ever be intended for genuine usage.
    ///
    /// ## Requirements
    /// Enables experimental content to be developed following the same lifecycle
    /// that would be used for a production-level capability statement.
    ///
    /// ## Implementation Notes
    /// Allows filtering of capability statements that are appropriate for use versus
    /// not.. Experimental resources might include example instances in
    /// implementation guides, instances created solely for testing purposes, etc. If
    /// experimental is 'true' for any version of a resource, it should be true for
    /// all versions of the resource. (If experimental changes, then it is being
    /// misused or a resource that was never intended for real-world use has
    /// unexpectedly changed its purpose.).
    ///
    /// Experimental resources are not expected to be stable and may well have
    /// breaking changes without a corresponding change to the 'version' element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    /// - When missing: If absent, this resource is treated as though it is not experimental.
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub experimental: Option<Boolean>,
    /// Date last changed
    ///
    /// The date (and optionally time) when the capability statement was last
    /// significantly changed. The date must change when the business version changes
    /// and it must change if the status code changes. In addition, it should change
    /// when the substantive content of the capability statement changes.
    ///
    /// ## Implementation Notes
    /// The date is often not tracked until the resource is published, but may be
    /// present on draft content. Note that this is not the same as the resource
    /// last-modified-date, since the resource may be a secondary representation of
    /// the capability statement. Additional specific dates may be added as
    /// extensions or be found by consulting Provenances associated with past
    /// versions of the resource.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Revision Date
    pub date: DateTime,
    /// Name of the publisher/steward (organization or individual)
    ///
    /// The name of the organization or individual responsible for the release and
    /// ongoing maintenance of the capability statement.
    ///
    /// ## Requirements
    /// Helps establish the "authority/credibility" of the capability statement. May
    /// also allow for contact.
    ///
    /// ## Implementation Notes
    /// Usually an organization but may be an individual. The publisher (or steward)
    /// of the capability statement is the organization or individual primarily
    /// responsible for the maintenance and upkeep of the capability statement. This
    /// is not necessarily the same individual or organization that developed and
    /// initially authored the content. The publisher is the primary point of contact
    /// for questions or issues with the capability statement. This item SHOULD be
    /// populated unless the information is available from context.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub publisher: Option<String>,
    /// Contact details for the publisher
    ///
    /// Contact details to assist a user in finding and communicating with the
    /// publisher.
    ///
    /// ## Implementation Notes
    /// May be a web site, an email address, a telephone number, etc.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contact: Option<Vec<ContactDetail>>,
    /// Natural language description of the capability statement
    ///
    /// A free text natural language description of the capability statement from a
    /// consumer's perspective. Typically, this is used when the capability statement
    /// describes a desired rather than an actual solution, for example as a formal
    /// expression of requirements as part of an RFP.
    ///
    /// ## Implementation Notes
    /// This description can be used to capture details such as comments about
    /// misuse, instructions for clinical use and interpretation, literature
    /// references, examples from the paper world, etc. It is not a rendering of the
    /// capability statement as conveyed in the 'text' field of the resource itself.
    /// This item SHOULD be populated unless the information is available from
    /// context (e.g. the language of the capability statement is presumed to be the
    /// predominant language in the place the capability statement was created).This
    /// does not need to be populated if the description is adequately implied by the
    /// software or implementation details.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-2
    pub description: Option<Markdown>,
    /// The context that the content is intended to support
    ///
    /// The content was developed with a focus and intent of supporting the contexts
    /// that are listed. These contexts may be general categories (gender, age, ...)
    /// or may be references to specific programs (insurance plans, studies, ...) and
    /// may be used to assist with indexing and searching for appropriate capability
    /// statement instances.
    ///
    /// ## Requirements
    /// Assist in searching for appropriate content.
    ///
    /// ## Implementation Notes
    /// When multiple useContexts are specified, there is no expectation that all or
    /// any of the contexts apply.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "useContext")]
    pub use_context: Option<Vec<UsageContext>>,
    /// ActorDefinitions the CapabilityStatement supports
    ///
    /// ActorDefinitions to describe the specific sets of functionality supported by
    /// (or that should be supported by) systems (via obligations).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "actorDefinition")]
    pub actor_definition: Option<Vec<Canonical>>,
    /// Jurisdiction of the authority that maintains the capability statement (if applicable)
    ///
    /// A legal or geographic region in which the authority that maintains the
    /// resource is operating. In general, the jurisdiction is also found in the
    /// useContext. The useContext may reference additional jurisdictions because the
    /// defining jurisdiction does not necessarily limit the jurisdictions of use.
    ///
    /// ## Implementation Notes
    /// It may be possible for the capability statement to be used in jurisdictions
    /// other than those for which it was originally designed or intended.
    ///
    /// DEPRECATION NOTE: For consistency, implementations are encouraged to migrate
    /// to using the new 'jurisdiction' code in the useContext element. (I.e.
    /// useContext.code indicating
    /// http://terminology.hl7.org/CodeSystem/usage-context-type#jurisdiction and
    /// useContext.valueCodeableConcept indicating the jurisdiction.)
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Countries and regions within which this artifact is targeted for use.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/jurisdiction
    pub jurisdiction: Option<Vec<CodeableConcept>>,
    /// Why this capability statement is defined
    ///
    /// Explanation of why this capability statement is needed and why it has been
    /// designed as it has.
    ///
    /// ## Implementation Notes
    /// This element does not describe the usage of the capability statement.
    /// Instead, it provides traceability of ''why'' the resource is either needed or
    /// ''why'' it is defined as it is. This may be used to point to source materials
    /// or specifications that drove the structure of this capability statement.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub purpose: Option<Markdown>,
    /// Use and/or publishing restrictions
    ///
    /// A copyright statement relating to the capability statement and/or its
    /// contents. Copyright statements are generally legal restrictions on the use
    /// and publishing of the capability statement.
    ///
    /// ## Requirements
    /// Consumers must be able to determine any legal restrictions on the use of the
    /// capability statement and/or its content.
    ///
    /// ## Implementation Notes
    /// ...
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// License, Restrictions
    pub copyright: Option<Markdown>,
    /// Copyright holder and year(s)
    ///
    /// A short string (<50 characters), suitable for inclusion in a page footer that
    /// identifies the copyright holder, effective period, and optionally whether
    /// rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').
    ///
    /// ## Requirements
    /// Defines the content expected to be rendered in all representations of the
    /// artifact.
    ///
    /// ## Implementation Notes
    /// The (c) symbol should NOT be included in this string. It will be added by
    /// software when rendering the notation. Full details about licensing,
    /// restrictions, warrantees, etc. goes in the more general 'copyright' element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "copyrightLabel")]
    pub copyright_label: Option<String>,
    /// instance | capability | requirements
    ///
    /// The way that this statement is intended to be used, to describe an actual
    /// running instance of software, a particular product (kind, not instance of
    /// software) or a class of implementation (e.g. a desired purchase).
    ///
    /// ## Requirements
    /// Allow searching the 3 modes.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: How a capability statement is intended to be used.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/capability-statement-kind|6.0.0-ballot3
    ///
    /// ## Conditions
    /// Used when: cpb-16, cpb-15, cpb-3, cpb-14
    pub kind: Code,
    /// Canonical URL of another capability statement this implements
    ///
    /// Reference to a canonical URL of another CapabilityStatement that this
    /// software implements. This capability statement is a published API description
    /// that corresponds to a business service. The server may actually implement a
    /// subset of the capability statement it claims to implement, so the capability
    /// statement must specify the full capability details.
    ///
    /// ## Implementation Notes
    /// HL7 defines the following Services: [Terminology
    /// Service](terminology-service.html).
    ///
    /// Many [Implementation Guides](http://fhir.org/guides/registry) define
    /// additional services.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub instantiates: Option<Vec<Canonical>>,
    /// Canonical URL of another capability statement this adds to
    ///
    /// Reference to a canonical URL of another CapabilityStatement that this
    /// software adds to. The capability statement automatically includes everything
    /// in the other statement, and it is not duplicated, though the server may
    /// repeat the same resources, interactions and operations to add additional
    /// details to them.
    ///
    /// ## Implementation Notes
    /// the contents of any directly or indirectly imported CapabilityStatements
    /// SHALL NOT overlap, i.e. they cannot refer to the same rest/resource,
    /// operations/name, searchparam/name, interaction/code, messaging/endpoint,
    /// document/mode pair.
    ///
    /// A capability statement that imports another CapabilityStatement automatically
    /// instantiates it too (though this is often not a very useful statement for the
    /// kinds of CapabilityStatements that are suitable for importing).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub imports: Option<Vec<Canonical>>,
    /// Software that is covered by this capability statement
    ///
    /// Software that is covered by this capability statement. It is used when the
    /// capability statement describes the capabilities of a particular software
    /// version, independent of an installation.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-16, cpb-15, cpb-2
    pub software: Option<CapabilityStatementSoftware>,
    /// If this describes a specific instance
    ///
    /// Identifies a specific implementation instance that is described by the
    /// capability statement - i.e. a particular installation, rather than the
    /// capabilities of a software program.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-16, cpb-15, cpb-14, cpb-2
    pub implementation: Option<CapabilityStatementImplementation>,
    /// FHIR Version the system supports
    ///
    /// The version of the FHIR specification that this CapabilityStatement describes
    /// (which SHALL be the same as the FHIR version of the CapabilityStatement
    /// itself). There is no default value.
    ///
    /// ## Implementation Notes
    /// Servers may implement multiple versions (see [Managing Multiple
    /// Versions](versioning.html), and the
    /// [$versions](capabilitystatement-operation-versions.html) operation). If they
    /// do, and the CapabilityStatement is requested from the server, then this
    /// fhirVersion will be either the version requested, or the server's default
    /// version.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: All published FHIR Versions.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/FHIR-version|6.0.0-ballot3
    #[fhir_serde(rename = "fhirVersion")]
    pub fhir_version: Code,
    /// formats supported (xml | json | ttl | mime type)
    ///
    /// A list of the formats supported by this implementation using their content
    /// types.
    ///
    /// ## Implementation Notes
    /// "xml", "json" and "ttl" are allowed, which describe the simple encodings
    /// described in the specification (and imply appropriate bundle support).
    /// Otherwise, mime types are legal here.
    ///
    /// ## Cardinality: Required, Multiple (1..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The mime type of an attachment. Any valid mime type is allowed (BCP 13; RFCs 2045, 2046, 2047, 4288, 4289 and 2049), and also `json`, `xml`, and `ttl`.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/supplemented-mimetypes|6.0.0-ballot3
    pub format: Option<Vec<Code>>,
    /// Patch formats supported (Mime types for FHIR and JSON And XML Patch)
    ///
    /// A list of the patch formats supported by this implementation using their
    /// content types.
    ///
    /// ## Implementation Notes
    /// At present, the patch mime types application/json-patch+json and
    /// application/xml-patch+xml are legal. Generally, if a server supports PATCH,
    /// it would be expected to support the patch formats and match the formats it
    /// supports, but this is not always possible or necessary.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: BCP 13 (RFCs 2045, 2046, 2047, 4288, 4289 and 2049)
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/patchmimetypes|6.0.0-ballot3
    #[fhir_serde(rename = "patchFormat")]
    pub patch_format: Option<Vec<Code>>,
    /// Languages supported
    ///
    /// A list of the languages supported by this implementation that are usefully
    /// supported in the ```Accept-Language``` header.
    ///
    /// ## Implementation Notes
    /// In general, if a server gets a request with an Accept-Language that it
    /// doesn't support, it should still reutrn the resource, just in its default
    /// language for the resource.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    #[fhir_serde(rename = "acceptLanguage")]
    pub accept_language: Option<Vec<Code>>,
    /// Implementation guides supported
    ///
    /// A list of implementation guides that the server does (or should) support in
    /// their entirety.
    ///
    /// ## Implementation Notes
    /// Note: this is primarily only relevant in terms of ImplementationGuides that
    /// don't define specific CapabilityStatements declaring the expectation of
    /// distinct roles. (E.g. generic IGs that establish privacy policies.) In
    /// situations where an ImplementationGuide does define CapabilityStatements,
    /// asserting CapabilityStatement.implementationGuide means that the
    /// implementation adheres to any Implementation.global definitions present in
    /// that IG as well as any textual requirements around security or other general
    /// interoperability behaviors. However, it does not make any assertions as to
    /// conformance with any of the CapabilityStatements defined in the IG. To assert
    /// conformance with CapabilityStatements in a referenced IG, it is necessary to
    /// use the CapabilityStatement.instantiates element.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implementationGuide")]
    pub implementation_guide: Option<Vec<Canonical>>,
    /// If the endpoint is a RESTful one
    ///
    /// A definition of the restful capabilities of the solution, if any.
    ///
    /// ## Implementation Notes
    /// Multiple repetitions allow definition of both client and/or server behaviors
    /// or possibly behaviors under different configuration settings (for software or
    /// requirements statements).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **cpb-9**: A given resource can only be described once per RESTful mode. (error)
    ///   Expression: `resource.select(type).isDistinct()`
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-4, cpb-1
    pub rest: Option<Vec<CapabilityStatementRest>>,
    /// If messaging is supported
    ///
    /// A description of the messaging capabilities of the solution.
    ///
    /// ## Implementation Notes
    /// Multiple repetitions allow the documentation of multiple endpoints per
    /// solution.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-1
    pub messaging: Option<Vec<CapabilityStatementMessaging>>,
    /// Document definition
    ///
    /// A document definition.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cpb-7, cpb-1
    pub document: Option<Vec<CapabilityStatementDocument>>,
}

/// Action to occur or has occurred as part of plan
///
/// Identifies an action that has occurred or is a planned action to occur as
/// part of the plan. For example, a medication to be used, lab tests to perform,
/// self-monitoring that has occurred, education etc.
///
/// ## Requirements
/// Allows systems to prompt for performance of planned activities, and validate
/// plans against best practice.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CarePlanActivity {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Activities that are completed or in progress (concept, or Appointment, Encounter, Procedure, etc.)
    ///
    /// Identifies the activity that was performed. For example, an activity could be
    /// patient education, exercise, or a medication administration. The reference to
    /// an "event" resource, such as Procedure or Encounter or Observation,
    /// represents the activity that was performed. The requested activity can be
    /// conveyed using the CarePlan.activity.plannedActivityReference (a reference to
    /// a “request” resource).
    ///
    /// ## Requirements
    /// Links plan to resulting actions.
    ///
    /// ## Implementation Notes
    /// The activity performed is independent of the outcome of the related goal(s).
    /// For example, if the goal is to achieve a target body weight of 150 lbs and an
    /// activity is defined to exercise, then the activity performed could be amount
    /// and intensity of exercise performed whereas the goal outcome is an
    /// observation for the actual body weight measured.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Identifies the results of the activity.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-plan-activity-performed
    #[fhir_serde(rename = "performedActivity")]
    pub performed_activity: Option<Vec<CodeableReference>>,
    /// Comments about the activity status/progress
    ///
    /// Notes about the adherence/status/progress of the activity.
    ///
    /// ## Requirements
    /// Can be used to capture information about adherence, progress, concerns, etc.
    ///
    /// ## Implementation Notes
    /// This element should NOT be used to describe the activity to be performed -
    /// that occurs within the resource pointed to by
    /// CarePlan.activity.plannedActivityReference.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub progress: Option<Vec<Annotation>>,
    /// Activity that is intended to be part of the care plan
    ///
    /// The details of the proposed activity represented in a specific resource.
    ///
    /// ## Requirements
    /// Details in a form consistent with other applications and contexts of use.
    ///
    /// ## Implementation Notes
    /// Standard extension exists
    /// ([http://hl7.org/fhir/StructureDefinition/resource-pertainsToGoal](https://build.fhir.org/ig/HL7/fhir-extensions/StructureDefinition-resource-pertainsToGoal.html))
    /// that allows goals to be referenced from any of the referenced resources in
    /// CarePlan.activity.plannedActivityReference.
    /// The goal should be visible when the resource referenced by
    /// CarePlan.activity.plannedActivityReference is viewed independently from the
    /// CarePlan. Requests that are pointed to by a CarePlan using this element
    /// should *not* point to this CarePlan using the "basedOn" element. i.e.
    /// Requests that are part of a CarePlan are not "based on" the CarePlan.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "plannedActivityReference")]
    pub planned_activity_reference: Option<Reference>,
}

/// FHIR CarePlan type
///
/// Describes the intention of how one or more practitioners intend to deliver
/// care for a particular patient, group or community for a period of time,
/// possibly limited to care for a specific condition or set of conditions.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [CarePlan](http://hl7.org/fhir/StructureDefinition/CarePlan)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CarePlan {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External Ids for this plan
    ///
    /// Business identifiers assigned to this care plan by the performer or other
    /// systems which remain constant as the resource is updated and propagates from
    /// server to server.
    ///
    /// ## Requirements
    /// Allows identification of the care plan as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Implementation Notes
    /// This is a business identifier, not a resource identifier (see
    /// [discussion](resource.html#identifiers)). It is best practice for the
    /// identifier to only appear on a single resource instance, however business
    /// practices may occasionally dictate that multiple resource instances with the
    /// same identifier can exist - possibly even with different resource types. For
    /// example, multiple Patient and a Person resource instance might share the same
    /// social insurance number.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Fulfills plan, proposal or order
    ///
    /// A higher-level request resource (i.e. a plan, proposal or order) that is
    /// fulfilled in whole or in part by this care plan.
    ///
    /// ## Requirements
    /// Allows tracing of the care plan and tracking whether
    /// proposals/recommendations were acted upon.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// fulfills
    #[fhir_serde(rename = "basedOn")]
    pub based_on: Option<Vec<Reference>>,
    /// CarePlan replaced by this CarePlan
    ///
    /// Completed or terminated care plan whose function is taken by this new care
    /// plan.
    ///
    /// ## Requirements
    /// Allows tracing the continuation of a therapy or administrative process
    /// instantiated through multiple care plans.
    ///
    /// ## Implementation Notes
    /// The replacement could be because the initial care plan was immediately
    /// rejected (due to an issue) or because the previous care plan was completed,
    /// but the need for the action described by the care plan remains ongoing.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// supersedes
    pub replaces: Option<Vec<Reference>>,
    /// Part of referenced CarePlan
    ///
    /// A larger care plan of which this particular care plan is a component or step.
    ///
    /// ## Implementation Notes
    /// Each care plan is an independent request, such that having a care plan be
    /// part of another care plan can cause issues with cascading statuses. As such,
    /// this element is still being discussed.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "partOf")]
    pub part_of: Option<Vec<Reference>>,
    /// draft | active | on-hold | entered-in-error | ended | completed | revoked | unknown
    ///
    /// Indicates whether the plan is currently being acted upon, represents future
    /// intentions or is now a historical record.
    ///
    /// ## Requirements
    /// Allows clinicians to determine whether the plan is actionable or not.
    ///
    /// ## Implementation Notes
    /// The unknown code is not to be used to convey other statuses. The unknown code
    /// should be used when one of the statuses applies, but the authoring system
    /// doesn't know the current state of the care plan.
    ///
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that marks the plan as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/request-status|6.0.0-ballot3
    pub status: Code,
    /// proposal | plan | order | option | directive
    ///
    /// Indicates the level of authority/intentionality associated with the care plan
    /// and where the care plan fits into the workflow chain.
    ///
    /// ## Requirements
    /// Proposals/recommendations, plans and orders all use the same structure and
    /// can exist in the same fulfillment chain.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because the intent alters when and how
    /// the resource is actually applicable.
    /// This element is expected to be immutable. E.g. A "proposal" instance should
    /// never change to be a "plan" instance or "order" instance. Instead, a new
    /// instance 'basedOn' the prior instance should be created with the new 'intent'
    /// value.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element changes the interpretation of all descriptive attributes. For example "the time the request is recommended to occur" vs. "the time the request is authorized to occur" or "who is recommended to perform the request" vs. "who is authorized to perform the request"
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Codes indicating the degree of authority/intentionality associated with a care plan.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-plan-intent|6.0.0-ballot3
    pub intent: Code,
    /// Type of plan
    ///
    /// Identifies what "kind" of plan this is to support differentiation between
    /// multiple co-existing plans; e.g. "Home health", "psychiatric", "asthma",
    /// "disease management", "wellness plan", etc.
    ///
    /// ## Requirements
    /// Used for filtering what plan(s) are retrieved and displayed to different
    /// types of users.
    ///
    /// ## Implementation Notes
    /// There may be multiple axes of categorization and one plan may serve multiple
    /// purposes. In some cases, this may be redundant with references to
    /// CarePlan.addresses.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Identifies what "kind" of plan this is to support differentiation between multiple co-existing plans; e.g. "Home health", "psychiatric", "asthma", "disease management", etc.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-plan-category
    pub category: Option<Vec<CodeableConcept>>,
    /// Human-friendly name for the care plan
    ///
    /// Human-friendly name for the care plan.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// Summary of nature of plan
    ///
    /// A description of the scope and nature of the plan.
    ///
    /// ## Requirements
    /// Provides more detail than conveyed by category.
    ///
    /// ## Implementation Notes
    /// CarePlan.description is not intended to convey the entire care plan. It is
    /// possible to convey the entire care plan narrative using CarePlan.text
    /// instead.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<String>,
    /// Who the care plan is for
    ///
    /// Identifies the patient or group whose intended care is described by the plan.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// patient
    pub subject: Reference,
    /// The Encounter during which this CarePlan was created
    ///
    /// The Encounter during which this CarePlan was created or to which the creation
    /// of this record is tightly associated.
    ///
    /// ## Implementation Notes
    /// This will typically be the encounter the event occurred within, but some
    /// activities may be initiated prior to or after the official completion of an
    /// encounter but still be tied to the context of the encounter. CarePlan
    /// activities conducted as a result of the care plan may well occur as part of
    /// other encounters.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Reference>,
    /// Time period plan covers
    ///
    /// Indicates when the plan did (or is intended to) come into effect and end.
    ///
    /// ## Requirements
    /// Allows tracking what plan(s) are in effect at a particular time.
    ///
    /// ## Implementation Notes
    /// Any activities scheduled as part of the plan should be constrained to the
    /// specified period regardless of whether the activities are planned within a
    /// single encounter/episode or across multiple encounters/episodes (e.g. the
    /// longitudinal management of a chronic condition).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// timing
    pub period: Option<Period>,
    /// Date record was first recorded
    ///
    /// Represents when this particular CarePlan record was created in the system,
    /// which is often a system-generated date.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// authoredOn
    pub created: Option<DateTime>,
    /// Who is the designated responsible party
    ///
    /// When populated, the custodian is responsible for the care plan. The care plan
    /// is attributed to the custodian.
    ///
    /// ## Implementation Notes
    /// The custodian might or might not be a contributor.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub custodian: Option<Reference>,
    /// Who provided the content of the care plan
    ///
    /// Identifies the individual(s), organization or device who provided the
    /// contents of the care plan.
    ///
    /// ## Implementation Notes
    /// Collaborative care plans may have multiple contributors.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contributor: Option<Vec<Reference>>,
    /// Who's involved in plan?
    ///
    /// Identifies all people and organizations who are expected to be involved in
    /// the care envisioned by this plan.
    ///
    /// ## Requirements
    /// Allows representation of care teams, helps scope care plan. In some cases may
    /// be a determiner of access permissions.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "careTeam")]
    pub care_team: Option<Vec<Reference>>,
    /// Health issues this plan addresses
    ///
    /// Identifies the conditions/problems/concerns/diagnoses/etc. whose management
    /// and/or mitigation are handled by this plan.
    ///
    /// ## Requirements
    /// The element can identify risks addressed by the plan as well as concerns.
    /// Also scopes plans - multiple plans may exist addressing different concerns.
    ///
    /// ## Implementation Notes
    /// Use CarePlan.addresses.concept when a code sufficiently describes the concern
    /// (e.g. condition, problem, diagnosis, risk). Use CarePlan.addresses.reference
    /// when referencing a resource, which allows more information to be conveyed,
    /// such as onset date. CarePlan.addresses.concept and
    /// CarePlan.addresses.reference are not meant to be duplicative. For a single
    /// concern, either CarePlan.addresses.concept or CarePlan.addresses.reference
    /// can be used. CarePlan.addresses.concept may be a summary code, or
    /// CarePlan.addresses.reference may be used to reference a very precise
    /// definition of the concern using Condition. Both CarePlan.addresses.concept
    /// and CarePlan.addresses.reference can be used if they are describing different
    /// concerns for the care plan.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes that describe the health issues this plan addresses.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/clinical-findings
    pub addresses: Option<Vec<CodeableReference>>,
    /// Information considered as part of plan
    ///
    /// Identifies portions of the patient's record that specifically influenced the
    /// formation of the plan. These might include comorbidities, recent procedures,
    /// limitations, recent assessments, etc.
    ///
    /// ## Requirements
    /// Identifies barriers and other considerations associated with the care plan.
    ///
    /// ## Implementation Notes
    /// Use "concern" to identify specific conditions addressed by the care plan.
    /// supportingInfo can be used to convey one or more Advance Directives or
    /// Medical Treatment Consent Directives by referencing Consent or any other
    /// request resource with intent = directive.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportingInfo")]
    pub supporting_info: Option<Vec<Reference>>,
    /// Desired outcome of plan
    ///
    /// Describes the intended objective(s) of carrying out the care plan.
    ///
    /// ## Requirements
    /// Provides context for plan. Allows plan effectiveness to be evaluated by
    /// clinicians.
    ///
    /// ## Implementation Notes
    /// Goal can be achieving a particular change or merely maintaining a current
    /// state or even slowing a decline.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub goal: Option<Vec<Reference>>,
    /// Action to occur or has occurred as part of plan
    ///
    /// Identifies an action that has occurred or is a planned action to occur as
    /// part of the plan. For example, a medication to be used, lab tests to perform,
    /// self-monitoring that has occurred, education etc.
    ///
    /// ## Requirements
    /// Allows systems to prompt for performance of planned activities, and validate
    /// plans against best practice.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub activity: Option<Vec<CarePlanActivity>>,
    /// Comments about the plan
    ///
    /// General notes about the care plan not covered elsewhere.
    ///
    /// ## Requirements
    /// Used to capture information that applies to the plan as a whole that doesn't
    /// fit into discrete elements.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
}

/// FHIR CareTeam type
///
/// The Care Team includes all the people, organizations, and care teams who
/// participate or plan to participate in the coordination and delivery of care.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [CareTeam](http://hl7.org/fhir/StructureDefinition/CareTeam)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CareTeam {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// External Ids for this team
    ///
    /// Business identifiers assigned to this care team by the performer or other
    /// systems which remain constant as the resource is updated and propagates from
    /// server to server.
    ///
    /// ## Requirements
    /// Allows identification of the care team as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Implementation Notes
    /// This is a business identifier, not a resource identifier (see
    /// [discussion](resource.html#identifiers)). It is best practice for the
    /// identifier to only appear on a single resource instance, however business
    /// practices may occasionally dictate that multiple resource instances with the
    /// same identifier can exist - possibly even with different resource types. For
    /// example, multiple Patient and a Person resource instance might share the same
    /// social insurance number.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// proposed | active | suspended | inactive | entered-in-error
    ///
    /// Indicates the current state of the care team.
    ///
    /// ## Implementation Notes
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that marks the care team as not currently valid.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Indicates the status of the care team.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-team-status|6.0.0-ballot3
    pub status: Option<Code>,
    /// Type of team
    ///
    /// Identifies what kind of team. This is to support differentiation between
    /// multiple co-existing teams, such as care plan team, episode of care team,
    /// longitudinal care team.
    ///
    /// ## Requirements
    /// Used for filtering what teams(s) are retrieved and displayed to different
    /// types of users.
    ///
    /// ## Implementation Notes
    /// There may be multiple axis of categorization and one team may serve multiple
    /// purposes.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Indicates the type of care team.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/care-team-category
    pub category: Option<Vec<CodeableConcept>>,
    /// Name of the team, such as crisis assessment team
    ///
    /// A label for human use intended to distinguish like teams. E.g. the "red" vs.
    /// "green" trauma teams.
    ///
    /// ## Implementation Notes
    /// The meaning/purpose of the team is conveyed in CareTeam.category. This
    /// element may also convey semantics of the team (e.g. "Red trauma team"), but
    /// its primary purpose is to distinguish between identical teams in a
    /// human-friendly way. ("Team 18735" isn't as friendly.).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub name: Option<String>,
    /// Who care team is for
    ///
    /// Identifies the patient or group whose intended care is handled by the team.
    ///
    /// ## Requirements
    /// Allows the team to care for a group (e.g. marriage) therapy.
    /// Allows for an organization to designate a team such as the PICC line team.
    ///
    /// ## Implementation Notes
    /// Use Group for care provision to all members of the group (e.g. group
    /// therapy). Use Patient for care provision to an individual patient.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// patient
    pub subject: Option<Reference>,
    /// Time period team covers
    ///
    /// Indicates when the team did (or is intended to) come into effect and end.
    ///
    /// ## Requirements
    /// Allows tracking what team(s) are in effect at a particular time.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub period: Option<Period>,
    /// Members of the team
    ///
    /// Identifies all people and organizations who are expected to be involved in
    /// the care team.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ctm-2**: CareTeam.participant.role or CareTeam.participant.member exists (warning)
    ///   Expression: `role.exists() or member.exists()`
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub participant: Option<Vec<CareTeamParticipant>>,
    /// Why the care team exists
    ///
    /// Describes why the care team exists.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Indicates the reason for the care team.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/clinical-findings
    pub reason: Option<Vec<CodeableReference>>,
    /// Organization responsible for the care team
    ///
    /// The organization responsible for the care team.
    ///
    /// ## Requirements
    /// Allows for multiple organizations to collaboratively manage
    /// cross-organizational, longitudinal care plan.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "managingOrganization")]
    pub managing_organization: Option<Vec<Reference>>,
    /// A contact detail for the care team (that applies to all members)
    ///
    /// A central contact detail for the care team (that applies to all members).
    ///
    /// ## Implementation Notes
    /// The ContactPoint.use code of home is not appropriate to use. These contacts
    /// are not the contact details of individual care team members.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub telecom: Option<Vec<ContactPoint>>,
    /// Comments made about the CareTeam
    ///
    /// Comments made about the CareTeam.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
}

/// Choice of types for the effective\[x\] field in CareTeamParticipant
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "effective")]
pub enum CareTeamParticipantEffective {
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "effectivePeriod")]
    Period(Period),
    /// Variant accepting the Timing type.
    #[fhir_serde(rename = "effectiveTiming")]
    Timing(Timing),
}

/// Members of the team
///
/// Identifies all people and organizations who are expected to be involved in
/// the care team.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ctm-2**: CareTeam.participant.role or CareTeam.participant.member exists (warning)
///   Expression: `role.exists() or member.exists()`
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "effective")]
pub struct CareTeamParticipant {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Type of involvement
    ///
    /// Indicates specific responsibility of an individual within the care team, such
    /// as "Primary care physician", "Trained social worker counselor", "Caregiver",
    /// etc.
    ///
    /// ## Implementation Notes
    /// Roles may sometimes be inferred by type of Practitioner. These are
    /// relationships that hold only within the context of the care team. General
    /// relationships should be handled as properties of the Patient resource
    /// directly. If a participant has multiple roles within the team, then there
    /// should be multiple participants.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Indicates specific responsibility of an individual within the care team, such as "Primary physician", "Team coordinator", "Caregiver", etc.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/participant-role
    ///
    /// ## Conditions
    /// Used when: ctm-2
    pub role: Option<CodeableConcept>,
    /// Who is involved
    ///
    /// The specific person or organization who is participating/expected to
    /// participate in the care team.
    ///
    /// ## Implementation Notes
    /// Patient only needs to be listed if they have a role other than "subject of
    /// care".
    ///
    /// Member is optional because some participants may be known only by their role,
    /// particularly in draft plans. Using Group is only allowed when the group
    /// represents a family or a household and should not represent groups of
    /// Practitioners.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: ctm-2
    pub member: Option<Reference>,
    /// Entity that the participant is acting as a proxy of, or an agent of, or in the interest of, or as a representative of
    ///
    /// Entity that the participant is acting as a proxy of, or an agent of, or in
    /// the interest of, or as a representative of.
    ///
    /// ## Requirements
    /// Allows specifying which organization a practitioner is acting on behalf of in
    /// context of this care team when practitioners are associated with multiple
    /// organizations.
    ///
    /// ## Implementation Notes
    /// Using Group is only allowed when the group represents a family or a household
    /// and should not represent groups of Practitioners.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "onBehalfOf")]
    pub on_behalf_of: Option<Reference>,
    /// When the member is generally available within this care team
    ///
    /// When the member is generally available within this care team.
    ///
    /// ## Requirements
    /// To manage members who share the same role, but with different timing. For
    /// example, two physical therapists where one is available Monday through Friday
    /// whereas the other is available on the weekend.
    ///
    /// ## Implementation Notes
    /// This is populated while creating / managing the CareTeam to ensure there is
    /// coverage when servicing CarePlan activities from the Schedule.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(flatten)]
    pub effective: Option<CareTeamParticipantEffective>,
    /// Basis for the member's participation
    ///
    /// The basis for the member's role participation in care team. For example,
    /// supporting documentation that establishes legal power of attorney or court
    /// ordered guardianship.
    ///
    /// ## Implementation Notes
    /// Enables care providers a more efficient path to review the participation, if
    /// necessary.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportingInfo")]
    pub supporting_info: Option<Vec<Reference>>,
}

/// Who performed charged service
///
/// Indicates who or what performed or participated in the charged service.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ChargeItemPerformer {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// What type of performance was done
    ///
    /// Describes the type of performance or participation(e.g. primary surgeon,
    /// anesthesiologiest, etc.).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Codes describing the types of functional roles performers can take on when performing events.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/performer-role
    pub function: Option<CodeableConcept>,
    /// Individual who was performing
    ///
    /// The device, practitioner, etc. who performed or participated in the service.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub actor: Reference,
}

/// Choice of types for the occurrence\[x\] field in ChargeItem
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "occurrence")]
pub enum ChargeItemOccurrence {
    /// Variant accepting the DateTime type.
    #[fhir_serde(rename = "occurrenceDateTime")]
    DateTime(DateTime),
    /// Variant accepting the Period type.
    #[fhir_serde(rename = "occurrencePeriod")]
    Period(Period),
    /// Variant accepting the Timing type.
    #[fhir_serde(rename = "occurrenceTiming")]
    Timing(Timing),
}

/// FHIR ChargeItem type
///
/// The resource ChargeItem describes the provision of healthcare provider
/// products for a certain patient, therefore referring not only to the product,
/// but containing in addition details of the provision, like date, time, amounts
/// and participating organizations and persons. Main Usage of the ChargeItem is
/// to enable the billing process and internal cost allocation.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [ChargeItem](http://hl7.org/fhir/StructureDefinition/ChargeItem)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "occurrence")]
pub struct ChargeItem {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Business Identifier for item
    ///
    /// Identifiers assigned to this event performer or other systems.
    ///
    /// ## Requirements
    /// Allows identification of the charge Item as it is known by various
    /// participating systems and in a way that remains consistent across servers.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Defining information about the code of this charge item
    ///
    /// References the (external) source of pricing information, rules of application
    /// for the code this ChargeItem uses.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "definitionUri")]
    pub definition_uri: Option<Vec<Uri>>,
    /// Resource defining the code of this ChargeItem
    ///
    /// References the source of pricing information, rules of application for the
    /// code this ChargeItem uses.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "definitionCanonical")]
    pub definition_canonical: Option<Vec<Canonical>>,
    /// planned | billable | not-billable | aborted | billed | entered-in-error | unknown
    ///
    /// The current state of the ChargeItem.
    ///
    /// ## Implementation Notes
    /// Unknown does not represent "other" - one of the defined statuses must apply.
    /// Unknown is used when the authoring system is not sure what the current status
    /// is.
    ///
    /// This element is labeled as a modifier because the status contains the code
    /// entered-in-error that marks the charge item as not currently valid.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labelled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: Codes identifying the lifecycle stage of a ChargeItem.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/chargeitem-status|6.0.0-ballot3
    pub status: Code,
    /// Part of referenced ChargeItem
    ///
    /// ChargeItems can be grouped to larger ChargeItems covering the whole set.
    ///
    /// ## Requirements
    /// E.g. Drug administration as part of a procedure, procedure as part of
    /// observation, etc.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// container
    #[fhir_serde(rename = "partOf")]
    pub part_of: Option<Vec<Reference>>,
    /// A code that identifies the charge, like a billing code
    ///
    /// A code that identifies the charge, like a billing code.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Example codes for billing purposes
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/chargeitem-billingcodes
    ///
    /// ## Aliases
    /// type
    pub code: CodeableConcept,
    /// Individual service was done for/to
    ///
    /// The individual or set of individuals the action is being or was performed on.
    ///
    /// ## Requirements
    /// Links the event to the Patient context.
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// patient
    pub subject: Reference,
    /// Encounter associated with this ChargeItem
    ///
    /// This ChargeItem has the details of how the associated Encounter should be
    /// billed or otherwise be handled by finance systems.
    ///
    /// ## Implementation Notes
    /// This ChargeItem may be recorded during planning, execution or after the
    /// actual encounter takes place.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub encounter: Option<Reference>,
    /// When the charged service was applied
    ///
    /// Date/time(s) or duration when the charged service was applied.
    ///
    /// ## Implementation Notes
    /// The list of types may be constrained as appropriate for the type of charge
    /// item.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// timing
    #[fhir_serde(flatten)]
    pub occurrence: Option<ChargeItemOccurrence>,
    /// Who performed charged service
    ///
    /// Indicates who or what performed or participated in the charged service.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub performer: Option<Vec<ChargeItemPerformer>>,
    /// Organization providing the charged service
    ///
    /// The organization performing the service.
    ///
    /// ## Implementation Notes
    /// Practitioners and Devices can be associated with multiple organizations. It
    /// has to be made clear, on behalf of which Organization the services have been
    /// rendered.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "performingOrganization")]
    pub performing_organization: Option<Reference>,
    /// Organization requesting the charged service
    ///
    /// The organization requesting the service.
    ///
    /// ## Implementation Notes
    /// The rendered Service might not be associated with a Request. This property
    /// indicates which Organization requested the services to be rendered. (In many
    /// cases, this may just be the Department associated with the
    /// Encounter.location).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "requestingOrganization")]
    pub requesting_organization: Option<Reference>,
    /// Organization that has ownership of the (potential, future) revenue
    ///
    /// The financial cost center permits the tracking of charge attribution.
    ///
    /// ## Implementation Notes
    /// The costCenter could either be given as a reference to an Organization(Role)
    /// resource or as the identifier of the cost center determined by
    /// Reference.identifier.value and Reference.identifier.system, depending on use
    /// case requirements.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "costCenter")]
    pub cost_center: Option<Reference>,
    /// Quantity of which the charge item has been serviced
    ///
    /// Quantity of which the charge item has been serviced.
    ///
    /// ## Implementation Notes
    /// In many cases this may just be a value, if the underlying units are implicit
    /// in the definition of the charge item code.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub quantity: Option<Quantity>,
    /// Anatomical location, if relevant
    ///
    /// The anatomical location where the related service has been applied.
    ///
    /// ## Implementation Notes
    /// Only used if not implicit in code found in Condition.code. If the use case
    /// requires attributes from the BodySite resource (e.g. to identify and track
    /// separately) then use the standard extension
    /// [http://hl7.org/fhir/StructureDefinition/bodySite](https://build.fhir.org/ig/HL7/fhir-extensions/StructureDefinition-bodySite.html).
    /// May be a summary code, or a reference to a very precise definition of the
    /// location, or both.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: SNOMED CT Body site concepts
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/body-site
    pub bodysite: Option<Vec<CodeableConcept>>,
    /// Unit price overriding the associated rules
    ///
    /// The unit price of the chargable item.
    ///
    /// ## Implementation Notes
    /// This could be communicated in ChargeItemDefinition. But if
    /// ChargeItemDefinition is not supported or not available, the unit price can be
    /// communicated in this property.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "unitPriceComponent")]
    pub unit_price_component: Option<MonetaryComponent>,
    /// Total price overriding the associated rules
    ///
    /// The total price for the chargable item, accounting for the quantity.
    ///
    /// ## Implementation Notes
    /// Often, the total price may be be calculated and recorded on the Invoice, but
    /// if a calculated total price must be exchanged prior to Invoice creation, it
    /// can be communicated in this property.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "totalPriceComponent")]
    pub total_price_component: Option<MonetaryComponent>,
    /// Reason for overriding the list price/factor
    ///
    /// If the list price or the rule-based factor associated with the code is
    /// overridden, this attribute can capture a text to indicate the reason for this
    /// action.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Local or regional codes covering why a price was overridden
    #[fhir_serde(rename = "overrideReason")]
    pub override_reason: Option<CodeableConcept>,
    /// Individual who was entering
    ///
    /// The device, practitioner, etc. who entered the charge item.
    ///
    /// ## Implementation Notes
    /// The enterer is also the person considered responsible for factor/price
    /// overrides if applicable.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub enterer: Option<Reference>,
    /// Date the charge item was entered
    ///
    /// Date the charge item was entered.
    ///
    /// ## Implementation Notes
    /// The actual date when the service associated with the charge has been rendered
    /// is captured in occurrence[x].
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "enteredDate")]
    pub entered_date: Option<DateTime>,
    /// Why was the charged  service rendered?
    ///
    /// Describes why the event occurred in coded or textual form.
    ///
    /// ## Implementation Notes
    /// If the application of the charge item requires a reason to be given, it can
    /// be captured here. Textual reasons can be captured using reasonCode.text.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: ICD 10 diagnosis codes
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/icd-10
    pub reason: Option<Vec<CodeableReference>>,
    /// Which rendered service is being charged?
    ///
    /// Indicated the rendered service that caused this charge.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub service: Option<Vec<CodeableReference>>,
    /// Product charged
    ///
    /// Identifies the device, food, drug or other product being charged either by
    /// type code or reference to an instance.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Example binding for product type.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/device-type
    pub product: Option<Vec<CodeableReference>>,
    /// Account to place this charge
    ///
    /// Account into which this ChargeItems belongs.
    ///
    /// ## Implementation Notes
    /// Systems posting the ChargeItems might not always be able to determine, which
    /// accounts the Items need to be places into. It is up to the postprocessing
    /// Financial System to apply internal rules to decide based on the
    /// Encounter/EpisodeOfCare/Patient/Coverage context and the type of ChargeItem,
    /// which Account is appropriate.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub account: Option<Vec<Reference>>,
    /// Comments made about the ChargeItem
    ///
    /// Comments made about the event by the performer, subject or other
    /// participants.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub note: Option<Vec<Annotation>>,
    /// Further information supporting this charge
    ///
    /// Further information supporting this charge.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "supportingInformation")]
    pub supporting_information: Option<Vec<Reference>>,
}

/// Choice of types for the versionAlgorithm\[x\] field in ChargeItemDefinition
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath)]
#[fhir_choice_element(base_name = "versionAlgorithm")]
pub enum ChargeItemDefinitionVersionAlgorithm {
    /// Variant accepting the String type.
    #[fhir_serde(rename = "versionAlgorithmString")]
    String(String),
    /// Variant accepting the Coding type.
    #[fhir_serde(rename = "versionAlgorithmCoding")]
    Coding(Coding),
}

/// FHIR ChargeItemDefinition type
///
/// The ChargeItemDefinition resource provides the properties that apply to the
/// (billing) codes necessary to calculate costs and prices. The properties may
/// differ largely depending on type and realm, therefore this resource gives
/// only a rough structure and requires profiling for each type of billing code
/// system.
///
/// ## Type: Resource type
/// Base type: http://hl7.org/fhir/StructureDefinition/DomainResource
///
/// ## Status: draft
/// FHIR Version: 6.0.0-ballot3
///
/// See: [ChargeItemDefinition](http://hl7.org/fhir/StructureDefinition/ChargeItemDefinition)
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
#[fhir_resource(choice_elements = "versionAlgorithm")]
pub struct ChargeItemDefinition {
    /// Logical id of this artifact
    ///
    /// The logical id of the resource, as used in the URL for the resource. Once
    /// assigned, this value never changes.
    ///
    /// ## Implementation Notes
    /// Within the context of the FHIR RESTful interactions, the resource has an id
    /// except for cases like the create and conditional update. Otherwise, the use
    /// of the resouce id depends on the given use case.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    pub id: Option<String>,
    /// Metadata about the resource
    ///
    /// The metadata about the resource. This is content that is maintained by the
    /// infrastructure. Changes to the content might not always be associated with
    /// version changes to the resource.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub meta: Option<Meta>,
    /// A set of rules under which this content was created
    ///
    /// A reference to a set of rules that were followed when the resource was
    /// constructed, and which must be understood when processing the content. Often,
    /// this is a reference to an implementation guide that defines the special rules
    /// along with other profiles etc.
    ///
    /// ## Implementation Notes
    /// Asserting this rule set restricts the content to be only understood by a
    /// limited set of trading partners. This inherently limits the usefulness of the
    /// data in the long term. However, the existing health eco-system is highly
    /// fractured, and not yet ready to define, collect, and exchange data in a
    /// generally computable sense. Wherever possible, implementers and/or
    /// specification writers should avoid using this element. Often, when used, the
    /// URL is a reference to an implementation guide that defines these special
    /// rules as part of its narrative along with other profiles, value sets, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies its meaning or interpretation
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "implicitRules")]
    pub implicit_rules: Option<Uri>,
    /// Language of the resource content
    ///
    /// The base language in which the resource is written.
    ///
    /// ## Implementation Notes
    /// Language is provided to support indexing and accessibility (typically,
    /// services such as text to speech use the language tag). The html language tag
    /// in the narrative applies to the narrative. The language tag on the resource
    /// may be used to specify the language of other presentations generated from the
    /// data in the resource. Not all the content has to be in the base language. The
    /// Resource.language should not be assumed to apply to the narrative
    /// automatically. If a language is specified, it should it also be specified on
    /// the div element in the html (see rules in HTML5 for information about the
    /// relationship between xml:lang and the html lang attribute).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: IETF language tag for a human language
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/all-languages|6.0.0-ballot3
    pub language: Option<Code>,
    /// Text summary of the resource, for human interpretation
    ///
    /// A human-readable narrative that contains a summary of the resource and can be
    /// used to represent the content of the resource to a human. The narrative need
    /// not encode all the structured data, but is required to contain sufficient
    /// detail to make it "clinically safe" for a human to just read the narrative.
    /// Resource definitions may define what content should be represented in the
    /// narrative to ensure clinical safety.
    ///
    /// ## Implementation Notes
    /// Contained resources do not have a narrative. Resources that are not contained
    /// SHOULD have a narrative. In some cases, a resource may only have text with
    /// little or no additional discrete data (as long as all minOccurs=1 elements
    /// are satisfied). This may be necessary for data from legacy systems where
    /// information is captured as a "text blob" or where text is additionally
    /// entered raw or narrated and encoded information is added later.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// narrative, html, xhtml, display
    ///
    /// ## Conditions
    /// Used when: dom-6
    pub text: Option<Narrative>,
    /// Contained, inline Resources
    ///
    /// These resources do not have an independent existence apart from the resource
    /// that contains them - they cannot be identified independently, nor can they
    /// have their own independent transaction scope. This is allowed to be a
    /// Parameters resource if and only if it is referenced by a resource that
    /// provides context/meaning.
    ///
    /// ## Implementation Notes
    /// This should never be done when the content can be identified properly, as
    /// once identification is lost, it is extremely difficult (and context
    /// dependent) to restore it again. Contained resources may have profiles and
    /// tags in their meta elements, but SHALL NOT have security labels. Contained
    /// resources may be a resource type defined in the FHIR specification, or an
    /// [additional resource](resource.html#additional).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Aliases
    /// inline resources, anonymous resources, contained resources
    ///
    /// ## Conditions
    /// Used when: dom-2, dom-4, dom-3, dom-5
    pub contained: Option<Vec<Resource>>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the resource and that modifies the understanding of the element
    /// that contains it and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer is allowed to define an extension, there is a set of requirements
    /// that SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Canonical identifier for this charge item definition, represented as a URI (globally unique)
    ///
    /// An absolute URI that is used to identify this charge item definition when it
    /// is referenced in a specification, model, design or an instance; also called
    /// its canonical identifier. This SHOULD be globally unique and SHOULD be a
    /// literal address at which an authoritative instance of this charge item
    /// definition is (or will be) published. This URL can be the target of a
    /// canonical reference. It SHALL remain the same when the charge item definition
    /// is stored on different servers.
    ///
    /// ## Requirements
    /// Allows the charge item definition to be referenced by a single globally
    /// unique identifier.
    ///
    /// ## Implementation Notes
    /// Can be a urn:uuid: or a urn:oid: but real http: addresses are preferred.
    /// Multiple instances may share the same URL if they have a distinct version.
    ///
    /// The determination of when to create a new version of a resource (same url,
    /// new version) vs. defining a new artifact is up to the author. Considerations
    /// for making this decision are found in [Technical and Business
    /// Versions](resource.html#versions).
    ///
    /// In some cases, the resource can no longer be found at the stated url, but the
    /// url itself cannot change. Implementations can use the
    /// [meta.source](resource.html#meta) element to indicate where the current
    /// master source of the resource can be found.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **cnl-1**: URL should not contain | or # - these characters make processing canonical references problematic (warning)
    ///   Expression: `exists() implies matches('^[^|# ]+$')`
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub url: Option<Uri>,
    /// Additional identifier for the charge item definition
    ///
    /// A formal identifier that is used to identify this charge item definition when
    /// it is represented in other formats, or referenced in a specification, model,
    /// design or an instance.
    ///
    /// ## Requirements
    /// Allows externally provided and/or usable business identifiers to be easily
    /// associated with the module.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub identifier: Option<Vec<Identifier>>,
    /// Business version of the charge item definition
    ///
    /// The identifier that is used to identify this version of the charge item
    /// definition when it is referenced in a specification, model, design or
    /// instance. This is an arbitrary value managed by the charge item definition
    /// author and is not expected to be globally unique. For example, it might be a
    /// timestamp (e.g. yyyymmdd) if a managed version is not available. There is
    /// also no expectation that versions can be placed in a lexicographical
    /// sequence. To provide a version consistent with the Decision Support Service
    /// specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more
    /// information on versioning knowledge assets, refer to the Decision Support
    /// Service specification. Note that a version is required for non-experimental
    /// active assets.
    ///
    /// ## Implementation Notes
    /// There may be different charge item definition instances that have the same
    /// identifier but different versions. The version can be appended to the url in
    /// a reference to allow a reference to a particular business version of the
    /// charge item definition with the format [url]|[version]. The version SHOULD
    /// NOT contain a '#' - see [Business Version](resource.html#bv-format).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub version: Option<String>,
    /// How to compare versions
    ///
    /// Indicates the mechanism used to compare versions to determine which is more
    /// current.
    ///
    /// ## Implementation Notes
    /// If set as a string, this is a FHIRPath expression that has two additional
    /// context variables passed in - %version1 and %version2 and will return a
    /// negative number if version1 is newer, a positive number if version2 and a 0
    /// if the version ordering can't be successfully be determined.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/version-algorithm
    #[fhir_serde(flatten)]
    pub version_algorithm: Option<ChargeItemDefinitionVersionAlgorithm>,
    /// Name for this charge item definition (computer friendly)
    ///
    /// A natural language name identifying the ChargeItemDefinition. This name
    /// should be usable as an identifier for the module by machine processing
    /// applications such as code generation.
    ///
    /// ## Requirements
    /// Support human navigation and code generation.
    ///
    /// ## Implementation Notes
    /// The name is not expected to be globally unique. The name should be a simple
    /// alphanumeric type name to ensure that it is machine-processing friendly.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Conditions
    /// Used when: cnl-0
    pub name: Option<String>,
    /// Name for this charge item definition (human friendly)
    ///
    /// A short, descriptive, user-friendly title for the charge item definition.
    ///
    /// ## Implementation Notes
    /// This name does not need to be machine-processing friendly and may contain
    /// punctuation, white-space, etc.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub title: Option<String>,
    /// Underlying externally-defined charge item definition
    ///
    /// The URL pointing to an externally-defined charge item definition that is
    /// adhered to in whole or in part by this definition.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "derivedFromUri")]
    pub derived_from_uri: Option<Vec<Uri>>,
    /// A larger definition of which this particular definition is a component or step
    ///
    /// A larger definition of which this particular definition is a component or
    /// step.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// container
    #[fhir_serde(rename = "partOf")]
    pub part_of: Option<Vec<Canonical>>,
    /// Completed or terminated request(s) whose function is taken by this new request
    ///
    /// As new versions of a protocol or guideline are defined, allows identification
    /// of what versions are replaced by a new instance.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// supersedes, prior, renewed order
    pub replaces: Option<Vec<Canonical>>,
    /// draft | active | retired | unknown
    ///
    /// The current state of the ChargeItemDefinition.
    ///
    /// ## Implementation Notes
    /// Allows filtering of charge item definitions that are appropriate for use
    /// versus not.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Required (1..1)
    ///
    /// ## Special Semantics
    /// - Modifier element - This is labeled as "Is Modifier" because applications should not use a retired {{title}} without due consideration
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: required
    /// - **Description**: The lifecycle status of an artifact.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/publication-status|6.0.0-ballot3
    pub status: Code,
    /// For testing only - never for real usage
    ///
    /// A Boolean value to indicate that this charge item definition is authored for
    /// testing purposes (or education/evaluation/marketing) and no version of this
    /// resource will ever be intended for genuine usage.
    ///
    /// ## Requirements
    /// Enables experimental content to be developed following the same lifecycle
    /// that would be used for a production-level charge item definition.
    ///
    /// ## Implementation Notes
    /// Allows filtering of charge item definitions that are appropriate for use
    /// versus not.. Experimental resources might include example instances in
    /// implementation guides, instances created solely for testing purposes, etc. If
    /// experimental is 'true' for any version of a resource, it should be true for
    /// all versions of the resource. (If experimental changes, then it is being
    /// misused or a resource that was never intended for real-world use has
    /// unexpectedly changed its purpose.).
    ///
    /// Experimental resources are not expected to be stable and may well have
    /// breaking changes without a corresponding change to the 'version' element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    /// - When missing: If absent, this resource is treated as though it is not experimental.
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub experimental: Option<Boolean>,
    /// Date last changed
    ///
    /// The date (and optionally time) when the charge item definition was last
    /// significantly changed. The date must change when the business version changes
    /// and it must change if the status code changes. In addition, it should change
    /// when the substantive content of the charge item definition changes.
    ///
    /// ## Implementation Notes
    /// The date is often not tracked until the resource is published, but may be
    /// present on draft content. Note that this is not the same as the resource
    /// last-modified-date, since the resource may be a secondary representation of
    /// the charge item definition. Additional specific dates may be added as
    /// extensions or be found by consulting Provenances associated with past
    /// versions of the resource.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// Revision Date
    pub date: Option<DateTime>,
    /// Candidate account(s) for charge items
    ///
    /// A set of candidate accounts to which charge items using this definition may
    /// be assigned.
    ///
    /// ## Implementation Notes
    /// An Account resource may represent either a patient-oriented account or an
    /// organizational account (e.g., a cost center). This property is intended for
    /// use with the cost center style accounts, and is not expected to refer to
    /// patient-oriented accounts. For example, if a ChargeItemDefinition is created
    /// to bill for a research procedure, this property could indicate that all
    /// charges for that procedure could be directed to the specified account.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub account: Option<Vec<Reference>>,
    /// Name of the publisher/steward (organization or individual)
    ///
    /// The name of the organization or individual responsible for the release and
    /// ongoing maintenance of the charge item definition.
    ///
    /// ## Requirements
    /// Helps establish the "authority/credibility" of the charge item definition.
    /// May also allow for contact.
    ///
    /// ## Implementation Notes
    /// Usually an organization but may be an individual. The publisher (or steward)
    /// of the charge item definition is the organization or individual primarily
    /// responsible for the maintenance and upkeep of the charge item definition.
    /// This is not necessarily the same individual or organization that developed
    /// and initially authored the content. The publisher is the primary point of
    /// contact for questions or issues with the charge item definition. This item
    /// SHOULD be populated unless the information is available from context.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub publisher: Option<String>,
    /// Contact details for the publisher
    ///
    /// Contact details to assist a user in finding and communicating with the
    /// publisher.
    ///
    /// ## Implementation Notes
    /// May be a web site, an email address, a telephone number, etc.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub contact: Option<Vec<ContactDetail>>,
    /// Natural language description of the charge item definition
    ///
    /// A free text natural language description of the charge item definition from a
    /// consumer's perspective.
    ///
    /// ## Implementation Notes
    /// This description can be used to capture details such as comments about
    /// misuse, instructions for clinical use and interpretation, literature
    /// references, examples from the paper world, etc. It is not a rendering of the
    /// charge item definition as conveyed in the 'text' field of the resource
    /// itself. This item SHOULD be populated unless the information is available
    /// from context (e.g. the language of the charge item definition is presumed to
    /// be the predominant language in the place the charge item definition was
    /// created).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub description: Option<Markdown>,
    /// The context that the content is intended to support
    ///
    /// The content was developed with a focus and intent of supporting the contexts
    /// that are listed. These contexts may be general categories (gender, age, ...)
    /// or may be references to specific programs (insurance plans, studies, ...) and
    /// may be used to assist with indexing and searching for appropriate charge item
    /// definition instances.
    ///
    /// ## Requirements
    /// Assist in searching for appropriate content.
    ///
    /// ## Implementation Notes
    /// When multiple useContexts are specified, there is no expectation that all or
    /// any of the contexts apply.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "useContext")]
    pub use_context: Option<Vec<UsageContext>>,
    /// Jurisdiction of the authority that maintains the charge item definition (if applicable)
    ///
    /// A legal or geographic region in which the authority that maintains the
    /// resource is operating. In general, the jurisdiction is also found in the
    /// useContext. The useContext may reference additional jurisdictions because the
    /// defining jurisdiction does not necessarily limit the jurisdictions of use.
    ///
    /// ## Implementation Notes
    /// It may be possible for the charge item definition to be used in jurisdictions
    /// other than those for which it was originally designed or intended.
    ///
    /// DEPRECATION NOTE: For consistency, implementations are encouraged to migrate
    /// to using the new 'jurisdiction' code in the useContext element. (I.e.
    /// useContext.code indicating
    /// http://terminology.hl7.org/CodeSystem/usage-context-type#jurisdiction and
    /// useContext.valueCodeableConcept indicating the jurisdiction.)
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: extensible
    /// - **Description**: Countries and regions within which this artifact is targeted for use.
    /// - **ValueSet**: http://terminology.hl7.org/ValueSet/jurisdiction
    pub jurisdiction: Option<Vec<CodeableConcept>>,
    /// Why this charge item definition is defined
    ///
    /// Explanation of why this charge item definition is needed and why it has been
    /// designed as it has.
    ///
    /// ## Implementation Notes
    /// This element does not describe the usage of the charge item definition.
    /// Instead, it provides traceability of ''why'' the resource is either needed or
    /// ''why'' it is defined as it is. This may be used to point to source materials
    /// or specifications that drove the structure of this charge item definition.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub purpose: Option<Markdown>,
    /// Use and/or publishing restrictions
    ///
    /// A copyright statement relating to the charge item definition and/or its
    /// contents. Copyright statements are generally legal restrictions on the use
    /// and publishing of the charge item definition.
    ///
    /// ## Requirements
    /// Consumers must be able to determine any legal restrictions on the use of the
    /// charge item definition and/or its content.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// License, Restrictions
    pub copyright: Option<Markdown>,
    /// Copyright holder and year(s)
    ///
    /// A short string (<50 characters), suitable for inclusion in a page footer that
    /// identifies the copyright holder, effective period, and optionally whether
    /// rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').
    ///
    /// ## Requirements
    /// Defines the content expected to be rendered in all representations of the
    /// artifact.
    ///
    /// ## Implementation Notes
    /// The (c) symbol should NOT be included in this string. It will be added by
    /// software when rendering the notation. Full details about licensing,
    /// restrictions, warrantees, etc. goes in the more general 'copyright' element.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "copyrightLabel")]
    pub copyright_label: Option<String>,
    /// When the charge item definition was approved by publisher
    ///
    /// The date on which the resource content was approved by the publisher.
    /// Approval happens once when the content is officially approved for usage.
    ///
    /// ## Implementation Notes
    /// The 'date' element may be more recent than the approval date because of minor
    /// changes or editorial corrections.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "approvalDate")]
    pub approval_date: Option<Date>,
    /// When the charge item definition was last reviewed by the publisher
    ///
    /// The date on which the resource content was last reviewed. Review happens
    /// periodically after approval but does not change the original approval date.
    ///
    /// ## Requirements
    /// Gives a sense of how "current" the content is. Resources that have not been
    /// reviewed in a long time may have a risk of being less appropriate/relevant.
    ///
    /// ## Implementation Notes
    /// If specified, this date follows the original approval date.
    ///
    /// See guidance around (not) making local changes to elements
    /// [here](canonicalresource.html#localization).
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "lastReviewDate")]
    pub last_review_date: Option<Date>,
    /// Billing code or product type this definition applies to
    ///
    /// The defined billing details in this resource pertain to the given billing
    /// code.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Binding
    /// - **Strength**: example
    /// - **Description**: Billing Code defined by this ChargeItemDefinition.
    /// - **ValueSet**: http://hl7.org/fhir/ValueSet/chargeitem-billingcodes
    pub code: Option<CodeableConcept>,
    /// Instances this definition applies to
    ///
    /// The defined billing details in this resource pertain to the given product
    /// instance(s).
    ///
    /// ## Implementation Notes
    /// In case of highly customized, individually produced or fitted
    /// devices/substances, the pricing information may be different for each
    /// instance of the product. This reference links pricing details to specific
    /// product instances.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub instance: Option<Vec<Reference>>,
    /// Whether or not the billing code is applicable
    ///
    /// Expressions that describe applicability criteria for the billing code.
    ///
    /// ## Implementation Notes
    /// The applicability conditions can be used to ascertain whether a billing item
    /// is allowed in a specific context. E.g. some billing codes may only be
    /// applicable in out-patient settings, only to male/female patients or only to
    /// children.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub applicability: Option<Vec<ChargeItemDefinitionApplicability>>,
    /// Group of properties which are applicable under the same conditions
    ///
    /// Group of properties which are applicable under the same conditions. If no
    /// applicability rules are established for the group, then all properties always
    /// apply.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children or both (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "propertyGroup")]
    pub property_group: Option<Vec<ChargeItemDefinitionPropertyGroup>>,
}

/// Whether or not the billing code is applicable
///
/// Expressions that describe applicability criteria for the billing code.
///
/// ## Implementation Notes
/// The applicability conditions can be used to ascertain whether a billing item
/// is allowed in a specific context. E.g. some billing codes may only be
/// applicable in out-patient settings, only to male/female patients or only to
/// children.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ChargeItemDefinitionApplicability {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Boolean-valued expression
    ///
    /// An expression that returns true or false, indicating whether the condition is
    /// satisfied. When using FHIRPath expressions, the %context environment variable
    /// must be replaced at runtime with the ChargeItem resource to which this
    /// definition is applied.
    ///
    /// ## Implementation Notes
    /// Please note that FHIRPath Expressions can only be evaluated in the scope of
    /// the current ChargeItem resource to which this definition is being applied.
    /// FHIRPath expressions can traverse into other resources linked from the
    /// ChargeItem resource, however, testing rules such as that a billing code may
    /// be billed only once per encounter need a wider scope. In such scenarios, CQL
    /// may be the appropriate choice.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub condition: Option<Expression>,
    /// When the charge item definition is expected to be used
    ///
    /// The period during which the charge item definition content was or is planned
    /// to be in active use.
    ///
    /// ## Requirements
    /// Allows establishing a transition before a resource comes into effect and also
    /// allows for a sunsetting process when new versions of the charge item
    /// definition are or are expected to be used instead.
    ///
    /// ## Implementation Notes
    /// The effective period for a charge item definition determines when the content
    /// is applicable for usage and is independent of publication and review dates.
    /// For example, a measure intended to be used for the year 2016 might be
    /// published in 2015.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Special Semantics
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "effectivePeriod")]
    pub effective_period: Option<Period>,
    /// Reference to / quotation of the external source of the group of properties
    ///
    /// Reference to / quotation of the external source of the group of properties.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "relatedArtifact")]
    pub related_artifact: Option<RelatedArtifact>,
}

/// Group of properties which are applicable under the same conditions
///
/// Group of properties which are applicable under the same conditions. If no
/// applicability rules are established for the group, then all properties always
/// apply.
///
/// ## Cardinality: Optional, Multiple (0..*)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct ChargeItemDefinitionPropertyGroup {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Conditions under which the priceComponent is applicable
    ///
    /// Expressions that describe applicability criteria for the priceComponent.
    ///
    /// ## Implementation Notes
    /// The applicability conditions can be used to ascertain whether a billing item
    /// is allowed in a specific context. E.g. some billing codes may only be
    /// applicable in out-patient settings, only to male/female patients or only to
    /// children.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    pub applicability: Option<Vec<ChargeItemDefinitionApplicability>>,
    /// Components of total line item price
    ///
    /// The price for a ChargeItem may be calculated as a base price with
    /// surcharges/deductions that apply in certain conditions. A
    /// ChargeItemDefinition resource that defines the prices, factors and conditions
    /// that apply to a billing code is currently under development. The
    /// priceComponent element can be used to offer transparency to the recipient of
    /// the Invoice of how the prices have been calculated.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    #[fhir_serde(rename = "priceComponent")]
    pub price_component: Option<Vec<MonetaryComponent>>,
}

/// The article or artifact being described
///
/// The article or artifact being described.
///
/// ## Cardinality: Optional (0..1)
///
/// ## Constraints
/// - **ele-1**: All FHIR elements must have a @value or children or both (error)
///   Expression: `hasValue() or (children().count() > id.count())`
#[derive(Debug, Clone, PartialEq, Eq, FhirSerde, FhirPath, Default)]
pub struct CitationCitedArtifact {
    /// Unique id for inter-element referencing
    ///
    /// Unique id for the element within a resource (for internal references). This
    /// may be any string value that does not contain spaces.
    ///
    /// ## Cardinality: Optional (0..1)
    ///
    /// ## Conditions
    /// Used when: ele-1
    pub id: Option<String>,
    /// Additional content defined by implementations
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element. To make the use of extensions safe and managable,
    /// there is a strict set of governance applied to the definition and use of
    /// extensions. Though any implementer can define an extension, there is a set of
    /// requirements that SHALL be met as part of the definition of the extension.
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content
    pub extension: Option<Vec<Extension>>,
    /// Extensions that cannot be ignored even if unrecognized
    ///
    /// May be used to represent additional information that is not part of the basic
    /// definition of the element and that modifies the understanding of the element
    /// in which it is contained and/or the understanding of the containing element's
    /// descendants. Usually modifier elements provide negation or qualification. To
    /// make the use of extensions safe and managable, there is a strict set of
    /// governance applied to the definition and use of extensions. Though any
    /// implementer can define an extension, there is a set of requirements that
    /// SHALL be met as part of the definition of the extension. Applications
    /// processing a resource are required to check for modifier extensions.
    ///
    /// Modifier extensions SHALL NOT change the meaning of any elements on Resource
    /// or DomainResource (including cannot change the meaning of modifierExtension
    /// itself).
    ///
    /// ## Requirements
    /// Modifier extensions allow for extensions that *cannot* be safely ignored to
    /// be clearly distinguished from the vast majority of extensions which can be
    /// safely ignored. This promotes interoperability by eliminating the need for
    /// implementers to prohibit the presence of extensions. For further information,
    /// see the [definition of modifier
    /// extensions](extensibility.html#modifierExtension).
    ///
    /// ## Implementation Notes
    /// There can be no stigma associated with the use of extensions by any
    /// application, project, or standard - regardless of the institution or
    /// jurisdiction that uses or defines the extensions. The use of extensions is
    /// what allows the FHIR specification to retain a core level of simplicity for
    /// everyone.
    ///
    /// ## Cardinality: Optional, Multiple (0..*)
    ///
    /// ## Special Semantics
    /// - Modifier element - Modifier extensions are expected to modify the meaning or interpretation of the element that contains them
    /// - Included in summary
    ///
    /// ## Constraints
    /// - **ele-1**: All FHIR elements must have a @value or children (error)
    ///   Expression: `hasValue() or (children().count() > id.count())`
    ///
    /// ## Aliases
    /// extensions, user content, modifiers
    #[fhir_serde(rename = "modifierExtension")]
    pub modifier_extension: Option<Vec<Extension>>,
    /// Unique identifier. May include DOI, PMID, PMCID, etc
    ///
    /// A formal identifier that is used to identify the cited artifact when it is
    /// represented in other formats, or referenced in a specification, model, design
    /// or an instance.
    ///
    /// ## Requirements
    /// Allows externally provided and/or usable identifiers to be associated with
    /// the cited artifact.
    ///
    /// ## Implementation Notes
    /// This element will contain unique identifiers that support de-duplication of
    /// citations. Commonly used identifiers for study citations include digital
    /// object identifier (DOI), PubMed ID (PMID), and PubMed Central ID (PMCID). To
    /// maintain interoperability, the suggested identifier.syst