"""Type stubs for the pysof Rust extension module."""

from typing import Any

# Exception classes
class SofError(Exception): ...
class InvalidViewDefinitionError(SofError): ...
class FhirPathError(SofError): ...
class SerializationError(SofError): ...
class UnsupportedContentTypeError(SofError): ...
class CsvError(SofError): ...
class IoError(SofError): ...
class InvalidSourceError(SofError): ...
class SourceNotFoundError(SofError): ...
class SourceFetchError(SofError): ...
class SourceReadError(SofError): ...
class InvalidSourceContentError(SofError): ...
class UnsupportedSourceProtocolError(SofError): ...

# Core functions
def py_run_view_definition(
    view: dict[str, Any],
    bundle: dict[str, Any],
    format: str,
    fhir_version: str,
) -> bytes: ...
def py_run_view_definition_with_options(
    view: dict[str, Any],
    bundle: dict[str, Any],
    format: str,
    *,
    since: str | None = None,
    limit: int | None = None,
    page: int | None = None,
    fhir_version: str = "R4",
) -> bytes: ...
def py_validate_view_definition(
    view: dict[str, Any],
    fhir_version: str,
) -> bool: ...
def py_validate_bundle(
    bundle: dict[str, Any],
    fhir_version: str,
) -> bool: ...
def py_parse_content_type(mime_type: str) -> str: ...
def py_get_supported_fhir_versions() -> list[str]: ...
