# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PluginInstallationArgs', 'PluginInstallation']

@pulumi.input_type
class PluginInstallationArgs:
    def __init__(__self__, *,
                 slug: pulumi.Input[_builtins.str],
                 stack_slug: pulumi.Input[_builtins.str],
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PluginInstallation resource.
        :param pulumi.Input[_builtins.str] slug: Slug of the plugin to be installed.
        :param pulumi.Input[_builtins.str] stack_slug: The stack id to which the plugin should be installed.
        """
        pulumi.set(__self__, "slug", slug)
        pulumi.set(__self__, "stack_slug", stack_slug)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def slug(self) -> pulumi.Input[_builtins.str]:
        """
        Slug of the plugin to be installed.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "slug", value)

    @_builtins.property
    @pulumi.getter(name="stackSlug")
    def stack_slug(self) -> pulumi.Input[_builtins.str]:
        """
        The stack id to which the plugin should be installed.
        """
        return pulumi.get(self, "stack_slug")

    @stack_slug.setter
    def stack_slug(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_slug", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _PluginInstallationState:
    def __init__(__self__, *,
                 slug: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PluginInstallation resources.
        :param pulumi.Input[_builtins.str] slug: Slug of the plugin to be installed.
        :param pulumi.Input[_builtins.str] stack_slug: The stack id to which the plugin should be installed.
        """
        if slug is not None:
            pulumi.set(__self__, "slug", slug)
        if stack_slug is not None:
            pulumi.set(__self__, "stack_slug", stack_slug)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Slug of the plugin to be installed.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slug", value)

    @_builtins.property
    @pulumi.getter(name="stackSlug")
    def stack_slug(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The stack id to which the plugin should be installed.
        """
        return pulumi.get(self, "stack_slug")

    @stack_slug.setter
    def stack_slug(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_slug", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("grafana:cloud/pluginInstallation:PluginInstallation")
class PluginInstallation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 slug: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Grafana Cloud Plugin Installations.

        * [Plugin Catalog](https://grafana.com/grafana/plugins/)

        Required access policy scopes:

        * stack-plugins:read
        * stack-plugins:write
        * stack-plugins:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.cloud.PluginInstallation("test",
            stack_slug="stackname",
            slug="some-plugin",
            version="1.2.3")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/pluginInstallation:PluginInstallation name "{{ stackSlug }}:{{ pluginSlug }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] slug: Slug of the plugin to be installed.
        :param pulumi.Input[_builtins.str] stack_slug: The stack id to which the plugin should be installed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluginInstallationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Grafana Cloud Plugin Installations.

        * [Plugin Catalog](https://grafana.com/grafana/plugins/)

        Required access policy scopes:

        * stack-plugins:read
        * stack-plugins:write
        * stack-plugins:delete

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.cloud.PluginInstallation("test",
            stack_slug="stackname",
            slug="some-plugin",
            version="1.2.3")
        ```

        ## Import

        ```sh
        $ pulumi import grafana:cloud/pluginInstallation:PluginInstallation name "{{ stackSlug }}:{{ pluginSlug }}"
        ```

        :param str resource_name: The name of the resource.
        :param PluginInstallationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluginInstallationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 slug: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluginInstallationArgs.__new__(PluginInstallationArgs)

            if slug is None and not opts.urn:
                raise TypeError("Missing required property 'slug'")
            __props__.__dict__["slug"] = slug
            if stack_slug is None and not opts.urn:
                raise TypeError("Missing required property 'stack_slug'")
            __props__.__dict__["stack_slug"] = stack_slug
            __props__.__dict__["version"] = version
        super(PluginInstallation, __self__).__init__(
            'grafana:cloud/pluginInstallation:PluginInstallation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            slug: Optional[pulumi.Input[_builtins.str]] = None,
            stack_slug: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'PluginInstallation':
        """
        Get an existing PluginInstallation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] slug: Slug of the plugin to be installed.
        :param pulumi.Input[_builtins.str] stack_slug: The stack id to which the plugin should be installed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluginInstallationState.__new__(_PluginInstallationState)

        __props__.__dict__["slug"] = slug
        __props__.__dict__["stack_slug"] = stack_slug
        __props__.__dict__["version"] = version
        return PluginInstallation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def slug(self) -> pulumi.Output[_builtins.str]:
        """
        Slug of the plugin to be installed.
        """
        return pulumi.get(self, "slug")

    @_builtins.property
    @pulumi.getter(name="stackSlug")
    def stack_slug(self) -> pulumi.Output[_builtins.str]:
        """
        The stack id to which the plugin should be installed.
        """
        return pulumi.get(self, "stack_slug")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "version")

