# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetScheduleResult',
    'AwaitableGetScheduleResult',
    'get_schedule',
    'get_schedule_output',
]

@pulumi.output_type
class GetScheduleResult:
    """
    A collection of values returned by getSchedule.
    """
    def __init__(__self__, created_by=None, deactivated=None, id=None, load_test_id=None, next_run=None, recurrence_rule=None, starts=None):
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if deactivated and not isinstance(deactivated, bool):
            raise TypeError("Expected argument 'deactivated' to be a bool")
        pulumi.set(__self__, "deactivated", deactivated)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_test_id and not isinstance(load_test_id, str):
            raise TypeError("Expected argument 'load_test_id' to be a str")
        pulumi.set(__self__, "load_test_id", load_test_id)
        if next_run and not isinstance(next_run, str):
            raise TypeError("Expected argument 'next_run' to be a str")
        pulumi.set(__self__, "next_run", next_run)
        if recurrence_rule and not isinstance(recurrence_rule, dict):
            raise TypeError("Expected argument 'recurrence_rule' to be a dict")
        pulumi.set(__self__, "recurrence_rule", recurrence_rule)
        if starts and not isinstance(starts, str):
            raise TypeError("Expected argument 'starts' to be a str")
        pulumi.set(__self__, "starts", starts)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The email of the user who created the schedule.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def deactivated(self) -> _builtins.bool:
        """
        Whether the schedule is deactivated.
        """
        return pulumi.get(self, "deactivated")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Numeric identifier of the schedule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="loadTestId")
    def load_test_id(self) -> _builtins.str:
        """
        The identifier of the load test to retrieve the schedule for.
        """
        return pulumi.get(self, "load_test_id")

    @_builtins.property
    @pulumi.getter(name="nextRun")
    def next_run(self) -> _builtins.str:
        """
        The next scheduled execution time.
        """
        return pulumi.get(self, "next_run")

    @_builtins.property
    @pulumi.getter(name="recurrenceRule")
    def recurrence_rule(self) -> Optional['outputs.GetScheduleRecurrenceRuleResult']:
        """
        The schedule recurrence settings. If null, the test will run only once on the starts date.
        """
        return pulumi.get(self, "recurrence_rule")

    @_builtins.property
    @pulumi.getter
    def starts(self) -> _builtins.str:
        """
        The start time for the schedule (RFC3339 format).
        """
        return pulumi.get(self, "starts")


class AwaitableGetScheduleResult(GetScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduleResult(
            created_by=self.created_by,
            deactivated=self.deactivated,
            id=self.id,
            load_test_id=self.load_test_id,
            next_run=self.next_run,
            recurrence_rule=self.recurrence_rule,
            starts=self.starts)


def get_schedule(load_test_id: Optional[_builtins.str] = None,
                 recurrence_rule: Optional[Union['GetScheduleRecurrenceRuleArgs', 'GetScheduleRecurrenceRuleArgsDict']] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduleResult:
    """
    Retrieves a k6 schedule.


    :param _builtins.str load_test_id: The identifier of the load test to retrieve the schedule for.
    :param Union['GetScheduleRecurrenceRuleArgs', 'GetScheduleRecurrenceRuleArgsDict'] recurrence_rule: The schedule recurrence settings. If null, the test will run only once on the starts date.
    """
    __args__ = dict()
    __args__['loadTestId'] = load_test_id
    __args__['recurrenceRule'] = recurrence_rule
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:k6/getSchedule:getSchedule', __args__, opts=opts, typ=GetScheduleResult).value

    return AwaitableGetScheduleResult(
        created_by=pulumi.get(__ret__, 'created_by'),
        deactivated=pulumi.get(__ret__, 'deactivated'),
        id=pulumi.get(__ret__, 'id'),
        load_test_id=pulumi.get(__ret__, 'load_test_id'),
        next_run=pulumi.get(__ret__, 'next_run'),
        recurrence_rule=pulumi.get(__ret__, 'recurrence_rule'),
        starts=pulumi.get(__ret__, 'starts'))
def get_schedule_output(load_test_id: Optional[pulumi.Input[_builtins.str]] = None,
                        recurrence_rule: Optional[pulumi.Input[Optional[Union['GetScheduleRecurrenceRuleArgs', 'GetScheduleRecurrenceRuleArgsDict']]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduleResult]:
    """
    Retrieves a k6 schedule.


    :param _builtins.str load_test_id: The identifier of the load test to retrieve the schedule for.
    :param Union['GetScheduleRecurrenceRuleArgs', 'GetScheduleRecurrenceRuleArgsDict'] recurrence_rule: The schedule recurrence settings. If null, the test will run only once on the starts date.
    """
    __args__ = dict()
    __args__['loadTestId'] = load_test_id
    __args__['recurrenceRule'] = recurrence_rule
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:k6/getSchedule:getSchedule', __args__, opts=opts, typ=GetScheduleResult)
    return __ret__.apply(lambda __response__: GetScheduleResult(
        created_by=pulumi.get(__response__, 'created_by'),
        deactivated=pulumi.get(__response__, 'deactivated'),
        id=pulumi.get(__response__, 'id'),
        load_test_id=pulumi.get(__response__, 'load_test_id'),
        next_run=pulumi.get(__response__, 'next_run'),
        recurrence_rule=pulumi.get(__response__, 'recurrence_rule'),
        starts=pulumi.get(__response__, 'starts')))
