# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstallationArgs', 'Installation']

@pulumi.input_type
class InstallationArgs:
    def __init__(__self__, *,
                 cloud_access_policy_token: pulumi.Input[_builtins.str],
                 grafana_sa_token: pulumi.Input[_builtins.str],
                 grafana_user: pulumi.Input[_builtins.str],
                 stack_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Installation resource.
        :param pulumi.Input[_builtins.str] cloud_access_policy_token: The [Grafana Cloud access policy](https://grafana.com/docs/grafana-cloud/account-management/authentication-and-permissions/access-policies/).
        :param pulumi.Input[_builtins.str] grafana_sa_token: The [service account](https://grafana.com/docs/grafana/latest/administration/service-accounts/) token.
        :param pulumi.Input[_builtins.str] grafana_user: The user to use for the installation.
        :param pulumi.Input[_builtins.str] stack_id: The identifier of the stack to install k6 on.
        """
        pulumi.set(__self__, "cloud_access_policy_token", cloud_access_policy_token)
        pulumi.set(__self__, "grafana_sa_token", grafana_sa_token)
        pulumi.set(__self__, "grafana_user", grafana_user)
        pulumi.set(__self__, "stack_id", stack_id)

    @_builtins.property
    @pulumi.getter(name="cloudAccessPolicyToken")
    def cloud_access_policy_token(self) -> pulumi.Input[_builtins.str]:
        """
        The [Grafana Cloud access policy](https://grafana.com/docs/grafana-cloud/account-management/authentication-and-permissions/access-policies/).
        """
        return pulumi.get(self, "cloud_access_policy_token")

    @cloud_access_policy_token.setter
    def cloud_access_policy_token(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_access_policy_token", value)

    @_builtins.property
    @pulumi.getter(name="grafanaSaToken")
    def grafana_sa_token(self) -> pulumi.Input[_builtins.str]:
        """
        The [service account](https://grafana.com/docs/grafana/latest/administration/service-accounts/) token.
        """
        return pulumi.get(self, "grafana_sa_token")

    @grafana_sa_token.setter
    def grafana_sa_token(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "grafana_sa_token", value)

    @_builtins.property
    @pulumi.getter(name="grafanaUser")
    def grafana_user(self) -> pulumi.Input[_builtins.str]:
        """
        The user to use for the installation.
        """
        return pulumi.get(self, "grafana_user")

    @grafana_user.setter
    def grafana_user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "grafana_user", value)

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the stack to install k6 on.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_id", value)


@pulumi.input_type
class _InstallationState:
    def __init__(__self__, *,
                 cloud_access_policy_token: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_sa_token: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_user: Optional[pulumi.Input[_builtins.str]] = None,
                 k6_access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 k6_organization: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Installation resources.
        :param pulumi.Input[_builtins.str] cloud_access_policy_token: The [Grafana Cloud access policy](https://grafana.com/docs/grafana-cloud/account-management/authentication-and-permissions/access-policies/).
        :param pulumi.Input[_builtins.str] grafana_sa_token: The [service account](https://grafana.com/docs/grafana/latest/administration/service-accounts/) token.
        :param pulumi.Input[_builtins.str] grafana_user: The user to use for the installation.
        :param pulumi.Input[_builtins.str] k6_access_token: Generated token to access the k6 API.
        :param pulumi.Input[_builtins.str] k6_organization: The identifier of the k6 organization.
        :param pulumi.Input[_builtins.str] stack_id: The identifier of the stack to install k6 on.
        """
        if cloud_access_policy_token is not None:
            pulumi.set(__self__, "cloud_access_policy_token", cloud_access_policy_token)
        if grafana_sa_token is not None:
            pulumi.set(__self__, "grafana_sa_token", grafana_sa_token)
        if grafana_user is not None:
            pulumi.set(__self__, "grafana_user", grafana_user)
        if k6_access_token is not None:
            pulumi.set(__self__, "k6_access_token", k6_access_token)
        if k6_organization is not None:
            pulumi.set(__self__, "k6_organization", k6_organization)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)

    @_builtins.property
    @pulumi.getter(name="cloudAccessPolicyToken")
    def cloud_access_policy_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [Grafana Cloud access policy](https://grafana.com/docs/grafana-cloud/account-management/authentication-and-permissions/access-policies/).
        """
        return pulumi.get(self, "cloud_access_policy_token")

    @cloud_access_policy_token.setter
    def cloud_access_policy_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_access_policy_token", value)

    @_builtins.property
    @pulumi.getter(name="grafanaSaToken")
    def grafana_sa_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [service account](https://grafana.com/docs/grafana/latest/administration/service-accounts/) token.
        """
        return pulumi.get(self, "grafana_sa_token")

    @grafana_sa_token.setter
    def grafana_sa_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_sa_token", value)

    @_builtins.property
    @pulumi.getter(name="grafanaUser")
    def grafana_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user to use for the installation.
        """
        return pulumi.get(self, "grafana_user")

    @grafana_user.setter
    def grafana_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_user", value)

    @_builtins.property
    @pulumi.getter(name="k6AccessToken")
    def k6_access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generated token to access the k6 API.
        """
        return pulumi.get(self, "k6_access_token")

    @k6_access_token.setter
    def k6_access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "k6_access_token", value)

    @_builtins.property
    @pulumi.getter(name="k6Organization")
    def k6_organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the k6 organization.
        """
        return pulumi.get(self, "k6_organization")

    @k6_organization.setter
    def k6_organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "k6_organization", value)

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the stack to install k6 on.
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_id", value)


@pulumi.type_token("grafana:k6/installation:Installation")
class Installation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_access_policy_token: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_sa_token: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_user: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Sets up the k6 App on a Grafana Cloud instance and generates a token.
        Once a Grafana Cloud stack is created, a user can either use this resource or go into the UI to install k6.
        This resource cannot be imported but it can be used on an existing k6 App installation without issues.

        **Note that this resource must be used on a provider configured with Grafana Cloud credentials.**

        * [Official documentation](https://grafana.com/docs/grafana-cloud/testing/k6/)

        Required access policy scopes:

        * stacks:read
        * stacks:write
        * subscriptions:read
        * orgs:read

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        config = pulumi.Config()
        # Cloud Access Policy token for Grafana Cloud with the following scopes: stacks:read|write|delete, stack-service-accounts:write
        cloud_access_policy_token = config.require_object("cloudAccessPolicyToken")
        stack_slug = config.require_object("stackSlug")
        cloud_region = config.get("cloudRegion")
        if cloud_region is None:
            cloud_region = "us"
        k6_stack = grafana.cloud.Stack("k6_stack",
            name=stack_slug,
            slug=stack_slug,
            region_slug=cloud_region)
        # Step 2: Create a Service Account and a token to install the k6 App
        k6_sa = grafana.cloud.StackServiceAccount("k6_sa",
            stack_slug=stack_slug,
            name=f"{stack_slug}-k6-app",
            role="Admin",
            is_disabled=False)
        k6_sa_token = grafana.cloud.StackServiceAccountToken("k6_sa_token",
            stack_slug=stack_slug,
            name=f"{stack_slug}-k6-app-token",
            service_account_id=k6_sa.id)
        # Step 3: Install the k6 App on the stack
        k6_installation = grafana.k6.Installation("k6_installation",
            cloud_access_policy_token=cloud_access_policy_token,
            stack_id=k6_stack.id,
            grafana_sa_token=k6_sa_token.key,
            grafana_user="admin")
        my_k6_project = grafana.k6.Project("my_k6_project", name="k6 Project created with TF")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_access_policy_token: The [Grafana Cloud access policy](https://grafana.com/docs/grafana-cloud/account-management/authentication-and-permissions/access-policies/).
        :param pulumi.Input[_builtins.str] grafana_sa_token: The [service account](https://grafana.com/docs/grafana/latest/administration/service-accounts/) token.
        :param pulumi.Input[_builtins.str] grafana_user: The user to use for the installation.
        :param pulumi.Input[_builtins.str] stack_id: The identifier of the stack to install k6 on.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstallationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Sets up the k6 App on a Grafana Cloud instance and generates a token.
        Once a Grafana Cloud stack is created, a user can either use this resource or go into the UI to install k6.
        This resource cannot be imported but it can be used on an existing k6 App installation without issues.

        **Note that this resource must be used on a provider configured with Grafana Cloud credentials.**

        * [Official documentation](https://grafana.com/docs/grafana-cloud/testing/k6/)

        Required access policy scopes:

        * stacks:read
        * stacks:write
        * subscriptions:read
        * orgs:read

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        config = pulumi.Config()
        # Cloud Access Policy token for Grafana Cloud with the following scopes: stacks:read|write|delete, stack-service-accounts:write
        cloud_access_policy_token = config.require_object("cloudAccessPolicyToken")
        stack_slug = config.require_object("stackSlug")
        cloud_region = config.get("cloudRegion")
        if cloud_region is None:
            cloud_region = "us"
        k6_stack = grafana.cloud.Stack("k6_stack",
            name=stack_slug,
            slug=stack_slug,
            region_slug=cloud_region)
        # Step 2: Create a Service Account and a token to install the k6 App
        k6_sa = grafana.cloud.StackServiceAccount("k6_sa",
            stack_slug=stack_slug,
            name=f"{stack_slug}-k6-app",
            role="Admin",
            is_disabled=False)
        k6_sa_token = grafana.cloud.StackServiceAccountToken("k6_sa_token",
            stack_slug=stack_slug,
            name=f"{stack_slug}-k6-app-token",
            service_account_id=k6_sa.id)
        # Step 3: Install the k6 App on the stack
        k6_installation = grafana.k6.Installation("k6_installation",
            cloud_access_policy_token=cloud_access_policy_token,
            stack_id=k6_stack.id,
            grafana_sa_token=k6_sa_token.key,
            grafana_user="admin")
        my_k6_project = grafana.k6.Project("my_k6_project", name="k6 Project created with TF")
        ```

        :param str resource_name: The name of the resource.
        :param InstallationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstallationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_access_policy_token: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_sa_token: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_user: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstallationArgs.__new__(InstallationArgs)

            if cloud_access_policy_token is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_access_policy_token'")
            __props__.__dict__["cloud_access_policy_token"] = None if cloud_access_policy_token is None else pulumi.Output.secret(cloud_access_policy_token)
            if grafana_sa_token is None and not opts.urn:
                raise TypeError("Missing required property 'grafana_sa_token'")
            __props__.__dict__["grafana_sa_token"] = None if grafana_sa_token is None else pulumi.Output.secret(grafana_sa_token)
            if grafana_user is None and not opts.urn:
                raise TypeError("Missing required property 'grafana_user'")
            __props__.__dict__["grafana_user"] = grafana_user
            if stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_id'")
            __props__.__dict__["stack_id"] = stack_id
            __props__.__dict__["k6_access_token"] = None
            __props__.__dict__["k6_organization"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["cloudAccessPolicyToken", "grafanaSaToken", "k6AccessToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Installation, __self__).__init__(
            'grafana:k6/installation:Installation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_access_policy_token: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_sa_token: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_user: Optional[pulumi.Input[_builtins.str]] = None,
            k6_access_token: Optional[pulumi.Input[_builtins.str]] = None,
            k6_organization: Optional[pulumi.Input[_builtins.str]] = None,
            stack_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Installation':
        """
        Get an existing Installation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_access_policy_token: The [Grafana Cloud access policy](https://grafana.com/docs/grafana-cloud/account-management/authentication-and-permissions/access-policies/).
        :param pulumi.Input[_builtins.str] grafana_sa_token: The [service account](https://grafana.com/docs/grafana/latest/administration/service-accounts/) token.
        :param pulumi.Input[_builtins.str] grafana_user: The user to use for the installation.
        :param pulumi.Input[_builtins.str] k6_access_token: Generated token to access the k6 API.
        :param pulumi.Input[_builtins.str] k6_organization: The identifier of the k6 organization.
        :param pulumi.Input[_builtins.str] stack_id: The identifier of the stack to install k6 on.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstallationState.__new__(_InstallationState)

        __props__.__dict__["cloud_access_policy_token"] = cloud_access_policy_token
        __props__.__dict__["grafana_sa_token"] = grafana_sa_token
        __props__.__dict__["grafana_user"] = grafana_user
        __props__.__dict__["k6_access_token"] = k6_access_token
        __props__.__dict__["k6_organization"] = k6_organization
        __props__.__dict__["stack_id"] = stack_id
        return Installation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudAccessPolicyToken")
    def cloud_access_policy_token(self) -> pulumi.Output[_builtins.str]:
        """
        The [Grafana Cloud access policy](https://grafana.com/docs/grafana-cloud/account-management/authentication-and-permissions/access-policies/).
        """
        return pulumi.get(self, "cloud_access_policy_token")

    @_builtins.property
    @pulumi.getter(name="grafanaSaToken")
    def grafana_sa_token(self) -> pulumi.Output[_builtins.str]:
        """
        The [service account](https://grafana.com/docs/grafana/latest/administration/service-accounts/) token.
        """
        return pulumi.get(self, "grafana_sa_token")

    @_builtins.property
    @pulumi.getter(name="grafanaUser")
    def grafana_user(self) -> pulumi.Output[_builtins.str]:
        """
        The user to use for the installation.
        """
        return pulumi.get(self, "grafana_user")

    @_builtins.property
    @pulumi.getter(name="k6AccessToken")
    def k6_access_token(self) -> pulumi.Output[_builtins.str]:
        """
        Generated token to access the k6 API.
        """
        return pulumi.get(self, "k6_access_token")

    @_builtins.property
    @pulumi.getter(name="k6Organization")
    def k6_organization(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the k6 organization.
        """
        return pulumi.get(self, "k6_organization")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the stack to install k6 on.
        """
        return pulumi.get(self, "stack_id")

