# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduleArgs', 'Schedule']

@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 enable_web_overrides: Optional[pulumi.Input[_builtins.bool]] = None,
                 ical_url_overrides: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_url_primary: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 shifts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 slack: Optional[pulumi.Input['ScheduleSlackArgs']] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Schedule resource.
        :param pulumi.Input[_builtins.str] type: The schedule's type. Valid values are `ical`, `calendar`, `web`.
        :param pulumi.Input[_builtins.bool] enable_web_overrides: Enable overrides via web UI (it will ignore ical*url*overrides).
        :param pulumi.Input[_builtins.str] ical_url_overrides: The URL of external iCal calendar which override primary events.
        :param pulumi.Input[_builtins.str] ical_url_primary: The URL of the external calendar iCal file.
        :param pulumi.Input[_builtins.str] name: The schedule's name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shifts: The list of ID's of on-call shifts.
        :param pulumi.Input['ScheduleSlackArgs'] slack: The Slack-specific settings for a schedule.
        :param pulumi.Input[_builtins.str] team_id: The ID of the OnCall team (using the `on_call_get_team` datasource).
        :param pulumi.Input[_builtins.str] time_zone: The schedule's time zone.
        """
        pulumi.set(__self__, "type", type)
        if enable_web_overrides is not None:
            pulumi.set(__self__, "enable_web_overrides", enable_web_overrides)
        if ical_url_overrides is not None:
            pulumi.set(__self__, "ical_url_overrides", ical_url_overrides)
        if ical_url_primary is not None:
            pulumi.set(__self__, "ical_url_primary", ical_url_primary)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shifts is not None:
            pulumi.set(__self__, "shifts", shifts)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The schedule's type. Valid values are `ical`, `calendar`, `web`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="enableWebOverrides")
    def enable_web_overrides(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable overrides via web UI (it will ignore ical*url*overrides).
        """
        return pulumi.get(self, "enable_web_overrides")

    @enable_web_overrides.setter
    def enable_web_overrides(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_web_overrides", value)

    @_builtins.property
    @pulumi.getter(name="icalUrlOverrides")
    def ical_url_overrides(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of external iCal calendar which override primary events.
        """
        return pulumi.get(self, "ical_url_overrides")

    @ical_url_overrides.setter
    def ical_url_overrides(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ical_url_overrides", value)

    @_builtins.property
    @pulumi.getter(name="icalUrlPrimary")
    def ical_url_primary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the external calendar iCal file.
        """
        return pulumi.get(self, "ical_url_primary")

    @ical_url_primary.setter
    def ical_url_primary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ical_url_primary", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def shifts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of ID's of on-call shifts.
        """
        return pulumi.get(self, "shifts")

    @shifts.setter
    def shifts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "shifts", value)

    @_builtins.property
    @pulumi.getter
    def slack(self) -> Optional[pulumi.Input['ScheduleSlackArgs']]:
        """
        The Slack-specific settings for a schedule.
        """
        return pulumi.get(self, "slack")

    @slack.setter
    def slack(self, value: Optional[pulumi.Input['ScheduleSlackArgs']]):
        pulumi.set(self, "slack", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the OnCall team (using the `on_call_get_team` datasource).
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule's time zone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _ScheduleState:
    def __init__(__self__, *,
                 enable_web_overrides: Optional[pulumi.Input[_builtins.bool]] = None,
                 ical_url_overrides: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_url_primary: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 shifts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 slack: Optional[pulumi.Input['ScheduleSlackArgs']] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Schedule resources.
        :param pulumi.Input[_builtins.bool] enable_web_overrides: Enable overrides via web UI (it will ignore ical*url*overrides).
        :param pulumi.Input[_builtins.str] ical_url_overrides: The URL of external iCal calendar which override primary events.
        :param pulumi.Input[_builtins.str] ical_url_primary: The URL of the external calendar iCal file.
        :param pulumi.Input[_builtins.str] name: The schedule's name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shifts: The list of ID's of on-call shifts.
        :param pulumi.Input['ScheduleSlackArgs'] slack: The Slack-specific settings for a schedule.
        :param pulumi.Input[_builtins.str] team_id: The ID of the OnCall team (using the `on_call_get_team` datasource).
        :param pulumi.Input[_builtins.str] time_zone: The schedule's time zone.
        :param pulumi.Input[_builtins.str] type: The schedule's type. Valid values are `ical`, `calendar`, `web`.
        """
        if enable_web_overrides is not None:
            pulumi.set(__self__, "enable_web_overrides", enable_web_overrides)
        if ical_url_overrides is not None:
            pulumi.set(__self__, "ical_url_overrides", ical_url_overrides)
        if ical_url_primary is not None:
            pulumi.set(__self__, "ical_url_primary", ical_url_primary)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if shifts is not None:
            pulumi.set(__self__, "shifts", shifts)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="enableWebOverrides")
    def enable_web_overrides(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable overrides via web UI (it will ignore ical*url*overrides).
        """
        return pulumi.get(self, "enable_web_overrides")

    @enable_web_overrides.setter
    def enable_web_overrides(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_web_overrides", value)

    @_builtins.property
    @pulumi.getter(name="icalUrlOverrides")
    def ical_url_overrides(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of external iCal calendar which override primary events.
        """
        return pulumi.get(self, "ical_url_overrides")

    @ical_url_overrides.setter
    def ical_url_overrides(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ical_url_overrides", value)

    @_builtins.property
    @pulumi.getter(name="icalUrlPrimary")
    def ical_url_primary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the external calendar iCal file.
        """
        return pulumi.get(self, "ical_url_primary")

    @ical_url_primary.setter
    def ical_url_primary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ical_url_primary", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def shifts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of ID's of on-call shifts.
        """
        return pulumi.get(self, "shifts")

    @shifts.setter
    def shifts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "shifts", value)

    @_builtins.property
    @pulumi.getter
    def slack(self) -> Optional[pulumi.Input['ScheduleSlackArgs']]:
        """
        The Slack-specific settings for a schedule.
        """
        return pulumi.get(self, "slack")

    @slack.setter
    def slack(self, value: Optional[pulumi.Input['ScheduleSlackArgs']]):
        pulumi.set(self, "slack", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the OnCall team (using the `on_call_get_team` datasource).
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule's time zone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule's type. Valid values are `ical`, `calendar`, `web`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("grafana:onCall/schedule:Schedule")
class Schedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_web_overrides: Optional[pulumi.Input[_builtins.bool]] = None,
                 ical_url_overrides: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_url_primary: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 shifts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 slack: Optional[pulumi.Input[Union['ScheduleSlackArgs', 'ScheduleSlackArgsDict']]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        * [HTTP API](https://grafana.com/docs/oncall/latest/oncall-api-reference/schedules/)

        ## Import

        ```sh
        $ pulumi import grafana:onCall/schedule:Schedule name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_web_overrides: Enable overrides via web UI (it will ignore ical*url*overrides).
        :param pulumi.Input[_builtins.str] ical_url_overrides: The URL of external iCal calendar which override primary events.
        :param pulumi.Input[_builtins.str] ical_url_primary: The URL of the external calendar iCal file.
        :param pulumi.Input[_builtins.str] name: The schedule's name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shifts: The list of ID's of on-call shifts.
        :param pulumi.Input[Union['ScheduleSlackArgs', 'ScheduleSlackArgsDict']] slack: The Slack-specific settings for a schedule.
        :param pulumi.Input[_builtins.str] team_id: The ID of the OnCall team (using the `on_call_get_team` datasource).
        :param pulumi.Input[_builtins.str] time_zone: The schedule's time zone.
        :param pulumi.Input[_builtins.str] type: The schedule's type. Valid values are `ical`, `calendar`, `web`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [HTTP API](https://grafana.com/docs/oncall/latest/oncall-api-reference/schedules/)

        ## Import

        ```sh
        $ pulumi import grafana:onCall/schedule:Schedule name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param ScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_web_overrides: Optional[pulumi.Input[_builtins.bool]] = None,
                 ical_url_overrides: Optional[pulumi.Input[_builtins.str]] = None,
                 ical_url_primary: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 shifts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 slack: Optional[pulumi.Input[Union['ScheduleSlackArgs', 'ScheduleSlackArgsDict']]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduleArgs.__new__(ScheduleArgs)

            __props__.__dict__["enable_web_overrides"] = enable_web_overrides
            __props__.__dict__["ical_url_overrides"] = ical_url_overrides
            __props__.__dict__["ical_url_primary"] = ical_url_primary
            __props__.__dict__["name"] = name
            __props__.__dict__["shifts"] = shifts
            __props__.__dict__["slack"] = slack
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["time_zone"] = time_zone
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(Schedule, __self__).__init__(
            'grafana:onCall/schedule:Schedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_web_overrides: Optional[pulumi.Input[_builtins.bool]] = None,
            ical_url_overrides: Optional[pulumi.Input[_builtins.str]] = None,
            ical_url_primary: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            shifts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            slack: Optional[pulumi.Input[Union['ScheduleSlackArgs', 'ScheduleSlackArgsDict']]] = None,
            team_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Schedule':
        """
        Get an existing Schedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enable_web_overrides: Enable overrides via web UI (it will ignore ical*url*overrides).
        :param pulumi.Input[_builtins.str] ical_url_overrides: The URL of external iCal calendar which override primary events.
        :param pulumi.Input[_builtins.str] ical_url_primary: The URL of the external calendar iCal file.
        :param pulumi.Input[_builtins.str] name: The schedule's name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shifts: The list of ID's of on-call shifts.
        :param pulumi.Input[Union['ScheduleSlackArgs', 'ScheduleSlackArgsDict']] slack: The Slack-specific settings for a schedule.
        :param pulumi.Input[_builtins.str] team_id: The ID of the OnCall team (using the `on_call_get_team` datasource).
        :param pulumi.Input[_builtins.str] time_zone: The schedule's time zone.
        :param pulumi.Input[_builtins.str] type: The schedule's type. Valid values are `ical`, `calendar`, `web`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduleState.__new__(_ScheduleState)

        __props__.__dict__["enable_web_overrides"] = enable_web_overrides
        __props__.__dict__["ical_url_overrides"] = ical_url_overrides
        __props__.__dict__["ical_url_primary"] = ical_url_primary
        __props__.__dict__["name"] = name
        __props__.__dict__["shifts"] = shifts
        __props__.__dict__["slack"] = slack
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["type"] = type
        return Schedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enableWebOverrides")
    def enable_web_overrides(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable overrides via web UI (it will ignore ical*url*overrides).
        """
        return pulumi.get(self, "enable_web_overrides")

    @_builtins.property
    @pulumi.getter(name="icalUrlOverrides")
    def ical_url_overrides(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL of external iCal calendar which override primary events.
        """
        return pulumi.get(self, "ical_url_overrides")

    @_builtins.property
    @pulumi.getter(name="icalUrlPrimary")
    def ical_url_primary(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL of the external calendar iCal file.
        """
        return pulumi.get(self, "ical_url_primary")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The schedule's name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def shifts(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of ID's of on-call shifts.
        """
        return pulumi.get(self, "shifts")

    @_builtins.property
    @pulumi.getter
    def slack(self) -> pulumi.Output[Optional['outputs.ScheduleSlack']]:
        """
        The Slack-specific settings for a schedule.
        """
        return pulumi.get(self, "slack")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the OnCall team (using the `on_call_get_team` datasource).
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The schedule's time zone.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The schedule's type. Valid values are `ical`, `calendar`, `web`.
        """
        return pulumi.get(self, "type")

