# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DashboardPermissionPermissionArgs',
    'DashboardPermissionPermissionArgsDict',
    'FolderPermissionPermissionArgs',
    'FolderPermissionPermissionArgsDict',
    'PlaylistItemArgs',
    'PlaylistItemArgsDict',
    'ServiceAccountPermissionPermissionArgs',
    'ServiceAccountPermissionPermissionArgsDict',
    'SsoSettingsLdapSettingsArgs',
    'SsoSettingsLdapSettingsArgsDict',
    'SsoSettingsLdapSettingsConfigArgs',
    'SsoSettingsLdapSettingsConfigArgsDict',
    'SsoSettingsLdapSettingsConfigServerArgs',
    'SsoSettingsLdapSettingsConfigServerArgsDict',
    'SsoSettingsLdapSettingsConfigServerGroupMappingArgs',
    'SsoSettingsLdapSettingsConfigServerGroupMappingArgsDict',
    'SsoSettingsOauth2SettingsArgs',
    'SsoSettingsOauth2SettingsArgsDict',
    'SsoSettingsSamlSettingsArgs',
    'SsoSettingsSamlSettingsArgsDict',
    'TeamPreferencesArgs',
    'TeamPreferencesArgsDict',
    'TeamTeamSyncArgs',
    'TeamTeamSyncArgsDict',
]

MYPY = False

if not MYPY:
    class DashboardPermissionPermissionArgsDict(TypedDict):
        permission: pulumi.Input[_builtins.str]
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        """
        team_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        user_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
elif False:
    DashboardPermissionPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DashboardPermissionPermissionArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[_builtins.str],
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param pulumi.Input[_builtins.str] role: Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        :param pulumi.Input[_builtins.str] team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param pulumi.Input[_builtins.str] user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Input[_builtins.str]:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


if not MYPY:
    class FolderPermissionPermissionArgsDict(TypedDict):
        permission: pulumi.Input[_builtins.str]
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        """
        team_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        user_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
elif False:
    FolderPermissionPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FolderPermissionPermissionArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[_builtins.str],
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param pulumi.Input[_builtins.str] role: Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        :param pulumi.Input[_builtins.str] team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param pulumi.Input[_builtins.str] user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Input[_builtins.str]:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


if not MYPY:
    class PlaylistItemArgsDict(TypedDict):
        order: pulumi.Input[_builtins.int]
        title: pulumi.Input[_builtins.str]
        id: NotRequired[pulumi.Input[_builtins.str]]
        type: NotRequired[pulumi.Input[_builtins.str]]
        value: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    PlaylistItemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PlaylistItemArgs:
    def __init__(__self__, *,
                 order: pulumi.Input[_builtins.int],
                 title: pulumi.Input[_builtins.str],
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "title", title)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "order", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ServiceAccountPermissionPermissionArgsDict(TypedDict):
        permission: pulumi.Input[_builtins.str]
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        team_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        user_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
elif False:
    ServiceAccountPermissionPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceAccountPermissionPermissionArgs:
    def __init__(__self__, *,
                 permission: pulumi.Input[_builtins.str],
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param pulumi.Input[_builtins.str] team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param pulumi.Input[_builtins.str] user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Input[_builtins.str]:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


if not MYPY:
    class SsoSettingsLdapSettingsArgsDict(TypedDict):
        config: pulumi.Input['SsoSettingsLdapSettingsConfigArgsDict']
        """
        The LDAP configuration.
        """
        allow_sign_up: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to allow new Grafana user creation through LDAP login. If set to false, then only existing Grafana users can log in with LDAP.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Define whether this configuration is enabled for LDAP. Defaults to `true`.
        """
        skip_org_role_sync: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Prevent synchronizing users’ organization roles from LDAP.
        """
elif False:
    SsoSettingsLdapSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SsoSettingsLdapSettingsArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['SsoSettingsLdapSettingsConfigArgs'],
                 allow_sign_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_org_role_sync: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input['SsoSettingsLdapSettingsConfigArgs'] config: The LDAP configuration.
        :param pulumi.Input[_builtins.bool] allow_sign_up: Whether to allow new Grafana user creation through LDAP login. If set to false, then only existing Grafana users can log in with LDAP.
        :param pulumi.Input[_builtins.bool] enabled: Define whether this configuration is enabled for LDAP. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] skip_org_role_sync: Prevent synchronizing users’ organization roles from LDAP.
        """
        pulumi.set(__self__, "config", config)
        if allow_sign_up is not None:
            pulumi.set(__self__, "allow_sign_up", allow_sign_up)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if skip_org_role_sync is not None:
            pulumi.set(__self__, "skip_org_role_sync", skip_org_role_sync)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input['SsoSettingsLdapSettingsConfigArgs']:
        """
        The LDAP configuration.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['SsoSettingsLdapSettingsConfigArgs']):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="allowSignUp")
    def allow_sign_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow new Grafana user creation through LDAP login. If set to false, then only existing Grafana users can log in with LDAP.
        """
        return pulumi.get(self, "allow_sign_up")

    @allow_sign_up.setter
    def allow_sign_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_sign_up", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Define whether this configuration is enabled for LDAP. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="skipOrgRoleSync")
    def skip_org_role_sync(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent synchronizing users’ organization roles from LDAP.
        """
        return pulumi.get(self, "skip_org_role_sync")

    @skip_org_role_sync.setter
    def skip_org_role_sync(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_org_role_sync", value)


if not MYPY:
    class SsoSettingsLdapSettingsConfigArgsDict(TypedDict):
        servers: pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerArgsDict']]]
        """
        The LDAP servers configuration.
        """
elif False:
    SsoSettingsLdapSettingsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SsoSettingsLdapSettingsConfigArgs:
    def __init__(__self__, *,
                 servers: pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerArgs']]] servers: The LDAP servers configuration.
        """
        pulumi.set(__self__, "servers", servers)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerArgs']]]:
        """
        The LDAP servers configuration.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerArgs']]]):
        pulumi.set(self, "servers", value)


if not MYPY:
    class SsoSettingsLdapSettingsConfigServerArgsDict(TypedDict):
        host: pulumi.Input[_builtins.str]
        """
        The LDAP server host.
        """
        search_base_dns: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        An array of base DNs to search through.
        """
        search_filter: pulumi.Input[_builtins.str]
        """
        The user search filter, for example "(cn=%s)" or "(sAMAccountName=%s)" or "(uid=%s)".
        """
        attributes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        The LDAP server attributes. The following attributes can be configured: email, member_of, name, surname, username.
        """
        bind_dn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The search user bind DN.
        """
        bind_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        The search user bind password.
        """
        client_cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path to the client certificate.
        """
        client_cert_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Base64 encoded value of the client certificate.
        """
        client_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path to the client private key.
        """
        client_key_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Base64 encoded value of the client private key.
        """
        group_mappings: NotRequired[pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerGroupMappingArgsDict']]]]
        """
        For mapping an LDAP group to a Grafana organization and role.
        """
        group_search_base_dns: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        An array of the base DNs to search through for groups. Typically uses ou=groups.
        """
        group_search_filter: NotRequired[pulumi.Input[_builtins.str]]
        """
        Group search filter, to retrieve the groups of which the user is a member (only set if memberOf attribute is not available).
        """
        group_search_filter_user_attribute: NotRequired[pulumi.Input[_builtins.str]]
        """
        The %s in the search filter will be replaced with the attribute defined in this field.
        """
        min_tls_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Minimum TLS version allowed. Accepted values are: TLS1.2, TLS1.3.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The LDAP server port.
        """
        root_ca_cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path to the root CA certificate.
        """
        root_ca_cert_values: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The Base64 encoded values of the root CA certificates.
        """
        ssl_skip_verify: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If set to true, the SSL cert validation will be skipped.
        """
        start_tls: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If set to true, use LDAP with STARTTLS instead of LDAPS.
        """
        timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        The timeout in seconds for connecting to the LDAP host.
        """
        tls_ciphers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Accepted TLS ciphers. For a complete list of supported ciphers, refer to: https://go.dev/src/crypto/tls/cipher_suites.go.
        """
        use_ssl: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Set to true if LDAP server should use an encrypted TLS connection (either with STARTTLS or LDAPS).
        """
elif False:
    SsoSettingsLdapSettingsConfigServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SsoSettingsLdapSettingsConfigServerArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[_builtins.str],
                 search_base_dns: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 search_filter: pulumi.Input[_builtins.str],
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bind_dn: Optional[pulumi.Input[_builtins.str]] = None,
                 bind_password: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_cert_value: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key_value: Optional[pulumi.Input[_builtins.str]] = None,
                 group_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerGroupMappingArgs']]]] = None,
                 group_search_base_dns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 group_search_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 group_search_filter_user_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 min_tls_version: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 root_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 root_ca_cert_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ssl_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_tls: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_ssl: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] host: The LDAP server host.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] search_base_dns: An array of base DNs to search through.
        :param pulumi.Input[_builtins.str] search_filter: The user search filter, for example "(cn=%s)" or "(sAMAccountName=%s)" or "(uid=%s)".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attributes: The LDAP server attributes. The following attributes can be configured: email, member_of, name, surname, username.
        :param pulumi.Input[_builtins.str] bind_dn: The search user bind DN.
        :param pulumi.Input[_builtins.str] bind_password: The search user bind password.
        :param pulumi.Input[_builtins.str] client_cert: The path to the client certificate.
        :param pulumi.Input[_builtins.str] client_cert_value: The Base64 encoded value of the client certificate.
        :param pulumi.Input[_builtins.str] client_key: The path to the client private key.
        :param pulumi.Input[_builtins.str] client_key_value: The Base64 encoded value of the client private key.
        :param pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerGroupMappingArgs']]] group_mappings: For mapping an LDAP group to a Grafana organization and role.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_search_base_dns: An array of the base DNs to search through for groups. Typically uses ou=groups.
        :param pulumi.Input[_builtins.str] group_search_filter: Group search filter, to retrieve the groups of which the user is a member (only set if memberOf attribute is not available).
        :param pulumi.Input[_builtins.str] group_search_filter_user_attribute: The %s in the search filter will be replaced with the attribute defined in this field.
        :param pulumi.Input[_builtins.str] min_tls_version: Minimum TLS version allowed. Accepted values are: TLS1.2, TLS1.3.
        :param pulumi.Input[_builtins.int] port: The LDAP server port.
        :param pulumi.Input[_builtins.str] root_ca_cert: The path to the root CA certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] root_ca_cert_values: The Base64 encoded values of the root CA certificates.
        :param pulumi.Input[_builtins.bool] ssl_skip_verify: If set to true, the SSL cert validation will be skipped.
        :param pulumi.Input[_builtins.bool] start_tls: If set to true, use LDAP with STARTTLS instead of LDAPS.
        :param pulumi.Input[_builtins.int] timeout: The timeout in seconds for connecting to the LDAP host.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tls_ciphers: Accepted TLS ciphers. For a complete list of supported ciphers, refer to: https://go.dev/src/crypto/tls/cipher_suites.go.
        :param pulumi.Input[_builtins.bool] use_ssl: Set to true if LDAP server should use an encrypted TLS connection (either with STARTTLS or LDAPS).
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "search_base_dns", search_base_dns)
        pulumi.set(__self__, "search_filter", search_filter)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if bind_dn is not None:
            pulumi.set(__self__, "bind_dn", bind_dn)
        if bind_password is not None:
            pulumi.set(__self__, "bind_password", bind_password)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_cert_value is not None:
            pulumi.set(__self__, "client_cert_value", client_cert_value)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if client_key_value is not None:
            pulumi.set(__self__, "client_key_value", client_key_value)
        if group_mappings is not None:
            pulumi.set(__self__, "group_mappings", group_mappings)
        if group_search_base_dns is not None:
            pulumi.set(__self__, "group_search_base_dns", group_search_base_dns)
        if group_search_filter is not None:
            pulumi.set(__self__, "group_search_filter", group_search_filter)
        if group_search_filter_user_attribute is not None:
            pulumi.set(__self__, "group_search_filter_user_attribute", group_search_filter_user_attribute)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if root_ca_cert is not None:
            pulumi.set(__self__, "root_ca_cert", root_ca_cert)
        if root_ca_cert_values is not None:
            pulumi.set(__self__, "root_ca_cert_values", root_ca_cert_values)
        if ssl_skip_verify is not None:
            pulumi.set(__self__, "ssl_skip_verify", ssl_skip_verify)
        if start_tls is not None:
            pulumi.set(__self__, "start_tls", start_tls)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The LDAP server host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="searchBaseDns")
    def search_base_dns(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        An array of base DNs to search through.
        """
        return pulumi.get(self, "search_base_dns")

    @search_base_dns.setter
    def search_base_dns(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "search_base_dns", value)

    @_builtins.property
    @pulumi.getter(name="searchFilter")
    def search_filter(self) -> pulumi.Input[_builtins.str]:
        """
        The user search filter, for example "(cn=%s)" or "(sAMAccountName=%s)" or "(uid=%s)".
        """
        return pulumi.get(self, "search_filter")

    @search_filter.setter
    def search_filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "search_filter", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The LDAP server attributes. The following attributes can be configured: email, member_of, name, surname, username.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="bindDn")
    def bind_dn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The search user bind DN.
        """
        return pulumi.get(self, "bind_dn")

    @bind_dn.setter
    def bind_dn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bind_dn", value)

    @_builtins.property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The search user bind password.
        """
        return pulumi.get(self, "bind_password")

    @bind_password.setter
    def bind_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bind_password", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the client certificate.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientCertValue")
    def client_cert_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64 encoded value of the client certificate.
        """
        return pulumi.get(self, "client_cert_value")

    @client_cert_value.setter
    def client_cert_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert_value", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the client private key.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="clientKeyValue")
    def client_key_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64 encoded value of the client private key.
        """
        return pulumi.get(self, "client_key_value")

    @client_key_value.setter
    def client_key_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key_value", value)

    @_builtins.property
    @pulumi.getter(name="groupMappings")
    def group_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerGroupMappingArgs']]]]:
        """
        For mapping an LDAP group to a Grafana organization and role.
        """
        return pulumi.get(self, "group_mappings")

    @group_mappings.setter
    def group_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SsoSettingsLdapSettingsConfigServerGroupMappingArgs']]]]):
        pulumi.set(self, "group_mappings", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchBaseDns")
    def group_search_base_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of the base DNs to search through for groups. Typically uses ou=groups.
        """
        return pulumi.get(self, "group_search_base_dns")

    @group_search_base_dns.setter
    def group_search_base_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_search_base_dns", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchFilter")
    def group_search_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group search filter, to retrieve the groups of which the user is a member (only set if memberOf attribute is not available).
        """
        return pulumi.get(self, "group_search_filter")

    @group_search_filter.setter
    def group_search_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_filter", value)

    @_builtins.property
    @pulumi.getter(name="groupSearchFilterUserAttribute")
    def group_search_filter_user_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The %s in the search filter will be replaced with the attribute defined in this field.
        """
        return pulumi.get(self, "group_search_filter_user_attribute")

    @group_search_filter_user_attribute.setter
    def group_search_filter_user_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_search_filter_user_attribute", value)

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Minimum TLS version allowed. Accepted values are: TLS1.2, TLS1.3.
        """
        return pulumi.get(self, "min_tls_version")

    @min_tls_version.setter
    def min_tls_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_tls_version", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The LDAP server port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="rootCaCert")
    def root_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the root CA certificate.
        """
        return pulumi.get(self, "root_ca_cert")

    @root_ca_cert.setter
    def root_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="rootCaCertValues")
    def root_ca_cert_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Base64 encoded values of the root CA certificates.
        """
        return pulumi.get(self, "root_ca_cert_values")

    @root_ca_cert_values.setter
    def root_ca_cert_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "root_ca_cert_values", value)

    @_builtins.property
    @pulumi.getter(name="sslSkipVerify")
    def ssl_skip_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the SSL cert validation will be skipped.
        """
        return pulumi.get(self, "ssl_skip_verify")

    @ssl_skip_verify.setter
    def ssl_skip_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_skip_verify", value)

    @_builtins.property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, use LDAP with STARTTLS instead of LDAPS.
        """
        return pulumi.get(self, "start_tls")

    @start_tls.setter
    def start_tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_tls", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout in seconds for connecting to the LDAP host.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Accepted TLS ciphers. For a complete list of supported ciphers, refer to: https://go.dev/src/crypto/tls/cipher_suites.go.
        """
        return pulumi.get(self, "tls_ciphers")

    @tls_ciphers.setter
    def tls_ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tls_ciphers", value)

    @_builtins.property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true if LDAP server should use an encrypted TLS connection (either with STARTTLS or LDAPS).
        """
        return pulumi.get(self, "use_ssl")

    @use_ssl.setter
    def use_ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_ssl", value)


if not MYPY:
    class SsoSettingsLdapSettingsConfigServerGroupMappingArgsDict(TypedDict):
        group_dn: pulumi.Input[_builtins.str]
        """
        LDAP distinguished name (DN) of LDAP group. If you want to match all (or no LDAP groups) then you can use wildcard ("*").
        """
        org_role: pulumi.Input[_builtins.str]
        """
        Assign users of group_dn the organization role Admin, Editor, or Viewer.
        """
        grafana_admin: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If set to true, it makes the user of group_dn Grafana server admin.
        """
        org_id: NotRequired[pulumi.Input[_builtins.int]]
        """
        The Grafana organization database id.
        """
elif False:
    SsoSettingsLdapSettingsConfigServerGroupMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SsoSettingsLdapSettingsConfigServerGroupMappingArgs:
    def __init__(__self__, *,
                 group_dn: pulumi.Input[_builtins.str],
                 org_role: pulumi.Input[_builtins.str],
                 grafana_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 org_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] group_dn: LDAP distinguished name (DN) of LDAP group. If you want to match all (or no LDAP groups) then you can use wildcard ("*").
        :param pulumi.Input[_builtins.str] org_role: Assign users of group_dn the organization role Admin, Editor, or Viewer.
        :param pulumi.Input[_builtins.bool] grafana_admin: If set to true, it makes the user of group_dn Grafana server admin.
        :param pulumi.Input[_builtins.int] org_id: The Grafana organization database id.
        """
        pulumi.set(__self__, "group_dn", group_dn)
        pulumi.set(__self__, "org_role", org_role)
        if grafana_admin is not None:
            pulumi.set(__self__, "grafana_admin", grafana_admin)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)

    @_builtins.property
    @pulumi.getter(name="groupDn")
    def group_dn(self) -> pulumi.Input[_builtins.str]:
        """
        LDAP distinguished name (DN) of LDAP group. If you want to match all (or no LDAP groups) then you can use wildcard ("*").
        """
        return pulumi.get(self, "group_dn")

    @group_dn.setter
    def group_dn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_dn", value)

    @_builtins.property
    @pulumi.getter(name="orgRole")
    def org_role(self) -> pulumi.Input[_builtins.str]:
        """
        Assign users of group_dn the organization role Admin, Editor, or Viewer.
        """
        return pulumi.get(self, "org_role")

    @org_role.setter
    def org_role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_role", value)

    @_builtins.property
    @pulumi.getter(name="grafanaAdmin")
    def grafana_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, it makes the user of group_dn Grafana server admin.
        """
        return pulumi.get(self, "grafana_admin")

    @grafana_admin.setter
    def grafana_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "grafana_admin", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Grafana organization database id.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "org_id", value)


if not MYPY:
    class SsoSettingsOauth2SettingsArgsDict(TypedDict):
        client_id: pulumi.Input[_builtins.str]
        """
        The client Id of your OAuth2 app.
        """
        allow_assign_grafana_admin: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled, it will automatically sync the Grafana server administrator role.
        """
        allow_sign_up: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If not enabled, only existing Grafana users can log in using OAuth.
        """
        allowed_domains: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated domains. The user should belong to at least one domain to log in.
        """
        allowed_groups: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated groups. The user should be a member of at least one group to log in. For Generic OAuth, if you configure allowed*groups, you must also configure groups*attribute_path.
        """
        allowed_organizations: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated organizations. The user should be a member of at least one organization to log in.
        """
        api_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The user information endpoint of your OAuth2 provider. Required for okta and generic_oauth providers.
        """
        auth_style: NotRequired[pulumi.Input[_builtins.str]]
        """
        It determines how client*id and client*secret are sent to Oauth2 provider. Possible values are AutoDetect, InParams, InHeader. Default is AutoDetect.
        """
        auth_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authorization endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        """
        auto_login: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Log in automatically, skipping the login screen.
        """
        client_secret: NotRequired[pulumi.Input[_builtins.str]]
        """
        The client secret of your OAuth2 app.
        """
        custom: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Custom fields to configure for OAuth2 such as the [force*use*graph_api](https://grafana.com/docs/grafana/latest/setup-grafana/configure-security/configure-authentication/azuread/#force-fetching-groups-from-microsoft-graph-api) field.
        """
        define_allowed_groups: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Define allowed groups.
        """
        define_allowed_teams_ids: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Define allowed teams ids.
        """
        email_attribute_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the key to use for user email lookup within the attributes map of OAuth2 ID token. Only applicable to Generic OAuth.
        """
        email_attribute_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        JMESPath expression to use for user email lookup from the user information. Only applicable to Generic OAuth.
        """
        empty_scopes: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled, no scopes will be sent to the OAuth2 provider.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Define whether this configuration is enabled for the specified provider. Defaults to `true`.
        """
        groups_attribute_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        JMESPath expression to use for user group lookup. If you configure allowed*groups, you must also configure groups*attribute_path.
        """
        id_token_attribute_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the key used to extract the ID token from the returned OAuth2 token. Only applicable to Generic OAuth.
        """
        login_attribute_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        JMESPath expression to use for user login lookup from the user ID token. Only applicable to Generic OAuth.
        """
        login_prompt: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the type of user interaction when the user logs in with the IdP. Available values are `login`, `consent` and `select_account`.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Helpful if you use more than one identity providers or SSO protocols.
        """
        name_attribute_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        JMESPath expression to use for user name lookup from the user ID token. This name will be used as the user’s display name. Only applicable to Generic OAuth.
        """
        org_attribute_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        JMESPath expression to use for the organization mapping lookup from the user ID token. The extracted list will be used for the organization mapping (to match "Organization" in the "org_mapping"). Only applicable to Generic OAuth and Okta.
        """
        org_mapping: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated Organization:OrgIdOrOrgName:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: None, Viewer, Editor or Admin.
        """
        role_attribute_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        JMESPath expression to use for Grafana role lookup.
        """
        role_attribute_strict: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled, denies user login if the Grafana role cannot be extracted using Role attribute path.
        """
        scopes: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated OAuth2 scopes.
        """
        signout_redirect_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URL to redirect the user to after signing out from Grafana.
        """
        skip_org_role_sync: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Prevent synchronizing users’ organization roles from your IdP.
        """
        team_ids: NotRequired[pulumi.Input[_builtins.str]]
        """
        String list of Team Ids. If set, the user must be a member of one of the given teams to log in. If you configure team*ids, you must also configure teams*url and team*ids*attribute_path.
        """
        team_ids_attribute_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The JMESPath expression to use for Grafana Team Id lookup within the results returned by the teams_url endpoint. Only applicable to Generic OAuth.
        """
        teams_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URL used to query for Team Ids. If not set, the default value is /teams. If you configure teams*url, you must also configure team*ids*attribute*path. Only applicable to Generic OAuth.
        """
        tls_client_ca: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path to the trusted certificate authority list. Is not applicable on Grafana Cloud.
        """
        tls_client_cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path to the certificate. Is not applicable on Grafana Cloud.
        """
        tls_client_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The path to the key. Is not applicable on Grafana Cloud.
        """
        tls_skip_verify_insecure: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled, the client accepts any certificate presented by the server and any host name in that certificate. You should only use this for testing, because this mode leaves SSL/TLS susceptible to man-in-the-middle attacks.
        """
        token_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The token endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        """
        use_pkce: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled, Grafana will use Proof Key for Code Exchange (PKCE) with the OAuth2 Authorization Code Grant.
        """
        use_refresh_token: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled, Grafana will fetch a new access token using the refresh token provided by the OAuth2 provider.
        """
elif False:
    SsoSettingsOauth2SettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SsoSettingsOauth2SettingsArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 allow_assign_grafana_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_sign_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_domains: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_groups: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_organizations: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_style: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_url: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 custom: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 define_allowed_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 define_allowed_teams_ids: Optional[pulumi.Input[_builtins.bool]] = None,
                 email_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_attribute_path: Optional[pulumi.Input[_builtins.str]] = None,
                 empty_scopes: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 groups_attribute_path: Optional[pulumi.Input[_builtins.str]] = None,
                 id_token_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 login_attribute_path: Optional[pulumi.Input[_builtins.str]] = None,
                 login_prompt: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_attribute_path: Optional[pulumi.Input[_builtins.str]] = None,
                 org_attribute_path: Optional[pulumi.Input[_builtins.str]] = None,
                 org_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 role_attribute_path: Optional[pulumi.Input[_builtins.str]] = None,
                 role_attribute_strict: Optional[pulumi.Input[_builtins.bool]] = None,
                 scopes: Optional[pulumi.Input[_builtins.str]] = None,
                 signout_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_org_role_sync: Optional[pulumi.Input[_builtins.bool]] = None,
                 team_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 team_ids_attribute_path: Optional[pulumi.Input[_builtins.str]] = None,
                 teams_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_client_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_skip_verify_insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_url: Optional[pulumi.Input[_builtins.str]] = None,
                 use_pkce: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_refresh_token: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] client_id: The client Id of your OAuth2 app.
        :param pulumi.Input[_builtins.bool] allow_assign_grafana_admin: If enabled, it will automatically sync the Grafana server administrator role.
        :param pulumi.Input[_builtins.bool] allow_sign_up: If not enabled, only existing Grafana users can log in using OAuth.
        :param pulumi.Input[_builtins.str] allowed_domains: List of comma- or space-separated domains. The user should belong to at least one domain to log in.
        :param pulumi.Input[_builtins.str] allowed_groups: List of comma- or space-separated groups. The user should be a member of at least one group to log in. For Generic OAuth, if you configure allowed*groups, you must also configure groups*attribute_path.
        :param pulumi.Input[_builtins.str] allowed_organizations: List of comma- or space-separated organizations. The user should be a member of at least one organization to log in.
        :param pulumi.Input[_builtins.str] api_url: The user information endpoint of your OAuth2 provider. Required for okta and generic_oauth providers.
        :param pulumi.Input[_builtins.str] auth_style: It determines how client*id and client*secret are sent to Oauth2 provider. Possible values are AutoDetect, InParams, InHeader. Default is AutoDetect.
        :param pulumi.Input[_builtins.str] auth_url: The authorization endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        :param pulumi.Input[_builtins.bool] auto_login: Log in automatically, skipping the login screen.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of your OAuth2 app.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom: Custom fields to configure for OAuth2 such as the [force*use*graph_api](https://grafana.com/docs/grafana/latest/setup-grafana/configure-security/configure-authentication/azuread/#force-fetching-groups-from-microsoft-graph-api) field.
        :param pulumi.Input[_builtins.bool] define_allowed_groups: Define allowed groups.
        :param pulumi.Input[_builtins.bool] define_allowed_teams_ids: Define allowed teams ids.
        :param pulumi.Input[_builtins.str] email_attribute_name: Name of the key to use for user email lookup within the attributes map of OAuth2 ID token. Only applicable to Generic OAuth.
        :param pulumi.Input[_builtins.str] email_attribute_path: JMESPath expression to use for user email lookup from the user information. Only applicable to Generic OAuth.
        :param pulumi.Input[_builtins.bool] empty_scopes: If enabled, no scopes will be sent to the OAuth2 provider.
        :param pulumi.Input[_builtins.bool] enabled: Define whether this configuration is enabled for the specified provider. Defaults to `true`.
        :param pulumi.Input[_builtins.str] groups_attribute_path: JMESPath expression to use for user group lookup. If you configure allowed*groups, you must also configure groups*attribute_path.
        :param pulumi.Input[_builtins.str] id_token_attribute_name: The name of the key used to extract the ID token from the returned OAuth2 token. Only applicable to Generic OAuth.
        :param pulumi.Input[_builtins.str] login_attribute_path: JMESPath expression to use for user login lookup from the user ID token. Only applicable to Generic OAuth.
        :param pulumi.Input[_builtins.str] login_prompt: Indicates the type of user interaction when the user logs in with the IdP. Available values are `login`, `consent` and `select_account`.
        :param pulumi.Input[_builtins.str] name: Helpful if you use more than one identity providers or SSO protocols.
        :param pulumi.Input[_builtins.str] name_attribute_path: JMESPath expression to use for user name lookup from the user ID token. This name will be used as the user’s display name. Only applicable to Generic OAuth.
        :param pulumi.Input[_builtins.str] org_attribute_path: JMESPath expression to use for the organization mapping lookup from the user ID token. The extracted list will be used for the organization mapping (to match "Organization" in the "org_mapping"). Only applicable to Generic OAuth and Okta.
        :param pulumi.Input[_builtins.str] org_mapping: List of comma- or space-separated Organization:OrgIdOrOrgName:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: None, Viewer, Editor or Admin.
        :param pulumi.Input[_builtins.str] role_attribute_path: JMESPath expression to use for Grafana role lookup.
        :param pulumi.Input[_builtins.bool] role_attribute_strict: If enabled, denies user login if the Grafana role cannot be extracted using Role attribute path.
        :param pulumi.Input[_builtins.str] scopes: List of comma- or space-separated OAuth2 scopes.
        :param pulumi.Input[_builtins.str] signout_redirect_url: The URL to redirect the user to after signing out from Grafana.
        :param pulumi.Input[_builtins.bool] skip_org_role_sync: Prevent synchronizing users’ organization roles from your IdP.
        :param pulumi.Input[_builtins.str] team_ids: String list of Team Ids. If set, the user must be a member of one of the given teams to log in. If you configure team*ids, you must also configure teams*url and team*ids*attribute_path.
        :param pulumi.Input[_builtins.str] team_ids_attribute_path: The JMESPath expression to use for Grafana Team Id lookup within the results returned by the teams_url endpoint. Only applicable to Generic OAuth.
        :param pulumi.Input[_builtins.str] teams_url: The URL used to query for Team Ids. If not set, the default value is /teams. If you configure teams*url, you must also configure team*ids*attribute*path. Only applicable to Generic OAuth.
        :param pulumi.Input[_builtins.str] tls_client_ca: The path to the trusted certificate authority list. Is not applicable on Grafana Cloud.
        :param pulumi.Input[_builtins.str] tls_client_cert: The path to the certificate. Is not applicable on Grafana Cloud.
        :param pulumi.Input[_builtins.str] tls_client_key: The path to the key. Is not applicable on Grafana Cloud.
        :param pulumi.Input[_builtins.bool] tls_skip_verify_insecure: If enabled, the client accepts any certificate presented by the server and any host name in that certificate. You should only use this for testing, because this mode leaves SSL/TLS susceptible to man-in-the-middle attacks.
        :param pulumi.Input[_builtins.str] token_url: The token endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        :param pulumi.Input[_builtins.bool] use_pkce: If enabled, Grafana will use Proof Key for Code Exchange (PKCE) with the OAuth2 Authorization Code Grant.
        :param pulumi.Input[_builtins.bool] use_refresh_token: If enabled, Grafana will fetch a new access token using the refresh token provided by the OAuth2 provider.
        """
        pulumi.set(__self__, "client_id", client_id)
        if allow_assign_grafana_admin is not None:
            pulumi.set(__self__, "allow_assign_grafana_admin", allow_assign_grafana_admin)
        if allow_sign_up is not None:
            pulumi.set(__self__, "allow_sign_up", allow_sign_up)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_groups is not None:
            pulumi.set(__self__, "allowed_groups", allowed_groups)
        if allowed_organizations is not None:
            pulumi.set(__self__, "allowed_organizations", allowed_organizations)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if auth_style is not None:
            pulumi.set(__self__, "auth_style", auth_style)
        if auth_url is not None:
            pulumi.set(__self__, "auth_url", auth_url)
        if auto_login is not None:
            pulumi.set(__self__, "auto_login", auto_login)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if define_allowed_groups is not None:
            pulumi.set(__self__, "define_allowed_groups", define_allowed_groups)
        if define_allowed_teams_ids is not None:
            pulumi.set(__self__, "define_allowed_teams_ids", define_allowed_teams_ids)
        if email_attribute_name is not None:
            pulumi.set(__self__, "email_attribute_name", email_attribute_name)
        if email_attribute_path is not None:
            pulumi.set(__self__, "email_attribute_path", email_attribute_path)
        if empty_scopes is not None:
            pulumi.set(__self__, "empty_scopes", empty_scopes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if groups_attribute_path is not None:
            pulumi.set(__self__, "groups_attribute_path", groups_attribute_path)
        if id_token_attribute_name is not None:
            pulumi.set(__self__, "id_token_attribute_name", id_token_attribute_name)
        if login_attribute_path is not None:
            pulumi.set(__self__, "login_attribute_path", login_attribute_path)
        if login_prompt is not None:
            pulumi.set(__self__, "login_prompt", login_prompt)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_attribute_path is not None:
            pulumi.set(__self__, "name_attribute_path", name_attribute_path)
        if org_attribute_path is not None:
            pulumi.set(__self__, "org_attribute_path", org_attribute_path)
        if org_mapping is not None:
            pulumi.set(__self__, "org_mapping", org_mapping)
        if role_attribute_path is not None:
            pulumi.set(__self__, "role_attribute_path", role_attribute_path)
        if role_attribute_strict is not None:
            pulumi.set(__self__, "role_attribute_strict", role_attribute_strict)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if signout_redirect_url is not None:
            pulumi.set(__self__, "signout_redirect_url", signout_redirect_url)
        if skip_org_role_sync is not None:
            pulumi.set(__self__, "skip_org_role_sync", skip_org_role_sync)
        if team_ids is not None:
            pulumi.set(__self__, "team_ids", team_ids)
        if team_ids_attribute_path is not None:
            pulumi.set(__self__, "team_ids_attribute_path", team_ids_attribute_path)
        if teams_url is not None:
            pulumi.set(__self__, "teams_url", teams_url)
        if tls_client_ca is not None:
            pulumi.set(__self__, "tls_client_ca", tls_client_ca)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_skip_verify_insecure is not None:
            pulumi.set(__self__, "tls_skip_verify_insecure", tls_skip_verify_insecure)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)
        if use_pkce is not None:
            pulumi.set(__self__, "use_pkce", use_pkce)
        if use_refresh_token is not None:
            pulumi.set(__self__, "use_refresh_token", use_refresh_token)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client Id of your OAuth2 app.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="allowAssignGrafanaAdmin")
    def allow_assign_grafana_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, it will automatically sync the Grafana server administrator role.
        """
        return pulumi.get(self, "allow_assign_grafana_admin")

    @allow_assign_grafana_admin.setter
    def allow_assign_grafana_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_assign_grafana_admin", value)

    @_builtins.property
    @pulumi.getter(name="allowSignUp")
    def allow_sign_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If not enabled, only existing Grafana users can log in using OAuth.
        """
        return pulumi.get(self, "allow_sign_up")

    @allow_sign_up.setter
    def allow_sign_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_sign_up", value)

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated domains. The user should belong to at least one domain to log in.
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_domains", value)

    @_builtins.property
    @pulumi.getter(name="allowedGroups")
    def allowed_groups(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated groups. The user should be a member of at least one group to log in. For Generic OAuth, if you configure allowed*groups, you must also configure groups*attribute_path.
        """
        return pulumi.get(self, "allowed_groups")

    @allowed_groups.setter
    def allowed_groups(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_groups", value)

    @_builtins.property
    @pulumi.getter(name="allowedOrganizations")
    def allowed_organizations(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated organizations. The user should be a member of at least one organization to log in.
        """
        return pulumi.get(self, "allowed_organizations")

    @allowed_organizations.setter
    def allowed_organizations(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_organizations", value)

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user information endpoint of your OAuth2 provider. Required for okta and generic_oauth providers.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_url", value)

    @_builtins.property
    @pulumi.getter(name="authStyle")
    def auth_style(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It determines how client*id and client*secret are sent to Oauth2 provider. Possible values are AutoDetect, InParams, InHeader. Default is AutoDetect.
        """
        return pulumi.get(self, "auth_style")

    @auth_style.setter
    def auth_style(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_style", value)

    @_builtins.property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authorization endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        """
        return pulumi.get(self, "auth_url")

    @auth_url.setter
    def auth_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_url", value)

    @_builtins.property
    @pulumi.getter(name="autoLogin")
    def auto_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Log in automatically, skipping the login screen.
        """
        return pulumi.get(self, "auto_login")

    @auto_login.setter
    def auto_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_login", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret of your OAuth2 app.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter
    def custom(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Custom fields to configure for OAuth2 such as the [force*use*graph_api](https://grafana.com/docs/grafana/latest/setup-grafana/configure-security/configure-authentication/azuread/#force-fetching-groups-from-microsoft-graph-api) field.
        """
        return pulumi.get(self, "custom")

    @custom.setter
    def custom(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom", value)

    @_builtins.property
    @pulumi.getter(name="defineAllowedGroups")
    def define_allowed_groups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Define allowed groups.
        """
        return pulumi.get(self, "define_allowed_groups")

    @define_allowed_groups.setter
    def define_allowed_groups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "define_allowed_groups", value)

    @_builtins.property
    @pulumi.getter(name="defineAllowedTeamsIds")
    def define_allowed_teams_ids(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Define allowed teams ids.
        """
        return pulumi.get(self, "define_allowed_teams_ids")

    @define_allowed_teams_ids.setter
    def define_allowed_teams_ids(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "define_allowed_teams_ids", value)

    @_builtins.property
    @pulumi.getter(name="emailAttributeName")
    def email_attribute_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the key to use for user email lookup within the attributes map of OAuth2 ID token. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "email_attribute_name")

    @email_attribute_name.setter
    def email_attribute_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_attribute_name", value)

    @_builtins.property
    @pulumi.getter(name="emailAttributePath")
    def email_attribute_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JMESPath expression to use for user email lookup from the user information. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "email_attribute_path")

    @email_attribute_path.setter
    def email_attribute_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_attribute_path", value)

    @_builtins.property
    @pulumi.getter(name="emptyScopes")
    def empty_scopes(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, no scopes will be sent to the OAuth2 provider.
        """
        return pulumi.get(self, "empty_scopes")

    @empty_scopes.setter
    def empty_scopes(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "empty_scopes", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Define whether this configuration is enabled for the specified provider. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="groupsAttributePath")
    def groups_attribute_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JMESPath expression to use for user group lookup. If you configure allowed*groups, you must also configure groups*attribute_path.
        """
        return pulumi.get(self, "groups_attribute_path")

    @groups_attribute_path.setter
    def groups_attribute_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_attribute_path", value)

    @_builtins.property
    @pulumi.getter(name="idTokenAttributeName")
    def id_token_attribute_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the key used to extract the ID token from the returned OAuth2 token. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "id_token_attribute_name")

    @id_token_attribute_name.setter
    def id_token_attribute_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_token_attribute_name", value)

    @_builtins.property
    @pulumi.getter(name="loginAttributePath")
    def login_attribute_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JMESPath expression to use for user login lookup from the user ID token. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "login_attribute_path")

    @login_attribute_path.setter
    def login_attribute_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_attribute_path", value)

    @_builtins.property
    @pulumi.getter(name="loginPrompt")
    def login_prompt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the type of user interaction when the user logs in with the IdP. Available values are `login`, `consent` and `select_account`.
        """
        return pulumi.get(self, "login_prompt")

    @login_prompt.setter
    def login_prompt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_prompt", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Helpful if you use more than one identity providers or SSO protocols.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nameAttributePath")
    def name_attribute_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JMESPath expression to use for user name lookup from the user ID token. This name will be used as the user’s display name. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "name_attribute_path")

    @name_attribute_path.setter
    def name_attribute_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_attribute_path", value)

    @_builtins.property
    @pulumi.getter(name="orgAttributePath")
    def org_attribute_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JMESPath expression to use for the organization mapping lookup from the user ID token. The extracted list will be used for the organization mapping (to match "Organization" in the "org_mapping"). Only applicable to Generic OAuth and Okta.
        """
        return pulumi.get(self, "org_attribute_path")

    @org_attribute_path.setter
    def org_attribute_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_attribute_path", value)

    @_builtins.property
    @pulumi.getter(name="orgMapping")
    def org_mapping(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated Organization:OrgIdOrOrgName:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: None, Viewer, Editor or Admin.
        """
        return pulumi.get(self, "org_mapping")

    @org_mapping.setter
    def org_mapping(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_mapping", value)

    @_builtins.property
    @pulumi.getter(name="roleAttributePath")
    def role_attribute_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JMESPath expression to use for Grafana role lookup.
        """
        return pulumi.get(self, "role_attribute_path")

    @role_attribute_path.setter
    def role_attribute_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_attribute_path", value)

    @_builtins.property
    @pulumi.getter(name="roleAttributeStrict")
    def role_attribute_strict(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, denies user login if the Grafana role cannot be extracted using Role attribute path.
        """
        return pulumi.get(self, "role_attribute_strict")

    @role_attribute_strict.setter
    def role_attribute_strict(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "role_attribute_strict", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated OAuth2 scopes.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter(name="signoutRedirectUrl")
    def signout_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL to redirect the user to after signing out from Grafana.
        """
        return pulumi.get(self, "signout_redirect_url")

    @signout_redirect_url.setter
    def signout_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signout_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="skipOrgRoleSync")
    def skip_org_role_sync(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent synchronizing users’ organization roles from your IdP.
        """
        return pulumi.get(self, "skip_org_role_sync")

    @skip_org_role_sync.setter
    def skip_org_role_sync(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_org_role_sync", value)

    @_builtins.property
    @pulumi.getter(name="teamIds")
    def team_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String list of Team Ids. If set, the user must be a member of one of the given teams to log in. If you configure team*ids, you must also configure teams*url and team*ids*attribute_path.
        """
        return pulumi.get(self, "team_ids")

    @team_ids.setter
    def team_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_ids", value)

    @_builtins.property
    @pulumi.getter(name="teamIdsAttributePath")
    def team_ids_attribute_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The JMESPath expression to use for Grafana Team Id lookup within the results returned by the teams_url endpoint. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "team_ids_attribute_path")

    @team_ids_attribute_path.setter
    def team_ids_attribute_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_ids_attribute_path", value)

    @_builtins.property
    @pulumi.getter(name="teamsUrl")
    def teams_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL used to query for Team Ids. If not set, the default value is /teams. If you configure teams*url, you must also configure team*ids*attribute*path. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "teams_url")

    @teams_url.setter
    def teams_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "teams_url", value)

    @_builtins.property
    @pulumi.getter(name="tlsClientCa")
    def tls_client_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the trusted certificate authority list. Is not applicable on Grafana Cloud.
        """
        return pulumi.get(self, "tls_client_ca")

    @tls_client_ca.setter
    def tls_client_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_client_ca", value)

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the certificate. Is not applicable on Grafana Cloud.
        """
        return pulumi.get(self, "tls_client_cert")

    @tls_client_cert.setter
    def tls_client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_client_cert", value)

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the key. Is not applicable on Grafana Cloud.
        """
        return pulumi.get(self, "tls_client_key")

    @tls_client_key.setter
    def tls_client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_client_key", value)

    @_builtins.property
    @pulumi.getter(name="tlsSkipVerifyInsecure")
    def tls_skip_verify_insecure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, the client accepts any certificate presented by the server and any host name in that certificate. You should only use this for testing, because this mode leaves SSL/TLS susceptible to man-in-the-middle attacks.
        """
        return pulumi.get(self, "tls_skip_verify_insecure")

    @tls_skip_verify_insecure.setter
    def tls_skip_verify_insecure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls_skip_verify_insecure", value)

    @_builtins.property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        """
        return pulumi.get(self, "token_url")

    @token_url.setter
    def token_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_url", value)

    @_builtins.property
    @pulumi.getter(name="usePkce")
    def use_pkce(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Grafana will use Proof Key for Code Exchange (PKCE) with the OAuth2 Authorization Code Grant.
        """
        return pulumi.get(self, "use_pkce")

    @use_pkce.setter
    def use_pkce(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_pkce", value)

    @_builtins.property
    @pulumi.getter(name="useRefreshToken")
    def use_refresh_token(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Grafana will fetch a new access token using the refresh token provided by the OAuth2 provider.
        """
        return pulumi.get(self, "use_refresh_token")

    @use_refresh_token.setter
    def use_refresh_token(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_refresh_token", value)


if not MYPY:
    class SsoSettingsSamlSettingsArgsDict(TypedDict):
        allow_idp_initiated: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether SAML IdP-initiated login is allowed.
        """
        allow_sign_up: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to allow new Grafana user creation through SAML login. If set to false, then only existing Grafana users can log in with SAML.
        """
        allowed_organizations: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated organizations. User should be a member of at least one organization to log in.
        """
        assertion_attribute_email: NotRequired[pulumi.Input[_builtins.str]]
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user email.
        """
        assertion_attribute_groups: NotRequired[pulumi.Input[_builtins.str]]
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user groups.
        """
        assertion_attribute_login: NotRequired[pulumi.Input[_builtins.str]]
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user login handle.
        """
        assertion_attribute_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user name. Alternatively, this can be a template with variables that match the names of attributes within the SAML assertion.
        """
        assertion_attribute_org: NotRequired[pulumi.Input[_builtins.str]]
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user organization.
        """
        assertion_attribute_role: NotRequired[pulumi.Input[_builtins.str]]
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user roles.
        """
        auto_login: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether SAML auto login is enabled.
        """
        certificate: NotRequired[pulumi.Input[_builtins.str]]
        """
        Base64-encoded string for the SP X.509 certificate.
        """
        certificate_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path for the SP X.509 certificate.
        """
        client_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The client Id of your OAuth2 app.
        """
        client_secret: NotRequired[pulumi.Input[_builtins.str]]
        """
        The client secret of your OAuth2 app.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Define whether this configuration is enabled for SAML. Defaults to `true`.
        """
        entity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The entity ID is a globally unique identifier for the service provider. It is used to identify the service provider to the identity provider. Defaults to the URL of the Grafana instance if not set.
        """
        force_use_graph_api: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If enabled, Grafana will fetch groups from Microsoft Graph API instead of using the groups claim from the ID token.
        """
        idp_metadata: NotRequired[pulumi.Input[_builtins.str]]
        """
        Base64-encoded string for the IdP SAML metadata XML.
        """
        idp_metadata_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path for the IdP SAML metadata XML.
        """
        idp_metadata_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        URL for the IdP SAML metadata XML.
        """
        max_issue_delay: NotRequired[pulumi.Input[_builtins.str]]
        """
        Duration, since the IdP issued a response and the SP is allowed to process it. For example: 90s, 1h.
        """
        metadata_valid_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        Duration, for how long the SP metadata is valid. For example: 48h, 5d.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name used to refer to the SAML authentication.
        """
        name_id_format: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Name ID Format to request within the SAML assertion. Defaults to urn:oasis:names:tc:SAML:2.0:nameid-format:transient
        """
        org_mapping: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated Organization:OrgId:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: Viewer, Editor or Admin.
        """
        private_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Base64-encoded string for the SP private key.
        """
        private_key_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path for the SP private key.
        """
        relay_state: NotRequired[pulumi.Input[_builtins.str]]
        """
        Relay state for IdP-initiated login. Should match relay state configured in IdP.
        """
        role_values_admin: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated roles which will be mapped into the Admin role.
        """
        role_values_editor: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated roles which will be mapped into the Editor role.
        """
        role_values_grafana_admin: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated roles which will be mapped into the Grafana Admin (Super Admin) role.
        """
        role_values_none: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated roles which will be mapped into the None role.
        """
        role_values_viewer: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of comma- or space-separated roles which will be mapped into the Viewer role.
        """
        signature_algorithm: NotRequired[pulumi.Input[_builtins.str]]
        """
        Signature algorithm used for signing requests to the IdP. Supported values are rsa-sha1, rsa-sha256, rsa-sha512.
        """
        single_logout: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether SAML Single Logout is enabled.
        """
        skip_org_role_sync: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Prevent synchronizing users’ organization roles from your IdP.
        """
        token_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The token endpoint of your OAuth2 provider. Required for Azure AD providers.
        """
elif False:
    SsoSettingsSamlSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SsoSettingsSamlSettingsArgs:
    def __init__(__self__, *,
                 allow_idp_initiated: Optional[pulumi.Input[_builtins.bool]] = None,
                 allow_sign_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_organizations: Optional[pulumi.Input[_builtins.str]] = None,
                 assertion_attribute_email: Optional[pulumi.Input[_builtins.str]] = None,
                 assertion_attribute_groups: Optional[pulumi.Input[_builtins.str]] = None,
                 assertion_attribute_login: Optional[pulumi.Input[_builtins.str]] = None,
                 assertion_attribute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 assertion_attribute_org: Optional[pulumi.Input[_builtins.str]] = None,
                 assertion_attribute_role: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_path: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_use_graph_api: Optional[pulumi.Input[_builtins.bool]] = None,
                 idp_metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_metadata_path: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_metadata_url: Optional[pulumi.Input[_builtins.str]] = None,
                 max_issue_delay: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_valid_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_id_format: Optional[pulumi.Input[_builtins.str]] = None,
                 org_mapping: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 relay_state: Optional[pulumi.Input[_builtins.str]] = None,
                 role_values_admin: Optional[pulumi.Input[_builtins.str]] = None,
                 role_values_editor: Optional[pulumi.Input[_builtins.str]] = None,
                 role_values_grafana_admin: Optional[pulumi.Input[_builtins.str]] = None,
                 role_values_none: Optional[pulumi.Input[_builtins.str]] = None,
                 role_values_viewer: Optional[pulumi.Input[_builtins.str]] = None,
                 signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 single_logout: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_org_role_sync: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] allow_idp_initiated: Whether SAML IdP-initiated login is allowed.
        :param pulumi.Input[_builtins.bool] allow_sign_up: Whether to allow new Grafana user creation through SAML login. If set to false, then only existing Grafana users can log in with SAML.
        :param pulumi.Input[_builtins.str] allowed_organizations: List of comma- or space-separated organizations. User should be a member of at least one organization to log in.
        :param pulumi.Input[_builtins.str] assertion_attribute_email: Friendly name or name of the attribute within the SAML assertion to use as the user email.
        :param pulumi.Input[_builtins.str] assertion_attribute_groups: Friendly name or name of the attribute within the SAML assertion to use as the user groups.
        :param pulumi.Input[_builtins.str] assertion_attribute_login: Friendly name or name of the attribute within the SAML assertion to use as the user login handle.
        :param pulumi.Input[_builtins.str] assertion_attribute_name: Friendly name or name of the attribute within the SAML assertion to use as the user name. Alternatively, this can be a template with variables that match the names of attributes within the SAML assertion.
        :param pulumi.Input[_builtins.str] assertion_attribute_org: Friendly name or name of the attribute within the SAML assertion to use as the user organization.
        :param pulumi.Input[_builtins.str] assertion_attribute_role: Friendly name or name of the attribute within the SAML assertion to use as the user roles.
        :param pulumi.Input[_builtins.bool] auto_login: Whether SAML auto login is enabled.
        :param pulumi.Input[_builtins.str] certificate: Base64-encoded string for the SP X.509 certificate.
        :param pulumi.Input[_builtins.str] certificate_path: Path for the SP X.509 certificate.
        :param pulumi.Input[_builtins.str] client_id: The client Id of your OAuth2 app.
        :param pulumi.Input[_builtins.str] client_secret: The client secret of your OAuth2 app.
        :param pulumi.Input[_builtins.bool] enabled: Define whether this configuration is enabled for SAML. Defaults to `true`.
        :param pulumi.Input[_builtins.str] entity_id: The entity ID is a globally unique identifier for the service provider. It is used to identify the service provider to the identity provider. Defaults to the URL of the Grafana instance if not set.
        :param pulumi.Input[_builtins.bool] force_use_graph_api: If enabled, Grafana will fetch groups from Microsoft Graph API instead of using the groups claim from the ID token.
        :param pulumi.Input[_builtins.str] idp_metadata: Base64-encoded string for the IdP SAML metadata XML.
        :param pulumi.Input[_builtins.str] idp_metadata_path: Path for the IdP SAML metadata XML.
        :param pulumi.Input[_builtins.str] idp_metadata_url: URL for the IdP SAML metadata XML.
        :param pulumi.Input[_builtins.str] max_issue_delay: Duration, since the IdP issued a response and the SP is allowed to process it. For example: 90s, 1h.
        :param pulumi.Input[_builtins.str] metadata_valid_duration: Duration, for how long the SP metadata is valid. For example: 48h, 5d.
        :param pulumi.Input[_builtins.str] name: Name used to refer to the SAML authentication.
        :param pulumi.Input[_builtins.str] name_id_format: The Name ID Format to request within the SAML assertion. Defaults to urn:oasis:names:tc:SAML:2.0:nameid-format:transient
        :param pulumi.Input[_builtins.str] org_mapping: List of comma- or space-separated Organization:OrgId:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: Viewer, Editor or Admin.
        :param pulumi.Input[_builtins.str] private_key: Base64-encoded string for the SP private key.
        :param pulumi.Input[_builtins.str] private_key_path: Path for the SP private key.
        :param pulumi.Input[_builtins.str] relay_state: Relay state for IdP-initiated login. Should match relay state configured in IdP.
        :param pulumi.Input[_builtins.str] role_values_admin: List of comma- or space-separated roles which will be mapped into the Admin role.
        :param pulumi.Input[_builtins.str] role_values_editor: List of comma- or space-separated roles which will be mapped into the Editor role.
        :param pulumi.Input[_builtins.str] role_values_grafana_admin: List of comma- or space-separated roles which will be mapped into the Grafana Admin (Super Admin) role.
        :param pulumi.Input[_builtins.str] role_values_none: List of comma- or space-separated roles which will be mapped into the None role.
        :param pulumi.Input[_builtins.str] role_values_viewer: List of comma- or space-separated roles which will be mapped into the Viewer role.
        :param pulumi.Input[_builtins.str] signature_algorithm: Signature algorithm used for signing requests to the IdP. Supported values are rsa-sha1, rsa-sha256, rsa-sha512.
        :param pulumi.Input[_builtins.bool] single_logout: Whether SAML Single Logout is enabled.
        :param pulumi.Input[_builtins.bool] skip_org_role_sync: Prevent synchronizing users’ organization roles from your IdP.
        :param pulumi.Input[_builtins.str] token_url: The token endpoint of your OAuth2 provider. Required for Azure AD providers.
        """
        if allow_idp_initiated is not None:
            pulumi.set(__self__, "allow_idp_initiated", allow_idp_initiated)
        if allow_sign_up is not None:
            pulumi.set(__self__, "allow_sign_up", allow_sign_up)
        if allowed_organizations is not None:
            pulumi.set(__self__, "allowed_organizations", allowed_organizations)
        if assertion_attribute_email is not None:
            pulumi.set(__self__, "assertion_attribute_email", assertion_attribute_email)
        if assertion_attribute_groups is not None:
            pulumi.set(__self__, "assertion_attribute_groups", assertion_attribute_groups)
        if assertion_attribute_login is not None:
            pulumi.set(__self__, "assertion_attribute_login", assertion_attribute_login)
        if assertion_attribute_name is not None:
            pulumi.set(__self__, "assertion_attribute_name", assertion_attribute_name)
        if assertion_attribute_org is not None:
            pulumi.set(__self__, "assertion_attribute_org", assertion_attribute_org)
        if assertion_attribute_role is not None:
            pulumi.set(__self__, "assertion_attribute_role", assertion_attribute_role)
        if auto_login is not None:
            pulumi.set(__self__, "auto_login", auto_login)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_path is not None:
            pulumi.set(__self__, "certificate_path", certificate_path)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if force_use_graph_api is not None:
            pulumi.set(__self__, "force_use_graph_api", force_use_graph_api)
        if idp_metadata is not None:
            pulumi.set(__self__, "idp_metadata", idp_metadata)
        if idp_metadata_path is not None:
            pulumi.set(__self__, "idp_metadata_path", idp_metadata_path)
        if idp_metadata_url is not None:
            pulumi.set(__self__, "idp_metadata_url", idp_metadata_url)
        if max_issue_delay is not None:
            pulumi.set(__self__, "max_issue_delay", max_issue_delay)
        if metadata_valid_duration is not None:
            pulumi.set(__self__, "metadata_valid_duration", metadata_valid_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_id_format is not None:
            pulumi.set(__self__, "name_id_format", name_id_format)
        if org_mapping is not None:
            pulumi.set(__self__, "org_mapping", org_mapping)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_path is not None:
            pulumi.set(__self__, "private_key_path", private_key_path)
        if relay_state is not None:
            pulumi.set(__self__, "relay_state", relay_state)
        if role_values_admin is not None:
            pulumi.set(__self__, "role_values_admin", role_values_admin)
        if role_values_editor is not None:
            pulumi.set(__self__, "role_values_editor", role_values_editor)
        if role_values_grafana_admin is not None:
            pulumi.set(__self__, "role_values_grafana_admin", role_values_grafana_admin)
        if role_values_none is not None:
            pulumi.set(__self__, "role_values_none", role_values_none)
        if role_values_viewer is not None:
            pulumi.set(__self__, "role_values_viewer", role_values_viewer)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if single_logout is not None:
            pulumi.set(__self__, "single_logout", single_logout)
        if skip_org_role_sync is not None:
            pulumi.set(__self__, "skip_org_role_sync", skip_org_role_sync)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)

    @_builtins.property
    @pulumi.getter(name="allowIdpInitiated")
    def allow_idp_initiated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether SAML IdP-initiated login is allowed.
        """
        return pulumi.get(self, "allow_idp_initiated")

    @allow_idp_initiated.setter
    def allow_idp_initiated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_idp_initiated", value)

    @_builtins.property
    @pulumi.getter(name="allowSignUp")
    def allow_sign_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow new Grafana user creation through SAML login. If set to false, then only existing Grafana users can log in with SAML.
        """
        return pulumi.get(self, "allow_sign_up")

    @allow_sign_up.setter
    def allow_sign_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_sign_up", value)

    @_builtins.property
    @pulumi.getter(name="allowedOrganizations")
    def allowed_organizations(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated organizations. User should be a member of at least one organization to log in.
        """
        return pulumi.get(self, "allowed_organizations")

    @allowed_organizations.setter
    def allowed_organizations(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allowed_organizations", value)

    @_builtins.property
    @pulumi.getter(name="assertionAttributeEmail")
    def assertion_attribute_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user email.
        """
        return pulumi.get(self, "assertion_attribute_email")

    @assertion_attribute_email.setter
    def assertion_attribute_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assertion_attribute_email", value)

    @_builtins.property
    @pulumi.getter(name="assertionAttributeGroups")
    def assertion_attribute_groups(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user groups.
        """
        return pulumi.get(self, "assertion_attribute_groups")

    @assertion_attribute_groups.setter
    def assertion_attribute_groups(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assertion_attribute_groups", value)

    @_builtins.property
    @pulumi.getter(name="assertionAttributeLogin")
    def assertion_attribute_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user login handle.
        """
        return pulumi.get(self, "assertion_attribute_login")

    @assertion_attribute_login.setter
    def assertion_attribute_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assertion_attribute_login", value)

    @_builtins.property
    @pulumi.getter(name="assertionAttributeName")
    def assertion_attribute_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user name. Alternatively, this can be a template with variables that match the names of attributes within the SAML assertion.
        """
        return pulumi.get(self, "assertion_attribute_name")

    @assertion_attribute_name.setter
    def assertion_attribute_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assertion_attribute_name", value)

    @_builtins.property
    @pulumi.getter(name="assertionAttributeOrg")
    def assertion_attribute_org(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user organization.
        """
        return pulumi.get(self, "assertion_attribute_org")

    @assertion_attribute_org.setter
    def assertion_attribute_org(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assertion_attribute_org", value)

    @_builtins.property
    @pulumi.getter(name="assertionAttributeRole")
    def assertion_attribute_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user roles.
        """
        return pulumi.get(self, "assertion_attribute_role")

    @assertion_attribute_role.setter
    def assertion_attribute_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assertion_attribute_role", value)

    @_builtins.property
    @pulumi.getter(name="autoLogin")
    def auto_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether SAML auto login is enabled.
        """
        return pulumi.get(self, "auto_login")

    @auto_login.setter
    def auto_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_login", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64-encoded string for the SP X.509 certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="certificatePath")
    def certificate_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path for the SP X.509 certificate.
        """
        return pulumi.get(self, "certificate_path")

    @certificate_path.setter
    def certificate_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_path", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client Id of your OAuth2 app.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client secret of your OAuth2 app.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Define whether this configuration is enabled for SAML. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The entity ID is a globally unique identifier for the service provider. It is used to identify the service provider to the identity provider. Defaults to the URL of the Grafana instance if not set.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_id", value)

    @_builtins.property
    @pulumi.getter(name="forceUseGraphApi")
    def force_use_graph_api(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Grafana will fetch groups from Microsoft Graph API instead of using the groups claim from the ID token.
        """
        return pulumi.get(self, "force_use_graph_api")

    @force_use_graph_api.setter
    def force_use_graph_api(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_use_graph_api", value)

    @_builtins.property
    @pulumi.getter(name="idpMetadata")
    def idp_metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64-encoded string for the IdP SAML metadata XML.
        """
        return pulumi.get(self, "idp_metadata")

    @idp_metadata.setter
    def idp_metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_metadata", value)

    @_builtins.property
    @pulumi.getter(name="idpMetadataPath")
    def idp_metadata_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path for the IdP SAML metadata XML.
        """
        return pulumi.get(self, "idp_metadata_path")

    @idp_metadata_path.setter
    def idp_metadata_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_metadata_path", value)

    @_builtins.property
    @pulumi.getter(name="idpMetadataUrl")
    def idp_metadata_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL for the IdP SAML metadata XML.
        """
        return pulumi.get(self, "idp_metadata_url")

    @idp_metadata_url.setter
    def idp_metadata_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_metadata_url", value)

    @_builtins.property
    @pulumi.getter(name="maxIssueDelay")
    def max_issue_delay(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Duration, since the IdP issued a response and the SP is allowed to process it. For example: 90s, 1h.
        """
        return pulumi.get(self, "max_issue_delay")

    @max_issue_delay.setter
    def max_issue_delay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_issue_delay", value)

    @_builtins.property
    @pulumi.getter(name="metadataValidDuration")
    def metadata_valid_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Duration, for how long the SP metadata is valid. For example: 48h, 5d.
        """
        return pulumi.get(self, "metadata_valid_duration")

    @metadata_valid_duration.setter
    def metadata_valid_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata_valid_duration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name used to refer to the SAML authentication.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nameIdFormat")
    def name_id_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name ID Format to request within the SAML assertion. Defaults to urn:oasis:names:tc:SAML:2.0:nameid-format:transient
        """
        return pulumi.get(self, "name_id_format")

    @name_id_format.setter
    def name_id_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_id_format", value)

    @_builtins.property
    @pulumi.getter(name="orgMapping")
    def org_mapping(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated Organization:OrgId:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: Viewer, Editor or Admin.
        """
        return pulumi.get(self, "org_mapping")

    @org_mapping.setter
    def org_mapping(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_mapping", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64-encoded string for the SP private key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path for the SP private key.
        """
        return pulumi.get(self, "private_key_path")

    @private_key_path.setter
    def private_key_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_path", value)

    @_builtins.property
    @pulumi.getter(name="relayState")
    def relay_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Relay state for IdP-initiated login. Should match relay state configured in IdP.
        """
        return pulumi.get(self, "relay_state")

    @relay_state.setter
    def relay_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relay_state", value)

    @_builtins.property
    @pulumi.getter(name="roleValuesAdmin")
    def role_values_admin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated roles which will be mapped into the Admin role.
        """
        return pulumi.get(self, "role_values_admin")

    @role_values_admin.setter
    def role_values_admin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_values_admin", value)

    @_builtins.property
    @pulumi.getter(name="roleValuesEditor")
    def role_values_editor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated roles which will be mapped into the Editor role.
        """
        return pulumi.get(self, "role_values_editor")

    @role_values_editor.setter
    def role_values_editor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_values_editor", value)

    @_builtins.property
    @pulumi.getter(name="roleValuesGrafanaAdmin")
    def role_values_grafana_admin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated roles which will be mapped into the Grafana Admin (Super Admin) role.
        """
        return pulumi.get(self, "role_values_grafana_admin")

    @role_values_grafana_admin.setter
    def role_values_grafana_admin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_values_grafana_admin", value)

    @_builtins.property
    @pulumi.getter(name="roleValuesNone")
    def role_values_none(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated roles which will be mapped into the None role.
        """
        return pulumi.get(self, "role_values_none")

    @role_values_none.setter
    def role_values_none(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_values_none", value)

    @_builtins.property
    @pulumi.getter(name="roleValuesViewer")
    def role_values_viewer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of comma- or space-separated roles which will be mapped into the Viewer role.
        """
        return pulumi.get(self, "role_values_viewer")

    @role_values_viewer.setter
    def role_values_viewer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_values_viewer", value)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Signature algorithm used for signing requests to the IdP. Supported values are rsa-sha1, rsa-sha256, rsa-sha512.
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="singleLogout")
    def single_logout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether SAML Single Logout is enabled.
        """
        return pulumi.get(self, "single_logout")

    @single_logout.setter
    def single_logout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "single_logout", value)

    @_builtins.property
    @pulumi.getter(name="skipOrgRoleSync")
    def skip_org_role_sync(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Prevent synchronizing users’ organization roles from your IdP.
        """
        return pulumi.get(self, "skip_org_role_sync")

    @skip_org_role_sync.setter
    def skip_org_role_sync(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_org_role_sync", value)

    @_builtins.property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token endpoint of your OAuth2 provider. Required for Azure AD providers.
        """
        return pulumi.get(self, "token_url")

    @token_url.setter
    def token_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_url", value)


if not MYPY:
    class TeamPreferencesArgsDict(TypedDict):
        home_dashboard_uid: NotRequired[pulumi.Input[_builtins.str]]
        """
        The UID of the dashboard to display when a team member logs in.
        """
        theme: NotRequired[pulumi.Input[_builtins.str]]
        """
        The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        """
        timezone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        """
        week_start: NotRequired[pulumi.Input[_builtins.str]]
        """
        The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
elif False:
    TeamPreferencesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TeamPreferencesArgs:
    def __init__(__self__, *,
                 home_dashboard_uid: Optional[pulumi.Input[_builtins.str]] = None,
                 theme: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 week_start: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] home_dashboard_uid: The UID of the dashboard to display when a team member logs in.
        :param pulumi.Input[_builtins.str] theme: The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        :param pulumi.Input[_builtins.str] timezone: The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        :param pulumi.Input[_builtins.str] week_start: The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        if home_dashboard_uid is not None:
            pulumi.set(__self__, "home_dashboard_uid", home_dashboard_uid)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @_builtins.property
    @pulumi.getter(name="homeDashboardUid")
    def home_dashboard_uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UID of the dashboard to display when a team member logs in.
        """
        return pulumi.get(self, "home_dashboard_uid")

    @home_dashboard_uid.setter
    def home_dashboard_uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "home_dashboard_uid", value)

    @_builtins.property
    @pulumi.getter
    def theme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        """
        return pulumi.get(self, "theme")

    @theme.setter
    def theme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "theme", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        return pulumi.get(self, "week_start")

    @week_start.setter
    def week_start(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "week_start", value)


if not MYPY:
    class TeamTeamSyncArgsDict(TypedDict):
        groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
elif False:
    TeamTeamSyncArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TeamTeamSyncArgs:
    def __init__(__self__, *,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups", value)


