# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DashboardPermissionPermission',
    'FolderPermissionPermission',
    'PlaylistItem',
    'ServiceAccountPermissionPermission',
    'SsoSettingsLdapSettings',
    'SsoSettingsLdapSettingsConfig',
    'SsoSettingsLdapSettingsConfigServer',
    'SsoSettingsLdapSettingsConfigServerGroupMapping',
    'SsoSettingsOauth2Settings',
    'SsoSettingsSamlSettings',
    'TeamPreferences',
    'TeamTeamSync',
    'GetDashboardsDashboardResult',
    'GetFoldersFolderResult',
    'GetLibraryPanelsPanelResult',
    'GetTeamPreferenceResult',
    'GetTeamTeamSyncResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class DashboardPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "teamId":
            suggest = "team_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission: _builtins.str,
                 role: Optional[_builtins.str] = None,
                 team_id: Optional[_builtins.str] = None,
                 user_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param _builtins.str role: Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        :param _builtins.str team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param _builtins.str user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[_builtins.str]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.str]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class FolderPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "teamId":
            suggest = "team_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FolderPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FolderPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FolderPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission: _builtins.str,
                 role: Optional[_builtins.str] = None,
                 team_id: Optional[_builtins.str] = None,
                 user_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param _builtins.str role: Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        :param _builtins.str team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param _builtins.str user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[_builtins.str]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.str]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class PlaylistItem(dict):
    def __init__(__self__, *,
                 order: _builtins.int,
                 title: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "title", title)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> _builtins.int:
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceAccountPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "teamId":
            suggest = "team_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAccountPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAccountPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAccountPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission: _builtins.str,
                 team_id: Optional[_builtins.str] = None,
                 user_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param _builtins.str team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param _builtins.str user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[_builtins.str]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[_builtins.str]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class SsoSettingsLdapSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSignUp":
            suggest = "allow_sign_up"
        elif key == "skipOrgRoleSync":
            suggest = "skip_org_role_sync"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsLdapSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsLdapSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsLdapSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: 'outputs.SsoSettingsLdapSettingsConfig',
                 allow_sign_up: Optional[_builtins.bool] = None,
                 enabled: Optional[_builtins.bool] = None,
                 skip_org_role_sync: Optional[_builtins.bool] = None):
        """
        :param 'SsoSettingsLdapSettingsConfigArgs' config: The LDAP configuration.
        :param _builtins.bool allow_sign_up: Whether to allow new Grafana user creation through LDAP login. If set to false, then only existing Grafana users can log in with LDAP.
        :param _builtins.bool enabled: Define whether this configuration is enabled for LDAP. Defaults to `true`.
        :param _builtins.bool skip_org_role_sync: Prevent synchronizing users’ organization roles from LDAP.
        """
        pulumi.set(__self__, "config", config)
        if allow_sign_up is not None:
            pulumi.set(__self__, "allow_sign_up", allow_sign_up)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if skip_org_role_sync is not None:
            pulumi.set(__self__, "skip_org_role_sync", skip_org_role_sync)

    @_builtins.property
    @pulumi.getter
    def config(self) -> 'outputs.SsoSettingsLdapSettingsConfig':
        """
        The LDAP configuration.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="allowSignUp")
    def allow_sign_up(self) -> Optional[_builtins.bool]:
        """
        Whether to allow new Grafana user creation through LDAP login. If set to false, then only existing Grafana users can log in with LDAP.
        """
        return pulumi.get(self, "allow_sign_up")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Define whether this configuration is enabled for LDAP. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="skipOrgRoleSync")
    def skip_org_role_sync(self) -> Optional[_builtins.bool]:
        """
        Prevent synchronizing users’ organization roles from LDAP.
        """
        return pulumi.get(self, "skip_org_role_sync")


@pulumi.output_type
class SsoSettingsLdapSettingsConfig(dict):
    def __init__(__self__, *,
                 servers: Sequence['outputs.SsoSettingsLdapSettingsConfigServer']):
        """
        :param Sequence['SsoSettingsLdapSettingsConfigServerArgs'] servers: The LDAP servers configuration.
        """
        pulumi.set(__self__, "servers", servers)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.SsoSettingsLdapSettingsConfigServer']:
        """
        The LDAP servers configuration.
        """
        return pulumi.get(self, "servers")


@pulumi.output_type
class SsoSettingsLdapSettingsConfigServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "searchBaseDns":
            suggest = "search_base_dns"
        elif key == "searchFilter":
            suggest = "search_filter"
        elif key == "bindDn":
            suggest = "bind_dn"
        elif key == "bindPassword":
            suggest = "bind_password"
        elif key == "clientCert":
            suggest = "client_cert"
        elif key == "clientCertValue":
            suggest = "client_cert_value"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clientKeyValue":
            suggest = "client_key_value"
        elif key == "groupMappings":
            suggest = "group_mappings"
        elif key == "groupSearchBaseDns":
            suggest = "group_search_base_dns"
        elif key == "groupSearchFilter":
            suggest = "group_search_filter"
        elif key == "groupSearchFilterUserAttribute":
            suggest = "group_search_filter_user_attribute"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "rootCaCert":
            suggest = "root_ca_cert"
        elif key == "rootCaCertValues":
            suggest = "root_ca_cert_values"
        elif key == "sslSkipVerify":
            suggest = "ssl_skip_verify"
        elif key == "startTls":
            suggest = "start_tls"
        elif key == "tlsCiphers":
            suggest = "tls_ciphers"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsLdapSettingsConfigServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsLdapSettingsConfigServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsLdapSettingsConfigServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: _builtins.str,
                 search_base_dns: Sequence[_builtins.str],
                 search_filter: _builtins.str,
                 attributes: Optional[Mapping[str, _builtins.str]] = None,
                 bind_dn: Optional[_builtins.str] = None,
                 bind_password: Optional[_builtins.str] = None,
                 client_cert: Optional[_builtins.str] = None,
                 client_cert_value: Optional[_builtins.str] = None,
                 client_key: Optional[_builtins.str] = None,
                 client_key_value: Optional[_builtins.str] = None,
                 group_mappings: Optional[Sequence['outputs.SsoSettingsLdapSettingsConfigServerGroupMapping']] = None,
                 group_search_base_dns: Optional[Sequence[_builtins.str]] = None,
                 group_search_filter: Optional[_builtins.str] = None,
                 group_search_filter_user_attribute: Optional[_builtins.str] = None,
                 min_tls_version: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 root_ca_cert: Optional[_builtins.str] = None,
                 root_ca_cert_values: Optional[Sequence[_builtins.str]] = None,
                 ssl_skip_verify: Optional[_builtins.bool] = None,
                 start_tls: Optional[_builtins.bool] = None,
                 timeout: Optional[_builtins.int] = None,
                 tls_ciphers: Optional[Sequence[_builtins.str]] = None,
                 use_ssl: Optional[_builtins.bool] = None):
        """
        :param _builtins.str host: The LDAP server host.
        :param Sequence[_builtins.str] search_base_dns: An array of base DNs to search through.
        :param _builtins.str search_filter: The user search filter, for example "(cn=%s)" or "(sAMAccountName=%s)" or "(uid=%s)".
        :param Mapping[str, _builtins.str] attributes: The LDAP server attributes. The following attributes can be configured: email, member_of, name, surname, username.
        :param _builtins.str bind_dn: The search user bind DN.
        :param _builtins.str bind_password: The search user bind password.
        :param _builtins.str client_cert: The path to the client certificate.
        :param _builtins.str client_cert_value: The Base64 encoded value of the client certificate.
        :param _builtins.str client_key: The path to the client private key.
        :param _builtins.str client_key_value: The Base64 encoded value of the client private key.
        :param Sequence['SsoSettingsLdapSettingsConfigServerGroupMappingArgs'] group_mappings: For mapping an LDAP group to a Grafana organization and role.
        :param Sequence[_builtins.str] group_search_base_dns: An array of the base DNs to search through for groups. Typically uses ou=groups.
        :param _builtins.str group_search_filter: Group search filter, to retrieve the groups of which the user is a member (only set if memberOf attribute is not available).
        :param _builtins.str group_search_filter_user_attribute: The %s in the search filter will be replaced with the attribute defined in this field.
        :param _builtins.str min_tls_version: Minimum TLS version allowed. Accepted values are: TLS1.2, TLS1.3.
        :param _builtins.int port: The LDAP server port.
        :param _builtins.str root_ca_cert: The path to the root CA certificate.
        :param Sequence[_builtins.str] root_ca_cert_values: The Base64 encoded values of the root CA certificates.
        :param _builtins.bool ssl_skip_verify: If set to true, the SSL cert validation will be skipped.
        :param _builtins.bool start_tls: If set to true, use LDAP with STARTTLS instead of LDAPS.
        :param _builtins.int timeout: The timeout in seconds for connecting to the LDAP host.
        :param Sequence[_builtins.str] tls_ciphers: Accepted TLS ciphers. For a complete list of supported ciphers, refer to: https://go.dev/src/crypto/tls/cipher_suites.go.
        :param _builtins.bool use_ssl: Set to true if LDAP server should use an encrypted TLS connection (either with STARTTLS or LDAPS).
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "search_base_dns", search_base_dns)
        pulumi.set(__self__, "search_filter", search_filter)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if bind_dn is not None:
            pulumi.set(__self__, "bind_dn", bind_dn)
        if bind_password is not None:
            pulumi.set(__self__, "bind_password", bind_password)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_cert_value is not None:
            pulumi.set(__self__, "client_cert_value", client_cert_value)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if client_key_value is not None:
            pulumi.set(__self__, "client_key_value", client_key_value)
        if group_mappings is not None:
            pulumi.set(__self__, "group_mappings", group_mappings)
        if group_search_base_dns is not None:
            pulumi.set(__self__, "group_search_base_dns", group_search_base_dns)
        if group_search_filter is not None:
            pulumi.set(__self__, "group_search_filter", group_search_filter)
        if group_search_filter_user_attribute is not None:
            pulumi.set(__self__, "group_search_filter_user_attribute", group_search_filter_user_attribute)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if root_ca_cert is not None:
            pulumi.set(__self__, "root_ca_cert", root_ca_cert)
        if root_ca_cert_values is not None:
            pulumi.set(__self__, "root_ca_cert_values", root_ca_cert_values)
        if ssl_skip_verify is not None:
            pulumi.set(__self__, "ssl_skip_verify", ssl_skip_verify)
        if start_tls is not None:
            pulumi.set(__self__, "start_tls", start_tls)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The LDAP server host.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="searchBaseDns")
    def search_base_dns(self) -> Sequence[_builtins.str]:
        """
        An array of base DNs to search through.
        """
        return pulumi.get(self, "search_base_dns")

    @_builtins.property
    @pulumi.getter(name="searchFilter")
    def search_filter(self) -> _builtins.str:
        """
        The user search filter, for example "(cn=%s)" or "(sAMAccountName=%s)" or "(uid=%s)".
        """
        return pulumi.get(self, "search_filter")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The LDAP server attributes. The following attributes can be configured: email, member_of, name, surname, username.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="bindDn")
    def bind_dn(self) -> Optional[_builtins.str]:
        """
        The search user bind DN.
        """
        return pulumi.get(self, "bind_dn")

    @_builtins.property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> Optional[_builtins.str]:
        """
        The search user bind password.
        """
        return pulumi.get(self, "bind_password")

    @_builtins.property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[_builtins.str]:
        """
        The path to the client certificate.
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientCertValue")
    def client_cert_value(self) -> Optional[_builtins.str]:
        """
        The Base64 encoded value of the client certificate.
        """
        return pulumi.get(self, "client_cert_value")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[_builtins.str]:
        """
        The path to the client private key.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clientKeyValue")
    def client_key_value(self) -> Optional[_builtins.str]:
        """
        The Base64 encoded value of the client private key.
        """
        return pulumi.get(self, "client_key_value")

    @_builtins.property
    @pulumi.getter(name="groupMappings")
    def group_mappings(self) -> Optional[Sequence['outputs.SsoSettingsLdapSettingsConfigServerGroupMapping']]:
        """
        For mapping an LDAP group to a Grafana organization and role.
        """
        return pulumi.get(self, "group_mappings")

    @_builtins.property
    @pulumi.getter(name="groupSearchBaseDns")
    def group_search_base_dns(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of the base DNs to search through for groups. Typically uses ou=groups.
        """
        return pulumi.get(self, "group_search_base_dns")

    @_builtins.property
    @pulumi.getter(name="groupSearchFilter")
    def group_search_filter(self) -> Optional[_builtins.str]:
        """
        Group search filter, to retrieve the groups of which the user is a member (only set if memberOf attribute is not available).
        """
        return pulumi.get(self, "group_search_filter")

    @_builtins.property
    @pulumi.getter(name="groupSearchFilterUserAttribute")
    def group_search_filter_user_attribute(self) -> Optional[_builtins.str]:
        """
        The %s in the search filter will be replaced with the attribute defined in this field.
        """
        return pulumi.get(self, "group_search_filter_user_attribute")

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[_builtins.str]:
        """
        Minimum TLS version allowed. Accepted values are: TLS1.2, TLS1.3.
        """
        return pulumi.get(self, "min_tls_version")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The LDAP server port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="rootCaCert")
    def root_ca_cert(self) -> Optional[_builtins.str]:
        """
        The path to the root CA certificate.
        """
        return pulumi.get(self, "root_ca_cert")

    @_builtins.property
    @pulumi.getter(name="rootCaCertValues")
    def root_ca_cert_values(self) -> Optional[Sequence[_builtins.str]]:
        """
        The Base64 encoded values of the root CA certificates.
        """
        return pulumi.get(self, "root_ca_cert_values")

    @_builtins.property
    @pulumi.getter(name="sslSkipVerify")
    def ssl_skip_verify(self) -> Optional[_builtins.bool]:
        """
        If set to true, the SSL cert validation will be skipped.
        """
        return pulumi.get(self, "ssl_skip_verify")

    @_builtins.property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> Optional[_builtins.bool]:
        """
        If set to true, use LDAP with STARTTLS instead of LDAPS.
        """
        return pulumi.get(self, "start_tls")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        The timeout in seconds for connecting to the LDAP host.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Accepted TLS ciphers. For a complete list of supported ciphers, refer to: https://go.dev/src/crypto/tls/cipher_suites.go.
        """
        return pulumi.get(self, "tls_ciphers")

    @_builtins.property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[_builtins.bool]:
        """
        Set to true if LDAP server should use an encrypted TLS connection (either with STARTTLS or LDAPS).
        """
        return pulumi.get(self, "use_ssl")


@pulumi.output_type
class SsoSettingsLdapSettingsConfigServerGroupMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupDn":
            suggest = "group_dn"
        elif key == "orgRole":
            suggest = "org_role"
        elif key == "grafanaAdmin":
            suggest = "grafana_admin"
        elif key == "orgId":
            suggest = "org_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsLdapSettingsConfigServerGroupMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsLdapSettingsConfigServerGroupMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsLdapSettingsConfigServerGroupMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_dn: _builtins.str,
                 org_role: _builtins.str,
                 grafana_admin: Optional[_builtins.bool] = None,
                 org_id: Optional[_builtins.int] = None):
        """
        :param _builtins.str group_dn: LDAP distinguished name (DN) of LDAP group. If you want to match all (or no LDAP groups) then you can use wildcard ("*").
        :param _builtins.str org_role: Assign users of group_dn the organization role Admin, Editor, or Viewer.
        :param _builtins.bool grafana_admin: If set to true, it makes the user of group_dn Grafana server admin.
        :param _builtins.int org_id: The Grafana organization database id.
        """
        pulumi.set(__self__, "group_dn", group_dn)
        pulumi.set(__self__, "org_role", org_role)
        if grafana_admin is not None:
            pulumi.set(__self__, "grafana_admin", grafana_admin)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)

    @_builtins.property
    @pulumi.getter(name="groupDn")
    def group_dn(self) -> _builtins.str:
        """
        LDAP distinguished name (DN) of LDAP group. If you want to match all (or no LDAP groups) then you can use wildcard ("*").
        """
        return pulumi.get(self, "group_dn")

    @_builtins.property
    @pulumi.getter(name="orgRole")
    def org_role(self) -> _builtins.str:
        """
        Assign users of group_dn the organization role Admin, Editor, or Viewer.
        """
        return pulumi.get(self, "org_role")

    @_builtins.property
    @pulumi.getter(name="grafanaAdmin")
    def grafana_admin(self) -> Optional[_builtins.bool]:
        """
        If set to true, it makes the user of group_dn Grafana server admin.
        """
        return pulumi.get(self, "grafana_admin")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[_builtins.int]:
        """
        The Grafana organization database id.
        """
        return pulumi.get(self, "org_id")


@pulumi.output_type
class SsoSettingsOauth2Settings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "allowAssignGrafanaAdmin":
            suggest = "allow_assign_grafana_admin"
        elif key == "allowSignUp":
            suggest = "allow_sign_up"
        elif key == "allowedDomains":
            suggest = "allowed_domains"
        elif key == "allowedGroups":
            suggest = "allowed_groups"
        elif key == "allowedOrganizations":
            suggest = "allowed_organizations"
        elif key == "apiUrl":
            suggest = "api_url"
        elif key == "authStyle":
            suggest = "auth_style"
        elif key == "authUrl":
            suggest = "auth_url"
        elif key == "autoLogin":
            suggest = "auto_login"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "defineAllowedGroups":
            suggest = "define_allowed_groups"
        elif key == "defineAllowedTeamsIds":
            suggest = "define_allowed_teams_ids"
        elif key == "emailAttributeName":
            suggest = "email_attribute_name"
        elif key == "emailAttributePath":
            suggest = "email_attribute_path"
        elif key == "emptyScopes":
            suggest = "empty_scopes"
        elif key == "groupsAttributePath":
            suggest = "groups_attribute_path"
        elif key == "idTokenAttributeName":
            suggest = "id_token_attribute_name"
        elif key == "loginAttributePath":
            suggest = "login_attribute_path"
        elif key == "loginPrompt":
            suggest = "login_prompt"
        elif key == "nameAttributePath":
            suggest = "name_attribute_path"
        elif key == "orgAttributePath":
            suggest = "org_attribute_path"
        elif key == "orgMapping":
            suggest = "org_mapping"
        elif key == "roleAttributePath":
            suggest = "role_attribute_path"
        elif key == "roleAttributeStrict":
            suggest = "role_attribute_strict"
        elif key == "signoutRedirectUrl":
            suggest = "signout_redirect_url"
        elif key == "skipOrgRoleSync":
            suggest = "skip_org_role_sync"
        elif key == "teamIds":
            suggest = "team_ids"
        elif key == "teamIdsAttributePath":
            suggest = "team_ids_attribute_path"
        elif key == "teamsUrl":
            suggest = "teams_url"
        elif key == "tlsClientCa":
            suggest = "tls_client_ca"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsSkipVerifyInsecure":
            suggest = "tls_skip_verify_insecure"
        elif key == "tokenUrl":
            suggest = "token_url"
        elif key == "usePkce":
            suggest = "use_pkce"
        elif key == "useRefreshToken":
            suggest = "use_refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsOauth2Settings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsOauth2Settings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsOauth2Settings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 allow_assign_grafana_admin: Optional[_builtins.bool] = None,
                 allow_sign_up: Optional[_builtins.bool] = None,
                 allowed_domains: Optional[_builtins.str] = None,
                 allowed_groups: Optional[_builtins.str] = None,
                 allowed_organizations: Optional[_builtins.str] = None,
                 api_url: Optional[_builtins.str] = None,
                 auth_style: Optional[_builtins.str] = None,
                 auth_url: Optional[_builtins.str] = None,
                 auto_login: Optional[_builtins.bool] = None,
                 client_secret: Optional[_builtins.str] = None,
                 custom: Optional[Mapping[str, _builtins.str]] = None,
                 define_allowed_groups: Optional[_builtins.bool] = None,
                 define_allowed_teams_ids: Optional[_builtins.bool] = None,
                 email_attribute_name: Optional[_builtins.str] = None,
                 email_attribute_path: Optional[_builtins.str] = None,
                 empty_scopes: Optional[_builtins.bool] = None,
                 enabled: Optional[_builtins.bool] = None,
                 groups_attribute_path: Optional[_builtins.str] = None,
                 id_token_attribute_name: Optional[_builtins.str] = None,
                 login_attribute_path: Optional[_builtins.str] = None,
                 login_prompt: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 name_attribute_path: Optional[_builtins.str] = None,
                 org_attribute_path: Optional[_builtins.str] = None,
                 org_mapping: Optional[_builtins.str] = None,
                 role_attribute_path: Optional[_builtins.str] = None,
                 role_attribute_strict: Optional[_builtins.bool] = None,
                 scopes: Optional[_builtins.str] = None,
                 signout_redirect_url: Optional[_builtins.str] = None,
                 skip_org_role_sync: Optional[_builtins.bool] = None,
                 team_ids: Optional[_builtins.str] = None,
                 team_ids_attribute_path: Optional[_builtins.str] = None,
                 teams_url: Optional[_builtins.str] = None,
                 tls_client_ca: Optional[_builtins.str] = None,
                 tls_client_cert: Optional[_builtins.str] = None,
                 tls_client_key: Optional[_builtins.str] = None,
                 tls_skip_verify_insecure: Optional[_builtins.bool] = None,
                 token_url: Optional[_builtins.str] = None,
                 use_pkce: Optional[_builtins.bool] = None,
                 use_refresh_token: Optional[_builtins.bool] = None):
        """
        :param _builtins.str client_id: The client Id of your OAuth2 app.
        :param _builtins.bool allow_assign_grafana_admin: If enabled, it will automatically sync the Grafana server administrator role.
        :param _builtins.bool allow_sign_up: If not enabled, only existing Grafana users can log in using OAuth.
        :param _builtins.str allowed_domains: List of comma- or space-separated domains. The user should belong to at least one domain to log in.
        :param _builtins.str allowed_groups: List of comma- or space-separated groups. The user should be a member of at least one group to log in. For Generic OAuth, if you configure allowed*groups, you must also configure groups*attribute_path.
        :param _builtins.str allowed_organizations: List of comma- or space-separated organizations. The user should be a member of at least one organization to log in.
        :param _builtins.str api_url: The user information endpoint of your OAuth2 provider. Required for okta and generic_oauth providers.
        :param _builtins.str auth_style: It determines how client*id and client*secret are sent to Oauth2 provider. Possible values are AutoDetect, InParams, InHeader. Default is AutoDetect.
        :param _builtins.str auth_url: The authorization endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        :param _builtins.bool auto_login: Log in automatically, skipping the login screen.
        :param _builtins.str client_secret: The client secret of your OAuth2 app.
        :param Mapping[str, _builtins.str] custom: Custom fields to configure for OAuth2 such as the [force*use*graph_api](https://grafana.com/docs/grafana/latest/setup-grafana/configure-security/configure-authentication/azuread/#force-fetching-groups-from-microsoft-graph-api) field.
        :param _builtins.bool define_allowed_groups: Define allowed groups.
        :param _builtins.bool define_allowed_teams_ids: Define allowed teams ids.
        :param _builtins.str email_attribute_name: Name of the key to use for user email lookup within the attributes map of OAuth2 ID token. Only applicable to Generic OAuth.
        :param _builtins.str email_attribute_path: JMESPath expression to use for user email lookup from the user information. Only applicable to Generic OAuth.
        :param _builtins.bool empty_scopes: If enabled, no scopes will be sent to the OAuth2 provider.
        :param _builtins.bool enabled: Define whether this configuration is enabled for the specified provider. Defaults to `true`.
        :param _builtins.str groups_attribute_path: JMESPath expression to use for user group lookup. If you configure allowed*groups, you must also configure groups*attribute_path.
        :param _builtins.str id_token_attribute_name: The name of the key used to extract the ID token from the returned OAuth2 token. Only applicable to Generic OAuth.
        :param _builtins.str login_attribute_path: JMESPath expression to use for user login lookup from the user ID token. Only applicable to Generic OAuth.
        :param _builtins.str login_prompt: Indicates the type of user interaction when the user logs in with the IdP. Available values are `login`, `consent` and `select_account`.
        :param _builtins.str name: Helpful if you use more than one identity providers or SSO protocols.
        :param _builtins.str name_attribute_path: JMESPath expression to use for user name lookup from the user ID token. This name will be used as the user’s display name. Only applicable to Generic OAuth.
        :param _builtins.str org_attribute_path: JMESPath expression to use for the organization mapping lookup from the user ID token. The extracted list will be used for the organization mapping (to match "Organization" in the "org_mapping"). Only applicable to Generic OAuth and Okta.
        :param _builtins.str org_mapping: List of comma- or space-separated Organization:OrgIdOrOrgName:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: None, Viewer, Editor or Admin.
        :param _builtins.str role_attribute_path: JMESPath expression to use for Grafana role lookup.
        :param _builtins.bool role_attribute_strict: If enabled, denies user login if the Grafana role cannot be extracted using Role attribute path.
        :param _builtins.str scopes: List of comma- or space-separated OAuth2 scopes.
        :param _builtins.str signout_redirect_url: The URL to redirect the user to after signing out from Grafana.
        :param _builtins.bool skip_org_role_sync: Prevent synchronizing users’ organization roles from your IdP.
        :param _builtins.str team_ids: String list of Team Ids. If set, the user must be a member of one of the given teams to log in. If you configure team*ids, you must also configure teams*url and team*ids*attribute_path.
        :param _builtins.str team_ids_attribute_path: The JMESPath expression to use for Grafana Team Id lookup within the results returned by the teams_url endpoint. Only applicable to Generic OAuth.
        :param _builtins.str teams_url: The URL used to query for Team Ids. If not set, the default value is /teams. If you configure teams*url, you must also configure team*ids*attribute*path. Only applicable to Generic OAuth.
        :param _builtins.str tls_client_ca: The path to the trusted certificate authority list. Is not applicable on Grafana Cloud.
        :param _builtins.str tls_client_cert: The path to the certificate. Is not applicable on Grafana Cloud.
        :param _builtins.str tls_client_key: The path to the key. Is not applicable on Grafana Cloud.
        :param _builtins.bool tls_skip_verify_insecure: If enabled, the client accepts any certificate presented by the server and any host name in that certificate. You should only use this for testing, because this mode leaves SSL/TLS susceptible to man-in-the-middle attacks.
        :param _builtins.str token_url: The token endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        :param _builtins.bool use_pkce: If enabled, Grafana will use Proof Key for Code Exchange (PKCE) with the OAuth2 Authorization Code Grant.
        :param _builtins.bool use_refresh_token: If enabled, Grafana will fetch a new access token using the refresh token provided by the OAuth2 provider.
        """
        pulumi.set(__self__, "client_id", client_id)
        if allow_assign_grafana_admin is not None:
            pulumi.set(__self__, "allow_assign_grafana_admin", allow_assign_grafana_admin)
        if allow_sign_up is not None:
            pulumi.set(__self__, "allow_sign_up", allow_sign_up)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_groups is not None:
            pulumi.set(__self__, "allowed_groups", allowed_groups)
        if allowed_organizations is not None:
            pulumi.set(__self__, "allowed_organizations", allowed_organizations)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if auth_style is not None:
            pulumi.set(__self__, "auth_style", auth_style)
        if auth_url is not None:
            pulumi.set(__self__, "auth_url", auth_url)
        if auto_login is not None:
            pulumi.set(__self__, "auto_login", auto_login)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if define_allowed_groups is not None:
            pulumi.set(__self__, "define_allowed_groups", define_allowed_groups)
        if define_allowed_teams_ids is not None:
            pulumi.set(__self__, "define_allowed_teams_ids", define_allowed_teams_ids)
        if email_attribute_name is not None:
            pulumi.set(__self__, "email_attribute_name", email_attribute_name)
        if email_attribute_path is not None:
            pulumi.set(__self__, "email_attribute_path", email_attribute_path)
        if empty_scopes is not None:
            pulumi.set(__self__, "empty_scopes", empty_scopes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if groups_attribute_path is not None:
            pulumi.set(__self__, "groups_attribute_path", groups_attribute_path)
        if id_token_attribute_name is not None:
            pulumi.set(__self__, "id_token_attribute_name", id_token_attribute_name)
        if login_attribute_path is not None:
            pulumi.set(__self__, "login_attribute_path", login_attribute_path)
        if login_prompt is not None:
            pulumi.set(__self__, "login_prompt", login_prompt)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_attribute_path is not None:
            pulumi.set(__self__, "name_attribute_path", name_attribute_path)
        if org_attribute_path is not None:
            pulumi.set(__self__, "org_attribute_path", org_attribute_path)
        if org_mapping is not None:
            pulumi.set(__self__, "org_mapping", org_mapping)
        if role_attribute_path is not None:
            pulumi.set(__self__, "role_attribute_path", role_attribute_path)
        if role_attribute_strict is not None:
            pulumi.set(__self__, "role_attribute_strict", role_attribute_strict)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if signout_redirect_url is not None:
            pulumi.set(__self__, "signout_redirect_url", signout_redirect_url)
        if skip_org_role_sync is not None:
            pulumi.set(__self__, "skip_org_role_sync", skip_org_role_sync)
        if team_ids is not None:
            pulumi.set(__self__, "team_ids", team_ids)
        if team_ids_attribute_path is not None:
            pulumi.set(__self__, "team_ids_attribute_path", team_ids_attribute_path)
        if teams_url is not None:
            pulumi.set(__self__, "teams_url", teams_url)
        if tls_client_ca is not None:
            pulumi.set(__self__, "tls_client_ca", tls_client_ca)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_skip_verify_insecure is not None:
            pulumi.set(__self__, "tls_skip_verify_insecure", tls_skip_verify_insecure)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)
        if use_pkce is not None:
            pulumi.set(__self__, "use_pkce", use_pkce)
        if use_refresh_token is not None:
            pulumi.set(__self__, "use_refresh_token", use_refresh_token)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client Id of your OAuth2 app.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="allowAssignGrafanaAdmin")
    def allow_assign_grafana_admin(self) -> Optional[_builtins.bool]:
        """
        If enabled, it will automatically sync the Grafana server administrator role.
        """
        return pulumi.get(self, "allow_assign_grafana_admin")

    @_builtins.property
    @pulumi.getter(name="allowSignUp")
    def allow_sign_up(self) -> Optional[_builtins.bool]:
        """
        If not enabled, only existing Grafana users can log in using OAuth.
        """
        return pulumi.get(self, "allow_sign_up")

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated domains. The user should belong to at least one domain to log in.
        """
        return pulumi.get(self, "allowed_domains")

    @_builtins.property
    @pulumi.getter(name="allowedGroups")
    def allowed_groups(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated groups. The user should be a member of at least one group to log in. For Generic OAuth, if you configure allowed*groups, you must also configure groups*attribute_path.
        """
        return pulumi.get(self, "allowed_groups")

    @_builtins.property
    @pulumi.getter(name="allowedOrganizations")
    def allowed_organizations(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated organizations. The user should be a member of at least one organization to log in.
        """
        return pulumi.get(self, "allowed_organizations")

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[_builtins.str]:
        """
        The user information endpoint of your OAuth2 provider. Required for okta and generic_oauth providers.
        """
        return pulumi.get(self, "api_url")

    @_builtins.property
    @pulumi.getter(name="authStyle")
    def auth_style(self) -> Optional[_builtins.str]:
        """
        It determines how client*id and client*secret are sent to Oauth2 provider. Possible values are AutoDetect, InParams, InHeader. Default is AutoDetect.
        """
        return pulumi.get(self, "auth_style")

    @_builtins.property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> Optional[_builtins.str]:
        """
        The authorization endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        """
        return pulumi.get(self, "auth_url")

    @_builtins.property
    @pulumi.getter(name="autoLogin")
    def auto_login(self) -> Optional[_builtins.bool]:
        """
        Log in automatically, skipping the login screen.
        """
        return pulumi.get(self, "auto_login")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[_builtins.str]:
        """
        The client secret of your OAuth2 app.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def custom(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Custom fields to configure for OAuth2 such as the [force*use*graph_api](https://grafana.com/docs/grafana/latest/setup-grafana/configure-security/configure-authentication/azuread/#force-fetching-groups-from-microsoft-graph-api) field.
        """
        return pulumi.get(self, "custom")

    @_builtins.property
    @pulumi.getter(name="defineAllowedGroups")
    def define_allowed_groups(self) -> Optional[_builtins.bool]:
        """
        Define allowed groups.
        """
        return pulumi.get(self, "define_allowed_groups")

    @_builtins.property
    @pulumi.getter(name="defineAllowedTeamsIds")
    def define_allowed_teams_ids(self) -> Optional[_builtins.bool]:
        """
        Define allowed teams ids.
        """
        return pulumi.get(self, "define_allowed_teams_ids")

    @_builtins.property
    @pulumi.getter(name="emailAttributeName")
    def email_attribute_name(self) -> Optional[_builtins.str]:
        """
        Name of the key to use for user email lookup within the attributes map of OAuth2 ID token. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "email_attribute_name")

    @_builtins.property
    @pulumi.getter(name="emailAttributePath")
    def email_attribute_path(self) -> Optional[_builtins.str]:
        """
        JMESPath expression to use for user email lookup from the user information. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "email_attribute_path")

    @_builtins.property
    @pulumi.getter(name="emptyScopes")
    def empty_scopes(self) -> Optional[_builtins.bool]:
        """
        If enabled, no scopes will be sent to the OAuth2 provider.
        """
        return pulumi.get(self, "empty_scopes")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Define whether this configuration is enabled for the specified provider. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="groupsAttributePath")
    def groups_attribute_path(self) -> Optional[_builtins.str]:
        """
        JMESPath expression to use for user group lookup. If you configure allowed*groups, you must also configure groups*attribute_path.
        """
        return pulumi.get(self, "groups_attribute_path")

    @_builtins.property
    @pulumi.getter(name="idTokenAttributeName")
    def id_token_attribute_name(self) -> Optional[_builtins.str]:
        """
        The name of the key used to extract the ID token from the returned OAuth2 token. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "id_token_attribute_name")

    @_builtins.property
    @pulumi.getter(name="loginAttributePath")
    def login_attribute_path(self) -> Optional[_builtins.str]:
        """
        JMESPath expression to use for user login lookup from the user ID token. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "login_attribute_path")

    @_builtins.property
    @pulumi.getter(name="loginPrompt")
    def login_prompt(self) -> Optional[_builtins.str]:
        """
        Indicates the type of user interaction when the user logs in with the IdP. Available values are `login`, `consent` and `select_account`.
        """
        return pulumi.get(self, "login_prompt")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Helpful if you use more than one identity providers or SSO protocols.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameAttributePath")
    def name_attribute_path(self) -> Optional[_builtins.str]:
        """
        JMESPath expression to use for user name lookup from the user ID token. This name will be used as the user’s display name. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "name_attribute_path")

    @_builtins.property
    @pulumi.getter(name="orgAttributePath")
    def org_attribute_path(self) -> Optional[_builtins.str]:
        """
        JMESPath expression to use for the organization mapping lookup from the user ID token. The extracted list will be used for the organization mapping (to match "Organization" in the "org_mapping"). Only applicable to Generic OAuth and Okta.
        """
        return pulumi.get(self, "org_attribute_path")

    @_builtins.property
    @pulumi.getter(name="orgMapping")
    def org_mapping(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated Organization:OrgIdOrOrgName:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: None, Viewer, Editor or Admin.
        """
        return pulumi.get(self, "org_mapping")

    @_builtins.property
    @pulumi.getter(name="roleAttributePath")
    def role_attribute_path(self) -> Optional[_builtins.str]:
        """
        JMESPath expression to use for Grafana role lookup.
        """
        return pulumi.get(self, "role_attribute_path")

    @_builtins.property
    @pulumi.getter(name="roleAttributeStrict")
    def role_attribute_strict(self) -> Optional[_builtins.bool]:
        """
        If enabled, denies user login if the Grafana role cannot be extracted using Role attribute path.
        """
        return pulumi.get(self, "role_attribute_strict")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated OAuth2 scopes.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter(name="signoutRedirectUrl")
    def signout_redirect_url(self) -> Optional[_builtins.str]:
        """
        The URL to redirect the user to after signing out from Grafana.
        """
        return pulumi.get(self, "signout_redirect_url")

    @_builtins.property
    @pulumi.getter(name="skipOrgRoleSync")
    def skip_org_role_sync(self) -> Optional[_builtins.bool]:
        """
        Prevent synchronizing users’ organization roles from your IdP.
        """
        return pulumi.get(self, "skip_org_role_sync")

    @_builtins.property
    @pulumi.getter(name="teamIds")
    def team_ids(self) -> Optional[_builtins.str]:
        """
        String list of Team Ids. If set, the user must be a member of one of the given teams to log in. If you configure team*ids, you must also configure teams*url and team*ids*attribute_path.
        """
        return pulumi.get(self, "team_ids")

    @_builtins.property
    @pulumi.getter(name="teamIdsAttributePath")
    def team_ids_attribute_path(self) -> Optional[_builtins.str]:
        """
        The JMESPath expression to use for Grafana Team Id lookup within the results returned by the teams_url endpoint. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "team_ids_attribute_path")

    @_builtins.property
    @pulumi.getter(name="teamsUrl")
    def teams_url(self) -> Optional[_builtins.str]:
        """
        The URL used to query for Team Ids. If not set, the default value is /teams. If you configure teams*url, you must also configure team*ids*attribute*path. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "teams_url")

    @_builtins.property
    @pulumi.getter(name="tlsClientCa")
    def tls_client_ca(self) -> Optional[_builtins.str]:
        """
        The path to the trusted certificate authority list. Is not applicable on Grafana Cloud.
        """
        return pulumi.get(self, "tls_client_ca")

    @_builtins.property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[_builtins.str]:
        """
        The path to the certificate. Is not applicable on Grafana Cloud.
        """
        return pulumi.get(self, "tls_client_cert")

    @_builtins.property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[_builtins.str]:
        """
        The path to the key. Is not applicable on Grafana Cloud.
        """
        return pulumi.get(self, "tls_client_key")

    @_builtins.property
    @pulumi.getter(name="tlsSkipVerifyInsecure")
    def tls_skip_verify_insecure(self) -> Optional[_builtins.bool]:
        """
        If enabled, the client accepts any certificate presented by the server and any host name in that certificate. You should only use this for testing, because this mode leaves SSL/TLS susceptible to man-in-the-middle attacks.
        """
        return pulumi.get(self, "tls_skip_verify_insecure")

    @_builtins.property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[_builtins.str]:
        """
        The token endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        """
        return pulumi.get(self, "token_url")

    @_builtins.property
    @pulumi.getter(name="usePkce")
    def use_pkce(self) -> Optional[_builtins.bool]:
        """
        If enabled, Grafana will use Proof Key for Code Exchange (PKCE) with the OAuth2 Authorization Code Grant.
        """
        return pulumi.get(self, "use_pkce")

    @_builtins.property
    @pulumi.getter(name="useRefreshToken")
    def use_refresh_token(self) -> Optional[_builtins.bool]:
        """
        If enabled, Grafana will fetch a new access token using the refresh token provided by the OAuth2 provider.
        """
        return pulumi.get(self, "use_refresh_token")


@pulumi.output_type
class SsoSettingsSamlSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowIdpInitiated":
            suggest = "allow_idp_initiated"
        elif key == "allowSignUp":
            suggest = "allow_sign_up"
        elif key == "allowedOrganizations":
            suggest = "allowed_organizations"
        elif key == "assertionAttributeEmail":
            suggest = "assertion_attribute_email"
        elif key == "assertionAttributeGroups":
            suggest = "assertion_attribute_groups"
        elif key == "assertionAttributeLogin":
            suggest = "assertion_attribute_login"
        elif key == "assertionAttributeName":
            suggest = "assertion_attribute_name"
        elif key == "assertionAttributeOrg":
            suggest = "assertion_attribute_org"
        elif key == "assertionAttributeRole":
            suggest = "assertion_attribute_role"
        elif key == "autoLogin":
            suggest = "auto_login"
        elif key == "certificatePath":
            suggest = "certificate_path"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "entityId":
            suggest = "entity_id"
        elif key == "forceUseGraphApi":
            suggest = "force_use_graph_api"
        elif key == "idpMetadata":
            suggest = "idp_metadata"
        elif key == "idpMetadataPath":
            suggest = "idp_metadata_path"
        elif key == "idpMetadataUrl":
            suggest = "idp_metadata_url"
        elif key == "maxIssueDelay":
            suggest = "max_issue_delay"
        elif key == "metadataValidDuration":
            suggest = "metadata_valid_duration"
        elif key == "nameIdFormat":
            suggest = "name_id_format"
        elif key == "orgMapping":
            suggest = "org_mapping"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "privateKeyPath":
            suggest = "private_key_path"
        elif key == "relayState":
            suggest = "relay_state"
        elif key == "roleValuesAdmin":
            suggest = "role_values_admin"
        elif key == "roleValuesEditor":
            suggest = "role_values_editor"
        elif key == "roleValuesGrafanaAdmin":
            suggest = "role_values_grafana_admin"
        elif key == "roleValuesNone":
            suggest = "role_values_none"
        elif key == "roleValuesViewer":
            suggest = "role_values_viewer"
        elif key == "signatureAlgorithm":
            suggest = "signature_algorithm"
        elif key == "singleLogout":
            suggest = "single_logout"
        elif key == "skipOrgRoleSync":
            suggest = "skip_org_role_sync"
        elif key == "tokenUrl":
            suggest = "token_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsSamlSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsSamlSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsSamlSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_idp_initiated: Optional[_builtins.bool] = None,
                 allow_sign_up: Optional[_builtins.bool] = None,
                 allowed_organizations: Optional[_builtins.str] = None,
                 assertion_attribute_email: Optional[_builtins.str] = None,
                 assertion_attribute_groups: Optional[_builtins.str] = None,
                 assertion_attribute_login: Optional[_builtins.str] = None,
                 assertion_attribute_name: Optional[_builtins.str] = None,
                 assertion_attribute_org: Optional[_builtins.str] = None,
                 assertion_attribute_role: Optional[_builtins.str] = None,
                 auto_login: Optional[_builtins.bool] = None,
                 certificate: Optional[_builtins.str] = None,
                 certificate_path: Optional[_builtins.str] = None,
                 client_id: Optional[_builtins.str] = None,
                 client_secret: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 entity_id: Optional[_builtins.str] = None,
                 force_use_graph_api: Optional[_builtins.bool] = None,
                 idp_metadata: Optional[_builtins.str] = None,
                 idp_metadata_path: Optional[_builtins.str] = None,
                 idp_metadata_url: Optional[_builtins.str] = None,
                 max_issue_delay: Optional[_builtins.str] = None,
                 metadata_valid_duration: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 name_id_format: Optional[_builtins.str] = None,
                 org_mapping: Optional[_builtins.str] = None,
                 private_key: Optional[_builtins.str] = None,
                 private_key_path: Optional[_builtins.str] = None,
                 relay_state: Optional[_builtins.str] = None,
                 role_values_admin: Optional[_builtins.str] = None,
                 role_values_editor: Optional[_builtins.str] = None,
                 role_values_grafana_admin: Optional[_builtins.str] = None,
                 role_values_none: Optional[_builtins.str] = None,
                 role_values_viewer: Optional[_builtins.str] = None,
                 signature_algorithm: Optional[_builtins.str] = None,
                 single_logout: Optional[_builtins.bool] = None,
                 skip_org_role_sync: Optional[_builtins.bool] = None,
                 token_url: Optional[_builtins.str] = None):
        """
        :param _builtins.bool allow_idp_initiated: Whether SAML IdP-initiated login is allowed.
        :param _builtins.bool allow_sign_up: Whether to allow new Grafana user creation through SAML login. If set to false, then only existing Grafana users can log in with SAML.
        :param _builtins.str allowed_organizations: List of comma- or space-separated organizations. User should be a member of at least one organization to log in.
        :param _builtins.str assertion_attribute_email: Friendly name or name of the attribute within the SAML assertion to use as the user email.
        :param _builtins.str assertion_attribute_groups: Friendly name or name of the attribute within the SAML assertion to use as the user groups.
        :param _builtins.str assertion_attribute_login: Friendly name or name of the attribute within the SAML assertion to use as the user login handle.
        :param _builtins.str assertion_attribute_name: Friendly name or name of the attribute within the SAML assertion to use as the user name. Alternatively, this can be a template with variables that match the names of attributes within the SAML assertion.
        :param _builtins.str assertion_attribute_org: Friendly name or name of the attribute within the SAML assertion to use as the user organization.
        :param _builtins.str assertion_attribute_role: Friendly name or name of the attribute within the SAML assertion to use as the user roles.
        :param _builtins.bool auto_login: Whether SAML auto login is enabled.
        :param _builtins.str certificate: Base64-encoded string for the SP X.509 certificate.
        :param _builtins.str certificate_path: Path for the SP X.509 certificate.
        :param _builtins.str client_id: The client Id of your OAuth2 app.
        :param _builtins.str client_secret: The client secret of your OAuth2 app.
        :param _builtins.bool enabled: Define whether this configuration is enabled for SAML. Defaults to `true`.
        :param _builtins.str entity_id: The entity ID is a globally unique identifier for the service provider. It is used to identify the service provider to the identity provider. Defaults to the URL of the Grafana instance if not set.
        :param _builtins.bool force_use_graph_api: If enabled, Grafana will fetch groups from Microsoft Graph API instead of using the groups claim from the ID token.
        :param _builtins.str idp_metadata: Base64-encoded string for the IdP SAML metadata XML.
        :param _builtins.str idp_metadata_path: Path for the IdP SAML metadata XML.
        :param _builtins.str idp_metadata_url: URL for the IdP SAML metadata XML.
        :param _builtins.str max_issue_delay: Duration, since the IdP issued a response and the SP is allowed to process it. For example: 90s, 1h.
        :param _builtins.str metadata_valid_duration: Duration, for how long the SP metadata is valid. For example: 48h, 5d.
        :param _builtins.str name: Name used to refer to the SAML authentication.
        :param _builtins.str name_id_format: The Name ID Format to request within the SAML assertion. Defaults to urn:oasis:names:tc:SAML:2.0:nameid-format:transient
        :param _builtins.str org_mapping: List of comma- or space-separated Organization:OrgId:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: Viewer, Editor or Admin.
        :param _builtins.str private_key: Base64-encoded string for the SP private key.
        :param _builtins.str private_key_path: Path for the SP private key.
        :param _builtins.str relay_state: Relay state for IdP-initiated login. Should match relay state configured in IdP.
        :param _builtins.str role_values_admin: List of comma- or space-separated roles which will be mapped into the Admin role.
        :param _builtins.str role_values_editor: List of comma- or space-separated roles which will be mapped into the Editor role.
        :param _builtins.str role_values_grafana_admin: List of comma- or space-separated roles which will be mapped into the Grafana Admin (Super Admin) role.
        :param _builtins.str role_values_none: List of comma- or space-separated roles which will be mapped into the None role.
        :param _builtins.str role_values_viewer: List of comma- or space-separated roles which will be mapped into the Viewer role.
        :param _builtins.str signature_algorithm: Signature algorithm used for signing requests to the IdP. Supported values are rsa-sha1, rsa-sha256, rsa-sha512.
        :param _builtins.bool single_logout: Whether SAML Single Logout is enabled.
        :param _builtins.bool skip_org_role_sync: Prevent synchronizing users’ organization roles from your IdP.
        :param _builtins.str token_url: The token endpoint of your OAuth2 provider. Required for Azure AD providers.
        """
        if allow_idp_initiated is not None:
            pulumi.set(__self__, "allow_idp_initiated", allow_idp_initiated)
        if allow_sign_up is not None:
            pulumi.set(__self__, "allow_sign_up", allow_sign_up)
        if allowed_organizations is not None:
            pulumi.set(__self__, "allowed_organizations", allowed_organizations)
        if assertion_attribute_email is not None:
            pulumi.set(__self__, "assertion_attribute_email", assertion_attribute_email)
        if assertion_attribute_groups is not None:
            pulumi.set(__self__, "assertion_attribute_groups", assertion_attribute_groups)
        if assertion_attribute_login is not None:
            pulumi.set(__self__, "assertion_attribute_login", assertion_attribute_login)
        if assertion_attribute_name is not None:
            pulumi.set(__self__, "assertion_attribute_name", assertion_attribute_name)
        if assertion_attribute_org is not None:
            pulumi.set(__self__, "assertion_attribute_org", assertion_attribute_org)
        if assertion_attribute_role is not None:
            pulumi.set(__self__, "assertion_attribute_role", assertion_attribute_role)
        if auto_login is not None:
            pulumi.set(__self__, "auto_login", auto_login)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_path is not None:
            pulumi.set(__self__, "certificate_path", certificate_path)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if force_use_graph_api is not None:
            pulumi.set(__self__, "force_use_graph_api", force_use_graph_api)
        if idp_metadata is not None:
            pulumi.set(__self__, "idp_metadata", idp_metadata)
        if idp_metadata_path is not None:
            pulumi.set(__self__, "idp_metadata_path", idp_metadata_path)
        if idp_metadata_url is not None:
            pulumi.set(__self__, "idp_metadata_url", idp_metadata_url)
        if max_issue_delay is not None:
            pulumi.set(__self__, "max_issue_delay", max_issue_delay)
        if metadata_valid_duration is not None:
            pulumi.set(__self__, "metadata_valid_duration", metadata_valid_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_id_format is not None:
            pulumi.set(__self__, "name_id_format", name_id_format)
        if org_mapping is not None:
            pulumi.set(__self__, "org_mapping", org_mapping)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_path is not None:
            pulumi.set(__self__, "private_key_path", private_key_path)
        if relay_state is not None:
            pulumi.set(__self__, "relay_state", relay_state)
        if role_values_admin is not None:
            pulumi.set(__self__, "role_values_admin", role_values_admin)
        if role_values_editor is not None:
            pulumi.set(__self__, "role_values_editor", role_values_editor)
        if role_values_grafana_admin is not None:
            pulumi.set(__self__, "role_values_grafana_admin", role_values_grafana_admin)
        if role_values_none is not None:
            pulumi.set(__self__, "role_values_none", role_values_none)
        if role_values_viewer is not None:
            pulumi.set(__self__, "role_values_viewer", role_values_viewer)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if single_logout is not None:
            pulumi.set(__self__, "single_logout", single_logout)
        if skip_org_role_sync is not None:
            pulumi.set(__self__, "skip_org_role_sync", skip_org_role_sync)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)

    @_builtins.property
    @pulumi.getter(name="allowIdpInitiated")
    def allow_idp_initiated(self) -> Optional[_builtins.bool]:
        """
        Whether SAML IdP-initiated login is allowed.
        """
        return pulumi.get(self, "allow_idp_initiated")

    @_builtins.property
    @pulumi.getter(name="allowSignUp")
    def allow_sign_up(self) -> Optional[_builtins.bool]:
        """
        Whether to allow new Grafana user creation through SAML login. If set to false, then only existing Grafana users can log in with SAML.
        """
        return pulumi.get(self, "allow_sign_up")

    @_builtins.property
    @pulumi.getter(name="allowedOrganizations")
    def allowed_organizations(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated organizations. User should be a member of at least one organization to log in.
        """
        return pulumi.get(self, "allowed_organizations")

    @_builtins.property
    @pulumi.getter(name="assertionAttributeEmail")
    def assertion_attribute_email(self) -> Optional[_builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user email.
        """
        return pulumi.get(self, "assertion_attribute_email")

    @_builtins.property
    @pulumi.getter(name="assertionAttributeGroups")
    def assertion_attribute_groups(self) -> Optional[_builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user groups.
        """
        return pulumi.get(self, "assertion_attribute_groups")

    @_builtins.property
    @pulumi.getter(name="assertionAttributeLogin")
    def assertion_attribute_login(self) -> Optional[_builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user login handle.
        """
        return pulumi.get(self, "assertion_attribute_login")

    @_builtins.property
    @pulumi.getter(name="assertionAttributeName")
    def assertion_attribute_name(self) -> Optional[_builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user name. Alternatively, this can be a template with variables that match the names of attributes within the SAML assertion.
        """
        return pulumi.get(self, "assertion_attribute_name")

    @_builtins.property
    @pulumi.getter(name="assertionAttributeOrg")
    def assertion_attribute_org(self) -> Optional[_builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user organization.
        """
        return pulumi.get(self, "assertion_attribute_org")

    @_builtins.property
    @pulumi.getter(name="assertionAttributeRole")
    def assertion_attribute_role(self) -> Optional[_builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user roles.
        """
        return pulumi.get(self, "assertion_attribute_role")

    @_builtins.property
    @pulumi.getter(name="autoLogin")
    def auto_login(self) -> Optional[_builtins.bool]:
        """
        Whether SAML auto login is enabled.
        """
        return pulumi.get(self, "auto_login")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[_builtins.str]:
        """
        Base64-encoded string for the SP X.509 certificate.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="certificatePath")
    def certificate_path(self) -> Optional[_builtins.str]:
        """
        Path for the SP X.509 certificate.
        """
        return pulumi.get(self, "certificate_path")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The client Id of your OAuth2 app.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[_builtins.str]:
        """
        The client secret of your OAuth2 app.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Define whether this configuration is enabled for SAML. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[_builtins.str]:
        """
        The entity ID is a globally unique identifier for the service provider. It is used to identify the service provider to the identity provider. Defaults to the URL of the Grafana instance if not set.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="forceUseGraphApi")
    def force_use_graph_api(self) -> Optional[_builtins.bool]:
        """
        If enabled, Grafana will fetch groups from Microsoft Graph API instead of using the groups claim from the ID token.
        """
        return pulumi.get(self, "force_use_graph_api")

    @_builtins.property
    @pulumi.getter(name="idpMetadata")
    def idp_metadata(self) -> Optional[_builtins.str]:
        """
        Base64-encoded string for the IdP SAML metadata XML.
        """
        return pulumi.get(self, "idp_metadata")

    @_builtins.property
    @pulumi.getter(name="idpMetadataPath")
    def idp_metadata_path(self) -> Optional[_builtins.str]:
        """
        Path for the IdP SAML metadata XML.
        """
        return pulumi.get(self, "idp_metadata_path")

    @_builtins.property
    @pulumi.getter(name="idpMetadataUrl")
    def idp_metadata_url(self) -> Optional[_builtins.str]:
        """
        URL for the IdP SAML metadata XML.
        """
        return pulumi.get(self, "idp_metadata_url")

    @_builtins.property
    @pulumi.getter(name="maxIssueDelay")
    def max_issue_delay(self) -> Optional[_builtins.str]:
        """
        Duration, since the IdP issued a response and the SP is allowed to process it. For example: 90s, 1h.
        """
        return pulumi.get(self, "max_issue_delay")

    @_builtins.property
    @pulumi.getter(name="metadataValidDuration")
    def metadata_valid_duration(self) -> Optional[_builtins.str]:
        """
        Duration, for how long the SP metadata is valid. For example: 48h, 5d.
        """
        return pulumi.get(self, "metadata_valid_duration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name used to refer to the SAML authentication.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameIdFormat")
    def name_id_format(self) -> Optional[_builtins.str]:
        """
        The Name ID Format to request within the SAML assertion. Defaults to urn:oasis:names:tc:SAML:2.0:nameid-format:transient
        """
        return pulumi.get(self, "name_id_format")

    @_builtins.property
    @pulumi.getter(name="orgMapping")
    def org_mapping(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated Organization:OrgId:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: Viewer, Editor or Admin.
        """
        return pulumi.get(self, "org_mapping")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[_builtins.str]:
        """
        Base64-encoded string for the SP private key.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> Optional[_builtins.str]:
        """
        Path for the SP private key.
        """
        return pulumi.get(self, "private_key_path")

    @_builtins.property
    @pulumi.getter(name="relayState")
    def relay_state(self) -> Optional[_builtins.str]:
        """
        Relay state for IdP-initiated login. Should match relay state configured in IdP.
        """
        return pulumi.get(self, "relay_state")

    @_builtins.property
    @pulumi.getter(name="roleValuesAdmin")
    def role_values_admin(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the Admin role.
        """
        return pulumi.get(self, "role_values_admin")

    @_builtins.property
    @pulumi.getter(name="roleValuesEditor")
    def role_values_editor(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the Editor role.
        """
        return pulumi.get(self, "role_values_editor")

    @_builtins.property
    @pulumi.getter(name="roleValuesGrafanaAdmin")
    def role_values_grafana_admin(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the Grafana Admin (Super Admin) role.
        """
        return pulumi.get(self, "role_values_grafana_admin")

    @_builtins.property
    @pulumi.getter(name="roleValuesNone")
    def role_values_none(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the None role.
        """
        return pulumi.get(self, "role_values_none")

    @_builtins.property
    @pulumi.getter(name="roleValuesViewer")
    def role_values_viewer(self) -> Optional[_builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the Viewer role.
        """
        return pulumi.get(self, "role_values_viewer")

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[_builtins.str]:
        """
        Signature algorithm used for signing requests to the IdP. Supported values are rsa-sha1, rsa-sha256, rsa-sha512.
        """
        return pulumi.get(self, "signature_algorithm")

    @_builtins.property
    @pulumi.getter(name="singleLogout")
    def single_logout(self) -> Optional[_builtins.bool]:
        """
        Whether SAML Single Logout is enabled.
        """
        return pulumi.get(self, "single_logout")

    @_builtins.property
    @pulumi.getter(name="skipOrgRoleSync")
    def skip_org_role_sync(self) -> Optional[_builtins.bool]:
        """
        Prevent synchronizing users’ organization roles from your IdP.
        """
        return pulumi.get(self, "skip_org_role_sync")

    @_builtins.property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[_builtins.str]:
        """
        The token endpoint of your OAuth2 provider. Required for Azure AD providers.
        """
        return pulumi.get(self, "token_url")


@pulumi.output_type
class TeamPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "homeDashboardUid":
            suggest = "home_dashboard_uid"
        elif key == "weekStart":
            suggest = "week_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 home_dashboard_uid: Optional[_builtins.str] = None,
                 theme: Optional[_builtins.str] = None,
                 timezone: Optional[_builtins.str] = None,
                 week_start: Optional[_builtins.str] = None):
        """
        :param _builtins.str home_dashboard_uid: The UID of the dashboard to display when a team member logs in.
        :param _builtins.str theme: The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        :param _builtins.str timezone: The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        :param _builtins.str week_start: The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        if home_dashboard_uid is not None:
            pulumi.set(__self__, "home_dashboard_uid", home_dashboard_uid)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @_builtins.property
    @pulumi.getter(name="homeDashboardUid")
    def home_dashboard_uid(self) -> Optional[_builtins.str]:
        """
        The UID of the dashboard to display when a team member logs in.
        """
        return pulumi.get(self, "home_dashboard_uid")

    @_builtins.property
    @pulumi.getter
    def theme(self) -> Optional[_builtins.str]:
        """
        The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        """
        return pulumi.get(self, "theme")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[_builtins.str]:
        """
        The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[_builtins.str]:
        """
        The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        return pulumi.get(self, "week_start")


@pulumi.output_type
class TeamTeamSync(dict):
    def __init__(__self__, *,
                 groups: Optional[Sequence[_builtins.str]] = None):
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "groups")


@pulumi.output_type
class GetDashboardsDashboardResult(dict):
    def __init__(__self__, *,
                 folder_title: _builtins.str,
                 title: _builtins.str,
                 uid: _builtins.str):
        pulumi.set(__self__, "folder_title", folder_title)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="folderTitle")
    def folder_title(self) -> _builtins.str:
        return pulumi.get(self, "folder_title")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetFoldersFolderResult(dict):
    def __init__(__self__, *,
                 id: _builtins.int,
                 title: _builtins.str,
                 uid: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.int id: The folder ID.
        :param _builtins.str title: The folder title.
        :param _builtins.str uid: The folder's unique identifier.
        :param _builtins.str url: The folder's URL
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "uid", uid)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The folder ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        The folder title.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        """
        The folder's unique identifier.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The folder's URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetLibraryPanelsPanelResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 folder_uid: _builtins.str,
                 model_json: _builtins.str,
                 name: _builtins.str,
                 uid: _builtins.str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "folder_uid", folder_uid)
        pulumi.set(__self__, "model_json", model_json)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderUid")
    def folder_uid(self) -> _builtins.str:
        return pulumi.get(self, "folder_uid")

    @_builtins.property
    @pulumi.getter(name="modelJson")
    def model_json(self) -> _builtins.str:
        return pulumi.get(self, "model_json")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetTeamPreferenceResult(dict):
    def __init__(__self__, *,
                 home_dashboard_uid: Optional[_builtins.str] = None,
                 theme: Optional[_builtins.str] = None,
                 timezone: Optional[_builtins.str] = None,
                 week_start: Optional[_builtins.str] = None):
        """
        :param _builtins.str home_dashboard_uid: The UID of the dashboard to display when a team member logs in.
        :param _builtins.str theme: The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        :param _builtins.str timezone: The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        :param _builtins.str week_start: The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        if home_dashboard_uid is not None:
            pulumi.set(__self__, "home_dashboard_uid", home_dashboard_uid)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @_builtins.property
    @pulumi.getter(name="homeDashboardUid")
    def home_dashboard_uid(self) -> Optional[_builtins.str]:
        """
        The UID of the dashboard to display when a team member logs in.
        """
        return pulumi.get(self, "home_dashboard_uid")

    @_builtins.property
    @pulumi.getter
    def theme(self) -> Optional[_builtins.str]:
        """
        The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        """
        return pulumi.get(self, "theme")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[_builtins.str]:
        """
        The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[_builtins.str]:
        """
        The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        return pulumi.get(self, "week_start")


@pulumi.output_type
class GetTeamTeamSyncResult(dict):
    def __init__(__self__, *,
                 groups: Optional[Sequence[_builtins.str]] = None):
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "groups")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str,
                 id: _builtins.int,
                 is_admin: _builtins.bool,
                 login: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str email: The user's email.
        :param _builtins.int id: The user ID.
        :param _builtins.bool is_admin: Whether the user is admin or not.
        :param _builtins.str login: The user's login.
        :param _builtins.str name: The user's name.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_admin", is_admin)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The user's email.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The user ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> _builtins.bool:
        """
        Whether the user is admin or not.
        """
        return pulumi.get(self, "is_admin")

    @_builtins.property
    @pulumi.getter
    def login(self) -> _builtins.str:
        """
        The user's login.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The user's name.
        """
        return pulumi.get(self, "name")


