# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictInt, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.create_reconciliation_request import CreateReconciliationRequest
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.inline_valuations_reconciliation_request import InlineValuationsReconciliationRequest
from lusid.models.list_aggregation_reconciliation import ListAggregationReconciliation
from lusid.models.mapping import Mapping
from lusid.models.paged_resource_list_of_reconciliation import PagedResourceListOfReconciliation
from lusid.models.portfolios_reconciliation_request import PortfoliosReconciliationRequest
from lusid.models.reconciliation import Reconciliation
from lusid.models.reconciliation_request import ReconciliationRequest
from lusid.models.reconciliation_response import ReconciliationResponse
from lusid.models.resource_list_of_mapping import ResourceListOfMapping
from lusid.models.resource_list_of_reconciliation_break import ResourceListOfReconciliationBreak
from lusid.models.transaction_reconciliation_request import TransactionReconciliationRequest
from lusid.models.transaction_reconciliation_request_v2 import TransactionReconciliationRequestV2
from lusid.models.transactions_reconciliations_response import TransactionsReconciliationsResponse
from lusid.models.update_reconciliation_request import UpdateReconciliationRequest
from lusid.models.valuations_reconciliation_request import ValuationsReconciliationRequest

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class ReconciliationsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_scheduled_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reconciliation")], create_reconciliation_request : Annotated[Optional[CreateReconciliationRequest], Field(description="The definition of the reconciliation")] = None, **kwargs) -> Reconciliation:  # noqa: E501
        ...

    @overload
    def create_scheduled_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reconciliation")], create_reconciliation_request : Annotated[Optional[CreateReconciliationRequest], Field(description="The definition of the reconciliation")] = None, async_req: Optional[bool]=True, **kwargs) -> Reconciliation:  # noqa: E501
        ...

    @validate_arguments
    def create_scheduled_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reconciliation")], create_reconciliation_request : Annotated[Optional[CreateReconciliationRequest], Field(description="The definition of the reconciliation")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Reconciliation, Awaitable[Reconciliation]]:  # noqa: E501
        """[EXPERIMENTAL] CreateScheduledReconciliation: Create a scheduled reconciliation  # noqa: E501

        Create a scheduled reconciliation for the given request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_scheduled_reconciliation(scope, create_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reconciliation (required)
        :type scope: str
        :param create_reconciliation_request: The definition of the reconciliation
        :type create_reconciliation_request: CreateReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Reconciliation
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_scheduled_reconciliation_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_scheduled_reconciliation_with_http_info(scope, create_reconciliation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_scheduled_reconciliation_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reconciliation")], create_reconciliation_request : Annotated[Optional[CreateReconciliationRequest], Field(description="The definition of the reconciliation")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] CreateScheduledReconciliation: Create a scheduled reconciliation  # noqa: E501

        Create a scheduled reconciliation for the given request  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_scheduled_reconciliation_with_http_info(scope, create_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reconciliation (required)
        :type scope: str
        :param create_reconciliation_request: The definition of the reconciliation
        :type create_reconciliation_request: CreateReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Reconciliation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'create_reconciliation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_scheduled_reconciliation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_reconciliation_request'] is not None:
            _body_params = _params['create_reconciliation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Reconciliation",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$scheduledReconciliations/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the scheduled reconciliation")], code : Annotated[StrictStr, Field(..., description="The code of the scheduled reconciliation")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the scheduled reconciliation")], code : Annotated[StrictStr, Field(..., description="The code of the scheduled reconciliation")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the scheduled reconciliation")], code : Annotated[StrictStr, Field(..., description="The code of the scheduled reconciliation")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EXPERIMENTAL] DeleteReconciliation: Delete scheduled reconciliation  # noqa: E501

        Delete the given scheduled reconciliation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_reconciliation(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the scheduled reconciliation (required)
        :type scope: str
        :param code: The code of the scheduled reconciliation (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_reconciliation_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_reconciliation_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_reconciliation_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the scheduled reconciliation")], code : Annotated[StrictStr, Field(..., description="The code of the scheduled reconciliation")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] DeleteReconciliation: Delete scheduled reconciliation  # noqa: E501

        Delete the given scheduled reconciliation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_reconciliation_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the scheduled reconciliation (required)
        :type scope: str
        :param code: The code of the scheduled reconciliation (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_reconciliation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$scheduledReconciliations/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_reconciliation_mapping(self, scope : Annotated[StrictStr, Field(..., description="The scope of the mapping.")], code : Annotated[StrictStr, Field(..., description="The code fof the mapping.")], **kwargs) -> str:  # noqa: E501
        ...

    @overload
    def delete_reconciliation_mapping(self, scope : Annotated[StrictStr, Field(..., description="The scope of the mapping.")], code : Annotated[StrictStr, Field(..., description="The code fof the mapping.")], async_req: Optional[bool]=True, **kwargs) -> str:  # noqa: E501
        ...

    @validate_arguments
    def delete_reconciliation_mapping(self, scope : Annotated[StrictStr, Field(..., description="The scope of the mapping.")], code : Annotated[StrictStr, Field(..., description="The code fof the mapping.")], async_req: Optional[bool]=None, **kwargs) -> Union[str, Awaitable[str]]:  # noqa: E501
        """[EARLY ACCESS] DeleteReconciliationMapping: Delete a mapping  # noqa: E501

        Deletes the mapping identified by the scope and code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_reconciliation_mapping(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the mapping. (required)
        :type scope: str
        :param code: The code fof the mapping. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_reconciliation_mapping_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_reconciliation_mapping_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_reconciliation_mapping_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the mapping.")], code : Annotated[StrictStr, Field(..., description="The code fof the mapping.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeleteReconciliationMapping: Delete a mapping  # noqa: E501

        Deletes the mapping identified by the scope and code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_reconciliation_mapping_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the mapping. (required)
        :type scope: str
        :param code: The code fof the mapping. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_reconciliation_mapping" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/mapping/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the scheduled reconciliation")], code : Annotated[StrictStr, Field(..., description="The code of the scheduled reconciliation")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the scheduled reconciliation. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the scheduled reconciliation. Defaults to returning the latest version of the reconciliation if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Reconciliation' property domain to decorate onto the reconciliation.              These must take the form {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.")] = None, **kwargs) -> Reconciliation:  # noqa: E501
        ...

    @overload
    def get_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the scheduled reconciliation")], code : Annotated[StrictStr, Field(..., description="The code of the scheduled reconciliation")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the scheduled reconciliation. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the scheduled reconciliation. Defaults to returning the latest version of the reconciliation if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Reconciliation' property domain to decorate onto the reconciliation.              These must take the form {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> Reconciliation:  # noqa: E501
        ...

    @validate_arguments
    def get_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the scheduled reconciliation")], code : Annotated[StrictStr, Field(..., description="The code of the scheduled reconciliation")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the scheduled reconciliation. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the scheduled reconciliation. Defaults to returning the latest version of the reconciliation if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Reconciliation' property domain to decorate onto the reconciliation.              These must take the form {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Reconciliation, Awaitable[Reconciliation]]:  # noqa: E501
        """[EXPERIMENTAL] GetReconciliation: Get scheduled reconciliation  # noqa: E501

        Get the requested scheduled reconciliation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_reconciliation(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the scheduled reconciliation (required)
        :type scope: str
        :param code: The code of the scheduled reconciliation (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the scheduled reconciliation. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the scheduled reconciliation. Defaults to returning the latest version of the reconciliation if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Reconciliation' property domain to decorate onto the reconciliation.              These must take the form {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Reconciliation
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_reconciliation_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_reconciliation_with_http_info(scope, code, effective_at, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_reconciliation_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the scheduled reconciliation")], code : Annotated[StrictStr, Field(..., description="The code of the scheduled reconciliation")], effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to retrieve the scheduled reconciliation. Defaults to the current LUSID system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to retrieve the scheduled reconciliation. Defaults to returning the latest version of the reconciliation if not specified.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Reconciliation' property domain to decorate onto the reconciliation.              These must take the form {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] GetReconciliation: Get scheduled reconciliation  # noqa: E501

        Get the requested scheduled reconciliation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_reconciliation_with_http_info(scope, code, effective_at, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the scheduled reconciliation (required)
        :type scope: str
        :param code: The code of the scheduled reconciliation (required)
        :type code: str
        :param effective_at: The effective datetime or cut label at which to retrieve the scheduled reconciliation. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the scheduled reconciliation. Defaults to returning the latest version of the reconciliation if not specified.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Reconciliation' property domain to decorate onto the reconciliation.              These must take the form {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Reconciliation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'effective_at',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reconciliation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Reconciliation",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$scheduledReconciliations/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_reconciliation_mapping(self, scope : Annotated[StrictStr, Field(..., description="The scope of the mapping.")], code : Annotated[StrictStr, Field(..., description="The code of the mapping.")], **kwargs) -> Mapping:  # noqa: E501
        ...

    @overload
    def get_reconciliation_mapping(self, scope : Annotated[StrictStr, Field(..., description="The scope of the mapping.")], code : Annotated[StrictStr, Field(..., description="The code of the mapping.")], async_req: Optional[bool]=True, **kwargs) -> Mapping:  # noqa: E501
        ...

    @validate_arguments
    def get_reconciliation_mapping(self, scope : Annotated[StrictStr, Field(..., description="The scope of the mapping.")], code : Annotated[StrictStr, Field(..., description="The code of the mapping.")], async_req: Optional[bool]=None, **kwargs) -> Union[Mapping, Awaitable[Mapping]]:  # noqa: E501
        """[EARLY ACCESS] GetReconciliationMapping: Get a mapping  # noqa: E501

        Gets a mapping identified by the given scope and code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_reconciliation_mapping(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the mapping. (required)
        :type scope: str
        :param code: The code of the mapping. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Mapping
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_reconciliation_mapping_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_reconciliation_mapping_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_reconciliation_mapping_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the mapping.")], code : Annotated[StrictStr, Field(..., description="The code of the mapping.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetReconciliationMapping: Get a mapping  # noqa: E501

        Gets a mapping identified by the given scope and code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_reconciliation_mapping_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the mapping. (required)
        :type scope: str
        :param code: The code of the mapping. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Mapping, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reconciliation_mapping" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Mapping",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/mapping/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_reconciliation_mappings(self, reconciliation_type : Annotated[Optional[StrictStr], Field( description="Optional parameter to specify which type of mappings should be returned.  Defaults to Transaction if not provided.")] = None, **kwargs) -> ResourceListOfMapping:  # noqa: E501
        ...

    @overload
    def list_reconciliation_mappings(self, reconciliation_type : Annotated[Optional[StrictStr], Field( description="Optional parameter to specify which type of mappings should be returned.  Defaults to Transaction if not provided.")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfMapping:  # noqa: E501
        ...

    @validate_arguments
    def list_reconciliation_mappings(self, reconciliation_type : Annotated[Optional[StrictStr], Field( description="Optional parameter to specify which type of mappings should be returned.  Defaults to Transaction if not provided.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfMapping, Awaitable[ResourceListOfMapping]]:  # noqa: E501
        """[EARLY ACCESS] ListReconciliationMappings: List the reconciliation mappings  # noqa: E501

        Lists all mappings this user is entitled to see  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_reconciliation_mappings(reconciliation_type, async_req=True)
        >>> result = thread.get()

        :param reconciliation_type: Optional parameter to specify which type of mappings should be returned.  Defaults to Transaction if not provided.
        :type reconciliation_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfMapping
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_reconciliation_mappings_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_reconciliation_mappings_with_http_info(reconciliation_type, **kwargs)  # noqa: E501

    @validate_arguments
    def list_reconciliation_mappings_with_http_info(self, reconciliation_type : Annotated[Optional[StrictStr], Field( description="Optional parameter to specify which type of mappings should be returned.  Defaults to Transaction if not provided.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListReconciliationMappings: List the reconciliation mappings  # noqa: E501

        Lists all mappings this user is entitled to see  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_reconciliation_mappings_with_http_info(reconciliation_type, async_req=True)
        >>> result = thread.get()

        :param reconciliation_type: Optional parameter to specify which type of mappings should be returned.  Defaults to Transaction if not provided.
        :type reconciliation_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfMapping, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'reconciliation_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_reconciliation_mappings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('reconciliation_type') is not None:  # noqa: E501
            _query_params.append(('reconciliationType', _params['reconciliation_type']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfMapping",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/mapping', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_reconciliations(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the reconciliation. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the reconciliation. Defaults to returning the latest version              of each reconciliation if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing reconciliations; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the reconciliation type, specify \"id.Code eq '001'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Reconciliation' domain to decorate onto each reconciliation.              These must take the format {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.")] = None, **kwargs) -> PagedResourceListOfReconciliation:  # noqa: E501
        ...

    @overload
    def list_reconciliations(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the reconciliation. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the reconciliation. Defaults to returning the latest version              of each reconciliation if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing reconciliations; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the reconciliation type, specify \"id.Code eq '001'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Reconciliation' domain to decorate onto each reconciliation.              These must take the format {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfReconciliation:  # noqa: E501
        ...

    @validate_arguments
    def list_reconciliations(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the reconciliation. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the reconciliation. Defaults to returning the latest version              of each reconciliation if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing reconciliations; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the reconciliation type, specify \"id.Code eq '001'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Reconciliation' domain to decorate onto each reconciliation.              These must take the format {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfReconciliation, Awaitable[PagedResourceListOfReconciliation]]:  # noqa: E501
        """[EXPERIMENTAL] ListReconciliations: List scheduled reconciliations  # noqa: E501

        List all the scheduled reconciliations matching particular criteria  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_reconciliations(effective_at, as_at, page, limit, filter, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the reconciliation. Defaults to the current LUSID              system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the reconciliation. Defaults to returning the latest version              of each reconciliation if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing reconciliations; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.              For example, to filter on the reconciliation type, specify \"id.Code eq '001'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param property_keys: A list of property keys from the 'Reconciliation' domain to decorate onto each reconciliation.              These must take the format {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfReconciliation
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_reconciliations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_reconciliations_with_http_info(effective_at, as_at, page, limit, filter, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_reconciliations_with_http_info(self, effective_at : Annotated[Optional[StrictStr], Field( description="The effective datetime or cut label at which to list the TimeVariant properties for the reconciliation. Defaults to the current LUSID              system datetime if not specified.")] = None, as_at : Annotated[Optional[datetime], Field(description="The asAt datetime at which to list the reconciliation. Defaults to returning the latest version              of each reconciliation if not specified.")] = None, page : Annotated[Optional[StrictStr], Field( description="The pagination token to use to continue listing reconciliations; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="When paginating, limit the results to this number. Defaults to 100 if not specified.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Expression to filter the results.              For example, to filter on the reconciliation type, specify \"id.Code eq '001'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Reconciliation' domain to decorate onto each reconciliation.              These must take the format {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListReconciliations: List scheduled reconciliations  # noqa: E501

        List all the scheduled reconciliations matching particular criteria  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_reconciliations_with_http_info(effective_at, as_at, page, limit, filter, property_keys, async_req=True)
        >>> result = thread.get()

        :param effective_at: The effective datetime or cut label at which to list the TimeVariant properties for the reconciliation. Defaults to the current LUSID              system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the reconciliation. Defaults to returning the latest version              of each reconciliation if not specified.
        :type as_at: datetime
        :param page: The pagination token to use to continue listing reconciliations; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results.              For example, to filter on the reconciliation type, specify \"id.Code eq '001'\". For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param property_keys: A list of property keys from the 'Reconciliation' domain to decorate onto each reconciliation.              These must take the format {domain}/{scope}/{code}, for example 'Reconciliation/Broker/Id'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfReconciliation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'effective_at',
            'as_at',
            'page',
            'limit',
            'filter',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_reconciliations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('effective_at') is not None:  # noqa: E501
            _query_params.append(('effectiveAt', _params['effective_at']))

        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfReconciliation",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$scheduledReconciliations', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def reconcile_generic(self, reconciliation_request : Annotated[Optional[ReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, **kwargs) -> ReconciliationResponse:  # noqa: E501
        ...

    @overload
    def reconcile_generic(self, reconciliation_request : Annotated[Optional[ReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, async_req: Optional[bool]=True, **kwargs) -> ReconciliationResponse:  # noqa: E501
        ...

    @validate_arguments
    def reconcile_generic(self, reconciliation_request : Annotated[Optional[ReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ReconciliationResponse, Awaitable[ReconciliationResponse]]:  # noqa: E501
        """ReconcileGeneric: Reconcile either holdings or valuations performed on one or two sets of holdings using one or two configuration recipes.                The output is configurable for various types of comparisons, to allow tolerances on numerical and date-time data or case-insensitivity on strings,  and elision of resulting differences where they are 'empty' or null or zero.  # noqa: E501

        Perform evaluation of one or two set of holdings (a portfolio of instruments) using one or two (potentially different) configuration recipes.  Produce a breakdown of the resulting differences in evaluation that can be iterated through.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_generic(reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param reconciliation_request: The specifications of the inputs to the reconciliation
        :type reconciliation_request: ReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ReconciliationResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the reconcile_generic_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.reconcile_generic_with_http_info(reconciliation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def reconcile_generic_with_http_info(self, reconciliation_request : Annotated[Optional[ReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ReconcileGeneric: Reconcile either holdings or valuations performed on one or two sets of holdings using one or two configuration recipes.                The output is configurable for various types of comparisons, to allow tolerances on numerical and date-time data or case-insensitivity on strings,  and elision of resulting differences where they are 'empty' or null or zero.  # noqa: E501

        Perform evaluation of one or two set of holdings (a portfolio of instruments) using one or two (potentially different) configuration recipes.  Produce a breakdown of the resulting differences in evaluation that can be iterated through.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_generic_with_http_info(reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param reconciliation_request: The specifications of the inputs to the reconciliation
        :type reconciliation_request: ReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ReconciliationResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'reconciliation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reconcile_generic" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['reconciliation_request'] is not None:
            _body_params = _params['reconciliation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ReconciliationResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$reconcileGeneric', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def reconcile_holdings(self, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set.              For example, to filter on the left portfolio Code, use \"left.portfolioId.code eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, portfolios_reconciliation_request : Annotated[Optional[PortfoliosReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, **kwargs) -> ResourceListOfReconciliationBreak:  # noqa: E501
        ...

    @overload
    def reconcile_holdings(self, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set.              For example, to filter on the left portfolio Code, use \"left.portfolioId.code eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, portfolios_reconciliation_request : Annotated[Optional[PortfoliosReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, async_req: Optional[bool]=True, **kwargs) -> ResourceListOfReconciliationBreak:  # noqa: E501
        ...

    @validate_arguments
    def reconcile_holdings(self, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set.              For example, to filter on the left portfolio Code, use \"left.portfolioId.code eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, portfolios_reconciliation_request : Annotated[Optional[PortfoliosReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfReconciliationBreak, Awaitable[ResourceListOfReconciliationBreak]]:  # noqa: E501
        """[EARLY ACCESS] ReconcileHoldings: Reconcile portfolio holdings  # noqa: E501

        Reconcile the holdings of two portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_holdings(sort_by, limit, filter, portfolios_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: List[str]
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set.              For example, to filter on the left portfolio Code, use \"left.portfolioId.code eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param portfolios_reconciliation_request: The specifications of the inputs to the reconciliation
        :type portfolios_reconciliation_request: PortfoliosReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfReconciliationBreak
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the reconcile_holdings_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.reconcile_holdings_with_http_info(sort_by, limit, filter, portfolios_reconciliation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def reconcile_holdings_with_http_info(self, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName")] = None, limit : Annotated[Optional[StrictInt], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set.              For example, to filter on the left portfolio Code, use \"left.portfolioId.code eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, portfolios_reconciliation_request : Annotated[Optional[PortfoliosReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ReconcileHoldings: Reconcile portfolio holdings  # noqa: E501

        Reconcile the holdings of two portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_holdings_with_http_info(sort_by, limit, filter, portfolios_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: List[str]
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set.              For example, to filter on the left portfolio Code, use \"left.portfolioId.code eq 'string'\"              Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param portfolios_reconciliation_request: The specifications of the inputs to the reconciliation
        :type portfolios_reconciliation_request: PortfoliosReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfReconciliationBreak, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'sort_by',
            'limit',
            'filter',
            'portfolios_reconciliation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reconcile_holdings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['portfolios_reconciliation_request'] is not None:
            _body_params = _params['portfolios_reconciliation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfReconciliationBreak",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$reconcileholdings', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def reconcile_inline(self, inline_valuations_reconciliation_request : Annotated[Optional[InlineValuationsReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, **kwargs) -> ListAggregationReconciliation:  # noqa: E501
        ...

    @overload
    def reconcile_inline(self, inline_valuations_reconciliation_request : Annotated[Optional[InlineValuationsReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, async_req: Optional[bool]=True, **kwargs) -> ListAggregationReconciliation:  # noqa: E501
        ...

    @validate_arguments
    def reconcile_inline(self, inline_valuations_reconciliation_request : Annotated[Optional[InlineValuationsReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ListAggregationReconciliation, Awaitable[ListAggregationReconciliation]]:  # noqa: E501
        """ReconcileInline: Reconcile valuations performed on one or two sets of inline instruments using one or two configuration recipes.  # noqa: E501

        Perform valuation of one or two set of inline instruments using different one or two configuration recipes. Produce a breakdown of the resulting differences in valuation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_inline(inline_valuations_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param inline_valuations_reconciliation_request: The specifications of the inputs to the reconciliation
        :type inline_valuations_reconciliation_request: InlineValuationsReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListAggregationReconciliation
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the reconcile_inline_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.reconcile_inline_with_http_info(inline_valuations_reconciliation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def reconcile_inline_with_http_info(self, inline_valuations_reconciliation_request : Annotated[Optional[InlineValuationsReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ReconcileInline: Reconcile valuations performed on one or two sets of inline instruments using one or two configuration recipes.  # noqa: E501

        Perform valuation of one or two set of inline instruments using different one or two configuration recipes. Produce a breakdown of the resulting differences in valuation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_inline_with_http_info(inline_valuations_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param inline_valuations_reconciliation_request: The specifications of the inputs to the reconciliation
        :type inline_valuations_reconciliation_request: InlineValuationsReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListAggregationReconciliation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'inline_valuations_reconciliation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reconcile_inline" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['inline_valuations_reconciliation_request'] is not None:
            _body_params = _params['inline_valuations_reconciliation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ListAggregationReconciliation",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$reconcileInline', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def reconcile_transactions(self, transaction_reconciliation_request : Optional[TransactionReconciliationRequest] = None, **kwargs) -> TransactionsReconciliationsResponse:  # noqa: E501
        ...

    @overload
    def reconcile_transactions(self, transaction_reconciliation_request : Optional[TransactionReconciliationRequest] = None, async_req: Optional[bool]=True, **kwargs) -> TransactionsReconciliationsResponse:  # noqa: E501
        ...

    @validate_arguments
    def reconcile_transactions(self, transaction_reconciliation_request : Optional[TransactionReconciliationRequest] = None, async_req: Optional[bool]=None, **kwargs) -> Union[TransactionsReconciliationsResponse, Awaitable[TransactionsReconciliationsResponse]]:  # noqa: E501
        """[EARLY ACCESS] ReconcileTransactions: Perform a Transactions Reconciliation.  # noqa: E501

        Evaluates two sets of transactions to determine which transactions from each set likely match  using the rules of a specified mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_transactions(transaction_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param transaction_reconciliation_request:
        :type transaction_reconciliation_request: TransactionReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionsReconciliationsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the reconcile_transactions_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.reconcile_transactions_with_http_info(transaction_reconciliation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def reconcile_transactions_with_http_info(self, transaction_reconciliation_request : Optional[TransactionReconciliationRequest] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ReconcileTransactions: Perform a Transactions Reconciliation.  # noqa: E501

        Evaluates two sets of transactions to determine which transactions from each set likely match  using the rules of a specified mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_transactions_with_http_info(transaction_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param transaction_reconciliation_request:
        :type transaction_reconciliation_request: TransactionReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionsReconciliationsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'transaction_reconciliation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reconcile_transactions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_reconciliation_request'] is not None:
            _body_params = _params['transaction_reconciliation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "TransactionsReconciliationsResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$reconcileTransactions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def reconcile_transactions_v2(self, transaction_reconciliation_request_v2 : Optional[TransactionReconciliationRequestV2] = None, **kwargs) -> ReconciliationResponse:  # noqa: E501
        ...

    @overload
    def reconcile_transactions_v2(self, transaction_reconciliation_request_v2 : Optional[TransactionReconciliationRequestV2] = None, async_req: Optional[bool]=True, **kwargs) -> ReconciliationResponse:  # noqa: E501
        ...

    @validate_arguments
    def reconcile_transactions_v2(self, transaction_reconciliation_request_v2 : Optional[TransactionReconciliationRequestV2] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ReconciliationResponse, Awaitable[ReconciliationResponse]]:  # noqa: E501
        """[EXPERIMENTAL] ReconcileTransactionsV2: Perform a Transactions Reconciliation.  # noqa: E501

        Evaluates two sets of transactions to determine which transactions from each set likely match  using the rules of a specified mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_transactions_v2(transaction_reconciliation_request_v2, async_req=True)
        >>> result = thread.get()

        :param transaction_reconciliation_request_v2:
        :type transaction_reconciliation_request_v2: TransactionReconciliationRequestV2
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ReconciliationResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the reconcile_transactions_v2_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.reconcile_transactions_v2_with_http_info(transaction_reconciliation_request_v2, **kwargs)  # noqa: E501

    @validate_arguments
    def reconcile_transactions_v2_with_http_info(self, transaction_reconciliation_request_v2 : Optional[TransactionReconciliationRequestV2] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ReconcileTransactionsV2: Perform a Transactions Reconciliation.  # noqa: E501

        Evaluates two sets of transactions to determine which transactions from each set likely match  using the rules of a specified mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_transactions_v2_with_http_info(transaction_reconciliation_request_v2, async_req=True)
        >>> result = thread.get()

        :param transaction_reconciliation_request_v2:
        :type transaction_reconciliation_request_v2: TransactionReconciliationRequestV2
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ReconciliationResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'transaction_reconciliation_request_v2'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reconcile_transactions_v2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['transaction_reconciliation_request_v2'] is not None:
            _body_params = _params['transaction_reconciliation_request_v2']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ReconciliationResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$reconcileTransactionsV2', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def reconcile_valuation(self, valuations_reconciliation_request : Annotated[Optional[ValuationsReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, **kwargs) -> ListAggregationReconciliation:  # noqa: E501
        ...

    @overload
    def reconcile_valuation(self, valuations_reconciliation_request : Annotated[Optional[ValuationsReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, async_req: Optional[bool]=True, **kwargs) -> ListAggregationReconciliation:  # noqa: E501
        ...

    @validate_arguments
    def reconcile_valuation(self, valuations_reconciliation_request : Annotated[Optional[ValuationsReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ListAggregationReconciliation, Awaitable[ListAggregationReconciliation]]:  # noqa: E501
        """ReconcileValuation: Reconcile valuations performed on one or two sets of holdings using one or two configuration recipes.  # noqa: E501

        Perform valuation of one or two set of holdings using different one or two configuration recipes. Produce a breakdown of the resulting differences in valuation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_valuation(valuations_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param valuations_reconciliation_request: The specifications of the inputs to the reconciliation
        :type valuations_reconciliation_request: ValuationsReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListAggregationReconciliation
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the reconcile_valuation_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.reconcile_valuation_with_http_info(valuations_reconciliation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def reconcile_valuation_with_http_info(self, valuations_reconciliation_request : Annotated[Optional[ValuationsReconciliationRequest], Field(description="The specifications of the inputs to the reconciliation")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """ReconcileValuation: Reconcile valuations performed on one or two sets of holdings using one or two configuration recipes.  # noqa: E501

        Perform valuation of one or two set of holdings using different one or two configuration recipes. Produce a breakdown of the resulting differences in valuation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reconcile_valuation_with_http_info(valuations_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param valuations_reconciliation_request: The specifications of the inputs to the reconciliation
        :type valuations_reconciliation_request: ValuationsReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListAggregationReconciliation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'valuations_reconciliation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reconcile_valuation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['valuations_reconciliation_request'] is not None:
            _body_params = _params['valuations_reconciliation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ListAggregationReconciliation",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$reconcileValuation', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reconciliation to be updated")], code : Annotated[StrictStr, Field(..., description="The code of the reconciliation to be updated")], update_reconciliation_request : Annotated[Optional[UpdateReconciliationRequest], Field(description="The updated definition of the reconciliation")] = None, **kwargs) -> Reconciliation:  # noqa: E501
        ...

    @overload
    def update_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reconciliation to be updated")], code : Annotated[StrictStr, Field(..., description="The code of the reconciliation to be updated")], update_reconciliation_request : Annotated[Optional[UpdateReconciliationRequest], Field(description="The updated definition of the reconciliation")] = None, async_req: Optional[bool]=True, **kwargs) -> Reconciliation:  # noqa: E501
        ...

    @validate_arguments
    def update_reconciliation(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reconciliation to be updated")], code : Annotated[StrictStr, Field(..., description="The code of the reconciliation to be updated")], update_reconciliation_request : Annotated[Optional[UpdateReconciliationRequest], Field(description="The updated definition of the reconciliation")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Reconciliation, Awaitable[Reconciliation]]:  # noqa: E501
        """[EXPERIMENTAL] UpdateReconciliation: Update scheduled reconciliation  # noqa: E501

        Update a given scheduled reconciliation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_reconciliation(scope, code, update_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reconciliation to be updated (required)
        :type scope: str
        :param code: The code of the reconciliation to be updated (required)
        :type code: str
        :param update_reconciliation_request: The updated definition of the reconciliation
        :type update_reconciliation_request: UpdateReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Reconciliation
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_reconciliation_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_reconciliation_with_http_info(scope, code, update_reconciliation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_reconciliation_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the reconciliation to be updated")], code : Annotated[StrictStr, Field(..., description="The code of the reconciliation to be updated")], update_reconciliation_request : Annotated[Optional[UpdateReconciliationRequest], Field(description="The updated definition of the reconciliation")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] UpdateReconciliation: Update scheduled reconciliation  # noqa: E501

        Update a given scheduled reconciliation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_reconciliation_with_http_info(scope, code, update_reconciliation_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the reconciliation to be updated (required)
        :type scope: str
        :param code: The code of the reconciliation to be updated (required)
        :type code: str
        :param update_reconciliation_request: The updated definition of the reconciliation
        :type update_reconciliation_request: UpdateReconciliationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Reconciliation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_reconciliation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_reconciliation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_reconciliation_request'] is not None:
            _body_params = _params['update_reconciliation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Reconciliation",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/$scheduledReconciliations/{scope}/{code}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_reconciliation_mapping(self, mapping : Annotated[Optional[Mapping], Field(description="The mapping to be created / updated.")] = None, **kwargs) -> Mapping:  # noqa: E501
        ...

    @overload
    def upsert_reconciliation_mapping(self, mapping : Annotated[Optional[Mapping], Field(description="The mapping to be created / updated.")] = None, async_req: Optional[bool]=True, **kwargs) -> Mapping:  # noqa: E501
        ...

    @validate_arguments
    def upsert_reconciliation_mapping(self, mapping : Annotated[Optional[Mapping], Field(description="The mapping to be created / updated.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[Mapping, Awaitable[Mapping]]:  # noqa: E501
        """[EARLY ACCESS] UpsertReconciliationMapping: Create or update a mapping  # noqa: E501

        If no mapping exists with the specified scope and code will create a new one.  Else will update the existing mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_reconciliation_mapping(mapping, async_req=True)
        >>> result = thread.get()

        :param mapping: The mapping to be created / updated.
        :type mapping: Mapping
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Mapping
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_reconciliation_mapping_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_reconciliation_mapping_with_http_info(mapping, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_reconciliation_mapping_with_http_info(self, mapping : Annotated[Optional[Mapping], Field(description="The mapping to be created / updated.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertReconciliationMapping: Create or update a mapping  # noqa: E501

        If no mapping exists with the specified scope and code will create a new one.  Else will update the existing mapping  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_reconciliation_mapping_with_http_info(mapping, async_req=True)
        >>> result = thread.get()

        :param mapping: The mapping to be created / updated.
        :type mapping: Mapping
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Mapping, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'mapping'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_reconciliation_mapping" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['mapping'] is not None:
            _body_params = _params['mapping']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Mapping",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/portfolios/mapping', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
