# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field 
from lusid.models.a2_b_breakdown import A2BBreakdown

class A2BCategory(BaseModel):
    """
    A2B Category - one of the five major categories in the A2BDataRecord  # noqa: E501
    """
    holding_currency: Optional[A2BBreakdown] = Field(None, alias="holdingCurrency")
    portfolio_currency: Optional[A2BBreakdown] = Field(None, alias="portfolioCurrency")
    __properties = ["holdingCurrency", "portfolioCurrency"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> A2BCategory:
        """Create an instance of A2BCategory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of holding_currency
        if self.holding_currency:
            _dict['holdingCurrency'] = self.holding_currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of portfolio_currency
        if self.portfolio_currency:
            _dict['portfolioCurrency'] = self.portfolio_currency.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> A2BCategory:
        """Create an instance of A2BCategory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return A2BCategory.parse_obj(obj)

        _obj = A2BCategory.parse_obj({
            "holding_currency": A2BBreakdown.from_dict(obj.get("holdingCurrency")) if obj.get("holdingCurrency") is not None else None,
            "portfolio_currency": A2BBreakdown.from_dict(obj.get("portfolioCurrency")) if obj.get("portfolioCurrency") is not None else None
        })
        return _obj
