# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, constr, validator 

class CheckDefinitionRule(BaseModel):
    """
    CheckDefinitionRule
    """
    rule_key:  Optional[StrictStr] = Field(None,alias="ruleKey", description="The key of the Rule.") 
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="The name of the Rule.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A description for the Rule.") 
    rule_formula:  Optional[StrictStr] = Field(None,alias="ruleFormula", description="The formula for the rule.") 
    severity: Optional[StrictInt] = Field(None, description="Severity of the rule if formaula is not satisfied.")
    __properties = ["ruleKey", "displayName", "description", "ruleFormula", "severity"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CheckDefinitionRule:
        """Create an instance of CheckDefinitionRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if rule_key (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_key is None and "rule_key" in self.__fields_set__:
            _dict['ruleKey'] = None

        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if rule_formula (nullable) is None
        # and __fields_set__ contains the field
        if self.rule_formula is None and "rule_formula" in self.__fields_set__:
            _dict['ruleFormula'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CheckDefinitionRule:
        """Create an instance of CheckDefinitionRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CheckDefinitionRule.parse_obj(obj)

        _obj = CheckDefinitionRule.parse_obj({
            "rule_key": obj.get("ruleKey"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "rule_formula": obj.get("ruleFormula"),
            "severity": obj.get("severity")
        })
        return _obj
