# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 
from lusid.models.data_model_membership import DataModelMembership
from lusid.models.resource_id import ResourceId
from lusid.models.staged_modifications_info import StagedModificationsInfo
from lusid.models.version import Version

class MembershipAmendmentResponse(BaseModel):
    """
    MembershipAmendmentResponse
    """
    custom_data_model_id: ResourceId = Field(..., alias="customDataModelId")
    entity_type:  StrictStr = Field(...,alias="entityType", description="The type of the entity that was added or removed from the Custom Data Model.") 
    entity_unique_id:  StrictStr = Field(...,alias="entityUniqueId", description="The entity unique identifier of the entity that was added or removed from the Custom Data Model.") 
    operation:  StrictStr = Field(...,alias="operation", description="The operation that was performed on the entity's membership in the Custom Data Model. Either 'Add' or 'Remove'.") 
    entity_display_name:  StrictStr = Field(...,alias="entityDisplayName", description="The display name of the entity that was added or removed from the Custom Data Model.") 
    data_model_membership: Optional[DataModelMembership] = Field(None, alias="dataModelMembership")
    version: Optional[Version] = None
    staged_modifications: Optional[StagedModificationsInfo] = Field(None, alias="stagedModifications")
    __properties = ["customDataModelId", "entityType", "entityUniqueId", "operation", "entityDisplayName", "dataModelMembership", "version", "stagedModifications"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MembershipAmendmentResponse:
        """Create an instance of MembershipAmendmentResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of custom_data_model_id
        if self.custom_data_model_id:
            _dict['customDataModelId'] = self.custom_data_model_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_model_membership
        if self.data_model_membership:
            _dict['dataModelMembership'] = self.data_model_membership.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of staged_modifications
        if self.staged_modifications:
            _dict['stagedModifications'] = self.staged_modifications.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MembershipAmendmentResponse:
        """Create an instance of MembershipAmendmentResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MembershipAmendmentResponse.parse_obj(obj)

        _obj = MembershipAmendmentResponse.parse_obj({
            "custom_data_model_id": ResourceId.from_dict(obj.get("customDataModelId")) if obj.get("customDataModelId") is not None else None,
            "entity_type": obj.get("entityType"),
            "entity_unique_id": obj.get("entityUniqueId"),
            "operation": obj.get("operation"),
            "entity_display_name": obj.get("entityDisplayName"),
            "data_model_membership": DataModelMembership.from_dict(obj.get("dataModelMembership")) if obj.get("dataModelMembership") is not None else None,
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "staged_modifications": StagedModificationsInfo.from_dict(obj.get("stagedModifications")) if obj.get("stagedModifications") is not None else None
        })
        return _obj
