# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conlist, constr, validator 
from lusid.models.resource_id import ResourceId

class NavTypeDefinition(BaseModel):
    """
    NavTypeDefinition
    """
    code:  Optional[StrictStr] = Field(None,alias="code") 
    display_name:  Optional[StrictStr] = Field(None,alias="displayName") 
    description:  Optional[StrictStr] = Field(None,alias="description") 
    chart_of_accounts_id: ResourceId = Field(..., alias="chartOfAccountsId")
    posting_module_codes: Optional[conlist(StrictStr)] = Field(None, alias="postingModuleCodes")
    cleardown_module_codes: Optional[conlist(StrictStr)] = Field(None, alias="cleardownModuleCodes")
    valuation_recipe_id: ResourceId = Field(..., alias="valuationRecipeId")
    holding_recipe_id: ResourceId = Field(..., alias="holdingRecipeId")
    accounting_method:  StrictStr = Field(...,alias="accountingMethod") 
    sub_holding_keys: Optional[conlist(StrictStr)] = Field(None, alias="subHoldingKeys", description="Set of unique holding identifiers, e.g. trader, desk, strategy.")
    amortisation_method:  StrictStr = Field(...,alias="amortisationMethod") 
    transaction_type_scope:  StrictStr = Field(...,alias="transactionTypeScope") 
    cash_gain_loss_calculation_date:  StrictStr = Field(...,alias="cashGainLossCalculationDate") 
    __properties = ["code", "displayName", "description", "chartOfAccountsId", "postingModuleCodes", "cleardownModuleCodes", "valuationRecipeId", "holdingRecipeId", "accountingMethod", "subHoldingKeys", "amortisationMethod", "transactionTypeScope", "cashGainLossCalculationDate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NavTypeDefinition:
        """Create an instance of NavTypeDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of chart_of_accounts_id
        if self.chart_of_accounts_id:
            _dict['chartOfAccountsId'] = self.chart_of_accounts_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of valuation_recipe_id
        if self.valuation_recipe_id:
            _dict['valuationRecipeId'] = self.valuation_recipe_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of holding_recipe_id
        if self.holding_recipe_id:
            _dict['holdingRecipeId'] = self.holding_recipe_id.to_dict()
        # set to None if code (nullable) is None
        # and __fields_set__ contains the field
        if self.code is None and "code" in self.__fields_set__:
            _dict['code'] = None

        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if posting_module_codes (nullable) is None
        # and __fields_set__ contains the field
        if self.posting_module_codes is None and "posting_module_codes" in self.__fields_set__:
            _dict['postingModuleCodes'] = None

        # set to None if cleardown_module_codes (nullable) is None
        # and __fields_set__ contains the field
        if self.cleardown_module_codes is None and "cleardown_module_codes" in self.__fields_set__:
            _dict['cleardownModuleCodes'] = None

        # set to None if sub_holding_keys (nullable) is None
        # and __fields_set__ contains the field
        if self.sub_holding_keys is None and "sub_holding_keys" in self.__fields_set__:
            _dict['subHoldingKeys'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NavTypeDefinition:
        """Create an instance of NavTypeDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return NavTypeDefinition.parse_obj(obj)

        _obj = NavTypeDefinition.parse_obj({
            "code": obj.get("code"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "chart_of_accounts_id": ResourceId.from_dict(obj.get("chartOfAccountsId")) if obj.get("chartOfAccountsId") is not None else None,
            "posting_module_codes": obj.get("postingModuleCodes"),
            "cleardown_module_codes": obj.get("cleardownModuleCodes"),
            "valuation_recipe_id": ResourceId.from_dict(obj.get("valuationRecipeId")) if obj.get("valuationRecipeId") is not None else None,
            "holding_recipe_id": ResourceId.from_dict(obj.get("holdingRecipeId")) if obj.get("holdingRecipeId") is not None else None,
            "accounting_method": obj.get("accountingMethod"),
            "sub_holding_keys": obj.get("subHoldingKeys"),
            "amortisation_method": obj.get("amortisationMethod"),
            "transaction_type_scope": obj.get("transactionTypeScope"),
            "cash_gain_loss_calculation_date": obj.get("cashGainLossCalculationDate")
        })
        return _obj
