# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist 
from lusid.models.reconciliation_line import ReconciliationLine
from lusid.models.result_data_schema import ResultDataSchema

class ReconciliationResponse(BaseModel):
    """
    Class representing the set of comparisons that result from comparing holdings and their valuations between two separate evaluations.  # noqa: E501
    """
    comparisons: Optional[conlist(ReconciliationLine)] = Field(None, description="List of comparisons of left to right hand sides.")
    data_schema: Optional[ResultDataSchema] = Field(None, alias="dataSchema")
    __properties = ["comparisons", "dataSchema"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReconciliationResponse:
        """Create an instance of ReconciliationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in comparisons (list)
        _items = []
        if self.comparisons:
            for _item in self.comparisons:
                if _item:
                    _items.append(_item.to_dict())
            _dict['comparisons'] = _items
        # override the default output from pydantic by calling `to_dict()` of data_schema
        if self.data_schema:
            _dict['dataSchema'] = self.data_schema.to_dict()
        # set to None if comparisons (nullable) is None
        # and __fields_set__ contains the field
        if self.comparisons is None and "comparisons" in self.__fields_set__:
            _dict['comparisons'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReconciliationResponse:
        """Create an instance of ReconciliationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReconciliationResponse.parse_obj(obj)

        _obj = ReconciliationResponse.parse_obj({
            "comparisons": [ReconciliationLine.from_dict(_item) for _item in obj.get("comparisons")] if obj.get("comparisons") is not None else None,
            "data_schema": ResultDataSchema.from_dict(obj.get("dataSchema")) if obj.get("dataSchema") is not None else None
        })
        return _obj
