# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist, constr, validator 
from lusid.models.link import Link
from lusid.models.resource_id import ResourceId
from lusid.models.version import Version

class RelationshipDefinition(BaseModel):
    """
    RelationshipDefinition
    """
    version: Optional[Version] = None
    relationship_definition_id: ResourceId = Field(..., alias="relationshipDefinitionId")
    source_entity_type:  StrictStr = Field(...,alias="sourceEntityType", description="The entity type of the source entity object.") 
    target_entity_type:  StrictStr = Field(...,alias="targetEntityType", description="The entity type of the target entity object.") 
    display_name:  StrictStr = Field(...,alias="displayName", description="The display name of the relationship.") 
    outward_description:  StrictStr = Field(...,alias="outwardDescription", description="The description to relate source entity object and target entity object") 
    inward_description:  StrictStr = Field(...,alias="inwardDescription", description="The description to relate target entity object and source entity object") 
    life_time:  StrictStr = Field(...,alias="lifeTime", description="Describes how the relationships can change over time.") 
    relationship_cardinality:  StrictStr = Field(...,alias="relationshipCardinality", description="Describes the cardinality of the relationship between source entity and target entity.") 
    links: Optional[conlist(Link)] = None
    __properties = ["version", "relationshipDefinitionId", "sourceEntityType", "targetEntityType", "displayName", "outwardDescription", "inwardDescription", "lifeTime", "relationshipCardinality", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RelationshipDefinition:
        """Create an instance of RelationshipDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relationship_definition_id
        if self.relationship_definition_id:
            _dict['relationshipDefinitionId'] = self.relationship_definition_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RelationshipDefinition:
        """Create an instance of RelationshipDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RelationshipDefinition.parse_obj(obj)

        _obj = RelationshipDefinition.parse_obj({
            "version": Version.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "relationship_definition_id": ResourceId.from_dict(obj.get("relationshipDefinitionId")) if obj.get("relationshipDefinitionId") is not None else None,
            "source_entity_type": obj.get("sourceEntityType"),
            "target_entity_type": obj.get("targetEntityType"),
            "display_name": obj.get("displayName"),
            "outward_description": obj.get("outwardDescription"),
            "inward_description": obj.get("inwardDescription"),
            "life_time": obj.get("lifeTime"),
            "relationship_cardinality": obj.get("relationshipCardinality"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
