import * as ec2 from '@aws-cdk/aws-ec2';
import * as efs from '@aws-cdk/aws-efs';
import * as cdk from '@aws-cdk/core';
/**
 *
 */
export interface GithubSourceFeederProps {
    /**
     * The target Amazon EFS filesystem to clone the github repository to.
     */
    readonly efsAccessPoint: efs.AccessPoint;
    /**
     * The VPC of the Amazon EFS Filesystem.
     */
    readonly vpc: ec2.IVpc;
    /**
     * The github repository HTTP URI.
     */
    readonly repository: string;
    /**
     * The dependent resources before triggering the sync.
     */
    readonly runsAfter?: cdk.IDependable[];
}
/**
 *
 */
export declare class GithubSourceSync extends cdk.Construct {
    /**
     *
     */
    constructor(scope: cdk.Construct, id: string, props: GithubSourceFeederProps);
}
