"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubSourceSync = void 0;
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 *
 */
class GithubSourceSync extends cdk.Construct {
    /**
     *
     */
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        const region = stack.region;
        const handler = new lambda.Function(this, 'Handler', {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../lambda-handler')),
            handler: 'index.on_event',
            layers: [
                lambda.LayerVersion.fromLayerVersionArn(this, 'GitLayer', `arn:aws:lambda:${region}:553035198032:layer:git-lambda2:7`),
            ],
            filesystem: lambda.FileSystem.fromEfsAccessPoint(props.efsAccessPoint, '/mnt/efsmount'),
            vpcSubnets: {
                subnetType: ec2.SubnetType.PRIVATE,
            },
            vpc: props.vpc,
            memorySize: 512,
            timeout: cdk.Duration.minutes(1),
            environment: {
                REPOSITORY_URI: props.repository,
                MOUNT_TARGET: '/mnt/efsmount',
            },
            currentVersionOptions: {
                provisionedConcurrentExecutions: 1,
            },
        });
        // create a custom resource to trigger the sync
        const myProvider = new cr.Provider(this, 'MyProvider', {
            onEventHandler: handler,
        });
        new cdk.CustomResource(this, 'SyncTrigger', { serviceToken: myProvider.serviceToken });
        // ensure the dependency
        if (props.runsAfter) {
            handler.node.addDependency(...props.runsAfter);
            // triggerResource.node.addDependency(...props.runsAfter);
        }
        ;
        // handler.node.addDependency(props.efsAccessPoint);
        // triggerResource.node.addDependency(props.efsAccessPoint);
    }
}
exports.GithubSourceSync = GithubSourceSync;
//# sourceMappingURL=data:application/json;base64,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