"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const efs = require("@aws-cdk/aws-efs");
const core_1 = require("@aws-cdk/core");
const _1 = require("./");
const AWS_DEFAULT_REGION = 'us-east-1';
class IntegTesting {
    constructor() {
        var _a, _b;
        const app = new core_1.App();
        const env = {
            region: (_a = process.env.CDK_DEFAULT_REGION) !== null && _a !== void 0 ? _a : AWS_DEFAULT_REGION,
            account: (_b = process.env.CDK_DEFAULT_ACCOUNT) !== null && _b !== void 0 ? _b : '11111111111',
        };
        const stack = new core_1.Stack(app, 'testing-stack9', { env });
        const vpc = ec2.Vpc.fromLookup(stack, 'Vpc', { isDefault: true });
        const fs = new efs.FileSystem(stack, 'Filesystem', {
            vpc,
            removalPolicy: core_1.RemovalPolicy.DESTROY,
        });
        const efsAccessPoint = fs.addAccessPoint('EfsAccessPoint', {
            path: '/demo',
            createAcl: {
                ownerGid: '1001',
                ownerUid: '1001',
                permissions: '0755',
            },
            posixUser: {
                uid: '1001',
                gid: '1001',
            },
        });
        // create the one-time sync from Github repository to Amaozn EFS
        new _1.GithubSourceSync(stack, 'GithubSourceSync', {
            repository: 'https://github.com/pahud/cdk-efs-assets.git',
            efsAccessPoint,
            runsAfter: [fs.mountTargetsAvailable],
            vpc,
        });
        this.stack = [stack];
    }
    ;
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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