from django.conf.urls import patterns, url

from groups_manager import views


urlpatterns = patterns('',

    url(r'^$',
        views.GroupsManagerView.as_view(),
        name='groups_manager',),

    url(r'^member/$',
        views.MemberListView.as_view(),
        name='member_list',),
    url(r'^member/detail/(?P<pk>\d+)/$',
        views.MemberDetailView.as_view(),
        name='member_detail',),
    url(r'^member/edit/(?P<pk>\d+)/$',
        views.MemberEditView.as_view(),
        name='member_edit',),
    url(r'^member/add/$',
        views.MemberCreateView.as_view(),
        name='member_add',),
    url(r'^member/delete/(?P<pk>\d+)/$',
        views.MemberDeleteView.as_view(),
        name='member_delete',),

    url(r'^group-type/$',
        views.GroupTypeListView.as_view(),
        name='group_type_list',),
    url(r'^group-type/detail/(?P<pk>\d+)/$',
        views.GroupTypeDetailView.as_view(),
        name='group_type_detail',),
    url(r'^group-type/edit/(?P<pk>\d+)/$',
        views.GroupTypeEditView.as_view(),
        name='group_type_edit',),
    url(r'^group-type/add/$',
        views.GroupTypeCreateView.as_view(),
        name='group_type_add',),
    url(r'^group-type/delete/(?P<pk>\d+)/$',
        views.GroupTypeDeleteView.as_view(),
        name='group_type_delete',),

    url(r'^group-entity/$',
        views.GroupEntityListView.as_view(),
        name='group_entity_list',),
    url(r'^group-entity/detail/(?P<pk>\d+)/$',
        views.GroupEntityDetailView.as_view(),
        name='group_entity_detail',),
    url(r'^group-entity/edit/(?P<pk>\d+)/$',
        views.GroupEntityEditView.as_view(),
        name='group_entity_edit',),
    url(r'^group-entity/add/$',
        views.GroupEntityCreateView.as_view(),
        name='group_entity_add',),
    url(r'^group-entity/delete/(?P<pk>\d+)/$',
        views.GroupEntityDeleteView.as_view(),
        name='group_entity_delete',),

    url(r'^group/$',
        views.GroupListView.as_view(),
        name='group_list',),
    url(r'^group/detail/(?P<pk>\d+)/$',
        views.GroupDetailView.as_view(),
        name='group_detail',),
    url(r'^group/edit/(?P<pk>\d+)/$',
        views.GroupEditView.as_view(),
        name='group_edit',),
    url(r'^group/add/$',
        views.GroupCreateView.as_view(),
        name='group_add',),
    url(r'^group/delete/(?P<pk>\d+)/$',
        views.GroupDeleteView.as_view(),
        name='group_delete',),

    url(r'^group-member-role/$',
        views.GroupMemberRoleListView.as_view(),
        name='group_member_role_list',),
    url(r'^group-member-role/detail/(?P<pk>\d+)/$',
        views.GroupMemberRoleDetailView.as_view(),
        name='group_member_role_detail',),
    url(r'^group-member-role/edit/(?P<pk>\d+)/$',
        views.GroupMemberRoleEditView.as_view(),
        name='group_member_role_edit',),
    url(r'^group-member-role/add/$',
        views.GroupMemberRoleCreateView.as_view(),
        name='group_member_role_add',),
    url(r'^group-member-role/delete/(?P<pk>\d+)/$',
        views.GroupMemberRoleDeleteView.as_view(),
        name='group_member_role_delete',),

    url(r'^group-member/edit/(?P<pk>\d+)/$',
        views.GroupMemberEditView.as_view(),
        name='group_member_edit',),
    url(r'^group-member/delete/(?P<pk>\d+)/$',
        views.GroupMemberDeleteView.as_view(),
        name='group_member_delete',),
    url(r'^group-member/add-member/(?P<group_id>\d+)/$',
        views.GroupMemberAddMemberView.as_view(),
        name='group_member_add_member',),
    url(r'^group-member/add-group/(?P<member_id>\d+)/$',
        views.GroupMemberAddGroupView.as_view(),
        name='group_member_add_group',),

)
