#
# Copyright (c) 2018 Leland Stanford Junior University
# Copyright (c) 2018 The Regents of the University of California
#
# This file is part of pelicun.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# 3. Neither the name of the copyright holder nor the names of its contributors
# may be used to endorse or promote products derived from this software without
# specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# You should have received a copy of the BSD 3-Clause License along with
# pelicun. If not, see <http://www.opensource.org/licenses/>.

from __future__ import annotations

from typing import Generator
from unittest.mock import patch

import pytest

# This is an explicit list of tests that handle their own network mocking
# and should be excluded from the global fixture.
EXCLUDED_TESTS = {
    'test_check_dlml_data_with_missing_data',
    'test_check_dlml_data_with_existing_data_update_available',
    'test_check_dlml_data_download_failure',
    'test_check_dlml_data_permission_error',
    'test_check_dlml_data_version_check_failure',
    'test_logging_configuration',
    'test_warning_system_integration',
}


@pytest.fixture(autouse=True)
def mock_dlml_data_check(
    request: pytest.FixtureRequest,
) -> Generator[None, None, None]:
    """
    Mocks the DLML data check for the entire test session, UNLESS
    the test is in the specific exclusion list.

    This provides a high-performance, fail-safe "no network" policy
    while allowing specific integration tests to run their own logic.
    """
    # If the current test's name is in our exclusion list, do not
    # apply the global mock.
    if request.node.name in EXCLUDED_TESTS:
        yield
    else:
        # For all other tests, apply the global mock.
        target_function_path = 'pelicun.tools.dlml.check_dlml_data'
        with patch(target_function_path) as mocked_check_func:
            mocked_check_func.return_value = None
            yield
