def 查询_表记录总数(游标对象, 表名):
    """
    查询指定表的记录数量。

    参数：
        - 游标对象: 数据库游标对象。
        - 表名: 要查询记录数量的表名。

    返回值：
        - 返回指定表的记录数量，如果查询失败返回 None。

    使用示例（可以复制并直接修改）：
        记录数 = zfx_mysql.查询_表记录总数(游标对象, "users")

        # 替换参数：
        # - 游标对象：已建立的数据库游标对象
        # - 表名：需要查询记录数量的表名称，如 "users" 或 "orders"

        # 使用返回的记录数：
        # if 记录数 is not None:
        #     print(f"表中共有 {记录数} 条记录")
        # else:
        #     print("查询失败")
    """
    try:
        # 构建查询语句
        查询语句 = f"SELECT COUNT(*) FROM {表名}"

        # 执行查询操作
        游标对象.execute(查询语句)

        # 获取记录数量
        记录数 = 游标对象.fetchone()[0]

        return 记录数
    except Exception:
        return None