def 关闭浏览器(结果: dict, 彻底退出: bool = True, 安静: bool = True):
    """
    功能：
        一键关闭由“初始化_普通模式”或“初始化_禁用图片”等初始化函数返回的浏览器对象。
        本函数定位为“快速收尾/终止进程”：
          - 优先尝试关闭“浏览器”（其内部会连带关闭所有上下文与页面）；
          - 可选是否“彻底退出”引擎（默认 True），用于释放底层资源、结束后台进程；
          - 无论任一环节是否出错，都会继续执行后续关闭动作，尽量保证最终收尾。

    适用场景：
        - 脚本任务结束，需要快速清理所有页面/上下文/浏览器与底层资源；
        - 出现异常需要尽快退出，避免遗留后台进程；
        - 批量任务中，循环每轮结束后一键收尾。

    参数：
        - 结果：字典。应当是初始化函数的原样返回，例如：
            {
                "引擎":   引擎对象,
                "浏览器": 浏览器对象,
                "上下文": 上下文对象,   # 可无视；关闭“浏览器”时会一并收尾
                "页面":   页面对象      # 可无视；关闭“浏览器”时会一并收尾
            }
          说明：本函数不会依赖“页面/上下文”的逐级关闭，直接以“浏览器”为核心收尾。
        - 彻底退出：布尔。是否在关闭浏览器后，同时“停止引擎”（默认 True）。
          建议：常规脚本/批处理保持 True；若你在同一进程内还要继续创建新浏览器，可设为 False。
        - 安静：布尔。是否“静默处理”关闭中的异常（默认 True）。
          - True  → 只在必要时打印简短提示，不抛出异常，返回 True/False 作为结果；
          - False → 打印更详细的错误信息，便于排查。

    返回值：
        - True  ：至少成功执行了关键关闭步骤（浏览器或引擎其一成功关闭，且无致命异常）
        - False ：传入参数不合法，或关键步骤全部失败（会打印失败原因）

    关闭策略（设计理念）：
        1) “以浏览器为中心”：关闭浏览器会自动结束其下所有上下文与页面，避免逐级关闭的繁琐与脆弱；
        2) “尽力而为，继续前进”：即使关闭浏览器报错，也会继续尝试停止引擎，避免残留后台进程；
        3) “可配置的彻底程度”：通过“彻底退出”参数，兼顾一次性脚本与长进程内反复开启浏览器的场景；
        4) “静默/详尽可选”：通过“安静”参数，平衡生产环境的干净日志与调试时的信息量。

    使用示例：
        # 例1：普通使用（推荐）
        结果 = 初始化_普通模式()
        if 结果:
            页 = 结果["页面"]
            # ... 执行你的页面操作 ...
            关闭浏览器(结果)  # 默认彻底退出，干净利落

        # 例2：同一进程内还要继续开新浏览器（不退出引擎）
        结果 = 初始化_禁用图片(启动参数=["--headless"])
        if 结果:
            # ... 执行任务 ...
            关闭浏览器(结果, 彻底退出=False)  # 仅关浏览器，不 stop 引擎

        # 例3：调试时需要看到详细报错
        关闭浏览器(结果, 彻底退出=True, 安静=False)

    常见问答：
        Q1：为什么不逐级关闭“页面→上下文→浏览器→引擎”？
            A：逐级关闭更冗长且在异常情况下更脆弱。关闭“浏览器”即可连带回收其下对象，更简单、更稳。
        Q2：一定要“彻底退出”吗？
            A：一次性脚本/任务建议 True；若你在同一个 Python 进程里“反复”创建浏览器实例，偶尔可以 False。
        Q3：万一关闭浏览器时报错，会影响退出引擎吗？
            A：不会。函数会继续尝试停止引擎，尽量确保最终清理干净。

    返回 True/False 判定说明（便于外部流程控制）：
        - 返回 True：说明关键资源已被关闭（浏览器或引擎至少一个成功），一般可继续后续逻辑或安全退出；
        - 返回 False：通常是“结果”参数无效或两步都失败，建议打印日志并谨慎处理（例如进程级兜底退出）。

    注意：
        - 本函数只做“收尾清理”，不做任何等待/超时策略调整；
        - 若你的初始化返回字典使用了不同的键名，请保持与模块约定一致（引擎/浏览器/上下文/页面）。
    """
    try:
        if not isinstance(结果, dict):
            if not 安静:
                print("关闭失败：传入参数不是字典；请传入初始化函数的原样返回。")
            return False

        已关闭_浏览器 = False
        已停止_引擎 = False

        # 1) 关闭浏览器（快速、粗暴、可靠）
        try:
            浏览器 = 结果.get("浏览器")
            if 浏览器:
                浏览器.close()
                已关闭_浏览器 = True
            else:
                if not 安静:
                    print("提示：结果中未发现“浏览器”对象，跳过浏览器关闭。")
        except Exception as e:
            if not 安静:
                print(f"关闭浏览器时发生异常：{e}（将继续尝试停止引擎）")

        # 2) 按需停止引擎（彻底退出 Playwright 相关后台资源）
        if 彻底退出:
            try:
                引擎 = 结果.get("引擎")
                if 引擎:
                    引擎.stop()
                    已停止_引擎 = True
                else:
                    if not 安静:
                        print("提示：结果中未发现“引擎”对象，跳过引擎停止。")
            except Exception as e:
                if not 安静:
                    print(f"停止引擎时发生异常：{e}")

        # 成功判定：关键动作至少成功其一
        if 已关闭_浏览器 or 已停止_引擎:
            if not 安静:
                print("浏览器资源已清理完毕。")
            return True
        else:
            if not 安静:
                print("关闭失败：未能成功关闭浏览器或停止引擎。")
            return False

    except Exception as e:
        if not 安静:
            print(f"关闭流程出现未预期异常：{e}")
        return False
