def 取行数(文件路径):
    """
    计算指定文本文件的行数。文件编码格式必须为 UTF-8，否则可能导致读取错误。

    参数:
        - 文件路径 (str): 要计算行数的文本文件路径，要求为 UTF-8 编码格式。

    返回值:
        - int: 文本文件中的行数。失败时返回 -1。

    示例:
        行数 = 取行数('示例.txt')
        if 行数 != -1:
            print(f"文件行数: {行数}")
        else:
            print("获取文件行数失败")

    注意:
        - 此函数假设文本文件为 UTF-8 编码。如果文件是其他编码格式，可能会导致读取失败。
    """
    try:
        # 以读取模式打开文件，使用 UTF-8 编码
        with open(文件路径, 'r', encoding='utf-8') as file:
            行数 = sum(1 for _ in file)  # 通过逐行迭代计算行数
        return 行数
    except Exception:
        return -1