def 取首行无标记文本(文件路径: str, 标记内容: str):
    r"""
    功能：
        从账号记录文本中读取第一行未包含指定标记内容的账号信息，并返回其所在行号。

    用途场景：
        适用于处理账号信息批处理任务，例如下列文本结构：
            - 用户名----密码----令牌
            - 用户名----密码----令牌----已完成
            - 用户名----密码----令牌----备注----已完成

        系统将跳过所有包含“标记内容”的行，仅返回第一条未包含标记的账号记录及其行号。

    参数：
        - 文件路径: 账号记录文本文件的路径。
        - 标记内容: 表示某行已处理的标记字符串（如“已完成”、“Done”）。

    返回值：
        - 成功时：返回一个元组 (行号, 行内容)，行号从 1 开始计。
        - 所有账号均已标记：返回 None。
        - 打开或读取文件失败：返回 False。

    注意事项：
        1. 文件需为 UTF-8 编码格式。
        2. 判断依据是“行内包含标记内容”而非是否结尾。
        3. 返回的行号便于用户在后续操作中修改原文件、标记状态或输出日志等。

    使用示例：
        假设“accounts.txt”文件内容如下：
            - user1----pass1----token1----已完成----测试
            - user2----pass2----token2
            - user3----pass3----token3

        示例代码：
            文件路径 = "accounts.txt"
            标记内容 = "已完成"
            结果 = 取首行无标记文本(文件路径, 标记内容)

            if isinstance(结果, tuple):
                行号, 内容 = 结果
                print(f"第 {行号} 行账号信息：{内容}")
            elif 结果 is None:
                print("所有账号均已标记")
            else:
                print("读取失败")
    """
    try:
        with open(文件路径, 'r', encoding='utf-8') as 文件对象:
            for 索引, 行内容 in enumerate(文件对象, start=1):
                当前行 = 行内容.rstrip('\n').rstrip('\r')
                if 标记内容 not in 当前行:
                    return 索引, 当前行
        return None
    except Exception:
        return False
