def 响应对象_取右边(响应对象, 目标文本):
    """
    功能：
        从服务器响应对象的文本中，查找第一次出现的目标文本，
        并返回其右边的所有内容。如果未找到目标文本，则返回空字符串。

    参数：
        - 响应对象：
            requests.Response 类型对象，通常是 requests.get/post 的返回值。
            若传入 None，则直接返回空字符串。
        - 目标文本 (str)：
            用于定位的字符串标记。函数会截取该标记之后的所有文本。

    返回：
        - str：
            截取到的右边部分文本。
        - str（空字符串）：
            当 响应对象 为 None、未找到目标文本、或出现异常时，返回 ""。

    异常处理逻辑：
        - 如果 响应对象 为 None，立即返回空字符串。
        - 如果找不到目标文本，返回空字符串。
        - 如果读取 .text 或截取时出错，返回空字符串。

    示例：
        >>> import requests
        >>> r = requests.get("https://httpbin.org/html")
        >>> 内容 = 响应对象_取右边(r, "<h1>")
        >>> print(内容[:40])
        "Herman Melville - Moby-Dick</h1>..."

    注意事项：
        - 本函数只处理 **第一次出现的目标文本**。
        - 返回的内容不包含目标文本本身。
        - 若需要处理多次出现的目标文本，需要额外循环或正则。
    """
    try:
        if 响应对象 is None:
            return ''
        文本内容 = 响应对象.text
        目标位置 = 文本内容.find(目标文本)
        if 目标位置 == -1:
            return ''
        return 文本内容[目标位置 + len(目标文本):]
    except Exception:
        return ''
