def 响应对象_取指定行内容(响应对象, 行号):
    """
    功能：
        从服务器响应对象的文本中，获取指定行号的内容。
        行号从 1 开始计数（与人类习惯一致）。

    参数：
        - 响应对象：
            requests.Response 类型对象，通常是 requests.get/post 的返回值。
            若传入 None，则直接返回空字符串。
        - 行号 (int)：
            要获取的行号，从 1 开始计数。
            例如 行号=1 表示第一行。

    返回：
        - str：
            指定行号对应的文本内容。
        - str（空字符串）：
            当 响应对象 为 None、行号超出范围、或出现异常时，返回 ""。

    异常处理逻辑：
        - 如果 响应对象 为 None，立即返回空字符串。
        - 如果行号小于 1 或超出总行数，返回空字符串。
        - 如果读取 .text 或分割时出错，返回空字符串。

    示例：
        >>> import requests
        >>> r = requests.get("https://httpbin.org/stream/3")
        >>> 第一行 = 响应对象_取指定行内容(r, 1)
        >>> print(第一行)
        "{\\"url\\": \\"/stream/3\\", ..."

        >>> 不存在行 = 响应对象_取指定行内容(r, 999)
        >>> print(不存在行)
        ""

    注意事项：
        - 行号从 1 开始，而不是 0。
        - 使用 .splitlines() 进行分割，自动兼容 \n / \r\n / \r。
        - 返回的字符串不包含换行符本身。
    """
    try:
        if 响应对象 is None:
            return ''
        文本内容 = 响应对象.text
        行列表 = 文本内容.splitlines()
        实际行号 = 行号 - 1  # 转换为 0 基索引
        if 0 <= 实际行号 < len(行列表):
            return 行列表[实际行号]
        return ''
    except Exception:
        return ''
