def 响应文本_取中间(响应文本, 文本前缀, 文本后缀):
    """
    功能：
        在响应文本（字符串）中查找指定的前缀和后缀，
        并提取它们之间的子字符串。
        如果未找到前缀或后缀，则返回空字符串。

    参数：
        - 响应文本 (str)：
            已经提取出来的字符串内容。
            如果传入 None，则直接返回空字符串。
        - 文本前缀 (str)：
            用于定位目标文本起始位置的标记字符串。
        - 文本后缀 (str)：
            用于定位目标文本结束位置的标记字符串。

    返回：
        - str：
            提取到的目标子字符串。
        - str（空字符串）：
            当 响应文本 为 None、未找到前缀或后缀、或出现异常时，返回 ""。

    异常处理逻辑：
        - 如果 响应文本 为 None，立即返回空字符串。
        - 如果找不到前缀或后缀，返回空字符串。
        - 如果切片过程中出错，也会返回空字符串。

    示例：
        >>> 内容 = "<title>Hello</title>"
        >>> 结果 = 响应文本_取中间(内容, "<title>", "</title>")
        >>> print(结果)
        "Hello"

    注意事项：
        - 仅提取 **第一次匹配** 的前后缀之间内容。
        - 返回结果不包含前缀和后缀本身。
        - 若需要提取多个匹配片段，可使用正则表达式 re.findall()。
    """
    try:
        if 响应文本 is None:
            return ''
        起始位置 = 响应文本.find(文本前缀)
        if 起始位置 == -1:
            return ''
        起始位置 += len(文本前缀)
        结束位置 = 响应文本.find(文本后缀, 起始位置)
        if 结束位置 == -1:
            return ''
        return 响应文本[起始位置:结束位置]
    except Exception:
        return ''
