def 搜索邮件_按日期(连接对象, 年, 月, 日, 条件="SINCE"):
    """
    按日期搜索邮件。

    参数:
        - 连接对象 (IMAP4_SSL): IMAP4_SSL 连接对象。
        - 年 (int): 年份，格式为四位数，例如 2024。
        - 月 (int): 月份，1 到 12。
        - 日 (int): 日期，1 到 31。
        - 条件 (str): 搜索条件，默认为 'SINCE'，表示搜索指定日期之后的邮件。可以为 'BEFORE' 表示搜索指定日期之前的邮件，也可以为 'ON' 表示精确匹配指定日期的邮件。

    返回:
        - list: 包含符合搜索条件的邮件的邮件ID列表。

    说明:
        1. 根据提供的日期和条件，构建符合IMAP标准的日期搜索条件。
        2. 日期格式会转换为：`"DD-Mmm-YYYY"`，例如 `"04-May-2024"`。
        3. 支持 `SINCE`（指定日期之后的所有邮件），`BEFORE`（指定日期之前的所有邮件），`ON`（精确匹配指定日期的邮件）三种条件。
        4. 调用 IMAP 的 `search` 方法进行邮件搜索，获取符合条件的邮件ID。
        5. 如果搜索成功返回邮件ID列表，否则返回空列表。

    示例:
        - 邮件ID列表 = 搜索邮件_按日期(连接对象, 2024, 5, 4)
        - 邮件ID列表 = 搜索邮件_按日期(连接对象, 2024, 5, 4, 'BEFORE')
        - 邮件ID列表 = 搜索邮件_按日期(连接对象, 2024, 5, 4, 'ON')
    """
    try:
        # 定义月份名称的列表
        月份名称 = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']

        # 构建符合标准的日期格式
        日期 = f'{日}-{月份名称[月 - 1]}-{年}'

        # 构建IMAP搜索条件
        搜索条件 = f'{条件} "{日期}"'

        # 使用 search 方法根据搜索条件查找邮件
        状态, 邮件数据 = 连接对象.search(None, 搜索条件)

        # 如果搜索失败，返回空列表
        if 状态 != "OK":
            return []

        # 返回符合条件的邮件ID列表
        邮件ID列表 = 邮件数据[0].split()
        return 邮件ID列表
    except Exception:
        return []