# Documentation

Welcome to the documentation! This documentation is organized by features and workflows rather than individual code files.

## 📚 Documentation Structure

### [Overview](./overview/index.md)
High-level understanding of the project
- **[Project Overview](./overview/index.md)** - What this project does and why
- **[Architecture Overview](./overview/architecture.md)** - How the system works
- **[Technology Stack](./overview/technology-stack.md)** - Technologies used

### [Getting Started](./getting-started/installation.md)
Everything you need to begin using the project
- **[Installation](./getting-started/installation.md)** - Set up the project
- **[Quick Start](./getting-started/quick-start.md)** - Get up and running in minutes
- **[Configuration](./getting-started/configuration.md)** - Configure for your needs

### [Features](./features/index.md)
Detailed documentation of each major feature and capability

### [Architecture](./architecture/components.md)
Deep dive into system design, components, and patterns

## 🚀 Quick Links

- **First time here?** Start with [Getting Started → Installation](./getting-started/installation.md)
- **Want to understand the system?** Read [Overview → Architecture](./overview/architecture.md)
- **Looking for specific functionality?** Browse [Features](./features/index.md)

## 💡 Documentation Philosophy

This documentation focuses on:
- **Use cases and workflows** rather than individual files
- **Visual diagrams** to explain complex concepts
- **Practical examples** you can copy and adapt
- **Progressive disclosure** from simple to advanced

