# generated by datamodel-codegen:
#   filename:  analytics.yaml
#   timestamp: 2025-07-30T20:13:54+00:00

from __future__ import annotations

from enum import StrEnum
from typing import Any

from pydantic import BaseModel, Field


class Summary(BaseModel):
    ad_mode_begin: int | None = Field(
        None,
        description="Total ad mode begin events received for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    ad_mode_complete: int | None = Field(
        None,
        description="Total ad mode complete events received for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    active_media: int | None = Field(
        None,
        description="Total active videos in account(s) - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    bytes_delivered: int | None = Field(
        None,
        description="Total bytes of data delivered for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    daily_unique_viewers: int | None = Field(
        None,
        description="Total daily unique viewers for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    drm_bytes_packaged: float | None = Field(
        None,
        description="Total DRM bytes packaged for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    engagement_score: float | None = Field(
        None,
        description="Average engagement score for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    licenses_served: int | None = Field(
        None,
        description="Total DRM licenses serverd for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    live_seconds_streamed: float | None = Field(
        None,
        description="Total second of live video streamed for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    play_rate: float | None = Field(
        None,
        description="Average play rate for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    play_request: int | None = Field(
        None,
        description="Total play requests for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    player_load: int | None = Field(
        None,
        description="Total player loads for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    video_engagement_1: float | None = Field(
        None,
        description="Average views at 1% point for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    video_engagement_25: float | None = Field(
        None,
        description="Average views at 25% point for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    video_engagement_50: float | None = Field(
        None,
        description="Average views at 50% point for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    video_engagement_75: float | None = Field(
        None,
        description="Average views at 75% point for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    video_engagement_100: float | None = Field(
        None,
        description="Average views at 100% point for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    video_impression: int | None = Field(
        None,
        description="Total video impressions for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )
    video_view: int | None = Field(
        None,
        description="Total video views for all items - note that properties included in the summary vary depending on the dimension(s) and fields requested",
    )


class TimeSeries(BaseModel):
    type: str = Field(..., description="The type of the timeline array")
    values: list[float] = Field(
        ...,
        description="Array of views in each 100th part of video duration",
    )


class Timeline(BaseModel):
    timeline: TimeSeries


class TimelineWithDuration(Timeline):
    video_duration: GetVideoEngagementResponse | None = None


class GetTimeSeriesResponse(BaseModel):
    interval: list[int] | None = Field(
        None,
        description="array containing the start and end points for the interval in the units specified by the `bucket_duration` parameter",
    )
    dimensions: dict[str, Any] | None = Field(
        None,
        description="A set of dimension/value pairs corresponding to the dimensions specified in the `dimensions` parameter",
    )
    points: list[dict[str, Any]] | None = Field(
        None,
        description="An array of objects containing metrics for the points in the time-series",
    )


class Datum(BaseModel):
    dimensions: dict[str, Any] | None = Field(
        None,
        description="Object containing dimension/value that the associated metrics are for",
    )
    totals: dict[str, Any] | None = Field(
        None,
        description="Object containing metric/value pairs for the associated dimensions",
    )


class GetEventsResponse(BaseModel):
    data: list[Datum] | None = Field(
        None,
        description="array containing metrics per dimension(s)",
    )


class GetVideoEngagementResponse(BaseModel):
    video_duration: str = Field(..., description="the video duration in seconds")


class Items(BaseModel):
    ad_mode_begin: int | None = Field(
        None,
        description="number of times a player entered ad mode",
    )
    ad_mode_complete: int | None = Field(
        None,
        description="number of times a player completed ad mode",
    )
    bytes_delivered: float | None = Field(
        None,
        description="the total bytes of data delivered, including the videos, other assets such as images and captions, and (for player reports) the player code - some of the date is obtained from CDNs and may not be available for up to 3 days",
    )
    engagement_score: float | None = Field(
        None,
        description="the calculated engagement score for the video",
    )
    play_rate: float | None = Field(
        None,
        description="video views divided by video impressions",
    )
    play_request: int | None = Field(
        None,
        description="number of play requests received for a video",
    )
    video: str | None = Field(None, description="the video id")
    duration: str | None = Field(
        None,
        description="'the duration of the video in seconds (note that the duration is available only if there is at least one `video_view`)'",
    )
    video_engagement_1: float | None = Field(
        None,
        description="number of views at the 1% point of the video duration",
    )
    video_engagement_25: float | None = Field(
        None,
        description="number of views at the 25% point of the video duration",
    )
    video_engagement_50: float | None = Field(
        None,
        description="number of views at the 50% point of the video duration",
    )
    video_engagement_75: float | None = Field(
        None,
        description="number of views at the 75% point of the video duration",
    )
    video_engagement_100: float | None = Field(
        None,
        description="number of views at the 100% point of the video duration",
    )
    video_impression: int | None = Field(
        None,
        description="number of times the video was loaded in a player",
    )
    video_name: str | None = Field(None, description="name of the video")
    video_percent_viewed: float | None = Field(
        None,
        description="average percentage of the video played when viewed",
    )
    video_seconds_viewed: float | None = Field(
        None,
        description="total seconds of the video viewed",
    )
    video_view: int | None = Field(
        None,
        description="number of times some portion of the video was viewed",
    )


class LiveDimensions(StrEnum):
    video = "video"
    video_country = "video,country"
    video__device_type = "video, device_type"


class GetAvailableDateRangeResponse(BaseModel):
    reconciled_from: str = Field(
        ...,
        description="the earliest date that you can use for from and get reconciled data",
    )
    reconciled_to: str = Field(
        ...,
        description="'the latest date that you can use for to and get reconciled data (realtime data may be available for later dates)'",
    )


class GetAlltimeVideoViewsResponse(BaseModel):
    alltime_video_views: int = Field(..., description="all-time video views")


class Dimensions(StrEnum):
    account = "account"
    city = "city"
    country = "country"
    region = "region"
    date = "date"
    date_time = "date-time"
    device_os = "device_os"
    device_type = "device_type"
    player = "player"
    referrer_domain = "referrer_domain"
    destination_domain = "destination_domain"
    search_terms = "search_terms"
    social_platform = "social_platform"
    source_type = "source_type"
    video = "video"


class Where(StrEnum):
    account = "account"
    city = "city"
    country = "country"
    region = "region"
    date = "date"
    date_time = "date-time"
    device_os = "device_os"
    device_type = "device_type"
    player = "player"
    referrer_domain = "referrer_domain"
    destination_domain = "destination_domain"
    search_terms = "search_terms"
    social_platform = "social_platform"
    source_type = "source_type"
    video = "video"


class LiveWhere(StrEnum):
    country = "country"
    device_type = "device_type"
    video = "video"


class Format(StrEnum):
    csv = "csv"
    json = "json"
    xlxs = "xlxs"


class GetAnalyticsReportResponse(BaseModel):
    item_count: int = Field(
        ...,
        description="the total number of items matching the request",
    )
    items: list[Items] = Field(
        ...,
        description="array of analytics objects for the videos returned",
    )
    summary: Summary
