---
comments: true
date:
    created: 9999-09-09
    updated: 2024-11-12
authors:
    - Xiaokang2022
categories:
    - 官方文章
tags:
    - 网站
    - 新增功能
    - 说明
---

# 网站新增博客功能🎉

网站新增了博客功能，大家可以把自己的经验、想法写成文章，通过 [拉取请求](https://github.com/Xiaokang2022/maliang/pulls)（Pull Request）来添加到此处，以后官方的文章也会在此处贴出。当然，项目团队会对内容的合规性进行审核，**但我们不对文章内容的正确与否做保证**，我们只保证内容符合项目的 [行为准则](../../../CODE_OF_CONDUCT.md)。~~反正文章底部有评论区，内容的正确与否自会有人评判（笑）~~

也不用担心自己文章的内容写错了无法更改，想要更改很简单，再创建一个新的拉取请求进行更改就行。

好了，简单的介绍就到这里，下面是深入地对这个博客机制进行说明。

<!-- more -->

## 一、由 [`Material`](https://squidfunk.github.io/mkdocs-material/) 主题支持的博客功能

相关文档：

* 搭建博客：<https://squidfunk.github.io/mkdocs-material/setup/setting-up-a-blog/>
* 博客插件：<https://squidfunk.github.io/mkdocs-material/plugins/blog/>

这里是基于上述链接的内容，深度定制后的博客功能。在支持极广泛的 Markdown 语法的情况，融合了单页数据统计功能，包括字数统计、代码行数统计、图片张数统计和访问量统计。此外，还结合了评论功能，RSS 相关功能等，形成了较为完善的博客功能。

此处列出当前项目文档站所使用到的开源项目，可能存在缺漏（“改”字表示被我魔改了）：

直接依赖项目：

* 基础：
    + 框架：<https://github.com/mkdocs/mkdocs>
    + 主题：<https://github.com/squidfunk/mkdocs-material>
* 插件：
    + 图片灯箱（改）：<https://github.com/Blueswen/mkdocs-glightbox>
    + git 贡献者显示：<https://github.com/ojacques/mkdocs-git-committers-plugin-2/>
    + git 日期显示：<https://github.com/timvink/mkdocs-git-revision-date-localized-plugin>
    + 数据统计（改）：<https://github.com/TonyCrane/mkdocs-statistics-plugin>
    + 文档瘦身：<https://github.com/byrnereese/mkdocs-minify-plugin>
    + 版本控制：<https://github.com/jimporter/mike>
* 语法：
    + Markdown 基础语法：<https://github.com/Python-Markdown/markdown>
    + Markdown 扩展语法：<https://github.com/facelessuser/pymdown-extensions>
    + 流程图等绘图：<https://github.com/mermaid-js/mermaid>
    + 数学公式：<https://github.com/mathjax/MathJax>
* 其他：
    + 评论系统：<https://github.com/giscus/giscus>
    + 表格排序：<https://github.com/tristen/tablesort>
    + 网页字体：<https://github.com/lxgw/LxgwWenKai>
    + 字体图标：<https://github.com/FortAwesome/Font-Awesome>
    + 鼠标点击特效：<https://github.com/ColdDay/click-colorful>

参考项目，部分改编：

* 主题：
    * 主题配色：<https://github.com/TonyCrane/note>
    * 顶栏半透明效果：<https://github.com/krahets/hello-algo>
    * 单页右上角下载按钮：<https://github.com/timvink/mkdocs-print-site-plugin>
    * 哔哩哔哩视频 `iframe` 大小适配：<https://github.com/krahets/hello-algo>

未在此文档站中展现，在测试中的功能：

* 其他：
    * 多语言代码在线可视化（可用）：<https://github.com/Xiaokang2022/Fucking-Code/>
    * Live2D 看板娘（存在问题）：<https://github.com/oh-my-live2d/oh-my-live2d>
    * Live2D 看板娘解决方案二（存在问题）：<https://github.com/stevenjoezhang/live2d-widget>

## 二、我们的计划

我们目前的计划收集一系列关于本项目的学习资源，并归档和分类于此，以免去大家从茫茫的互联网上低效地搜集更多的学习资源。此外，可能还可以收录一些连官方都没想到的关于本项目的奇妙操作。

我们还将在此发布一些官方的文章和信息，欢迎大家来看一看！

!!! tip "温馨提示"

    另外，如果你的文章很不错，在评论区得到了很好的反响，我们会参考对应的数据，给你的文章加个独特的标识，表示这是优质的内容。

## 三、如何投稿和修改

首先，项目主站的文档源代码位于主仓库的 `docs` 分支上，项目的教程和文档是在单独的仓库中的，与这里是分开来的。所以，如果需要投稿，应该投稿到 `docs` 分支上。下面列出文章应该投稿到的文件夹位置：

```python hl_lines="5"
└─docs
   └─blog
      └─posts
          ├─official # (1)!
          └─users
```

1. 此处是官方文章所在位置

其他位置的目录和文件我们不需要关系，我们只需要知道，用户投稿的文章应该位于 users 文件夹下。当你打开这个文件夹，你会看到一系列数字，你不需要管这些数字的含义，你只需要按照下面的格式来命名你的文章即可：

```text linenums="0"
当天日期-GitHub用户名.md
```

日期采用 YYYYMMDD 的格式，其他的不需要管。

!!! question "猜你想问：用户投稿有啥回报吗？"

    有啊！包有的啊！你可以成为本项目的贡献者，这还不够吗？:) 不过我手动收录的就算了，这没办法。

## 三、文章元数据

此处要说明的对大家投稿的文章极为重要，这里指的元数据要写在 Markdown 文件的**开头**，这样博客插件才能识别相应的数据。格式如下（此处以该文件为例）：

```markdown
---
comments: true
date:
    created: 9999-09-09
    updated: 2024-11-11
authors:
    - Xiaokang2022
categories:
    - 官方文章
tags:
    - 网站
    - 新增功能
    - 说明
---
```

下面列举元数据每项的含义：

* `comments`: 是否开启评论区（必开，你不开也得给我开）
* `data`:
    + `created`: 创建日期
    + `updated`: 更新日期（第一次的数据和创建日期保持一致）
* `authors`: 作者的 GitHub 用户名，列表形式，多个人就继续往下写
* `categories`: 文章分类，列表形式
* `tags`: 文章标签，列表形式，页面开头那几个

这里关于文章分类，只允许写 “用户投稿” 一项。关于文章标签，你随意，别太离谱就行。

## 四、文章概览

这个必须要有，不然文档构建时不会通过。很简单，就是在你的文章里面，你认为合适的地方添加单独的一段，内容为 `<!-- more -->`，这样，博客插件就会把这个之前的内容认为是文章概览，首页出现的内容就是玩意儿。

当然，你要嫌麻烦，也可以不写，不写的话就我来帮你写（不我介意）。

## 五、其他

支持的 Markdown 的语法是完整的，此外还支持一堆扩展语法，见上述 Markdown 扩展语法开源项目。

这里给个简单博客示例：

```markdown
---
comments: true
date:
    created: 2333-02-23
    updated: 6666-06-06
authors:
    - 我叫用户名
categories:
    - 用户投稿
tags:
    - 标签一
    - 标签二
    - 标签三
---

# 我是文章标题

我是文章概览

<!-- more -->

啊吧啊吧……

```
