---
icon: material/clipboard-text
---

First off, thanks for taking the time to contribute! ❤️

All types of contributions are encouraged and valued.Please see the table of contents below for details on the different ways to contribute and how to handle them. Be sure to read the relevant section before contributing, this will make it easier for our maintainers and make the experience smoother for everyone involved. We look forward to your contributions!

!!! tip "Tip"

    If you like the project, but just don't have time to contribute, that's fine. There are other easy ways to support the project and show your gratitude, and we are also very happy, such as star the project!⭐

## ❓ I Have a Question

### 💡 Issue

If you want to ask a question, we assume that you have read the available Documentation.If you still don't find an answer you're happy with, you can start an issue and we'll get back to you as quickly as possible. However, before initiating an issue, please search for existing issues related to your issue to avoid initiating duplicate issues.

### 💬 Discussion

If you have any suggestions, etc., you can start a discussion in the discussion board. For example, you can start a discussion about a feature, discuss it with someone else or a project maintainer, and we will make improvements to the project based on the results of the discussion, or we may not take the suggestion.

## ✏️ I Want To Contribute

!!! warning "Warning"

    When contributing to this project, you must agree that you have authored **100%** of the content, that you have the necessary rights to the content and that the content you contribute may be provided under the project license.

### 📝 Source Codes

* It must be able to run stably in the latest stable version of the programming environment;
* The content must be relevant to the project;
* The code style meets the requirements (see below);
* Include appropriate comments;
* All in English, including docstrings;

### 📑 Documents

* Correct, detailed, and easy to understand;
* Comply with certain specifications;
* If possible, please translate into both English and Chinese;

### 📖 Tutorials

* Accurate;
* Contains runnable sample code;
* The code must contain appropriate comments;
* If possible, try not to use external resources (such as images, etc.);
* If possible, please add pictures for illustrative purposes;
* If possible, please translate into both English and Chinese;

### 📚 Others

* Compliance with certain specifications is sufficient, depending on the circumstances;

## ✨ What is the Style

### 1️⃣ Lint & Test

We set up Lint and Test for all submissions. Lint require that your code must have no major errors (such as syntax errors) and that your code must be rated greater than 9.0. Test require your code to pass without too many errors.

* Lint: <https://github.com/pylint-dev/pylint>
* Test: <https://github.com/pytest-dev/pytest>

### 2️⃣ Code Style

If you want your PR to be merged, we want your code style to be as official as possible, and if you can, we prefer your code to be in line with the project's code style.

### 3️⃣ Other Style

For other content, such as issues, we don't make any stylistic requirements.

## 🤝 Join The Project Team

If you would like to join the project team, please contact the maintainers of the project team, here is some information about the authors of this project:

* 😆 Author: @Xiaokang2022
* ✉️ Email: <2951256653@qq.com>

---

<small>This contribution guide is based on https://contributing.md/example/ .</small>
