# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-eks. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._enums import *
from ._inputs import *
from .cluster import Cluster
from .vpc_cni_addon import VpcCniAddon
import pulumi_aws
import pulumi_kubernetes

__all__ = ['NodeGroupV2Args', 'NodeGroupV2']

@pulumi.input_type
class NodeGroupV2Args:
    def __init__(__self__, *,
                 cluster: pulumi.Input[Union['Cluster', 'CoreDataArgs']],
                 ami_id: Optional[pulumi.Input[builtins.str]] = None,
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 auto_scaling_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bootstrap_extra_args: Optional[pulumi.Input[builtins.str]] = None,
                 bottlerocket_settings: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cloud_formation_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cluster_ingress_rule: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']] = None,
                 cluster_ingress_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 enable_detailed_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[builtins.bool]] = None,
                 extra_node_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]] = None,
                 gpu: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_scaling_changes: Optional[builtins.bool] = None,
                 instance_profile: Optional['pulumi_aws.iam.InstanceProfile'] = None,
                 instance_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 kubelet_extra_args: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_refresh_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 node_public_key: Optional[pulumi.Input[builtins.str]] = None,
                 node_root_volume_delete_on_termination: Optional[pulumi.Input[builtins.bool]] = None,
                 node_root_volume_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 node_root_volume_iops: Optional[pulumi.Input[builtins.int]] = None,
                 node_root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 node_root_volume_throughput: Optional[pulumi.Input[builtins.int]] = None,
                 node_root_volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 node_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 node_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 node_user_data: Optional[pulumi.Input[builtins.str]] = None,
                 node_user_data_override: Optional[pulumi.Input[builtins.str]] = None,
                 nodeadm_extra_options: Optional[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]]] = None,
                 operating_system: Optional[pulumi.Input['OperatingSystem']] = None,
                 spot_price: Optional[pulumi.Input[builtins.str]] = None,
                 taints: Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NodeGroupV2 resource.
        :param pulumi.Input[Union['Cluster', 'CoreDataArgs']] cluster: The target EKS cluster.
        :param pulumi.Input[builtins.str] ami_id: The AMI ID to use for the worker nodes.
               
               Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.
               
               Note: `amiId` and `gpu` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[builtins.str] ami_type: The AMI Type to use for the worker nodes. 
               
               Only applicable when setting an AMI ID that is of type `arm64`. 
               
               Note: `amiType` and `gpu` are mutually exclusive.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] auto_scaling_group_tags: The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.
               
               Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input[builtins.str] bootstrap_extra_args: Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        :param pulumi.Input[Mapping[str, Any]] bottlerocket_settings: The configuration settings for Bottlerocket OS.
               The settings will get merged with the base settings the provider uses to configure Bottlerocket.
               
               This includes:
                 - settings.kubernetes.api-server
                 - settings.kubernetes.cluster-certificate
                 - settings.kubernetes.cluster-name
                 - settings.kubernetes.cluster-dns-ip
               
               For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] cloud_formation_tags: The tags to apply to the CloudFormation Stack of the Worker NodeGroup.
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroupRule'] cluster_ingress_rule: The ingress rule that gives node group access.
        :param pulumi.Input[builtins.str] cluster_ingress_rule_id: The ID of the ingress rule that gives node group access.
        :param pulumi.Input[builtins.int] desired_capacity: The number of worker nodes that should be running in the cluster. Defaults to 2.
        :param pulumi.Input[builtins.bool] enable_detailed_monitoring: Enables/disables detailed monitoring of the EC2 instances.
               
               With detailed monitoring, all metrics, including status check metrics, are available in 1-minute intervals.
               When enabled, you can also get aggregated data across groups of similar instances.
               
               Note: You are charged per metric that is sent to CloudWatch. You are not charged for data storage.
               For more information, see "Paid tier" and "Example 1 - EC2 Detailed Monitoring" here https://aws.amazon.com/cloudwatch/pricing/.
        :param pulumi.Input[builtins.bool] encrypt_root_block_device: Encrypt the root block device of the nodes in the node group.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]] extra_node_security_groups: Extra security groups to attach on all nodes in this worker node group.
               
               This additional set of security groups captures any user application rules that will be needed for the nodes.
        :param pulumi.Input[builtins.bool] gpu: Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.
               
               Defaults to false.
               
               Note: `gpu` and `amiId` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
               - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        :param builtins.bool ignore_scaling_changes: Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.
               
               See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        :param 'pulumi_aws.iam.InstanceProfile' instance_profile: The IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        :param pulumi.Input[builtins.str] instance_profile_name: The name of the IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        :param pulumi.Input[builtins.str] instance_type: The instance type to use for the cluster's nodes. Defaults to "t3.medium".
        :param pulumi.Input[builtins.str] key_name: Name of the key pair to use for SSH access to worker nodes.
        :param pulumi.Input[builtins.str] kubelet_extra_args: Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the explicit `kubeletExtraArgs`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Custom k8s node labels to be attached to each worker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]] launch_template_tag_specifications: The tag specifications to apply to the launch template.
        :param pulumi.Input[builtins.int] max_size: The maximum number of worker nodes running in the cluster. Defaults to 2.
        :param pulumi.Input[builtins.int] min_refresh_percentage: The minimum amount of instances that should remain available during an instance refresh, expressed as a percentage. Defaults to 50.
        :param pulumi.Input[builtins.int] min_size: The minimum number of worker nodes running in the cluster. Defaults to 1.
        :param pulumi.Input[builtins.bool] node_associate_public_ip_address: Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        :param pulumi.Input[builtins.str] node_public_key: Public key material for SSH access to worker nodes. See allowed formats at:
               https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
               If not provided, no SSH access is enabled on VMs.
        :param pulumi.Input[builtins.bool] node_root_volume_delete_on_termination: Whether the root block device should be deleted on termination of the instance. Defaults to true.
        :param pulumi.Input[builtins.bool] node_root_volume_encrypted: Whether to encrypt a cluster node's root volume. Defaults to false.
        :param pulumi.Input[builtins.int] node_root_volume_iops: The amount of provisioned IOPS. This is only valid with a volumeType of 'io1'.
        :param pulumi.Input[builtins.int] node_root_volume_size: The size in GiB of a cluster node's root volume. Defaults to 20.
        :param pulumi.Input[builtins.int] node_root_volume_throughput: Provisioned throughput performance in integer MiB/s for a cluster node's root volume. This is only valid with a volumeType of 'gp3'.
        :param pulumi.Input[builtins.str] node_root_volume_type: Configured EBS type for a cluster node's root volume. Default is 'gp2'. Supported values are 'standard', 'gp2', 'gp3', 'st1', 'sc1', 'io1'.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroup'] node_security_group: The security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        :param pulumi.Input[builtins.str] node_security_group_id: The ID of the security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroupId` option and the cluster option `nodeSecurityGroupTags` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] node_subnet_ids: The set of subnets to override and use for the worker node group.
               
               Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        :param pulumi.Input[builtins.str] node_user_data: Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        :param pulumi.Input[builtins.str] node_user_data_override: User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        :param pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]] nodeadm_extra_options: Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
               The base settings the provider sets are:
                 - cluster.name
                 - cluster.apiServerEndpoint
                 - cluster.certificateAuthority
                 - cluster.cidr
               
               Note: This is only applicable when using AL2023.
               See for more details:
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        :param pulumi.Input['OperatingSystem'] operating_system: The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
               Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.
               
               Defaults to the current recommended OS.
        :param pulumi.Input[builtins.str] spot_price: Bidding price for spot instance. If set, only spot instances will be added as worker node.
        :param pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]] taints: Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        :param pulumi.Input[builtins.str] version: Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        pulumi.set(__self__, "cluster", cluster)
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if ami_type is not None:
            pulumi.set(__self__, "ami_type", ami_type)
        if auto_scaling_group_tags is not None:
            pulumi.set(__self__, "auto_scaling_group_tags", auto_scaling_group_tags)
        if bootstrap_extra_args is not None:
            pulumi.set(__self__, "bootstrap_extra_args", bootstrap_extra_args)
        if bottlerocket_settings is not None:
            pulumi.set(__self__, "bottlerocket_settings", bottlerocket_settings)
        if cloud_formation_tags is not None:
            pulumi.set(__self__, "cloud_formation_tags", cloud_formation_tags)
        if cluster_ingress_rule is not None:
            pulumi.set(__self__, "cluster_ingress_rule", cluster_ingress_rule)
        if cluster_ingress_rule_id is not None:
            pulumi.set(__self__, "cluster_ingress_rule_id", cluster_ingress_rule_id)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if enable_detailed_monitoring is not None:
            pulumi.set(__self__, "enable_detailed_monitoring", enable_detailed_monitoring)
        if encrypt_root_block_device is not None:
            pulumi.set(__self__, "encrypt_root_block_device", encrypt_root_block_device)
        if extra_node_security_groups is not None:
            pulumi.set(__self__, "extra_node_security_groups", extra_node_security_groups)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if ignore_scaling_changes is not None:
            pulumi.set(__self__, "ignore_scaling_changes", ignore_scaling_changes)
        if instance_profile is not None:
            pulumi.set(__self__, "instance_profile", instance_profile)
        if instance_profile_name is not None:
            pulumi.set(__self__, "instance_profile_name", instance_profile_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kubelet_extra_args is not None:
            pulumi.set(__self__, "kubelet_extra_args", kubelet_extra_args)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_template_tag_specifications is not None:
            pulumi.set(__self__, "launch_template_tag_specifications", launch_template_tag_specifications)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_refresh_percentage is not None:
            pulumi.set(__self__, "min_refresh_percentage", min_refresh_percentage)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if node_associate_public_ip_address is not None:
            pulumi.set(__self__, "node_associate_public_ip_address", node_associate_public_ip_address)
        if node_public_key is not None:
            pulumi.set(__self__, "node_public_key", node_public_key)
        if node_root_volume_delete_on_termination is not None:
            pulumi.set(__self__, "node_root_volume_delete_on_termination", node_root_volume_delete_on_termination)
        if node_root_volume_encrypted is not None:
            pulumi.set(__self__, "node_root_volume_encrypted", node_root_volume_encrypted)
        if node_root_volume_iops is not None:
            pulumi.set(__self__, "node_root_volume_iops", node_root_volume_iops)
        if node_root_volume_size is not None:
            pulumi.set(__self__, "node_root_volume_size", node_root_volume_size)
        if node_root_volume_throughput is not None:
            pulumi.set(__self__, "node_root_volume_throughput", node_root_volume_throughput)
        if node_root_volume_type is not None:
            pulumi.set(__self__, "node_root_volume_type", node_root_volume_type)
        if node_security_group is not None:
            pulumi.set(__self__, "node_security_group", node_security_group)
        if node_security_group_id is not None:
            pulumi.set(__self__, "node_security_group_id", node_security_group_id)
        if node_subnet_ids is not None:
            pulumi.set(__self__, "node_subnet_ids", node_subnet_ids)
        if node_user_data is not None:
            pulumi.set(__self__, "node_user_data", node_user_data)
        if node_user_data_override is not None:
            pulumi.set(__self__, "node_user_data_override", node_user_data_override)
        if nodeadm_extra_options is not None:
            pulumi.set(__self__, "nodeadm_extra_options", nodeadm_extra_options)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[Union['Cluster', 'CoreDataArgs']]:
        """
        The target EKS cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[Union['Cluster', 'CoreDataArgs']]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AMI ID to use for the worker nodes.

        Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.

        Note: `amiId` and `gpu` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        """
        return pulumi.get(self, "ami_id")

    @ami_id.setter
    def ami_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ami_id", value)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AMI Type to use for the worker nodes. 

        Only applicable when setting an AMI ID that is of type `arm64`. 

        Note: `amiType` and `gpu` are mutually exclusive.
        """
        return pulumi.get(self, "ami_type")

    @ami_type.setter
    def ami_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ami_type", value)

    @property
    @pulumi.getter(name="autoScalingGroupTags")
    def auto_scaling_group_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.

        Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "auto_scaling_group_tags")

    @auto_scaling_group_tags.setter
    def auto_scaling_group_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "auto_scaling_group_tags", value)

    @property
    @pulumi.getter(name="bootstrapExtraArgs")
    def bootstrap_extra_args(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        """
        return pulumi.get(self, "bootstrap_extra_args")

    @bootstrap_extra_args.setter
    def bootstrap_extra_args(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bootstrap_extra_args", value)

    @property
    @pulumi.getter(name="bottlerocketSettings")
    def bottlerocket_settings(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The configuration settings for Bottlerocket OS.
        The settings will get merged with the base settings the provider uses to configure Bottlerocket.

        This includes:
          - settings.kubernetes.api-server
          - settings.kubernetes.cluster-certificate
          - settings.kubernetes.cluster-name
          - settings.kubernetes.cluster-dns-ip

        For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        """
        return pulumi.get(self, "bottlerocket_settings")

    @bottlerocket_settings.setter
    def bottlerocket_settings(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "bottlerocket_settings", value)

    @property
    @pulumi.getter(name="cloudFormationTags")
    def cloud_formation_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags to apply to the CloudFormation Stack of the Worker NodeGroup.

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "cloud_formation_tags")

    @cloud_formation_tags.setter
    def cloud_formation_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cloud_formation_tags", value)

    @property
    @pulumi.getter(name="clusterIngressRule")
    def cluster_ingress_rule(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']]:
        """
        The ingress rule that gives node group access.
        """
        return pulumi.get(self, "cluster_ingress_rule")

    @cluster_ingress_rule.setter
    def cluster_ingress_rule(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']]):
        pulumi.set(self, "cluster_ingress_rule", value)

    @property
    @pulumi.getter(name="clusterIngressRuleId")
    def cluster_ingress_rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the ingress rule that gives node group access.
        """
        return pulumi.get(self, "cluster_ingress_rule_id")

    @cluster_ingress_rule_id.setter
    def cluster_ingress_rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_ingress_rule_id", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of worker nodes that should be running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="enableDetailedMonitoring")
    def enable_detailed_monitoring(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables/disables detailed monitoring of the EC2 instances.

        With detailed monitoring, all metrics, including status check metrics, are available in 1-minute intervals.
        When enabled, you can also get aggregated data across groups of similar instances.

        Note: You are charged per metric that is sent to CloudWatch. You are not charged for data storage.
        For more information, see "Paid tier" and "Example 1 - EC2 Detailed Monitoring" here https://aws.amazon.com/cloudwatch/pricing/.
        """
        return pulumi.get(self, "enable_detailed_monitoring")

    @enable_detailed_monitoring.setter
    def enable_detailed_monitoring(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_detailed_monitoring", value)

    @property
    @pulumi.getter(name="encryptRootBlockDevice")
    def encrypt_root_block_device(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Encrypt the root block device of the nodes in the node group.
        """
        return pulumi.get(self, "encrypt_root_block_device")

    @encrypt_root_block_device.setter
    def encrypt_root_block_device(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypt_root_block_device", value)

    @property
    @pulumi.getter(name="extraNodeSecurityGroups")
    def extra_node_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]]:
        """
        Extra security groups to attach on all nodes in this worker node group.

        This additional set of security groups captures any user application rules that will be needed for the nodes.
        """
        return pulumi.get(self, "extra_node_security_groups")

    @extra_node_security_groups.setter
    def extra_node_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]]):
        pulumi.set(self, "extra_node_security_groups", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.

        Defaults to false.

        Note: `gpu` and `amiId` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
        - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="ignoreScalingChanges")
    def ignore_scaling_changes(self) -> Optional[builtins.bool]:
        """
        Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.

        See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        """
        return pulumi.get(self, "ignore_scaling_changes")

    @ignore_scaling_changes.setter
    def ignore_scaling_changes(self, value: Optional[builtins.bool]):
        pulumi.set(self, "ignore_scaling_changes", value)

    @property
    @pulumi.getter(name="instanceProfile")
    def instance_profile(self) -> Optional['pulumi_aws.iam.InstanceProfile']:
        """
        The IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        """
        return pulumi.get(self, "instance_profile")

    @instance_profile.setter
    def instance_profile(self, value: Optional['pulumi_aws.iam.InstanceProfile']):
        pulumi.set(self, "instance_profile", value)

    @property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        """
        return pulumi.get(self, "instance_profile_name")

    @instance_profile_name.setter
    def instance_profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_profile_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance type to use for the cluster's nodes. Defaults to "t3.medium".
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the key pair to use for SSH access to worker nodes.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kubeletExtraArgs")
    def kubelet_extra_args(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the explicit `kubeletExtraArgs`.
        """
        return pulumi.get(self, "kubelet_extra_args")

    @kubelet_extra_args.setter
    def kubelet_extra_args(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kubelet_extra_args", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Custom k8s node labels to be attached to each worker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchTemplateTagSpecifications")
    def launch_template_tag_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]]]:
        """
        The tag specifications to apply to the launch template.
        """
        return pulumi.get(self, "launch_template_tag_specifications")

    @launch_template_tag_specifications.setter
    def launch_template_tag_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]]]):
        pulumi.set(self, "launch_template_tag_specifications", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of worker nodes running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minRefreshPercentage")
    def min_refresh_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum amount of instances that should remain available during an instance refresh, expressed as a percentage. Defaults to 50.
        """
        return pulumi.get(self, "min_refresh_percentage")

    @min_refresh_percentage.setter
    def min_refresh_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_refresh_percentage", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of worker nodes running in the cluster. Defaults to 1.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="nodeAssociatePublicIpAddress")
    def node_associate_public_ip_address(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        """
        return pulumi.get(self, "node_associate_public_ip_address")

    @node_associate_public_ip_address.setter
    def node_associate_public_ip_address(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "node_associate_public_ip_address", value)

    @property
    @pulumi.getter(name="nodePublicKey")
    def node_public_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Public key material for SSH access to worker nodes. See allowed formats at:
        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
        If not provided, no SSH access is enabled on VMs.
        """
        return pulumi.get(self, "node_public_key")

    @node_public_key.setter
    def node_public_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_public_key", value)

    @property
    @pulumi.getter(name="nodeRootVolumeDeleteOnTermination")
    def node_root_volume_delete_on_termination(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the root block device should be deleted on termination of the instance. Defaults to true.
        """
        return pulumi.get(self, "node_root_volume_delete_on_termination")

    @node_root_volume_delete_on_termination.setter
    def node_root_volume_delete_on_termination(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "node_root_volume_delete_on_termination", value)

    @property
    @pulumi.getter(name="nodeRootVolumeEncrypted")
    def node_root_volume_encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to encrypt a cluster node's root volume. Defaults to false.
        """
        return pulumi.get(self, "node_root_volume_encrypted")

    @node_root_volume_encrypted.setter
    def node_root_volume_encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "node_root_volume_encrypted", value)

    @property
    @pulumi.getter(name="nodeRootVolumeIops")
    def node_root_volume_iops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of provisioned IOPS. This is only valid with a volumeType of 'io1'.
        """
        return pulumi.get(self, "node_root_volume_iops")

    @node_root_volume_iops.setter
    def node_root_volume_iops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_root_volume_iops", value)

    @property
    @pulumi.getter(name="nodeRootVolumeSize")
    def node_root_volume_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size in GiB of a cluster node's root volume. Defaults to 20.
        """
        return pulumi.get(self, "node_root_volume_size")

    @node_root_volume_size.setter
    def node_root_volume_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_root_volume_size", value)

    @property
    @pulumi.getter(name="nodeRootVolumeThroughput")
    def node_root_volume_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Provisioned throughput performance in integer MiB/s for a cluster node's root volume. This is only valid with a volumeType of 'gp3'.
        """
        return pulumi.get(self, "node_root_volume_throughput")

    @node_root_volume_throughput.setter
    def node_root_volume_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_root_volume_throughput", value)

    @property
    @pulumi.getter(name="nodeRootVolumeType")
    def node_root_volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configured EBS type for a cluster node's root volume. Default is 'gp2'. Supported values are 'standard', 'gp2', 'gp3', 'st1', 'sc1', 'io1'.
        """
        return pulumi.get(self, "node_root_volume_type")

    @node_root_volume_type.setter
    def node_root_volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_root_volume_type", value)

    @property
    @pulumi.getter(name="nodeSecurityGroup")
    def node_security_group(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]:
        """
        The security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        """
        return pulumi.get(self, "node_security_group")

    @node_security_group.setter
    def node_security_group(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]):
        pulumi.set(self, "node_security_group", value)

    @property
    @pulumi.getter(name="nodeSecurityGroupId")
    def node_security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroupId` option and the cluster option `nodeSecurityGroupTags` are mutually exclusive.
        """
        return pulumi.get(self, "node_security_group_id")

    @node_security_group_id.setter
    def node_security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_security_group_id", value)

    @property
    @pulumi.getter(name="nodeSubnetIds")
    def node_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The set of subnets to override and use for the worker node group.

        Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        """
        return pulumi.get(self, "node_subnet_ids")

    @node_subnet_ids.setter
    def node_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "node_subnet_ids", value)

    @property
    @pulumi.getter(name="nodeUserData")
    def node_user_data(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        """
        return pulumi.get(self, "node_user_data")

    @node_user_data.setter
    def node_user_data(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_user_data", value)

    @property
    @pulumi.getter(name="nodeUserDataOverride")
    def node_user_data_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        """
        return pulumi.get(self, "node_user_data_override")

    @node_user_data_override.setter
    def node_user_data_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_user_data_override", value)

    @property
    @pulumi.getter(name="nodeadmExtraOptions")
    def nodeadm_extra_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]]]:
        """
        Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
        The base settings the provider sets are:
          - cluster.name
          - cluster.apiServerEndpoint
          - cluster.certificateAuthority
          - cluster.cidr

        Note: This is only applicable when using AL2023.
        See for more details:
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        """
        return pulumi.get(self, "nodeadm_extra_options")

    @nodeadm_extra_options.setter
    def nodeadm_extra_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]]]):
        pulumi.set(self, "nodeadm_extra_options", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input['OperatingSystem']]:
        """
        The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
        Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.

        Defaults to the current recommended OS.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input['OperatingSystem']]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Bidding price for spot instance. If set, only spot instances will be added as worker node.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]]:
        """
        Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("eks:index:NodeGroupV2")
class NodeGroupV2(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_id: Optional[pulumi.Input[builtins.str]] = None,
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 auto_scaling_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bootstrap_extra_args: Optional[pulumi.Input[builtins.str]] = None,
                 bottlerocket_settings: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cloud_formation_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cluster: Optional[pulumi.Input[Union['Cluster', Union['CoreDataArgs', 'CoreDataArgsDict']]]] = None,
                 cluster_ingress_rule: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']] = None,
                 cluster_ingress_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 enable_detailed_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[builtins.bool]] = None,
                 extra_node_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]] = None,
                 gpu: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_scaling_changes: Optional[builtins.bool] = None,
                 instance_profile: Optional['pulumi_aws.iam.InstanceProfile'] = None,
                 instance_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 kubelet_extra_args: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]]]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_refresh_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 node_public_key: Optional[pulumi.Input[builtins.str]] = None,
                 node_root_volume_delete_on_termination: Optional[pulumi.Input[builtins.bool]] = None,
                 node_root_volume_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 node_root_volume_iops: Optional[pulumi.Input[builtins.int]] = None,
                 node_root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 node_root_volume_throughput: Optional[pulumi.Input[builtins.int]] = None,
                 node_root_volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 node_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 node_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 node_user_data: Optional[pulumi.Input[builtins.str]] = None,
                 node_user_data_override: Optional[pulumi.Input[builtins.str]] = None,
                 nodeadm_extra_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeadmOptionsArgs', 'NodeadmOptionsArgsDict']]]]] = None,
                 operating_system: Optional[pulumi.Input['OperatingSystem']] = None,
                 spot_price: Optional[pulumi.Input[builtins.str]] = None,
                 taints: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['TaintArgs', 'TaintArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        NodeGroup is a component that wraps the AWS EC2 instances that provide compute capacity for an EKS cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ami_id: The AMI ID to use for the worker nodes.
               
               Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.
               
               Note: `amiId` and `gpu` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[builtins.str] ami_type: The AMI Type to use for the worker nodes. 
               
               Only applicable when setting an AMI ID that is of type `arm64`. 
               
               Note: `amiType` and `gpu` are mutually exclusive.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] auto_scaling_group_tags: The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.
               
               Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input[builtins.str] bootstrap_extra_args: Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        :param pulumi.Input[Mapping[str, Any]] bottlerocket_settings: The configuration settings for Bottlerocket OS.
               The settings will get merged with the base settings the provider uses to configure Bottlerocket.
               
               This includes:
                 - settings.kubernetes.api-server
                 - settings.kubernetes.cluster-certificate
                 - settings.kubernetes.cluster-name
                 - settings.kubernetes.cluster-dns-ip
               
               For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] cloud_formation_tags: The tags to apply to the CloudFormation Stack of the Worker NodeGroup.
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input[Union['Cluster', Union['CoreDataArgs', 'CoreDataArgsDict']]] cluster: The target EKS cluster.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroupRule'] cluster_ingress_rule: The ingress rule that gives node group access.
        :param pulumi.Input[builtins.str] cluster_ingress_rule_id: The ID of the ingress rule that gives node group access.
        :param pulumi.Input[builtins.int] desired_capacity: The number of worker nodes that should be running in the cluster. Defaults to 2.
        :param pulumi.Input[builtins.bool] enable_detailed_monitoring: Enables/disables detailed monitoring of the EC2 instances.
               
               With detailed monitoring, all metrics, including status check metrics, are available in 1-minute intervals.
               When enabled, you can also get aggregated data across groups of similar instances.
               
               Note: You are charged per metric that is sent to CloudWatch. You are not charged for data storage.
               For more information, see "Paid tier" and "Example 1 - EC2 Detailed Monitoring" here https://aws.amazon.com/cloudwatch/pricing/.
        :param pulumi.Input[builtins.bool] encrypt_root_block_device: Encrypt the root block device of the nodes in the node group.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]] extra_node_security_groups: Extra security groups to attach on all nodes in this worker node group.
               
               This additional set of security groups captures any user application rules that will be needed for the nodes.
        :param pulumi.Input[builtins.bool] gpu: Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.
               
               Defaults to false.
               
               Note: `gpu` and `amiId` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
               - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        :param builtins.bool ignore_scaling_changes: Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.
               
               See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        :param 'pulumi_aws.iam.InstanceProfile' instance_profile: The IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        :param pulumi.Input[builtins.str] instance_profile_name: The name of the IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        :param pulumi.Input[builtins.str] instance_type: The instance type to use for the cluster's nodes. Defaults to "t3.medium".
        :param pulumi.Input[builtins.str] key_name: Name of the key pair to use for SSH access to worker nodes.
        :param pulumi.Input[builtins.str] kubelet_extra_args: Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the explicit `kubeletExtraArgs`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Custom k8s node labels to be attached to each worker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]]] launch_template_tag_specifications: The tag specifications to apply to the launch template.
        :param pulumi.Input[builtins.int] max_size: The maximum number of worker nodes running in the cluster. Defaults to 2.
        :param pulumi.Input[builtins.int] min_refresh_percentage: The minimum amount of instances that should remain available during an instance refresh, expressed as a percentage. Defaults to 50.
        :param pulumi.Input[builtins.int] min_size: The minimum number of worker nodes running in the cluster. Defaults to 1.
        :param pulumi.Input[builtins.bool] node_associate_public_ip_address: Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        :param pulumi.Input[builtins.str] node_public_key: Public key material for SSH access to worker nodes. See allowed formats at:
               https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
               If not provided, no SSH access is enabled on VMs.
        :param pulumi.Input[builtins.bool] node_root_volume_delete_on_termination: Whether the root block device should be deleted on termination of the instance. Defaults to true.
        :param pulumi.Input[builtins.bool] node_root_volume_encrypted: Whether to encrypt a cluster node's root volume. Defaults to false.
        :param pulumi.Input[builtins.int] node_root_volume_iops: The amount of provisioned IOPS. This is only valid with a volumeType of 'io1'.
        :param pulumi.Input[builtins.int] node_root_volume_size: The size in GiB of a cluster node's root volume. Defaults to 20.
        :param pulumi.Input[builtins.int] node_root_volume_throughput: Provisioned throughput performance in integer MiB/s for a cluster node's root volume. This is only valid with a volumeType of 'gp3'.
        :param pulumi.Input[builtins.str] node_root_volume_type: Configured EBS type for a cluster node's root volume. Default is 'gp2'. Supported values are 'standard', 'gp2', 'gp3', 'st1', 'sc1', 'io1'.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroup'] node_security_group: The security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        :param pulumi.Input[builtins.str] node_security_group_id: The ID of the security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroupId` option and the cluster option `nodeSecurityGroupTags` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] node_subnet_ids: The set of subnets to override and use for the worker node group.
               
               Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        :param pulumi.Input[builtins.str] node_user_data: Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        :param pulumi.Input[builtins.str] node_user_data_override: User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeadmOptionsArgs', 'NodeadmOptionsArgsDict']]]] nodeadm_extra_options: Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
               The base settings the provider sets are:
                 - cluster.name
                 - cluster.apiServerEndpoint
                 - cluster.certificateAuthority
                 - cluster.cidr
               
               Note: This is only applicable when using AL2023.
               See for more details:
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        :param pulumi.Input['OperatingSystem'] operating_system: The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
               Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.
               
               Defaults to the current recommended OS.
        :param pulumi.Input[builtins.str] spot_price: Bidding price for spot instance. If set, only spot instances will be added as worker node.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['TaintArgs', 'TaintArgsDict']]]] taints: Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        :param pulumi.Input[builtins.str] version: Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeGroupV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        NodeGroup is a component that wraps the AWS EC2 instances that provide compute capacity for an EKS cluster.

        :param str resource_name: The name of the resource.
        :param NodeGroupV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeGroupV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_id: Optional[pulumi.Input[builtins.str]] = None,
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 auto_scaling_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 bootstrap_extra_args: Optional[pulumi.Input[builtins.str]] = None,
                 bottlerocket_settings: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cloud_formation_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 cluster: Optional[pulumi.Input[Union['Cluster', Union['CoreDataArgs', 'CoreDataArgsDict']]]] = None,
                 cluster_ingress_rule: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']] = None,
                 cluster_ingress_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 enable_detailed_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[builtins.bool]] = None,
                 extra_node_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]] = None,
                 gpu: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_scaling_changes: Optional[builtins.bool] = None,
                 instance_profile: Optional['pulumi_aws.iam.InstanceProfile'] = None,
                 instance_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_name: Optional[pulumi.Input[builtins.str]] = None,
                 kubelet_extra_args: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]]]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_refresh_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[builtins.bool]] = None,
                 node_public_key: Optional[pulumi.Input[builtins.str]] = None,
                 node_root_volume_delete_on_termination: Optional[pulumi.Input[builtins.bool]] = None,
                 node_root_volume_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 node_root_volume_iops: Optional[pulumi.Input[builtins.int]] = None,
                 node_root_volume_size: Optional[pulumi.Input[builtins.int]] = None,
                 node_root_volume_throughput: Optional[pulumi.Input[builtins.int]] = None,
                 node_root_volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 node_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 node_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 node_user_data: Optional[pulumi.Input[builtins.str]] = None,
                 node_user_data_override: Optional[pulumi.Input[builtins.str]] = None,
                 nodeadm_extra_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeadmOptionsArgs', 'NodeadmOptionsArgsDict']]]]] = None,
                 operating_system: Optional[pulumi.Input['OperatingSystem']] = None,
                 spot_price: Optional[pulumi.Input[builtins.str]] = None,
                 taints: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['TaintArgs', 'TaintArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeGroupV2Args.__new__(NodeGroupV2Args)

            __props__.__dict__["ami_id"] = ami_id
            __props__.__dict__["ami_type"] = ami_type
            __props__.__dict__["auto_scaling_group_tags"] = auto_scaling_group_tags
            __props__.__dict__["bootstrap_extra_args"] = bootstrap_extra_args
            __props__.__dict__["bottlerocket_settings"] = bottlerocket_settings
            __props__.__dict__["cloud_formation_tags"] = cloud_formation_tags
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["cluster_ingress_rule"] = cluster_ingress_rule
            __props__.__dict__["cluster_ingress_rule_id"] = cluster_ingress_rule_id
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["enable_detailed_monitoring"] = enable_detailed_monitoring
            __props__.__dict__["encrypt_root_block_device"] = encrypt_root_block_device
            __props__.__dict__["extra_node_security_groups"] = extra_node_security_groups
            __props__.__dict__["gpu"] = gpu
            __props__.__dict__["ignore_scaling_changes"] = ignore_scaling_changes
            __props__.__dict__["instance_profile"] = instance_profile
            __props__.__dict__["instance_profile_name"] = instance_profile_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kubelet_extra_args"] = kubelet_extra_args
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_template_tag_specifications"] = launch_template_tag_specifications
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["min_refresh_percentage"] = min_refresh_percentage
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["node_associate_public_ip_address"] = node_associate_public_ip_address
            __props__.__dict__["node_public_key"] = node_public_key
            __props__.__dict__["node_root_volume_delete_on_termination"] = node_root_volume_delete_on_termination
            __props__.__dict__["node_root_volume_encrypted"] = node_root_volume_encrypted
            __props__.__dict__["node_root_volume_iops"] = node_root_volume_iops
            __props__.__dict__["node_root_volume_size"] = node_root_volume_size
            __props__.__dict__["node_root_volume_throughput"] = node_root_volume_throughput
            __props__.__dict__["node_root_volume_type"] = node_root_volume_type
            __props__.__dict__["node_security_group"] = node_security_group
            __props__.__dict__["node_security_group_id"] = node_security_group_id
            __props__.__dict__["node_subnet_ids"] = node_subnet_ids
            __props__.__dict__["node_user_data"] = node_user_data
            __props__.__dict__["node_user_data_override"] = node_user_data_override
            __props__.__dict__["nodeadm_extra_options"] = nodeadm_extra_options
            __props__.__dict__["operating_system"] = operating_system
            __props__.__dict__["spot_price"] = spot_price
            __props__.__dict__["taints"] = taints
            __props__.__dict__["version"] = version
            __props__.__dict__["auto_scaling_group"] = None
        super(NodeGroupV2, __self__).__init__(
            'eks:index:NodeGroupV2',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="autoScalingGroup")
    def auto_scaling_group(self) -> pulumi.Output['pulumi_aws.autoscaling.Group']:
        """
        The AutoScalingGroup for the Node group.
        """
        return pulumi.get(self, "auto_scaling_group")

    @property
    @pulumi.getter(name="extraNodeSecurityGroups")
    def extra_node_security_groups(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.SecurityGroup']]:
        """
        The additional security groups for the node group that captures user-specific rules.
        """
        return pulumi.get(self, "extra_node_security_groups")

    @property
    @pulumi.getter(name="nodeSecurityGroup")
    def node_security_group(self) -> pulumi.Output[Optional['pulumi_aws.ec2.SecurityGroup']]:
        """
        The security group for the node group to communicate with the cluster, or undefined if using `nodeSecurityGroupId`.
        """
        return pulumi.get(self, "node_security_group")

    @property
    @pulumi.getter(name="nodeSecurityGroupId")
    def node_security_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the security group for the node group to communicate with the cluster.
        """
        return pulumi.get(self, "node_security_group_id")

