# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/BookingAllocations.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg

class BookingAllocations(genpy.Message):
  _md5sum = "eab114295b1b2988539445beb057ee3c"
  _type = "digitaleye_msgs/BookingAllocations"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Booking Allocations

# booking id linked to allocation
uint32 booking_id

# id of allocations
uint32 id

# agent registration linked to the booking
uint64 agent_reg

# flights included in booking, use FLIGHTS_ constants below
uint32 flights

uint32 FLIGHTS_IN     = 0
uint32 FLIGHTS_OUT    = 1
uint32 FLIGHTS_IN_OUT = 2


digitaleye_msgs/Allocation[] allocations

================================================================================
MSG: digitaleye_msgs/Allocation
# Allocation in 4D

# allocation id
uint32 id

# action id, of which the allocation is part of
uint32 action_id

# allocation for the following entity id(s)
uint64[] entity_id

# allocation for the following entity class(es) (can be empty), use ENT_CLASS
uint32[] entity_class

# 3D Volume of allocation
digitaleye_msgs/Volume[] volume

# volume block ids
uint32[] block_ids

# start time of allocation (included) (Epoch timestamp in seconds)
uint64 start

# end time of allocation (included) (Epoch timestamp in seconds)
uint64 end

# duration allocation (included) (seconds)
uint64 duration

# category of allocation, use BLOCK_CAT_ in Constants Allocations
uint32 category

# command on allocation entry
digitaleye_msgs/VehicleCommand[] commands

# action dependencies
uint32[] action_dep

================================================================================
MSG: digitaleye_msgs/Volume
# Volume definition

# Volume shape, use SHAPE_
uint32 shape

uint32 SHAPE_PRISM=1
uint32 SHAPE_SPHERE=2
uint32 SHAPE_CYLINDER=3

# Parameters of the volume
uint32[] int_param
float64[] float_param

# Prism: characterised by 2 bases of same nb of point (x,y,z), ordered the same way
# size of float param is nb points*PRISM_FLOAT_PARAM_SIZE*2
# (number of points * number of coordinates/float param per point  * 2 bases)
# Prism int parameters indexes
uint32 PRISM_INT_NB_POINTS=0
uint32 PRISM_INT_PARAM_SIZE=1 # constant (not index) - size of int_param
# Prism float parameters indexes
uint32 PRISM_FLOAT_X=0
uint32 PRISM_FLOAT_Y=1
uint32 PRISM_FLOAT_Z=2
uint32 PRISM_FLOAT_PARAM_SIZE=3  # constant (not index) - size of each point / nb of float params per point

# Sphere: characterised by radius and centre point (x,y,z)
# Sphere no int parameters
uint32 SPHERE_INT_PARAM_SIZE=0 # constant (not index) - size of int_param
# Sphere float parameters indexes
uint32 SPHERE_FLOAT_RADIUS=0
uint32 SPHERE_FLOAT_X=1
uint32 SPHERE_FLOAT_Y=2
uint32 SPHERE_FLOAT_Z=3
uint32 SPHERE_FLOAT_PARAM_SIZE=4 # constant (not index) - size of float_param

# Cylinder: characterised by 2 bases with each:
#   centre point (x,y,z), radius, termination: spherical/flat (use TERM_)
# Cylinder int parameters indexes
uint32 CYLINDER_INT_TERM1=0
uint32 CYLINDER_INT_TERM2=1
uint32 CYLINDER_INT_PARAM_SIZE=2 # constant (not index) - size of int_param

# Cylinder float parameters indexes
uint32 CYLINDER_FLOAT_X1=0
uint32 CYLINDER_FLOAT_Y1=1
uint32 CYLINDER_FLOAT_Z1=2
uint32 CYLINDER_FLOAT_RADIUS1=3
uint32 CYLINDER_FLOAT_X2=4
uint32 CYLINDER_FLOAT_Y2=5
uint32 CYLINDER_FLOAT_Z2=6
uint32 CYLINDER_FLOAT_RADIUS2=7
uint32 CYLINDER_FLOAT_PARAM_SIZE=8 # constant (not index) - size of float_param

# termination of volume, spherical or flat
uint32 TERM_SPHERE=0
uint32 TERM_FLAT=1

================================================================================
MSG: digitaleye_msgs/VehicleCommand
# definition of vehicle commands

# The command, CMD_, see below
uint32 command

# Command
uint32 CMD_GOTO=0
uint32 CMD_TAKEOFF=1
uint32 CMD_LAND=2
uint32 CMD_STOP=3
uint32 CMD_CHANGE_YAW=4
uint32 CMD_CHANGE_SPEED=5
uint32 CMD_JUMP_CMD=6

# Parameters of the command
uint32 delay # delay of the command in second, mostly useful for missions
uint32[] int_param
float64[] float_param

## GOTO: Frame, use FRAME_; yaw angle in degrees, see specified frame;
## x, y, z see specified frame; ground speed m/s
# GOTO int parameters indexes
uint32 GOTO_INT_FRAME=0
uint32 GOTO_INT_YAW=1
uint32 GOTO_INT_PARAM_SIZE=2 # constant (not index) - size of int_param
# GOTO float parameters indexes
uint32 GOTO_FLOAT_X=0
uint32 GOTO_FLOAT_Y=1
uint32 GOTO_FLOAT_Z=2
uint32 GOTO_FLOAT_SPEED=3
uint32 GOTO_FLOAT_PARAM_SIZE=4 # constant (not index) - size of float_param

## TAKEOFF: Frame, use FRAME_; yaw angle in degrees, see specified frame;
## z see specified frame; vertical speed m/s
# TAKEOFF int parameters indexes
uint32 TAKEOFF_INT_FRAME=0
uint32 TAKEOFF_INT_YAW=1
uint32 TAKEOFF_INT_PARAM_SIZE=2 # constant (not index) - size of int_param
# TAKEOFF float parameters indexes
uint32 TAKEOFF_FLOAT_Z=0
uint32 TAKEOFF_FLOAT_SPEED=1
uint32 TAKEOFF_FLOAT_PARAM_SIZE=2 # constant (not index) - size of float_param

## LAND: no parameters
uint32 LAND_INT_PARAM_SIZE=0 # constant (not index) - size of int_param
uint32 LAND_FLOAT_PARAM_SIZE=0 # constant (not index) - size of float_param

## STOP: no parameters
uint32 STOP_INT_PARAM_SIZE=0 # constant (not index) - size of int_param
uint32 STOP_FLOAT_PARAM_SIZE=0 # constant (not index) - size of float_param

## CHANGE_YAW: Frame, use YAW_FRAME_; yaw angle in degrees, see specified frame; speed deg/s
# CHANGE_YAW int parameters indexes
uint32 CHANGE_YAW_INT_FRAME=0
uint32 CHANGE_YAW_INT_YAW=1
uint32 CHANGE_YAW_INT_SPEED=2
uint32 CHANGE_YAW_INT_PARAM_SIZE=3 # constant (not index) - size of int_param
# CHANGE_YAW no float parameters
uint32 CHANGE_YAW_FLOAT_PARAM_SIZE=0 # constant (not index) - size of float_param

## CHANGE_SPEED: ground speed in m/s
uint32 CHANGE_SPEED_INT_PARAM_SIZE=0 # constant (not index) - size of int_param
# CHANGE_SPEED float parameters indexes
uint32 CHANGE_SPEED_FLOAT_Z=0
uint32 CHANGE_SPEED_FLOAT_PARAM_SIZE=1 # constant (not index) - size of float_param

## JUMP_CMD: Command number to jump to; repeat giving the number of repeats
# JUMP_CMD int parameters indexes
uint32 JUMP_CMD_INT_CMD_NB=0
uint32 JUMP_CMD_INT_REPEAT=1
uint32 JUMP_CMD_INT_PARAM_SIZE=2 # constant (not index) - size of int_param
# JUMP_CMD no float parameters
uint32 JUMP_CMD_FLOAT_PARAM_SIZE=0 # constant (not index) - size of float_param

## FRAME:
uint32 FRAME_PORTAL = 0 # Portal coordinate frame, coordinates in m, absolute yaw (-1 to not specify)
uint32 FRAME_GLOBAL = 1 # WGS84 coordinate frame (deg) + MSL altitude (m), absolute yaw (-1 to not specify)
uint32 FRAME_FRD = 2 # FRD local frame, x: Forward, y: Right, z: Down (m), relative yaw

"""
  # Pseudo-constants
  FLIGHTS_IN = 0
  FLIGHTS_OUT = 1
  FLIGHTS_IN_OUT = 2

  __slots__ = ['booking_id','id','agent_reg','flights','allocations']
  _slot_types = ['uint32','uint32','uint64','uint32','digitaleye_msgs/Allocation[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       booking_id,id,agent_reg,flights,allocations

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(BookingAllocations, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.booking_id is None:
        self.booking_id = 0
      if self.id is None:
        self.id = 0
      if self.agent_reg is None:
        self.agent_reg = 0
      if self.flights is None:
        self.flights = 0
      if self.allocations is None:
        self.allocations = []
    else:
      self.booking_id = 0
      self.id = 0
      self.agent_reg = 0
      self.flights = 0
      self.allocations = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_2IQI().pack(_x.booking_id, _x.id, _x.agent_reg, _x.flights))
      length = len(self.allocations)
      buff.write(_struct_I.pack(length))
      for val1 in self.allocations:
        _x = val1
        buff.write(_get_struct_2I().pack(_x.id, _x.action_id))
        length = len(val1.entity_id)
        buff.write(_struct_I.pack(length))
        pattern = '<%sQ'%length
        buff.write(struct.Struct(pattern).pack(*val1.entity_id))
        length = len(val1.entity_class)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*val1.entity_class))
        length = len(val1.volume)
        buff.write(_struct_I.pack(length))
        for val2 in val1.volume:
          _x = val2.shape
          buff.write(_get_struct_I().pack(_x))
          length = len(val2.int_param)
          buff.write(_struct_I.pack(length))
          pattern = '<%sI'%length
          buff.write(struct.Struct(pattern).pack(*val2.int_param))
          length = len(val2.float_param)
          buff.write(_struct_I.pack(length))
          pattern = '<%sd'%length
          buff.write(struct.Struct(pattern).pack(*val2.float_param))
        length = len(val1.block_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*val1.block_ids))
        _x = val1
        buff.write(_get_struct_3QI().pack(_x.start, _x.end, _x.duration, _x.category))
        length = len(val1.commands)
        buff.write(_struct_I.pack(length))
        for val2 in val1.commands:
          _x = val2
          buff.write(_get_struct_2I().pack(_x.command, _x.delay))
          length = len(val2.int_param)
          buff.write(_struct_I.pack(length))
          pattern = '<%sI'%length
          buff.write(struct.Struct(pattern).pack(*val2.int_param))
          length = len(val2.float_param)
          buff.write(_struct_I.pack(length))
          pattern = '<%sd'%length
          buff.write(struct.Struct(pattern).pack(*val2.float_param))
        length = len(val1.action_dep)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*val1.action_dep))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.allocations is None:
        self.allocations = None
      end = 0
      _x = self
      start = end
      end += 20
      (_x.booking_id, _x.id, _x.agent_reg, _x.flights,) = _get_struct_2IQI().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.allocations = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Allocation()
        _x = val1
        start = end
        end += 8
        (_x.id, _x.action_id,) = _get_struct_2I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sQ'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.entity_id = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.entity_class = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.volume = []
        for i in range(0, length):
          val2 = digitaleye_msgs.msg.Volume()
          start = end
          end += 4
          (val2.shape,) = _get_struct_I().unpack(str[start:end])
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          pattern = '<%sI'%length
          start = end
          s = struct.Struct(pattern)
          end += s.size
          val2.int_param = s.unpack(str[start:end])
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          pattern = '<%sd'%length
          start = end
          s = struct.Struct(pattern)
          end += s.size
          val2.float_param = s.unpack(str[start:end])
          val1.volume.append(val2)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.block_ids = s.unpack(str[start:end])
        _x = val1
        start = end
        end += 28
        (_x.start, _x.end, _x.duration, _x.category,) = _get_struct_3QI().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.commands = []
        for i in range(0, length):
          val2 = digitaleye_msgs.msg.VehicleCommand()
          _x = val2
          start = end
          end += 8
          (_x.command, _x.delay,) = _get_struct_2I().unpack(str[start:end])
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          pattern = '<%sI'%length
          start = end
          s = struct.Struct(pattern)
          end += s.size
          val2.int_param = s.unpack(str[start:end])
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          pattern = '<%sd'%length
          start = end
          s = struct.Struct(pattern)
          end += s.size
          val2.float_param = s.unpack(str[start:end])
          val1.commands.append(val2)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.action_dep = s.unpack(str[start:end])
        self.allocations.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_2IQI().pack(_x.booking_id, _x.id, _x.agent_reg, _x.flights))
      length = len(self.allocations)
      buff.write(_struct_I.pack(length))
      for val1 in self.allocations:
        _x = val1
        buff.write(_get_struct_2I().pack(_x.id, _x.action_id))
        length = len(val1.entity_id)
        buff.write(_struct_I.pack(length))
        pattern = '<%sQ'%length
        buff.write(val1.entity_id.tostring())
        length = len(val1.entity_class)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(val1.entity_class.tostring())
        length = len(val1.volume)
        buff.write(_struct_I.pack(length))
        for val2 in val1.volume:
          _x = val2.shape
          buff.write(_get_struct_I().pack(_x))
          length = len(val2.int_param)
          buff.write(_struct_I.pack(length))
          pattern = '<%sI'%length
          buff.write(val2.int_param.tostring())
          length = len(val2.float_param)
          buff.write(_struct_I.pack(length))
          pattern = '<%sd'%length
          buff.write(val2.float_param.tostring())
        length = len(val1.block_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(val1.block_ids.tostring())
        _x = val1
        buff.write(_get_struct_3QI().pack(_x.start, _x.end, _x.duration, _x.category))
        length = len(val1.commands)
        buff.write(_struct_I.pack(length))
        for val2 in val1.commands:
          _x = val2
          buff.write(_get_struct_2I().pack(_x.command, _x.delay))
          length = len(val2.int_param)
          buff.write(_struct_I.pack(length))
          pattern = '<%sI'%length
          buff.write(val2.int_param.tostring())
          length = len(val2.float_param)
          buff.write(_struct_I.pack(length))
          pattern = '<%sd'%length
          buff.write(val2.float_param.tostring())
        length = len(val1.action_dep)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(val1.action_dep.tostring())
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.allocations is None:
        self.allocations = None
      end = 0
      _x = self
      start = end
      end += 20
      (_x.booking_id, _x.id, _x.agent_reg, _x.flights,) = _get_struct_2IQI().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.allocations = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Allocation()
        _x = val1
        start = end
        end += 8
        (_x.id, _x.action_id,) = _get_struct_2I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sQ'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.entity_id = numpy.frombuffer(str[start:end], dtype=numpy.uint64, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.entity_class = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.volume = []
        for i in range(0, length):
          val2 = digitaleye_msgs.msg.Volume()
          start = end
          end += 4
          (val2.shape,) = _get_struct_I().unpack(str[start:end])
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          pattern = '<%sI'%length
          start = end
          s = struct.Struct(pattern)
          end += s.size
          val2.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          pattern = '<%sd'%length
          start = end
          s = struct.Struct(pattern)
          end += s.size
          val2.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
          val1.volume.append(val2)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.block_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        _x = val1
        start = end
        end += 28
        (_x.start, _x.end, _x.duration, _x.category,) = _get_struct_3QI().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.commands = []
        for i in range(0, length):
          val2 = digitaleye_msgs.msg.VehicleCommand()
          _x = val2
          start = end
          end += 8
          (_x.command, _x.delay,) = _get_struct_2I().unpack(str[start:end])
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          pattern = '<%sI'%length
          start = end
          s = struct.Struct(pattern)
          end += s.size
          val2.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          pattern = '<%sd'%length
          start = end
          s = struct.Struct(pattern)
          end += s.size
          val2.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
          val1.commands.append(val2)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.action_dep = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        self.allocations.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_2I = None
def _get_struct_2I():
    global _struct_2I
    if _struct_2I is None:
        _struct_2I = struct.Struct("<2I")
    return _struct_2I
_struct_2IQI = None
def _get_struct_2IQI():
    global _struct_2IQI
    if _struct_2IQI is None:
        _struct_2IQI = struct.Struct("<2IQI")
    return _struct_2IQI
_struct_3QI = None
def _get_struct_3QI():
    global _struct_3QI
    if _struct_3QI is None:
        _struct_3QI = struct.Struct("<3QI")
    return _struct_3QI
