# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/BreachPicture.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg

class BreachPicture(genpy.Message):
  _md5sum = "fb56d9b6dd6ce63abba83807f44b82ec"
  _type = "digitaleye_msgs/BreachPicture"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Breach picture definition

# list of breach(es)
digitaleye_msgs/Breach[] breach

================================================================================
MSG: digitaleye_msgs/Breach
# Breach definition
uint64 entity_id

# local position, m
float64 x
float64 y
float64 z

# conformance status, use CONF_ constants
uint32 conf_status

# current sector(s) of the entity (i.e. presence)
uint32[] sector_ids
"""
  __slots__ = ['breach']
  _slot_types = ['digitaleye_msgs/Breach[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       breach

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(BreachPicture, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.breach is None:
        self.breach = []
    else:
      self.breach = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      length = len(self.breach)
      buff.write(_struct_I.pack(length))
      for val1 in self.breach:
        _x = val1
        buff.write(_get_struct_Q3dI().pack(_x.entity_id, _x.x, _x.y, _x.z, _x.conf_status))
        length = len(val1.sector_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*val1.sector_ids))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.breach is None:
        self.breach = None
      end = 0
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.breach = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Breach()
        _x = val1
        start = end
        end += 36
        (_x.entity_id, _x.x, _x.y, _x.z, _x.conf_status,) = _get_struct_Q3dI().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.sector_ids = s.unpack(str[start:end])
        self.breach.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      length = len(self.breach)
      buff.write(_struct_I.pack(length))
      for val1 in self.breach:
        _x = val1
        buff.write(_get_struct_Q3dI().pack(_x.entity_id, _x.x, _x.y, _x.z, _x.conf_status))
        length = len(val1.sector_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(val1.sector_ids.tostring())
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.breach is None:
        self.breach = None
      end = 0
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.breach = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Breach()
        _x = val1
        start = end
        end += 36
        (_x.entity_id, _x.x, _x.y, _x.z, _x.conf_status,) = _get_struct_Q3dI().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.sector_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        self.breach.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_Q3dI = None
def _get_struct_Q3dI():
    global _struct_Q3dI
    if _struct_Q3dI is None:
        _struct_Q3dI = struct.Struct("<Q3dI")
    return _struct_Q3dI
