# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/ConformanceUavStatus.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import geometry_msgs.msg

class ConformanceUavStatus(genpy.Message):
  _md5sum = "fbc0b6a86597900c521a56f7eba691f7"
  _type = "digitaleye_msgs/ConformanceUavStatus"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Conformance status details for a UAV

# unique internal UAV id
uint64 uav_id

# state of the conformance of the UAV
# using CONF_ constants below
uint32 conformance_state

# indicator of the position of the UAV
# - true: inside Managed Volume
# - false: outside of Managed Volume
bool is_inside_MV

# coordinates of the object’s estimated position
# in the local reference frame (meters)
geometry_msgs/Point position

uint32 CONF_MIN_STATE=9200 # for bounds check
uint32 CONF_KO_UNKNOWN=9200
uint32 CONF_KO_AIR_ENTRY=9201
uint32 CONF_KO_GROUND_ENTRY=9202
uint32 CONF_KO_ALL_ENTRIES=9203
uint32 CONF_KO_FLIGHTPATH=9204
uint32 CONF_OK_AIR_ENTRY=9205
uint32 CONF_OK_GROUND_ENTRY=9206
uint32 CONF_OK_FLIGHTPATH=9207
uint32 CONF_OK_AIR_EXIT=9208
uint32 CONF_OK_GROUND=9209
uint32 CONF_OK_AIR=9210
uint32 CONF_READY_TO_LAND=9211
uint32 CONF_READY_TO_FLY_OUT=9212
uint32 CONF_MAX_STATE=9212 # for bounds check

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z
"""
  # Pseudo-constants
  CONF_MIN_STATE = 9200
  CONF_KO_UNKNOWN = 9200
  CONF_KO_AIR_ENTRY = 9201
  CONF_KO_GROUND_ENTRY = 9202
  CONF_KO_ALL_ENTRIES = 9203
  CONF_KO_FLIGHTPATH = 9204
  CONF_OK_AIR_ENTRY = 9205
  CONF_OK_GROUND_ENTRY = 9206
  CONF_OK_FLIGHTPATH = 9207
  CONF_OK_AIR_EXIT = 9208
  CONF_OK_GROUND = 9209
  CONF_OK_AIR = 9210
  CONF_READY_TO_LAND = 9211
  CONF_READY_TO_FLY_OUT = 9212
  CONF_MAX_STATE = 9212

  __slots__ = ['uav_id','conformance_state','is_inside_MV','position']
  _slot_types = ['uint64','uint32','bool','geometry_msgs/Point']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       uav_id,conformance_state,is_inside_MV,position

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(ConformanceUavStatus, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.uav_id is None:
        self.uav_id = 0
      if self.conformance_state is None:
        self.conformance_state = 0
      if self.is_inside_MV is None:
        self.is_inside_MV = False
      if self.position is None:
        self.position = geometry_msgs.msg.Point()
    else:
      self.uav_id = 0
      self.conformance_state = 0
      self.is_inside_MV = False
      self.position = geometry_msgs.msg.Point()

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_QIB3d().pack(_x.uav_id, _x.conformance_state, _x.is_inside_MV, _x.position.x, _x.position.y, _x.position.z))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.position is None:
        self.position = geometry_msgs.msg.Point()
      end = 0
      _x = self
      start = end
      end += 37
      (_x.uav_id, _x.conformance_state, _x.is_inside_MV, _x.position.x, _x.position.y, _x.position.z,) = _get_struct_QIB3d().unpack(str[start:end])
      self.is_inside_MV = bool(self.is_inside_MV)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_QIB3d().pack(_x.uav_id, _x.conformance_state, _x.is_inside_MV, _x.position.x, _x.position.y, _x.position.z))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.position is None:
        self.position = geometry_msgs.msg.Point()
      end = 0
      _x = self
      start = end
      end += 37
      (_x.uav_id, _x.conformance_state, _x.is_inside_MV, _x.position.x, _x.position.y, _x.position.z,) = _get_struct_QIB3d().unpack(str[start:end])
      self.is_inside_MV = bool(self.is_inside_MV)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_QIB3d = None
def _get_struct_QIB3d():
    global _struct_QIB3d
    if _struct_QIB3d is None:
        _struct_QIB3d = struct.Struct("<QIB3d")
    return _struct_QIB3d
