# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/ExtAction.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct


class ExtAction(genpy.Message):
  _md5sum = "82d82ee984bfa2f6a5bd7c0f3ed9d3eb"
  _type = "digitaleye_msgs/ExtAction"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# External Action definition

# action id
uint32 id

# action for the following entity id(s) (can be empty)
uint64[] entity_id

# Agent registration (can be empty)
string agent_reg

# start time of allocation (included) (Epoch timestamp in seconds)
uint64 start

# end time of allocation (included) (Epoch timestamp in seconds)
uint64 end

# duration of allocation (seconds)
uint64 duration

# category of action, use EXT_CAT_ below
uint32 category

uint32 EXT_CAT_FLIGHT_IN = 0
uint32 EXT_CAT_FLIGHT_OUT = 1
uint32 EXT_CAT_GROUND_IN = 2
uint32 EXT_CAT_GROUND_OUT = 3
uint32 EXT_CAT_GROUND_AIR_DELIV = 4
uint32 EXT_CAT_MANUAL_CHARGING = 5
uint32 EXT_CAT_TOUCH_AND_GO = 6
uint32 EXT_CAT_MVV = 7
"""
  # Pseudo-constants
  EXT_CAT_FLIGHT_IN = 0
  EXT_CAT_FLIGHT_OUT = 1
  EXT_CAT_GROUND_IN = 2
  EXT_CAT_GROUND_OUT = 3
  EXT_CAT_GROUND_AIR_DELIV = 4
  EXT_CAT_MANUAL_CHARGING = 5
  EXT_CAT_TOUCH_AND_GO = 6
  EXT_CAT_MVV = 7

  __slots__ = ['id','entity_id','agent_reg','start','end','duration','category']
  _slot_types = ['uint32','uint64[]','string','uint64','uint64','uint64','uint32']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       id,entity_id,agent_reg,start,end,duration,category

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(ExtAction, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.id is None:
        self.id = 0
      if self.entity_id is None:
        self.entity_id = []
      if self.agent_reg is None:
        self.agent_reg = ''
      if self.start is None:
        self.start = 0
      if self.end is None:
        self.end = 0
      if self.duration is None:
        self.duration = 0
      if self.category is None:
        self.category = 0
    else:
      self.id = 0
      self.entity_id = []
      self.agent_reg = ''
      self.start = 0
      self.end = 0
      self.duration = 0
      self.category = 0

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.id
      buff.write(_get_struct_I().pack(_x))
      length = len(self.entity_id)
      buff.write(_struct_I.pack(length))
      pattern = '<%sQ'%length
      buff.write(struct.Struct(pattern).pack(*self.entity_id))
      _x = self.agent_reg
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_3QI().pack(_x.start, _x.end, _x.duration, _x.category))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      start = end
      end += 4
      (self.id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sQ'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.entity_id = s.unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.agent_reg = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.agent_reg = str[start:end]
      _x = self
      start = end
      end += 28
      (_x.start, _x.end, _x.duration, _x.category,) = _get_struct_3QI().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.id
      buff.write(_get_struct_I().pack(_x))
      length = len(self.entity_id)
      buff.write(_struct_I.pack(length))
      pattern = '<%sQ'%length
      buff.write(self.entity_id.tostring())
      _x = self.agent_reg
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_3QI().pack(_x.start, _x.end, _x.duration, _x.category))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      end = 0
      start = end
      end += 4
      (self.id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      pattern = '<%sQ'%length
      start = end
      s = struct.Struct(pattern)
      end += s.size
      self.entity_id = numpy.frombuffer(str[start:end], dtype=numpy.uint64, count=length)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.agent_reg = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.agent_reg = str[start:end]
      _x = self
      start = end
      end += 28
      (_x.start, _x.end, _x.duration, _x.category,) = _get_struct_3QI().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3QI = None
def _get_struct_3QI():
    global _struct_3QI
    if _struct_3QI is None:
        _struct_3QI = struct.Struct("<3QI")
    return _struct_3QI
