# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/GNSSState.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg

class GNSSState(genpy.Message):
  _md5sum = "2a19cfc0a45b3c854f06a83290eb612b"
  _type = "digitaleye_msgs/GNSSState"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Describes the current state of a GNSS receiver/measurement

# Fix type of the satellite
uint32 sat_fix

# Number of visible satellites
uint32 num_sats

#Reported source of corrections
uint32 corr_source

# Last available measurement from the GNSS receiver
digitaleye_msgs/GNSSPosition measurement

================================================================================
MSG: digitaleye_msgs/GNSSPosition
# Description of a GNSS position reading

# Reported latitude of the receiver
float32 latitude

# Reported longitude of the receiver
float32 longitude

# Reported altitude of the receiver (WGS-84 Ellipsoid)
float32 altitude

# Reported altitude of the receiver (Mean Sea Level)
float32 altitude_msl

# Reported vertical dilution of precision
float32 vDOP

# Reported horizontal dilution of precision
float32 hDOP
"""
  __slots__ = ['sat_fix','num_sats','corr_source','measurement']
  _slot_types = ['uint32','uint32','uint32','digitaleye_msgs/GNSSPosition']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       sat_fix,num_sats,corr_source,measurement

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(GNSSState, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.sat_fix is None:
        self.sat_fix = 0
      if self.num_sats is None:
        self.num_sats = 0
      if self.corr_source is None:
        self.corr_source = 0
      if self.measurement is None:
        self.measurement = digitaleye_msgs.msg.GNSSPosition()
    else:
      self.sat_fix = 0
      self.num_sats = 0
      self.corr_source = 0
      self.measurement = digitaleye_msgs.msg.GNSSPosition()

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self
      buff.write(_get_struct_3I6f().pack(_x.sat_fix, _x.num_sats, _x.corr_source, _x.measurement.latitude, _x.measurement.longitude, _x.measurement.altitude, _x.measurement.altitude_msl, _x.measurement.vDOP, _x.measurement.hDOP))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.measurement is None:
        self.measurement = digitaleye_msgs.msg.GNSSPosition()
      end = 0
      _x = self
      start = end
      end += 36
      (_x.sat_fix, _x.num_sats, _x.corr_source, _x.measurement.latitude, _x.measurement.longitude, _x.measurement.altitude, _x.measurement.altitude_msl, _x.measurement.vDOP, _x.measurement.hDOP,) = _get_struct_3I6f().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self
      buff.write(_get_struct_3I6f().pack(_x.sat_fix, _x.num_sats, _x.corr_source, _x.measurement.latitude, _x.measurement.longitude, _x.measurement.altitude, _x.measurement.altitude_msl, _x.measurement.vDOP, _x.measurement.hDOP))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.measurement is None:
        self.measurement = digitaleye_msgs.msg.GNSSPosition()
      end = 0
      _x = self
      start = end
      end += 36
      (_x.sat_fix, _x.num_sats, _x.corr_source, _x.measurement.latitude, _x.measurement.longitude, _x.measurement.altitude, _x.measurement.altitude_msl, _x.measurement.vDOP, _x.measurement.hDOP,) = _get_struct_3I6f().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I6f = None
def _get_struct_3I6f():
    global _struct_3I6f
    if _struct_3I6f is None:
        _struct_3I6f = struct.Struct("<3I6f")
    return _struct_3I6f
