# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/LayoutDefinition.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg

class LayoutDefinition(genpy.Message):
  _md5sum = "7d61b7353b4e48ba32c6c018c98c454a"
  _type = "digitaleye_msgs/LayoutDefinition"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Definition of whole Layout of Managed Volume related spaces:

# List of volumes defining the entirety of the Managed Volume
# First object must include ground if any ground is included
digitaleye_msgs/Volume[] managed_volume

# Permanent Sectors - Pre-defined volumes allocated to specific purposes such as boarding
digitaleye_msgs/Sector[] permanent_sectors

# Allocable Sectors - Volumes designated for partial allocation to specific purposes
digitaleye_msgs/Sector[] allocable_sectors

# Allocable Templates - Volumes designated for allocation to specific purposes
digitaleye_msgs/Block[] allocable_templates

# Volume for handovers - must be encompassing volume outside of the Managed Volume
digitaleye_msgs/Volume[] handover_volume

# default radius of proximity for handover sphere (meters)
float32 handover_radius

# default radius of proximity for flight corridor cylinder (meters)
float32 flight_radius

================================================================================
MSG: digitaleye_msgs/Volume
# Volume definition

# Volume shape, use SHAPE_
uint32 shape

uint32 SHAPE_PRISM=1
uint32 SHAPE_SPHERE=2
uint32 SHAPE_CYLINDER=3

# Parameters of the volume
uint32[] int_param
float64[] float_param

# Prism: characterised by 2 bases of same nb of point (x,y,z), ordered the same way
# size of float param is nb points*PRISM_FLOAT_PARAM_SIZE*2
# (number of points * number of coordinates/float param per point  * 2 bases)
# Prism int parameters indexes
uint32 PRISM_INT_NB_POINTS=0
uint32 PRISM_INT_PARAM_SIZE=1 # constant (not index) - size of int_param
# Prism float parameters indexes
uint32 PRISM_FLOAT_X=0
uint32 PRISM_FLOAT_Y=1
uint32 PRISM_FLOAT_Z=2
uint32 PRISM_FLOAT_PARAM_SIZE=3  # constant (not index) - size of each point / nb of float params per point

# Sphere: characterised by radius and centre point (x,y,z)
# Sphere no int parameters
uint32 SPHERE_INT_PARAM_SIZE=0 # constant (not index) - size of int_param
# Sphere float parameters indexes
uint32 SPHERE_FLOAT_RADIUS=0
uint32 SPHERE_FLOAT_X=1
uint32 SPHERE_FLOAT_Y=2
uint32 SPHERE_FLOAT_Z=3
uint32 SPHERE_FLOAT_PARAM_SIZE=4 # constant (not index) - size of float_param

# Cylinder: characterised by 2 bases with each:
#   centre point (x,y,z), radius, termination: spherical/flat (use TERM_)
# Cylinder int parameters indexes
uint32 CYLINDER_INT_TERM1=0
uint32 CYLINDER_INT_TERM2=1
uint32 CYLINDER_INT_PARAM_SIZE=2 # constant (not index) - size of int_param

# Cylinder float parameters indexes
uint32 CYLINDER_FLOAT_X1=0
uint32 CYLINDER_FLOAT_Y1=1
uint32 CYLINDER_FLOAT_Z1=2
uint32 CYLINDER_FLOAT_RADIUS1=3
uint32 CYLINDER_FLOAT_X2=4
uint32 CYLINDER_FLOAT_Y2=5
uint32 CYLINDER_FLOAT_Z2=6
uint32 CYLINDER_FLOAT_RADIUS2=7
uint32 CYLINDER_FLOAT_PARAM_SIZE=8 # constant (not index) - size of float_param

# termination of volume, spherical or flat
uint32 TERM_SPHERE=0
uint32 TERM_FLAT=1

================================================================================
MSG: digitaleye_msgs/Sector
#Sector definition

# sector id
uint32 id

#Volume definition
digitaleye_msgs/Volume volume

# sector category, use SECTOR_CAT_ in allocations constants
uint32 category

================================================================================
MSG: digitaleye_msgs/Block
# Block definition

# unique id
uint32 id

# other linked block ids
uint32[] link_ids

# Volume definition
digitaleye_msgs/Volume volume

# category of allocations eligible to use this Block, use BLOCK_CAT_ in ConstantsAllocations
uint32[] eligible_categories

# specific entities eligible to use this Block, can be empty if not restricted
string[] eligible_entities
"""
  __slots__ = ['managed_volume','permanent_sectors','allocable_sectors','allocable_templates','handover_volume','handover_radius','flight_radius']
  _slot_types = ['digitaleye_msgs/Volume[]','digitaleye_msgs/Sector[]','digitaleye_msgs/Sector[]','digitaleye_msgs/Block[]','digitaleye_msgs/Volume[]','float32','float32']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       managed_volume,permanent_sectors,allocable_sectors,allocable_templates,handover_volume,handover_radius,flight_radius

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(LayoutDefinition, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.managed_volume is None:
        self.managed_volume = []
      if self.permanent_sectors is None:
        self.permanent_sectors = []
      if self.allocable_sectors is None:
        self.allocable_sectors = []
      if self.allocable_templates is None:
        self.allocable_templates = []
      if self.handover_volume is None:
        self.handover_volume = []
      if self.handover_radius is None:
        self.handover_radius = 0.
      if self.flight_radius is None:
        self.flight_radius = 0.
    else:
      self.managed_volume = []
      self.permanent_sectors = []
      self.allocable_sectors = []
      self.allocable_templates = []
      self.handover_volume = []
      self.handover_radius = 0.
      self.flight_radius = 0.

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      length = len(self.managed_volume)
      buff.write(_struct_I.pack(length))
      for val1 in self.managed_volume:
        _x = val1.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(val1.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*val1.int_param))
        length = len(val1.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(struct.Struct(pattern).pack(*val1.float_param))
      length = len(self.permanent_sectors)
      buff.write(_struct_I.pack(length))
      for val1 in self.permanent_sectors:
        _x = val1.id
        buff.write(_get_struct_I().pack(_x))
        _v1 = val1.volume
        _x = _v1.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(_v1.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*_v1.int_param))
        length = len(_v1.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(struct.Struct(pattern).pack(*_v1.float_param))
        _x = val1.category
        buff.write(_get_struct_I().pack(_x))
      length = len(self.allocable_sectors)
      buff.write(_struct_I.pack(length))
      for val1 in self.allocable_sectors:
        _x = val1.id
        buff.write(_get_struct_I().pack(_x))
        _v2 = val1.volume
        _x = _v2.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(_v2.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*_v2.int_param))
        length = len(_v2.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(struct.Struct(pattern).pack(*_v2.float_param))
        _x = val1.category
        buff.write(_get_struct_I().pack(_x))
      length = len(self.allocable_templates)
      buff.write(_struct_I.pack(length))
      for val1 in self.allocable_templates:
        _x = val1.id
        buff.write(_get_struct_I().pack(_x))
        length = len(val1.link_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*val1.link_ids))
        _v3 = val1.volume
        _x = _v3.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(_v3.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*_v3.int_param))
        length = len(_v3.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(struct.Struct(pattern).pack(*_v3.float_param))
        length = len(val1.eligible_categories)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*val1.eligible_categories))
        length = len(val1.eligible_entities)
        buff.write(_struct_I.pack(length))
        for val2 in val1.eligible_entities:
          length = len(val2)
          if python3 or type(val2) == unicode:
            val2 = val2.encode('utf-8')
            length = len(val2)
          buff.write(struct.Struct('<I%ss'%length).pack(length, val2))
      length = len(self.handover_volume)
      buff.write(_struct_I.pack(length))
      for val1 in self.handover_volume:
        _x = val1.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(val1.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*val1.int_param))
        length = len(val1.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(struct.Struct(pattern).pack(*val1.float_param))
      _x = self
      buff.write(_get_struct_2f().pack(_x.handover_radius, _x.flight_radius))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.managed_volume is None:
        self.managed_volume = None
      if self.permanent_sectors is None:
        self.permanent_sectors = None
      if self.allocable_sectors is None:
        self.allocable_sectors = None
      if self.allocable_templates is None:
        self.allocable_templates = None
      if self.handover_volume is None:
        self.handover_volume = None
      end = 0
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.managed_volume = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Volume()
        start = end
        end += 4
        (val1.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.int_param = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.float_param = s.unpack(str[start:end])
        self.managed_volume.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.permanent_sectors = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Sector()
        start = end
        end += 4
        (val1.id,) = _get_struct_I().unpack(str[start:end])
        _v4 = val1.volume
        start = end
        end += 4
        (_v4.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v4.int_param = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v4.float_param = s.unpack(str[start:end])
        start = end
        end += 4
        (val1.category,) = _get_struct_I().unpack(str[start:end])
        self.permanent_sectors.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.allocable_sectors = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Sector()
        start = end
        end += 4
        (val1.id,) = _get_struct_I().unpack(str[start:end])
        _v5 = val1.volume
        start = end
        end += 4
        (_v5.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v5.int_param = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v5.float_param = s.unpack(str[start:end])
        start = end
        end += 4
        (val1.category,) = _get_struct_I().unpack(str[start:end])
        self.allocable_sectors.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.allocable_templates = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Block()
        start = end
        end += 4
        (val1.id,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.link_ids = s.unpack(str[start:end])
        _v6 = val1.volume
        start = end
        end += 4
        (_v6.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v6.int_param = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v6.float_param = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.eligible_categories = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.eligible_entities = []
        for i in range(0, length):
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2 = str[start:end].decode('utf-8', 'rosmsg')
          else:
            val2 = str[start:end]
          val1.eligible_entities.append(val2)
        self.allocable_templates.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.handover_volume = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Volume()
        start = end
        end += 4
        (val1.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.int_param = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.float_param = s.unpack(str[start:end])
        self.handover_volume.append(val1)
      _x = self
      start = end
      end += 8
      (_x.handover_radius, _x.flight_radius,) = _get_struct_2f().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      length = len(self.managed_volume)
      buff.write(_struct_I.pack(length))
      for val1 in self.managed_volume:
        _x = val1.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(val1.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(val1.int_param.tostring())
        length = len(val1.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(val1.float_param.tostring())
      length = len(self.permanent_sectors)
      buff.write(_struct_I.pack(length))
      for val1 in self.permanent_sectors:
        _x = val1.id
        buff.write(_get_struct_I().pack(_x))
        _v7 = val1.volume
        _x = _v7.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(_v7.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(_v7.int_param.tostring())
        length = len(_v7.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(_v7.float_param.tostring())
        _x = val1.category
        buff.write(_get_struct_I().pack(_x))
      length = len(self.allocable_sectors)
      buff.write(_struct_I.pack(length))
      for val1 in self.allocable_sectors:
        _x = val1.id
        buff.write(_get_struct_I().pack(_x))
        _v8 = val1.volume
        _x = _v8.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(_v8.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(_v8.int_param.tostring())
        length = len(_v8.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(_v8.float_param.tostring())
        _x = val1.category
        buff.write(_get_struct_I().pack(_x))
      length = len(self.allocable_templates)
      buff.write(_struct_I.pack(length))
      for val1 in self.allocable_templates:
        _x = val1.id
        buff.write(_get_struct_I().pack(_x))
        length = len(val1.link_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(val1.link_ids.tostring())
        _v9 = val1.volume
        _x = _v9.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(_v9.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(_v9.int_param.tostring())
        length = len(_v9.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(_v9.float_param.tostring())
        length = len(val1.eligible_categories)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(val1.eligible_categories.tostring())
        length = len(val1.eligible_entities)
        buff.write(_struct_I.pack(length))
        for val2 in val1.eligible_entities:
          length = len(val2)
          if python3 or type(val2) == unicode:
            val2 = val2.encode('utf-8')
            length = len(val2)
          buff.write(struct.Struct('<I%ss'%length).pack(length, val2))
      length = len(self.handover_volume)
      buff.write(_struct_I.pack(length))
      for val1 in self.handover_volume:
        _x = val1.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(val1.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(val1.int_param.tostring())
        length = len(val1.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(val1.float_param.tostring())
      _x = self
      buff.write(_get_struct_2f().pack(_x.handover_radius, _x.flight_radius))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.managed_volume is None:
        self.managed_volume = None
      if self.permanent_sectors is None:
        self.permanent_sectors = None
      if self.allocable_sectors is None:
        self.allocable_sectors = None
      if self.allocable_templates is None:
        self.allocable_templates = None
      if self.handover_volume is None:
        self.handover_volume = None
      end = 0
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.managed_volume = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Volume()
        start = end
        end += 4
        (val1.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
        self.managed_volume.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.permanent_sectors = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Sector()
        start = end
        end += 4
        (val1.id,) = _get_struct_I().unpack(str[start:end])
        _v10 = val1.volume
        start = end
        end += 4
        (_v10.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v10.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v10.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
        start = end
        end += 4
        (val1.category,) = _get_struct_I().unpack(str[start:end])
        self.permanent_sectors.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.allocable_sectors = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Sector()
        start = end
        end += 4
        (val1.id,) = _get_struct_I().unpack(str[start:end])
        _v11 = val1.volume
        start = end
        end += 4
        (_v11.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v11.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v11.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
        start = end
        end += 4
        (val1.category,) = _get_struct_I().unpack(str[start:end])
        self.allocable_sectors.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.allocable_templates = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Block()
        start = end
        end += 4
        (val1.id,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.link_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        _v12 = val1.volume
        start = end
        end += 4
        (_v12.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v12.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v12.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.eligible_categories = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        val1.eligible_entities = []
        for i in range(0, length):
          start = end
          end += 4
          (length,) = _struct_I.unpack(str[start:end])
          start = end
          end += length
          if python3:
            val2 = str[start:end].decode('utf-8', 'rosmsg')
          else:
            val2 = str[start:end]
          val1.eligible_entities.append(val2)
        self.allocable_templates.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.handover_volume = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Volume()
        start = end
        end += 4
        (val1.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
        self.handover_volume.append(val1)
      _x = self
      start = end
      end += 8
      (_x.handover_radius, _x.flight_radius,) = _get_struct_2f().unpack(str[start:end])
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_2f = None
def _get_struct_2f():
    global _struct_2f
    if _struct_2f is None:
        _struct_2f = struct.Struct("<2f")
    return _struct_2f
