# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/Sensor.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg
import geometry_msgs.msg
import sensor_msgs.msg
import std_msgs.msg

class Sensor(genpy.Message):
  _md5sum = "d718593cee4f32fdba7fc5123dafdd14"
  _type = "digitaleye_msgs/Sensor"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Description of a monitoring DigitalEye sensor
# and its properties

# unique identifier of the sensor
# e.g. hardware serial number
string sensor_id

# brand/model of sensor hardware
string model

# type of sensor being described
# e.g. camera, LIDAR, etc.
uint32 type

# position of the sensor in
# the DigitalEye’s local reference frame (meters)
geometry_msgs/Pose pose

# direction in which the sensor is facing
# with respect to the local frame’s x-axis
float32 azimuth

# resolution height of the image captured by the sensor
uint32 image_width

# resolution width of the image captured by the sensor
uint32 image_height

# frame rate of a vision sensor
uint32 frame_rate

# sensor’s current power level
float32 power

# Whether or not the sensor has been calibrated
bool calibrated

# current state of the sensor
digitaleye_msgs/State state

# Sensor inertial measurements
digitaleye_msgs/IMUValue imu

================================================================================
MSG: geometry_msgs/Pose
# A representation of pose in free space, composed of position and orientation. 
Point position
Quaternion orientation

================================================================================
MSG: geometry_msgs/Point
# This contains the position of a point in free space
float64 x
float64 y
float64 z

================================================================================
MSG: geometry_msgs/Quaternion
# This represents an orientation in free space in quaternion form.

float64 x
float64 y
float64 z
float64 w

================================================================================
MSG: digitaleye_msgs/State
# Details of a system’s status

# unique identifier of the system
# whose status is being reported
uint32 id

# system’s current state within the 
# DigitalEye state machine
uint32 state

# system’s substatus within the current state,
# unique to each system
uint32 status

# description of the system’s current state/status
string description

# timestamp indicating last change in state or status
# (epoch time in sec)
uint32 lastChange

# list of performance metrics associated with the
# current state
digitaleye_msgs/Metric[] metrics

================================================================================
MSG: digitaleye_msgs/Metric
# Performance indicator for a subsystem,
# component or sensor

# name of the performance indicator
string name

# value of the performance indicator
string value

================================================================================
MSG: digitaleye_msgs/IMUValue
# Description of an IMU value reading

# Imu heading
float32 heading

# Unique identifier of the sensor
# e.g. hardware serial number
string device_id

# Imu measurements
sensor_msgs/Imu imu

# Magenetometer readings
geometry_msgs/Vector3 magnetic_field

# Imu reading of roll
float32 roll

# Imu reading of pitch
float32 pitch

# Calibration status
bool deviceCalibrated

================================================================================
MSG: sensor_msgs/Imu
# This is a message to hold data from an IMU (Inertial Measurement Unit)
#
# Accelerations should be in m/s^2 (not in g's), and rotational velocity should be in rad/sec
#
# If the covariance of the measurement is known, it should be filled in (if all you know is the 
# variance of each measurement, e.g. from the datasheet, just put those along the diagonal)
# A covariance matrix of all zeros will be interpreted as "covariance unknown", and to use the
# data a covariance will have to be assumed or gotten from some other source
#
# If you have no estimate for one of the data elements (e.g. your IMU doesn't produce an orientation 
# estimate), please set element 0 of the associated covariance matrix to -1
# If you are interpreting this message, please check for a value of -1 in the first element of each 
# covariance matrix, and disregard the associated estimate.

Header header

geometry_msgs/Quaternion orientation
float64[9] orientation_covariance # Row major about x, y, z axes

geometry_msgs/Vector3 angular_velocity
float64[9] angular_velocity_covariance # Row major about x, y, z axes

geometry_msgs/Vector3 linear_acceleration
float64[9] linear_acceleration_covariance # Row major x, y z 

================================================================================
MSG: std_msgs/Header
# Standard metadata for higher-level stamped data types.
# This is generally used to communicate timestamped data 
# in a particular coordinate frame.
# 
# sequence ID: consecutively increasing ID 
uint32 seq
#Two-integer timestamp that is expressed as:
# * stamp.sec: seconds (stamp_secs) since epoch (in Python the variable is called 'secs')
# * stamp.nsec: nanoseconds since stamp_secs (in Python the variable is called 'nsecs')
# time-handling sugar is provided by the client library
time stamp
#Frame this data is associated with
string frame_id

================================================================================
MSG: geometry_msgs/Vector3
# This represents a vector in free space. 
# It is only meant to represent a direction. Therefore, it does not
# make sense to apply a translation to it (e.g., when applying a 
# generic rigid transformation to a Vector3, tf2 will only apply the
# rotation). If you want your data to be translatable too, use the
# geometry_msgs/Point message instead.

float64 x
float64 y
float64 z"""
  __slots__ = ['sensor_id','model','type','pose','azimuth','image_width','image_height','frame_rate','power','calibrated','state','imu']
  _slot_types = ['string','string','uint32','geometry_msgs/Pose','float32','uint32','uint32','uint32','float32','bool','digitaleye_msgs/State','digitaleye_msgs/IMUValue']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       sensor_id,model,type,pose,azimuth,image_width,image_height,frame_rate,power,calibrated,state,imu

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(Sensor, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.sensor_id is None:
        self.sensor_id = ''
      if self.model is None:
        self.model = ''
      if self.type is None:
        self.type = 0
      if self.pose is None:
        self.pose = geometry_msgs.msg.Pose()
      if self.azimuth is None:
        self.azimuth = 0.
      if self.image_width is None:
        self.image_width = 0
      if self.image_height is None:
        self.image_height = 0
      if self.frame_rate is None:
        self.frame_rate = 0
      if self.power is None:
        self.power = 0.
      if self.calibrated is None:
        self.calibrated = False
      if self.state is None:
        self.state = digitaleye_msgs.msg.State()
      if self.imu is None:
        self.imu = digitaleye_msgs.msg.IMUValue()
    else:
      self.sensor_id = ''
      self.model = ''
      self.type = 0
      self.pose = geometry_msgs.msg.Pose()
      self.azimuth = 0.
      self.image_width = 0
      self.image_height = 0
      self.frame_rate = 0
      self.power = 0.
      self.calibrated = False
      self.state = digitaleye_msgs.msg.State()
      self.imu = digitaleye_msgs.msg.IMUValue()

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.sensor_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.model
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_I7df3IfB3I().pack(_x.type, _x.pose.position.x, _x.pose.position.y, _x.pose.position.z, _x.pose.orientation.x, _x.pose.orientation.y, _x.pose.orientation.z, _x.pose.orientation.w, _x.azimuth, _x.image_width, _x.image_height, _x.frame_rate, _x.power, _x.calibrated, _x.state.id, _x.state.state, _x.state.status))
      _x = self.state.description
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.state.lastChange
      buff.write(_get_struct_I().pack(_x))
      length = len(self.state.metrics)
      buff.write(_struct_I.pack(length))
      for val1 in self.state.metrics:
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1.value
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.imu.heading
      buff.write(_get_struct_f().pack(_x))
      _x = self.imu.device_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_3I().pack(_x.imu.imu.header.seq, _x.imu.imu.header.stamp.secs, _x.imu.imu.header.stamp.nsecs))
      _x = self.imu.imu.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_4d().pack(_x.imu.imu.orientation.x, _x.imu.imu.orientation.y, _x.imu.imu.orientation.z, _x.imu.imu.orientation.w))
      buff.write(_get_struct_9d().pack(*self.imu.imu.orientation_covariance))
      _x = self
      buff.write(_get_struct_3d().pack(_x.imu.imu.angular_velocity.x, _x.imu.imu.angular_velocity.y, _x.imu.imu.angular_velocity.z))
      buff.write(_get_struct_9d().pack(*self.imu.imu.angular_velocity_covariance))
      _x = self
      buff.write(_get_struct_3d().pack(_x.imu.imu.linear_acceleration.x, _x.imu.imu.linear_acceleration.y, _x.imu.imu.linear_acceleration.z))
      buff.write(_get_struct_9d().pack(*self.imu.imu.linear_acceleration_covariance))
      _x = self
      buff.write(_get_struct_3d2fB().pack(_x.imu.magnetic_field.x, _x.imu.magnetic_field.y, _x.imu.magnetic_field.z, _x.imu.roll, _x.imu.pitch, _x.imu.deviceCalibrated))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.pose is None:
        self.pose = geometry_msgs.msg.Pose()
      if self.state is None:
        self.state = digitaleye_msgs.msg.State()
      if self.imu is None:
        self.imu = digitaleye_msgs.msg.IMUValue()
      end = 0
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.sensor_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.sensor_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.model = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.model = str[start:end]
      _x = self
      start = end
      end += 93
      (_x.type, _x.pose.position.x, _x.pose.position.y, _x.pose.position.z, _x.pose.orientation.x, _x.pose.orientation.y, _x.pose.orientation.z, _x.pose.orientation.w, _x.azimuth, _x.image_width, _x.image_height, _x.frame_rate, _x.power, _x.calibrated, _x.state.id, _x.state.state, _x.state.status,) = _get_struct_I7df3IfB3I().unpack(str[start:end])
      self.calibrated = bool(self.calibrated)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.state.description = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.state.description = str[start:end]
      start = end
      end += 4
      (self.state.lastChange,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.state.metrics = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Metric()
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.name = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.value = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.value = str[start:end]
        self.state.metrics.append(val1)
      start = end
      end += 4
      (self.imu.heading,) = _get_struct_f().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.imu.device_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.imu.device_id = str[start:end]
      _x = self
      start = end
      end += 12
      (_x.imu.imu.header.seq, _x.imu.imu.header.stamp.secs, _x.imu.imu.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.imu.imu.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.imu.imu.header.frame_id = str[start:end]
      _x = self
      start = end
      end += 32
      (_x.imu.imu.orientation.x, _x.imu.imu.orientation.y, _x.imu.imu.orientation.z, _x.imu.imu.orientation.w,) = _get_struct_4d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.imu.orientation_covariance = _get_struct_9d().unpack(str[start:end])
      _x = self
      start = end
      end += 24
      (_x.imu.imu.angular_velocity.x, _x.imu.imu.angular_velocity.y, _x.imu.imu.angular_velocity.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.imu.angular_velocity_covariance = _get_struct_9d().unpack(str[start:end])
      _x = self
      start = end
      end += 24
      (_x.imu.imu.linear_acceleration.x, _x.imu.imu.linear_acceleration.y, _x.imu.imu.linear_acceleration.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.imu.linear_acceleration_covariance = _get_struct_9d().unpack(str[start:end])
      _x = self
      start = end
      end += 33
      (_x.imu.magnetic_field.x, _x.imu.magnetic_field.y, _x.imu.magnetic_field.z, _x.imu.roll, _x.imu.pitch, _x.imu.deviceCalibrated,) = _get_struct_3d2fB().unpack(str[start:end])
      self.imu.deviceCalibrated = bool(self.imu.deviceCalibrated)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.sensor_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.model
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_I7df3IfB3I().pack(_x.type, _x.pose.position.x, _x.pose.position.y, _x.pose.position.z, _x.pose.orientation.x, _x.pose.orientation.y, _x.pose.orientation.z, _x.pose.orientation.w, _x.azimuth, _x.image_width, _x.image_height, _x.frame_rate, _x.power, _x.calibrated, _x.state.id, _x.state.state, _x.state.status))
      _x = self.state.description
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.state.lastChange
      buff.write(_get_struct_I().pack(_x))
      length = len(self.state.metrics)
      buff.write(_struct_I.pack(length))
      for val1 in self.state.metrics:
        _x = val1.name
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1.value
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self.imu.heading
      buff.write(_get_struct_f().pack(_x))
      _x = self.imu.device_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_3I().pack(_x.imu.imu.header.seq, _x.imu.imu.header.stamp.secs, _x.imu.imu.header.stamp.nsecs))
      _x = self.imu.imu.header.frame_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_4d().pack(_x.imu.imu.orientation.x, _x.imu.imu.orientation.y, _x.imu.imu.orientation.z, _x.imu.imu.orientation.w))
      buff.write(self.imu.imu.orientation_covariance.tostring())
      _x = self
      buff.write(_get_struct_3d().pack(_x.imu.imu.angular_velocity.x, _x.imu.imu.angular_velocity.y, _x.imu.imu.angular_velocity.z))
      buff.write(self.imu.imu.angular_velocity_covariance.tostring())
      _x = self
      buff.write(_get_struct_3d().pack(_x.imu.imu.linear_acceleration.x, _x.imu.imu.linear_acceleration.y, _x.imu.imu.linear_acceleration.z))
      buff.write(self.imu.imu.linear_acceleration_covariance.tostring())
      _x = self
      buff.write(_get_struct_3d2fB().pack(_x.imu.magnetic_field.x, _x.imu.magnetic_field.y, _x.imu.magnetic_field.z, _x.imu.roll, _x.imu.pitch, _x.imu.deviceCalibrated))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.pose is None:
        self.pose = geometry_msgs.msg.Pose()
      if self.state is None:
        self.state = digitaleye_msgs.msg.State()
      if self.imu is None:
        self.imu = digitaleye_msgs.msg.IMUValue()
      end = 0
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.sensor_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.sensor_id = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.model = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.model = str[start:end]
      _x = self
      start = end
      end += 93
      (_x.type, _x.pose.position.x, _x.pose.position.y, _x.pose.position.z, _x.pose.orientation.x, _x.pose.orientation.y, _x.pose.orientation.z, _x.pose.orientation.w, _x.azimuth, _x.image_width, _x.image_height, _x.frame_rate, _x.power, _x.calibrated, _x.state.id, _x.state.state, _x.state.status,) = _get_struct_I7df3IfB3I().unpack(str[start:end])
      self.calibrated = bool(self.calibrated)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.state.description = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.state.description = str[start:end]
      start = end
      end += 4
      (self.state.lastChange,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.state.metrics = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.Metric()
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.name = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.name = str[start:end]
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.value = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.value = str[start:end]
        self.state.metrics.append(val1)
      start = end
      end += 4
      (self.imu.heading,) = _get_struct_f().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.imu.device_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.imu.device_id = str[start:end]
      _x = self
      start = end
      end += 12
      (_x.imu.imu.header.seq, _x.imu.imu.header.stamp.secs, _x.imu.imu.header.stamp.nsecs,) = _get_struct_3I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.imu.imu.header.frame_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.imu.imu.header.frame_id = str[start:end]
      _x = self
      start = end
      end += 32
      (_x.imu.imu.orientation.x, _x.imu.imu.orientation.y, _x.imu.imu.orientation.z, _x.imu.imu.orientation.w,) = _get_struct_4d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.imu.orientation_covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=9)
      _x = self
      start = end
      end += 24
      (_x.imu.imu.angular_velocity.x, _x.imu.imu.angular_velocity.y, _x.imu.imu.angular_velocity.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.imu.angular_velocity_covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=9)
      _x = self
      start = end
      end += 24
      (_x.imu.imu.linear_acceleration.x, _x.imu.imu.linear_acceleration.y, _x.imu.imu.linear_acceleration.z,) = _get_struct_3d().unpack(str[start:end])
      start = end
      end += 72
      self.imu.imu.linear_acceleration_covariance = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=9)
      _x = self
      start = end
      end += 33
      (_x.imu.magnetic_field.x, _x.imu.magnetic_field.y, _x.imu.magnetic_field.z, _x.imu.roll, _x.imu.pitch, _x.imu.deviceCalibrated,) = _get_struct_3d2fB().unpack(str[start:end])
      self.imu.deviceCalibrated = bool(self.imu.deviceCalibrated)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_3I = None
def _get_struct_3I():
    global _struct_3I
    if _struct_3I is None:
        _struct_3I = struct.Struct("<3I")
    return _struct_3I
_struct_3d = None
def _get_struct_3d():
    global _struct_3d
    if _struct_3d is None:
        _struct_3d = struct.Struct("<3d")
    return _struct_3d
_struct_3d2fB = None
def _get_struct_3d2fB():
    global _struct_3d2fB
    if _struct_3d2fB is None:
        _struct_3d2fB = struct.Struct("<3d2fB")
    return _struct_3d2fB
_struct_4d = None
def _get_struct_4d():
    global _struct_4d
    if _struct_4d is None:
        _struct_4d = struct.Struct("<4d")
    return _struct_4d
_struct_9d = None
def _get_struct_9d():
    global _struct_9d
    if _struct_9d is None:
        _struct_9d = struct.Struct("<9d")
    return _struct_9d
_struct_I7df3IfB3I = None
def _get_struct_I7df3IfB3I():
    global _struct_I7df3IfB3I
    if _struct_I7df3IfB3I is None:
        _struct_I7df3IfB3I = struct.Struct("<I7df3IfB3I")
    return _struct_I7df3IfB3I
_struct_f = None
def _get_struct_f():
    global _struct_f
    if _struct_f is None:
        _struct_f = struct.Struct("<f")
    return _struct_f
