# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/NewBookingRequest.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg

class NewBookingRequest(genpy.Message):
  _md5sum = "e04a15792d9fa66f055031ff7e03a9a6"
  _type = "digitaleye_msgs/NewBookingRequest"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# Request a new booking and get its status if feasible or not

# booking id
uint32 booking_id

# agent registration linked to the booking
string agent_cloud_id

# window start time (Epoch timestamp in seconds)
uint64 start

# window end time (Epoch timestamp in seconds)
uint64 end

# flight mode for booking, use FLIGHT_ booking constants
uint32 flight_mode

# actions linked to booking
digitaleye_msgs/ExtAction[] actions

# C2 comms link
string connection


================================================================================
MSG: digitaleye_msgs/ExtAction
# External Action definition

# action id
uint32 id

# action for the following entity id(s) (can be empty)
uint64[] entity_id

# Agent registration (can be empty)
string agent_reg

# start time of allocation (included) (Epoch timestamp in seconds)
uint64 start

# end time of allocation (included) (Epoch timestamp in seconds)
uint64 end

# duration of allocation (seconds)
uint64 duration

# category of action, use EXT_CAT_ below
uint32 category

uint32 EXT_CAT_FLIGHT_IN = 0
uint32 EXT_CAT_FLIGHT_OUT = 1
uint32 EXT_CAT_GROUND_IN = 2
uint32 EXT_CAT_GROUND_OUT = 3
uint32 EXT_CAT_GROUND_AIR_DELIV = 4
uint32 EXT_CAT_MANUAL_CHARGING = 5
uint32 EXT_CAT_TOUCH_AND_GO = 6
uint32 EXT_CAT_MVV = 7
"""
  __slots__ = ['booking_id','agent_cloud_id','start','end','flight_mode','actions','connection']
  _slot_types = ['uint32','string','uint64','uint64','uint32','digitaleye_msgs/ExtAction[]','string']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       booking_id,agent_cloud_id,start,end,flight_mode,actions,connection

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(NewBookingRequest, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.booking_id is None:
        self.booking_id = 0
      if self.agent_cloud_id is None:
        self.agent_cloud_id = ''
      if self.start is None:
        self.start = 0
      if self.end is None:
        self.end = 0
      if self.flight_mode is None:
        self.flight_mode = 0
      if self.actions is None:
        self.actions = []
      if self.connection is None:
        self.connection = ''
    else:
      self.booking_id = 0
      self.agent_cloud_id = ''
      self.start = 0
      self.end = 0
      self.flight_mode = 0
      self.actions = []
      self.connection = ''

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.booking_id
      buff.write(_get_struct_I().pack(_x))
      _x = self.agent_cloud_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_2QI().pack(_x.start, _x.end, _x.flight_mode))
      length = len(self.actions)
      buff.write(_struct_I.pack(length))
      for val1 in self.actions:
        _x = val1.id
        buff.write(_get_struct_I().pack(_x))
        length = len(val1.entity_id)
        buff.write(_struct_I.pack(length))
        pattern = '<%sQ'%length
        buff.write(struct.Struct(pattern).pack(*val1.entity_id))
        _x = val1.agent_reg
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1
        buff.write(_get_struct_3QI().pack(_x.start, _x.end, _x.duration, _x.category))
      _x = self.connection
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.actions is None:
        self.actions = None
      end = 0
      start = end
      end += 4
      (self.booking_id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.agent_cloud_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.agent_cloud_id = str[start:end]
      _x = self
      start = end
      end += 20
      (_x.start, _x.end, _x.flight_mode,) = _get_struct_2QI().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.actions = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ExtAction()
        start = end
        end += 4
        (val1.id,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sQ'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.entity_id = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.agent_reg = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.agent_reg = str[start:end]
        _x = val1
        start = end
        end += 28
        (_x.start, _x.end, _x.duration, _x.category,) = _get_struct_3QI().unpack(str[start:end])
        self.actions.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.connection = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.connection = str[start:end]
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.booking_id
      buff.write(_get_struct_I().pack(_x))
      _x = self.agent_cloud_id
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      _x = self
      buff.write(_get_struct_2QI().pack(_x.start, _x.end, _x.flight_mode))
      length = len(self.actions)
      buff.write(_struct_I.pack(length))
      for val1 in self.actions:
        _x = val1.id
        buff.write(_get_struct_I().pack(_x))
        length = len(val1.entity_id)
        buff.write(_struct_I.pack(length))
        pattern = '<%sQ'%length
        buff.write(val1.entity_id.tostring())
        _x = val1.agent_reg
        length = len(_x)
        if python3 or type(_x) == unicode:
          _x = _x.encode('utf-8')
          length = len(_x)
        buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
        _x = val1
        buff.write(_get_struct_3QI().pack(_x.start, _x.end, _x.duration, _x.category))
      _x = self.connection
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.actions is None:
        self.actions = None
      end = 0
      start = end
      end += 4
      (self.booking_id,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.agent_cloud_id = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.agent_cloud_id = str[start:end]
      _x = self
      start = end
      end += 20
      (_x.start, _x.end, _x.flight_mode,) = _get_struct_2QI().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.actions = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.ExtAction()
        start = end
        end += 4
        (val1.id,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sQ'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.entity_id = numpy.frombuffer(str[start:end], dtype=numpy.uint64, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        start = end
        end += length
        if python3:
          val1.agent_reg = str[start:end].decode('utf-8', 'rosmsg')
        else:
          val1.agent_reg = str[start:end]
        _x = val1
        start = end
        end += 28
        (_x.start, _x.end, _x.duration, _x.category,) = _get_struct_3QI().unpack(str[start:end])
        self.actions.append(val1)
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.connection = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.connection = str[start:end]
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_2QI = None
def _get_struct_2QI():
    global _struct_2QI
    if _struct_2QI is None:
        _struct_2QI = struct.Struct("<2QI")
    return _struct_2QI
_struct_3QI = None
def _get_struct_3QI():
    global _struct_3QI
    if _struct_3QI is None:
        _struct_3QI = struct.Struct("<3QI")
    return _struct_3QI
# This Python file uses the following encoding: utf-8
"""autogenerated by genpy from digitaleye_msgs/NewBookingResponse.msg. Do not edit."""
import codecs
import sys
python3 = True if sys.hexversion > 0x03000000 else False
import genpy
import struct

import digitaleye_msgs.msg

class NewBookingResponse(genpy.Message):
  _md5sum = "a1df1833df02d4fbd4d33ce6a129ee69"
  _type = "digitaleye_msgs/NewBookingResponse"
  _has_header = False  # flag to mark the presence of a Header object
  _full_text = """# status of the request, use booking constants STATUS_
uint32 status

# details of status
string details

digitaleye_msgs/BookingOption[] options


================================================================================
MSG: digitaleye_msgs/BookingOption
# Booking option

# booking id
uint32 id

# start time (Epoch timestamp in seconds)
uint64 start

# end time (Epoch timestamp in seconds)
uint64 end

# zone ids
uint32[] zone_ids

# entry point
digitaleye_msgs/Volume entry

================================================================================
MSG: digitaleye_msgs/Volume
# Volume definition

# Volume shape, use SHAPE_
uint32 shape

uint32 SHAPE_PRISM=1
uint32 SHAPE_SPHERE=2
uint32 SHAPE_CYLINDER=3

# Parameters of the volume
uint32[] int_param
float64[] float_param

# Prism: characterised by 2 bases of same nb of point (x,y,z), ordered the same way
# size of float param is nb points*PRISM_FLOAT_PARAM_SIZE*2
# (number of points * number of coordinates/float param per point  * 2 bases)
# Prism int parameters indexes
uint32 PRISM_INT_NB_POINTS=0
uint32 PRISM_INT_PARAM_SIZE=1 # constant (not index) - size of int_param
# Prism float parameters indexes
uint32 PRISM_FLOAT_X=0
uint32 PRISM_FLOAT_Y=1
uint32 PRISM_FLOAT_Z=2
uint32 PRISM_FLOAT_PARAM_SIZE=3  # constant (not index) - size of each point / nb of float params per point

# Sphere: characterised by radius and centre point (x,y,z)
# Sphere no int parameters
uint32 SPHERE_INT_PARAM_SIZE=0 # constant (not index) - size of int_param
# Sphere float parameters indexes
uint32 SPHERE_FLOAT_RADIUS=0
uint32 SPHERE_FLOAT_X=1
uint32 SPHERE_FLOAT_Y=2
uint32 SPHERE_FLOAT_Z=3
uint32 SPHERE_FLOAT_PARAM_SIZE=4 # constant (not index) - size of float_param

# Cylinder: characterised by 2 bases with each:
#   centre point (x,y,z), radius, termination: spherical/flat (use TERM_)
# Cylinder int parameters indexes
uint32 CYLINDER_INT_TERM1=0
uint32 CYLINDER_INT_TERM2=1
uint32 CYLINDER_INT_PARAM_SIZE=2 # constant (not index) - size of int_param

# Cylinder float parameters indexes
uint32 CYLINDER_FLOAT_X1=0
uint32 CYLINDER_FLOAT_Y1=1
uint32 CYLINDER_FLOAT_Z1=2
uint32 CYLINDER_FLOAT_RADIUS1=3
uint32 CYLINDER_FLOAT_X2=4
uint32 CYLINDER_FLOAT_Y2=5
uint32 CYLINDER_FLOAT_Z2=6
uint32 CYLINDER_FLOAT_RADIUS2=7
uint32 CYLINDER_FLOAT_PARAM_SIZE=8 # constant (not index) - size of float_param

# termination of volume, spherical or flat
uint32 TERM_SPHERE=0
uint32 TERM_FLAT=1
"""
  __slots__ = ['status','details','options']
  _slot_types = ['uint32','string','digitaleye_msgs/BookingOption[]']

  def __init__(self, *args, **kwds):
    """
    Constructor. Any message fields that are implicitly/explicitly
    set to None will be assigned a default value. The recommend
    use is keyword arguments as this is more robust to future message
    changes.  You cannot mix in-order arguments and keyword arguments.

    The available fields are:
       status,details,options

    :param args: complete set of field values, in .msg order
    :param kwds: use keyword arguments corresponding to message field names
    to set specific fields.
    """
    if args or kwds:
      super(NewBookingResponse, self).__init__(*args, **kwds)
      # message fields cannot be None, assign default values for those that are
      if self.status is None:
        self.status = 0
      if self.details is None:
        self.details = ''
      if self.options is None:
        self.options = []
    else:
      self.status = 0
      self.details = ''
      self.options = []

  def _get_types(self):
    """
    internal API method
    """
    return self._slot_types

  def serialize(self, buff):
    """
    serialize message into buffer
    :param buff: buffer, ``StringIO``
    """
    try:
      _x = self.status
      buff.write(_get_struct_I().pack(_x))
      _x = self.details
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.options)
      buff.write(_struct_I.pack(length))
      for val1 in self.options:
        _x = val1
        buff.write(_get_struct_I2Q().pack(_x.id, _x.start, _x.end))
        length = len(val1.zone_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*val1.zone_ids))
        _v1 = val1.entry
        _x = _v1.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(_v1.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(struct.Struct(pattern).pack(*_v1.int_param))
        length = len(_v1.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(struct.Struct(pattern).pack(*_v1.float_param))
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize(self, str):
    """
    unpack serialized message in str into this message instance
    :param str: byte array of serialized message, ``str``
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.options is None:
        self.options = None
      end = 0
      start = end
      end += 4
      (self.status,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.details = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.details = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.options = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.BookingOption()
        _x = val1
        start = end
        end += 20
        (_x.id, _x.start, _x.end,) = _get_struct_I2Q().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.zone_ids = s.unpack(str[start:end])
        _v2 = val1.entry
        start = end
        end += 4
        (_v2.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v2.int_param = s.unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v2.float_param = s.unpack(str[start:end])
        self.options.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill


  def serialize_numpy(self, buff, numpy):
    """
    serialize message with numpy array types into buffer
    :param buff: buffer, ``StringIO``
    :param numpy: numpy python module
    """
    try:
      _x = self.status
      buff.write(_get_struct_I().pack(_x))
      _x = self.details
      length = len(_x)
      if python3 or type(_x) == unicode:
        _x = _x.encode('utf-8')
        length = len(_x)
      buff.write(struct.Struct('<I%ss'%length).pack(length, _x))
      length = len(self.options)
      buff.write(_struct_I.pack(length))
      for val1 in self.options:
        _x = val1
        buff.write(_get_struct_I2Q().pack(_x.id, _x.start, _x.end))
        length = len(val1.zone_ids)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(val1.zone_ids.tostring())
        _v3 = val1.entry
        _x = _v3.shape
        buff.write(_get_struct_I().pack(_x))
        length = len(_v3.int_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sI'%length
        buff.write(_v3.int_param.tostring())
        length = len(_v3.float_param)
        buff.write(_struct_I.pack(length))
        pattern = '<%sd'%length
        buff.write(_v3.float_param.tostring())
    except struct.error as se: self._check_types(struct.error("%s: '%s' when writing '%s'" % (type(se), str(se), str(locals().get('_x', self)))))
    except TypeError as te: self._check_types(ValueError("%s: '%s' when writing '%s'" % (type(te), str(te), str(locals().get('_x', self)))))

  def deserialize_numpy(self, str, numpy):
    """
    unpack serialized message in str into this message instance using numpy for array types
    :param str: byte array of serialized message, ``str``
    :param numpy: numpy python module
    """
    if python3:
      codecs.lookup_error("rosmsg").msg_type = self._type
    try:
      if self.options is None:
        self.options = None
      end = 0
      start = end
      end += 4
      (self.status,) = _get_struct_I().unpack(str[start:end])
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      start = end
      end += length
      if python3:
        self.details = str[start:end].decode('utf-8', 'rosmsg')
      else:
        self.details = str[start:end]
      start = end
      end += 4
      (length,) = _struct_I.unpack(str[start:end])
      self.options = []
      for i in range(0, length):
        val1 = digitaleye_msgs.msg.BookingOption()
        _x = val1
        start = end
        end += 20
        (_x.id, _x.start, _x.end,) = _get_struct_I2Q().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        val1.zone_ids = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        _v4 = val1.entry
        start = end
        end += 4
        (_v4.shape,) = _get_struct_I().unpack(str[start:end])
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sI'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v4.int_param = numpy.frombuffer(str[start:end], dtype=numpy.uint32, count=length)
        start = end
        end += 4
        (length,) = _struct_I.unpack(str[start:end])
        pattern = '<%sd'%length
        start = end
        s = struct.Struct(pattern)
        end += s.size
        _v4.float_param = numpy.frombuffer(str[start:end], dtype=numpy.float64, count=length)
        self.options.append(val1)
      return self
    except struct.error as e:
      raise genpy.DeserializationError(e)  # most likely buffer underfill

_struct_I = genpy.struct_I
def _get_struct_I():
    global _struct_I
    return _struct_I
_struct_I2Q = None
def _get_struct_I2Q():
    global _struct_I2Q
    if _struct_I2Q is None:
        _struct_I2Q = struct.Struct("<I2Q")
    return _struct_I2Q
class NewBooking(object):
  _type          = 'digitaleye_msgs/NewBooking'
  _md5sum = 'a78304b6ec127238e790a1c1d31ecd9d'
  _request_class  = NewBookingRequest
  _response_class = NewBookingResponse
