# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
#
# MIT License
#
# Copyright (c) 2022 KuFlow
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#
# --------------------------------------------------------------------------
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
#
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterator, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ...operations._process_item_operations import (
    build_append_process_item_task_log_request,
    build_assign_process_item_task_request,
    build_claim_process_item_task_request,
    build_complete_process_item_task_request,
    build_create_process_item_request,
    build_download_process_item_task_data_webforms_as_document_request,
    build_find_process_items_request,
    build_patch_process_item_task_data_request,
    build_retrieve_process_item_request,
    build_update_process_item_task_data_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ProcessItemOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~kuflow.rest.aio.KuFlowRestClient`'s
        :attr:`process_item` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def find_process_items(
        self,
        *,
        size: int = 25,
        page: int = 0,
        sort: Optional[List[str]] = None,
        process_id: Optional[List[str]] = None,
        type: Optional[List[Union[str, _models.ProcessItemType]]] = None,
        task_state: Optional[List[Union[str, _models.ProcessItemTaskState]]] = None,
        task_definition_code: Optional[List[str]] = None,
        tenant_id: Optional[List[str]] = None,
        **kwargs: Any,
    ) -> _models.ProcessItemPage:
        """Find all accessible Process Items.

        List all Process Items that have been created and the credentials has access.

        Available sort query values: id, createdAt, lastModifiedAt, claimedAt, completedAt,
        cancelledAt.

        :keyword size: The number of records returned within a single API call. Default value is 25.
        :paramtype size: int
        :keyword page: The page number of the current page in the returned records, 0 is the first
         page. Default value is 0.
        :paramtype page: int
        :keyword sort: Sorting criteria in the format: property{,asc|desc}. Example: createdAt,desc

         Default sort order is ascending. Multiple sort criteria are supported.

         Please refer to the method description for supported properties. Default value is None.
        :paramtype sort: list[str]
        :keyword process_id: Filter by an array of process ids. Default value is None.
        :paramtype process_id: list[str]
        :keyword type: Filter by an array of type. Default value is None.
        :paramtype type: list[str or ~kuflow.rest.models.ProcessItemType]
        :keyword task_state: Filter by an array of task states. Default value is None.
        :paramtype task_state: list[str or ~kuflow.rest.models.ProcessItemTaskState]
        :keyword task_definition_code: Filter by an array of task definition codes. Default value is
         None.
        :paramtype task_definition_code: list[str]
        :keyword tenant_id: Filter by tenantId. Default value is None.
        :paramtype tenant_id: list[str]
        :return: ProcessItemPage
        :rtype: ~kuflow.rest.models.ProcessItemPage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ProcessItemPage] = kwargs.pop("cls", None)

        _request = build_find_process_items_request(
            size=size,
            page=page,
            sort=sort,
            process_id=process_id,
            type=type,
            task_state=task_state,
            task_definition_code=task_definition_code,
            tenant_id=tenant_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ProcessItemPage", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_process_item(
        self,
        process_item_create_params: _models.ProcessItemCreateParams,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Create a new Process Item in the selected Process.

        Create a Process Item and optionally fill its value.

        If you want to add document type elements, you can pass a reference to an existing document
        type element
        indicating its 'uri'. This will copy that document into the element. In case you want to add a
        new document,
        please use the corresponding API method.

        If you want the method to be idempotent, please specify the ``id`` field in the request body.

        :param process_item_create_params: Process Item to be created. Required.
        :type process_item_create_params: ~kuflow.rest.models.ProcessItemCreateParams
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_process_item(
        self, process_item_create_params: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.ProcessItem:
        """Create a new Process Item in the selected Process.

        Create a Process Item and optionally fill its value.

        If you want to add document type elements, you can pass a reference to an existing document
        type element
        indicating its 'uri'. This will copy that document into the element. In case you want to add a
        new document,
        please use the corresponding API method.

        If you want the method to be idempotent, please specify the ``id`` field in the request body.

        :param process_item_create_params: Process Item to be created. Required.
        :type process_item_create_params: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_process_item(
        self, process_item_create_params: Union[_models.ProcessItemCreateParams, IO[bytes]], **kwargs: Any
    ) -> _models.ProcessItem:
        """Create a new Process Item in the selected Process.

        Create a Process Item and optionally fill its value.

        If you want to add document type elements, you can pass a reference to an existing document
        type element
        indicating its 'uri'. This will copy that document into the element. In case you want to add a
        new document,
        please use the corresponding API method.

        If you want the method to be idempotent, please specify the ``id`` field in the request body.

        :param process_item_create_params: Process Item to be created. Is either a
         ProcessItemCreateParams type or a IO[bytes] type. Required.
        :type process_item_create_params: ~kuflow.rest.models.ProcessItemCreateParams or IO[bytes]
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ProcessItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(process_item_create_params, (IOBase, bytes)):
            _content = process_item_create_params
        else:
            _json = self._serialize.body(process_item_create_params, "ProcessItemCreateParams")

        _request = build_create_process_item_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ProcessItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def retrieve_process_item(self, id: str, **kwargs: Any) -> _models.ProcessItem:
        """Get a process item given it ID.

        Allow to get a process item by ID.

        :param id: The resource ID. Required.
        :type id: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ProcessItem] = kwargs.pop("cls", None)

        _request = build_retrieve_process_item_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ProcessItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def claim_process_item_task(self, id: str, **kwargs: Any) -> _models.ProcessItem:
        """Claim a process item task.

        Allow to claim a task.

        :param id: The resource ID. Required.
        :type id: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ProcessItem] = kwargs.pop("cls", None)

        _request = build_claim_process_item_task_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ProcessItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def assign_process_item_task(
        self,
        id: str,
        process_item_task_assign_params: _models.ProcessItemTaskAssignParams,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Assign a process item task.

        Allow to assign a process item task to a user or application. Only one option will be
        necessary.

        :param id: The resource ID. Required.
        :type id: str
        :param process_item_task_assign_params: Params to change the process item task owner. Required.
        :type process_item_task_assign_params: ~kuflow.rest.models.ProcessItemTaskAssignParams
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def assign_process_item_task(
        self,
        id: str,
        process_item_task_assign_params: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Assign a process item task.

        Allow to assign a process item task to a user or application. Only one option will be
        necessary.

        :param id: The resource ID. Required.
        :type id: str
        :param process_item_task_assign_params: Params to change the process item task owner. Required.
        :type process_item_task_assign_params: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def assign_process_item_task(
        self,
        id: str,
        process_item_task_assign_params: Union[_models.ProcessItemTaskAssignParams, IO[bytes]],
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Assign a process item task.

        Allow to assign a process item task to a user or application. Only one option will be
        necessary.

        :param id: The resource ID. Required.
        :type id: str
        :param process_item_task_assign_params: Params to change the process item task owner. Is either
         a ProcessItemTaskAssignParams type or a IO[bytes] type. Required.
        :type process_item_task_assign_params: ~kuflow.rest.models.ProcessItemTaskAssignParams or
         IO[bytes]
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ProcessItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(process_item_task_assign_params, (IOBase, bytes)):
            _content = process_item_task_assign_params
        else:
            _json = self._serialize.body(process_item_task_assign_params, "ProcessItemTaskAssignParams")

        _request = build_assign_process_item_task_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ProcessItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def complete_process_item_task(self, id: str, **kwargs: Any) -> _models.ProcessItem:
        """Complete a process item task.

        Allow to complete a claimed task by the principal.

        :param id: The resource ID. Required.
        :type id: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ProcessItem] = kwargs.pop("cls", None)

        _request = build_complete_process_item_task_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ProcessItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def append_process_item_task_log(
        self,
        id: str,
        process_item_task_append_log_params: _models.ProcessItemTaskAppendLogParams,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Append a log to the process item task.

        A log entry is added to the task. If the number of log entries is reached, the oldest log entry
        is removed.

        :param id: The resource ID. Required.
        :type id: str
        :param process_item_task_append_log_params: Log to be created. Required.
        :type process_item_task_append_log_params: ~kuflow.rest.models.ProcessItemTaskAppendLogParams
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def append_process_item_task_log(
        self,
        id: str,
        process_item_task_append_log_params: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Append a log to the process item task.

        A log entry is added to the task. If the number of log entries is reached, the oldest log entry
        is removed.

        :param id: The resource ID. Required.
        :type id: str
        :param process_item_task_append_log_params: Log to be created. Required.
        :type process_item_task_append_log_params: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def append_process_item_task_log(
        self,
        id: str,
        process_item_task_append_log_params: Union[_models.ProcessItemTaskAppendLogParams, IO[bytes]],
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Append a log to the process item task.

        A log entry is added to the task. If the number of log entries is reached, the oldest log entry
        is removed.

        :param id: The resource ID. Required.
        :type id: str
        :param process_item_task_append_log_params: Log to be created. Is either a
         ProcessItemTaskAppendLogParams type or a IO[bytes] type. Required.
        :type process_item_task_append_log_params: ~kuflow.rest.models.ProcessItemTaskAppendLogParams
         or IO[bytes]
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ProcessItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(process_item_task_append_log_params, (IOBase, bytes)):
            _content = process_item_task_append_log_params
        else:
            _json = self._serialize.body(process_item_task_append_log_params, "ProcessItemTaskAppendLogParams")

        _request = build_append_process_item_task_log_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ProcessItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_process_item_task_data(
        self,
        id: str,
        process_item_task_data_update_params: _models.ProcessItemTaskDataUpdateParams,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Save JSON data.

        Allow to save a JSON data validating that the data follow the related schema. If the data is
        invalid, then
        the json form is marked as invalid.

        :param id: The resource ID. Required.
        :type id: str
        :param process_item_task_data_update_params: Params used to update the JSON value. Required.
        :type process_item_task_data_update_params: ~kuflow.rest.models.ProcessItemTaskDataUpdateParams
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_process_item_task_data(
        self,
        id: str,
        process_item_task_data_update_params: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Save JSON data.

        Allow to save a JSON data validating that the data follow the related schema. If the data is
        invalid, then
        the json form is marked as invalid.

        :param id: The resource ID. Required.
        :type id: str
        :param process_item_task_data_update_params: Params used to update the JSON value. Required.
        :type process_item_task_data_update_params: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_process_item_task_data(
        self,
        id: str,
        process_item_task_data_update_params: Union[_models.ProcessItemTaskDataUpdateParams, IO[bytes]],
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Save JSON data.

        Allow to save a JSON data validating that the data follow the related schema. If the data is
        invalid, then
        the json form is marked as invalid.

        :param id: The resource ID. Required.
        :type id: str
        :param process_item_task_data_update_params: Params used to update the JSON value. Is either a
         ProcessItemTaskDataUpdateParams type or a IO[bytes] type. Required.
        :type process_item_task_data_update_params: ~kuflow.rest.models.ProcessItemTaskDataUpdateParams
         or IO[bytes]
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ProcessItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(process_item_task_data_update_params, (IOBase, bytes)):
            _content = process_item_task_data_update_params
        else:
            _json = self._serialize.body(process_item_task_data_update_params, "ProcessItemTaskDataUpdateParams")

        _request = build_update_process_item_task_data_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ProcessItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def patch_process_item_task_data(
        self,
        id: str,
        json_patch: List[_models.JsonPatchOperation],
        *,
        content_type: str = "application/json-patch+json",
        **kwargs: Any,
    ) -> _models.ProcessItem:
        """Patch JSON data.

        Allow to patch a JSON data validating that the data follow the related schema. If the data is
        invalid, then
        the json is marked as invalid.

        :param id: The resource ID. Required.
        :type id: str
        :param json_patch: Params to save the JSON value. Required.
        :type json_patch: list[~kuflow.rest.models.JsonPatchOperation]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json-patch+json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def patch_process_item_task_data(
        self, id: str, json_patch: IO[bytes], *, content_type: str = "application/json-patch+json", **kwargs: Any
    ) -> _models.ProcessItem:
        """Patch JSON data.

        Allow to patch a JSON data validating that the data follow the related schema. If the data is
        invalid, then
        the json is marked as invalid.

        :param id: The resource ID. Required.
        :type id: str
        :param json_patch: Params to save the JSON value. Required.
        :type json_patch: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json-patch+json".
        :paramtype content_type: str
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def patch_process_item_task_data(
        self, id: str, json_patch: Union[List[_models.JsonPatchOperation], IO[bytes]], **kwargs: Any
    ) -> _models.ProcessItem:
        """Patch JSON data.

        Allow to patch a JSON data validating that the data follow the related schema. If the data is
        invalid, then
        the json is marked as invalid.

        :param id: The resource ID. Required.
        :type id: str
        :param json_patch: Params to save the JSON value. Is either a [JsonPatchOperation] type or a
         IO[bytes] type. Required.
        :type json_patch: list[~kuflow.rest.models.JsonPatchOperation] or IO[bytes]
        :return: ProcessItem
        :rtype: ~kuflow.rest.models.ProcessItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ProcessItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json-patch+json"
        _json = None
        _content = None
        if isinstance(json_patch, (IOBase, bytes)):
            _content = json_patch
        else:
            _json = self._serialize.body(json_patch, "[JsonPatchOperation]")

        _request = build_patch_process_item_task_data_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ProcessItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def download_process_item_task_data_webforms_as_document(  # pylint: disable=name-too-long
        self, id: str, *, property_path: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Download a Form rendered as PDF or Zip of PDFs (when the element is multiple).

        Given a task, generate a PDF from a Form type element with the data filled in, if any. If there
        are multiple form values, they are packed into a ZIP.

        Important!: To use this feature, please contact to kuflow@kuflow.com.

        :param id: The resource ID. Required.
        :type id: str
        :keyword property_path: JSON pointer to the property with the error. See:
         https://datatracker.ietf.org/doc/html/rfc6901

         ie: /user/name or /users/1/name. Required.
        :paramtype property_path: str
        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_download_process_item_task_data_webforms_as_document_request(
            id=id,
            property_path=property_path,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
